if UnitFactionGroup("player")~="Alliance" then return end
local ZygorGuidesViewer=ZygorGuidesViewer
if not ZygorGuidesViewer then return end
if ZGV:DoMutex("IncludesA") then return end


--------------------------------------------------------------------------------------------------------------------------------------
-- Hearth
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("innkeeper_dwarven",[[
		goto Stormwind,64.9,31.9
		.talk Thaegra Tillstone##44235
]])

ZygorGuidesViewer:RegisterInclude("home_TradeDistrict",[[
		goto Stormwind City,60.4,75.3
		.talk Innkeeper Allison##6740F
		.home Trade District
]])

ZygorGuidesViewer:RegisterInclude("home_DwarvenDistrict",[[
		goto Stormwind City,64.9,31.9
		.talk Thaegra Tillstone##44235
		.home Dwarven District
]])

ZygorGuidesViewer:RegisterInclude("Spirt_Harmony",[[
		goto Vale of Eternal Blossoms/0 84.6,60.4
		.talk Krystel##66678
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- Portals
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("a_begin_pandaria",[[
	step
		.' In order to get to Pandaria for the first time, you must complete the opening questline to The Jade Forest.
		|confirm
	step
		goto Stormwind City 81.3,37.1
		..accept The King's Command##29547
		.' Visit Stormwind Keep |q 29547/1
	step
		goto 78.8,40.0
		.talk Rell Nightwind##55789
		..turnin The King's Command##29547
		..accept The Mission##29548
	step
		goto Eastern Kingdoms 41.46,70.19
		' Look for a ship in the air. You have to use a flying mount to get to Sky Admiral Rogers.
		.' Talk to Sky Admiral Rogers //##756
		.' Tell her:
		.' <I am ready to depart> |goto The Jade Forest 42.0,92.8 |noway |c |q 29548
	step
		goto The Jade Forest 42.0,92.8
		.' Talk to Sky Admiral Rogers //##756
		..turnin The Mission##29548
		..accept Unleash Hell##31732
	step
		goto 42.0,92.5
		.clicknpc Skyfire Gyrocopter##66473
		|invehicle |q 31732
	step
		.' Use the abilities on your bar in order to kill the enemies.
		..kill 60 Garrosh'ar Horde |q 31732/1
		..kill 8 Garrosh'ar Shredder |q 31732/2
		..kill Bladefist Reaper sunk |q 31732/3
		..kill Stygian Scar sunk |q 31732/4
	step
		goto 42.0,92.7
		.' Talk to Sky Admiral Rogers //##756
		..turnin Unleash Hell##31732
		..accept Touching Ground##31733
	step
		goto 42.3,92.8
		.click Skyfire Parachute##12345 // need correct ID
		.' Equip a Skyfire Parachute |q 31733/1
	step
		goto 43.6,90.7 //goto 41.4,79.7
		.talk Sully "The Pickle" McLeary##54616
		..turnin Touching Ground##31733
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Reputations
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("A_Cenarion_Circle_Faction",[[
	step
	label	"menu"
		.' There are several ways to earn reputation with _Cenarion Circle_.  Earning Exalted with this Faction is half of the _Achievement Guardian of Cenarius_.
		.' You can _farm mobs and bosses_ in the _Ruins of Ahn'Qiraj_.  You would need at least 1 other person to form the raid.
		.' or
		.' There are a large number of _quests_ available at _Cenarion Hold_, but once those are completed you'll need to grind your way to Exalted. Click here to go to these quests |confirm always |next "quest"
		.' or
		.' The _only repeatable quest_ as of 4.2 is from Bor Wildmane at Cenarion Hold.  You will need to _collect 10 Encrypted Twilight Text_ per _turn in_. Click here to continue |confirm always |next "farm_text"
		|next "exalted" |only if rep('Cenarion Circle')==Exalted
	step
	label	"quest"
		goto Silithus,54.9,36.0
		.talk Windcaller Proudhorn##15191
		..accept Securing the Supply Lines##8280
	step
		goto 55.0,36.0
		.' Click the Wanted Poster: Deathclasp |model 3053
		..accept Wanted - Deathclasp, Terror of the Sands##8283 |tip You must kill an elite mob for this quest, so you may need a partner if you cannot solo it.  You can skip this quest if you can't solo it and can't find a partner to help.
	step
		goto 55.5,36.8
		.talk Calandrath##15174
		.home Cenarion Hold
	step
		goto 55.4,36.3
		.talk Beetix Ficklespragg##15189
		..accept Deadly Desert Venom##8277
	step
		goto 54.5,33.0
		.talk Rifleman Torrig##17082
		..accept Report to Marshal Bluewall##9415
	step
		goto 53.2,35.1
		.talk Bor Wildmane##15306
		..accept Secret Communication##8318
	step
		goto 53.2,35.1
		.talk Huum Wildmane##15270
		..accept Twilight Geolords##8320
	step
		goto 45.4,41.3
		.from Twilight Avenger##11880+, Twilight Stonecaller##11882+
		.get 10 Encrypted Twilight Text |q 8318/1
		.collect 20 Encrypted Twilight Text##20404 |q 8323 |future |tip You need 10 extra Encrypted Twighlight Text for a future quest.
		.kill 10 Twilight Geolord##11881+ |q 8320/1
	step
		goto 46.2,34.8
		.from Sand Skitterer##11738+
		.get 8 Sand Skitterer Fang |q 8277/2
		.from Stonelash Scorpid##11735+
		.get 8 Stonelash Scorpid Stinger |q 8277/1
		.kill 15 Dredge Striker##11740+ |q 8280/1
	step
		goto 55.4,36.3
		.talk Beetix Ficklespragg##15189
		..turnin Deadly Desert Venom##8277
		..accept Noggle's Last Hope##8278
	step
		goto 54.9,36.0
		.talk Windcaller Proudhorn##15191
		..turnin Securing the Supply Lines##8280
		..accept Stepping Up Security##8281
	step
		goto 52.7,35.6
		.talk Bor Wildmane##15306
		..turnin Secret Communication##8318
	step
		goto 52.7,35.7
		.talk Huum Wildmane##15270
		..turnin Twilight Geolords##8320
		..accept Vyral the Vile##8321
	step
		goto 70.2,16.1 |n
		.' Enter the cave |goto 70.2,16.1,0.5 |noway |c |q 8321
	step
		goto 73.1,16.5
		.' Follow the path inside the cave
		.from Vyral the Vile##15202
		.get Vyral's Signet Ring |q 8321/1
	step
		goto 70.2,16.1 |n
		.' Leave the cave |goto 70.2,16.1,0.5 |noway |c |q 8321
	step
		goto 52.7,35.6
		.talk Huum Wildmane##15270
		..turnin Vyral the Vile##8321
	step
		goto 53.6,35.3
		.talk Geologist Larksbane##15183
		..accept The Twilight Mystery##8284
	step
		goto 31.0,13.6
		.click Twilight Tablet Fragments##6419
		.get 8 Twilight Tablet Fragment |q 8284/1
	step
		goto 53.6,35.3
		.talk Geologist Larksbane##15183
		..turnin The Twilight Mystery##8284
		..accept The Deserter##8285
	step
		goto 53.2,32.5
		.talk Commander Mar'alith##15181
		..accept Dearest Natalia##8304
	step
		goto 68.7,63.0
		.talk Hermit Ortell##15194
		..turnin The Deserter##8285
		..accept The Twilight Lexicon##8279
	step
		goto 39.6,47.0
		.talk Marshal Bluewall##17080
		..turnin Report to Marshal Bluewall##9415
		..accept Scouring the Desert##9419
	step
		goto 50.0,49.9
		.click Silithyst Geyser##6862
		.' Surround yourself in Silithyst Dust |havebuff Interface\Icons\Spell_Holiday_ToW_SpiceCloud |c |q 9419
		.' They spawn in various locations, you find more at:
		.' [53.2,41.6]
		.' [57.1,47.2]
		.' [60.0,41.1]
	step
		goto 39.1,46.9
		.' Stand inside the big blue-glowing metal machine
		.' Deliver Silithyst |q 9419/1
	step
		goto 39.6,47.0
		.talk Marshal Bluewall##17080
		..turnin Scouring the Desert##9419
	step
		goto 46.2,39.8
		.from Twilight Keeper Havunth##11804 |tip He walks around this area in a purple robe, so you may need to search for him.
		.get Twilight Lexicon - Chapter 3 |q 8279/3
	step
		goto 33.9,34.1
		.from Twilight Keeper Mayna##15200 |tip She walks around this area carrying a book, so you may need to search for her.
		.get Twilight Lexicon - Chapter 1 |q 8279/1
	step
		goto 44.9,48.7
		.kill 20 Dredge Crusher##11741+ |q 8281/1
		.' You can find more Dredge Crushers around [Silithus,37.9,32.4]
	step
		goto 42.8,63.5
		.from Stonelash Flayer##11737+
		.get 3 Stonelash Flayer Stinger |q 8278/1
		.from Stonelash Pincer##11736+
		.get 3 Stonelash Pincer Stinger |q 8278/2
		.from Rock Stalker##11739+
		.get 3 Rock Stalker Fang |q 8278/3
	step
		goto 54.9,36.0
		.talk Windcaller Proudhorn##15191
		..turnin Stepping Up Security##8281
	step
		goto 55.4,36.3
		.talk Beetix Ficklespragg##15189
		..turnin Noggle's Last Hope##8278
	step
		goto 55.3,36.2
		.talk Noggle Ficklespragg##15190
		..accept Noggle's Lost Satchel##8282
	step
		goto 46.0,79.4
		.talk Frankal Stonebridge##15171
		..' Tell him you've heard he might have some information as to the weareabouts of Mistress Natalia Mar'alith
		.' Question Frankal |q 8304/1
	step
		goto 46.4,79.1
		.talk Rutgar Glyphshaper##15170
		..' Tell him the Commander has sent you here to gather some information about his missing wife
		.' Question Rutgar |q 8304/2
	step
		.' Click the Complete Quest box in the top right corner of your screen
		..turnin Dearest Natalia##8304
		..accept Into The Maw of Madness##8306
	step
		goto 47.4,81.1 |n
		.' Follow the path up |goto 47.4,81.1,0.5 |noway |c |q 8306
	step
		goto 49.2,81.6
		.click Noggle's Satchel##323 |tip Be careful of Deathclasp, the elite scorpion that patrols this small area.
		.get Noggle's Satchel##20379 |q 8282/1
	step
		goto 49.5,81.3
		.from Deathclasp##15196
		.get Deathclasp's Pincer |q 8283/1 |tip Deathclasp is an elite mob, so you may need a partner if you cannot solo him.  You can skip this quest if you can't solo it and can't find a partner to help.
	step
		goto 24.8,77.3
		.from Twilight Keeper Exeter##11803
		.get Twilight Lexicon - Chapter 2 |q 8279/2
	step
		goto 55.3,36.2
		.talk Noggle Ficklespragg##15190
		..turnin Noggle's Lost Satchel##8282
	step
		goto 54.3,34.0 |n
		.' Follow the path up |goto 54.3,34.0,0.5 |noway |c |q 8283
	step
		goto 54.5,32.0
		.talk Vish Kozus##15182
		..turnin Wanted - Deathclasp, Terror of the Sands##8283
	step
		goto 46.0,79.4
		.talk Frankal Stonebridge##15171
		..accept Breaking the Code##8310
	step
		goto 46.4,79.1
		.talk Rutgar Glyphshaper##15170
		..accept Glyph Chasing##8309
	step
		goto 58.5,78.4 |n
		.' Enter the hive |goto 58.5,78.4,0.5 |noway |c |q 8309
	step
		goto 57.2,79.2 |n
		.' Follow this path |goto 57.2,79.2,0.5 |noway |c |q 8309
	step
		goto 56.4,83.0 |n
		.' Follow this path |goto 56.4,83.0,0.5 |noway |c |q 8309
	step
		goto 56.1,87.8 |n
		.' Follow this path |goto 56.1,87.8,0.5 |noway |c |q 8309
	step
		goto 55.6,90.6
		.from Mistress Natalia Mar'alith##15215
		.' Discover the Fate of Mistress Natalia Mar'alith |q 8306/1
	step
		goto 55.6,90.5
		.click the Hive'Regal Glyphed Crystal##6414
		..' <Use the transcription device to gather a rubbing.>
		.get Hive'Regal Rubbing |q 8309/1
	step
		goto 56.1,87.8 |n
		.' Follow this path |goto 56.1,87.8,0.5 |noway |c |q 8309
	step
		goto 56.4,83.0 |n
		.' Follow this path |goto 56.4,83.0,0.5 |noway |c |q 8309
	step
		goto 57.2,79.2 |n
		.' Follow this path |goto 57.2,79.2,0.5 |noway |c |q 8309
	step
		goto 58.5,78.4 |n
		.' Leave the hive |goto 58.5,78.4,0.5 |noway |c |q 8309
	step
		goto 59.3,74.8
		.from Hive'Regal Ambusher##11730+, Hive'Regal Slavemaker##11733+, Hive'Regal Spitfire##11732+, Hive'Regal Hive Lord##11734+
		.get Hive'Regal Silithid Brain |q 8310/1
		.collect 1 Brann Bronzebeard's Lost Letter##20461 |n
		.' Click Brann Bronzebeard's Lost Letter |use Brann Bronzebeard's Lost Letter##20461
		..accept Brann Bronzebeard's Lost Letter##8308
	step
		goto 65.8,76.5 |n
		.' Follow the path up |goto 65.8,76.5,0.5 |noway |c |q 8308
	step
		goto 68.7,63.0
		.talk Hermit Ortell##15194
		..turnin The Twilight Lexicon##8279
		..accept A Terrible Purpose##8287
		..accept True Believers##8323
	step
		goto 53.2,32.5
		.talk Commander Mar'alith##15181
		..turnin Into The Maw of Madness##8306
		..turnin A Terrible Purpose##8287
	step
		goto 45.4,41.3
		.from Twilight Avenger##11880+, Twilight Geolord##11881+, Twilight Stonecaller##11882+
		.get 10 Encrypted Twilight Text |q 8323/1
	step
		goto 46.0,79.4
		.talk Frankal Stonebridge##15171
		..turnin Breaking the Code##8310
	step
		goto 46.4,79.1
		.talk Rutgar Glyphshaper##15170
		..turnin Brann Bronzebeard's Lost Letter##8308
		..turnin Glyph Chasing##8309
		..accept Unraveling the Mystery##8314
	step
		goto 65.8,76.5 |n
		.' Follow the path up |goto 65.8,76.5,0.5 |noway |c |q 8314
	step
		goto 68.7,63.0
		.talk Hermit Ortell##15194
		..turnin True Believers##8323
	step
		goto 53.6,35.3
		.talk Geologist Larksbane##15183
		..turnin Unraveling the Mystery##8314
		|next "menu"
	step
	label	"farm_text"
		goto Silithus,45.6,40.1
		.from Twilight Avenger##11880+, Twilight Keeper Havunth##11804+, Twilight Stonecaller##11882+, Twilight Geolord##11881+
		.collect Encrypted Twilight Text##20404 |n
		.' More Twilight mobs can be found at [28.0,74.8]
		.' Here [69.7,16.6]
		.' Here [33.5,33.9]
		.' When you have a lot of Twilight Texts to turn in, click here |confirm
	step
		goto Silithus,53.2,35.1
		.talk Bor Wildmane##15306
		..accept Encrypted Twilight Texts##8319 |n
		.' You can click here to farm more Texts |confirm |next "farm_text"
		.' or
		.' Click here to do quests outside of Silithus for more rep |confirm
		|next "exalted" |only if rep('Cenarion Circle')==Exalted
	step
		goto Un'Goro Crater,55.7,60.6
		.talk Zen'Aliri##38269
		..accept Finding Stormclaw##24854
	step
		goto 70.8,76.4
		.talk Garl Stormclaw##38274
		..turnin Finding Stormclaw##24854
		..accept Claws of White##24719
	step
		goto 67.4,72.3
		.from Ravasaur##6505+,Ravasaur Runner##6506+,Ravasaur Hunter##6507+,Venomhide Ravasaur##6508+
		..get 5 White Ravasaur Claw |q 24719/1
		.' More can be found around [Un'Goro Crater,69.1,57.1]
	step
		goto 70.6,76.8
		.talk Garl Stormclaw##38274
		..turnin Claws of White##24719
		..accept Carried on the Waves##24686
	step
		goto 73.5,60.2
		.' While traveling to the coordinates, look in the water for Bloodpetal Seeds |modelnpc 38202
		.' Catch the Bloodpetal Seeds with Garl's Net. |use Garl's Net##50441
		.get 4 Un'Goro Lasher Seed |q 24686/1
	step
		goto 70.6,75.9
		.talk Garl Stormclaw##38274
		..turnin Carried on the Waves##24686
		..accept Flowing to the North##24689
	step
		goto 76.4,48.3
		.talk Ithis Moonwarden##38263
		..turnin Flowing to the North##24689
		..accept Bouquets of Death##24687
	step
		goto 75.8,44.1
		.' Attack the Juvenile Bloodpetals in the area.
		..kill 6 Pack of Juvenile Bloodpetal##38213+ |q 24687/1
	step
		goto 76.4,48.3
		.talk Ithis Moonwarden##38263
		..turnin Bouquets of Death##24687
		..accept Aberrant Flora##24855
	step
		goto 69.9,34.1
		.kill 11 Bloodpetal##6512+ |q 24855/1
	step
		goto 76.4,48.3
		.talk Ithis Moonwarden##38263
		..turnin Aberrant Flora##24855
	step
		goto Western Plaguelands 48.9,54.8
		.talk Adrine Towhide##44456
		..accept Zen'Kiki, the Druid##26953
	step
		goto 48.5,54.9
		.talk Selyria Groenveld##44457
		..accept I Ain't Sayin' You a Gourd-Digger...##26956
	step
		goto 47.4,52.9
		.click Unhealthy-Looking Pumpkin##6326
		.from Thrashing Pumpkin##44487+
		.' Remove 3 Unhealthy-Looking Pumpkins |q 26956/3
	step
		goto 46.8,54.1
		.click Rotten Apple##9820+
		.from Pome Wraith##44488+
		.' Remove 4 Rotten Apples |q 26956/2
	step
		goto 45.8,53.4
		.click Bad Corn##9819
		.from Corn Stalker##44489+
		.' Remove 6 Bad Corn |q 26956/1
	step
		goto 50.3,59.6
		.from Plague Lurker##1824+, Venom Mist Lurker##1822+, Diseased Wolf##1817+, Hulking Plaguebear##44482+ |tip You must do this with the Troll Zen'Kiki next to you. If you lose him, return to the Menders' Stead and talk to him.
		.' Kill 20 Wildlife with Zen'Kiki |q 26953/1
	step
		goto 48.9,54.8
		.talk Adrine Towhide##44456
		..turnin Zen'Kiki, the Druid##26953
		..accept A Different Approach##26954
	step
		goto 48.5,54.9
		.talk Selyria Groenveld##44457
		..turnin I Ain't Sayin' You a Gourd-Digger...##26956
	step
		goto 53.9,53.7
		.' Click Zen'Kiki |tip He's the Troll that's following you around.  Keep clicking him to pull the Diseased Hawks down to you.
		.kill 7 Diseased Hawk##44481 |q 26954/1
	step
		goto 48.9,54.8
		.talk Adrine Towhide##44456
		..turnin A Different Approach##26954
	step
		goto 49.3,55.0
		.talk Field Agent Kaartish##44454
		..accept A New Era for the Plaguelands##26999
	step
		goto 46.0,48.7
		.from Hulking Plaguebear##44482+
		.get 4 Hulking Plaguebear Sample |q 26999/3
		.from Diseased Wolf##1817+
		.get 4 Diseased Wolf Sample |q 26999/4
	step
		goto 57.0,62.7
		.from Plague Lurker##1824+
		.get 4 Plague Lurker Sample |q 26999/1
		.from Venom Mist Lurker##1822+
		.get 4 Venom Mist Lurker Sample |q 26999/2
	step
		goto 49.3,55.0
		.talk Field Agent Kaartish##44454
		..turnin A New Era for the Plaguelands##26999
		..accept Northridge Lumber Mill##26935
	step
		goto 48.1,32.4
		.talk Nathaniel Dumah##11616
		..turnin Northridge Lumber Mill##26935
		..accept Learning the Ropes##27000
	step
		goto 47.7,31.7
		.clicknpc Hearthglen Mustang##44836
		.' Ride the Hearthglen Mustang |invehicle |c |q 27000
	step
		goto 47.4,35.0
		.' Use your Whinny ability on your hotbar near Northridge Spiders
		.' Frighten 25 Northridge Spiders |q 27000/1
		|modelnpc Northridge Spider##44284
	step
		'Click the red arrow on your hotbar to stop riding the Hearthglen Mustang |outvehicle |c |q 27000
	step
		goto 48.1,32.4
		.talk Nathaniel Dumah##11616
		..turnin Learning the Ropes##27000
		..accept This Means WAR (Wild Arachnid Roundup)##27001
	step
		goto 47.7,31.7
		.clicknpc Hearthglen Mustang##44836
		.' Ride the Hearthglen Mustang |invehicle |c |q 27001
	step
		goto 47.0,35.3
		.' Use your Whinny ability on your hotbar near Northridge Spiders
		.' Continuously scare the Northridge Spiders and try to make them run to [48.0,32.9]
		.' The Hearthglen Recruits will kill the Northridge Spiders
		.' Lure 10 Northridge Spiders to Lumber Mill |q 27001/1
	step
		'Click the red arrow on your hotbar to stop riding the Hearthglen Mustang |outvehicle |c |q 27001
	step
		goto 48.1,32.4
		.talk Nathaniel Dumah##11616
		..turnin This Means WAR (Wild Arachnid Roundup)##27001
		..accept An Audience with the Highlord##27002
	step
		goto 42.0,14.8
		.talk Highlord Tirion Fordring##44441
		..turnin An Audience with the Highlord##27002
	step
		goto 49.3,54.9
		.talk Field Agent Kaartish##44454
		..accept Gahrron's Withering Cauldron##27053
	step
		goto 62.7,58.9
		.from Cauldron Lord Soulwrath##11078
		.get Gahrron's Withering Cauldron Key |q 27053/1
	step
		goto 62.6,58.6
		.' Click the Scourge Cauldron |tip It's a huge shaking black pot with orange liquid in it on a stone platform.
		..turnin Gahrron's Withering Cauldron##27053
		..accept Return to the Stead##27057
	step
		goto 49.3,55.0
		.talk Field Agent Kaartish##44454
		..turnin Return to the Stead##27057
	step
		goto 48.9,54.8
		.talk Adrine Towhide##44456
		..accept Zen'Kiki and the Cultists##26955
	step
		goto 66.7,48.9
		.' Click Cultist Cages |tip They look like big yellow cages around this area. |model 01787
		.' Free and Heal 4 Captive Plaguebears |q 26955/1
	step
		goto 48.9,54.8
		.talk Adrine Towhide##44456
		..turnin Zen'Kiki and the Cultists##26955
	step
		goto Eastern Plaguelands,35.6,68.9
		.talk Carlin Redpath##11063
		..accept Little Pamela##27383
	step
		goto Eastern Plaguelands,32.5,83.7
		.talk Pamela Redpath##10926
		..turnin Little Pamela##27383
		..accept Pamela's Doll##27384
	step
		goto 35.5,85.3
		.' You can find the doll parts in all of the buildings
		.click Pamela's Doll's Right Side##4233
		.collect Pamela's Doll's Right Side##12888 |q 27384
		.click Pamela's Doll's Left Side##4232
		.collect Pamela's Doll's Left Side##12887 |q 27384
		.click Pamela's Doll's Head##4231
		.collect Pamela's Doll's Head##12886 |q 27384
	step
		'Use Pamela's Doll's Head |use Pamela's Doll's Head##12886
		.get Pamela's Doll |q 27384/1
	step
		goto 32.4,83.7
		.talk Pamela Redpath##10926
		..turnin Pamela's Doll##27384
		..accept I'm Not Supposed to Tell You This##27392
	step
		goto 40.3,83.8
		.from The Lone Hunter##45450
		.get Joseph's Hunting Blade |q 27392/1
	step
		goto 32.5,83.6
		.talk Pamela Redpath##10926
		..turnin I'm Not Supposed to Tell You This##27392
		..accept Uncle Carlin##27385
	step
		goto 35.6,68.9
		.talk Carlin Redpath##11063
		..turnin Uncle Carlin##27385
		..accept A Strange Historian##27386
	step
		goto 35.3,68.1
		.talk Chromie##10667
		..turnin A Strange Historian##27386
	step
		goto Eastern Plaguelands,35.0,68.1
		.talk Urk Gagbaz##45500
		..accept Cenarion Tenacity##27544
	step
		goto 30.2,56.9
		.talk Rayne##16135
		..turnin Cenarion Tenacity##27544
		..accept Postponing the Inevitable##27420
		..accept Amidst Death, Life##27421
	step
		goto 33.7,44.4
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Western Necropolis |q 27421/2
	step
		goto 37.8,42.5
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Northeastern Necropolis |q 27421/3
	step
		goto 37.6,48.3
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Southeastern Necropolis |q 27421/1
	step
		goto 36.4,46.0
		.from Shadowmage##8550+, Dark Adept##8546+
		.collect Plague Disseminator Control Rune##61037 |n
		.' Use your Overcharged Mote when you have a Plague Disseminator Control Rune |use Overcharged Mote##61038
		.' Destroy 3 Plague Disseminators |q 27420/1
	step
		goto 30.2,56.9
		.talk Rayne##16135
		..turnin Postponing the Inevitable##27420
		..turnin Amidst Death, Life##27421
		|next "exalted" |only if rep('Cenarion Circle')==Exalted
	step
		.' This is the end of the questing
		.' Click here to go back to the Silithus Reputation menu |confirm |next "menu"
	step
	label	"exalted"
		.' Congratulations, you are Exalted with Cenarion Expedition |only if rep('Cenarion Circle')==Exalted
]])
ZygorGuidesViewer:RegisterInclude("A_Cenarion_Expedition_Faction",[[
		description This guide will take you through the quests needed to become Exalted with Cenarion Expedition
		author support@zygorguides.com
	step
		.' You will need to farm Cenarion Circle and Cenarion Expedition reputation.
		.' Farming rep in the dungeons Slave Pens and Underbog is a good way to gain reputation up to honoroed.
		.' You can also kill naga or any mobs for Unidentified Plant Parts until friendly.
		.' You can also grind reputation from Heroic Coilfang Instances up to exalted if you would rather do that.
		|confirm always
	step
		goto Hellfire Peninsula,47.8,65.8
		.from Crust Burster##16844+ |tip They are under the jumping piles of rocks, they come up to fight when you get close to the jumping rocks.
		.collect Eroded Leather Case##23338 |n
		.' Click the Eroded Leather Case |use Eroded Leather Case##23338
		..accept Missing Missive##9373
	step
		goto 15.7,52
		.talk Thiah Redmane##16991
		..turnin Missing Missive##9373
		..accept Demonic Contamination##9372
	step
		goto 24.9,54.3
		.from Hulking Helboar##16880+
		.get 6 Helboar Blood Sample |q 9372/1
	step
		goto 15.7,52
		.talk Thiah Redmane##16991
		..turnin Demonic Contamination##9372
		..accept Testing the Antidote##10255
	step
		goto 15.7,52
		.talk Mahuram Stouthoof##16888
		..accept Keep Thornfang Hill Clear!##10159
	step
		goto 25,54
		.' Use the Cenarion Antidote on a Hulking Helboar |use Cenarion Antidote##23337
		.from Dreadtusk##16992
		.' Administer the Antidote |q 10255/1
	step
		goto 15.7,52
		.talk Thiah Redmane##16991
		..turnin Testing the Antidote##10255
	step
		goto 10.1,53.2
		.kill 8 Thornfang Ravager##19349+ |q 10159/1
		.kill 8 Thornfang Venomspitter##19350+ |q 10159/2
	step
		goto Hellfire Peninsula,15.7,52
		.talk Mahuram Stouthoof##16888
		..turnin Keep Thornfang Hill Clear!##10159
	step
		goto 15.6,52.0
		.talk Tola'thion##19293
		..accept Colossal Menace##10132
	step
		goto 14.7,44.6
		.kill 5 Raging Colossus##19188+ |q 10132/1
		.collect Crimson Crystal Shard##29476 |n
		.' Click the Crimson Crystal Shard in your bags |use Crimson Crystal Shard##29476
		..accept Crimson Crystal Clue##10134
	step
		goto 15.6,52.0
		.talk Tola'thion##19293
		..turnin Colossal Menace##10132
		..turnin Crimson Crystal Clue##10134
		..accept The Earthbinder##10349
	step
		goto 16.0,51.6
		.talk Earthbinder Galandria Nightbreeze##19294
		..turnin The Earthbinder##10349
		..accept Natural Remedies##10351
	step
		goto 13.6,39.1
		.' Use your Seed of Revitalization while standing on the Earthbinder's Circle |use Seed of Revitalization##29478 |tip It's a bright green symbol on the ground.
		.from Goliathon##19305
		.' Revitalize Fallen Sky Ridge |q 10351/1
	step
		goto 16.0,51.6
		.talk Earthbinder Galandria Nightbreeze##19294
		..turnin Natural Remedies##10351
	step
		goto Zangarmarsh,80.4,64.2
		.talk Lauranna Thar'well##17909
		..accept Plants of Zangarmarsh##9802
		.talk Ikeyen##17956
		..accept The Umbrafen Tribe##9747
	step
		goto 79.1,65.3
		.talk Warden Hamoot##17858
		..accept A Warm Welcome##9728
	step
		goto 78.5,63.1
		.talk Lethyn Moonfire##17834
		..accept The Dying Balance##9895
	step
		goto 78.4,62
		.talk Ysiel Windsinger##17841
		..accept Disturbance at Umbrafen Lake##9716
	step
		goto 80.1,73.3
		'Kill all mobs in this area
		.get 10 Unidentified Plant Parts |q 9802/1
	step
		goto 81,72.2
		.kill Boglash##18281 |q 9895/1 |tip I found Boglash here. He is a tall alien looking thing with really long legs. Kill him, he's really easy, despite his elite status. He walks around in the water, so some searching may be necessary.
	step
		goto 80.4,64.2
		.talk Lauranna Thar'well##17909
		..turnin Plants of Zangarmarsh##9802
	step
		goto 78.5,63.1
		.talk Lethyn Moonfire##17834
		..turnin The Dying Balance##9895
	step
		goto 85.3,90.9
		.kill Kataru##18080 |q 9747/1 |tip In the big building, all the way at the top.
	step
		goto 83.1,85.2
		.kill 6 Umbrafen Oracle##18077+ |q 9747/2
		.kill 8 Umbrafen Seer##18079+ |q 9747/3
		.kill 6 Umbrafen Witchdoctor##20115+ |q 9747/4
	step
		goto 83.4,85.5
		.talk Kayra Longmane##17969
		..accept Escape from Umbrafen##9752
		.' Escort Kayra Longmane to safety |q 9752/1
	step
		goto 80.4,64.2
		.talk Ikeyen##17956
		..turnin The Umbrafen Tribe##9747
		..accept A Damp, Dark Place##9788
		.talk Lauranna Thar'well##17909
		..accept Saving the Sporeloks##10096
	step
		goto 80.4,64.7
		.talk Windcaller Blackhoof##18070
		..accept Safeguarding the Watchers##9894
	step
		goto 78.4,62
		.talk Ysiel Windsinger##17841
		..turnin Escape from Umbrafen##9752
	step
		goto 74.7,91.6|n
		.' The path to 'Ikeyen's Belongings' starts here |goto Zangarmarsh,74.7,91.6,0.3 |noway |c |q 9788
	step
		'Go southwest inside the cave to 70.5,97.9 |goto 70.5,97.9
		.click Ikeyen's Belongings##318
		.get Ikeyen's Belongings |q 9788/1
	step
		'Go northeast inside the cave to 72.5,94.0 |goto 72.5,94.0
		.kill Lord Klaq##18282 |q 9894/1 |tip On the bottom level of the cave, in the small round room all the way in the back.
	step
		goto 75.7,90.2
		.kill 10 Marsh Lurker##18136+ |q 10096/2
		.kill 10 Marsh Dredger##18137+ |q 10096/1
	step
		goto 70.9,82.1
		.' Stand here to Investigate Umbrafen Lake |q 9716/1
		.from Darkcrest Slaver##19946+,Darkcrest Sorceress##19947+
		.get 10 Unidentified Plant Parts|q 9802/1
		.get 30 Naga Claws|q 9728/1
		.' You can find more Naga at:
		.' [73.4,82.3]
		.' [72.2,75.8]
	step
		goto 80.4,64.7
		.talk Windcaller Blackhoof##18070
		..turnin Safeguarding the Watchers##9894
	step
		goto 80.4,64.2
		.talk Ikeyen##17956
		..turnin A Damp, Dark Place##9788
		.talk Lauranna Thar'well##17909
		..turnin Saving the Sporeloks##10096
		.' Turn in any stacks of 10 Unidentified Plant Parts you have
		.' If you found an Uncatalogued Species, turn that in also
	step
		goto 79.1,65.3
		.talk Warden Hamoot##17858
		..turnin A Warm Welcome##9728
	step
		goto 78.5,63.1
		.talk Lethyn Moonfire##17834
		..accept What's Wrong at Cenarion Thicket?##9957
	step
		goto 78.4,62
		.talk Ysiel Windsinger##17841
		..turnin Disturbance at Umbrafen Lake##9716
		..accept As the Crow Flies##9718
	step
		'Use your Stormcrow Amulet |use Stormcrow Amulet##25465
		.' Watch yourself fly as a crow.
		.' Explore the Lakes of Zangarmarsh |q 9718/1
	step
		goto 78.4,62
		.talk Ysiel Windsinger##17841
		..turnin As the Crow Flies##9718
		..accept Balance Must Be Preserved##9720
	step
		goto 80.4,64.7
		.talk Windcaller Blackhoof##18070
		..accept Blessings of the Ancients##9785
	step
		goto 78.1,63.8
		.talk Keleth##17901
		.' Get the Mark of War |q 9785/2
	step
		goto 81.1,63.9
		.talk Ashyen##17900
		.' Get the Mark of Lore |q 9785/1
	step
		goto 80.4,64.7
		.talk Windcaller Blackhoof##18070
		..turnin Blessings of the Ancients##9785
	step
		goto 70.6,80.3
		.' Use your Ironvine Seeds on the Umbrafen Lake Pump Controls |use Ironvine Seeds##24355
		.' Disable the Umbrafen Lake Pump Controls |q 9720/1 |tip The pump controls look like a little box with some levers on it
	step
		goto 63.1,64.1
		.' Use your Ironvine Seeds on the Lagoon Pump Controls |use Ironvine Seeds##24355
		.' Disable the Lagoon Pump Controls |q 9720/4 |tip The pump controls look like a little box with some levers on it
	step
		goto 62,40.8
		.' Use your Ironvine Seeds on the Serpent Lake Controls |use Ironvine Seeds##24355 |tip The pump controls look like a little box with some levers on it
		.' Disable the Serpent Lake Controls |q 9720/3
		.from Steam Pump Overseer##18340+, Bloodscale Overseer##20088+, and Bloodscale Wavecaller##20089+
		.' Get a Drain Schematics
		.' Click the Drain Schematics in your bags |use Drain Schematics##24330
		..accept Drain Schematics##9731
	step
		goto 50.4,40.8
		.' Swim straight down into the big bubbling pipe opening below until you discover the drain
		.' Locate the drain in Serpent Lake |q 9731/1
	step
		goto 25.4,42.9
		.' Use your Ironvine Seeds on the Umbrafen Lake Pump Controls |use Ironvine Seeds##24355
		.' Disable the Umbrafen Lake Pump Controls |q 9720/2 |tip The pump controls look like a little box with some levers on it
	step
		goto 78.4,62
		.talk Ysiel Windsinger##17841
		..turnin Balance Must Be Preserved##9720
		..turnin Drain Schematics##9731
		..accept Warning the Cenarion Circle##9724
	step
		goto 78.5,63.1
		.talk Lethyn Moonfire##17834
		..accept What's Wrong at Cenarion Thicket?##9957
	step
		goto Hellfire Peninsula,16,52.2
		.talk Amythiel Mistwalker##16885
		..turnin Warning the Cenarion Circle##9724
		..accept Return to the Marsh##9732
	step
		goto Zangarmarsh,78.4,62
		.talk Ysiel Windsinger##17841
		.turnin Return to the Marsh##9732
		..accept Checking Up##29566
		..accept Storming the Steamvault##29616
	step
		goto The Slave Pens 18.9,11.3
		.talk Watcher Jhang##54667
		..turnin Checking Up##29566
	step
		goto The Slave Pens 18.9,11.3
		.talk Watcher Jhang##54667
		..accept Lost in Action##29563
		..accept The Heart of the Matter##29565
	step
		goto 17.9,12.1
		.talk Nahuud##54668
		..accept A Brother Betrayed##29564
	step
		goto 25.0,51.2 |n
		.' Follow the path and go straight through this main room |goto 25.0,51.2,1 |noway |c |q 29565
	step
		goto 40.2,35.5 |n
		.' Follow this hallway |goto 40.2,35.5,0.5 |noway |c |q 29565
	step
		goto 48.8,24.3
		.' You can either stand back and pull Mennu from the ramp, or clear the enemies first so they won't aggro.
		.kill Mennu the Betrayer##17941 |q 29564/1
	step
		goto 48.9,83.4
		.talk Weeder Greenthumb##17890
		.' Discover Weeder Greenthumb |q 29563/2
	step
		goto 57.3,45.4
		.from Rokmar the Crackler##17991+
		.get The Invader's Claw |q 29565/1
	step
		goto 74.9,51.4 |n
		.' Follow this path up |goto 74.9,51.4,1 |noway |c |q 29565
	step
		goto 95.7,66.2
		.talk Naturalist Bite##17893
		.' Discover Naturalist Bite |q 29563/2
	step
		goto 95.7,66.2
		.' Be ready to fight a couple mobs
		.from Coilfang Champion##17957+, Coilfang Enchantress##17961+
		.talk Naturalist Bite##17893
		.' Tell him
		.' <Naturalist, please grant me your boon |havebuff Interface\Icons\Ability_Druid_FerociousBite |q 29565
	step
		goto The Slave Pens 86.2,67.9
		.from Quagmirran##17942+
		.get The Slave Master's Eye |q 29565/2
	step
		goto The Slave Pens 17.9,12.2
		.talk Nahuud##54668
		..turnin A Brother Betrayed##29564
	step
		goto 18.8,11.3
		.talk Watcher Jhang##54667
		..turnin Lost in Action##29563
	step
		goto The Underbog 29.5,64.7
		.talk Naturalist Bite##54678
		..accept A Necessary Evil##29568
	step
		goto 30.9,65.3
		.talk Watcher Jhang##54675
		..accept Rescuing the Expedition##29570
	step
		goto 31.5,65.5
		.talk T'shu##54674
		..accept Stalk the Stalker##29567
		..accept Bring Me A Shrubbery!##29691
	step
		'As you go through the dungeon, look for Sanguine Hibiscus
		.click Sanguine Hibiscus##5031 |q 29691
		.collect 5 Sanguine Hibiscus##24246 |n
		|confirm
	step
		goto 42.5,62.0 |n
		.' Keep following this straight path |goto 42.5,62.0,0.5 |noway |c |q 29567
	step
		goto 57.4,82.9 |n
		.' Follow this path up and around |goto 57.4,82.9,0.5 |noway |c |q 29567
	step
		goto 70.0,90.0
		.' He will summon mushrooms, these will explode to deal damage to player, and heal the boss.
		.' Keep moving him so that doesn't happen.
		.kill Hungarfen##17770 |q 29568/1
	step
		goto 77.2,43.8
		.' Follow the path around until you get here
		.from Ghaz'an##18105
		|confirm |q 29567
	step
		goto 78.9,24.5 |n
		.' Jump down in the water here  |goto 78.9,24.5,0.5 |noway |c |q 29567
	step
		goto 79.6,15.2 |n
		.' Swim across the water and jump down here |goto 79.6,15.2,0.5 |noway |c |q 29567
	step
		goto 67.4,21.3
		.talk Earthbinder Rayge##17885
		.' Discover Earthbinder Rayge |q 29570/1
	step
		goto 67.0,14.0 |n
		.' Follow this path down and to the right |goto 67.0,14.0,0.5 |noway |c |q 29567
	step
		  goto 41.5,25.4
		.from Swamplord Musel'ek##17826, Claw##17827
		.' Talk to Windcaller Claw
		.' Discover Windcaller Claw |q 29570/2
	step
		goto The Underbog 25.9,45.5
		.from The Black Stalker##17882
		.get Black Stalker's Brain |q 29567/1
	step
		'Make sure you have picked up 5 Sanguine Hibiscus
		.click Sanguine Hibiscus##5031
		.get 5 Sanguine Hibiscus##24246 |q 29691/1
	step
		goto The Underbog 29.5,64.5
		.talk Naturalist Bite##54678
		..turnin A Necessary Evil##29568
	step
		goto 30.8,65.3
		.talk Watcher Jhang##54675
		..turnin Rescuing the Expedition##29570
	step
		goto 31.6,65.5
		.talk T'shu##54674
		..turnin Stalk the Stalker##29567
		..turnin Bring Me A Shrubbery!##29691
	step
		goto The Steamvault 17.9,27.3
		.talk Watcher Jhang##54848
		..turnin Storming the Steamvault##29616
		..accept A Proper Fate##29613
	step
		goto 17.5,25.9
		.talk Naturalist Bite##54849
		..accept Containment is Key##29614
	step
		goto 18.9,27.8
		.talk Windcaller Claw##54851
		..accept Windcaller Claw and the Water Thief##29615
	step
		goto 33.7,22.7
		.kill 3 Bog Overlord##21694+|q 29614/1
	step
		goto The Steamvault 54.3,12.4
		.kill Hydromancer Thespia##17797 |q 29615/1
	step
		goto 54.2,10.6
		.click Main Chambers Access Panel##7147
		.' You hear a faint echo...
		|confirm always
	step
		goto 42.1,32.9 |n
		.' Go through the opening on your left. |goto 42.1,32.9,0.5 |noway |c |q 29613
	step
		goto 49.3,42.8 |n
		.' Go up the ramp |goto 49.3,42.8,0.5 |noway |c |q 29613
	step
		goto 55.8,47.3 |n
		.' Go up to the bridge on the right side |goto 55.8,47.3,0.25 |noway |c |q 29613
	step
		goto 39.7,69.0 |n
		.' Cross the bridge and go through the hallway |goto 39.7,69.0,0.5 |noway |c |q 29613
	step
		goto The Steamvault 33.6,81.2
		.from Mekgineer Steamrigger##17796
		.get Irradiated Gear |q 29614/3
		.kill 6 Coilfang Leper##21338+ |q 29614/2
	step
		goto 31.8,84.0
		.click Main Chambers Access Panel##7147
		.' You hear a faint echo... and You hear a loud rumble of metal grinding on stone....
		|confirm always
	step
		goto 54.0,51.4 |n
		.' Follow the tunnel back to the bridge |goto 54.0,51.4,0.5 |noway |c |q 29613
	step
		goto 69.8,43.4 |n
		.' Take a right after crossing the bridge, and go up a ramp |goto 69.8,43.4,0.5 |noway |c |q 29613
	step
		goto 78.7,43.3 |n
		.kill Warlord Kalithresh##17798 |q 29613/1
	step
		goto 49.1,42.6 |n
		.' Follow the path down to the ramp |goto 49.1,42.6,0.5 |noway |c |q 29613
	step
		goto 42.5,33.0 |n
		.' Enter this doorway |goto 42.5,33.0,0.5 |noway |c |q 29613
	step
		goto 18.8,27.6
		.talk Windcaller Claw##54851
		..turnin Windcaller Claw and the Water Thief##29615
	step
		goto 18.0,27.2
		.talk Watcher Jhang##54848
		..turnin A Proper Fate##29613
	step
		goto 17.6,25.9
		.talk Naturalist Bite##54849
		..turnin Containment is Key##29614
	step
		goto Zangarmarsh 79.1,64.8
		.click Wanted Poster##15
		..accept Leader of the Darkcrest##9730
		..accept Leader of the Bloodscale##9817
	step
		goto Zangarmarsh 65.1,68.7
		.kill Rajah Haghazed##18046 |q 9730/1
	step
		goto Zangarmarsh 65.1,40.9
		.kill Rajis Fyashe##18044 |q 9817/1
	step
		goto 79.1,65.2
		.talk Warden Hamoot##17858
		..turnin Leader of the Darkcrest##9730
		..turnin Leader of the Bloodscale##9817
	step
		goto Terokkar Forest,44.3,26.3
		.talk Earthbinder Tavgren##18446
		..turnin What's Wrong at Cenarion Thicket?##9957
		..accept Strange Energy##9968
		..accept Clues in the Thicket##9971
	step
		goto 45,22.5
		.talk Warden Treelos##18424
		..accept It's Watching You!##9951
	step
		goto 45.1,21.8
		.click Strange Object##7214
		.' Examine the Strange Object |q 9971/1 |tip Inside the building, looks like a white ball on the floor next to a dead guy.
	step
		goto 43.4,22.1
		.kill Naphthal'ar##18438 |q 9951/1 |tip At the top of the big tower.
	step
		goto 45,22.5
		.talk Warden Treelos##18424
		..turnin It's Watching You!##9951
	step
		goto 44.3,26.3
		.talk Earthbinder Tavgren##18446
		..turnin Clues in the Thicket##9971
	step
		goto 44.1,23.8
		.from Vicious Teromoth##18437+
		.get 4 Vicious Teromoth Sample |q 9968/2
	step
		goto 45.8,29.8
		.from Teromoth##18468+
		.get 4 Teromoth Sample |q 9968/1
	step
		goto 44.3,26.3
		.talk Earthbinder Tavgren##18446
		..turnin Strange Energy##9968
		..accept By Any Means Necessary##9978
	step
		goto 47.1,27
		.talk Empoor##18482
		.' Fight Empoor until he's almost dead
		..turnin By Any Means Necessary##9978
		..accept Wind Trader Lathrai##9979
	step
		goto Shattrath City,72.2,30.7
		.talk Wind Trader Lathrai##18484
		..turnin Wind Trader Lathrai##9979
		..accept A Personal Favor##10112
	step
		goto Terokkar Forest 30.9,42.0
		.from Skithian Windripper##18453+
		.from Skithian Dreadhawk##18452+
		.get 5 Lathrai's Stolen Goods |q 10112/1
	step
		goto Shattrath City 72.3,30.9
		.talk Wind Trader Lathrai##18484
		..turnin A Personal Favor##10112
		..accept Investigate Tuurem##9990
	step
		goto Terokkar Forest 54.0,30.0
		.click Sealed Box##6881
		.get Sealed Box |q 9990/1
	step
		goto 44.4,26.3
		.talk Earthbinder Tavgren##18446
		..turnin Investigate Tuurem##9990
		..accept What Are These Things?##9994
	step
		goto Terokkar Forest 57.0,53.5
		.talk Jenai Starwhisper##18459
		..turnin What Are These Things?##9994
		..accept Report to the Allerian Post##10444
	step
		goto Terokkar Forest 69.7,44.2
		.talk Lieutenant Meridian##21006
		..turnin Report to the Allerian Post##10444
		..accept Attack on Firewing Point##9996
	step
		goto 70.5,37.4
		.kill 10 Firewing Defender##5355+ |q 9996/1
		.kill 10 Firewing Bloodwarder##1410+ |q 9996/2
		.kill 10 Firewing Warlock##16769+ |q 9996/3
	step
		goto Terokkar Forest 69.7,44.2
		.talk Lieutenant Meridian##21006
		..turnin Attack on Firewing Point##9996
		..accept The Final Code##10446
	step
		goto 73.4,36.3 |n
		.' Enter this building |goto 73.4,36.3,0.5 |noway |c |q 10446
	step
		goto 73.3,34.6
		.click Orb of Translocation##7161
		.' Run up the ramp to [73.9,35.8]
		.from Sharth Voldoun##18554+
		.collect The Final Code##29912 |q 10446
	step
		goto 74.2,36.5 |n
		.click Orb of Translocation##7161
		.' Teleport to the bottom of the tower |goto 73.3,36.3,0.5 |noway |c |q 10446
	step
		goto 71.3,37.4
		.click Mana Bomb##7213
		.' Activate Mana Bomb |q 10446/1
	step
		goto Terokkar Forest 57.0,53.5
		.talk Jenai Starwhisper##18459
		..turnin The Final Code##10446
		..accept Letting Earthbinder Tavgren Know##10005
	step
		goto Terokkar Forest,44.3,26.3
		.talk Earthbinder Tavgren##18446
		..turnin Letting Earthbinder Tavgren Know##10006
	step
		goto 37.9,51.7
		.talk Lakotae##22420
		..accept The Infested Protectors##10896
	step
		goto 35.2,48.8
		.from Infested Root-walker##22095+
		.' Kill the Wood Mites that come out of their corpses
		.kill 25 Wood Mite |q 10896/1
		.' You can find more Infested Root-walkers at [39.1,47.0]
	step
		goto 37.9,51.7
		.talk Lakotae##22420
		..turnin The Infested Protectors##10896
	step
		goto Blade's Edge Mountains 62.2,39.1
		.talk Timeon##21782
		..accept Creating the Pendant##10567
	step
		goto 62.0,39.5
		.talk Tree Warden Chawn##22007
		..accept A Time for Negotiation...##10682
	step
		goto 62.5,38.2
		.talk Faradrella##22133
		..accept Culling the Wild##10753
	step
		goto 61.3,38.4
		.talk Mosswood the Ancient##22053
		..accept From the Ashes##10771
		..accept Little Embers##10770
	step
		goto 58.8,39.1
		.talk Overseer Nuaar##21981 |tip He wanders around the Wyrmcult camps.
		.' Negotiate with Overseer Nuaar |q 10682/1
	step
		goto 62,39.5
		.talk Tree Warden Chawn##22007
		..turnin A Time for Negotiation...##10682
		..accept ...and a Time for Action##10713
	step
		goto 61.8,39.6
		.talk Samia Inkling##21983
		..accept Poaching from Poachers##10717
	step
		goto 59.9,37.8
		.kill 10 Wyrmcult Hewer##21810+ |q 10713/1
		.from Wyrmcult Poacher##21809+
		.get 5 Wyrmcult Net |q 10717/1
		.collect Meeting Note##31120 |n
		.' Click the Meeting Note in your bags |use Meeting Note##31120
		..accept Did You Get The Note?##10719
	step
		goto 63.9,31.5
		.from Ruuan'ok Ravenguard##19987+, Ruuan'ok Skyfury##19986+, Ruuan'ok Cloudgazer##19985+, Ruuan'ok Matriarch##20211+
		.collect 6 Ruuan'ok Claw##30704 |q 10567
	step
		goto 64.5,33.1
		.' Use the 6 Ruuan'ok Claws inside the glowing circle |use Ruuan'ok Claw##30704
		.from Harbinger of the Raven##21767 |tip On the little island in the pond.
		.get Harbinger's Pendant##30706 |q 10567/1
	step
		goto 62.2,39.1
		.talk Timeon##21782
		..turnin Creating the Pendant##10567
		..accept Whispers of the Raven God##10607
	step
		goto 62,39.5
		.talk Samia Inkling##21983
		..turnin Poaching from Poachers##10717
	step
		goto 62.0,39.6
		.talk Tree Warden Chawn##22007
		..turnin ...and a Time for Action##10713
		..turnin Did You Get The Note?##10719
		..accept Wyrmskull Watcher##10894
	step
		goto 49.9,35.9
		.talk Watcher Moonshade##22386
		..turnin Wyrmskull Watcher##10894
		..accept Longtail is the Lynchpin##10893
	step
		goto 46.7,32.9
		.kill Draaca Longtail##22396 |q 10893/1 |tip She walks near the Raven's Wood end of the cave.
	step
		goto 49.9,35.9
		.talk Watcher Moonshade##22386
		..turnin Longtail is the Lynchpin##10893
		..accept Meeting at the Blackwing Coven##10722
	step
		goto 42.2,25.1
		.from Grishna Scorncrow##19990+, Grishna Falconwing##19988+, Grishna Harbinger##19989+
		.' Get the Understanding Ravenspeech buff |havebuff Interface\Icons\Ability_Hunter_Pet_DragonHawk |q 10722
		|tip Must be within melee range to receive the buff
		.' Anytime the buff wears off, kill Grishna mobs again to get it back
	step
		goto 40.7,18.7
		.' Stand next to the wooden totem with the Understanding Ravenspeech buff on you |tip On the ground, next to a pond with basilisks in it.
		.' Receive the Third Prophecy |q 10607/3
		|model The Third Prophecy##7249
	step
		goto 39,17.2
		.' Stand next to the wooden totem with the Understanding Ravenspeech buff on you |tip Up the left ramp, then left across the hanging bridge.
		.' Receive the First Prophecy |q 10607/1
		|model The First Prophecy##7249
	step
		goto 42.5,21.6
		.' Stand next to the wooden totem with the Understanding Ravenspeech buff on you |tip Up the right ramp, then go right across the hanging bridge, then down the stairs to the left.
		.' Receive the Second Prophecy |q 10607/2
		|model The Second Prophecy##7249
	step
		goto 40.2,23
		.' Stand next to the wooden totem with the Understanding Ravenspeech buff on you |tip On the ground, in front of a hut.
		.' Receive the Fourth Prophecy |q 10607/4
		|model The Fourth Prophecy##7249
	step
		goto 32.3,34.9
		.' Go inside the cave
		.from Wyrmcult Scout##21637+, Wyrmcult Acolyte##21383+, Wyrmcult Zealot##21382+
		.collect 5 Costume Scraps##31121 |q 10722
	step
		goto 32.6,37.5
		.' Combine your 5 Costume Scraps to make an Overseer Disguise |use Costume Scraps##31121
		.' Put on the Overseer Disguise |havebuff Interface\Icons\INV_Chest_Wolf |q 10722 |use Overseer Disguise##31122
		.talk Kolphis Darkscale##22019
		.' Attend the meeting with Kolphis Darkscale |q 10722/1
	step
		goto 62.0,39.5
		.talk Tree Warden Chawn##22007
		..turnin Meeting at the Blackwing Coven##10722
		..accept Maxnar Must Die!##10748
	step
		'Go inside the cave |goto Blade's Edge Mountains,32.1,34.1,0.3 |q 10748
	step
		goto 33.9,35.4
		.kill Maxnar the Ashmaw##21389 |q 10748/1 |tip Follow the cave path until it dead ends into him.
	step
		'Leave the cave. |goto Blade's Edge Mountains,32.1,34.1,0.3 |q 10748
	step
		goto 62,39.5
		.talk Tree Warden Chawn##22007
		..turnin Maxnar Must Die!##10748
	step
		goto 62.2,39.1
		.talk Timeon##21782
		..turnin Whispers of the Raven God##10607
	step
		goto 68.9,35.6
		.kill 4 Felsworn Scalewing##21123+ |q 10753/1
		.kill 4 Felsworn Daggermaw##21124+ |q 10753/2
		.kill 2 Fel Corrupter##21300+ |q 10753/3
		.get Damaged Mask|n
		.' Click the Damaged Mask |use Damaged Mask##31384
		..accept Damaged Mask##10810
	step
		goto 71.7,22.4
		.click Fertile Volcanic Soil##7297
		.' Plant the Ironroot Seeds |q 10771/1
	step
		goto 71.6,20.3
		.click Fertile Volcanic Soil##7297
		.' Plant the Ironroot Seeds|q 10771/2
	step
		goto 71.6,18.5
		.click Fertile Volcanic Soil##7297
		.' Plant the Ironroot Seeds |q 10771/3
	step
		goto 70.7,20.2
		.kill 8 Scorch Imp##21021+ |q 10770/1
	step
		goto 62.7,40.4
		.talk O'Mally Zapnabber##22020
		..turnin Damaged Mask##10810
		..accept Mystery Mask##10812
	step
		goto 62.2,40.1
		.talk Wildlord Antelarion##22127
		..turnin Mystery Mask##10812
		..accept Felsworn Gas Mask##10819
	step
		goto 62.6,38.2
		.talk Faradrella##22133
		..turnin Culling the Wild##10753
	step
		goto 61.2,38.4
		.talk Mosswood the Ancient##22053
		..turnin Little Embers##10770
		..turnin From the Ashes##10771
	step
		'Make sure you have your Felsworn Gas Mask in your bags |collect Felsworn Gas Mask##31366 |q 10819
		.' It has a 60 minute timer on it
		.' If you need another one, talk to Wildlord Antelarion at [62.6,39.6]
		.' Click here to continue. |confirm always
	step
		goto 73.3,40.1
		.' Use your Felsworn Gas Mask to equip it |use Felsworn Gas Mask##31366
		.' Wear the Felsworn Gas Mask |havebuff Interface\Icons\INV_Helmet_31 |c |q 10819
		.' Click the Legion Communicator |tip Between 2 big green floating crystals. You must be wearing the Felsworn Gas Mask to use the Legion Communicator
		..turnin Felsworn Gas Mask##10819
		..accept Deceive thy Enemy##10820
	step
		goto 74.9,39.9
		.kill 4 Doomforge Attendant##19961+ |q 10820/1
		.kill 4 Doomforge Engineer##19960+ |q 10820/2
	step
		goto 73.3,40.1
		.' Use your Felsworn Gas Mask to equip it |use Felsworn Gas Mask##31366
		.' Wear the Felsworn Gas Mask |havebuff Interface\Icons\INV_Helmet_31 |c |q 10819
		.' Click the Legion Communicator
		..turnin Deceive thy Enemy##10820 |tip Between 2 big green floating crystals. Click the Legion Communicator. You must be wearing the Felsworn Gas Mask to use the Legion Communicator
		..accept You're Fired!##10821
	step
		goto 73.0,41.0
		.from Anger Guard##16952+
		.collect 5 Camp Anger Key##31536 |q 10821
	step
		goto 73.5,43.5
		.' Click the Legion Obelisk to activate it |tip It's a metal structure with a floating tall metal piece in the middle of it.
		.' Click here to proceed. |confirm always |q 10821
	step
		goto 75.3,41.7
		.' Click the Legion Obelisk to activate it |tip It's a metal structure with a floating tall metal piece in the middle of it.
		.' Click here to proceed. |confirm always |q 10821
	step
		goto 73.8,41.0
		.' Click the Legion Obelisk to activate it |tip It's a metal structure with a floating tall metal piece in the middle of it.
		.' Click here to proceed. |confirm always |q 10821
	step
		goto 75.4,40.6
		.' Click the Legion Obelisk to activate it |tip It's a metal structure with a floating tall metal piece in the middle of it.
		.' Click here to proceed. |confirm always |q 10821
	step
		goto 74.0,39.9
		.' Click the Legion Obelisk to activate it |tip It's a metal structure with a floating tall metal piece in the middle of it.
		.' Click here to proceed. |confirm always |q 10821
	step
		goto 74.3,42.5
		.kill Doomcryer##19963 |q 10821/1
	step
		goto 62.4,38.4
		.talk Wildlord Antelarion##22127
		..turnin You're Fired!##10821
		..accept Death's Door##10910
	step
		goto 63.2,65.5
		.' Use your Druid Signal anywhere in Death's Door |use Druid Signal##31763
		.' Talk to Evergrove Druid
		..turnin Death's Door##10910
		..accept Harvesting the Fel Ammunition##10904
	step
		goto 63.8,66.5
		.from Death's Might##21519+, Deathforge Over-Smith##19978+, Death's Watch##21516+
		.get 5 Fel Cannonball |q 10904/1
	step
		'Use your Druid Signal anywhere in Death's Door |use Druid Signal##31763
		.' Talk to Evergrove Druid
		..turnin Harvesting the Fel Ammunition##10904
		..accept Fire At Will!##10911
	step
		goto 64.8,68.3
		.' Use your Naturalized Ammunition next to the Death's Door Fel Cannon |use Naturalized Ammunition##31807 |tip It looks like a big metal green-glowing bullet shaped machine.
		.' Use the Artillery on the Warp-Gate ability 7 times |cast Artillery on the Warp-Gate##39221
		.' Destroy the South Warp-Gate |q 10911/1
	step
		goto 62.0,60.3
		.' Use your Naturalized Ammunition next to the Death's Door Fel Cannon |use Naturalized Ammunition##31807 |tip It looks like a big metal green-glowing bullet shaped machine.
		.' Use the Artillery on the Warp-Gate ability 7 times |cast Artillery on the Warp-Gate##39221
		.' Destroy the North Warp-Gate |q 10911/2
	step
		'Use your Druid Signal anywhere in Death's Door |use Druid Signal##31763
		.' Talk to Evergrove Druid
		..turnin Fire At Will!##10911
		..accept The Hound-Master##10912
	step
		goto 63.6,59.1
		.kill Baelmon the Hound-Master##19747 |q 10912/1
	step
		goto 62.7,39.4
		.talk Wildlord Antelarion##22127
		..turnin The Hound-Master##10912
	step
		goto Netherstorm,42.3,32.6
		.talk Aurine Moonblaze##20871
		..accept Flora of the Eco-Domes##10426
	step
		goto 41.2,32.2
		.' Use Energy Field Modulator on Farahlon Lashers |use Energy Field Modulator##29818
		.from Mutated Farahlon Lasher##20774+
		.' Test Energy Modulator 10 times |q 10426/1
	step
		goto 42.3,32.6
		.talk Aurine Moonblaze##20871
		..turnin Flora of the Eco-Domes##10426
		..accept Creatures of the Eco-Domes##10427
	step
		goto 40.4,35.5
		.from Talbuk Doe##20610+, Talbuk Sire##20777
		.' Use the Talbuk Tagger on talbuks when they are below 20 percent health. |use Talbuk##29817
		.' Tag 12 Talbuk |q 10427/1
	step
		goto 42.3,32.6
		.talk Aurine Moonblaze##20871
		..turnin Creatures of the Eco-Domes##10427
		..accept When Nature Goes Too Far##10429
	step
		goto 44.3,28.5
		.from Markaru##20775+
		..get Hulking Hydra Heart |q 10429/1
	step
		goto 42.3,32.6
		.talk Aurine Moonblaze##20871
		..turnin When Nature Goes Too Far##10429
	step
		goto Borean Tundra,57,44.3
		.talk Arch Druid Lathorius##25809
		..accept A Mission Statement##11864 |instant
		..accept Ears of Our Enemies##11866
		..accept Help Those That Cannot Help Themselves##11876
	step
		goto 57.3,44.1
		.talk Hierophant Cenius##25810
		..accept Happy as a Clam##11869
	step
		goto 57,44
		.talk Killinger the Den Watcher##25812
		..accept Ned, Lord of Rhinos...##11884
	step
		goto 56.8,44
		.talk Zaza##25811
		..accept Unfit for Death##11865
	step
		goto 53.8,40.6
		.' Use your D.E.H.T.A. Trap Smasher while standing next to Trapped Mammoth Calves|use D.E.H.T.A. Trap Smasher##35228|tip They look like baby elephants laying on the ground in a trap.
		.' Free 8 Mammoth Calves |q 11876/1 |modelnpc 24613
	step
		goto 53.4,42.7
		.kill 10 Loot Crazed Diver##25836 |q 11869/1
		.kill Loot Crazed Divers|n
		.get 15 Nesingwary Lackey Ear|q 11866/1
	step
		goto 46.4,40
		.' Find and kill "Lunchbox"|kill "Lunchbox"|q 11884/2
		.kill Nedar, Lord of Rhinos##25801|q 11884/1|tip He walks around this area.  Kill 'Lunchbox' and then Nedar, Lord of Rhinos will jump off.
	step
		goto 56.2,50.5
		.' Stand inside the Caribou Traps on the ground|tip They look like metal spiked traps on the ground.
		.' Use your Pile of Fake Furs|use Pile of Fake Furs##35127
		.' Trap 8 Nesingwary Trappers |q 11865/1 |modelnpc 25835
	step
		goto 57,44.3
		.talk Arch Druid Lathorius##25809
		..turnin Ears of Our Enemies##11866
		..turnin Help Those That Cannot Help Themselves##11876
		..accept Khu'nok Will Know##11878
		.' After you turn in Ears of Our Enemies, you will get a repeatable quest called Can't Get Ear-nough...
	step
		goto 57.3,44.1
		.talk Hierophant Cenius##25810
		..turnin Happy as a Clam##11869
		..accept The Abandoned Reach##11870
	step
		goto 57,44
		.talk Killinger the Den Watcher##25812
		..turnin Ned, Lord of Rhinos...##11884
	step
		goto 56.8,44
		.talk Zaza##25811
		..turnin Unfit for Death##11865
		..accept The Culler Cometh##11868
	step
		goto 59.5,30.4
		.' Deliver the Orphaned Mammoth Calf to Khu'nok |q 11878/1
		|modelnpc Mammoth Calf##24613, Khu'nok the Behemoth##25862
	step
		goto 59.5,30.4
		.talk Khu'nok the Behemoth##25862
		..turnin Khu'nok Will Know##11878
		..accept Kaw the Mammoth Destroyer##11879
	step
		'Ride around and find a Wooly Mammoth Bull|n |modelnpc 25743
		.' Click it to ride it|invehicle|c |q 11879
	step
		goto 53.7,23.9
		.' Use the skills on your mammoth action bar to do the following:
		.from Kaw the Mammoth Destroyer##25802
		.' Click Kaw's War Halberd on the ground
		.get Kaw's War Halberd|q 11879/1
	step
		goto 57,44.3
		.talk Arch Druid Lathorius##25809
		..turnin Kaw the Mammoth Destroyer##11879
	step
		goto 57.3,56.5
		.kill 1 Karen "I Don't Caribou" the Culler##25803 |q 11868/1|tip She walks around in this spot.  Be careful, she has 2 stealthed guards that come with her.
	step
		goto 57.8,55.1
		.talk Hierophant Liandra##25838
		..turnin The Abandoned Reach##11870
		..accept Not On Our Watch##11871
	step
		goto 59.1,55.9
		.kill Northsea Thugs##25843 |n
		.' Click the Shipment of Animal Parts containers on the ground|tip They look like brown bags and crates sitting on the ground around this area.
		.get 12 Shipment of Animal Parts|q 11871/1
	step
		goto 57.8,55.1
		.talk Hierophant Liandra##25838
		..turnin Not On Our Watch##11871
		..accept The Nefarious Clam Master...##11872
	step
		goto 61.5,66.5
		.kill 1 Clam Master K##25800 |q 11872/1 |tip He's walking around underwater.
	step
		goto 57.3,44.1
		.talk Hierophant Cenius##25810
		..turnin The Nefarious Clam Master...##11872
	step
		goto 56.8,44
		.talk Zaza##25811
		..turnin The Culler Cometh##11868
	step
		goto 43.5,14
		.talk King Mrgl-Mrgl##25197
		..accept Learning to Communicate##11571
	step
		'Go underwater to 42.5,15.9 |goto 42.5,15.9
		.from Scalder##25226
		.' Use The King's Empty Conch on Scalder's corpse |use The King's Empty Conch##34598
		.get The King's Filled Conch |q 11571/1
	step
		goto 42.5,16.4
		.click Winterfin Clam##261
		.collect 5 Winterfin Clam##34597 |furure |q 11559
	step
		goto 43.5,14
		.talk King Mrgl-Mrgl##25197
		..turnin Learning to Communicate##11571
		..accept Winterfin Commerce##11559
	step
		goto 43,13.8
		.talk Ahlurglgr##25206
		..turnin Winterfin Commerce##11559
	step
		goto 41.5,13.4
		.click Winterfin Clam##261 |tip They are on the ground underwater.
		.get 5 Winterfin Clam|q 11559/1
	step
		goto 43,13.8
		.talk Ahlurglgr##25206
		..turnin Winterfin Commerce##11559
	step
		goto 42.8,13.7
		.talk Brglmurgl##25199
		..accept Them!##11561
	step
		goto 43.5,14
		.talk King Mrgl-Mrgl##25197
		..accept Oh Noes, the Tadpoles!##11560
	step
		goto 40.6,17.5
		.kill 15 Winterfin murlocs|q 11561/1
		.click the yellow cage##1787+
		.' Rescue 20 Winterfin Tadpoles |q 11560/1
		|modelnpc Winterfin Oracle##25216, Winterfin Shorestriker##25215
	step
		goto 42.8,13.7
		.talk Brglmurgl##25199
		..turnin Them!##11561
	step
		goto 43.5,14
		.talk King Mrgl-Mrgl##25197
		..turnin Oh Noes, the Tadpoles!##11560
		..accept I'm Being Blackmailed By My Cleaner##11562
	step
		goto 42,12.8
		.talk Mrmrglmr##25205
		..turnin I'm Being Blackmailed By My Cleaner##11562
		..accept Grmmurggll Mrllggrl Glrggl!!!##11563
	step
		goto 42,13.2
		.talk Cleaver Bmurglbrm##25211
		..accept Succulent Orca Stew##11564
	step
		goto 37.4,9.8
		.from Glrggl##25203
		.get Glrggl's Head|q 11563/1
	step
		goto 40.3,12.4
		.kill Glimmer Bay Orcas##25204+ |n
		.get 7 Succulent Orca Blubber|q 11564/1
	step
		goto 42,12.8
		.talk Mrmrglmr##25205
		..turnin Grmmurggll Mrllggrl Glrggl!!!##11563
		..accept The Spare Suit##11565
	step
		goto 42,13.2
		.talk Cleaver Bmurglbrm##25211
		..turnin Succulent Orca Stew##11564
	step
		goto 43.5,14
		.talk King Mrgl-Mrgl##25197
		..turnin The Spare Suit##11565
		..accept Surrender... Not!##11566
	step
		'Go southwest to Winterfin Village|n
		.' Use King Mrgl-Mrgl's Spare Suit|havebuff INV_Misc_Head_Murloc_01|use King Mrgl-Mrgl's Spare Suit##34620 |q 11566
	step
		'Go inside the cave to [37.8,23.2]|goto 37.8,23.2
		.talk Glrglrglr##28375
		..accept Keymaster Urmgrgl##11569
	step
		'Go down the path and underneath you to [38.4,22.7]|goto 38.4,22.7
		.from Keymaster Urmgrgl##25210
		.get Urmgrgl's Key|q 11569/1
	step
		'Follow the path up and to the back of the cave to [37.6,27.4]|goto 37.6,27.4
		.from Claximus##25209
		.get Claw of Claximus|q 11566/1
	step
		'Go back up the path to [37.8,23.2]|goto 37.8,23.2
		.talk Glrglrglr##28375
		..turnin Keymaster Urmgrgl##11569
	step
		goto 37.8,23
		.talk Lurgglbr##25208
		..accept Escape from the Winterfin Caverns##11570
		.' Escort Lurgglbr to safety |q 11570/1
	step
		goto 43.5,14
		.talk King Mrgl-Mrgl##25197
		..turnin Surrender... Not!##11566
		..turnin Escape from the Winterfin Caverns##11570
	step
	label "menu2"
		.' If you are not Exalted with the Cenarion Expedition, you can turn in Lackey Ears for a repeatable quest, or run Heroic Dungeons.
		.' The Heroic Dungeons are Slave Pens, Underbog and Steamvault.
		.' Click here to do the repeatable quest |confirm |next "ears"
		.' Click here to be taken to the Slave Pens |confirm |next "Zygor's Alliance Dungeon Guides\\Outland Dungeons\\Coilfang Reservoir: Slave Pens (SP) 61-65" |only if ZGV.guidesets['DungeonAMOP']
		.' Click here to be taken to the Underbog |confirm |next "Zygor's Alliance Dungeon Guides\\Outland Dungeons\\Coilfang Reservoir: Underbog (UB) 62-66" |only if ZGV.guidesets['DungeonAMOP']
		.' Click here to be taken to the Steamvault |confirm |next "Zygor's Alliance Dungeon Guides\\Outland Dungeons\\Coilfang Reservoir: The Steamvault (SV) 68-70" |only if ZGV.guidesets['DungeonAMOP']
	step
	label ears
		goto Borean Tundra 60.9,63.4
		.from Northsea Mercenary##25839+, Northsea Thug##25843+
		.collect Nesingwary Lackey Ear##35188 |n
		.' Collect Lackey Ears in stacks of 15.
		.' When you want to turn in Lackey Ears, click here. |next "turnin" |confirm
	step
	label turnin
		goto 57.1,44.3
		.talk Arch Druid Lathorius##25809
		..accept Can't Get Ear-Nough##11867 |n
		..' Click here to go back to farming ears. |next "ears" |confirm
		..' Keep repeating this quest until you are Exalted with the Cenarion Expedition |condition rep('Cenarion Expedition')==Exalted |next "exalted"
	step
	label exalted
		'Congratulations, you are now Exalted with the Cenarion Expedition!'
]])

ZygorGuidesViewer:RegisterInclude("AKaluak_rep",[[
	step
		goto Borean Tundra 54.3,36.1
		.talk Etaruk##25292
		..accept Reclaiming the Quarry##11612
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok
		..accept The Honored Ancestors##11605
		'|model Elder Atkanok##7633
	step
		goto 52.8,34
		.click "Elder Sagani"##7655
		.' Identify the Elder Sagani |q 11605/2
	step
		goto 52.3,31.2
		.click "Elder Takret"##7655
		.' Identify the Elder Takret |q 11605/3
	step
		goto 50.9,32.4
		.click "Elder Kesuk"##7655
		.' Identify the Elder Kesuk |q 11605/1
	step
		goto 54.4,35.1
		.kill 12 Beryl Treasure Hunter##25353+ |q 11612/1
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok
		..turnin The Honored Ancestors##11605
		..accept The Lost Spirits##11607
		'|model Elder Atkanok##7633
	step
		goto 54.3,36.1
		.talk Etaruk##25292
		..turnin Reclaiming the Quarry##11612
		..accept Hampering Their Escape##11617
	step
		goto 51.5,31.4
		.kill Beryl Hound##25355+ |n
		.get 6 Cores of Malice|n
		.' Use the Cores of Malice on Kaskala Craftsmen and Kaskala Shaman |use Core of Malice##34711
		.' Free 3 Kaskala Craftsman spirits |q 11607/1
		.' Free 3 Kaskala Shaman spirits |q 11607/2
		.from Beryl Reclaimer##25449+
		.collect 3 Gnomish Grenade##34772|q 11617
	step
		goto 52.2,32.1
		.' Use your Gnomish Grenade while standing under the floating platform |use Gnomish Grenade##34772 |tip If you can fly, you can stand on the floating platform and use your Gnomish Grenade.
		.' Destroy the North Platform |q 11617/2
	step
		goto 51,33.9
		.' Use your Gnomish Grenade while standing under the floating platform |use Gnomish Grenade##34772 |tip If you can fly, you can stand on the floating platform and use your Gnomish Grenade.
		.' Destroy the West Platform |q 11617/3
	step
		goto 52.8,34.5
		.' Use your Gnomish Grenade while standing under the floating platform |use Gnomish Grenade##34772 |tip If you can fly, you can stand on the floating platform and use your Gnomish Grenade.
		.' Destroy the East Platform |q 11617/1
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok
		..turnin The Lost Spirits##11607
		..accept Picking Up the Pieces##11609
		'|model Elder Atkanok##7633
	step
		goto 54.3,36.1
		.talk Etaruk##25292
		..turnin Hampering Their Escape##11617
		..accept A Visit to the Curator##11623
	step
		goto 53.1,33.3
		.click Tuskarr Ritual Object##7472+
		.get 6 Tuskarr Ritual Object|q 11609/1
	step
		goto 50.1,32.6
		.kill Curator Insivius##25448 |q 11623/1
	step
		goto 54.7,35.8
		.' Talk to Elder Atkanok
		..turnin Picking Up the Pieces##11609
		..accept Leading the Ancestors Home##11610
		'|model Elder Atkanok##7633
	step
		goto 54.3,36.1
		.talk Etaruk##25292
		..turnin A Visit to the Curator##11623
	step
		goto 52.8,34
		.' Use your Tuskarr Ritual Object while standing next to the Elder Sagani |use Tuskarr Ritual Object##34715 |tip It looks like 2 small totem pole things at the base of the big stone on the huge bone cart.
		.' Complete Elder Sagani's ceremony |q 11610/2
		|model "Elder Saganai"##7655
	step
		goto 52.3,31.2
		.' Use your Tuskarr Ritual Object while standing next to the Elder Takret |use Tuskarr Ritual Object##34715 |tip It looks like 2 small totem pole things at the base of the big stone on the huge bone cart.
		.' Complete Elder Takret's ceremony |q 11610/3
		|model "Elder Takret"##7655
	step
		goto 50.9,32.4
		.' Use your Tuskarr Ritual Object while standing next to the Elder Kesuk |use Tuskarr Ritual Object##34715 |tip It looks like 2 small totem pole things at the base of the big stone on the huge bone cart.
		.' Complete Elder Kesuk's ceremony |q 11610/1
		|model "Elder Kesuk"##7655
	step
		goto 54.7,35.8
		..' Talk to Elder Atkanok
		..turnin Leading the Ancestors Home##11610
		'|model Elder Atkanok##7633
	step
		goto 55.0,68.9
		.talk Medic Hawthorn##25825
		..accept A Soldier in Need##11789
	step
		goto 57.5,69.3
		.click First Aid Supplies##01
		.get Hawthorn's Anti-Venom |q 11789/1
	step
		goto 57.5,69.1
		.' Click the Cultist Shrine|tip It looks like a small candle shrine on the ground downstairs in this ship, next to the wall.
		..accept Cultists Among Us##11920 |or
		..accept Cultists Among Us##11790 |or
	step
		goto 55.0,68.9
		.talk Medic Hawthorn##25825
		..turnin A Soldier in Need##11789
	step
		goto 57.8,69.2
		.talk Captain "Lefty" Lugsail##25298
		..turnin Cultists Among Us##11920 |or
		..turnin Cultists Among Us##11790 |or
	step
		goto 57.8,69.2
		.talk Admiral Cantlebree##25299
		..accept Notify Arlos##11791
	step
		goto 56.7,72.6
		.talk General Arlos##25250
		..turnin Notify Arlos##11791
	step
		goto 56.7,72.6
		.talk Counselor Talbot##25301
		..accept A Diplomatic Mission##12141
	step
		goto 55,68.9
		.talk Medic Hawthorn##25825
		..turnin A Soldier in Need##11789
	step
		goto 47.1,75.5
		.talk Karuk##25435
		..turnin A Diplomatic Mission##12141
		..accept Karuk's Oath##11613
	step
		goto 46.5,77.2
		.kill 6 Skadir Raider##25522+ |q 11613/1
		.kill 5 Skadir Longboatsman##25521+ |q 11613/2
	step
		goto 44.2,77.8
		.'Kill the Riplash Myrmidon and cheering Skadir mobs
		.talk Captured Tuskarr Prisoner##25636
		..accept Cruelty of the Kvaldir##12471
	step
		goto 47.1,75.5
		.talk Karuk##25435
		..turnin Karuk's Oath##11613
		..accept Gamel the Cruel##11619
		..turnin Cruelty of the Kvaldir##12471
	step
		'Go inside the cave to 46.4,78.2|goto 46.4,78.2
		.kill Gamel the Cruel##26449 |q 11619/1
	step
		goto 47.1,75.5
		.talk Karuk##25435
		..turnin Gamel the Cruel##11619
		..accept A Father's Words##11620
	step
		goto 43.6,80.5
		.talk Veehja##25450
		..turnin A Father's Words##11620
		..accept The Trident of Naz'jan##11625
	step
		'Go into the big building to 54.7,89.1|goto 54.7,89.1
		.from Ragnar Drakkarlund##26451
		.get Trident of Naz'jan|q 11625/1
	step
		goto 43.6,80.5
		.talk Veehja##25450
		..turnin The Trident of Naz'jan##11625
		..accept The Emissary##11626
	step
		goto 52.2,88.2
		.' Swim underwater to the bubbling rock at the very bottom, so you don't run out of air
		.' Use your Trident of Naz'jan on Leviroth|use Trident of Naz'jan##35850
		.kill Leviroth##26452 |q 11626/1
	step
		goto 47.1,75.5
		.talk Karuk##25435
		..turnin The Emissary##11626
	step
		goto 63.8,46.1
		.talk Ataika##26169
		..accept Not Without a Fight!##11949
	step
		goto 64,45.7
		.talk Utaik##26213
		..accept Preparing for the Worst##11945
	step
		goto 65.3,47.2
		.kill 12 Kvaldir Raider##25760+ |q 11949/1
		.click Kaskala Supplies##644
		.get 8 Kaskala Supplies |q 11945/1
	step
		goto 63.8,46.1
		.talk Ataika##26169
		..turnin Not Without a Fight!##11949
		..accept Muahit's Wisdom##11950
	step
		goto 64,45.7
		.talk Utaik##26213
		..turnin Preparing for the Worst##11945
	step
		goto 67.2,54.9
		.talk Elder Muahit##26218
		..turnin Muahit's Wisdom##11950
		..accept Spirits Watch Over Us##11961
	step
		goto 67.6,50.4
		.talk Iruk##26219
		.' <Search corpse for Issliruk's Totem>
		.get Issliruk's Totem |q 11961/1
	step
		goto 67.2,54.9
		.talk Elder Muahit##26218
		..turnin Spirits Watch Over Us##11961
		..accept The Tides Turn##11968
	step
		goto 67.6,56.6
		.kill Heigarr the Horrible##26266 |q 11968/1
	step
		goto 67.2,54.8
		.talk Elder Muahit##26218
		..turnin The Tides Turn##11968
	step
		goto Howling Fjord,40.3,60.3
		.talk Orfus of Kamagua##23804
		..accept The Dead Rise!##11504
	step
		goto 57.7,77.5
		.' Click the Mound of Debris|tip It looks like a pile of dirt in the bottom of this small pit, next to a skeleton.
		.get Fengir's Clue|q 11504/1
	step
		goto 59.2,77
		.' Click the Unlocked Chest|tip It looks like a small chest in the bottom of this small pit, next to a skeleton.
		.get Rodin's Clue|q 11504/2
	step
		goto 59.8,79.4
		.' Click the Long Tail Feather|tip It's a small blue feather sitting on a circular shield in this pit, on top of a skeleton.
		.get Isuldof's Clue|q 11504/3
	step
		goto 62,80
		.' Click the Cannonball|tip It looks like a big round grey ball sitting in the dirt in this pit, between a skeleton's legs.
		.get Windan's Clue|q 11504/4
	step
		goto 40.3,60.3
		.talk Orfus of Kamagua##23804
		..turnin The Dead Rise!##11504
		..accept Elder Atuik and Kamagua##11507
	step
		'Go across The Ancient Lift to 25.0,57.0|goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Elder Atuik and Kamagua##11507
		..accept Grezzix Spindlesnap##11508
		..accept Feeding the Survivors##11456
	step
		goto 24.7,57.8
		.talk Kip Trawlskip##28197
		.fpath Kamagua
	step
		goto 29.1,58.8
		.kill Island Shoveltusk##24681+ |n
		.get 6 Island Shoveltusk Meat|q 11456/1
	step
		goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Feeding the Survivors##11456
		..accept Arming Kamagua##11457
	step
		goto 26.4,62.9
		.from Frostwing Chimaera##24673
		.get 3 Chimaera Horn|q 11457/1
	step
		goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Arming Kamagua##11457
		..accept Avenge Iskaal##11458
	step
		goto 23.1,62.7
		.talk Grezzix Spindlesnap##24643
		..turnin Grezzix Spindlesnap##11508
		..accept Street "Cred"##11509
	step
		goto 35.1,80.9
		.talk "Silvermoon" Harry##24539
		..turnin Street "Cred"##11509
		..accept "Scoodles"##11510
	step
		goto 35.6,80.2
		.talk Handsome Terry##24537
		..accept Forgotten Treasure##11434
	step
		goto 37.8,79.6
		.talk Scuttle Frostprow##24784
		..accept Swabbin' Soap##11469
	step
		goto 38.3,83.4
		.from "Scoodles"##24899
		.get Sin'dorei Scrying Crystal|q 11510/1
	step
		goto 37.8,84.6
		.click the Eagle Figurine##6925 |tip It's a blue eagle statue inside this ship on the middle floor.
		.get Eagle Figurine|q 11434/2
	step
		goto 37.1,85.5
		.click the Amani Vase##7495 |tip It looks like a grey vase at the bottom of this wrecked ship.
		.get Amani Vase|q 11434/1
	step
		goto 31.4,77.9
		.from Big Roy##24785
		.get Big Roy's Blubber|q 11469/1
	step
		goto 35.1,80.9
		.talk "Silvermoon" Harry##24539
		..turnin "Scoodles"##11510
		..accept The Ancient Armor of the Kvaldir##11567
		..accept The Frozen Heart of Isuldof##11512
		..accept The Lost Shield of the Aesirites##11519
		..accept The Staff of Storm's Fury##11511
	step
		goto 35.6,80.2
		.talk Handsome Terry##24537
		..turnin Forgotten Treasure##11434
		..accept The Fragrance of Money##11455
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..accept Gambling Debt##11464
	step
		goto 37.7,79.6
		.talk Scuttle Frostprow##24784
		..turnin Swabbin' Soap##11469
	step
		goto 35.1,81.0
		.talk "Silvermoon" Harry##24539
		.' Tell him:
		.' Taruk sent me to collect what you owe.>
		.from "Silvermoon" Harry##24539
		.' After he submits to you
		.' <Pay up, Harry!>
		.' Collect "Silvermoon" Harry's Debt |q 11464/1
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..turnin Gambling Debt##11464
		..accept Jack Likes His Drink##11466
	step
		goto 35.3,79.6
		.talk Olga, the Scalawag Wench##24639
		.' Tell her:
		.' <I'd like to buy Jack a drink.>
		.' She will walk over to Jack Adams
		|confirm |q 11466
	step
		goto 35.5,79.4
		.clicknpc Jack Adams##24788
		.' Discretely search the pirate's pockets for Taruk's payment.>
		.get Jack Adams' Debt |q 11466/1
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..turnin Jack Likes His Drink##11466
		..accept Dead Man's Debt##11467
	step
		goto 35.4,78.1
		.from Rabid Brown Bear##24633+
		.get 4 Bear Musk |q 11455/1
	step
		goto 33.6,75.6 |n
		.' Enter the Cave here |goto 33.6,75.6,0.5 |noway |c |q 11512
	step
		goto 33.8,78.0
		.from "Mad" Jonah Sterling##24742
		.' After you beat him, he will jump down
		|confirm |q 11512
	step
		goto 33.7,79.2 |n
		.' Run down the ramp here |goto 33.7,79.2,0.5 |noway |c |q 11512
	step
		goto 32.3,78.7
		.click The Frozen Heart of Isuldof##7554
		.get The Frozen Heart of Isuldof |q 11512/1
	step
		'Leave the cave and go to 33.2,63.9|goto 33.2,63.9
		.kill 8 Crazed Northsea Slaver##24676+ |q 11458/1
	step
		goto 37.2,74.8
		.talk Captain Ellis##24910
		..turnin The Lost Shield of the Aesirites##11519
		..accept Mutiny on the Mercy##11527
	step
		'Go downstairs in the ship
		.kill Mutinous Sea Dog##25026+ |n
		.get 5 Barrel of Blasting Powder|q 11527/1
	step
		'Go upstairs to the ship deck
		.talk Captain Ellis##24910
		..turnin Mutiny on the Mercy##11527
		..accept Sorlof's Booty##11529
	step
		'Run to the other end of the ship deck to the big cannon
		.clicknpc The Big Gun##24992
		.' Keep clicking The Big Gun until Sorlof is dead
		.' Sorlof will drop a big pile of gold on the shore
		.' Jump off the ship and click Sorlof's Booty
		.get Sorlof's Booty|q 11529/1
	step
		goto 37.2,74.8
		.talk Captain Ellis##24910
		..turnin Sorlof's Booty##11529
		..accept The Shield of the Aesirites##11530
	step
		goto 35.3,64.8
		.' At the bottom of the ship. If you are careful, you can avoid _Abdul the Insane_
		.click The Staff of Storm's Fury##1708
		.get The Staff of Storm's Fury |q 11511/1
	step
		goto 32.7,60.2
		.click Dirt Mound##20
		.from Black Conrad's Ghost##24790+
		.get Black Conrad's Treasure |q 11467/1
	step
		goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Avenge Iskaal##11458
	step
		goto 36.3,80.5
		.talk Taruk##24541
		..turnin Dead Man's Debt##11467
	step
		goto 35.6,80.2
		.talk Handsome Terry##24537
		..turnin The Fragrance of Money##11455
	step
		goto 81.8,73.9
		.click The Ancient Armor of the Kvaldir##7624
		.get The Ancient Armor of the Kvaldir |q 11567/1
	step
		'Ride the big lift to the top of the cliff and go to 40.3,60.3|goto 40.3,60.3
		.talk Orfus of Kamagua##23804
		..turnin The Ancient Armor of the Kvaldir##11567
		..turnin The Frozen Heart of Isuldof##11512
		..turnin The Shield of the Aesirites##11530
		..turnin The Staff of Storm's Fury##11511
		..accept A Return to Resting##11568
	step
		goto 57.6,77.4
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton|use Bundle of Vrykul Artifacts##34624
		.' Return the Shield of Aesirites |q 11568/1
	step
		goto 59.2,77
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton|use Bundle of Vrykul Artifacts##34624
		.' Return the Staff of Storm's Fury |q 11568/2
	step
		goto 59.8,79.4
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton.|use Bundle of Vrykul Artifacts##34624
		.' Return the Frozen Heart of Isuldof |q 11568/3
	step
		goto 62,80
		.' Use your Bundle of Vrykul Artifacts while standing near the skeleton.|use Bundle of Vrykul Artifacts##34624
		.' Return the Ancient Armor of the Kvaldir |q 11568/4
	step
		goto 40.3,60.3
		.talk Orfus of Kamagua##23804
		..turnin A Return to Resting##11568
		..accept Return to Atuik##11572
	step
		'Go across the Ancient Lift to 25.0,57.0|goto 25.0,57.0
		.talk Elder Atuik##24755
		..turnin Return to Atuik##11572
	step
		goto Dragonblight 48,74.9
		.talk Elder Ko'nani##26194
		..accept Let Nothing Go To Waste##11958
	step
		goto 48.3,74.3
		.talk Trapper Mau'i##26228
		..accept Planning for the Future##11960
	step
		goto 45.3,63.7
		.from Snowfall Glade Reaver##26197, Snowfall Glade Wolvar##26198, Snowfall Glade Shaman##26201, Snowfall Glade Den Mother##26199
		.get 6 Stolen Moa'ki Goods|q 11958/1
		.clicknpc Snowfall Glade Pup##26200
		.get 12 Snowfall Glade Pup|q 11960/1
	step
		goto 48.3,74.3
		.talk Trapper Mau'i##26228
		..turnin Planning for the Future##11960
	step
		goto 48,74.9
		.talk Elder Ko'nani##26194
		..turnin Let Nothing Go To Waste##11958
		..accept Slay Loguhn##11959
	step
		goto 46.3,59.2
		.from Loguhn##26196
		.get Blood of Loguhn|n
		.' Click the Blood of Loguhn in your bags|use Blood of Loguhn##35688
		.' Smear the Blood of Loguhn on yourself |q 11959/1
	step
		goto 48,74.9
		.talk Elder Ko'nani##26194
		..turnin Slay Loguhn##11959
	step
		goto 49.2,75.6
		.talk Toalu'u the Mystic##26595
		..accept Spiritual Insight##12028
	step
		goto 48.9,75.8
		.' Use Toalu'u's Spiritual Incense next to Toalu'u's Brazier|use Toalu'u's Spiritual Incense##35907|tip Sitting next to the entrance to the small house.
		.' Watch yourself fly as a wisp
		.' Attain Spiritual Insight concerning Indu'le Village |q 12028/1
	step
		goto 49.2,75.6
		.talk Toalu'u the Mystic##26595
		..turnin Spiritual Insight##12028
		..accept Elder Mana'loa##12030
	step
		goto Dragonblight/0 48.0,76.1
		.talk Tua'kea##26245
		..accept Tua'kea's Crab Traps##12009
	step
		goto 46.6,77.5
		.' Click Tua'kea's Crab Traps|tip They look like small cages on the ground underwater around this area.
		.get 8 Tua'kea Crab Trap|q 12009/1
	step
		goto 47.7,80
		.' Click the Wrecked Crab Trap|tip It looks like a broken version of Tue'kea's Crab Traps, on the ground underwater.
		..accept Signs of Big Watery Trouble##12011
	step
		goto Dragonblight/0 48.0,76.1
		.talk Tua'kea##26245
		..turnin Tua'kea's Crab Traps##12009
		..turnin Signs of Big Watery Trouble##12011
		..accept The Bait##12016
	step
		goto 43.7,82.3
		.from Kili'ua##26521
		.get The Flesh of "Two Huge Pincers"|q 12016/1
	step
		goto Dragonblight/0 48.0,76.1
		.talk Tua'kea##26245
		..turnin The Bait##12016
		..accept Meat on the Hook##12017
	step
		goto 46.7,78.2
		.' Use Tu'u'gwar's Bait next to Tua'kea's Fishing Hook|use Tu'u'gwar's Bait##35838|tip It looks like a rope leading into the water, with a big hook on the end.
		.' Kill Tu'u'gwar when he comes|kill 1 Tu'u'gwar|q 12017/1
	step
		goto Dragonblight/0 48.0,76.1
		.talk Tua'kea##26245
		..turnin Meat on the Hook##12017
	step
		goto 36.4,65
		'Talk to Elder Mana'loa |model Elder Mana'loa##7768
		..turnin Elder Mana'loa##12030
		..accept Freedom for the Lingering##12031
	step
		goto 37.2,65.5
		.from Indu'le Mystic##26336, Indu'le Warrior##26344
		.' Put 15 Indu'le spirits to rest |q 12031/1
	step
		goto 36.4,65
		'Talk to Elder Mana'loa |model Elder Mana'loa##7768
		..turnin Freedom for the Lingering##12031
		..accept Conversing With the Depths##12032
	step
		goto 34.3,79.8|n
		.' The path up to Conversing With the Depths starts here|goto Dragonblight,34.3,79.8,0.5|noway|c
	step
		'Follow the path up to 34,83.4|goto 34,83.4
		.' Click The Pearl of the Depths|tip It's a big white pearl sitting on a altar thing.
		.' Oacha'noa appears and tells you to jump in the water
		.' Jump in the water when he tells you to
		.' Obey Oacha'noa's compulsion |q 12032/1
	step
		goto 49.2,75.6
		.talk Toalu'u the Mystic##26595
		..turnin Conversing With the Depths##12032
	step
		.' Once you've completed all of the quests above, you can now do the daily quests.
		.' Reach exalted with The Kalu'ak |next "exalted" |only if rep("Kalu'ak")==Exalted
		|confirm |next |only if default
//borean//
	step
	label "daily"
		goto Borean Tundra,64,45.7
		.talk Utaik##26213
		..accept Preparing for the Worst##11945
	step
		.click Kaskala Supplies##644
		.get 8 Kaskala Supplies |q 11945/1
	step
		goto 64,45.7
		.talk Utaik##26213
		..turnin Preparing for the Worst##11945
//dragon//
	step
		goto Dragonblight,48.3,74.3
		.talk Trapper Mau'i##26228
		..accept Planning for the Future##11960
	step
		goto 45.3,63.7
		.clicknpc Snowfall Glade Pup##26200
		.get 12 Snowfall Glade Pup |q 11960/1
	step
		goto 48.3,74.3
		.talk Trapper Mau'i##26228
		..turnin Planning for the Future##11960
//howling//
	step
		goto Howling Fjord 24.6,58.9
		.talk Anuniaq##24810
		..accept The Way to His Heart...##11472
	step
		goto 28.9,74.8
		.' Use Anuniaq's Net on the Schools of Tasty Reef Fish|use Anuniaq's Net##40946|tip They look like swarms of fish in the water.
		.kill Great Reef Shark##24637+ |n
		.collect 10 Tasty Reef Fish##34127|q 11472
	step
		goto 31,74.4
		.' Use your Tasty Reef Fish on a Reef Bull as far away as you can|use Tasty Reef Fish##34127
		.' He will come to the spot where you're standing
		.' Keep doing this
		.' Lead the Reef Bull to a Reef Cow on the other side of the water |q 11472/1
	step
		goto 24.6,58.9
		.talk Anuniaq##24810
		..turnin The Way to His Heart...##11472
	step
		'You have reached the end of the dailies for today.
		.' To go back to the beginning of this guide, click here. |next "daily" |confirm |only if default
		.' Earn Exalted reputation with the Kalu'ak |next "exalted" |only if rep("Kalu'ak")==Exalted
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- Leveling Kalimdor
--------------------------------------------------------------------------------------------------------------------------------------

-- DUSTWALLOW MARSH --
ZygorGuidesViewer:RegisterInclude("A_Timbermaw_Faction",[[
	step
		'Routing to proper section. |next "the_grind" |only if completedq(28614)
		'Routing to proper section. |next |only if not completedq(28614)
	step
		goto Felwood,64.0,10.3
		.talk Nafien##15395
		..accept Deadwood of the North##28338
		..accept Disarming Bears##28366
	step
		goto 64.1,10.3
		.talk Ferli##48461
		..accept Stupid Drizle!##28362
	step
		goto 60.6,9.5
		.talk Drizle##47556
		.turnin Stupid Drizle!##28362
		.accept The Chieftain's Key##28364
	step
		goto 62.1,9.9
		.from Chieftain Bloodmaw##9462
		.get Drizle's Key##63695 |q 28364/1
	step
		goto 60.6,9.5
		.talk Drizle##47556
		.turnin The Chieftain's Key##28364
	step
		goto 62.0,12.8
		.from Deadwood Den Watcher##7156+, Deadwood Avenger##7157+, Deadwood Shaman##7158+
		.'Kill 15 Deadwood Furbolg |q 28338/1
		.click Deadwood Weapon Pile##10202
		.get 7 Deadwood Weapons |q 28366/1
		..collect 1 Deadwood Ritual Totem##20741 |use 1 Deadwood Ritual Totem##20741 |n
		..accept Deadwood Ritual Totem##8470
		.' You can find more around [Felwood,59.7,9.8].
	step
		goto 64.0,10.3
		.talk Nafien##15395
		..turnin Deadwood of the North##28338
		..turnin Disarming Bears##28366
		..accept Speak to Salfa##28521
		.' You should be able to turn in Feathers for Nafien, a repeatable reputation quest.
	step
		goto 64.7,5.7
		.talk Kernda##11558
		.turnin Deadwood Ritual Totem##8470
		.' You should be friendly with Timbermaw after completing this quest.
		only if rep('Timbermaw Hold')>=Neutral
	step
		goto 64.9,5.2
		.talk Meilosh##11557
		.accept Runecloth##6031
		only if rep ('Timbermaw Hold')>=Friendly
	step
		goto Winterspring,21.1,46.2
		.talk Salfa##11556
		..turnin Speak to Salfa##28521
		..accept Delivery for Donova##28524
		..accept Winterfall Activity##28522
	step
		goto 25.1,58.5
		.talk Donova Snowden##9298
		..turnin Delivery for Donova##28524
		..accept Threat of the Winterfall##28460
		..accept Falling to Corruption##28464
	step
		goto 24.5,47.6
		.' Click the Winterfall Cauldron.
		..turnin Falling to Corruption##28464
		..accept Mystery Goo##28467
	step
		goto 24.5,47.6
		  .from Winterfall Totemic##7441+, Winterfall Den Watcher##7440+, Winterfall Runner##10916+
		.'Kill 15 Winterfall Furbolg |q 28460/1
		..get 10 Winterfall Spirit Beads |q 28522/1
		.' You can find more mobs around [Winterspring,27.3,49.3].
	step
		goto 25.1,58.5
		.talk Donova Snowden##9298
		..turnin Mystery Goo##28467
		..turnin Threat of the Winterfall##28460
		..accept Winterfall Runners##28469
		..accept Scalding Signs##28530
	step
		goto 29.3,54.8
		.from Winterfall Runner##10916
		.get Winterfall Crate |q 28469/1
		.' They walk along the road so some searching may be required.
	step
		goto 32.7,50.6
		.from Scalding Springsurge##48767+,Boiling Springbubble##48768+
		.get 7 Suspicious Green Sludge |q 28530/1
	step
		goto 25.1,58.5
		.talk Donova Snowden##9298
		..turnin Winterfall Runners##28469
		..turnin Scalding Signs##28530
		..accept High Chief Winterfall##28470
		.' You should be honored with Timbermaw Hold at this point.
	step
		goto 37.0,55.6
		.kill High Chief Winterfall##10738 |q 28470/1
	step
		goto 25.1,58.5
		.talk Donova Snowden##9298
		..turnin High Chief Winterfall##28470
	step
		goto 21.1,46.2
		.talk Salfa##11556
		..turnin Winterfall Activity##28522
		.' You should now be able to do the quest More Beads for Salfa.
	step
		goto 65.3,46.2
		.talk Burndl##48722
		.accept Bearzerker##28614
	step
		 goto 65.4,46.2
		.talk Tanrir##48723
		..accept Turning the Earth##28615
	step
		goto 67.0,47.7
		' Use Tanrir's Overcharged Totem to overload Winterfall Earth Totems. |use Tanrir's Overcharged Totem##64637
		.' Overload 4 Winterfall Earth Totems |q 28615/1
		|modelnpc Winterfall Earth Totem##49177
	step
		goto 69.3,50.6
		..kill Grolnar the Berserk##49178 |q 28614/1
	step
		goto Winterspring,65.4,46.2
		.talk Tanrir##48723
		..turnin Turning the Earth##28615
	step
		goto 65.3,46.2
		.talk Burndl##48722
		..turnin Bearzerker##28614
	step
	label	"the_grind"
		.' At this point, you can do two repeatable quests, as well as grind to earn rep.
		.' More Beads for Salfa requires that you grind in Winterspring.  You collect 5 Winterfall Spirit Beads, which are worth 2,000 Reputation per turn in.  Click here to farm at the Winterspring location. |confirm |next "winterfall"
		.' or
		.' Feathers for Nafien requires that you grind in Felwood. You collect 5 Deadwood Headdress Feathers, which are worth 2,000 Reputation per turn in.  Click here to farm at the Felwood location. |confirm |next "deadwood"
		.' Collecting 65 Beads/Feathers will get you from Honored to Exalted.
	step
	label	"winterfall"
		goto 67.5,49.8
		.from Winterfall Shaman##7439+,Winterfall Ursa##7438+
		..collect Winterfall Spirit Beads##21383 |n |tip You need to collect at least 5.
		.' 5 Winterfall Spirit Beads = 2,000 Reputation. You're aiming for at least 60 to 65 Winterfall Spirit Beads in total.
		.' More can be found at [Winterspring,35.6,56.3]
		.' Click here to turn in your beads |confirm
	step
		goto 21.1,46.2
		.talk Salfa##11556
		..accept More Beads for Salfa##28523 |n
		.' Click here to go back to grinding. |next "the_grind" |only if rep('Timbermaw Hold')<=Revered |confirm
		.' or
		.' Exalted with Timbermaw Hold |next "exalted" |condition rep('Timbermaw Hold')==Exalted
	step
	label	"deadwood"
		goto Felwood,61.9,12.3
		.from Deadwood Avenger##7157+,Deadwood Den Watcher##7156+,Deadwood Shaman##7158+
		..collect Deadwood Headdress Feather##21377 |n |tip You need to collect at least 5.
		.' 5 Feather Headresses = 2,000 Reputation.  You're aiming for at least 60 to 65 Feather Headresses in total.
		.' More can be found at [Felwood,59.6,8.9]
		.' Click here to turn in your feathers |confirm |next "turnin"
	step
	label	"turnin"
		goto 64.0,10.3
		.talk Nafien##15395
		 ..accept Feathers for Nafien##28395 |n
		.' Click here to go back to grinding. |next "the_grind" |only if rep('Timbermaw Hold')<=Revered |confirm
		.' Exalted with Timbermaw Hold |next "exalted" |condition rep('Timbermaw Hold')==Exalted
	step
	label	"exalted"
		.' Congratulations, you are now Exalted with Timbermaw Hold!
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- Leveling Eastern Kingdoms
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("A_Eastern_Plaguelands_Argent_Dawn_Revered",[[
	step
		'Routing to proper section |next |only if not completedq(27527)
		'Routing to proper section |next "Annals" |only if completedq(27527)
	step
		goto Eastern Plaguelands,9.0,66.5
		.talk Fiona##45417
		..turnin Into the Woods##27683 |only if havequest(27683)
		..accept Gidwin Goldbraids##27367
		..accept Tarenar Sunstrike##27370
	step
		goto 4.1,36.0
		.talk Gidwin Goldbraids##45428
		..turnin Gidwin Goldbraids##27367
		..accept Just Encased##27368
	step
		goto 4.7,35.6 |n
		.' Enter the tunnel |goto 4.7,35.6,0.5 |noway |c |q 27368
	step
		goto 5.1,33.4
		.from Crypt Stalker##8555+,Crypt Horror##8557+, Crypt Walker##8556+, Crypt Slayer##8558+ |tip All inside this tunnel.
		.get 8 Crypt Bile |q 27368/1
	step
		goto 4.7,35.6 |n
		.' Leave the tunnel |goto 4.7,35.6,0.5 |noway |c |q 27368
	step
		goto Eastern Plaguelands,4.1,36.0
		.talk Gidwin Goldbraids##45428
		..turnin Just Encased##27368
		..accept Greasing the Wheel##27369
	step
		goto 3.4,38.0
		.click Banshee's Bell##9889+ |tip They are located right along the edge of the water
		.get 10 Banshee's Bells |q 27369/1
	step
		goto 9.0,66.5
		.talk Fiona##45417
		..turnin Greasing the Wheel##27369
	step
		goto 18.4,74.8
		.talk Tarenar Sunstrike##45429
		..turnin Tarenar Sunstrike##27370
		..accept What I Do Best##27371
	step
		goto 18.6,76.9
		.kill 5 Death's Step Miscreation##45444+ |q 27371/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin What I Do Best##27371
		..accept A Gift For Fiona##27372
	step
		goto 17.2,68.7
		.from Plaguehound Runt##8596+ |tip They share spawn locations with the Carrion Grubs.  So, if you are having trouble finding Plaguehound Runts, kill Carrion Grubs and more should spawn.
		.get 10 Plaguehound Blood |q 27372/1
		.' You can find more Plague Hound Runts around [Eastern Plaguelands,14.4,63.0].
	step
		goto 9.0,66.5
		.talk Fiona##45417
		..turnin A Gift For Fiona##27372
		..accept Onward, to Light's Hope Chapel##27373
	step
		goto 8.8,66.6
		.clicknpc Fiona's Caravan##45400
		..' Choose 1 of the 3 buffs you can choose from |tip All of the buffs only work while you're in Eastern Plaguelands.  Fiona's Lucky Charm gives you a chance to loot extra gold or items from enemies.  Gidwin's Weapon Oil gives you a chance to do extra Holy damage on melee and ranged attacks.  Tarenar's Talisman gives you a chance to do extra Holy damage on successful spell attacks.
		.' Click here to proceed. |confirm
	step
		goto 8.8,66.6
		.clicknpc Fiona's Caravan##45400
		..' Choose to go to the next destination
		.' Ride Fiona's Caravan |q 27373/1
	step
		goto 35.0,68.1
		.talk Urk Gagbaz##45500
		..accept Zaeldarr the Outcast##27432
	step
		goto 34.9,69.1
		.talk Fiona##45417
		..turnin Onward, to Light's Hope Chapel##27373
	step
		goto 35.3,68.8
		.talk Tarenar Sunstrike##45429
		..accept Traveling Companions##27381
	step
		goto 35.6,68.9
		.talk Carlin Redpath##11063
		..accept Little Pamela##27383
	step
		goto 35.9,69.3
		.' Go to the top of the tower
		.talk Argus Highbeacon##45451
		..' Ask him if he's interested in joining your caravan
		.' Find a traveling companion |q 27381/1
	step
		goto 35.9,69.3
		.talk Argus Highbeacon##45451
		..accept Rough Roads##27382
	step
		goto 35.3,68.9
		.talk Tarenar Sunstrike##45429
		..turnin Traveling Companions##27381
	step
		goto 32.4,83.7
		.talk Pamela Redpath##10926
		..turnin Little Pamela##27383
		..accept Pamela's Doll##27384
		..accept I'm Not Supposed to Tell You This##27392
	step
		goto 35.5,85.3
		.' You can find the doll parts in all of the buildings
		.click Pamela's Doll's Right Side##4233
		.collect Pamela's Doll's Right Side##12888 |q 27384
		.click Pamela's Doll's Left Side##4232
		.collect Pamela's Doll's Left Side##12887 |q 27384
		.click Pamela's Doll's Head##4231
		.collect Pamela's Doll's Head##12886 |q 27384
	step
		'Use Pamela's Doll's Head |use Pamela's Doll's Head##12886
		.get Pamela's Doll |q 27384/1
	step
		goto 40.3,83.8
		.from The Lone Hunter##45450
		.get Joseph's Hunting Blade |q 27392/1
	step
		goto 32.4,83.7
		.talk Pamela Redpath##10926
		..turnin Pamela's Doll##27384
		..turnin I'm Not Supposed to Tell You This##27392
		..accept Uncle Carlin##27385
	step
		ding 40
	step
		goto 35.6,68.9
		.talk Carlin Redpath##11063
		..turnin Uncle Carlin##27385
		..accept A Strange Historian##27386
	step
		goto 35.3,68.0
		.talk Chromie##10667
		..turnin A Strange Historian##27386
		..accept Villains of Darrowshire##27387
		..accept Heroes of Darrowshire##27388
		..accept Marauders of Darrowshire##27389
	step
		goto 35.0,68.1
		.talk Urk Gagbaz##45500
		..accept Cenarion Tenacity##27544
	step
		goto 35.6,68.9
		.talk Carlin Redpath##11063
		..' Ask him if he has the extended Annals of Darrowshire
		.get Extended Annals of Darrowshire |q 27388/1
	step
		goto 39.8,72.4
		.click Shattered Sword of Marduk##4175
		.get Shattered Sword of Marduk |q 27387/2
	step
		goto 39.6,72.1
		.kill 13 Plaguebat##8600+ |q 27382/1
	step
		goto 35.6,68.7
		.' Go to the top of the tower
		.talk Argus Highbeacon##45451
		..turnin Rough Roads##27382
	step
		goto 24.2,78.5 |n
		.' Enter the crypt |goto 24.2,78.5,0.5 |noway |c |q 27432
	step
		goto 23.8,77.9
		.' Go to the bottom of the crypt
		.from Zaeldarr the Outcast##12250
		.get Zaeldarr's Head |q 27432/1
	step
		goto 22.1,68.2
		.click Redpath's Shield##4172
		.get Redpath's Shield |q 27388/3
	step
		goto 22.3,68.3
		.' Go upstairs
		.click Davil's Libram##430
		.get Davil's Libram |q 27388/2
	step
		goto 35.0,68.2
		.talk Urk Gagbaz##45500
		..turnin Zaeldarr the Outcast##27432
	step
		goto 35.2,68.1
		.talk Chromie##10667
		..turnin Heroes of Darrowshire##27388
	step
		goto 37.3,60.2
		.click Horgus' Skull##4173
		.get Skull of Horgus |q 27387/1
	step
		goto 30.2,56.9
		.talk Rayne##16135
		..turnin Cenarion Tenacity##27544
		..accept Postponing the Inevitable##27420
		..accept Amidst Death, Life##27421
	step
		goto 33.7,44.4
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Western Necropolis |q 27421/2
	step
		goto 37.8,42.5
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Northeastern Necropolis |q 27421/3
	step
		goto 37.6,48.3
		.' Go inside the necropolis
		.' Use Rayne's Seeds while standing on the platform above the green liquid |use Rayne's Seeds##61036
		.' Plant a Seed in the Southeastern Necropolis |q 27421/1
	step
		goto 36.4,46.0
		.from Scourge Champion##8529+
		.collect Fetid Skull##13157 |n
		.' Use your Mystic Crystal when you have a Fetid Skull |use Mystic Crystal##13156
		.get 5 Resonating Skull |q 27389/1
		.from Shadowmage##8550+, Dark Adept##8546+
		.collect Plague Disseminator Control Rune##61037 |n
		.' Use your Overcharged Mote when you have a Plague Disseminator Control Rune |use Overcharged Mote##61038
		.' Destroy 3 Plague Disseminators |q 27420/1
	step
		goto 30.2,56.9
		.talk Rayne##16135
		..turnin Postponing the Inevitable##27420
		..turnin Amidst Death, Life##27421
	step
		goto 35.3,68.1
		.talk Chromie##10667
		..turnin Villains of Darrowshire##27387
		..turnin Marauders of Darrowshire##27389
		..accept The Battle of Darrowshire##27390
	step
		goto 35.1,84.0
		.' Use your Relic Bundle |use Relic Bundle##15209
		.' Fight in the battle and follow the instructions that appear on your screen
		.from Redpath the Corrupted##10938
		.' Joseph Redpath will appear after the battle at [Eastern Plaguelands,35.1,84.0]
		.talk Joseph Redpath##10936
		.' Accept Redpath's Forgiveness |q 27390/1
	step
		goto 32.4,83.7
		.talk Pamela Redpath##10926
		..turnin The Battle of Darrowshire##27390
		..accept Hidden Treasures##27391
	step
		goto 32.2,83.4
		.click Joseph's Chest##318
		..turnin Hidden Treasures##27391
	step
		goto 34.9,69.2
		.talk Fiona##45417
		..accept The Trek Continues##27448
	step
		goto 35.0,69.3
		.clicknpc Fiona's Caravan##45400
		..' Choose to go to the next destination
		.' Ride in Fiona's Caravan |q 27448/1
	step
		goto 52.9,53.1
		.talk Fiona##45417
		..turnin The Trek Continues##27448
		..accept Boys Will Be Boys##27455
	step
		goto 53.0,53.1
		.clicknpc Fiona's Caravan##45400
		.' Complete the Argus' Journal quest |tip This will give you a 2% experience bonus while in Eastern Plaguelands, so will allow you to level faster.  // %
		|confirm
	step
		goto 53.2,54.6
		.talk Betina Bigglezink##11035
		..accept To Kill With Purpose##27451
		..accept Dark Garb##27452
	step
		goto 53.8,54.0
		.' Go to the top of the tower
		.talk Frederick Calston##45575
		..accept Frederick's Fish Fancy##27450
	step
		goto 52.8,51.4
		.talk Vex'tul##45574
		..accept Honor and Strength##27449
		.kill 3 Mossflayer Rogue##45579+ |q 27449/1
	step
		goto 52.8,51.4
		.talk Vex'tul##45574
		..turnin Honor and Strength##27449
	step
		ding 41
	step
		goto 50.2,61.3
		.clicknpc Plague Puffer##45650+
		.get 8 Plague Puffer |q 27450/1
		.clicknpc Infectis Incher##45655+
		.get 8 Infectis Incher |q 27450/2
		.clicknpc Infectis Scuttler##45657+
		.get 8 Infectis Scuttler |q 27450/3
	step
		goto 53.7,62.3
		.from Unseen Servant##8538+, Stitched Horror##8543+, Hate Shrieker##8541+, Dark Caster##8526+, Scourge Warder##8525+, Gibbering Ghoul##8531+
		.collect 7 Living Rot##15447 |n |tip These only last 10 minutes, so keep an eye on the timer and try to get them as fast as you can.
		.' Use Mortar and Pestle once you have 7 Living Rot |use Mortar and Pestle##15454
		.get Coagulated Rot |q 27451/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin To Kill With Purpose##27451
	step
		goto 55.7,61.0
		.from Dark Summoner##8551+, Vile Tutor##8548+
		.get Death Cultist Headwear |q 27452/1
		.get Death Cultist Robes |q 27452/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Dark Garb##27452
		..accept Catalysm##27453
	step
		goto 57.6,72.6
		.' Use Betina's Flasks on Plague Ravagers and Blighted Surges underwater |use Betina's Flasks##61284
		.get 8 Active Liquid Plague Agent |q 27453/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Catalysm##27453
		..accept Just a Drop in the Bucket##27454
	step
		goto 61.7,75.5
		.' Use your Death Cultist Disguise |use Death Cultist Disguise##61283
		.' Wear your Death Cultist Disguise |havebuff INTERFACE\ICONS\inv_helmet_152 |q 27454
	step
		goto 62.4,76.4
		.click Mereldar Plague Cauldron##4331
		..' Choose to throw in an entire flask
		.' Disturb the Mereldar Plague Cauldron |q 27454/1
	step
		goto 53.2,54.6
		.talk Betina Bigglezink##11035
		..turnin Just a Drop in the Bucket##27454
	step
		goto 53.8,54.0
		.' Go to the top of the tower
		.talk Frederick Calston##45575
		..turnin Frederick's Fish Fancy##27450
	step
		goto 74.4,53.3
		.talk Gidwin Goldbraids##45431
		..turnin Boys Will Be Boys##27455
		..accept A Boyhood Dream##27463
	step
		goto 73.8,51.9
		.talk Rimblat Earthshatter##16134
		..accept Gathering Some Grub(s)##27456
	step
		goto 74.9,53.5
		.talk Smokey LaRue##11033
		..accept Smokey and the Bandage##27458
	step
		goto 75.6,52.4
		.talk Jessica Chambers##16256
		.home Light's Hope Chapel
	step
		goto 75.6,52.0
		.talk Leonid Barthalomew the Revered##11036
		..accept The Brotherhood of Light##27459
	step
		goto 75.9,52.0
		.talk Lord Maxwell Tyrosus##11034
		..turnin A Boyhood Dream##27463
		..accept Argent Call: The Trial of the Crypt##27464
	step
		goto 77.2,50.8 |n
		.' Enter the crypt |goto 77.2,50.8,0.5 |noway |c |q 27464
	step
		goto 77.2,51.4
		.' Go to the bottom of the crypt
		.' Use your Argent Scroll |use Argent Scroll##61309
		.from Argent Warden##45698+
		.from Lord Raymond George##45707
		.' Complete the Trial of the Crypt |q 27464/1
	step
		goto 75.9,52.0
		.talk Lord Maxwell Tyrosus##11034
		..turnin Argent Call: The Trial of the Crypt##27464
		..accept Argent Call: The Noxious Glade##27465
	step
		goto 75.7,52.0
		.talk Master Craftsman Omarion##16365
		..accept Buried Blades##27467
	step
		goto 71.9,45.4
		.from Stephen Browman##46167
		.get Browman's Wrappings |q 27458/1
	step
		goto 72.1,41.6 |n
		.' Run up this path |goto 72.1,41.6,0.5 |noway |c |q 27458
	step
		goto 77.4,37.3
		.kill 16 Noxious Glade Scourge |q 27465/1
		.kill 8 Noxious Glade Cultists |q 27465/2
		.clicknpc Slain Scourge Trooper##45695+
		.' Bury 10 Blades |q 27467/1
		' |from Diseased Flayer##8532+, Dread Weaver##8528+, Death Singer##8542+
		' |from Skullmage##45691+, Noxious Assassin##45692+
		|tip Be careful of the patrolling elite, Garginox, in this area.
		|modelnpc Garginox##45681
	step
		goto 75.7,52.0
		.talk Master Craftsman Omarion##16365
		..turnin Buried Blades##27467
	step
		goto 75.9,52.0
		.talk Lord Maxwell Tyrosus##11034
		..turnin Argent Call: The Noxious Glade##27465
	step
		goto 74.9,53.5
		.talk Smokey LaRue##11033
		..turnin Smokey and the Bandage##27458
	step
		goto 71.1,60.6
		.from Carrion Grub##8603+, Carrion Devourer##8605+
		.get 15 Slab of Carrion Worm Meat |q 27456/1
	step
		goto 72.6,74.8
		.talk Archmage Angela Dosantos##16116
		..turnin The Brotherhood of Light##27459
		..accept Soft Landing##27460
	step
		goto 73.6,74.8
		.kill 10 Tyr's Hand Scarlet Crusader |q 27460/1
		' |from Scarlet Enchanter##9452+, Scarlet Warder##9447+, Scarlet Cleric##9449+
	step
		goto 77.6,79.4
		.click Crusader's Flare##6543
		..turnin Soft Landing##27460
		..accept To Take the Abbey##27461
		..accept To Take the Barracks##27462
	step
		goto 75.3,76.2
		.talk Crusade Commander Korfax##16112
		..turnin To Take the Barracks##27462
		..accept Scarlet Salvage##27614
		..accept The Wrathcaster##27615
		..accept The Huntsman##27616
		..accept The Commander##27619
	step
		ding 42
	step
		goto 74.8,76.7
		.click Battered Chest##10
		.get Crimson Boar |q 27614/1
	step
		goto 74.2,78.3
		.click Battered Chest##10
		.get Lihanna's Strand |q 27614/2
	step
		goto 75.1,79.0
		.click Battered Chest##10
		.get Shroud of Uther |q 27614/3
	step
		goto 75.9,77.5
		.click Battered Chest##10
		.get Gavinrad's Sigil |q 27614/4
	step
		goto 75.0,78.3
		.' Go into the basement of the fortress
		.kill Mataus the Wrathcaster##46093 |q 27615/1
	step
		goto 74.9,78.3
		.' Go upstairs into the main room of the fortress
		.kill Scarlet Commander Marjhan##46092 |q 27619/1
	step
		goto 74.5,77.5
		.' Go down the hall and up more stairs
		.kill Huntsman Leopold##46094 |q 27616/1
	step
		goto 75.3,76.2
		.talk Crusade Commander Korfax##16112
		..turnin Scarlet Salvage##27614
		..turnin The Wrathcaster##27615
		..turnin The Huntsman##27616
		..turnin The Commander##27619
		..accept Argent Upheaval##27618
	step
		goto 76.1,75.3
		.talk Archmage Angela Dosantos##16116
		..turnin Argent Upheaval##27618
	step
		goto 76.7,73.1
		.talk Crusade Commander Eligor Dawnbringer##16115
		..turnin To Take the Abbey##27461
		..accept Victory From Within##27612
		..accept The Assassin##27613
	step
		goto 77.8,71.0
		.' Click the Argent Portal |tip It looks like a swirling portal in a room on the north side of the building.  Follow the stairs up in the Library Wing, not the big spiral stairs in the middle of the building.
		.' Open the Portal within the Library Wing |q 27612/2
	step
		goto 78.6,72.9
		.' Click the Argent Portal |tip It looks like a swirling portal in a room on the west side of the building.
		.' Open the Portal within the Hall of Arms |q 27612/1
	step
		goto 77.6,72.7
		.' Follow the big spiral stairs up to the top of the bell tower
		.kill Rohan the Assassin##46095 |q 27613/1
	step
		goto 76.7,73.1
		.talk Crusade Commander Eligor Dawnbringer##16115
		..turnin Victory From Within##27612
		..turnin The Assassin##27613
		..accept Befouled No More##27617
	step
		goto 76.1,75.3
		.talk Archmage Angela Dosantos##16116
		..turnin Befouled No More##27617
		..accept Like Rats##27620
	step
		goto 82.3,79.4
		.kill Crusader Lord Valdelmar##46096 |q 27620/1
	step
		goto 75.6,52.0
		.talk Leonid Barthalomew the Revered##11036
		..turnin Like Rats##27620
	step
		 goto Eastern Plaguelands,75.8,52.4
		.talk Tarenar Sunstrike##45729
		..accept Argent Call: Northdale##27466
	step
		goto 73.8,51.9
		.talk Rimblat Earthshatter##16134
		..turnin Gathering Some Grub(s)##27456
		..accept An Opportune Alliance##27457
	step
		goto 61.8,41.0
		.talk Vex'tul##45574
		..accept Out of the Ziggurat##27481
	step
		goto 61.0,43.7
		.talk Deacon Andaal##45736
		..accept Righteous Indignation##27479
	step
		goto 61.6,43.1
		.talk Gamella Cracklefizz##45735
		..accept The Corpulent One##27477
	step
		goto 61.5,42.7
		.talk Fiona##45417
		..turnin An Opportune Alliance##27457
		..turnin Argent Call: Northdale##27466
	step
		goto 61.6,43.2
		.talk Tarenar Sunstrike##45729
		..accept Ix'lar the Underlord##27487
	step
		goto 61.8,35.7
		.kill Ix'lar the Underlord##45744 |q 27487/1 |tip He's a big purple bug that walks around this area, so you may need to search for him.
		.kill 10 Ix'lar's minion |q 27487/2
		' |from Scourge Guard##8527+, Gangled Golem##8544+, Nerubian Sycophant##45743+
	step
		goto 56.7,27.9
		.kill Borelgore##11896 |q 27477/1 |tip He's a huge yellow grub that walks along in this big trench.
	step
		goto 58.9,20.4 |n
		.' Run up this path |goto 58.9,20.4,0.5 |noway |c |q 27479
	step
		goto 66.8,9.9
		.' Don't walk over the dirt piles on the ground, they spawn more enemies
		.from Warlord Thresh'jin##10822 |tip Don't worry that he's elite, you can kill him easily
		.get Body of Warlord Thresh'jin |q 27481/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Out of the Ziggurat##27481
		..accept Into the Flames##27482
	step
		goto 67.4,9.0
		.' Use the Body of Warlordw Thresh'jin next to the Bonfire at the top of the temple |use Body of Warlord Thresh'jin##61316
		.' Burn Warlord Thresh'jin's Body |q 27482/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Into the Flames##27482
	step
		goto 64.5,13.7
		.' Don't walk over the dirt piles on the ground, they spawn more enemies
		.from Mossflayer Cannibal##8562+, Mossflayer Scout##8560+, Mossflayer Shadowhunter##8561+, Infected Mossflayer##12261+
		.get 30 Mossflayer Eye |q 27479/1
	step
		goto 61.3,44.5
		.talk Deacon Andaal##45736
		..turnin Righteous Indignation##27479
	step
		goto 61.6,43.1
		.talk Gamella Cracklefizz##45735
		..turnin The Corpulent One##27477
	step
		goto 61.5,42.7
		.talk Fiona##45417
		..turnin Ix'lar the Underlord##27487
	step
		goto 61.6,43.2
		.talk Tarenar Sunstrike##45729
		..accept Impatience##27488
	step
		goto 65.5,24.4
		.click Open Prayer Book##254
		.get Gidwin's Prayer Book |q 27488/1
	step
		goto 61.6,43.2
		.talk Tarenar Sunstrike##45729
		..turnin Impatience##27488
		..accept Nobody to Blame but Myself##27489
	step
		goto 61.6,42.5
		.clicknpc Fiona's Caravan##45400
		..' Choose to go to the next destination
		.' Ride Fiona's Caravan to Northpass Tower |q 27489/1
	step
		goto 50.4,20.1
		.talk Tarenar Sunstrike##45729
		..turnin Nobody to Blame but Myself##27489
		..accept Beat it Out of Them##27522
	step
		goto 50.0,19.5
		.talk Kirkian Dawnshield##45826
		..accept Wretched Hive of Scum and Villainy##27521
	step
		goto 54.6,19.1
		.from Scourge Siege Engineer##17878+
		.' Beat 6 Scourge Siege Engineers |q 27522/1
		.' Discover Gidwin's Location |q 27522/2
		.' Discover Gidwin's Captor |q 27522/3
	step
		goto 47.0,17.4
		.kill 9 Quel'lithien Wretched |q 27521/1
		' |from Wretched Pathstrider##8565+, Wretched Woodsman##8563+, Wretched Ranger##8564+
	step
		goto 48.0,23.0
		.talk Corpseburner Tim##45816
		..accept Duskwing, Oh How I Hate Thee...##27523
	step
		goto 46.4,33.8
		.' Use The Corpseburner's Flare in this spot |use The Corpseburner's Flare##61334 |tip If you get a message that there are no valid targets, wait until Duskwing spawns.  He's a big gray bat that flies in the sky around this area.
		.from Duskwing##11897
		.get Patch of Duskwing's Fur |q 27523/1
	step
		goto 48.0,23.0
		.talk Corpseburner Tim##45816
		..turnin Duskwing, Oh How I Hate Thee...##27523
	step
		goto 50.5,20.2
		.talk Fiona##45417
		..turnin Beat it Out of Them##27522
		..accept Blind Fury##27524
	step
		goto 50.5,20.2
		.talk Argus Highbeacon##45451
		..accept The Plaguewood Tower##27532
	step
		goto 50.0,19.5
		.talk Kirkian Dawnshield##45826
		..turnin Wretched Hive of Scum and Villainy##27521
	step
		goto 27.6,21.2
		.talk Tarenar Sunstrike##45729
		..turnin Blind Fury##27524
		..accept Guardians of Stratholme##27525
	step
		goto 27.6,20.9
		.talk Crusader Kevin Frost##45831
		..accept Scourged Mass##27528
		..accept Defenders of Darrowshire##27529
		..accept Add 'em to the Pile##27539
	step
		goto 29.4,19.7
		.kill Karthis Darkrune##45868 |q 27525/2
		.collect The Baroness' Missive##61378 |n
		.' Click The Baroness' Missive in your bags |use The Baroness' Missive##61378
		..accept The Baroness' Missive##27551
	step
		goto 27.4,21.3
		.talk Tarenar Sunstrike##45729
		..turnin The Baroness' Missive##27551
		..accept Gidwin's Fate Revealed##27526
	step
		goto 29.1,26.2
		.' Enter this building and watch the cutscene
		.' Find Gidwin Goldbraids |q 27526/1
	step
		goto 28.4,25.9
		.talk Gidwin Goldbraids##45730
		..turnin Gidwin's Fate Revealed##27526
		..accept Journey's End##27527
	step
		goto 25.4,19.8
		.kill Omasum Blighthoof##45867 |q 27525/1
	step
		goto 31.4,20.3
		.' All around Plaguewood, do the following:
		.from Overstuffed Golem##45851+
		.' Use your Crusader's Torch on their corpses |use Crusader's Torch##61369
		.' Burn 8 Overstuffed Golem Corpses |q 27528/1
		.from Cursed Mage##8524+, Scourge Soldier##8523+
		.get 16 Stinking Skull |q 27539/1
		.from Cannibal Ghoul##8530+
		.talk Darrowshire Spirit##11064 |tip They spawn after you kill Cannibal Ghouls.
		.' Free 8 Darrowshire Spirits |q 27529/1
	step
		goto 28.5,25.9
		.talk Tarenar Sunstrike##45729
		..turnin Guardians of Stratholme##27525
	step
		goto 27.6,20.9
		.talk Crusader Kevin Frost##45831
		..turnin Scourged Mass##27528
		..turnin Defenders of Darrowshire##27529
		..turnin Add 'em to the Pile##27539
		..accept The Corpsebeasts##27530
	step
		ding 44
	step
		goto 28.3,32.3
		.' Use your Argent Lightwell Charm next to the big brown monster corpses |use Argent Lightwell Charm##61375 |tip You will have to put 3 around each corpse, and you can't put them too close together.
		.' Destroy 3 Corpsebeasts |q 27530/1
	step
		goto 27.6,20.9
		.talk Crusader Kevin Frost##45831
		..turnin The Corpsebeasts##27530
	step
		goto 17.7,28.0
		.talk Argent Apothecary Judkins##45828
		..turnin The Plaguewood Tower##27532
		..accept Counter-Plague Research##27531
		..accept Just a Little Touched##27535
	step
		goto 25.1,34.5
		.click Flesh Giant Foot##8077
		.get Flesh Giant Foot Scrapings |q 27531/3
	step
		goto 23.5,22.4
		.' Lying on the ground all around this area:
		.click Rotberry Bush##28+
		.get 20 Rotberry |q 27531/1
		.click Disembodied Arm##8373+
		.get 5 Disembodied Arm |q 27531/2
	step
		goto 17.7,28.0
		.talk Argent Apothecary Judkins##45828
		..turnin Counter-Plague Research##27531
	step
		goto 11.3,28.6
		.talk Augustus the Touched##12384
		..turnin Just a Little Touched##27535
		..accept A Fate Worse Than Butchery##27533
		..accept Augustus' Receipt Book##27534
	step
		goto 14.2,26.3
		.click Augustus' Receipt Book##4872
		|tip The Receipt Book is upstairs in the far room.
		.get Augustus' Receipt Book |q 27534/1
	step
		goto 14.4,28.5
		.kill 9 Plagued Swine##16117+ |q 27533/1
	step
		goto 11.3,28.6
		.talk Augustus the Touched##12384
		..turnin A Fate Worse Than Butchery##27533
		..turnin Augustus' Receipt Book##27534
	step
		goto 73.7,52.1
		.talk Fiona##45417
		..turnin Journey's End##27527
	step
	label	"Annals"
		goto 76.1,51.0
		.talk Lord Raymond George##49856
		|tip These are dungeon quests. If you are not high level, you will need to get a group to continue.
		..accept Annals of the Silver Hand##28755 |repeatable
	step
		goto Stratholme,32.1,34.6
		.click The Bastion Door##444
		.' Enter the hallway |goto Stratholme,30.5,35.8,0.5 |c
	step
		goto Stratholme,22.4,56.6
		.click Hall of the High Command Door##444
		.' Enter the Hallway and turn left |goto 20.1,59.5,0.5 |noway |c
	step
		goto Stratholme,27.5,74.7
		.click Annals of the Silver Hand##8133
		.get Annals of the Silver Hand |q 28755/1 |repeatable
	step
		goto Eastern Plaguelands,76.2,51.0
		.talk Lord Raymond George##49856
		..turnin Annals of the Silver Hand##28755 |tip If you do not reset your instance then you will only be forced to clear mobs one time.
		.' Earn Exalted reputation with the Argent Dawn |condition rep('Argent Dawn')==Exalted |only if rep('Argent Dawn')==Exalted
		|next "Annals" |only if rep('Argent Dawn')<=Revered
		|next "exalted" |only if rep('Argent Dawn')==Exalted
	step
	label exalted
		.' Congratulations, you are now Exalted with the _Argent Dawn_!
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Leveling Outland
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("A_Sporeggar_Faction",[[
	step
		'Routing to proper section |next "questc" |only if completedq(9919)
		'Routing to proper section |next |only if not completedq(9919)
	step
		goto Zangarmarsh,19.1,64.2
		.talk Fahssn##17923
		.accept The Sporelings' Plight##9739
		.accept Natural Enemies##9743
		.' turn in these two quests 4 times to go from unfriendly to friendly.
		|only if rep('Sporeggar')<=Neutral
	step
		goto 16.0,60.3
		.from Starving Fungal Giant##18125+, Starving Bog Lord##19519+
		.get 6 Bog Lord Tendril##24291 |q  9743/1
		.click Mature Spore Sac##6911+
		.get 10 Mature Spore Sac##24290 |q 9739/1 |tip They are on the ground throughout the area.
		|only if rep('Sporeggar')<=Neutral
	step
		goto Zangarmarsh,19.1,64.2
		.talk Fahssn##17923
		.turnin The Sporelings' Plight##9739 |repeatable
		..turnin Natural Enemies##9743 |repeatable
		|only if rep('Sporeggar')<=Neutral
	step
		goto 16.0,60.3
		.from Starving Fungal Giant##18125+, Starving Bog Lord##19519+
		.collect 6 Bog Lord Tendril##24291+ |n
		.click Mature Spore Sac##6911+
		.collect 10 Mature Spore Sac##24290 |n |tip They are on the ground throughout the area.
		.' Turn in 10 Spore Sacs or 6 Bog Lord Tendrils at a time here: [19.0,63.3]
		.' Reach Friendly with Sporeggar |condition rep('Sporeggar')>=Friendly
	step
		goto Zangarmarsh,19.1,64.2
		.talk Fahssn##17923
		..accept Sporeggar##9919
	step
		goto 19.7,52.0
		.talk Msshi'fn##17924
		..turnin Sporeggar##9919
	step
	label "questc"
		.' Once you have reached friendly, you can farm the quest Now That We're Friends... and Bring Me A Shrubbery!  Grinding mobs at The Spawning Glen no longer will give you reputation.
		.' Collecting 265 Sanguine Hibiscus from The Underbog will give you enough
		.' Click here if you want to grind out Sanguine Hibiscus. |confirm always |next "hibiscus_1"
		.' or
		.' Click here if you want to grind Naga mobs.|confirm always |next "grind_1"
	step
	label	"hibiscus_1"
		goto The Underbog 31.6,65.4
		.talk T'shu##54674
		..accept Bring Me A Shrubbery!##29691
		..accept Stalk the Stalker##29567
	step
	label	"hibiscus"
		.' You can find the Sanguine Hibiscus on the ground scattered through out the instance.
		.' You can also get Sanguine Hibiscus from Underbat, Underbog Lurkers, Underbog Shamblers, Bog Overlords, Bog Giants and Underbog Lords.
		.collect Sanguine Hibiscus##24246 |n
		.' You need 5 Sanguine Hibiscus for 750 Reputation.
		.' 40 Sanguine Hibiscus = 6,000 Reputation.
		.' 80 Sanguine Hibiscus = 12,000 Reputation.
		.' Click when you are ready to turn in |confirm always
	step
		goto The Underbog 25.7,44.1
		.from The Black Stalker##17882+
		.get Brain of the Black Stalker |q 29567/1
	step
		goto The Underbog 31.6,65.4
		.talk T'shu##54674
		..turnin Bring Me A Shrubbery!##29691
		..turnin Stalk the Stalker##29567
	step
	label	"hibiscus_r"
		goto The Underbog 31.6,65.4
		.talk T'shu##54674
		.accept Bring Me Another Shrubbery!##9714 |instant |repeatable |or
		.' or
		.' Click here to go farming for more _Sanguine Hibiscus_ |confirm always |next "hibiscus" |or
		.' or
		.' Click here if you would like to farm Naga for more reputation |confirm always |next "grind_1" |or
	step
		goto 19.5,50.0
		.talk Gzhun'tt##17856
		.turnin Bring Me A Shrubbery!##9715
		|next "hibiscus_r" |only if rep('Sporeggar')<=Revered
		|next "exalted" |only if rep('Sporeggar')==Exalted
		|only if havequest(9715)
	step
		goto 19.5,50.0
		.talk Gzhun'tt##17856
		.turnin Bring Me Another Shrubbery!##9714
		|next "hibiscus_r" |only if rep('Sporeggar')<=Revered
		|next "exalted" |only if rep('Sporeggar')==Exalted
		|only if havequest(9714)
	step
	label	"grind_1"
		goto Zangarmarsh 19.5,50.0
		.talk Gzhun'tt##17856
		.accept Now That We're Friends...##9726
		|only if rep('Sporeggar')>=Friendly
		|next "grind_2" |only if not completedq(9726)
		|next |only if default
	step
	label	"grind_r"
		goto 19.5,50.0
		.talk Gzhun'tt##17856
		..accept Now That We're Still Friends...##9727 |repeatable |next "grind"|or
		.' or
		.' Click here to go farming for _Sanguine Hibiscus_ |confirm |next "hibiscus_1" |or
		|only if rep('Sporeggar')>=Friendly
	step
	label	"grind_2"
		goto Zangarmarsh,26.9,41.7
		.kill 12 Bloodscale Slavedriver##18089+ |q 9726/1
		.kill 6 Bloodscale Enchantress##18088+ |q 9726/2
		|only if havequest(9726)
		|next "grind_3"
	step
	label	"grind"
		goto Zangarmarsh,26.9,41.7
		.kill 12 Bloodscale Slavedriver##18089+ |q 9727/1 |repeatable
		.kill 6 Bloodscale Enchantress##18088+ |q 9727/2 |repeatable
		|only if havequest(9727)
		|next "grind_4"
	step
	label	"grind_3"
		goto 19.5,50.0
		.talk Gzhun'tt##17856
		.turnin Now That We're Friends...##9726
		|next "grind_r" |only if rep('Sporeggar')<=Revered
		|next "exalted" |only if rep('Sporeggar')==Exalted
	step
	label	"grind_4"
		goto 19.5,50.0
		.talk Gzhun'tt##17856
		.turnin Now That We're Still Friends...##9727
		|next "grind_r" |only if rep('Sporeggar')<=Revered
		|next "exalted" |only if rep('Sporeggar')==Exalted
	step
	label	"exalted"
		.' Congratulations, you are now exalted with Sporeggar!
]])
ZygorGuidesViewer:RegisterInclude("A_Kurenai_Faction",[[
		author support@zygorguides.com
	step
		'Proceeding to Daily |only if completedq(10011)
		'Proceeding to Quests |only if not completedq(10011)
		|next |only if not completedq(10011)
		|next "bead_grind" |only if completedq(10011)
	step
		goto Zangarmarsh,41.9,27.2
		.talk Ikuti##18008
		..accept Ango'rosh Encroachment##9835
		..accept Daggerfen Deviance##10115
	step
		goto 41.7,27.3
		.click Wanted Poster##6901
		..accept Wanted: Chieftain Mummaki##10116
	step
		goto 23.8,26.8
		.from Chieftain Mummaki##19174
		.get Chieftain Mummaki's Totem|q 10116/1
	step
		goto 28.2,22.1
		.kill 3 Daggerfen Assassin##18116 |q 10115/1
		.kill 15 Daggerfen Muckdweller##18115 |q 10115/2
	step
		goto 34.6,29.7
		.kill 5 Ango'rosh Shaman##18118 |q 9835/1
		.kill 10 Ango'rosh Ogre##18117 |q 9835/2
	step
		goto 42.0,27.2
		.talk Ikuti##18008
		..turnin Wanted: Chieftain Mummaki##10116
		..turnin Ango'rosh Encroachment##9835
		..turnin Daggerfen Deviance##10115
		..accept Overlord Gorefist##9839
	step
		goto 40.8,28.7
		.talk Puluu##18009
		..accept Stinger Venom##9830
		..accept Lines of Communication##9833
		..accept The Terror of Marshlight Lake##9902
	step
		goto 41.6,27.3
		.talk Maktu##18010
		..accept Natural Armor##9834
	step
		goto 48.1,38.4
		.from Fenclaw Thrasher##18214
		.get 8 Fenclaw Hide##24486 |q 9834/1
	step
		goto 35.9,58.6
		.kill 12 Marshfang Slicer##18131 |q 9833/1
	step
		goto 22.4,46.1
		.kill Terrorclaw##20477 |q 9902/1 |tip On a little island.
	step
		goto 17.3,38.4
		.from Marshlight Bleeder##18133 |tip They are all around this area on the land, to the north and south.
		.get 6 Marshlight Bleeder Venom |q 9830/1
		.' You'll be able to find more around [Zangarmarsh,19.6,33.3]
	step
		goto 17.3,10.2
		.kill 10 Ango'rosh Mauler##18120 |q 9839/2
		.' Click the brown crates and kill ogres around this area
	step
		goto 18.3,7.7
		.kill Overlord Gorefist##18160 |q 9839/1 |tip Follow the path up the hill. Overlord Gorefist is inside the small house on the left.
	step
		goto 40.8,28.7
		.talk Puluu##18009
		..turnin Stinger Venom##9830
		..turnin Lines of Communication##9833
		..turnin The Terror of Marshlight Lake##9902
	step
		goto 41.6,27.3
		.talk Maktu##18010
		..turnin Natural Armor##9834
		..accept Maktu's Revenge##9905
	step
		goto 42.2,41.4
		.kill Mragesh##18286 |q 9905/1
	step
		goto 41.6,27.3
		.talk Maktu##18010
		..turnin Maktu's Revenge##9905
	step
		goto Nagrand 54.2,70.0
		.talk Huntress Kima##18416
		..accept The Ravaged Caravan##9956
	step
		goto 55.5,68.8
		.talk Elementalist Ioki##18233
		..accept The Throne of the Elements##9869
	step
		goto 55,70.5
		.talk Huntress Bintook##18353
		..accept Do My Eyes Deceive Me##9917
	step
		goto 54.6,70.7
		.click Telaar Bulletin Board##6901
		..accept Wanted: Giselda the Crone##9936
		..accept Wanted: Zorbo the Advisor##9940
	step
		goto 54.7,70.9
		.talk Warden Moi'bff Jill##18408
		..accept Fierce Enemies##10476
	step
		goto 54.5,72.1
		.talk Otonbu the Sage##18222
		..accept Stopping the Spread##9874
	step
		goto 54.5,72.3
		.talk Poli'lukluk the Wiser##18224
		..accept Solving the Problem##9878
	step
		goto 63.1,73.2
		.from Boulderfist Hunter##18352+
		.get Boulderfist Plans|q 9917/1
	step
		goto 71.1,82.4
		.kill Giselda the Crone##18391 |q 9936/1
	step
		goto 67.9,79.3
		.from Kil'sorrow Deathsworn##17148+, Kil'sorrow Spellbinder##17146+, Kil'sorrow Cultist##17147+
		. Kill 10 Kil'sorrow Agents|q 9936/2
	step
		goto 72.6,70.7
		.talk Corki##18369
		..accept HELP!##9923
		.from Boulderfist Crusher##17134+, Boulderfist Mystic##17135+
		.collect 1 Boulderfist Key##25490 |q 9923 |sticky
		.click Corki's Prison##1787
		.' Free Corki |q 9923/1
	step
		goto 60.7,22.1
		.talk Elementalist Sharvak##18072
		..turnin The Throne of the Elements##9869
	step
		goto 48.3,21.5
		.kill 5 Warmaul Shaman##18064+ |q 9940/2
		.kill 5 Warmaul Reaver##17138+ |q 9940/3
		.get 10 Obsidian Warbeads|q 10476/1
	step
		goto 46.5,18.2
		.kill Zorbo the Advisor##18413|q 9940/1
	step
		goto 27.9,29.7
		.click Telaar Supply Crate##6881
		.get 10 Telaar Supply Crate |q 9956/1
	step
		goto 29.5,43.5
		.kill 10 Murkblood Scavenger##18207+ |q 9878/1
		.kill 5 Murkblood Raider##18203+ |q 9878/2
		.' Use the Torch of Liquid Fire on Sunspring Villager Corpses in the water and the village |use Torch of Liquid Fire##24560
		.' Burn 10 Sunspring Villager Corpses |q 9874/1
		|modelnpc Sunspring Villager##18240+
	step
		goto 54.5,72.3
		.talk Poli'lukluk the Wiser##18224
		..turnin Solving the Problem##9878
	step
		goto 54.5,72.1
		.talk Otonbu the Sage##18222
		..turnin Stopping the Spread##9874
	step
		goto 54.2,70
		.talk Huntress Kima##18416
		..turnin The Ravaged Caravan##9956
	step
		goto 55.5,68.8
		.talk Arechron##18183
		..turnin HELP!##9923
		..accept Corki's Gone Missing Again!##9924
	step
		goto 55,70.5
		.talk Huntress Bintook##18353
		..turnin Do My Eyes Deceive Me##9917
		..accept Not On My Watch!##9918
	step
		goto 54.8,71
		.talk Warden Moi'bff Jill##18408
		..turnin Wanted: Giselda the Crone##9936
		..turnin Wanted: Zorbo the Advisor##9940
		..turnin Fierce Enemies##10476
	step
		goto 62.7,71.4
		.' Fight Lump until he's almost dead |tip Sleeping on the hill.
		.'Talk to Lump and tell him you need answers! |q 9918/1
		|modelnpc Lump##18351
	step
		goto 55,70.5
		.talk Huntress Bintook##18353
		..turnin Not On My Watch!##9918
		..accept Mo'mor the Breaker##9920
	step
		goto 54.6,72.2
		.talk Mo'mor the Breaker##18223
		..turnin Mo'mor the Breaker##9920
		..accept The Ruins of Burning Blade##9921
	step
		goto 72.9,69.8
		.kill 8 Boulderfist Crusher##17134+ |q 9921/1
		.kill 8 Boulderfist Mystic##17135+ |q 9921/2
	step
		goto 54.6,72.2
		.talk Mo'mor the Breaker##18223
		..turnin The Ruins of Burning Blade##9921
		..accept The Twin Clefts of Nagrand##9922
	step
		goto 40.7,35.6
		.kill 10 Boulderfist Warrior##17136+ |q 9922/1
		.kill 10 Boulderfist Mage##17137+ |q 9922/2
		.collect 1 Northwind Cleft Key##25509 |q 9924 |sticky
	step
		goto 39.3,27.5
		.click Corki's Prison##1787
		.' Free Corki inside the cave |q 9924/1 |tip Inside the cave, way in the back.
	step
		'Go outside to 54.5,72.2|goto 54.6,72.2
		.talk Mo'mor the Breaker##18223
		..turnin The Twin Clefts of Nagrand##9922
		..accept Diplomatic Measures##10108
	step
		goto 55.5,68.8
		.talk Arechron##18183
		..turnin Corki's Gone Missing Again!##9924
	step
		goto 73.8,62.6
		.talk Lantresor of the Blade##18261
		..'Listen to his story
		..turnin Diplomatic Measures##10108
		..accept Armaments for Deception##9928
		..accept Ruthless Cunning##9927
	step
		goto 71.4,79.4
		.click Kil'sorrow Armament##6959+
		.get 10 Kil'sorrow Armaments |q 9928/1
		.from Kil'sorrow Deathsworn##17148+, Kil'sorrow Spellbinder##17146+, Kil'sorrow Cultist##17147+
		.' Use your Warmaul Ogre Banners on their corpses |use Warmaul Ogre Banner##25552
		.' Plant 10 Warmaul Ogre Banners|q 9927/1
	step
		goto 73.8,62.6
		.talk Lantresor of the Blade##18261
		..turnin Armaments for Deception##9928
		..turnin Ruthless Cunning##9927
		..accept Returning the Favor##9931
		..accept Body of Evidence##9932
	step
		goto 46.5,24.3
		.from Warmaul Shaman##18064+,Warmaul Reaver##17138+
		.' Use your Kil'sorrow Banners on their corpses |use Kil'sorrow Banner##25555
		.' Plant 10 Kil'sorrow Banners |q 9931/1
		.' Use the Damp Woolen Blanket on the Blazing Warmaul Pyre |use Damp Woolen Blanket##25658
		.' Defend the Boulderfist Saboteurs that appear until they are done placing the corpses |q 9932/1
		|modelnpc Boulderfist Saboteur##18396
	step
		goto 73.8,62.6
		.talk Lantresor of the Blade##18261
		..turnin Returning the Favor##9931
		..turnin Body of Evidence##9932
		..accept Message to Telaar##9933
	step
		goto 55.5,68.8
		.talk Arechron##18183
		..turnin Message to Telaar##9933
	step
		goto 55.5,68.7
		.talk Arechron##18183
		..accept Corki's Ransom##9954
	step
		goto 54.7,70.9
		.talk Warden Moi'bff Jill##18408
		..accept Wanted: Durn the Hungerer##9938
	step
		goto Nagrand,54.8,70.5
		.talk Huntress Kima##18416
		..accept He Called Himself Altruis...##9982
	step
		.' The next few quests are meant to be _group quests_. If you are not high level, you may need at least _3 people_ for these quests.
		.' Click here to proceed |confirm
	step
		map Nagrand
		path follow loose;loop;ants curved
		path	46.7,63.7	40.8,63.5	37.4,62.1
		path	34.0,62.7	31.7,65.4	30.5,71.3
		path	32.0,75.9	35.5,78.5	39.8,78.7
		path	42.4,75.5	46.0,70.2
		.' Follow the path around this are to look for _Durn the Hungerer_
		.kill Durn the Hungerer##18411 |q 9938/1
	step
		goto 27.3,43.1
		.talk Altruis the Sufferer##18417
		..turnin He Called Himself Altruis...##9982
		..accept Survey the Land##9991 |tip You will fly around on a drake to view The Twilight Ridge.
		..turnin Survey the Land##9991
		..accept Buying Time##9999
	step
		goto 25.2,38.3
		.kill 2 Felguard Legionnaire##17152+ |q 9999/1
		.kill 3 Mo'arg Engineer##16945+ |q 9999/2
		.kill 8 Gan'arg Tinkerer##17151+ |q 9999/3
	step
		goto 27.3,43.1
		.talk Altruis the Sufferer##18417
		..turnin Buying Time##9999
		..accept The Master Planner##10001
	step
		goto 23.6,34.6
		.from Mo'arg Master Planner##18567
		.get The Master Planner's Blueprints |q 10001/1
	step
		goto 27.3,43.1
		.talk Altruis the Sufferer##18417
		..turnin The Master Planner##10001
		..accept Patience and Understanding##10004
	step
		goto 27.0,23.7 |n
		.' Enter the Cave here |goto 27.0,23.7,0.5 |noway |c |q 10004
	step
		goto 29.5,26.1
		.talk Corki##18445 |tip You may have to fight the 65 Elite standing next to the cage.
		..turnin Corki's Ransom##9954
		..accept Cho'war the Pillager##9955
	step
		goto 27.0,23.7 |n
		.' Leave the cave |goto 27.0,23.7,0.5 |noway |c |q 9955
	step
		goto 27.2,18.7 |n
		.' Enter the Cave here |goto 27.2,18.7,0.5 |noway |c |q 9955
	step
		goto Nagrand,25.8,13.8
		.' Follow the path up and around
		.from Cho'war the Pillager##18423+
		.collect Cho'war's Key##25648 |q 9955
	step
		goto 27.2,18.7 |n
		.' Leave the Cave here |goto 27.2,18.7,0.5 |noway |c |q 9955
	step
		goto 27.0,23.7 |n
		.' Enter the cave |goto 27.0,23.7,0.5 |noway |c |q 9955
	step
		goto 29.5,26.1
		.' Click _Corki's_ cage to unlock it
		.' Free Corki |q 9955/1 |tip You may have to fight the 65 Elite standing next to the cage.
	step
		goto 27.0,23.7 |n
		.' Leave the cave |goto 27.0,23.7,0.5 |noway |c
	step
		goto 54.7,70.9
		.talk Warden Moi'bff Jill##18408
		..turnin Wanted: Durn the Hungerer##9938
	step
		goto 55.5,68.7
		.talk Arechron##18183
		..turnin Cho'war the Pillager##9955
	step
		goto Shattrath City,77.3,34.9
		.talk Sal'salabim##18584
		.' Tell him "Altruis sent me. He said that you could help me." |tip He will immediately start attacking you!
		.' Persuad Sal'salabim |q 10004/1
	step
		goto Shattrath City,77.3,34.9
		.talk Sal'salabim##18584
		..turnin Patience and Understanding##10004
		..accept Crackin' Some Skulls##10009
	step
		goto 75.0,31.5
		.talk Raliq the Drunk##18585
		.' Tell him you are here to collect a dept, pay up or you're going to have to hurt him. |tip He will immediately start attacking you!
		.' Collect Raliq's Debt |q 10009/1
	step
		goto Zangarmarsh,80.9,91.1
		.talk Coosh'coosh##18586
		.' Tell him you are here to collect a dept, pay up or you're going to have to hurt him. |tip He will immediately start attacking you!
		.' Collect Coosh'coosh's Debt |q 10009/2
	step
		goto Terokkar Forest,27.2,58.1
		.talk Floon##18588
		.' Tell him you are here to collect a dept, pay up or you're going to have to hurt him. |tip He will immediately start attacking you!
		.' Collect Floon's Debt |q 10009/3
	step
		goto Shattrath City 77.3,34.9
		.talk Sal'salabim##18584
		..turnin Crackin' Some Skulls##10009
		..accept It's Just That Easy?##10010
	step
		goto Nagrand,27.3,43.1
		.talk Altruis the Sufferer##18417
		..turnin It's Just That Easy?##10010
		..accept Forge Camp: Annihilated##10011
	step
		goto Nagrand,25.0,36.1
		.from Demos\,\ Overseer of Hate##18535
		.collect Fel Cannon Activator##25770 |n
		.' Use the Fel Cannon Activator in your bags |use Fel Cannon Activator##25770
		.' Destroy Forge Camp: Hate |q 10011/1
	step
		goto 19.6,51.1
		.from Xirkos\,\ Overseer of Fear##18536
		.collect Fel Cannon Activator##25771 |n
		.' Use the Fel Cannon Activator in your bags |use Fel Cannon Activator##25771
		.' Destoy Forge Camp: Fear |q 10011/2
	step
		goto 27.3,43.1
		.talk Altruis the Sufferer##18417
		..turnin Forge Camp: Annihilated##10011
	step
		.' Once you have completed the above quests, you will have to grind your way to Exalted.
		.' Click to proceed. |confirm
	step
	label	"bead_grind"
		goto Nagrand,48.9,22.7
		.from Warmaul Reaver##17138+, Warmaul Shaman##18064+
		..collect Obsidian Warbeads##25433 |n
		.' If you are fresh into revered, you will need 420 beads to get 21,000 reputation points.
		.' Collect beads in sets of 10.
		.' Click here when you're ready to turn in. |confirm
	step
	label	"turn_in"
		goto Nagrand,54.7,70.9
		.talk Warden Moi'bff Jill##18408
		..accept More Warbeads##10477 |n
		.' or
		.' Click here to go back to farming. |next "bead_grind" |confirm
		'Earn Exalted reputation with the Kurenai. |condition rep("Kurenai")==Exalted |next "exalted"
	step
	label exalted
		.' Congratulations, you are now Exalted with The Kurenai! |condition rep("Kurenai")==Exalted
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- Leveling Northrend
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("A_Icecrown_Argent_Crusade_Rep",[[
	step
		'Routing to proper section. |next |only if not completedq(13082)
		'Routing to proper section. |next "Tabard" |only if completedq(13082)
	step
		goto Icecrown 87.5,75.8
		.talk Highlord Tirion Fordring##28179
		..accept Honor Above All Else##13036
	step
		goto 87.1,75.8
		.talk Crusade Commander Entari##30223
		..turnin Honor Above All Else##13036
		..accept Scourge Tactics##13008
	step
		goto 86.8,76.7
		.talk Father Gustav##30226
		..accept Curing The Incurable##13040
	step
		goto 86.1,75.8
		.talk Crusader Lord Dalfors##30224
		..accept Defending The Vanguard##13039
	step
		goto 84.4,74.3
		.from Carrion Fleshstripper##30206+, Forgotten Depths Acolyte##30205+
		.kill 15 Forgotten Depths Nerubian |q 13039/1
		.get 10 Forgotten Depths Venom Sac|q 13040/1
		.' Kill the white spider wrappings around this area.
		|modelnpc Webbed Crusader##17680
		.' Free 8 Webbed Crusaders |q 13008/1
	step
		goto 86.1,75.8
		.talk Crusader Lord Dalfors##30224
		..turnin Defending The Vanguard##13039
	step
		goto 86.8,76.7
		.talk Father Gustav##30226
		..turnin Curing The Incurable##13040
	step
		goto 87.1,75.8
		.talk Crusade Commander Entari##30223
		..turnin Scourge Tactics##13008
		..accept If There Are Survivors...##13044
	step
		goto 87.0,79.0
		.talk Penumbrius##30227
		..turnin If There Are Survivors...##13044
		..accept Into The Wild Green Yonder##13045
	step
		goto 87.1,79.1
		'Click the Argent Skytalon to ride it |modelnpc Argent Skytalon##30500 |invehicle |c |q 13045
	step
		goto 79.0,67.4
		.' Use the Grab Captured Crusader ability near Captured Crusaders to pick them up |petaction Grab Captured Crusader
		.' Once you pick up a Captured Crusader, fly to [86.9,76.5]|n
		.' Use the Drop Off Captured Crusader ability near the tents to drop off the crusaders
		.' Repeat this process 2 more times
		.' Rescue 3 Captured Crusaders |q 13045/1
	step
		.' Click the red arrow on your vehicle hot bar to stop riding the dragon |outvehicle
	step
		goto 87.5,75.8
		.talk Highlord Tirion Fordring##28179
		..turnin Into The Wild Green Yonder##13045
		..accept A Cold Front Approaches##13070
	step
		goto 85.6,76.0
		.talk Siegemaster Fezzik##30657
		..turnin A Cold Front Approaches##13070
		..accept The Last Line Of Defense##13086
	step
		goto 85.3,75.9
		'Click the Argent Cannon to get on it |modelnpc Argent Cannon##30236 |invehicle |c |q 13086
	step
		'Use the skills on your hotbar to kill scourge mobs and dragons
		.kill 100 Scourge Attacker |q 13086/1
		.kill 3 Frostbrood Destroyer |q 13086/2
		'|from Forgotten Depths Slayer##30593, Frostbrood Destroyer##30575
	step
		.' Click the red arrow on your vehicle hot bar to stop using the cannon |outvehicle |c
	step
		goto 85.6,76.0
		.talk Siegemaster Fezzik##30657
		..turnin The Last Line Of Defense##13086
	step
		goto 86.0,75.8
		.talk Highlord Tirion Fordring##28179
		..accept Once More Unto The Breach, Hero##13105 |only DeathKnight
		..accept Once More Unto The Breach, Hero##13104 |only !DeathKnight
	step
		goto 83.0,72.9
		.talk The Ebon Watcher##30596
		..turnin Once More Unto The Breach, Hero##13105 |only DeathKnight
		..turnin Once More Unto The Breach, Hero##13104 |only !DeathKnight
		..accept The Purging Of Scourgeholme##13118
		..accept The Scourgestone##13122
	step
		goto 83.0,73.1
		.talk Crusade Architect Silas##30686
		..accept The Stone That Started A Revolution##13130
	step
		goto 83.0,73.1
		.talk Crusade Engineer Spitzpatrick##30714
		..accept It Could Kill Us All##13135
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..accept The Restless Dead##13110
	step
		goto 80.4,68.2
		.from 8 Reanimated Crusader##31043+ |q 13118/3
		.from 3 Forgotten Depths Underking##31039+ |q 13118/2
		.get 15 Scourgestone |q 13122/1
		.' Use your Holy Water on Reanimated Crusader corpses |use Holy Water##43153
		.' Free 10 Restless Souls |q 13110/1
	step
		goto 78.7,60.2
		.kill 3 Forgotten Depths High Priest##31037+ |q 13118/1
		.' You can find another Forgotten Depths High Priest at [76.2,61.0] |n
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..turnin The Restless Dead##13110
	step
		goto 83.0,72.9
		.talk The Ebon Watcher##30596
		..turnin The Purging Of Scourgeholme##13118
		..turnin The Scourgestone##13122
		..accept The Air Stands Still##13125
	step
		goto 77.6,62.2
		.' Use your War Horn of Acherus on Salranax the Flesh Render |use War Horn of Acherus##43206 |tip A Death Knight is summoned to help you, but make sure you get the first hit on Salranax the Flesh Render, or else you won't get credit for the kill.
		.kill Salranax the Flesh Render##30829 |q 13125/1
	step
		goto 79.7,60.9
		.' Use your War Horn of Acherus on High Priest Yath'amon |use War Horn of Acherus##43206 |tip A Death Knight is summoned to help you, but make sure you get the first hit on High Priest Yath'amon, or else you won't get credit for the kill.
		.kill High Priest Yath'amon##30831 |q 13125/3
	step
		goto 76.6,54.1
		.' Use your War Horn of Acherus on Underking Talonox |use War Horn of Acherus##43206 |tip A Death Knight is summoned to help you, but make sure you get the first hit on Underking Talonox, or else you won't get credit for the kill.
		.kill Underking Talonox##30830 |q 13125/2
	step
		'Click the dark portal that spawns after you kill Underking Talonox to return to the Valley of Echoes |goto Icecrown,83.0,72.6,0.5 |noway |c
	step
		goto 83.0,72.9
		.talk The Ebon Watcher##30596
		..turnin The Air Stands Still##13125
	step
		goto Crystalsong Forest,59.9,57.2
		.from Unbound Ent##30862+, Unbound Dryad##30860+
		.get 8 Crystallized Energy |q 13135/1
		.click Crystalline Heartwood##8439
		.get 10 Crystalline Heartwood |q 13130/1
	step
		goto 73.6,64.0
		.click Ancient Elven Masonry##8356
		.get 10 Ancient Elven Masonry |q 13130/2
		.' You can find more Ancient Elven Masonry around [79.6,61.3] |n
	step
		goto Icecrown,83.0,73.1
		.talk Crusade Architect Silas##30686
		..turnin The Stone That Started A Revolution##13130
	step
		goto 83.0,73.1
		.talk Crusade Engineer Spitzpatrick##30714
		..turnin It Could Kill Us All##13135
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..accept Into The Frozen Heart Of Northrend##13139
	step
		goto 86.0,75.8
		.talk Highlord Tirion Fordring##28179
		..turnin Into The Frozen Heart Of Northrend##13139
		..accept The Battle For Crusaders' Pinnacle##13141
	step
		goto 80.1,72.0
		.' Stand next to the Pile of Crusader Skulls
		.' Use your Blessed Banner of the Crusade |use Blessed Banner of the Crusade##43243
		.' Defend the Banner of the Crusade against oncoming attackers
		.' Complete the Battle for Crusaders' Pinnacle |q 13141/1
	step
		goto 82.9,72.8
		.talk Father Gustav##30683
		..turnin The Battle For Crusaders' Pinnacle##13141
		..accept The Crusaders' Pinnacle##13157
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin The Crusaders' Pinnacle##13157
		..accept A Tale of Valor##13068
	step
		goto 79.4,72.9
		.talk Marshal Ivalius##31241
		..accept The Skybreaker##13225
	step
		goto 79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin A Tale of Valor##13068
		..accept A Hero Remains##13072
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin A Hero Remains##13072
		..accept The Keeper's Favor##13073
	step
		goto 87.1,77.0
		.talk Arch Druid Lilliandra##30630
		..' Ask her for a portal to Moonglade
		..' Click the Moonglade Portal that appears next to you|goto Moonglade|noway|c
	step
		goto Moonglade,36.2,41.8
		.talk Keeper Remulos##11832
		..turnin The Keeper's Favor##13073
		..accept Hope Within the Emerald Nightmare##13074
	step
		goto 33.7,44.1
		.click Emerald Acorn##424
		.get 3 Emerald Acorn|q 13074/1
	step
		'Right click your Fitfull Dream buff to awaken from the nightmare|nobuff Spell_Nature_Sleep|q 13074|tip The Fitfull Dream buff icon looks like a closed eye.
	step
		goto 36.2,41.8
		.talk Keeper Remulos##11832
		..turnin Hope Within the Emerald Nightmare##13074
		..accept The Boon of Remulos##13075
	step
		goto 36.2,41.8
		.talk Keeper Remulos##11832
		..' Tell him you wish to return to Arch Druid Lilliandra.
		..' Click the Moonglade Return Portal |goto Icecrown|noway|c
	step
		goto 79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin The Boon of Remulos##13075
		..accept Time Yet Remains##13076
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin Time Yet Remains##13076
		..accept The Touch of an Aspect##13077
	step
		goto Dragonblight,57.9,54.2|n
		.talk Tariolstrasz##26443
		..'Tell him you need to go to the top of the temple|goto Dragonblight,59.7,53.1,0.1|noway|c
	step
		goto 59.8,54.7
		.talk Alexstrasza the Life-Binder##26917
		..turnin The Touch of an Aspect##13077
		..accept Dahlia's Tears##13078
	step
		goto 59.5,53.3|n
		.talk Torastrasza##26949
		..'Tell him you want to go to the ground level of the temple|goto Dragonblight,58.0,55.2,0.1|noway|c
	step
		goto 43.2,51.7
		.' There should be a fight happening, so just wait around until the fight is over|tip If there isn't fight happening, just wait until the fighters spawn again, and there should be some red dragon Ruby Watchers flying above the fight.
		.' At the end of the fight, a Ruby Watcher will blow alot of fire on the ground and the Dahlia's Tears will spawn
		.click Dahlia's Tears##8329
		.get Dahlia's Tears|q 13078/1
	step
		goto 57.9,54.2|n
		.talk Tariolstrasz##26443
		..'Tell him you need to go to the top of the temple|goto Dragonblight,59.7,53.1,0.1|noway|c
	step
		goto 59.8,54.7
		.talk Alexstrasza the Life-Binder##26917
		..turnin Dahlia's Tears##13078
		..accept The Boon of Alexstrasza##13079
	step
		goto 59.5,53.3|n
		.talk Torastrasza##26949
		..'Tell him you want to go to the ground level of the temple|goto Dragonblight,58.0,55.2,0.1|noway|c
	step
		goto Icecrown 79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin The Boon of Alexstrasza##13079
		..accept Hope Yet Remains##13080
	step
		goto 79.8,71.8
		.talk Highlord Tirion Fordring##28179
		..turnin Hope Yet Remains##13080
		..accept The Will of the Naaru##13081
	step
		'Click the Portal to Shattrath that appears near you |goto Shattrath City |noway |c
	step
		goto Shattrath City,54,44.8
		.talk A'dal##18481
		..turnin The Will of the Naaru##13081
		..accept The Boon of A'dal##13082
	step
		goto Icecrown,79.8,30.8
		.talk Crusader Bridenbrad##30562
		..turnin The Boon of A'dal##13082
	step
	label "Tabard"
		'You should now be above Honored with the _Argent Crusade_.
		.' The fastest way to continue to earn reputation with _Argent Crusade_ is to buy a tabard and run any dungeon that gives experience.
		|confirm
	step
		goto Icecrown,87.5,75.6
		.talk Veteran Crusader Aliocha Segard##30431
		.buy 1 Tabard of the Argent Crusade##43154
	step
		.' Equip this Tabard in your bags |equipped Tabard of the Argent Crusade##43154 |use Tabard of the Argent Crusade##43154
		.' You can run any dungeon that grants experience to gain reputation for the Argent Crusade.
		.' Friendly with Argent Crusade |condition rep("Argent Crusade")>=Friendly
		.' Honored with Argent Crusade |condition rep("Argent Crusade")>=Honored
		.' Revered with Argent Crusade |condition rep("Argent Crusade")>=Revered
		.' Become Exalted with Argent Crusade |condition rep("Argent Crusade")==Exalted
	step
		'Congratulations! You are now Exalted with the _Argent Crusade_!
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Leveling Cataclysm
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("A_Deepholm_Leveling",[[
	step
		goto Stormwind City 62.9,71.6
		.click Hero's Call Board##10016
		..accept Hero's Call: Deepholm!##27727
	step
		goto 74.5,19.0
		.talk Naraat the Earthspeaker##45226
		..turnin Hero's Call: Deepholm!##27727
		..accept The Maelstrom##27203
	step
		goto The Maelstrom,33.4,50.2
		.talk Thrall##45042
		..turnin The Maelstrom##27203
		..accept Deepholm, Realm of Earth##27123
	step
		goto 32.5,52.0
		.clicknpc Wyvern##45005
		.' You will fly into Deepholm |goto Deepholm,49.9,54.7,0.5 |noway |c |q 27123
	step
		goto Deepholm,49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Deepholm, Realm of Earth##27123
		..accept Gunship Down##26245
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..accept Elemental Energy##27136
		..accept The Earth Claims All##26244
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..accept Where's Goldmine?##26409
	step
		goto 49.2,51.9
		.talk Caretaker Nuunwa##45300
		.home Temple of Earth
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Where's Goldmine?##26409
		..accept Explosive Bonding Compound##26410
		..accept Something that Burns##27135
	step
		goto 45.5,57.9
		.from Rockslice Flayer##42606+, Rockslice Ripper##42607+
		.get 5 Quartzite Resin |q 26410/1
		.' You can find more Rockslice Flayers around [42.5,55.6]
	step
		goto 51.1,61.6
		.' Use your Depleted Totem |use Depleted Totem##60835
		.from Lodestone Elemental##43258+, Energized Geode##43254+ |tip Kill them next to your Depleted Totems.
		.' Energize the Totem 8 Times |q 27136/1
	step
		goto 52.0,58.9
		.' Use Goldmine's Fire Totem in the red lava spot |use Goldmines's Fire Totem##60834
		.from Magmatooth##45099
		.get The Burning Heart |q 27135/1
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Explosive Bonding Compound##26410
		..turnin Something that Burns##27135
		..accept Apply and Flash Dry##26411
	step
		goto 46.6,57.2
		.' Use your Explosive Bonding Compound on Flint Oremantle |use Explosive Bonding Compound##58502 |modelnpc Flint Oremantle##43036+
		.' Apply the Explosive Bonding Compound |q 26411/1
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Apply and Flash Dry##26411
		..accept Take Him to the Earthcaller##26413
	step
		goto 49.5,53.3
		.' Introduce Flint Oremantle to Earthcaller Yevaa |q 26413/1
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..turnin Take Him to the Earthcaller##26413
		..accept To Stonehearth's Aid##26484
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin Elemental Energy##27136
	step
		goto 56.1,74.2
		.clicknpc Slain Cannoneer##43032
		.' Receive the Second Clue |q 26245/2
	step
		goto 53.5,73.8
		.clicknpc Captain Skullshatter##43048
		.' Receive the First Clue |q 26245/1
		.|tip It is inside on the upper level of this broken gunship.
	step
		goto 53.6,73.8
		.click Captain's Log##6891
		..accept Captain's Log##26246
	step
		goto 56.7,76.4
		.clicknpc Unexploded Artillery Shell##43044
		.' Receive the Third Clue |q 26245/3
		.|tip It is on the ground in front of the gunship.
	step
		goto 55.9,74.9
		.kill 5 Deepstone Elemental##43026+ |q 26244/1
	step
		goto 49.6,52.9
		.talk Maruut Stonebinder##43065
		..turnin Gunship Down##26245
		..turnin Captain's Log##26246
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin The Earth Claims All##26244
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..accept Diplomacy First##26247
	step
		goto 62.4,52.6
		.talk Stormcaller Mylra##42684 |tip She's up above in an airship patrolling this area.
		..turnin Diplomacy First##26247
		..accept All Our Friends Are Dead##26248
		..accept The Admiral's Cabin##26249
	step
		'All around on this air ship:
		.' Use your Spirit Totem on Slain Crew Members |use Spirit Totem##58167
		.' Receive 6 Slain Crew Member Information |q 26248/1
		|modelnpc Slain Crew Member##42681+
	step
		'Enter the doorway on the main deck of the air ship:
		.talk First Mate Moody##43082
		.|tip He will be on your left.
		..turnin The Admiral's Cabin##26249
		..accept Without a Captain or Crew##26427
	step
		'Leave through the doorway and immediately turn right:
		.click Bottle of Whiskey##9712 |tip Located on the life boat.
		.get Bottle of Whiskey |q 26427/1
	step
		'All around on the deck of the air ship:
		.click Spool of Rope##7538
		.get Spool of Rope |q 26427/2
	step
		'Enter the doorway on the main deck of the air ship:
		.talk First Mate Moody##43082
		..turnin Without a Captain or Crew##26427
	step
		'Go to the very top of the air ship:
		.talk Stormcaller Mylra##42684
		..turnin All Our Friends Are Dead##26248
		..accept Take No Prisoners##26251
		..accept On Second Thought, Take One Prisoner##26250
	step
		'Go onto the main deck of the ship and go down the stairs to the deck below:
		.' Fight Mor'norokk the Hateful until he surrenders |tip He's downstairs in the airship, in the very back of the first level you come to. He may be marked on your mini map as a white skull with red eyes.
		.talk Mor'norokk the Hateful##42801
		.' Subdue Mor'norokk the Hateful |q 26250/1
	step
		'All around on this lower deck of the air ship:
		.kill 6 Twilight Saboteur##42885 |q 26251/1
	step
		'Go to the very top of the air ship:
		.talk Stormcaller Mylra##42684
		..turnin Take No Prisoners##26251
		..turnin On Second Thought, Take One Prisoner##26250
		..accept Some Spraining to Do##26254
	step
		Next to Stormcaller Mylra:
		.clicknpc Stormbeak##42887
		.' Interrogate Mok'norrok |q 26254/1
	step
		'When you land on the air ship again:
		.talk Stormcaller Mylra##42684
		..turnin Some Spraining to Do##26254
		..accept Return to the Temple of Earth##26255
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Return to the Temple of Earth##26255
		..accept Deathwing's Fall##26258
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..accept Blood of the Earthwarder##26259
	step
		goto 59.4,58.2
		.' Go to this spot
		.' Reach Deathwing's Fall |q 26258/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Deathwing's Fall##26258
		..accept Bleed the Bloodshaper##26256
	step
		goto 61.5,60.6
		.from Twilight Bloodshaper##43218+
		.get Twilight Orders |q 26256/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Bleed the Bloodshaper##26256
		..accept Question the Slaves##26261
	step
		goto 62.8,59.5
		.click Slavemaster's Coffer##41
		.|tip It is in a small box inside this tent.
		.collect 1 Twilight Slaver's Key##60739 |q 26261
	step
		goto 61.2,60.1
		.from Living Blood##43123+
		.get 5 Blood of Neltharion |q 26259/1
	step
		goto 64.5,65.5
		.click Ball and Chain##181+
		.' Free 6 Enslaved Miners |q 26261/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Question the Slaves##26261
		..accept The Forgemaster's Log##26260
	step
		goto 63.7,55.4
		.click Forgemaster's Log##6891
		.|tip It is at the top of this tower.
		..turnin The Forgemaster's Log##26260
		..accept Silvermarsh Rendezvous##27007
	step
		goto 70.6,61.2
		.' Go to this spot
		.' Reach Upper Silvermarsh |q 27007/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Silvermarsh Rendezvous##27007
		..accept Quicksilver Submersion##27010
	step
		goto 71.8,64.3
		.click Trogg Crate##9855
		.collect Trogg Crate##60809 |q 27010
		.from Murkstone Trogg##44936
		.collect 1 Maziel's Research##60816 |n
		.' Click Maziel's Research in your bags |use Maziel's Research##60816
		..accept Twilight Research##27100
	step
		goto 74.9,64.8
		.' Use your Trogg Crate in the water and swim to this spot |use Trogg Crate##60809
		.' Watch the dialogue
		.' Uncover the World Pillar Fragment Clue |q 27010/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Quicksilver Submersion##27010
		..accept The Twilight Overlook##27061
	step
		goto 72.5,65.2
		.from Mercurial Ooze##43158+
		.get 4 Twilight Research Notes |q 27100/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Twilight Research##27100
		..accept Maziel's Revelation##27101
	step
		goto 67.2,70.2
		.click Maziel's Journal##2530
		..turnin Maziel's Revelation##27101
		..accept Maziel's Ascendancy##27102
	step
		goto 69.5,68.0 |n
		.' Enter the cave |goto 69.5,68.0,0.5 |noway |c
	step
		goto 72.8,62.0
		.kill Maziel##44967 |q 27102/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Maziel's Ascendancy##27102
	step
		goto 69.5,68.0 |n
		.' Leave the cave |goto 69.5,68.0,0.5 |noway |c
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin The Twilight Overlook##27061
		..accept Big Game, Big Bait##26766
		..accept To Catch a Dragon##26768
	step
		goto 58.0,84.8
		.from Jadecrest Basilisk##43981+
		.' Use Mylra's Knife on Jadecrest Basilisk corpses |use Mylra's Knife##60382
		.get 5 Side of Basilisk Meat |q 26766/1
		.from Twilight Dragonstalker##43992+
		.get Twilight Snare |q 26768/1
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin Big Game, Big Bait##26766
		..turnin To Catch a Dragon##26768
		..accept Testing the Trap##26771
	step
		goto 50.9,85.3
		.' Use your Trapped Basilisk Meat |use Trapped Basilisk Meat##60773
		.kill Stonescale Matriarch##44148 |q 26771/1
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin Testing the Trap##26771
		..accept Abyssion's Minions##26857
	step
		goto 64.6,82.2
		.talk Seer Galekk##44222
		..accept Block the Gates##26861
	step
		goto 68.7,75.0
		.' Use your Stormstone next to the swirling blue portal |use Stormstone##60501
		.' Disrupt the Twilight Gate |q 26861/1
	step
		goto 71.2,75.1
		.' Use your Stormstone next to the structure with the floating yellow crystal |use Stormstone##60501
		.' Disrupt the Elemental Gate |q 26861/2
	step
		goto 69.9,76.7
		.from Scalesworn Cultist##44221+, Twilight Scalesister##43967+, Twilight Dragonspawn##43966+
		.' Defeat 8 Abyssion's Underlings |q 26857/1
	step
		goto 64.6,82.2
		.talk Seer Galekk##44222
		..turnin Block the Gates##26861
	step
		goto 64.5,82.2
		.talk Stormcaller Mylra##44010
		..turnin Abyssion's Minions##26857
		..accept The World Pillar Fragment##26876
	step
		goto 69.9,76.9
		.' Use your Earthen Ring Banner |use Earthen Ring Banner##60810
		.from Abyssion##44289
		.click The First Fragment of the World Pillar##9779
		.get The Upper World Pillar Fragment |q 26876/1
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin The World Pillar Fragment##26876
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin Blood of the Earthwarder##26259
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin To Stonehearth's Aid##26484
		..accept The Quaking Fields##27931
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..turnin The Quaking Fields##27931
		..accept The Axe of Earthly Sundering##27932
		..accept Elemental Ore##27933
	step
		goto 32.2,79.1
		.' Use The Axe of Earthly Sundering on Emerald Colossi |use The Ace of Earthly Sundering##60490
		.kill 5 Sundered Emerald Colossus##44229 |q 27932/1
		.from Jade Rager##44220+
		.get 6 Elemental Ore |q 27933/1
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..turnin The Axe of Earthly Sundering##27932
		..turnin Elemental Ore##27933
		..accept One With the Ground##27934
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..' Tell him you are ready for the ritual
		.' Complete the One With the Ground Ritual |q 27934/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin One With the Ground##27934
		..accept Bring Down the Avalanche##27935
	step
		goto 46.9,89.1
		.kill Avalanchion##44372 |q 27935/1
	step
		goto 43.4,82.0 |n
		.' Leave the cave |goto 43.4,82.0,0.5 |noway |c
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin Bring Down the Avalanche##27935
		..accept Stonefather's Boon##26499
	step
		goto 28.2,69.6
		.talk Earthbreaker Dolomite##43160
		..accept We're Surrounded##26500
	step
		goto 29.7,68.8
		.kill 12 Stone Trogg Ambusher##43134+ |q 26500/1
		.' Use Stonefather's Banner next to Stone Hearth Defenders |use Stonefather's Banner##58884 |modelnpc Stonehearth Defender##43138+
		.' Grant the Stonefather's Boon 12 times |q 26499/1
	step
		goto 28.2,69.6
		.talk Earthbreaker Dolomite##43160
		..turnin We're Surrounded##26500
		..accept Thunder Stones##26502
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin Stonefather's Boon##26499
		..accept Sealing the Way##26501
	step
		goto 27.3,67.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Shrine |q 26501/4
	step
		goto 26.0,68.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Barracks |q 26501/3
	step
		goto 26.2,69.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Inn |q 26501/2
	step
		goto 27.3,70.1
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Armory |q 26501/1
		.click Thunder Stone##9722+
		.get 12 Thunder Stone |q 26502/1
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Sealing the Way##26501
		..accept Shatter Them!##26537
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..turnin Thunder Stones##26502
		..accept Fixer Upper##26564
	step
		goto 24.6,62.2
		.talk Earthmender Deepvein##43319
		..accept Battlefront Triage##26591
	step
		goto 23.9,60.3
		.' Use Deepvein's Patch Kit on Injured Earthens |use Deepvein's Patch Kit##58965 |modelnpc Injured Earthen##43233
		.' Patch up 10 Injured Earthen |q 26591/1
		.' Click Catapult Parts |tip They look kind of like big metal parts laying on the ground around this area.
		.get 6 Catapult Part |q 26564/1
		.from Stone Trogg Berserker##43228+, Stone Trogg Geomancer##43234+, Needlerock Rider##43250+
		.kill 12 Fractured Battlefront stone troggs |q 26537/1
		.' You can also look around 23.1,53.9 for more
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Shatter Them!##26537
	step
		goto 24.6,62.2
		.talk Earthmender Deepvein##43319
		..turnin Battlefront Triage##26591
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..turnin Fixer Upper##26564
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..accept Troggzor the Earthinator##26625
	step
		goto 22.6,56.9
		.from Troggzor the Earthinator##43456
		.get The Earthinator's Cudgel |q 26625/1
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Troggzor the Earthinator##26625
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..accept Rush Delivery##27126
	step
		goto 20.7,61.6
		.talk Peak Grindstone##45043
		..turnin Rush Delivery##27126
		..accept Close Escort##26632
	step
		goto 20.7,61.6
		.talk Peak Grindstone##45043
		..' Tell him you're ready to escort the catapult |tip You need to be near the catapult or it will stop
		.' Safely Escort the Earthen Catapult |q 26632/1
		|modelnpc Earthen Catapult##43509+
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Close Escort##26632
		..accept Keep Them off the Front##26755
	step
		goto 22.4,52.0
		.clicknpc Earthen Catapult##43509
		.' Use your Fire Catapult ability on your hotbar on the Stone Trogg and Fungal mobs
		.' Bombard 30 Reinforcements |q 26755/1
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Keep Them off the Front##26755
		..accept Reactivate the Constructs##26762
	step
		goto 22.8,52.1
		.talk Flint Oremantle##43898
		..accept Mystic Masters##26770
	step
		goto 22.6,47.6
		.clicknpc Deactivated War Construct##43984
		.' Reactivate 5 Deactivated War Constructs |q 26762/1
		.kill 5 Needlerock Mystic |q 26770/1
		.'|tip Activate the golems before attacking mystics.
	step
		goto 22.8,52.1
		.talk Flint Oremantle##43898
		..turnin Mystic Masters##26770
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Reactivate the Constructs##26762
		..accept Down Into the Chasm##26834
	step
		goto 27.6,44.8
		.talk Slate Quicksand##44143
		..turnin Down Into the Chasm##26834
		..accept Sprout No More##26791
		..accept Fungal Monstrosities##26792
	step
		goto 27.6,44.7
		.clicknpc War Guardian##44126
		.' Obtain a War Guardian for the Sprout No More quest |q 26791/1
		.' Obtain a War Guardian for the Fungal Monstrosities quest |q 26792/1
	step
		goto 26.8,41.8
		.kill 5 Fungal Monstrosity##44035+ |q 26792/2
		.clicknpc Giant Mushroom##44049+
		.' Destroy 5 Giant Mushrooms |q 26791/2
	step
		goto 27.6,44.8
		.talk Slate Quicksand##44143
		..turnin Sprout No More##26791
		..turnin Fungal Monstrosities##26792
		..accept A Slight Problem##26835
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin A Slight Problem##26835
		..accept Rescue the Stonefather... and Flint##26836
	step
		goto 24.5,31.1
		.from Bouldergut##44151
		.' Rescue Stonefather Oremantle |q 26836/1
		.|tip He is up high on an upper rock platform.
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Rescue the Stonefather... and Flint##26836
		..accept The Hero Returns##27937
	step
		goto 28.0,68.6
		.talk Stonefather Oremantle##44204
		..turnin The Hero Returns##27937
		..accept The Middle Fragment##27938
	step
		goto 28.0,68.7
		.click The Stonefather's Safe##7608
		.get The Middle Fragment of the World Pillar |q 27938/1
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..turnin The Middle Fragment##27938
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..accept The Very Earth Beneath Our Feet##26326
	step
		goto 46.1,45.6
		.talk Earthcaller Torunscar##42730
		..turnin The Very Earth Beneath Our Feet##26326
		..accept Crumbling Defenses##26312
		..accept On Even Ground##26314
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..accept Core of Our Troubles##26313
	step
		goto 44.3,43.7
		.from Irestone Rumbler##42780+
		.get Irestone Core##58168 |q 26313/1 |n
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Stormcaller Mylra |q 26312/2
		|modelnpc Servant of Therazane##42781+
	step
		goto 44.5,41.3
		.from Irestone Rumbler##42780+
		.get Irestone Core##58168 |q 26313/1 |n
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Tawn Winterbluff |q 26312/1
		|modelnpc Servant of Therazane##42781+
	step
		goto 47.6,42.8
		.from Irestone Rumbler##42780+
		.get Irestone Core##58168 |q 26313/1 |n
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Hargoth Dimblaze |q 26312/3
		|modelnpc Servant of Therazane##42781+
	step
		goto 46.2,42.2
		.from Irestone Rumbler##42780+
		.get 6 Irestone Core |q 26313/1
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Bring down 3 Servants of Therazane |q 26314/1
		|modelnpc Servant of Therazane##42781+
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..turnin Core of Our Troubles##26313
	step
		goto 46.1,45.6
		.talk Earthcaller Torunscar##42730
		..turnin Crumbling Defenses##26312
		..turnin On Even Ground##26314
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..accept Imposing Confrontation##26315
	step
		goto 49.2,40.1
		.' Use your Earthen Ring Proclamation on Boden the Imposing |use Earthen Ring Proclamation##58177 |tip He's a huge rock giant that walks around this area.
		.' Seek Peace with Boden the Imposing |q 26315/1
		|modelnpc Boden the Imposing##42471+
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..turnin Imposing Confrontation##26315
		..accept Rocky Relations##26328
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin Rocky Relations##26328
		..accept Hatred Runs Deep##26376
		..accept Unsolid Ground##26377
	step
		goto 56.5,41.0
		.talk Quartz Stonetender##42899
		..accept Loose Stones##26375
	step
		goto 60.2,39.4
		.kill Dragul Giantbutcher##42921 |q 26376/1
	step
		goto 59.5,41.5
		.click Jade Crystal Cluster##9694+
		.collect 6 Jade Crystal Cluster##58500 |q 26377
		.' Use your Delicate Chain Smasher next to Quartz Rocklings |use Delicate Chain Smasher##58254 |tip They look like small rock giants around this area.
		.' Release 6 Quartz Rocklings |q 26375/1
		|modelnpc Quartz Rockling##42900+
	step
		'Use the Jade Crystal Clusters |use Jade Crystal Cluster##58500
		.collect Jade Crystal Composite##58783 |q 26377
	step
		goto 59.6,41.4
		.' Use your Jade Crystal Composite |use Jade Crystal Composite##58783
		.' Lure an Agitated Tunneler |q 26377/1
	step
		goto 59.3,40.6
		.from Twilight Laborer##42924+, Twilight Priestess##42823+, Twilight Duskwarden##42917+
		.kill 12 Lorthuna's Gate Cultists |q 26376/2
	step
		goto 56.5,41.0
		.talk Quartz Stonetender##42899
		..turnin Loose Stones##26375
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin Hatred Runs Deep##26376
		..turnin Unsolid Ground##26377
		..accept Violent Gale##26426
	step
		goto 51.7,31.6
		.' Get next to Felsen the Enduring
		.' Find Felsen the Enduring |q 26426/1
		' |modelnpc 43805
	step
		goto 58.4,25.7
		.' Fly to the mouth of this cave
		.' Find the entrance to the Crumbling Depths |q 26426/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Violent Gale##26426
		..accept Depth of the Depths##26869
	step
		goto 64.5,21.7 |n
		.' Enter the cave and follow the path |goto 64.5,21.7,0.5 |noway |c
		.|tip Watch out for the Colossal Gyreworm. It patrols around this cave in a circle, and if it hits you you'll get caught inside of it, take damage, and get dumped back at the beginning.
		.|tip As you're going around this first curve, if you don't have a speed boost there is a small side passage you can step into to avoid getting hit by the Colossal Gyreworm.
		|modelnpc Colossal Gyreworm##44258
	step
		goto 65.3,18.4 |n
		.' Follow the path |goto 65.3,18.4,0.5 |noway |c
	step
		goto 66.4,20.6
		.click Gigantic Painite Cluster##9815
		..turnin Depth of the Depths##26869
		..accept A Rock Amongst Many##26871
	step
		goto 64.3,23.5
		.' Follow the path to this spot, then jump down |goto 64.3,23.5,0.5 |noway |c
	step
		goto 58.3,25.5 |n
		.' Leave the cave |goto 58.3,25.5,0.5 |noway |c
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin A Rock Amongst Many##26871
		..accept Entrenched##26436
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Entrenched##26436
		..accept Intervention##26438
		..accept Making Things Crystal Clear##26437
	step
		goto 34.1,35.2
		.talk Berracite##43344
		..accept Putting the Pieces Together##26439
	step
		goto 30.5,46.8
		.from Jaspertip Borer##42524+, Jaspertip Swarmer##42521+, Jaspertip Ravager##42525+
		.kill 12 Jaspertip flayers |q 26438/1
		.click Chalky Crystal Formation##9715+
		.get 8 Chalky Crystal Formation |q 26437/1
		.clicknpc Dormant Stonebound Elemental##43115
		.' Reform 6 Stonebound Elementals |q 26439/1
		.|tip These look like broken rubble on the ground, like after you've killed a stone elemental.
		.' More of all of these can be found around [Deepholm,34.2,51.7]
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Intervention##26438
		..turnin Making Things Crystal Clear##26437
	step
		goto 34.1,35.2
		.talk Berracite##43344
		..turnin Putting the Pieces Together##26439
	step
		goto 34.4,34.3
		.talk Kor The Immovable##42469
		..accept Pebble##28869
	step
		'Next to you:
		.talk Pebble##43116
		..turnin Pebble##28869
		..accept Clingy##26440
	step
		goto 30.1,47.7
		.' Get next to the huge green crystals
		.|tip Protect Pebble.
		.' Bring Pebble to the crystal formation |q 26440/1
	step
		'Next to you:
		.talk Pebble##43116
		..turnin Clingy##26440
		..accept So Big, So Round...##26441
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin So Big, So Round...##26441
		..accept Petrified Delicacies##26507
		..accept Rock Bottom##26575
	step
		goto 47.6,26.8
		.kill Gorgonite##43339 |q 26575/1
	step
		goto 47.5,26.8
		.clicknpc Petrified Stone Bat##43182+
		.get 12 Petrified Stone Bat |q 26507/1
		.|tip They look like little black bats laying on the ground around this area. Basiliks around this area may drop them as well.
		.' PS: there's more over here [Deepholm,44,26.2]
	step
		'Next to you:
		.talk Pebble##43116
		..turnin Petrified Delicacies##26507
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Rock Bottom##26575
		..accept Steady Hand##26576
		..accept Rocky Upheaval##26577
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..turnin Steady Hand##26576
		..accept Don't. Stop. Moving.##26656
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..' Tell him you are ready to escort a group of elementals across the open.
		.' Speak to Terrath the Steady |q 26656/1
	step
		goto 51.1,14.7
		.' Go to this spot
		.' Escort 5 Opalescent Guardians to safety |q 26656/2 |tip Run on the ground with your mount, don't fly or you the rock elementals will disappear when you get too far away from them.
		' |modelnpc 43591
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..turnin Don't. Stop. Moving.##26656
		..accept Hard Falls##26657
		..accept Fragile Values##26658
	step
		goto 35.4,22.5
		.from Stone Trogg Beast Tamer##43598 |tip He moves all around this area capturing basilisks, so you may need to look around a bit for him.
		.get Stonework Mallet |q 26658/1
	step
		goto 36.5,18.8
		.kill 6 Stone Drake##42522 |q 26657/1 |tip They will fall to the ground with half health, so you can kill them, even though they are elite.
	step
		goto 40.0,19.4
		.talk Terrath the Steady##42466
		..turnin Hard Falls##26657
		..turnin Fragile Values##26658
		..accept Resonating Blow##26659
	step
		goto 32.7,24.3
		.' Use your Stonework Mallet next to the Pale Resonating Crystal |use Stonework Mallet##60266
		.' Strike the Pale Resonating Crystal |q 26659/1
		.from Aeosera##43641 |tip Click the Boulder Platforms to jump from rock to rock while fighting Aeosera.  When she is casting her Searing Breath ability, jump to another rock and attack her while she is breathing fire to the other rock.  Repeat this until she surrenders.
		.' Defeat Aeosera |q 26659/2
		|model Pale Resonating Crystal##6415
	step
		goto 33.1,24.1
		.talk Terrath the Steady##42466
		..turnin Resonating Blow##26659
		.' If Terrath the Steady doesn't spawn at the appropriate spot, go to [40.0,19.4]
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Rocky Upheaval##26577
		..accept Doomshrooms##26578
		..accept Gone Soft##26579
		..accept Familiar Intruders##26580
	step
		goto 71.8,47.6
		.talk Windspeaker Lorvarius##43395
		..turnin Familiar Intruders##26580
		..accept A Head Full of Wind##26581
	step
		goto 73.6,40.8
		.kill 8 Fungal Behemoth##42475+ |q 26579/1
		.from Doomshroom##43388+
		.' Destroy 10 Doomshrooms |q 26578/1
		.' Gather a sample of the red mist |q 26581/1 |tip There are small clouds of red mist that float around on the ground around this area.  Walk into one of them to gather a sample.
		.' You will be able to find more Fungal Behemoths and Doomshrooms around [76.6,44.4]
	step
		goto 71.8,47.6
		.talk Windspeaker Lorvarius##43395
		..turnin A Head Full of Wind##26581
		..accept Unnatural Causes##26582
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Doomshrooms##26578
		..turnin Gone Soft##26579
		..turnin Unnatural Causes##26582
		..accept Shaken and Stirred##26584
		..accept Corruption Destruction##26585
	step
		goto 68.5,26.4
		.talk Ruberick##43442
		..accept Wrath of the Fungalmancer##26583
	step
		goto 68.6,29.1 |n
		.' Enter the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 69.8,31.9
		.talk Earthmender Norsala##43503
		..' Tell her you're ready when she is |q 26583/1
		.kill Fungalmancer Glop##43372 |q 26583/2 |tip Follow him each time he runs away.  Avoid the mushrooms as you walk, they will give you a debuff.  While fighting Fungalmancer Glop, avoid the Boomshrooms he creates.
	step
		goto 70.2,33.8 |n
		.' Follow the path up |goto 70.2,33.8,0.5 |noway |c
	step
		goto 68.6,29.1 |n
		.' Leave the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 68.5,26.3
		.talk Ruberick##43442
		..turnin Wrath of the Fungalmancer##26583
	step
		goto 69.4,24.8
		.kill 8 Verlok Pillartumbler##43513+ |q 26584/1
		.click Verlok Miracle-Grow##6895
		.get 8 Verlok Miracle-Grow |q 26585/1
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Shaken and Stirred##26584
		..turnin Corruption Destruction##26585
		..accept At the Stonemother's Call##26750
	step
		goto 56.3,12.2
		.talk Therazane##42465
		..turnin At the Stonemother's Call##26750
		..accept Audience with the Stonemother##26752
	step
		'Watch the dialogue
		.' Attend the Stonemother's Audience |q 26752/1
	step
		goto 56.1,13.5
		.talk Earthcaller Torunscar##43809
		..turnin Audience with the Stonemother##26752
		..accept Rallying the Earthen Ring##26827
	step
		ding 83
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..accept The Twilight Plot##27004
	step
		goto 47.3,51.4
		.talk Prospector Brewer##44802
		..accept Fly Over##27006
	step
		goto 39.0,74.2
		.' Go to this spot next to the big white portal
		.' Investigate the Master's Gate |q 27006/1
	step
		goto 40.1,72.2
		.from Twilight Cryptomancer##44855+, Twilight Crusher##44849+, Twilight Armsman##44847+
		.get Masters' Gate Plans |q 27004/1
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..turnin The Twilight Plot##27004
	step
		goto 47.3,51.4
		.talk Prospector Brewer##44802
		..turnin Fly Over##27006
		..accept Fight Fire and Water and Air with...##27042
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..accept Decryption Made Easy##27040
	step
		goto 40.8,66.3
		.from Bound Water Elemental##44886
		.' Acquire the Water Ward |q 27042/2
	step
		goto 36.0,67.4
		.from Bound Fire Elemental##44887
		.' Acquire the Fire Ward |q 27042/1
	step
		goto 40.5,72.4
		.from Bound Air Elemental##44885
		.' Acquire the Air Ward |q 27042/3
	step
		goto 40.2,67.5
		.click One-Time Decryption Engine##9842+
		.' Decrypt 6 Plans |q 27040/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Decryption Made Easy##27040
		..accept The Wrong Sequence##27058
	step
		goto 39.1,73.9
		.click the Waygate Controller##9849
		.' Destroy the Waygate |q 27058/1
	step
		goto 39.9,62.2
		.kill Haethen Kaul##44835 |q 27042/4 |tip He's up on a huge floating rock.
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..turnin The Wrong Sequence##27058
		..accept That's No Pyramid!##28292
	step
		goto 47.3,51.4
		.talk Prospector Brewer##44802
		..turnin Fight Fire and Water and Air with...##27042
	step
		goto 48.0,53.7
		.' Talk with Windspeaker Lorvarius, Yuldris Smolderfury, Tawn Winterbluff, Earthcaller Yevaa and Tharm Wildfire at the below locations:
		.' [48.5,50.1]
		.' [47.4,50.9]
		.' [48.1,49.9]
		..' Tell them you are joining an assault on Lorthuna's Gate and they are needed.
		.' Rally 5 Earthen Ring |q 26827/1
		' |modelnpc Windspeaker Lorvarius##43836+
		' |modelnpc Yuldris Smolderfury##45034+
		' |modelnpc Earthcaller Yevaa##44646+
		' |modelnpc Tawn Winterbluff##44634+
		' |modelnpc Tharm Wildfire##44631+
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Rallying the Earthen Ring##26827
		..accept Our Part of the Bargain##26828
	step
		goto 63.3,25.0
		.talk Therazane##44025
		..turnin Our Part of the Bargain##26828
		..accept The Stone March##26829
		..accept Therazane's Mercy##26832
	step
		goto 62.6,26.9
		.talk Boden the Imposing##44080
		..accept The Twilight Flight##26831
	step
		goto 62.4,31.8
		.from High Priestess Lorthuna##42914 |tip She is in a small room on the top of this building.  She is elite, but you can still kill her.  She will run away when she is almost dead.
		.' Defeat High Priestess Lorthuna |q 26832/2
	step
		goto 58.9,32.9
		.from Boldrich Stonerender##42923
		.' Defeat Boldrich Stonerender |q 26832/1
	step
		goto 63.1,38.1
		.from Zoltrik Drakebane##42918 |tip You will eventually get on a stone drake and fly after Zoltrik Drakebane.  You can use your Jump ability to jump onto his drake, if you are a melee class.  Either way, you will land on a rock with him and kill him there.
		.' Defeat Zoltrik Drakebane |q 26831/1
	step
		goto 64.1,36.9
		.talk Terrath the Steady##42614
		..turnin The Twilight Flight##26831
	step
		goto 60.3,33.2
		.from Defaced Earthrager##44076+, Twilight Soulreaper##42916+, Twilight Priestess##42823+
		.kill 15 Twilight Precipice Cultists |q 26829/1
	step
		goto 63.3,25.0
		.talk Therazane##44025
		..turnin The Stone March##26829
		..turnin Therazane's Mercy##26832
		..accept Word In Stone##26833
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43818
		..turnin Word In Stone##26833
		..accept Undying Twilight##26875
	step
		goto 50.7,49.6
		.kill 12 Twilight Invaders |q 26875/1
		.kill Desecrated Earthrager##44683 |q 26875/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Undying Twilight##26875
		..accept The Binding##26971
		' |modelnpc 44681
	step
		goto 49.6,52.9
		.kill High Priestess Lorthuna##43837 |q 26971/1
	step
		goto 49.6,52.9
		.talk Earthcaller Torunscar##43835
		..turnin The Binding##26971
]])

ZygorGuidesViewer:RegisterInclude("A_Vashj'ir_Leveling",[[
	step
		goto Stormwind City,62.9,71.6
		.click Hero's Call Board##10016
		..accept Hero's Call Vashj'ir##27724
	step
		'When you enter Stormwind City:
		.' You will automatically accept a quest
		..accept A Personal Summons##28825
	step
		goto Stormwind City,74.5,19.0
		.talk Naraat the Earthspeaker##45226
		..turnin A Personal Summons##28825
		..accept Eye of the Storm##28826
	step
		goto 74.4,19.5
		.click Waters of Farseeing##445
		.' Peer into the Waters of Farseeing |q 28826/1
	step
		goto 74.5,19.0
		.talk Naraat the Earthspeaker##45226
		..turnin Eye of the Storm##28826
	step
		goto 27.4,24.1
		.talk Recruiter Burns##36799
		..turnin Hero's Call Vashj'ir##27724
		..accept Call of Duty##14482
	step
		 goto 18.5,25.4 |n
		.' Ride the mercenary ship to Vashj'ir |q 14482/1 |tip Wait on the docks, it could take a little while for the boat to finally show up.
	step
		goto Kelp'thar Forest,45.2,23.4
		.talk Erunak Stonespeaker##36915
		..turnin Call of Duty##14482
		..accept Sea Legs##24432
	step
		goto 44.5,25.0
		.click Saltwater Stars##9991
		.get 3 Saltwater Starfish |q 24432/1
		.click Conch Shell##9440
		.get Conch Shell |q 24432/2
	step
		goto 45.2,23.4
		.talk Erunak Stonespeaker##36915
		..turnin Sea Legs##24432
		..accept Pay It Forward##25281
	step
		goto 44.3,27.6
		.' Use your Enchanted Conch on Drowning Warriors |use Enchanted Conch##52710
		.' Rescue 6 Drowning Soldiers |q 25281/1
		'|modelnpc Drowning Soldier##39663
	step
		goto 45.2,23.4
		.talk Erunak Stonespeaker##36915
		..turnin Pay It Forward##25281
		..accept Rest For the Weary##25405
	step
		goto 45.2,23.4
		.talk Erunak Stonespeaker##36915
		.home The Briny Cutter
	step
		goto 44.7,22.6
		.talk Captain Taylor##39887
		..turnin Rest For the Weary##25405
		..accept Buy Us Some Time##25357
		..accept Traveling on Our Stomachs##25546
	step
		 goto 43.7,25.6
		.from Splitclaw Skitterer##40685+
		.get 10 Succulent Crab Meat |q 25546/1
	step
		goto 48.7,27.4
		.kill 8 Zin'jatar Raider##39313+ |q 25357/1
	step
		goto 44.7,22.6
		.talk Captain Taylor##39887
		..turnin Buy Us Some Time##25357
		..turnin Traveling on Our Stomachs##25546
		..accept To Arms!##25545
		..accept Stormwind Elite Aquatic and Land Forces##25564
	step
		goto 49.1,21.4
		.from Slitherfin Eel##40855
		..accept Once More, With Eeling##27729 |tip This quest will automatically be accepted after you kill an eel.
	step
		goto 48.0,20.9
		.click Stormwind Breastplates##4074
		.get 5 Stormwind Breastplate |q 25545/1
		.click Stormwind Helm##9486
		.get 5 Stormwind Helm |q 25545/2
		.click Stormwind Spear##9494
		.get 5 Stormwind Spear |q 25545/3
		.from Gilblin Scavenger##40811+
		.get 5 Stormwind Shield |q 25545/4
		.click the Stormwind S.E.A.L. Equipment##9280
		.get 6 Stormwind S.E.A.L. Equipment |q 25564/1
		.from Slitherfin Eel##40855+
		.' Justifiably Slay 8 Disgusting Eels |q 27729/1
	step
		'Click the Quest Completion box that pops up
		..turnin Once More, With Eeling##27729
	step
		goto 44.7,22.6
		.talk Captain Taylor##39887
		..turnin To Arms!##25545
		..turnin Stormwind Elite Aquatic and Land Forces##25564
		..accept On Our Own Terms##25547
	step
		goto 45.0,23.5
		.talk Captain Taylor##40690
		..turnin On Our Own Terms##25547
		..accept All or Nothing##25558
	step
		goto 44.4,24.6
		.' Follow the troops out and help them defend the Briny Cutter from the waves of nagas
		.' Swim over to [46.4,46.5] after you get kidnapped
		.' Defense of The Briny Gutter Complete |q 25558/1
	step
		goto 46.3,46.9
		.talk Erunak Stonespeaker##40105
		..turnin All or Nothing##25558
	step
		goto 46.0,46.9
		.talk Moanah Stormhoof##41248
		..accept Better Late Than Dead##25477
	step
		goto 54.2,53.0
		.' Use Moanah's Baitstick on a Speckled Sea Turtle |use Moanah's Baitstick##54462 |modelnpc Speckled Sea Turtle##40223
		.' Start swimming back to Moanah Stormhoof at [46.0,46.9]
		.' Mount the Sea Turtle |q 25477/1
	step
		goto 46.0,46.9
		.talk Moanah Stormhoof##41248
		..turnin Better Late Than Dead##25477
		..accept The Abyssal Ride##25371
	step
		goto 45.4,46.6
		.click Braided Rope##7548
		..' Tie your lure off and let it loose
		.' Tie off the Seahorse lure |q 25371/1
		.clicknpc Abyssal Seahorse##39629 |invehicle
	step
		'Use the abilities on your action bar and follow the on screen instructions to hold onto the seahorse
		.' Subdue an Abyssal Seahorse |q 25371/2
	step
		goto 46.0,46.9
		.talk Moanah Stormhoof##41248
		..turnin The Abyssal Ride##25371
	step
		.learnmount Subdued Abyssal Seahorse##75207 |use Subdued Abyssal Seahorse##54465
	step
		goto 46.6,46.8
		.talk Rendel Firetongue##41252
		..accept Good Deed Left Undone##27685
	step
		goto 53.5,43.0
		.talk Adarrah##39667
		..turnin Good Deed Left Undone##27685
		..accept Gimme Shelter!##25587
	step
		goto 54.4,33.7 |n
		.' Enter the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 56.8,29.8
		.' Go to this spot
		.' Scout Smuggler's Hole |q 25587/1
	step
		goto 54.4,33.7 |n
		.' Leave the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 54.0,34.6
		.' Go to this spot
		.' Signal Adarrah |q 25587/2
	step
		goto 54.4,33.7 |n
		.' Enter the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 57.1,28.8
		.talk Adarrah##39883
		..turnin Gimme Shelter!##25587
		..accept Ain't Too Proud to Beg##25598
	step
		goto 54.4,33.7 |n
		.' Leave the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 48.3,39.6
		.talk Captain Samir##39669
		..' Tell him to make for that cave to the west
		.' Rescue Mack and Samir |q 25598/1
	step
		goto 49.7,40.9
		.click Sunken Crate##336
		..accept A Case of Crabs##25388
	step
		goto 54.4,33.7 |n
		.' Enter the cave |goto 54.4,33.7,0.5 |noway |c |travelfor 2
	step
		goto 57.1,28.8
		.talk Adarrah##39883
		..turnin Ain't Too Proud to Beg##25598
		..turnin A Case of Crabs##25388
		..accept A Girl's Best Friend##25390
		..accept A Taste For Tail##25389
	step
		goto 57.3,28.9
		.talk Captain Samir##39884
		..accept Can't Start a Fire Without a Spark##25602
	step
		goto 54.4,33.7 |n
		.' Leave the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 49.7,38.4
		.from Clacksnap Pincer##39918+
		.get 4 Clacksnap Tail |q 25389/1
		.collect Tattered Treasure Map##53053 |n
		.' Use your Tattered Treasure Map in your bags |use Tattered Treasure Map##53053
		..accept The Horde's Hoard##25377
		.click Adarrah's Jewelry Boxe##1+
		.get 6 Adarrah's Keepsake |q 25390/1
	step
		goto 55.5,38.8
		.click Keg of Gunpowder##472
		.get Keg of Gunpowder |q 25602/1
	step
		goto 57.2,37.8
		.from Akasha##39964
		.get Horde Chest Key |q 25377/1
	step
		goto 57.8,35.2
		.click Sunken Horde Chest##9281
		..turnin The Horde's Hoard##25377
	step
		goto 54.4,33.7 |n
		.' Enter the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 57.1,28.8
		.talk Adarrah##39883
		..turnin A Girl's Best Friend##25390
		..turnin A Taste For Tail##25389
	step
		goto 57.3,28.9
		.talk Captain Samir##39884
		..turnin Can't Start a Fire Without a Spark##25602
	step
		goto 57.1,28.8
		.talk Adarrah##39883
		..accept Ophidophobia##25459
	step
		goto 57.3,29.3
		.talk Mack Fearsen##40983
		..accept Nerve Tonic##25358
	step
		goto 54.4,33.7 |n
		.' Leave the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 55.3,38.9
		.talk Budd##46338
		..accept Oh, the Insanity!##25651
	step
		goto 56.8,36.3
		.from Brinescale Serpent##39948+
		.' Slay 4 Brinescale Serpent |q 25459/1
		.click Sunken Cargo##7539
		.get 5 Sunken Cargo |q 25358/1
	step
		goto 52.1,51.5
		.from Gilblin Hoarder##41016+
		.click Pilfered Cannonball##4177+
		.collect 50 Pilfered Cannonball##55185 |n
		.' Use your Pilfered Cannonballs |use Pilfered Cannonball##55185
		.get Barrel of Gunpowder |q 25651/1
	step
		goto 55.3,38.9
		.talk Budd##46338
		..turnin Oh, the Insanity!##25651
		..accept Dah, Nunt.. Dah, Nunt..##25657
	step
		goto 54.4,33.7 |n
		.' Enter the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 57.3,29.3
		.talk Mack Fearsen##40983
		..turnin Nerve Tonic##25358
	step
		goto 57.1,28.8
		.talk Adarrah##39883
		..turnin Ophidophobia##25459
	step
		goto 56.4,30.1
		.click Broken Bottle##238
		..accept A Desperate Plea##25638
	step
		goto 54.4,33.7 |n
		.' Leave the cave |goto 54.4,33.7,0.5 |noway |c
	step
		goto 46.3,46.9
		.talk Erunak Stonespeaker##40105
		..turnin A Desperate Plea##25638
		..accept Undersea Sanctuary##25794
	step
		'Use Erunak's Scrying Orb |use Erunak's Scrying Orb##56020 |q 25794/1
	step
		goto 46.3,46.9
		.talk Erunak Stonespeaker##40105
		..turnin Undersea Sanctuary##25794
		..accept Spelunking##25812
	step
		goto 58.3,48.8
		.' Use your Booby-Trapped Bait next to the Rusty Harpoon Gun |use Booby-Trapped Bait##55190
		.' Feed the Explosive Grub to Gnaws |q 25657/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Dah, Nunt... Dah, Nunt...##25657
		..accept Shark Weak##27699
	step
		goto 58.4,50.1
		.click Gnaws' Tooth##9517
		.get 5 Gnaws' Tooth |q 27699/1
	step
		goto 55.3,38.9
		.talk Budd##46338
		..turnin Shark Weak##27699
		..accept DUN-dun-DUN-dun-DUN-dun##25670
	step
		goto 58.3,48.8
		.' Use your Budd's Chain next to the Rusty Harpoon Gun |use Budd's Chain##55220
		.' While in Gnaws' mouth, spam the ability on your hotbar |tip A huge harpoon will eventually shoot into Gnaws.  Once that happens, you can stop spamming the ability.
		.' Slay Gnaws |q 25670/1
	step
		goto 61.5,63.4 |n
		.' Enter the cave |goto 61.5,63.4,0.5 |noway |c
	step
		goto 64.0,59.8
		.talk Private Pollard##41324
		..turnin Spelunking##25812
	step
		goto 63.9,59.9
		.talk Erunak Stonespeaker##41341
		..accept Debriefing##25824
	step
		goto 64.0,59.8
		.talk Private Pollard##41340
		..' Ask him who he is
		.' Debrief Private Pollard |q 25824/1
	step
		goto 63.9,59.9
		.talk Erunak Stonespeaker##41341
		..turnin Debriefing##25824
		..accept Wake of Destruction##25887
	step
		goto 58.4,48.7
		.talk Budd##46458
		..turnin DUN-dun-DUN-dun-DUN-dun##25670
		..accept A Bone to Pick##25732
	step
		goto 53.6,58.0
		.from King Gurboggle##41018
		.get The Pewter Pounder |q 25732/1
	step
		goto 58.4,48.7
		.talk Budd##46458
		..turnin A Bone to Pick##25732
		..accept Decisions, Decisions##25743
	step
		'Use The Pewter Pounder |use The Pewter Pounder##55806
		.' Destroy The Pewter Prophet |q 25743/1
	step
		goto 58.4,48.6
		.talk Budd##46463
		..turnin Decisions, Decisions##25743
	step
		goto 58.7,72.4
		.' Use your Orb of Suggestion on a Famished Great Shark |use Orb of Suggestion##56576
		.' Take control of a Famished Great Shark |invehicle |q 25887
	step
		goto 57.5,72.4
		.' Use the Eat Naga ability on your hotbar repeatedly near Zin'jatar Guardians |tip They are nagas all around this area.
		.' Eat 10 Zin'jatar Guardians Alive |q 25887/1
		.' Use the Return to Safety ability on your hotbar
		.' Go back to the Deepmist Grotto |outvehicle |q 25887
		' |modelnpc 41481
	step
		goto 61.1,63.9 |n
		.' Enter the cave |goto 61.1,63.9,0.5 |noway |c
	step
		goto 63.9,59.9
		.talk Erunak Stonespeaker##41341
		..turnin Wake of Destruction##25887
	step
		goto 63.9,59.9
		.talk Erunak Stonespeaker##41341
		.home Deepmist Grotto
	step
		goto 64.0,59.8
		.talk Private Pollard##41340
		..accept What? What? In My Gut...?##25885
	step
		goto 63.9,59.4
		.talk Moanah Stormhoof##41347
		..accept Decompression##25888
	step
		goto 64.2,59.9
		.talk Rendel Firetongue##41344
		..accept Come Hell or High Water##25884
	step
		goto 61.1,63.9 |n
		.' Leave the cave |goto 61.1,63.9,0.5 |noway |c
	step
		goto 60.3,69.9
		.click Naga Tridents##9552+
		..accept How Disarming##25883
	step
		goto 57.7,75.4
		.' Swim around on all 3 layers of the naga Holding Pens
		.from Zin'jatar Guardian##41996+, Zin'jatar Pearlbinder##41477+, Zin'jatar Overseer##41549+, Zin'jatar Warden##41530
		.' Slay 12 Zin'jatar Naga |q 25884/1
		.get 7 Wiggleweed Sprout |q 25885/1
		.' Use your Breathstone on Imprisoned Soldiers |use Breathstone##56169 |tip They looks like dead humans in big balls of light all around on the naga Holding Pens.
		.' Release 10 Imprisoned Soldiers |q 25888/1
		.click Naga Tridents##9552
		.' Destroy 6 Naga Weapons |q 25883/1
	step
		'Click the Quest Complete box that pops up
		..turnin Come Hell or High Water##25884
		..accept The Warden's Time##27708
	step
		'Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin How Disarming##25883
	step
		goto 60.1,81.2
		.kill Zin'jatar Warden##41530 |q 27708/1
	step
		goto 63.9,59.9
		.talk Erunak Stonespeaker##41341
		..turnin The Warden's Time##27708
		..accept Across the Great Divide##25471
	step
		goto 64.0,59.8
		.talk Private Pollard##41340
		..turnin What? What? In My Gut...?##25885
	step
		goto 63.9,59.4
		.talk Moanah Stormhoof##41347
		..turnin Decompression##25888
	step
		goto 48.3,72.5 |n
		.' Enter the cave |goto 48.3,72.5,0.5 |noway |c
	step
		goto Shimmering Expanse,56.0,13.7
		.talk Farseer Gadra##39226
		..turnin Across the Great Divide##25471
		..accept The Looming Threat##25334
	step
		goto 56.0,13.7
		.talk Farseer Gadra##39226
		..' Tell him you are ready to join him in the vision
		.' Share in Farseer Gadra's Spirit Vision |q 25334/1
	step
		goto Abyssal Depths,72.9,37.4
		.talk Spirit of Farseer Gadra##40398
		..turnin The Looming Threat##25334
	step
		goto Shimmering Expanse,56.0,13.7
		.talk Farseer Gadra##39226
		..accept Backed Into a Corner##25164
	step
		goto 56.0,13.7
		.from Zin'jatar Fathom-Stalker##40162+
		.' Fend Off the Naga Attack |q 25164/1 |tip You have to kill 50 nagas.
		.kill Fathom-Lord Zin'jatar##40510 |q 25164/2
	step
		goto 56.0,13.7
		.talk Farseer Gadra##39226
		..turnin Backed Into a Corner##25164
	step
		goto 55.5,12.5
		.talk Toshe Chaosrender##39877
		..accept Rundown##25221
	step
		goto 54.0,23.4
		.' Follow the path outside the cave
		.' Use Toshe's Hunting Spears near Fleeing Zin'jatar Fathom-Stalkers |use Toshe's Hunting Spears##54466
		.kill 20 Fleeing Zin'jatar Fathom-Stalker##40174 |q 25221/1
	step
		goto 53.3,33.1
		.talk Toshe Chaosrender##39877
		..turnin Rundown##25221
		..accept Silver Tide Hollow##25222
	step
		goto 50.1,39.1 |n
		.' Enter the cave |goto 50.1,39.1,0.5 |noway |c
	step
		goto 49.5,42.4
		.talk Felora Firewreath##39876
		..turnin Silver Tide Hollow##25222
		..accept A Distracting Scent##25215
		..accept The Great Sambino##25216
	step
		goto 49.2,42.6
		.talk Earthmender Duarn##39875
		..accept Don't be Shellfish##25219
	step
		goto 49.1,42.0
		.talk Caretaker Movra##39878
		..accept Slippery Threat##25220
	step
		goto 49.1,42.0
		.talk Caretaker Movra##39878
		.home Silver Tide Hollow
	step
		goto 50.3,41.1
		.clicknpc Dead Zin'jatar Raider##39911+
		.' Bring them to [50.8,45.9] |tip You have to drag them one at a time.
		.' Dispose of 3 Dead Zin'jatar Raiders |q 25215/1
	step
		goto 59.6,40.1
		.kill 12 Spiketooth Eel##40237+ |q 25220/1
		.clicknpc Coilshell Sifter##39422+
		.get 10 Coilshell Sifter |q 25219/1
	step
		goto 50.1,39.1 |n
		.' Enter the cave |goto 50.1,39.1,0.5 |noway |c
	step
		goto 49.5,42.4
		.talk Felora Firewreath##39876
		..turnin A Distracting Scent##25215
	step
		goto 49.2,42.6
		.talk Earthmender Duarn##39875
		..turnin Don't be Shellfish##25219
	step
		goto 49.1,42.0
		.talk Caretaker Movra##39878
		..turnin Slippery Threat##25220
	step
		goto 41.3,34.2
		.talk The Great Sambino##39882
		..turnin The Great Sambino##25216
		..accept Undersea Inflation##25218
	step
		goto 41.1,34.2
		.talk Felice##40227
		..accept Crabby Patrons##25360
	step
		goto 40.5,35.5
		.' Use Sambino's Air Balloon next to the bubbling objects |use Sambino's Air Balloon##54608 |tip They look like green bubbling watermelon looking plants with a holes in the tops of them, and big blue bubbling snail shells.  You'll have to do this 10 times.
		.' Fill Sambino's Air Balloon |q 25218/1
		.kill 10 Green Sand Crab##40238 |q 25360/1
		.get Sambino's Air Valve |q 25218/2
		' |modelnpc 40399
	step
		goto 41.3,34.2
		.talk The Great Sambino##39882
		..turnin Undersea Inflation##25218
		..accept Totem Modification##25217
	step
		goto 41.2,34.2
		.talk Felice##40227
		..turnin Crabby Patrons##25360
	step
		goto 42.7,34.0
		.' Use one of Sambino's Modified Totems while standing on an orange spot on the ground: |tip You will only get one of the four totems to use, it's random.
		.' Use Sambino's Modified Stoneclaw Totem |use Sambino's Modified Stoneclaw Totem##54214
		.' Use Sambino's Modified Earthbind Totem |use Sambino's Modified Earthbind Totem##53052
		.' Use Sambino's Modified Stoneskin Totem |use Sambino's Modified Stoneskin Totem##54217
		.' Use Sambino's Modified Strength of Earth Totem |use Sambino's Modified Strength of Earth Totem##54216
		.' Defend Sambino's Modified Totem
		.' Take a Drill Sample |q 25217/1
	step
		goto 41.3,34.2
		.talk The Great Sambino##39882
		..turnin Totem Modification##25217
		..accept Back in One Piece##25456
	step
		goto 50.1,39.0 |n
		.' Enter Silver Tide Hollow |goto 50.1,39.0,0.5 |noway |c
	step
		goto 49.6,42.1
		.talk Felora Firewreath##39876
		..turnin Back in One Piece##25456
		..accept Toshe's Vengeance##25359
	step
		goto 64.1,42.3
		.talk Toshe Chaosrender##40221
		..turnin Toshe's Vengeance##25359
		..accept Vengeful Heart##25439
		..accept Vortex##25441
	step
		goto 65.8,43.1
		.' Use your Globes of Tumultuous Water near Swarming Serpents |use Globes of Tumultuous Water##54785
		.' Trap 30 Swarming Serpents |q 25441/1
		.kill 10 Zin'jatar Ravager##40275+ |q 25439/1
		' |modelnpc 40280
	step
		goto 64.1,42.3
		.talk Toshe Chaosrender##40221
		..turnin Vengeful Heart##25439
		..accept Fathom-Lord Zin'jatar##25440
		..turnin Vortex##25441
	step
		goto 67.3,49.7
		.kill Fathom-Lord Zin'jatar##40510 |q 25440/1
		.collect 1 Luminescent Pearl##54614 |n
		.' Click the Luminescent Pearl in your bags |use Luminescent Pearl##54614
		..accept A Pearl of Wisdom##25442
	step
		goto 64.1,42.3
		.talk Toshe Chaosrender##40221
		..turnin Fathom-Lord Zin'jatar##25440
	step
		goto 49.2,42.6
		.talk Earthmender Duarn##39875
		..turnin A Pearl of Wisdom##25442
		..accept Nespirah##25890
	step
		goto Shimmering Expanse/0 49.5,41.3
		.talk Swift Seahorse##40873
		.' Tell him you need to go to Nespirah.
		|confirm |q 25890
	step
		'Run up the spiral ramp and follow Earthmender Duarn around after he spawns: |modelnpc Earthmender Duarn##41532
		.' Find a way to communicate with Nespirah |q 25890/1
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..turnin Nespirah##25890
		..accept Making Contact##25900
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..' Tell him whenever he's ready
		.' Observe as Earthmender Duarn attempts to communicate with Nespirah |q 25900/1
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..turnin Making Contact##25900
		..accept Slave Labor##25907
		..accept Stick it to Them##25908
	step
		goto 54.6,50.6
		.kill 7 Idra'kess Sentinel##41466 |q 25908/1
		.kill 7 Idra'kess Enchantress##41467 |q 25908/2
		.' Use Duarn's Rope near Enslaved Alliance and Horde Pearl Miners |use Duarn's Rope##56178 |tip They are in the trenches with the huge pearls.
		.' Rescue 8 Pearl Miners |q 25907/1
		|modelnpc Enslaved Alliance Pearl Miner##41494
		|modelnpc Enslaved Horde Pearl Miner##41495
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..turnin Slave Labor##25907
		..turnin Stick it to Them##25908
		..accept Capture the Crab##25909
	step
		 goto 54.7,62.2
		.' Use Duarn's Net on the Deepseeker Crab |use Duarn's Net##56184 |tip The Deepseeker Crab is the pet of the Idra'kess Harpooner.
		.clicknpc Deepseeker Crab##41520
		.get Deepseeker Crab |q 25909/1
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..turnin Capture the Crab##25909
		..accept Breaking Through##25916
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..' Tell him let's speak with Nespirah
		.' Speak with Earthmender Duarn |q 25916/1
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..turnin Breaking Through##25916
		..accept We Are Not Alone##25917
	step
		goto 62.7,49.9
		.talk Captain Taylor##41540
		..turnin We Are Not Alone##25917
		..accept Body Blows##25919
	step
		goto 62.7,50.0
		.talk Admiral Dvorek##41541
		..accept Hopelessly Gearless##25918
	step
		goto 62.7,50.5
		.talk Wavespeaker Valoren##41802
		..accept Still Valuable##25920
	step
		goto 62.6,54.2
		.from Idra'kess Warlord##41607+, Idra'kess Prophet##41608+
		.get 5 Mysterious Pearl |q 25920/1
		.click Idra'kess Weapon Rack##9557 +
		.get 4 Purloined Polearm |q 25918/1
		.' Attack 7 Nespirah Abscesses |q 25919/1
		' |model Nespirah Abcess##9547
	step
		goto 62.7,49.9
		.talk Captain Taylor##41540
		..turnin Body Blows##25919
	step
		goto 62.7,50.0
		.talk Admiral Dvorek##41541
		..turnin Hopelessly Gearless##25918
	step
		goto 62.7,50.5
		.talk Wavespeaker Valoren##41802
		..turnin Still Valuable##25920
	step
		goto 62.7,49.9
		.talk Captain Taylor##41540
		..accept Overseer Idra'kess##25921
	step
		goto 62.9,56.8 |n
		.' Follow the path up |goto 62.9,56.8,0.5 |noway |c
	step
		goto 57.4,56.3
		.kill Overseer Idra'kess##41731 |q 25921/1 |tip Kill the Idra'kess Mistresses when instructed to.
		|modelnpc Idra'kess Mistress##41795
	step
		goto 60.2,52.8 |n
		.' Follow the path down |goto 60.2,52.8,0.5 |noway |c
	step
		goto 51.6,52.2
		.talk Earthmender Duarn##41531
		..turnin Overseer Idra'kess##25921
		..accept Waking the Beast##25922
		.' Listen as Duarn speaks to Nespirah |q 25922/1
	step
		goto 50.3,55.4
		.' Follow Erunak Stonespeaker when he runs away
		.clicknpc Swiftfin Seahorse##41776
		.' Escape on Erunak's Seahorse |q 25922/2
	step
		goto 49.2,57.0
		.talk Captain Taylor##40642
		..turnin Waking the Beast##25922
		..accept Cold Welcome##25536
	step
		goto 49.5,57.6
		.talk Wavespeaker Valoren##39881
		..accept A Powerful Need To Eat##25535
	step
		goto 49.7,57.4
		.talk Anissa Matherly##42873
		.home Tranquil Wash
	step
		goto 46.9,57.5 |n
		.' Leave the cave |goto 46.9,57.5,0.5 |noway |c
	step
		goto 49.0,49.1
		.talk Divemaster Birmingham##40641
		..turnin A Powerful Need To Eat##25535
		..accept Clamming Up##25539
	step
		goto 49.0,49.2
		.talk Engineer Hexascrub##40639
		..accept Art of Attraction##25537
	step
		goto 43.8,47.9
		.kill 10 Glimmerdeep Tidehunter##39664+ |q 25536/1
		.click Glimmerdeep Clam##261
		.get 16 Glimmerdeep Clam |q 25539/1
		.' Use the Anenmone Chemical Extraction Device on the Anemones |use Anenmone Chemical Extraction Device##54840 |tip They look like huge brown spiked flower shaped plants that leak red mist on the walls around this area.
		.' Gather 8 Anemone Chemicals |q 25537/1
	step
		goto 49.0,49.1
		.talk Divemaster Birmingham##40641
		..turnin Clamming Up##25539
	step
		goto 49.0,49.2
		.talk Engineer Hexascrub##40639
		..turnin Art of Attraction##25537
		..accept Odor Coater##25538
	step
		goto 49.0,52.9
		.' Use Anemone Chemical Application Device on Clam Divers |use Anemone Chemical Application Device##54851
		.' Odorify 8 Clam Divers |q 25538/1
	step
		goto 49.0,49.2
		.talk Engineer Hexascrub##40639
		..turnin Odor Coater##25538
	step
		goto 49.0,49.1
		.talk Divemaster Birmingham##40641
		..accept Bellies Await##25540
	step
		goto 46.9,57.5
		.' Swim down under the big stone slab and into the small cove
		.' Enter the cave |goto 46.9,57.5,0.5 |noway |c |q 25536
	step
		goto 49.2,57.0
		.talk Captain Taylor##40642
		..turnin Cold Welcome##25536
	step
		goto 49.5,57.6
		.talk Wavespeaker Valoren##39881
		..turnin Bellies Await##25540
	step
		goto 49.7,57.1
		.talk Levla Dreamwaker##40644
		..accept An Occupation of Time##25581
	step
		goto 49.2,57.0
		.talk Admiral Dvorek##40643
		..accept A Better Vantage##25582
		..accept Caught Off-Guard##25579
	step
		goto 49.2,57.0
		.talk Captain Taylor##40642
		..accept Swift Approach##25580
	step
		goto 46.9,57.5 |n
		.' Leave the cave |goto 46.9,57.5,0.5 |noway |c
	step
		goto 40.5,74.4
		.' Go to this spot in the ruins
		.' Scout the Structures South of Quel'Dormir Gardens |q 25582/3
	step
		goto 40.5,75.5
		.click Enormous Skull##9394
		..accept Upon the Scene of Battle##25583
	step
		goto 39.7,67.7
		.click Ranger Valarian##3412
		.' Read the Ranger Valarian Statue |q 25581/3
	step
		goto 38.5,66.0
		.click High Priestess Siralen##3412
		.' Read the High Priestess Siralen Statue |q 25581/4
	step
		goto 35.5,62.9
		.' Go to this spot in the ruins
		.' Scout the Tunnel West of Quel'Dormir Gardens |q 25582/2
	step
		goto 38.6,59.0
		.click the Queen Azshara##3412
		.' Read the Queen Azshara Statue |q 25581/2
	step
		goto 39.7,59.0
		.click the Lestharia Vashj##3412
		.' Read the Lestharia Vashj Statue |q 25581/1
	step
		goto 39.2,57.9
		.' Go to this spot in the ruins
		.' Scout the Northern Quel'Dormir Gardens |q 25582/1
	step
		goto 41.6,61.9
		.from Azsh'ir Monitor##40877+
		.' Destroy 8 Azsh'ir Monitor |q 25580/1
		.kill 12 Azsh'ir Patroller##39638 |q 25579/1
		.collect 1 Ancient Elven Etching##62281 |n |tip You will need to kill the Azsh'ir Mobs until you get this to drop.
		.' Click the Ancient Elven Etching in your bags |use Ancient Elven Etching##62281
		..accept Piece of the Past##27716
	step
		goto 49.7,57.1
		.talk Levla Dreamwaker##40644
		..turnin An Occupation of Time##25581
		..turnin Piece of the Past##27716
	step
		goto 49.2,57.0
		.talk Captain Taylor##40642
		..turnin Swift Approach##25580
	step
		goto 49.2,57.0
		.talk Admiral Dvorek##40643
		..turnin A Better Vantage##25582
		..turnin Caught Off-Guard##25579
		..turnin Upon the Scene of Battle##25583
	step
		goto 49.2,57.0
		.talk Wavespeaker Valoren##39881
		..accept Visions of the Past: The Invasion of Vashj'ir##25760
	step
		goto 46.9,57.5 |n
		.' Leave the cave |goto 46.9,57.5,0.5 |noway |c
	step
		goto 40.5,75.5
		.' Use your Blade of the Naz'jar Battlemaiden next to the Vision of the Battlemaiden |use Blade of the Naz'jar Battlemaiden##55171 |tip It's a bright flashing light on the ground in the ruins.
		.' Become a Naz'jar Battlemaiden
		.talk Fathom-Stalker Azjentus##40978
		..accept Reoccupation##25619
	step
		goto 40.5,73.5
		.' Use the abilities on your hotbar
		.from Kvaldir Deepwalker##41107+, Kvaldir Marauder##39602+
		.' Slay 10 Kvaldir Defenders |q 25619/1
	step
		goto 40.6,75.3
		.talk Fathom-Stalker Azjentus##40978
		..turnin Reoccupation##25619
		..accept The Revered Lady##25620
	step
		goto 39.4,59.0
		.talk Lady Naz'jar##40640
		..turnin The Revered Lady##25620
		..accept To the Fathom-Lord's Call##25637
	step
		goto 39.0,58.6
		.talk Sira'kess Tide Priestess##41050
		..accept Built to Last##25658
	step
		goto 35.5,67.5
		.' Go to the top level of the ruins
		.from Kvaldir Pillager##41102+, Kvladir Plunderer##41108+, Kvaldir Wasteroamer##41106+
		.' Slay 16 Kvladir Invaders on the Terrace |q 25637/1
		.click Nar'shola Ward##6913+
		.' Activate 6 Nar'shola Wards |q 25658/1
	step
		goto 39.0,58.6
		.talk Sira'kess Tide Priestess##41050
		..turnin Built to Last##25658
	step
		goto 36.4,78.7
		.talk Fathom-Lord Zin'jatar##41049
		..turnin To the Fathom-Lord's Call##25637
		..accept Not Soon Forgotten##25659
	step
		goto 28.6,78.6
		.kill Varkul the Unrelenting##41115 |q 25659/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Not Soon Forgotten##25659
	step
		goto 40.6,75.1
		.talk Wavespeaker Valoren##39881
		..turnin Visions of the Past: The Invasion of Vashj'ir##25760
		..accept Looking Forward##25747
	step
		goto 40.6,75.0
		.clicknpc Tamed Seahorse##48836
		.' You will ride to the Ruins of Vashj'ir |goto 33.1,68.9,0.5 |noway |c |q 25747
	step
		goto 33.0,67.9
		.talk Admiral Dvorek##40643
		..turnin Looking Forward##25747
		..accept Clear Goals##25748
	step
		goto 33.2,68.4
		.talk Captain Taylor##40642
		..accept Not Entirely Unprepared##25749
	step
		goto 32.9,69.2
		.talk Engineer Hexascrub##40639
		..accept Properly Inspired##25751
	step
		goto 33.0,74.2
		.' Use your Box of Crossbow Bolts on Alliance Lookouts |use Box of Crossbow Bolts##56247 |tip They look like Alliance mobs either standing or on sea horses around this area with crossbows.
		.' Restock 8 Alliance Lookouts |q 25749/1
		.click Bloated Kelp Bulb##9535
		.get 8 Bloated Kelp Bulb |q 25751/1
		|modelnpc Alliance Lookout##46470
	step
		goto 27.0,79.0
		.from Azsh'ir Abyss Priestess##42453+, Azsh'ir Infantry##41227+, Naz'jar Serpent Guard##41228+
		.' Slay 10 Southern Naga Forces |q 25748/1
	step
		goto 32.9,69.2
		.talk Engineer Hexascrub##40639
		..turnin Properly Inspired##25751
	step
		goto 33.2,68.4
		.talk Captain Taylor##40642
		..turnin Not Entirely Unprepared##25749
	step
		goto 33.0,67.9
		.talk Admiral Dvorek##40643
		..turnin Clear Goals##25748
		..accept Swift Action##25752
	step
		goto 32.9,69.2
		.talk Engineer Hexascrub##40639
		..' Tell him you're ready to begin the assault on the terrace
		.' Use the Improvised Explosives ability on your hotbar on the nagas on the ground as you ride the seahorse
		.kill 100 Azsh'ir Solider##41249+ |q 25752/2
		.kill 20 Wave Screamer##41250+ |q 25752/3
		.kill 12 Azsh'ir Archaean##42549+ |q 25752/4
	step
		goto 39.1,78.7
		.talk Admiral Dvorek##40643
		..turnin Swift Action##25752
		..accept Gauging Success##25754
	step
		goto 39.1,78.5
		.talk Captain Taylor##40642
		..accept Fallen But Not Forgotten##25753
	step
		goto 33.3,67.6
		.' Go to this spot at the entrance of the tunnel
		.' Scout the Tunnel to the North |q 25754/1
	step
		goto 30.2,75.1
		.' Go to this spot at the entrance of the tunnel
		.' Scout the Northwestern Terrace |q 25754/2
	step
		goto 32.9,78.7
		.talk Injured Assault Volunteer##41281
		..' Tell them they should get moving.
		.' Rescue 6 Injured Assault Volunteers |q 25753/1
	step
		goto 39.1,78.7
		.talk Admiral Dvorek##40643
		..turnin Gauging Success##25754
	step
		goto 39.1,78.5
		.talk Captain Taylor##40642
		..turnin Fallen But Not Forgotten##25753
	step
		goto 39.2,78.6
		.talk Wavespeaker Valoren##39881
		..accept Visions of the Past: The Slaughter of Beth'mora##25755
	step
		goto 28.9,78.7
		.' Use your Blade of the Naz'jar Battlemaiden next to the Vision of the Battlemaiden |use Blade of the Naz'jar Battlemaiden##55171 |tip It's a bright flashing light on the ground on the stone terrace.
		.talk Lady Naz'jar##42076
		..accept By Her Lady's Word##25858
	step
		goto 34.4,78.7
		.talk Fathom-Lord Zin'jatar##42072
		..' Tell him you are to hunt the Crucible of Nazsharin
		.' Speak to Fathom-Lord Zin'jatar |q 25858/1
	step
		goto 36.8,79.7
		.talk Overseer Idra'kess##41455
		..' Tell him you are to hunt the Crucible of Nazsharin
		.' Speak to Overseer Idra'kess |q 25858/3
	step
		goto 39.2,78.0
		.talk Lady Sira'kess##42071
		..' Tell her you are to hunt the Crucible of Nazsharin
		.' Speak to Lady Sira'kess |q 25858/2
	step
		goto 46.2,79.6
		.talk Fathom-Stalker Azjentus##42074
		..turnin By Her Lady's Word##25858
		..accept No Trespass Forgiven##25859
	step
		goto 46.3,78.6
		.talk Naz'jar Honor Guard##41476
		..accept Stolen Property##25862
	step
		goto 57.2,89.9
		.click Crucible of Nazsharin##9565
		..turnin Stolen Property##25862
		..accept Chosen Burden##25863
	step
		goto 57.2,85.2
		.talk Executioner Verathress##41457
		..accept Setting An Example##25861
	step
		goto 55.6,86.3
		.' Aggro a Kvaldir High-Shaman, but don't kill him
		.' Lure the Kvaldir High-Shaman back to Executioner Verathress at [57.2,85.2]
		.' Bring Kvaldir High-Shaman to the executioner |q 25861/1
		' |modelnpc 41537
	step
		goto 57.2,85.3
		.talk Executioner Verathress##41457
		..turnin Setting An Example##25861
	step
		goto 57.1,88.3
		.' Use the abilities on your hotbar to do the following:
		.kill 20 Vrykul Ledge Kvaldir |q 25859/1
		' |modelnpc 41537
		' |modelnpc 41451
	step
		goto 46.4,79.0
		.talk Lady Naz'jar##42076
		..turnin Chosen Burden##25863
	step
		goto 46.5,79.3
		.talk Fathom-Stalker Azjentus##42074
		..turnin No Trespass Forgiven##25859
	step
		goto 46.4,79.0
		.talk Lady Naz'jar##42076
		..accept The Culmination of Our Efforts##26191 |instant
		.' Witness the Continuing Story of the Battlemaiden |q 25755/1
	step
		goto 29.6,78.9
		.talk Wavespeaker Valoren##39881
		..turnin Visions of the Past: The Slaughter of Beth'mora##25755
		..accept Losing Ground##25892
	step
		goto 29.5,79.0
		.clicknpc Tamed Seahorse##48901
		.' You will ride to Tranquil Wash |goto 48.4,57.4,0.5 |noway |c |q 25892
	step
		goto 49.2,57.0
		.talk Captain Taylor##40642
		..turnin Losing Ground##25892
		..accept Desperate Plan##25893
	step
		goto 47.1,57.5 |n
		.' Leave the cave |goto 47.1,57.5,0.5 |noway |c
	step
		goto 56.9,80.5
		.talk Engineer Hexascrub##41535
		..turnin Desperate Plan##25893
		..accept Come Prepared##25895
		..accept Unfurling Plan##25897
	step
		goto 57.0,80.5
		.talk Jorlan Trueblade##40645
		..accept Hostile Waters##25894
	step
		goto 61.4,86.2
		.click Alliance Survival Kit##7539
		.get Alliance Survival Kit |q 25895/1
	step
		goto 60.8,85.3
		.kill 10 Muckskin Scrounger##41566 |q 25894/1
	step
		goto 56.7,87.2
		.from Kvaldir Fleshcarver##41569+, Kvaldir Seahorror##41606+
		.click Coils of Kvaldir Rope##7548
		.get 8 Coil of Kvaldir Rope |q 25897/1
	step
		goto 56.9,80.5
		.talk Engineer Hexascrub##41535
		..turnin Come Prepared##25895
		..turnin Unfurling Plan##25897
		..turnin Hostile Waters##25894
		..accept Honor and Privilege##25898
	step
		goto 56.6,80.3
		.' Swim up to the rescue balloon on the surface |q 25898/1
		.click Survival Kit Remains##7539
		.collect 1 Rescue Flare##56188 |n
		.' Use the Rescue Flare in your bags |use Rescue Flare##56188
		.' Fire a rescue flare towards the Alliance ships |q 25898/2
	step
		goto 56.6,80.3
		.talk Jorlan Trueblade##40645
		..turnin Honor and Privilege##25898
		..accept Welcome News##25911
	step
		goto 49.2,57.0
		.talk Captain Taylor##40642
		..turnin Welcome News##25911
	step
		goto 49.5,57.6
		.talk Wavespeaker Valoren##39881
		..accept Visions of the Past: Rise from the Deep##25626
	step
		goto 47.1,57.5 |n
		.' Leave the cave |goto 47.1,57.5,0.5 |noway |c
	step
		goto 33.1,77.9
		.' Go to the very top of the Naga terrace and into the dome temple
		.' Infiltrate the Quel'Dormir Temple |q 25626/1
	step
		goto 33.1,77.8
		.' Swim up to the second floor of the temple
		.' Use your Blade of the Naz'jar Battlemaiden next to the Vision of the Battlemaiden |use Blade of the Naz'jar Battlemaiden##55171 |tip It looks like a bright flashing light inside the temple.
		.talk Lady Sira'kess##41456
		..accept Devout Assembly##25896
	step
		goto 33.1,75.9
		.talk Lady Naz'jar##42077
		..accept Her Lady's Hand##25629
	step
		goto 33.1,61.0
		.talk Fathom-Caller Azrajar##41980
		..' Tell him the mistress awaits
		.' Gather Fathom-Caller Azrajar |q 25896/2
	step
		goto 33.1,73.0
		.talk Sira'kess Tide Priestess##41985
		..' Tell them they are needed for the ritual
		.' Gather 6 Sira'kess Tide Priestesses |q 25896/1
		.' Kill all the Kvaldir mobs attacking Naz'jar Honor Guards around this area
		.' Relieve 8 Naz'jar Honor Guards |q 25629/1
	step
		goto 33.1,75.9
		.talk Lady Naz'jar##42077
		..turnin Her Lady's Hand##25629
	step
		goto 33.1,77.9
		.talk Lady Sira'kess##41456
		..turnin Devout Assembly##25896
		..accept At All Costs##25860
	step
		goto 33.1,76.9
		.' Use the abilities on your hotbar
		.from Kvladir Sandreaper##42058+, Kvaldir Bonesnapper##42057+
		.kill 20 Attacking Kvaldir |q 25860/1
	step
		goto 33.1,77.9
		.talk Lady Sira'kess##41456
		..turnin At All Costs##25860
		..accept Final Judgement##25951
	step
		goto 37.9,78.5
		.' Use the abilities on your hotbar
		.from Kvaldir Skinflayer##42060+, Kvaldir Fearweaver##42062+
		.' Hold the eastern end of Quel'Dormir Terrace |q 25951/1
	step
		goto 41.9,78.6
		.' Use the abilities on your hotbar
		.from Hagrim Hopebreaker##42063 |tip He spawns when the naga allies arrive
		.' Push the Kvaldir back across the bridge |q 25951/2
	step
		goto 42.5,78.6
		.talk Lady Naz'jar##42077
		..turnin Final Judgement##25951
		.' Witness the Concluding Story of the Battlemaiden |q 25626/2
	step
		goto 46.9,57.5
		.' Swim down under the big stone slab and into the small cove
		.' Enter the cave |goto 46.9,57.5,0.5 |noway |c |q 25626
	step
		goto 49.5,57.6
		.talk Wavespeaker Valoren##39881
		..turnin Visions of the Past: Rise from the Deep##25626
		..accept A Breath of Fresh Air##26005
	step
		goto 57.1,75.2
		.' Use your Boom Boots to get to the water surface quickly |use Boom Boots##57412
		.talk Swift Seahorse##43289
		.fpath Voldrin's Hold
	step
		goto 57.1,75.5 |n
		.click Rope Ladder##9094 |tip It's hanging off the side of the boat.
		.' Jump up onto the boat |goto 57.1,75.5,0.5 |noway |c |q 26005
	step
		goto Vashj'ir,69.6,75.3
		.talk Captain Taylor##42411
		..turnin A Breath of Fresh Air##26005
		..accept Full Circle##26219
	step
		goto 69.8,75.6
		.' Board the Pincher once it arrives |q 26219/1 |tip It's a boat, so you may have a to wait a few minutes for it.
	step
		'Ride the boat
		.' Secure Darkbreak Cove |q 26219/2
	step
		goto  Abyssal Depths 54.4,72.9
		.talk Captain Glovaal##41662
		..turnin Full Circle##26219
	step
		goto 54.7,72.2
		.talk Barracks Officer Milson##42963
		.home Darkbreak Cove
	step
		goto 55.5,72.9
		.talk Engineer Hexascrub##41666
		..accept Bio-Fuel##26103
	step
		goto 60.0,78.5 |n
		.' Leave the cave |goto 53.5,73.8,-310 |noway |c
	step
		goto 52.5,74.4
		.' Swim up above the cave
		.from Seabrush Terrapin##42108+, Scourgut Remora##42112+, Spinescale Hammerhead##42113+
		.' Use your Oil Extrusion Pump on their corpses |use Oil Extrusion Pump##56821
		.get 4 Terrapin Oil |q 26103/1
		.get 4 Remora Oil |q 26103/2
		.get 4 Hammerhead Oil |q 26103/3
	step
		goto 60.0,78.5 |n
		.' Swim down into the cave |goto 60.0,78.5,1.0 |noway |c
	step
		goto 55.5,72.9
		.talk Engineer Hexascrub##41666
		..turnin Bio-Fuel##26103
		..accept Fuel-ology 101##26106
	step
		goto 55.8,72.5
		.click Fuel Sampling Station##3491
		..' Click "Let's get started!"
		.' Choose the Hammerhead Oil Sample 3 Times
		.' Choose the Remora Oil Sample 2 Times
		.' Mix the samples together!
		.collect Promising Fuel Sample##56833 |q 26106
	step
		goto 55.5,72.9
		.talk Engineer Hexascrub##41666
		..' Tell him you made a Promising Fuel Sample
		.' Create the perfect bio-fuel |q 26106/1
	step
		goto 55.5,72.9
		.talk Engineer Hexascrub##41666
		..turnin Fuel-ology 101##26106
	step
		goto 54.4,72.9
		.talk Captain Glovaal##41662
		..accept The Brother's Digsong##26014
	step
		goto 60.0,78.5 |n
		.' Leave the cave |goto 60.0,78.5,1.0 |noway |c
	step
		goto 47.4,49.7
		.talk Humphrey Digsong##41907
		..turnin The Brothers Digsong##26014
		..accept Phosphora Hunting##26015
	step
		goto 45.1,53.6
		.from Luxscale Grouper##41923+, Pyreshell Scuttler##41922+
		.get 6 Underlight Phosphora |q 26015/1
	step
		goto 47.4,49.7
		.talk Humphrey Digsong##41907
		..turnin Phosphora Hunting##26015
		..accept A Lure##26017
		..accept Coldlights Out##26018
	step
		goto 45.9,51.7
		.kill 4 Coldlight Hunter##41925+ |q 26018/1
		.kill 4 Coldlight Oracle##41926+ |q 26018/2
		.collect 1 Enormous Eel Egg##56571 |n
		.' Click the Enormous Eel Egg in your bags |use Enormous Eel Egg##56571
		..accept I Brought You This Egg##26019
		.' Get near Coldlight Nibblers |tip Having friendly nameplates active is very useful in finding them. Shift+V will bring them up
		.get 30 Coldlight Nibbler |q 26017/1
		|modelnpc Underlight Nibbler##41916+
	step
		goto 47.4,49.7
		.talk Humphrey Digsong##41907
		..turnin A Lure##26017
		..turnin Coldlights Out##26018
		..turnin I Brought You This Egg##26019
		..accept The Brothers Digsong 2: Eel-Egg-Trick Boogaloo##26021
		..accept One Last Favor##26080
	step
		goto 44.4,53.7
		.' Use your Eel-Splosive Device in the path of a Devious Great-Eel |use Eel-Splosive Device##56808 |tip They look like big blue eels that swim around this area.  Place the device in their path, so they swim into it.
		.from Weakened Great-Eel##41927
		.' Avenge Oskar Digsong |q 26021/2
	step
		goto 47.4,49.7
		.talk Humphrey Digsong##41907
		..turnin The Brothers Digsong 2: Eel-Egg-Trick Boogaloo##26021
	step
		goto 54.4,72.9
		.talk Captain Glovaal##41662
		..turnin One Last Favor##26080
	step
		goto 55.5,73.0
		.talk Lieutenant "Foxy" Topper##41667
		..accept Sira'kess Slaying##25950
		..accept A Standard Day for Azrajar##25977
	step
		goto 55.5,72.9
		.talk Engineer Hexascrub##41666
		..accept Those Aren't Masks##25981
	step
		goto 55.6,73.0
		.talk Jorlan Trueblade##41665
		..accept Treasure Reclamation##25975
	step
		goto 60.0,78.5 |n
		.' Leave the cave |goto 60.0,78.5,1.0 |noway |c
	step
		goto 52.5,21.3
		.from Fathom-Caller Azrajar##41590
		.' Use your Alliance Standard on Fathom-Caller Azrajar's corpse |use Alliance Standard##56250
		.' Plant a banner in Fathom-Caller Azrajar's corpse |q 25977/1
	step
		goto 43.7,16.7
		.click Deepfin Plunder##259+
		.get 6 Deepfin Plunder |q 25975/1
	step
		goto 50.2,18.2
		.from Sira'kess Guardian##41586+, Sira'kess Tide Priestess##41589+, Sira'kess Sea Witch##41588+
		.kill 10 Sira'kess naga |q 25950/1
		.kill Taken Gilbin##41729 |n |tip Click the Merciless Ones after the Gilbin is dead
		.from Merciless One##41601
		.get 6 Merciless Head |q 25981/1
	step
		goto 60.0,78.5 |n
		.' Enter the cave |goto 60.0,78.5,1.0 |noway |c
	step
		goto 55.6,73.0
		.talk Jorlan Trueblade##41665
		..turnin Treasure Reclamation##25975
	step
		goto 55.5,72.9
		.talk Engineer Hexascrub##41666
		..turnin Those Aren't Masks##25981
		..accept Put It On##25987
		.' Wear the Mindless One |q 25987/1
	step
		goto 55.5,72.9
		.talk Engineer Hexascrub##41666
		..turnin Put It On##25987
		..accept Promontory Point##25983
	step
		goto 55.5,73.0
		.talk Lieutenant "Foxy" Topper##41667
		..turnin Sira'kess Slaying##25950
		..turnin A Standard Day for Azrajar##25977
	step
		goto 60.0,78.5 |n
		.' Leave the cave |goto 60.0,78.5,1.0 |noway |c
	step
		goto 42.8,38.0
		.talk Captain Taylor##41598
		..turnin Promontory Point##25983
		..accept Clearing the Corrupted##26070
		..accept The Wavespeaker##26056
	step
		goto 42.7,37.9
		.talk Wavespeaker Tulra##41639
		..accept Scalding Shrooms##26096
	step
		goto 42.7,37.9
		.talk Erunak Stonespeaker##41600
		..accept Into the Totem##26072
	step
		goto 42.7,32.2
		.' Swim down to the ground
		.' Use Erunak's Confinement Totem |use Erunak's Confinement Totem##56801
		.from Faceless Defilers##41644+ |tip Kill them next to Erunak's Confinement Totem you put down.
		.' Confine 5 Corrupting Faceless Energies |q 26072/1
		.from Crushing Eel##41646+, Chasm Stalker##41645+, Deep Remora##41647+
		.kill 8 Defiled Scalding Chasm wildlife |q 26070/1
		.click Scalding Shroom##10057+
		.get 5 Scalding Shroom |q 26096/1
	step
		goto 42.8,38.0
		.talk Captain Taylor##41598
		..turnin Clearing the Corrupted##26070
	step
		goto 42.7,37.9
		.talk Wavespeaker Tulra##41639
		..turnin Scalding Shrooms##26096
	step
		goto 42.7,37.9
		.talk Erunak Stonespeaker##41600
		..turnin Into the Totem##26072
		..accept ... It Will Come##26111
	step
		goto 47.0,28.0
		.click Stonespeaker's Luring Totem##9575
		.from Ick'thys the Unfathomable##41648
		.get The Brain of the Unfathomable |q 26111/1
	step
		goto 52.6,27.8
		.talk Wavespeaker Valoren##41640
		..turnin The Wavespeaker##26056
		..accept Free Wil'hai##26065
	step
		goto 54.4,27.8
		.' Use Valoren's Shrinkage Totem next to a Tentacle Horror |use Valoren's Shrinkage Totem##57409
		.from Shrunken Tentacle Horror##41641+
		.' Kill all the Shrunken Tentacle Horrors attacking Wil'hai
		.' Free Wil'hai |q 26065/1
	step
		goto 52.6,27.8
		.talk Wavespeaker Valoren##41640
		..turnin Free Wil'hai##26065
	step
		goto 42.7,37.9
		.talk Erunak Stonespeaker##41600
		..turnin ... It Will Come##26111
		..accept Unplug L'ghorek##26130
	step
		goto 42.8,38.0
		.talk Captain Taylor##41598
		..accept Fiends from the Netherworld##26132
	step
		goto 36.3,47.0
		.' Swim down into the cave
		.kill Ur'Goz##41654 |q 26130/1
	step
		goto 34.6,54.6
		.kill Sku'Bu##41655 |q 26130/2
	step
		goto 29.6,53.0
		.kill Neph'Lahim##41656 |q 26130/3
	step
		goto 31.9,51.3
		.kill 8 Nether Fiend##41650 |q 26132/1
	step
		goto 42.8,38.0
		.talk Captain Taylor##41598
		..turnin Fiends from the Netherworld##26132
	step
		goto 42.7,37.9
		.talk Erunak Stonespeaker##41600
		..turnin Unplug L'ghorek##26130
		..accept Communing with the Ancient##26140
	step
		goto 36.6,42.1 |n
		.' Enter L'ghorek |goto 36.6,42.1,0.5 |noway |c
	step
		goto 38.5,45.3
		.' Talk to L'ghorek
		..turnin Communing with the Ancient##26140
		..accept Runestones of Binding##26141
		..accept Ascend No More!##26142
	step
		goto 27.0,54.0
		.from Twilight Champion##41652+, Twilight Candidate##41657+
		.collect 1 Twilight Cage Key##57102 |n
		.' Click the Twilight Cage Key in your bags |use Twilight Cage Key##57102
		..accept Prisoners##26144
	step
		goto 27.5,55.7
		.click Ancient Conduit##9639+
		.' Destroy 5 Ancient Conduits |q 26142/1
		.from Twilight Candidate##41657+
		.get 7 Runestone of Binding |q 26141/1
		.' Click the Cages |tip They looks like metal cages around this area.
		.' Rescue 5 Alliance Prisoners |q 26144/1
		.' Click the Quest Complete box that pops up
		..turnin Prisoners##26144
	step
		goto 38.5,45.3
		.' Talk to L'ghorek
		..turnin Runestones of Binding##26141
		..turnin Ascend No More!##26142
		..accept Twilight Extermination##26154
	step
		goto 34.9,54.0
		.' Use your Attuned Runestone of Binding on a Bound Torrent |use Attuned Runestone of Binding##57172 |tip You can run through the groups of mobs, they won't attack you, even though they are red.
		.' Possess a Bound Torrent |q 26154/1
	step
		goto 36.3,52.8
		.' Use the abilities on your hotbar on Twilight Devotees and Faceless Overseers
		.kill 50 Twilight Devotee##42281+ |q 26154/2
		.kill 10 Faceless Overseer##42285+ |q 26154/3
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Twilight Extermination##26154
	step
		goto 38.5,45.3
		.' Talk to L'ghorek
		..accept All that Rises##26143
	step
		goto 33.1,55.8
		.' Keep controlling the elemental. Subdue it again if needed.
		.' Use the abilities on your hotbar on Hallazeal the Ascended
		.kill Hallazeal the Ascended##41659 |q 26143/1
	step
		goto 38.5,45.3
		.' Talk to L'ghorek
		..turnin All that Rises##26143
		..accept Back to Darkbreak Cove##26181
	step
		goto 55.7,73.0
		.talk Erunak Stonespeaker##41600
		..turnin Back to Darkbreak Cove##26181
		..accept Defending the Rift##26193
	step
		goto 55.7,73.0
		.talk Erunak Stonespeaker##41600
		..' Tell him you are prepared
		.' Ride the boat until it stops |tip When the boat stops make sure you follow Erunak
		.' Fight in the Battle for Abyssal Breach |q 26193/1
	step
		goto 69.8,34.4
		.talk Captain Taylor##44490
		..turnin Defending the Rift##26193
]])

ZygorGuidesViewer:RegisterInclude("A_Uldum_Leveling",[[
	step
		goto Stormwind City,85.8,25.9
		.talk Harrison Jones##44238
		..turnin That's No Pyramid!##28292
	step
		goto 62.9,71.6
		.click Hero's Call Board##10016
		..accept Hero's Call: Uldum!##28558
	step
		goto Tanaris,30.5,65.5
		.talk Adarrah##44833
		..turnin Hero's Call: Uldum!##28558
		..accept Easy Money##27003
	step
		goto 30.5,65.7
		.clicknpc Lady Humps##46517
		.' Watch the cutscene
		.' Escort the Caravan |q 27003/1
	step
		goto Uldum,59.7,71.8
		.talk Adarrah##46873
		..turnin Easy Money##27003
	step
		goto 59.6,72.0
		.talk Prince Nadun##46872
		..accept Traitors!##27922
	step
		goto 61.7,71.1
		.click Neferset Frond##10097
		.|tip It is a plant sitting nexxt to one of the pillars.
		.' Watch the cutscene
		.' Uncover the Neferset Secret |q 27922/1
	step
		goto 59.6,72.0
		.talk Prince Nadun##46872
		..turnin Traitors!##27922
		..accept Smoke in Their Eyes##27923
		..accept Kavem the Callous##28105
	step
		goto 59.7,72.0
		.talk Budd##46875
		..accept Budd's Plan##27924
	step
		goto 60.0,74.0
		.from Kavem the Callous##47567
		.get Neferset Key |q 28105/1
	step
		goto 60.8,73.9
		.from Neferset Denizen##48267+, Neferset Sentinel##47306+
		.click Neferset Armor##10100
		.get 6 Neferset Armor |q 27924/1
		.' Use your Brazier Torch next to Bales of Hay |use Brazier Torch##63027 |tip They look like bundles of yellow straw sitting on the ground around this area.
		.' Burn 5 Bales of Hay |q 27923/1
		' |model Bale of Hay##8701
	step
		goto 59.7,72.0
		.talk Budd##46875
		..turnin Budd's Plan##27924
	step
		goto 59.6,72.0
		.talk Prince Nadun##46872
		..turnin Smoke in Their Eyes##27923
		..turnin Kavem the Callous##28105
		..accept Escape From the Lost City##28112
	step
		goto 54.9,32.7
		.talk King Phaoris##47684
		..turnin Escape From the Lost City##28112
		..accept Impending Retribution##28134
	step
		goto 54.7,32.9
		.talk Kazemde##48886
		.home Ramkahen
	step
		goto 56.2,33.6
		.talk Kurzel##48275
		.fpath Ramkahen
	step
		goto 53.0,27.7
		.talk Sun Priest Asaris##47715
		..' Tell him you might be able to help
		.' Speak with Sun Priest Asaris |q 28134/2
	step
		goto 53.0,27.7
		.talk Sun Priest Asaris##47715
		..accept Relics of the Sun King##28141
		..accept Venomblood Antidote##28145
	step
		goto 46.3,21.0
		.from Wastewander Outrider##45905+
		.get 4 Relic of the Sun King |q 28141/1
		.from Venomblood Scorpid##45859+
		.' Use your Antidote Vial on Venomblood Scorpid corpses |use Antidote Vial##63086
		.' Drain 8 Venomblood Scorpids |q 28145/1
		.' You can find more Venomblood Scorpid and Wastewander Outriders around [49.9,24.0]
		.' And at [48,16.1]
	step
		goto 53.0,27.7
		.talk Sun Priest Asaris##47715
		..turnin Relics of the Sun King##28141
		..turnin Venomblood Antidote##28145
		..accept The Bandit Warlord##28502
	step
		goto 45.7,16.2
		.kill Warlord Ihsenn##47755 |q 28502/1
	step
		goto 53.0,27.7
		.talk Sun Priest Asaris##47715
		..turnin The Bandit Warlord##28502
	step
		goto 49.7,39.2
		.talk Asaq##47930
		..' Tell him the king wishes to be informed about recent Neferset activity
		.' Speak with Asaq |q 28134/3
	step
		goto 49.7,39.1
		.talk Mack##47318
		..accept Take it to 'Em!##27993
	step
		goto 60.3,38.3
		.talk Nomarch Teneth##46603
		..' Tell him King Phaoris sent you to ask him about Neferset activity
		.' Speak with Nomarch Teneth |q 28134/1
	step
		goto 60.3,38.3
		.talk Nomarch Teneth##46603
		..accept Thieving Little Pluckers##28250
	step
		goto 59.1,38.4
		.' Use your Tahret Dynasty Mallet next to stacks of Pygmies |use Tahret Dynasty Mallet##63351 |tip They are sitting on each other's shoulders trying to steal fruit out of trees around this area.
		.from Pygmy Scout##48041+, Pygmy Oaf##48040+, Pygmy Thief##48043+
		.' Smash 30 Thieving Pluckers |q 28250/1
	step
		goto 60.3,38.3
		.talk Nomarch Teneth##46603
		..turnin Thieving Little Pluckers##28250
	step
		goto 64.4,22.3
		.' Go to this spot
		.' Investigate Khartut's Tomb |q 27993/1
	step
		goto 64.4,22.3
		.talk Harrison Jones##44860
		..turnin Take it to 'Em!##27993
		..accept Premature Explosionation##27141
	step
		goto 64.3,22.2
		.click Powder Keg##472
		.' Watch the cutscene
		.' Assist Harrison at Khartut's Tomb |q 27141/1
	step
		goto 64.6,28.6
		.talk Harrison Jones##45180
		..turnin Premature Explosionation##27141
	step
		goto 64.6,28.7
		.talk Sand Pygmy Corpse##45186
		..accept Field Work##27179
	step
		goto 64.8,29.6
		.click the Elaborate Disc##8342
		..accept Just the Tip##27176
	step
		goto 66.1,29.0
		.from Mangy Hyena##45202
		.' You will accept a quest
		..accept Do the World a Favor##27187
	step
		goto 68.2,31.5
		.from Skarf##45204
		.from Sultan Oogah##45205
		.collect Sultan's Staff##60865 |q 27176
	step
		'Use your Elaborate Disc |use Elaborate Disc##60859
		.get Shaft of the Stars |q 27176/1
	step
		goto 66.1,29.0
		.from Sand Pygmy##45190+
		.click Ornate Tablet Fragment##6420+
		.get 10 Ornate Tablet Fragment |q 27179/1
		.from Mangy Hyena##45202+
		.' Eradicate 12 Mangy Hyenas |q 27187/1
		.' You can find more mobs to kill at [Uldum,62.8,32]
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Do the World a Favor##27187
	step
		goto 64.6,28.6
		.talk Harrison Jones##45180
		.|tip He is all the way down, on the floor.
		..turnin Field Work##27179
		..turnin Just the Tip##27176
		..accept On to Something##27196
	step
		goto 64.6,28.6
		.talk Harrison Jones##45180
		..' Tell him you're ready!
		.' Follow Harrison Jones |tip When he jumps down, use your flying mount to go down into the Chamber of Stars.
		.' Accompany Harrison Jones to the Chamber of the Stars |q 27196/1
	step
		goto 64.5,28.0
		.talk Harrison Jones##45296
		..turnin On to Something##27196
		..accept The Thrill of Discovery##27511
	step
		goto 65.7,25.8
		.' Go to this spot
		.' Examine the Northern Hieroglyphs |q 27511/2
	step
		goto 64.4,29.9
		.' Go to this spot
		.' Examine the Ancient Mechanism |q 27511/1
	step
		goto 63.4,32.5
		.talk Schnottz Scout##45874
		..accept Lessons From the Past##27541
	step
		goto 63.4,32.5
		.talk Schnottz Scout##45874
		..' Take the scout's spectacles.
		.get Broken Spectacles |q 27541/1
	step
		goto 63.4,33.9
		.' Go to this spot
		.' Examine the Southern Hieroglyphs |q 27511/3
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin The Thrill of Discovery##27511
	step
		goto 64.5,28.0
		.talk Harrison Jones##45296
		..turnin Lessons From the Past##27541
		..accept By the Light of the Stars##27549
		..accept Be Prepared##28602
	step
		goto 63.3,28.0
		.click Suspended Starlight##9933
		.|tip After clicking the Suspended Starlight, one or two nearby Indentured Protectors will attack you.
		.get 7 Suspended Starlight |q 27549/1
		.' Walk up to the skeletons laying on the ground around this area; they'll get up and attack you.
		.from Tormented Tomb-Robber##45765+
		.get 6 Piece of Rope |q 28602/1
	step
		goto 64.5,28.0
		.talk Harrison Jones##45296
		..turnin By the Light of the Stars##27549
	step
		goto 64.5,28.0
		.talk Harrison Jones##45296
		..turnin Be Prepared##28602
		..accept Tipping the Balance##27431
	step
		goto 64.5,28.0
		.talk Harrison Jones##45296
		..' Ask him what you can do to help
		.' Watch the cutscene
		.' Stay Out of Harrison's Way |q 27431/1
	step
		goto 64.5,28.0
		.talk Harrison Jones##45296
		..turnin Tipping the Balance##27431
		..accept After the Fall##27624
	step
		goto 64.0,26.4
		.click Watcher Head##10079
		.get Orb of the Morning Star |q 27624/1
	step
		goto 66.8,28.1
		.click Watcher Head##10079
		.get Orb of the Evening Star |q 27624/2
	step
		goto 65.3,32.6
		.click Watcher Head##10079
		.get Orb of the Shooting Star |q 27624/4
	step
		goto 62.5,32.0
		.click Watcher Head##10079
		.get Orb of the North Star |q 27624/3
	step
		goto 64.5,28.0
		.talk Harrison Jones##45296
		..turnin After the Fall##27624
		..accept Do the Honors##27669
	step
		goto 64.5,28.7
		.' Use your Orbs of the Stars |use Orbs of the Stars##62054
		.' Watch the cutscene
		.' Reactivate the Obelisk of the Stars |q 27669/1
	step
		goto 63.9,33.9
		.talk Harrison Jones##48034
		..turnin Do the Honors##27669
	step
		goto 54.9,32.7
		.talk King Phaoris##47684
		..turnin Impending Retribution##28134
		..accept Al'Akir's Vengeance##28135
	step
		goto 54.3,35.3
		.talk Adarrah##47005
		..accept That Gleam in his Eye##27899
	step
		goto 45.2,38.0
		.talk Prince Nadun##45799
		..turnin Al'Akir's Vengeance##28135
		..accept Minions of Al'Akir##27520
	step
		goto 45.3,37.8
		.talk General Ammantep##45772
		..accept Under the Choking Sands##27519
		..accept The Prophet Hadassi##27595
	step
		goto 40.0,40.5
		.talk Prophet Hadassi##46003
		..turnin The Prophet Hadassi##27595
		..accept The Prophet's Dying Words##27602
	step
		goto 39.6,45.4
		.click Sand-Covered Hieroglyphs##5992
		.|tip It is inside this building.
		..turnin The Prophet's Dying Words##27602
		..accept Colossal Guardians##27623
	step
		goto 39.6,40.9
		.clicknpc Colossus of the Sun##46041
		.from Colossus of the Sun
		.get Stone of the Sun |q 27623/2
	step
		goto 41.2,37.6
		.clicknpc Colossus of the Moon##46042
		.from Colossus of the Moon
		.get Stone of the Moon |q 27623/1
	step
		goto 40.7,40.2
		.kill 6 Scion of Al'Akir##45755+ |q 27520/1
		.clicknpc Orsis Survivor##45715+
		.' Rescue 8 Orsis Survivors |q 27519/1
		.|tip You can rescue the survivors while on your mount.
		.' More can be found around [Uldum,42.7,33.9]
	step
		goto 39.6,45.4
		.click Sand-Covered Hieroglyphs##5992
		..turnin Colossal Guardians##27623
		..accept The Scepter of Orsis##27706
	step
		goto 39.6,45.4
		.click Sacred Receptacle##6502
		.get The Scepter of Orsis |q 27706/1
	step
		goto 44.0,57.1
		.talk Harrison Jones##46978
		..turnin That Gleam in his Eye##27899
		..accept I've Got This Guy##27900
		..accept They Don't Know What They've Got Here##27901
	step
		goto 44.3,58.2
		.from Schnottz Air Officer##46993
		.collect Efficient Excavations##62768 |n
		.' Click the Efficient Excavations in your bags |use Efficient Excavations##62768
		..accept Efficient Excavations##28132
	step
		goto 46.7,58.4
		.from Schnottz Air Trooper##46979+
		.' Slay 10 Schnottz Air Troopers |q 27900/1
		.from Schnottz Air Officer##46993+
		.collect Uldum Chest Key Code##62608 |n
		.click Obelisk of the Sun Coffer##8685+
		.collect 6 Titan Device Component##62610 |q 27901
		.' More can be found at [Uldum,45.6,55.1]
		.' And at [Uldum,43.7,55.7]
	step
		'Use your Titan Device Components |use Titan Device Component##62610
		.get Titan Activation Device |q 27901/1
	step
		goto 44.0,57.1
		.talk Harrison Jones##46978
		..turnin I've Got This Guy##27900
		..turnin They Don't Know What They've Got Here##27901
		..accept Ignition##27903
	step
		goto 45.2,58.8 |n
		.' Follow the path down |goto 45.2,58.8,0.5 |noway |c
	step
		goto 47.1,58.8
		.' Use your Titan Activation Device next to the huge statue |use Titan Activation Device##62611
		.from Titanic Guardian##47032 |tip While fighting the Titanic Guardian, click the big lava meteors that appear on the ground to do massive to the Titanic Guardian, making him much easier to kill.
		.get Lens of the Sun |q 27903/1
	step
		goto 45.6,57.8
		.' Fly up onto the middle platform inside this cave
		.' Click the Titan Mechanism
		..turnin Ignition##27903
	step
		goto 44.0,57.1
		.talk Harrison Jones##46978
		..accept Tailgunner!##27905
		.' Use the abilities on your hotbar to shoot down the airplanes that chase you
		.' Escape the Obelisk of the Sun |q 27905/1
	step
		goto 54.6,41.8
		.talk Harrison Jones##48082
		..turnin Tailgunner!##27905
	step
		goto 45.2,38.0
		.talk Prince Nadun##45799
		..turnin Minions of Al'Akir##27520
	step
		goto 45.3,37.8
		.talk General Ammantep##45772
		..turnin Under the Choking Sands##27519
		..turnin The Scepter of Orsis##27706
	step
		goto 45.2,38.0
		.talk Prince Nadun##45799
		..accept Send Word to Phaoris##27628
	step
		goto 54.9,32.7
		.talk King Phaoris##47684
		..turnin Send Word to Phaoris##27628
	step
		goto 55.0,34.0
		.talk Prince Nadun##47959
		..accept The High Priest's Vote##27630
		..accept The Vizier's Vote##27629
		..accept The High Commander's Vote##27631
	step
		goto 52.9,45.3 |n
		.' Enter the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 54.2,41.9
		.talk High Priest Amet##46135
		..turnin The High Priest's Vote##27630
		..accept Stopping the Spread##27836
		..accept Trespassers in the Water##27837
	step
		goto 52.9,45.3 |n
		.' Leave the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 52.9,40.8
		.kill 8 Stillwater Slitherer##46868+ |q 27837/1
		.click Slitherer Egg##7803+
		.' Destroy 6 Slitherer Eggs |q 27836/1
	step
		goto 52.9,45.3 |n
		.' Enter the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 54.2,41.9
		.talk High Priest Amet##46135
		..turnin Stopping the Spread##27836
		..turnin Trespassers in the Water##27837
		..accept The Defilers' Ritual##28611
	step
		goto 52.9,45.3 |n
		.' Leave the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 51.8,40.1 |n
		.' Enter the underwater cave |goto 51.8,40.1,0.5 |noway |c
	step
		goto 49.9,40.1
		.from Dark Ritualist Zakahn##49148
		.' Stop the Neferset Ritual |q 28611/1
	step
		goto 51.8,40.1 |n
		.' Leave the underwater cave |goto 51.8,40.1,0.5 |noway |c
	step
		goto 52.9,45.3 |n
		.' Enter the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 54.2,41.9
		.talk High Priest Amet##46135
		..turnin The Defilers' Ritual##28611
		..accept The Root of the Corruption##27838
	step
		goto 52.9,45.3 |n
		.' Leave the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 58.9,46.1
		.talk High Commander Kamses##46134
		..turnin The High Commander's Vote##27631
		..accept The Weakest Link##28198
		..accept Ploughshares to Swords##28201
	step
		goto 59.0,46.1
		.talk Sergeant Mehat##48012
		..accept The Element of Supplies##28200
	step
		goto 59.6,47.3
		.talk Salhet##46883
		..turnin The Weakest Link##28198
		..accept Shaping Up##28210
	step
		goto 56.3,53.5
		.talk Vizier Tanotep##46136 |tip He walks around the area here.
		..turnin The Vizier's Vote##27629
		..accept Tanotep's Son##27632
	step
		goto 55.6,53.7
		.talk Ramkahen Laborer##46333
		.' Recruit 8 Ramkahen Laborers |q 28201/1
		.|tip This can be done while mounted.
	step
		goto 56.7,48.5
		.from Riverbed Crocolisk##45321+ |tip They are all along and in this big river.
		.get 20 Hardened Crocolisk Hide |q 28200/1
	step
		goto 59.0,46.1
		.talk Sergeant Mehat##48012
		..turnin The Element of Supplies##28200
	step
		goto 58.9,46.1
		.talk High Commander Kamses##46134
		..turnin Ploughshares to Swords##28201
		..accept Ancient Weapons##27839
	step
		goto 60.4,57.5
		.' Use your Horn of Ramkahen |use Horn of Ramkahen##62534
		.' When the cat men run in to attack the smugglers, go to [60.5,58.7]
		.click Ancient Tol'vir Weapon##10071+
		.get Ancient Tol'vir Armaments |q 27839/1
	step
		goto 58.1,60.8
		.from Neferset Guard##46340+
		.get Vir'Naal Delta Map |q 27632/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Tanotep's Son##27632
		..accept Neferset Prison##27707
	step
		goto 55.5,59.5
		.from Bloodsnarl Hyena##45353+
		.' Help Salhet defeat 8 Bloodsnarl Hyenas |q 28210/1
		.' You can find more Bloodsnarl Hyenas around [52.6,56.2]
	step
		'Next to you:
		.talk Salhet##48022
		..turnin Shaping Up##28210
		..accept Salhet's Secret##28276
	step
		goto 56.9,62.4
		.talk Salhet##48237
		..turnin Salhet's Secret##28276
		..accept Salhet the Tactician##28277
	step
		goto 56.9,62.4
		.talk Salhet##48237
		..' Tell him let's see what he and his lions can do
		.' Use the abilities on your hotbar to use the lions to kill the hyenas
		.kill 30 Bloodsnarl Scavenger##48199+ |q 28277/1
	step
		goto 56.9,62.4
		.talk Salhet##48237
		..turnin Salhet the Tactician##28277
		..accept Return to Camp##28291
	step
		goto 71.3,73.7
		.talk Ramkahen Prisoner##46425
		.' Fight the enemies that attack
		.' Discover Tahet's Whereabouts |q 27707/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Neferset Prison##27707
		..accept The Pit of Scales##27738
	step
		goto 58.3,82.9
		.talk Tahet##46496
		.' Kill the Pit Master's crocolisk pets.
		.from Caimas the Pit Master##46276 |tip Make him chase you.  Run in front of him so that he runs over the big pink Croc Eggs on the ground around this area.  Baby Crocs will damage him and slow his run speed down.  Eventually, he will die.
		.' Free Tahet |q 27738/1
		|model Croc Eggs##412
	step
		goto 58.9,14.2
		.kill Scalemother Hevna##46871 |q 27838/1
	step
		goto 52.9,45.3 |n
		.' Enter the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 54.2,41.9
		.talk High Priest Amet##46135
		..turnin The Root of the Corruption##27838
	step
		goto 52.9,45.3 |n
		.' Leave the dam |goto 52.9,45.3,0.5 |noway |c
	step
		goto 58.9,46.1
		.talk High Commander Kamses##46134
		..turnin Return to Camp##28291
		..turnin Ancient Weapons##27839
	step
		goto 56.3,53.5
		.talk Vizier Tanotep##46136 |tip He walks around the area here.
		..turnin The Pit of Scales##27738
		..accept The High Council's Decision##28533
	step
		goto 54.9,32.7
		.talk King Phaoris##47684
		..turnin The High Council's Decision##28533
		.' Watch the cutscene
		..accept Nahom Must Hold##28561
	step
		goto 67.2,42.9
		.talk Salhet##48761
		..turnin Nahom Must Hold##28561
		..accept The Secret of Nahom##28498
	step
		goto 67.3,42.8
		.talk Sun Prophet Tumet##48501
		..accept Punish the Trespassers##28499
	step
		goto 71.7,46.1
		.from Neferset Raider##48626+, Neferset Scryer##48625+, Neferset Looter##48627+
		.kill 10 Neferset intruder |q 28499/1
		.click Atulhet's Record Fragment##6420+
		.get 8 Atulhet's Record Fragment |q 28498/1
		.' You can find more Atulhet Fragments and Neferset mobs around [75.2,45.7]
		.' Can also find more mobs at [Uldum,74,51.5]
	step
		goto 67.3,42.8
		.talk Sun Prophet Tumet##48501
		..turnin Punish the Trespassers##28499
	step
		goto 67.2,42.9
		.talk Salhet##48761
		..turnin The Secret of Nahom##28498
		..accept The Cypher of Keset##28500
	step
		goto 78.2,45.7
		.from Raider Lord Havat##49214
		.get The Cypher of Keset |q 28500/1
	step
		goto 67.2,42.9
		.talk Salhet##48761
		..turnin The Cypher of Keset##28500
		..accept The Defense of Nahom##28501
	step
		goto 66.7,41.8
		.talk Ramkahen Sergeant##49228
		.' Use the abilities on your hotbar to command the troops
		.' Complete the Defense of Nahom |q 28501/1
	step
		'Click the red arrow on your hotbar |outvehicle |noway |c |q 28501
	step
		goto 67.2,42.9
		.talk Salhet##48761
		..turnin The Defense of Nahom##28501
		..accept The Push Westward##28623
	step
		goto 67.3,42.8
		.talk Sun Prophet Tumet##48501
		..accept The Curse of the Tombs##27755
	step
		goto 69.8,58.9
		.kill Mekgineer Mixeltweed##46592 |q 27755/2
		.kill 6 Crazed Digger##46590+ |q 27755/1
		.collect 1 A.I.D.A. Communicator##62483 |n
		.' Use the A.I.D.A. Communicator |use A.I.D.A. Communicator##62483
		..accept Artificial Intelligence##27760
	step
		goto 74.1,64.4
		.click A.I.D.A. Terminal##7764
		..turnin Artificial Intelligence##27760
		..accept A Disarming Distraction##27761
		..accept Core Access Codes##27777
	step
		goto 73.3,72.8
		.' Use your Mech Control Scrambler on Twizzleflux the Insane repeatedly |use Mech Control Scrambler##62542
		.from Twizzleflux the Insane##46587
		.get Core Access Codes |q 27777/1
	step
		goto 78.8,62.1
		.' Use your Holographic Projector next to the First Bomb Cluster to distract the enemies |use Holographic Projector##62398
		.click First Bomb Cluster##9277
		.' Disarm the First Bomb Cluster |q 27761/1
	step
		goto 79.0,64.3
		.' Use your Holographic Projector next to the Second Bomb Cluster to distract the enemies |use Holographic Projector##62398
		.click Second Bomb Cluster##9277
		.' Disarm the Second Bomb Cluster |q 27761/2
	step
		goto 79.0,64.9
		.' Use your Holographic Projector next to the Third Bomb Cluster to distract the enemies |use Holographic Projector##62398
		.click Third Bomb Cluster##9277
		.' Disarm the Third Bomb Cluster |q 27761/3
	step
		goto 79.0,63.6
		.' Use your Holographic Projector next to Unstable Bomb Bots to distract the enemies |use Holographic Projector##62398
		.clicknpc Unstable Bomb Bot##46888+
		.' Deactivate 4 Unstable Bomb Bots |q 27761/4
	step
		goto 74.1,64.4
		.click A.I.D.A. Terminal##7764
		..turnin A Disarming Distraction##27761
		..turnin Core Access Codes##27777
		..accept Hacking the Wibson##27778
	step
		goto 77.0,62.9
		.click Maintenance Tools##317
		.collect Maintenance Axe##62621 |q 27778
		.|tip They are on top of this blimp thing.
	step
		goto 77.0,63.0
		.clicknpc Wibson Mainframe##46715
		.' Hack the Wibson Mainframe |q 27778/1
	step
		goto 77.3,63.3
		.talk Fusion Core##46750
		..turnin Hacking the Wibson##27778
		..accept Gnomebliteration##27779
	step
		goto 81.9,58.8
		.' Roll down the hill as the Fusion Core
		.' Run over gnomes all around this area
		.' Obliterate 1000 Crazed Gnomes |q 27779/1
	step
		goto 77.6,62.4
		.' Roll back up the hill
		.' Click the yellow arrow on your hotbar |outvehicle |noway |c |q 27779
	step
		goto 77.3,63.3
		.talk Fusion Core##46750
		..turnin Gnomebliteration##27779
	step
		goto 52.0,65.5
		.talk King Phaoris##48564
		..turnin The Push Westward##28623
		..accept Lieutenants of Darkness##28480
		..accept Bleeding the Enemy##28483
	step
		goto 52.9,65.5
		.talk Salhet##49345
		..accept Salhet's Gambit##28486
	step
		goto 54.1,71.2
		.talk Ramkahen Ranger Captain##49244
		.' Protect the rangers as they run up the path
		.' Secure Higher Ground |q 28486/1
	step
		goto 47.5,77.3
		.kill High Priest Sekhemet##47730 |q 28480/2
	step
		goto 50.6,87.0
		.kill Scorpion-Lord Namkhare##47742 |q 28480/1
	step
		goto 48.7,84.9
		.from Neferset Snake Charmer##47738+, Neferset Cursebringer##47760+, Neferset Ritualist##47762+
		.get 10 Neferset Insignia |q 28483/1
	step
		goto 52.9,65.5
		.talk Salhet##49345
		..turnin Salhet's Gambit##28486
	step
		goto 52.0,65.5
		.talk King Phaoris##48564
		..turnin Lieutenants of Darkness##28480
		..turnin Bleeding the Enemy##28483
		..accept The Fall of Neferset City##28520
	step
		goto 52.0,82.3
		.kill Dark Pharaoh Tekahn##47753 |q 28520/1
	step
		goto 24.4,64.5
		.talk Belloc Brightblade##47670
		..turnin Efficient Excavations##28132
		..accept Eastern Hospitality##27926
	step
		goto 22.5,63.2
		.talk Ambassador Laurent##47176
		..' Ask him what he thinks of our host
		.' Mingle with Ambassador Laurent |q 27926/1
	step
		goto 22.5,63.2
		.talk Refined Gentleman##47185
		..' Ask him what he knows of our generous host
		.' Mingle with a Refined Gentleman |q 27926/2
	step
		goto 22.3,63.2
		.talk Budding Artist##47187
		..' Ask him how to find the Commander
		.' Mingle with a Budding Artist |q 27926/3
		|modelnpc Budding Artist##47707
	step
		goto 22.2,63.2
		.talk Aspiring Starlet##47189
		..' Ask her how she has been enjoying her time here
		.' Mingle with an Aspiring Starlet |q 27926/4
	step
		goto 22.0,64.5
		.talk Arcane Guest Registry##49528
		.home Schnottz's Landing
	step
		goto 22.3,64.9
		.talk Evax Oilspark##48273
		..fpath Schnottz's Landing
	step
		goto 24.4,64.5
		.talk Belloc Brightblade##47670
		..turnin Eastern Hospitality##27926
		..accept A Favor for the Furrier##27928
	step
		goto 24.4,64.1
		.talk Commander Schnottz##47159
		..accept The Desert Fox##27939
	step
		goto 40.6,68.9
		.from Diseased Vulture##47202
		.|tip They are flying above you.
		.' You will accept a quest
		..accept Dirty Birds##27940
	step
		goto 40.6,68.9
		.from Diseased Vulture##47202+
		.' Slay 8 Diseased Vultures |q 27940/1
		.from Shaggy Desert Coyote##47190+
		.get 5 Desert Coyote Pelt |q 27928/1
		.' You can find more mobs to kill at [Uldum,43.7,70.3]
		.clicknpc Desert Fox##47201 |tip It runs around a lot, so you will probably have to search for it to find it.
		.get The Desert Fox |q 27939/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Dirty Birds##27940
	step
		goto 24.4,64.5
		.talk Belloc Brightblade##47670
		..turnin A Favor for the Furrier##27928
		..accept Fashionism##27941
	step
		goto 24.4,64.2
		.talk Commander Schnottz##47159
		..turnin The Desert Fox##27939
		..accept Idolatry##27942
		..accept Angered Spirits##27943
	step
		goto 31.2,63.6
		.from Furious Specter##47220+
		.' Use your Licensed Proton Accelerator Cannon on Furious Specters once they are at half health |use Licensed Proton Accelerator Cannon##62794
		.get 5 Furious Spectral Essence |q 27943/1
		.clicknpc Dead Trooper##47219+
		.|tip You can collect the Dead Tropoer Uniforms while mounted.
		.get 10 Trooper Uniform |q 27941/1
		.click Well-preserved Idol##10092+
		.get 8 Well-preserved Idol |q 27942/1
	step
		goto 24.4,64.5
		.talk Belloc Brightblade##47670
		..turnin Fashionism##27941
	step
		goto 24.4,64.1
		.talk Commander Schnottz##47159
		..turnin Idolatry##27942
		..turnin Angered Spirits##27943
		..accept Gobbles!##27950
	step
		goto 24.4,64.1
		.talk Commander Schnottz##47159
		..' Tell him the perimeter is secure
		.' Witness Gobbles' Transformation Ritual |q 27950/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Gobbles!##27950
	step
		goto 24.4,64.1
		.talk Commander Schnottz##47159
		..accept Make Yourself Useful##27969
	step
		'Use your Refurbished Trooper Uniform |use Refurbished Trooper Uniform##62813
		.' Wear the Uniform |havebuff INTERFACE\ICONS\inv_chest_leather_08 |q 27969
	step
		goto 23.2,60.1
		.talk Slacking Laborer##47292
		..' Tell them they're behind schedule
		.' Motivate 6 Slacking Laborers |q 27969/1 |tip You won't motivate all of the Slacking Laborers you talk to.
		.' You can find more Slacking Laborers around [20.5,60.5]
	step
		goto 24.5,64.2
		.talk Commander Schnottz##47159
		..turnin Make Yourself Useful##27969
	step
		goto 24.4,64.5
		.talk Belloc Brightblade##47670
		..accept Crisis Management##28002
	step
		goto 22.5,64.0
		.talk Budding Artist##47707
		..' Ask him if he saw anything
		.' Counsel the Budding Artist |q 28002/4
	step
		goto 22.4,63.8
		.talk Prolific Writer##47516
		..' Ask him who could have done such a thing
		.' Question the Prolific Writer |q 28002/1
	step
		goto 22.2,63.9
		.talk Privileged Socialite##47519
		..' Ask her if she is all right
		..' Soothe the Privileged Socialite |q 28002/2
	step
		goto 22.3,64.1
		.talk Pretentious Businessman##47520
		..' Ask him if he wants to know what happened to the man
		.' Chasten the Pretentious Businessman |q 28002/3
	step
		goto 24.4,64.5
		.talk Belloc Brightblade##47670
		..turnin Crisis Management##28002
	step
		goto 24.4,64.1
		.talk Commander Schnottz##47159
		..accept Battlezone##27990
	step
		goto 21.3,64.6
		.clicknpc Schnottz's Siege Tank##47732
		.' Ride in Schnottz's Siege Tank
		.' Use the Fire Cannon ability on your hotbar on Decrepit Watchers
		.' Obliterate 7 Decrepit Watchers |q 27990/1
		' |modelnpc 47385
	step
		goto 24.4,64.1
		.' Go to this spot
		.' Return to Schnottz |q 27990/2
	step
		goto 24.4,64.1
		.talk Commander Schnottz##47940
		..turnin Battlezone##27990
		..accept Missed Me By Zhat Much!##28187
	step
		goto 24.4,64.1
		.talk Commander Schnottz##47940
		..' Tell him let's move
		.' Follow Commander Schnottz
		.' Accompany Schnottz to Safety |q 28187/1
	step
		goto 22.5,63.2
		.talk Commander Schnottz##47972
		..turnin Missed Me By Zhat Much!##28187
		..accept Lockdown!##28193
	step
		goto 21.9,64.1
		.' Go to this spot
		.' Visit Schnottz's Guests |q 28193/1
	step
		goto 21.9,64.0
		.talk Prolific Writer##47967
		..accept The Great Escape##28194
	step
		goto 22.5,63.2
		.talk Commander Schnottz##47972
		..turnin Lockdown!##28193
		..accept Sending a Message##28195
	step
		goto 22.3,67.6
		.kill Captain Margun##47981 |q 28195/1
		.|tip He is on the top of the ship, in the back by the helm.
	step
		goto 24.9,69.0
		.kill Captain Cork##47980 |q 28195/2
		.|tip He is on the top of the ship, in the back by the helm.
	step
		goto 26.1,68.6
		.kill Captain Kronkh##47978 |q 28195/3
		.|tip He is on the top of the ship, in the back by the helm.
	step
		goto 24.9,68.4
		.from Schnottz Sea Trooper##47982+ |tip Kill them on all 3 of the pirate ships around this area.
		.get 6 Fresh Sailor Uniform |q 28194/1
	step
		goto 21.9,64.0
		.talk Prolific Writer##47967
		..turnin The Great Escape##28194
	step
		goto 22.5,63.2
		.talk Commander Schnottz##47972
		..turnin Sending a Message##28195
		..accept Firing Squad##28267
	step
		goto 22.5,63.2
		.talk Commander Schnottz##47972
		..' Tell him you suppose you're ready...
		.' Watch the cutscene
		.' Go 'Out Back' With Schnottz |q 28267/1
	step
		goto 23.6,60.3
		.talk Harrison Jones##48162
		..turnin Firing Squad##28267
		..accept Meet Me In Vir'sar##28269
	step
		goto 54.9,32.7
		.talk King Phaoris##47684
		..turnin The Fall of Neferset City##28520
	step
		goto 67.3,42.8
		.talk Sun Prophet Tumet##48501
		..turnin The Curse of the Tombs##27755
	step
		goto 27.0,7.5
		.talk Harrison Jones##48186
		..turnin Meet Me In Vir'sar##28269
		..accept Friend of a Friend##28273
	step
		goto 26.6,7.2
		.talk Yasmin##49406
		.home Oasis of Vir'sar
	step
		goto 26.6,8.0
		.talk Sullah##48203
		..turnin Friend of a Friend##28273
		..accept Two Tents##28274
	step
		'Watch the cutscene
		.' Accompany Sullah |q 28274/1
		' |modelnpc 48621
	step
		goto 29.6,21.9
		.talk Sullah##48431
		..turnin Two Tents##28274
		..accept Master Trapper##28350
		..accept Camel Tow##28352
		..accept Unlimited Potential##28351
	step
		goto 29.9,38.2
		.from Wild Camel##51193+
		.' Use Sullah's Camel Harness on Wild Camels when they are weakened |use Sullah's Camel Harness##67241 |tip You will see a message flash on your screen telling you to capture the camel.
		.' Capture 3 Wild Camels |q 28352/1
	step
		goto 29.9,38.2
		.from Wild Camel##51193+
		.get 5 Meat Scrap |q 28350/1
		.from Cavorting Pygmy##51217+
		.' Use Sullah's Pygmy Pen on Cavorting Pygmies when they are weakened |use Sullah's Pygmy Pen##67232 |tip You will see a message flash on your screen telling you to cage the pygmy.
		.' More can be found at [Uldum,27.8,47]
		.' Capture 5 Sand Pygmies |q 28351/1
	step
		goto 29.6,21.8
		.talk Sullah##48431
		..turnin Master Trapper##28350
		..turnin Camel Tow##28352
		..turnin Unlimited Potential##28351
		..accept Jonesy Sent For You##28353
	step
		goto 27.0,7.5
		.talk Harrison Jones##48186
		..turnin Jonesy Sent For You##28353
		..accept Reduced Productivity##28271
		..accept Missing Pieces##28272
	step
		goto 26.6,8.35
		.talk Jock Lindsey##48274
		..fpath Oasis of Vir'sar
	step
		goto 38.2,21.6
		.from Schnottz Overseer##48205+, Schnottz Excavator##48204+
		.' Kill 15 Schnottz Employees at the Obelisk of the Moon |q 28271/1
		.click Pillaged Loot Sack##10201+
		.get 7 Ancient Copper Scroll |q 28272/1
	step
		goto 27.0,7.6
		.talk Harrison Jones##48186
		..turnin Reduced Productivity##28271
		..turnin Missing Pieces##28272
		..accept Stirred the Hornet's Nest##28363
	step
		goto 29.6,21.8
		.talk Sullah##48431
		..turnin Stirred the Hornet's Nest##28363
		..accept Shroud of the Makers##28367
	step
		goto 38.4,22.6
		.' Use your Shroud of the Makers every 2 minutes to stay Cloaked |use Shroud of the Makers##63699 |tip If you have a pet with you dismiss it, it does not stealth with you and will attract mobs
		.click Schnottz Powder Keg##33+
		.' Sabotage 7 Powder Kegs |q 28367/1
	step
		goto 27.0,7.5
		.talk Harrison Jones##48186
		..turnin Shroud of the Makers##28367
		..accept Schnottz So Fast##28402
	step
		goto 36.7,20.8 |n
		.' Enter the building |goto 36.7,20.8,0.5 |noway |c
	step
		goto 33.5,17.8 |n
		.' Fly down this hole |goto 33.5,17.8,0.5 |noway |c
	step
		goto 35.0,19.2
		.from Schnottz Elite Trooper##48668+
		.' Slay 10 Schnottz Elite Troopers |q 28402/1
	step
		goto 36.1,20.3
		.talk Harrison Jones##48528
		..turnin Schnottz So Fast##28402
		..accept Bad Datas##28403
	step
		goto 36.1,20.3
		.talk Harrison Jones##48528
		..' Tell him you are ready when he is
		.' Follow Harrison Jones
		.' Upload the Titan Data |q 28403/1
	step
		goto 39.0,23.2
		.talk Harrison Jones##48558
		..turnin Bad Datas##28403
		..accept I'll Do It By Hand##28404
	step
		goto 39.6,23.6
		.from Lunar Crystal##48529+
		.' Defeat the Titanic Guardian |q 28404/1
	step
		goto 39.0,23.2
		.talk Harrison Jones##48558
		..turnin I'll Do It By Hand##28404
	step
		goto 42.2,25.9
		.talk Sullah##48621
		..accept Sullah's Gift##28482
	step
		goto 41.4,5.6
		.talk Harrison Jones##48698
		..turnin Sullah's Gift##28482
		..accept Fire From the Sky##28497
	step
		goto 41.4,5.6
		.clicknpc Confiscated Artillery##48699
		.' Use the Designate Target ability on your hotbar on the Schnottz Infantrymen
		.' Slay 100 Schnottz Infantrymen |q 28497/1
	step
		goto 41.4,5.6
		.talk Harrison Jones##48698
		..turnin Fire From the Sky##28497
		..accept See You on the Other Side!##28613
	step
		goto 36.1,15.8
		.talk Harrison Jones##47158
		..turnin See You on the Other Side!##28613
		..accept Fortune and Glory##27748
		.' Follow Harrison Jones and fight the Obsidian Colossus |tip Avoid the pink shadow runes on the ground when the Obsidian Colossus casts them.  You will see messages pop up on your screen letting you know what to do.
		.from Obsidian Colossus##46646
		.' Defeat the Obsidian Colossus |q 27748/1
	step
		goto 33.4,19.7
		.talk Harrison Jones##49151
		..turnin Fortune and Glory##27748
		..accept Harrison Jones and the Temple of Uldum##28612
		.' Watch the cutscene
		.' Discover the Coffer of Promise |q 28612/1
	step
		goto 32.6,30.9
		.talk Brann Bronzebeard##49204
		..turnin Harrison Jones and the Temple of Uldum##28612
		..accept Put That Baby in the Cradle!##28621
	step
		goto 32.6,30.7
		.talk Harrison Jones##49203
		..turnin Put That Baby in the Cradle!##28621
		..accept Three if by Air##28622
	step
		goto 32.0,29.9
		.clicknpc Signal Flare Position##49216 |use Harrison's Signal Flares##64668
		.' Place the North Signal Flare |q 28622/1
	step
		goto 31.4,30.8
		.clicknpc Signal Flare Position##49216|use Harrison's Signal Flares##64668
		.' Place the West Signal Flaare |q 28622/2
	step
		goto 32.0,31.6
		.clicknpc Signal Flare Position##49216 |use Harrison's Signal Flares##64668
		.' Place the South Signal Flare |q 28622/3
	step
		goto 44.9,67.3
		.talk Brann Bronzebeard##49248
		..turnin Three if by Air##28622
		..accept The Coffer of Promise##28633
	step
		goto 45.0,67.3
		.click Coffer of Promise##9968
		.get Titan Discs |q 28633/1
	step
		goto 44.9,67.3
		.talk Brann Bronzebeard##49351
		..turnin The Coffer of Promise##28633
]])

ZygorGuidesViewer:RegisterInclude("A_Twilight_Leveling",[[
	step
		goto Stormwind City,62.9,71.6
		.click Hero's Call Board##10016
		..accept Hero's Call: Twilight Highlands!##28716
	step
		goto 85.7,31.8
		.talk King Varian Wrynn##29611
		..turnin Hero's Call: Twilight Highlands!##28716
		..accept My Son, the Prince##26960
	step
		goto 85.7,31.6
		.talk Anduin Wrynn##1747
		..' Tell him to come with you
		.' Become Introduced to Anduin |q 26960/1
	step
		goto 85.7,31.8
		.talk King Varian Wrynn##29611
		..turnin My Son, the Prince##26960
		..accept Rallying the Fleet##26975
		..accept Twilight Investigation##26977
	step
		goto 85.1,31.3
		.talk Major Samuelson##2439
		..turnin Twilight Investigation##26977
		..accept The Usual Suspects##26997
	step
		goto 29.3,26.5
		.talk Stormwind Dock Worker##29152
		.' Interrogate 6 Dock Workers |q 26997/1
	step
		'Next to you:
		.talk Anduin Wrynn##44293
		..turnin The Usual Suspects##26997
		.' If Anduin Wrynn is not next to you, you can find in Stormwind Keep at [85.7,31.6] |tip Talk to him and tell him to come with you, if you have to go get him again.
	step
		goto 33.1,39.4
		.' Go to this spot
		.' Escort Anduin to Supply Sergeant Graves |q 26975/1
	step
		goto 33.1,39.5
		.talk Supply Sergeant Graves##44749
		..turnin Rallying the Fleet##26975
		..accept Missing Parts##27038
	step
		'Next to you:
		.talk Anduin Wrynn##44293
		..accept Peasant Problems##27044
		.' If Anduin Wrynn is not next to you, you can find in Stormwind Keep at [85.7,31.6] |tip Talk to him and tell him to come with you, if you have to go get him again.
	step
		goto 34.6,46.1
		.click Missing Parts##1211+
		.get 5 Missing Parts |q 27038/1
	step
		goto 34.8,38.2
		.talk Fargo Flintlocke##44806
		..turnin Missing Parts##27038
	step
		'Next to you:
		.talk Anduin Wrynn##44293
		..accept He's Holding Out on Us##27064
		.' If Anduin Wrynn is not next to you, you can find in Stormwind Keep at [85.7,31.6] |tip Talk to him and tell him to come with you, if you have to go get him again.
	step
		goto 52.0,5.8
		.' Go to this spot
		.' Escort Prince Anduin to Farmer Wollerton |q 27044/1
		.' If Anduin Wrynn is not next to you, you can find in Stormwind Keep at [85.7,31.6] |tip Talk to him and tell him to come with you, if you have to go get him again.
		' |modelnpc 44293
	step
		goto 52.1,6.0
		.talk Farmer Wollerton##44807
		..turnin Peasant Problems##27044
		..accept Unholy Cow##27060
	step
		goto 43.8,4.6
		.' Go to this spot
		.' Discover the Crime Scene |q 27060/1
		.from Twilight Striker##44808+
		.' Protect Prince Anduin |q 27060/2
	step
		'Next to you:
		.talk Anduin Wrynn##44293
		..turnin Unholy Cow##27060
		.' If Anduin Wrynn is not next to you, you can find in Stormwind Keep at [85.7,31.6] |tip Talk to him and tell him to come with you, if you have to go get him again.
	step
		goto 80.2,62.1
		.' Go inside this building, up the stairs, and then up the spiral staircase
		.' Allow Anduin to Examine Samuelson's Papers |q 27064/1
		.' If Anduin Wrynn is not next to you, you can find in Stormwind Keep at [85.7,31.6] |tip Talk to him and tell him to come with you, if you have to go get him again.
		' |modelnpc 44293
	step
		'Next to you:
		.talk Anduin Wrynn##44293
		..turnin He's Holding Out on Us##27064
		..accept Expert Opinion##28807
		.' If Anduin Wrynn is not next to you, you can find in Stormwind Keep at [85.7,31.6] |tip Talk to him and tell him to come with you, if you have to go get him again.
	step
		goto 81.3,63.5
		.talk Master Mathias Shaw##332
		..turnin Expert Opinion##28807
		..accept The Old Barracks##27072
	step
		goto 39.8,56.8
		.kill 6 Crazed Cultist##44814+ |q 27072/1
	step
		goto 37.2,56.2
		.talk Jack Bauden##50049
		.|tip He is downstairs in this house.
		..turnin The Old Barracks##27072
		..accept Cataclysm in the Catacombs##27092
	step
		goto 52.9,51.0 |n
		.' Enter the Cathedral |goto 52.9,51.0,0.5 |noway |c
	step
		goto 51.3,44.3 |n
		.' Follow the spiral ramp down |goto 51.3,44.3,0.5 |noway |c
	step
		goto 53.2,42.6 |n
		.' Follow the stairs down |goto 53.2,42.6,0.5 |noway |c
	step
		goto 50.6,42.2
		.kill The Black Bishop##44816 |q 27092/1
	step
		goto 50.2,42.6
		.click Pile of Explosives##9278
		..turnin Cataclysm in the Catacombs##27092
		..accept A Villain Unmasked##27106
	step
		goto 85.1,31.0
		.talk Major Samuelson##2439
		..' Tell him it's over
		.' Unmask Major Samuelson |q 27106/1
		.kill Samuelson Unmasked##45014 |q 27106/2
	step
		goto 85.8,31.7
		.talk King Varian Wrynn##29611
		..turnin A Villain Unmasked##27106
		..accept Twilight Shores##28238
	step
		goto 26.1,47.3
		.talk Fargo Flintlocke##44806
		..turnin Twilight Shores##28238
		..accept Twilight Shores##28832
	step
		goto 25.9,47.6
		.clicknpc Flintlocke's Seaplane##50262
		.' Ride to Twilight Highlands |goto Twilight Highlands |noway |c |q 28832
	step
		goto Twilight Highlands,81.0,79.4
		.talk Lieutenant Fawkes##49022
		..turnin Twilight Shores##28832
		..accept Welcome to Highbank!##28596
	step
		goto 81.1,77.3
		.from Axebite Infantry##49008+
		.kill 10 Horde Attackers |q 28596/1
	step
		goto 81.0,79.4
		.talk Lieutenant Fawkes##49022
		..turnin Welcome to Highbank!##28596
	step
		goto 81.0,79.4
		.talk Fargo Flintlocke##49252
		..accept Burnin' at Both Ends##28597
	step
		goto 81.1,77.3
		.clicknpc Cannon Powder Barrel##49143+
		.get 10 Cannon Powder |q 28597/1
	step
		goto 78.8,76.8
		.talk Fargo Flintlocke##49252
		..turnin Burnin' at Both Ends##28597
		..accept Aiming High##28598
	step
		'You may have to wait for a few minutes, so just stand here and wait
		.' Wait to be launched from Flintlocke's Cannon |q 28598/1
	step
		'Go downstairs in the zeppelin
		.' Use Flintlocke's Explosives while downstairs |use Flintlocke's Explosives##64660
		.' Destroy the Skyshredder |q 28598/2
	step
		goto 78.9,76.7
		.talk Fargo Flintlocke##49252
		..turnin Aiming High##28598
		..accept Kurdran's Waitin'##28599
	step
		goto 79.1,78.3
		.' Go upstairs in the fort
		.talk Kurdran Wildhammer##45167
		..turnin Kurdran's Waitin'##28599
		..accept Our Boys on the Shore##27338
	step
		goto 79.3,78.5
		.talk Simon Chandler##45170
		..accept Salvage Operation##27177
		..accept Naga Reinforcements##27178
	step
		goto 76.0,80.0
		.talk Ephram Hardstone##45171
		..accept Siren's Song##27200
	step
		goto 76.1,79.8
		.from Ophelia##45183
		.' Slay Ophelia and Protect Ephram |q 27200/1
	step
		goto 76.0,80.0
		.talk Ephram Hardstone##45171
		..turnin Siren's Song##27200
	step
		goto 76.2,83.0
		.click Water-Logged Crate##335+
		.get 8 Recovered Supplies |q 27177/1
		.from Blackscale Seacaller##45182+, Blackscale Myrmidon##45179+
		.' Slay 10 Blackscale Naga |q 27178/1
	step
		goto 79.3,78.5
		.' Go upstairs in the fort
		.talk Simon Chandler##45170
		..turnin Salvage Operation##27177
		..turnin Naga Reinforcements##27178
	step
		goto 81.65,77.1
		.talk Glenn Arbuckle##47119
		..fpath Highbank
	step
		goto 76.8,69.8
		.talk Lieutenant Emry##45169
		..turnin Our Boys on the Shore##27338
		..accept Scouting the Shore##27341
		..accept Landgrab##27366
	step
		goto 77.0,69.9
		.talk Fargo Flintlocke##49252
		..accept Shredderectomy##27433
	step
		goto 77.5,65.3
		.' Go to this spot
		.' Scout the Beach Head Control Point |q 27341/1
	step
		goto 77.4,67.1
		.kill 12 Axebite Marine##45175+ |q 27366/1 |tip Be careful and pay attention not to stand too close to the red arrows bouncing above the ground.  Cannon balls land at the arrows a few seconds after the arrows appear, and they will hurt you a lot if they hit you.
	step
		goto 74.3,68.0
		.from Diamond-Blade Shredder##45185+
		.get 5 Abused Shredder Parts |q 27433/1
		.' You can find more Shredders to kill at [Twilight Highlands,69,65.5]
	step
		goto 76.8,69.8
		.talk Lieutenant Emry##45169
		..turnin Scouting the Shore##27341
		..turnin Landgrab##27366
		..accept Bird Down! Bird Down!##27514
	step
		goto 77.0,69.9
		.talk Fargo Flintlocke##45168
		..turnin Shredderectomy##27433
		..accept Siege Tank Rescue##27468
	step
		goto 73.4,71.2
		.talk Siege Tank Commander##45524
		..' Tell him you'll cover him while he makes repairs
		.' Speak to a Siege Tank Commander |q 27468/1
		.from Axebite Grunt##45187+
		.' Defend the Siege Tank |q 27468/2
	step
		goto 77.0,69.9
		.talk Fargo Flintlocke##45168
		..turnin Siege Tank Rescue##27468
	step
		goto 67.7,66.0
		.talk Thordun Hammerblow##45172
		..turnin Bird Down! Bird Down!##27514
		..accept Roots'll Do 'Er##27515
	step
		goto 71.4,66.2
		.click Thorny Stankroot##414+
		.get 8 Thorny Stankroot |q 27515/1
	step
		goto 67.7,66.0
		.talk Thordun Hammerblow##45172
		..turnin Roots'll Do 'Er##27515
		..accept Wings Over Highbank##27516
	step
		goto 67.7,66.0
		.talk Thordun Hammerblow##45172
		..' Tell him you're ready
		.' Fly with Thordun Hammerblow to Highbank |q 27516/1
	step
		goto 79.4,78.5
		.talk Innkeeper Francis##49688
		.home Highbank
	step
		goto 79.1,78.3
		.' Go upstairs in the fort
		.talk Kurdran Wildhammer##45167
		..turnin Wings Over Highbank##27516
		..accept Any Portal in a Storm##27537
	step
		goto 79.2,78.3
		.talk Thordun Hammerblow##45172
		..accept The Perfect Poultice##27538
	step
		goto 67.7,46.9
		.from Muddied Water Elemental##44011+
		.get 5 Whirlpool Core |q 27537/1
		.click Verrall River Muck##10352
		.get 10 Verrall River Muck |q 27538/1
	step
		goto 79.4,77.6
		.talk Talaa##45173
		..turnin Any Portal in a Storm##27537
		..turnin The Perfect Poultice##27538
		..accept The Way is Open##27545
	step
		goto 79.1,78.3
		.' Go upstairs in the fort
		.talk Kurdran Wildhammer##45167
		..turnin The Way is Open##27545
	step
		goto 79.2,78.3
		.talk Thordun Hammerblow##45172
		..accept Firebeard's Patrol##27621
	step
		goto 60.1,57.9
		.talk Keegan Firebeard##46804
		..turnin Firebeard's Patrol##27621
		..accept Welcome Relief##27803
		..accept The Only Homes We Have##27804
	step
		goto 60.4,58.1
		.talk Innkeeper Corlin##49795
		.home Firebeard's Patrol
	step
		goto 60.4,58.3
		.talk Cailin Longfellow##46814
		..accept Small Comforts##27805
	step
		goto 60.4,57.65
		.talk Farstad Stonegrip##47147
		..fpath Firebeard's Patrol
	step
		goto 59.8,56.2
		.' Use your Wildhammer Water Bucket next to fires to extinguish them |use Wildhammer Water Bucket##62508
		.|tip If you lose the bucket, run near the Firebeard Militia dwarves and they'll toss you a new one.
		.click Meara's Dried Roses##10073
		.get Meara's Dried Roses |q 27805/1
		.|tip This is a small plant, found on the ground or in houses around this area.
	step
		goto 59.5,55.9
		.' Use your Wildhammer Water Bucket next to fires to extinguish them |use Wildhammer Water Bucket##62508
		.|tip If you lose the bucket, run near the Firebeard Militia dwarves and they'll toss you a new one.
		.click Aprika's Lost Doll##7514
		.|tip This is a small white doll sitting on the ground inside this ruined burning house.
		.get Aprika's Doll |q 27805/3
	step
		goto 59.3,56.9
		.' Use your Wildhammer Water Bucket next to fires to extinguish them |use Wildhammer Water Bucket##62508
		.|tip If you lose the bucket, run near the Firebeard Militia dwarves and they'll toss you a new one.
		.click Parlan's Ivory Hammer##8215
		.|tip Looks like a small white hammer sitting on a forge inside this burning building.
		.get Parlan's Ivory Hammer |q 27805/2
	step
		goto 59.8,56.9
		.' Use your Wildhammer Water Bucket next to fires |use Wildhammer Water Bucket##62508
		.' Extinguish 50 Village Fires |q 27804/1
		.kill 8 Subjugated Firestarter##46838+ |q 27803/1
	step
		goto 60.2,58.0
		.talk Keegan Firebeard##46804
		..turnin Welcome Relief##27803
		..turnin The Only Homes We Have##27804
		..accept Honorable Bearing##27806
	step
		goto 60.4,58.3
		.talk Cailin Longfellow##46814
		..turnin Small Comforts##27805
	step
		goto 57.5,58.1
		.talk Iain Firebeard##46805
		..turnin Honorable Bearing##27806
		..accept Clan Mullan##27807
		..accept Stubborn as a Doyle##27808
		..accept Firebeard Bellows##27809
	step
		goto 50.8,60.2
		.talk Duglas Mullan##46811
		..turnin Clan Mullan##27807
		..accept The Fighting Spirit##27810
	step
		goto 50.8,60.2
		.talk Edana Mullan##46812
		..accept The Scent of Battle##27811
	step
		goto 51.1,59.9
		.talk Mullan Gryphon Rider##46813
		..' Tell him he's not backing out
		.from Mullan Gryphon Rider
		.' Defeat a Mullan Gryphon Rider |q 27810/1
	step
		goto 50.8,60.2
		.talk Duglas Mullan##46811
		..turnin The Fighting Spirit##27810
	step
		goto 57.3,67.6
		.talk Mullan Gryphon##46968
		..' Let the gryphons smell the piece of Charred Highland Birch |tip If you come across a gyphon chained to the ground simply kill the Twilight Trapper and the Twilight Trapper Bindings. Other gryphons may need healing, if you cannot heal them move on.
		.' Find and return 8 Mullan Gryphons |q 27811/1
		|modelnpc Twilight Trapper Bindings##46975+
		|modelnpc Twilight Trapper##46984+
	step
		goto 61.4,67.4
		.talk Keeland Doyle##47317
		..turnin Stubborn as a Doyle##27808
		..accept The Fate of the Doyles##27999
	step
		goto 50.8,60.2
		.talk Edana Mullan##46812
		..turnin The Scent of Battle##27811
	step
		goto 50.8,60.3
		.talk Duglas Mullan##46811
		..accept The Loyalty of Clan Mullan##27812
	step
		goto 57.5,58.1
		.talk Iain Firebeard##46805
		..turnin The Fate of the Doyles##27999
		..turnin The Loyalty of Clan Mullan##27812
	step
		goto 62.5,48.4
		.talk Mackay Firebeard##46850
		..turnin Firebeard Bellows##27809
		..accept Death Worthy of a Dragonmaw##27813
	step
		goto 62.6,48.6
		.talk Ella Forgehammer##48046
		..accept The Lost Brother##28233
	step
		goto 62.6,48.6
		.talk Brom Forgehammer##46806
		..accept Anything We Can Get##27814
	step
		goto 63.1,47.6
		.talk Bahrum Forgehammer##48053
		..turnin The Lost Brother##28233
		..accept They Took Me Pants!##28234
	step
		goto 62.3,47.0
		.' Go upstairs in this building
		.from Gorosh the Pant Stealer##48102
		.get Bahrum's Pants |q 28234/1
	step
		goto 62.3,46.8
		.talk Injured Dragonmaw Straggler##47465
		..' Help the orcs up
		.kill Dragonmaw Straggler##46851
		.|tip You can kill the agrressive Stragglers or help the injured ones, either will complete this step.
		.' Defeat 6 Dragonmaw Stragglers |q 27813/1
		.click Dragonmaw Weapon Axe##9561+
		.click Dragonmaw Weapon Rack##9921+
		.click Dragonmaw Weapon Crate##5271+
		.get 8 Dragonmaw Weapon |q 27814/1
	step
		goto 63.2,47.6
		.talk Bahrum Forgehammer##48053
		..turnin They Took Me Pants!##28234
	step
		goto 62.5,48.4
		.talk Mackay Firebeard##46850
		..turnin Death Worthy of a Dragonmaw##27813
	step
		goto 62.6,48.6
		.talk Brom Forgehammer##46806
		..turnin Anything We Can Get##27814
	step
		goto 62.5,48.4
		.talk Mackay Firebeard##46850
		..accept Somethin' for the Boys##27815
	step
		goto 57.5,58.1
		.talk Iain Firebeard##46805
		..turnin Somethin' for the Boys##27815
		..accept Personal Request##27816
	step
		goto 60.2,57.8
		.talk Keegan Firebeard##46804
		..turnin Personal Request##27816
		..accept Dropping the Hammer##27817
	step
		goto 59.9,57.3
		.clicknpc Firebeard Gryphon Mount##47316
		.' Ride the Firebeard Gryphon Mount |invehicle |c |q 27817
	step
		goto 58.8,53.1
		.' While flying on the Firebeard Gryphon Mount:
		.' Use the abilities on your action bar to kill Twilight Stormbenders on the floating rocks |tip Use your Storm Shield ability when someone casts a lightning attack on you.
		.kill 12 Twilight Stormbender##47199+ |q 27817/1
	step
		goto 58.6,51.7
		.' While flying on the Firebeard Gryphon Mount:
		.' Use the abilities on your action bar to weaken Servias Windterror
		.' Eventually, you will get off the gryphon and fight him regularly
		.kill Servias Windterror##46839 |q 27817/2 |tip When he casts his lightning spell on the ground, move away from that spot to avoid damage when it explodes.
	step
		goto 60.2,57.9
		.talk Keegan Firebeard##46804
		..turnin Dropping the Hammer##27817
		..accept Dunwalds Don't Die##27640
		..accept A Coward's Due##28001
	step
		goto 46.7,66.0 |n
		.' Enter this building |goto 46.7,66.0,0.5 |noway |c
	step
		goto 45.9,65.5
		.talk Keely Dunwald##46177
		..turnin Dunwalds Don't Die##27640
		..accept Donnelly Dunwald##27643
		..accept Eoin Dunwald##27644
		..accept Cayden Dunwald##27645
	step
		goto 45.9,65.4
		.talk Flynn Dunwald##46143
		..accept While Meeting The Family##27641
		..accept Sifting Through The Wreckage##27642
	step
		goto 45.8,71.7
		.' Cayden Dunwald can also be at [45.8,71.7]
		.talk Cayden Dunwald##46174
		..turnin Cayden Dunwald##27645
		..accept Once More Into The Fire##27648
	step
		goto 45.8,71.7
		.talk Cayden Dunwald##46174
		..' Tell him yeah...
		.' Escort Cayden Dunwald
		.' Accompany Cayden through Dunwald Market Row |q 27648/1
	step
		goto 47.9,74.5
		.talk Cayden Dunwald##46174
		..turnin Once More Into The Fire##27648
		.' Cayden Dunwald can also be at [45.8,71.7]
	step
		goto 52.9,74.3
		.talk Eoin Dunwald##46175
		..turnin Eoin Dunwald##27644
		..accept Anything But Water##27647
	step
		goto 52.25,70.6 |n
		.' Enter the building here |goto 52.25,70.6 |noway |c
	step
		goto 52.8,69.8
		.' Follow the path to the left and go downstairs.
		.click Sacred Ale Tap##7415
		.get Sacred Wildhammer Ale |q 27647/1
	step
		goto 52.4,70.3
		.talk Eoin Dunwald##46583
		..turnin Anything But Water##27647
		..accept A Steady Supply##27649
	step
		goto 46.4,59.1
		.talk Donnelly Dunwald##46176
		.|tip He patrols around these two houses, you may have to search for him.
		..turnin Donnelly Dunwald##27643
		..accept Finding Beak##27646
	step
		goto 45.4,60.0
		.' As you walk around doing quests:
		.talk Dunwald Victim##46609
		.click Wildhammer Ale Cask##7415
		.' Go into the basement of this building
		.' Search the cellar in southern Dunwald Hovel |q 27646/1
	step
		goto 46.4,53.8
		.' As you walk around doing quests:
		.talk Dunwald Victim##46609
		.click Wildhammer Ale Cask##7415
		.' Go into the basement of this building
		.' Search the cellar in northwestern Dunwald Hovel |q 27646/2
	step
		goto 48.4,52.6
		.' As you walk around doing quests:
		.talk Dunwald Victim##46609
		.click Wildhammer Ale Cask##7415
		.' Go to this spot
		.' Search the buildings in eastern Dunwald Hovel |q 27646/3
	step
		goto 46.0,58.7
		.talk Donnelly Dunwald##46176
		.|tip He patrols around these two houses.
		..turnin Finding Beak##27646
		..accept Home Again##27650
	step
		goto 45.9,54.8
		.from Bloodgorged Ettin##46145+, Twilight Scavenger##46183+, Twilight Pillager##46144+, Twilight Shadeprowler##46526+
		..' Welcome #20# Twilight Guests to Dunwald |q 27641/1
		.talk Dunwald Victim##46609
		..' Find #12# Dunwald Victims |q 27642/1
		.click Wildhammer Ale Cask##7415
		..get 6 Wildhammer Ale |q 27649/1
		.|tip The best way to find victims and ale casks are inside houses.
		.' You can find more of all these things:
		.' Around [47.0,66.1]
		.' Around [46.4,72.6]
		.' Around [50.7,69.8]
	step
		goto 46.7,66.0 |n
		.' Enter this building |goto 46.7,66.0,0.5 |noway |c
	step
		goto 46.0,65.5
		.talk Keely Dunwald##46177
		..turnin Home Again##27650
		..accept Doing It Like a Dunwald##27651
	step
		goto 50.5,70.7
		.talk Eoin Dunwald##46627
		..turnin A Steady Supply##27649
	step
		goto 50.5,70.7
		.talk Flynn Dunwald##46143
		..turnin While Meeting The Family##27641
		..turnin Sifting Through The Wreckage##27642
	step
		goto 50.5,70.6
		.talk Flynn Dunwald##46628
		..' Tell him you're in
		.kill Darunga##46624 |q 27651/1
	step
		goto 50.5,70.6
		.talk Flynn Dunwald##46628
		..turnin Doing It Like a Dunwald##27651
	step
		goto 49.0,29.8
		.talk Colin Thundermar##46591
		..turnin A Coward's Due##28001
		..accept Dragonmaw Takedown##27754
		..accept My Sister, Fanny##28369
	step
		goto 49.8,29.2
		.talk Low Shaman Blundy##48010
		..accept Fight Like a Wildhammer##27752
	step
		goto 49.8,29.3
		.talk Fanny Thundermar##48013
		..turnin My Sister, Fanny##28369
		..accept Never Leave a Dinner Behind##27753
	step
		goto 49.5,30.4
		.talk Naveen Tendernose##49591
		.home Thundermar
	step
		goto 48.5,28.1
		.talk Doran Talonheart##47154
		..fpath Thundermar
	step
		goto 46.2,37.4
		.' Around this area and inside houses:
		.from Dragonmaw Marauder##46310+
		..get 8 Dragonmaw Insignia |q 27754/1
		.click Thundermar Ale Keg##4631+
		..get 10 Wildhammer Keg |q 27752/1
		.click Wildhammer Food Stores##10034
		..get 15 Wildhammer Food Stores |q 27753/1
		.' You can find more around [49.1,37.3]
		'|model Wildhammer Food Stores##224
		'|model Wildhammer Food Stores##229
	step
		goto 49.0,29.8
		.talk Colin Thundermar##46591
		..turnin Dragonmaw Takedown##27754
	step
		goto 49.8,29.2
		.talk Low Shaman Blundy##48010
		..turnin Fight Like a Wildhammer##27752
	step
		goto 49.8,29.3
		.talk Fanny Thundermar##48013
		..turnin Never Leave a Dinner Behind##27753
	step
		goto 49.8,29.2
		.talk Low Shaman Blundy##48010
		..accept A Vision of Twilight##28241
	step
		goto 49.1,29.4
		.talk Nivvet Channelock##48014
		..accept Tempered in Elemental Flame##28211
		..accept Hot Stuff##28212
		..accept Potential Energy##28215
	step
		goto 49.0,29.7
		.talk Colin Thundermar##46591
		..accept Magmalord Falthazar##28216
	step
		goto 57.9,33.5
		.click Eye of Twilight##7011
		..turnin A Vision of Twilight##28241
		..accept We All Must Sacrifice##28242
	step
		goto 58.0,32.6
		.kill 10 Shaman of the Black##46322+ |q 28242/1
		.from Obsidian Stoneslave##47226+
		.get 10 Twisted Elementium Loop |q 28215/1
	step
		goto 57.9,33.5
		.click Eye of Twilight##7011
		..turnin We All Must Sacrifice##28242
		..accept The Eyes Have It##28243
	step
		goto 49.1,29.4
		.talk Nivvet Channelock##48014
		..turnin Potential Energy##28215
	step
		goto 49.7,29.2
		.talk Low Shaman Blundy##48010
		..turnin The Eyes Have It##28243
		..accept Eye Spy##28244
	step
		goto 49.8,29.1
		.click Eye of Twilight##7011
		.' Watch the cutscene
		.' Peered into the Eye |q 28244/1
	step
		goto 49.7,29.2
		.talk Low Shaman Blundy##48010
		..turnin Eye Spy##28244
	step
		goto 42.5,23.5
		.from Magmalord Falthazar##48015
		.get Magmalord Falthazar's Head |q 28216/1
	step
		goto 42.2,24.3
		.from Unbound Emberfiend##48016+
		.get 5 Molten Fury |q 28212/1
		.click Tempered Spear##8490
		.get 8 Tempered Spear |q 28211/1
	step
		goto 49.0,29.7
		.talk Colin Thundermar##46591
		..turnin Magmalord Falthazar##28216
	step
		goto 49.1,29.4
		.talk Nivvet Channelock##48014
		..turnin Tempered in Elemental Flame##28211
		..turnin Hot Stuff##28212
		..accept Tear Them From the Sky!##28280
	step
		goto 49.2,29.8
		.' Use your Shoulder-Mounted Drake-Dropper on Dragonmaw Black Drakes |use Shoulder-Mounted Drake-Dropper##63393 |tip They are flying in the sky around this area.
		.kill 8 Dragonmaw Black Drake##48197+ |q 28280/1
	step
		goto 49.1,29.4
		.talk Nivvet Channelock##48174
		..turnin Tear Them From the Sky!##28280
	step
		goto 49.0,29.7
		.talk Colin Thundermar##48173
		..accept Last Stand at Thundermar##28281
	step
		goto 48.1,30.0
		.kill 8 Dragonmaw Skyclaw##48194 |q 28281/1
	step
		goto 49.0,29.7
		.talk Colin Thundermar##48173
		..turnin Last Stand at Thundermar##28281
		..accept Narkrall, The Drake-Tamer##28282
	step
		goto 49.0,29.7
		.talk Colin Thundermar##48173
		..' Tell him you're ready to fight him!
		.kill Narkrall Rakeclaw##48257 |q 28282/1
	step
		goto 49.0,29.7
		.talk Colin Thundermar##48173
		..turnin Narkrall, The Drake-Tamer##28282
		..accept The Kirthaven Summit##28294
	step
		goto 54.6,18.0
		.talk Vaughn Blusterbeard##49574
		.home Kirthaven
	step
		goto 54.3,16.7
		 .talk Lachlan MacGraff##48367
		..turnin The Kirthaven Summit##28294
	step
		goto 54.9,17.2
		.talk Kurdran Wildhammer##48365
		..accept The Bachelor##28346
	step
		goto 54.4,16.8
		.talk Keegan Firebeard##48364
		..turnin The Bachelor##28346
		..accept Rescue at Glopgut's Hollow##28377
	step
		goto 38.1,34.5
		.talk Colin Thundermar##48472
		..turnin Rescue at Glopgut's Hollow##28377
		..accept Find Fanny##28378
		..accept Ogre Bashin'##28379
	step
		goto 37.6,33.4 |n
		.' Enter the cave |goto 37.6,33.4,0.5 |noway |c
	step
		goto 35.0,31.1
		.' Go to this spot inside the cave
		.' Rescue Fanny Thundermar |q 28378/1
		' |modelnpc 48530
	step
		goto 37.6,33.4 |n
		.' Leave the cave |goto 37.6,33.4,0.5 |noway |c
	step
		goto 38.7,30.9
		.from Glopgut Pounder##48474+, Glopgut Hurler##48475+, Glopgut Basher##48498+
		.' Slay 10 Glopgut Ogres |q 28379/1
	step
		goto 38.1,34.5
		.talk Colin Thundermar##48472
		..turnin Find Fanny##28378
		..turnin Ogre Bashin'##28379
		..accept The Bachelorette##28407
	step
		goto 54.7,17.9
		.talk Fanny Thundermar##48530
		..turnin The Bachelorette##28407
	step
		goto 54.6,17.5
		.talk Russell Brower##48366
		..accept Words and Music By...##28413
	step
		goto 54.6,17.5
		.talk Russell Brower##48366
		..' Tell him you're ready, let's write a song
		.' Create a song |q 28413/1
	step
		goto 54.6,17.5
		.talk Russell Brower##48366
		..turnin Words and Music By...##28413
	step
		goto 54.3,16.7
		.talk Lachlan MacGraff##48367
		..accept Something Bold##28408
		..accept Something Brewed##28409
		..accept Something Stolen##28410
		..accept Something Stewed##28411
	step
		goto 53.4,24.5
		.from Highland Elk##46970+, Highland Doe##46971+
		..get 8 Fresh Venison |q 28411/1
		.from Highland Worg##46153+
		..get 5 Worg Rib |q 28411/2
		.' You can find more all around [57.4,10.7]
	step
		goto 56.8,21.9
		.from Tawny Owl##46162+
		.click Pristine Owl Feather##3651+
		.get 12 Pristine Owl Feather |q 28408/1
		.' You can find more owls at [Twilight Highlands,62.4,23]
	step
		goto 64.4,22.6
		.talk Hammelhand##48758
		..' Tell him you're here to escort a delivery to Kirthaven
		.' Follow the dwarves
		.from Dragonmaw Skirmisher##48799+
		.' Escort the Supply Caravan |q 28409/1
	step
		goto 75.1,33.8
		.' Find a zeppelin flying north or south along this coast between Dragonmaw Port and The Krazzworks
		.' Fly to the zeppelin and land on it
		.|tip The zepplins have a few Horde mobs on it, which will turn you PvP if you get hit by or attack them.
		.' Go downstairs on the zeppelin
		.click Crate of Fine Cloth##9105+
		.get Fine Dark Cloth |q 28410/1
	step
		goto 54.3,16.7
		.talk Lachlan MacGraff##48367
		..turnin Something Bold##28408
		..turnin Something Brewed##28409
		..turnin Something Stolen##28410
		..turnin Something Stewed##28411
	step
		goto 54.3,16.8
		.talk Grundy MacGraff##48368
		..accept Wild, Wild, Wildhammer Wedding##28655
	step
		goto 54.3,16.8
		.talk Grundy MacGraff##48368
		..' Tell him to let the wedding commence!
		.' Watch the cutscene
		.from The Beast Unleashed##49234
		.' Complete the Nuptials |q 28655/1
	step
		goto 55.3,17.3
		.talk Kurdran Wildhammer##49358
		..turnin Wild, Wild, Wildhammer Wedding##28655
	step
		goto 55.2,17.3
		.talk Lachlan MacGraff##49374
		..accept The Maw of Madness##27374 |or
		tip You could skip this breadcrumb quest. |or |condition completedq(27299)
	step
		goto 44.0,10.6
		.talk Earthcaller Torunscar##43901
		..turnin The Maw of Madness##27374
		..accept Torn Ground##27299
	step
		goto 41.8,11.4
		.kill 3 Tentacle of Iso'rath##45394 |q 27299/1
	step
		goto 44.0,10.6
		.talk Earthcaller Torunscar##45332
		..turnin Torn Ground##27299
		..accept Pushing Back##27300
	step
		goto 44.0,11.3
		.talk Earthmender Duarn##45391
		..accept Unbroken##27301
	step
		goto 44.4,11.6
		.talk Initiate Goldmine##45432
		..accept Simple Solutions##27302
	step
		goto 44.2,18.1
		.talk Earthcaller Yevaa##45362
		..turnin Unbroken##27301
		..accept Mercy for the Bound##27303
	step
		goto 42.3,17.2
		.from Twilight Captivator##45359+, Twilight Bonebreaker##45334+
		.kill 12 Drakgor cultists |q 27300/1
		.from Bound Fleshburner##45358+
		.get 5 Fleshburner Heart |q 27303/1
		.click Barrel of Pyreburn Oil##457+
		.get 10 Pyreburn Oil |q 27302/1
	step
		goto 44.4,11.6
		.talk Initiate Goldmine##45432
		..turnin Simple Solutions##27302
	step
		goto 43.8,11.3
		.talk Earthcaller Yevaa##45386
		..turnin Mercy for the Bound##27303
	step
		goto 44.0,10.6
		.talk Earthcaller Torunscar##45332
		..turnin Pushing Back##27300
		..accept The Maw of Iso'rath##27376
	step
		goto 44.5,10.6
		.clicknpc Earthen Ring Gryphon##50473
		.' Join the assault on Iso'rath |q 27376/1
	step
		goto 48.4,14.6
		.talk Earthcaller Yevaa##47991
		..turnin The Maw of Iso'rath##27376
		..accept Devoured##27377
	step
		'Let the oozes kill you.
		.' Survive Iso'rath's defenses |q 27377/1
		.talk Thrall##48051
		..turnin Devoured##27377
		..accept The Worldbreaker##27378
	step
		'Deathwing will attack you and Thrall
		.' Aid Thrall in battling Deathwing |q 27378/1
		.' Click the Quest Complete box that pops up
		..turnin The Worldbreaker##27378
		..accept The Terrors of Iso'rath##27379
	step
		goto 49.6,15.8
		.' Stand in the yellow bubbles on the ground around this area to heal |tip Watch the Digestive Acids bar near the bottom of your screen.  Don't let it get full.  Go into the yellow bubbles to lower it.
		.from Tentacle of Iso'rath##48790
		.|tip If you are ranged, attack the tentacles from inside the bubble
		.' Save Stormcaller Jalara |q 27379/2
		' |modelnpc 48789
	step
		goto 49.1,13.1
		.' Stand in the yellow bubbles on the ground around this area to heal |tip Watch the Digestive Acids bar near the bottom of your screen.  Don't let it get full.  Go into the yellow bubbles to lower it.
		.from Tentacle of Iso'rath##48790
		.' Save Earthmender Duarn |q 27379/3
		' |modelnpc 48793
	step
		goto 47.0,13.1
		.' Stand in the yellow bubbles on the ground around this area to heal |tip Watch the Digestive Acids bar near the bottom of your screen.  Don't let it get full.  Go into the yellow bubbles to lower it.
		.from Tentacle of Iso'rath##48790
		.' Save Hargoth Dimblaze |q 27379/1
		' |modelnpc 48743
	step
		goto 47.5,15.6
		.' Stand in the yellow bubbles on the ground around this area to heal |tip Watch the Digestive Acids bar near the bottom of your screen.  Don't let it get full.  Go into the yellow bubbles to lower it.
		.from Tentacle of Iso'rath##48790
		.' Save Stormcaller Mylra |q 27379/4
		' |modelnpc 50469
	step
		goto 48.7,16.6
		.talk Earthcaller Yevaa##48059
		..turnin The Terrors of Iso'rath##27379
		..accept Nightmare##27380
	step
		goto 48.8,14.9
		.' Stand in the yellow bubbles on the ground around this area to heal |tip Watch the Digestive Acids bar near the bottom of your screen.  Don't let it get full.  Go into the yellow bubbles to lower it.
		.from Brain of Iso'rath##47960
		.' Kill Iso'rath |q 27380/1
	step
		goto 44.0,10.6
		.talk Earthcaller Torunscar##45332
		..turnin Nightmare##27380
	step
		goto 44.1,10.5
		.talk Golluck Rockfist##48265
		..accept Warm Welcome##27485
	step
		goto 27.6,21.4
		.' You will get captured by a red dragon
		.' Meet with Lirastrasza |q 27485/1
		' |modelnpc 49417
	step
		goto 29.3,25.9
		.talk Calen##45528
		..turnin Warm Welcome##27485
		..accept Even Dragons Bleed##27504
	step
		goto 29.9,31.3
		.talk Velastrasza##45522
		..turnin Even Dragons Bleed##27504
		..accept Draconic Mending##27505
	step
		goto 29.8,31.4
		.talk Baleflame##45562
		..accept Life from Death##27506
	step
		goto 29.7,33.1
		.' Protect the Vermillion Menders while they heal Celastrasza to full health
		.|tip You can speed this up by healing Celastrasza yourself
		.' Defend 5 Vermillion Menders |q 27505/1
		.from Twilight Wyrmkiller##45748+
		.' Use your Ruby Seeds on Twilight Wyrmkiller and Vermillion Mender corpses |use Ruby Seeds##61323
		.' Reclaim 6 Dragonkin corpses |q 27506/1
		' |modelnpc 45746
	step
		goto 29.9,31.3
		.talk Velastrasza##45522
		..turnin Draconic Mending##27505
	step
		goto 29.8,31.4
		.talk Baleflame##45562
		..turnin Life from Death##27506
	step
		goto 29.9,31.3
		.talk Velastrasza##45522
		..accept In Defense of the Redoubt##27564
	step
		goto 29.3,25.9
		.talk Calen##45528
		..turnin In Defense of the Redoubt##27564
		..accept Encroaching Twilight##27507
		..accept Breach in the Defenses##27509
	step
		goto 29.3,26.0
		.talk Lirastrasza##45518
		..accept Far from the Nest##27508
	step
		goto 28.5,24.8
		.talk Aquinastrasz##47121
		..fpath Vermillion Redoubt
	step
		goto 18.4,16.7 |n
		.' Enter the cave |goto 18.4,16.7,0.5 |noway |c
	step
		goto 18.0,16.9
		.' Use your Flashgrowth Mote next to the Twilight Portal |use Flashgrowth Mote##61385 |tip It looks like a blue and pink swirled portal in a metal case.
		.' Destroy the Twilight Portal |q 27509/1
	step
		goto 20.9,15.7
		.from Twilight Abductor##45648+, Twilight Flamequencher##45618+
		.kill 12 Twilight invaders |q 27507/1
		.clicknpc Vermillion Egg##45682
		.get 6 Vermillion Egg |q 27508/1
	step
		goto 29.3,26.0
		.talk Calen##45528
		..turnin Encroaching Twilight##27507
		..turnin Breach in the Defenses##27509
	step
		goto 29.3,26.0
		.talk Lirastrasza##45518
		..turnin Far from the Nest##27508
	step
		goto 29.3,26.0
		.talk Calen##45528
		..accept Mathias' Command##28101
	step
		goto 26.0,38.8
		.talk Master Mathias Shaw##47592
		..turnin Mathias' Command##28101
		..accept Easy Pickings##28103
		..accept Precious Goods##28104
	step
		goto 25.6,37.9
		.from Twilight Spearwarder##47490+
		.get Twilight Caravan Cargo Key |q 28104/1
		.click Twilight Caravan Chest##10106+
		.get Twilight's Hammer Gatestone |q 28104/2
		.kill 8 Twilight Spearwarder |q 28103/1
	step
		goto 26.0,38.8
		.talk Master Mathias Shaw##47592
		..turnin Easy Pickings##28103
		..turnin Precious Goods##28104
		..accept If The Key Fits##28108
	step
		'Next to you:
		.talk Master Mathias Shaw##47611
		..accept Paving the Way##28107
	step
		goto 29.5,51.7
		.' Go to this spot
		.' Open the Dragonmaw Gate |q 28108/1
		.' If you lost your squad, return to Master Mathias at [Twilight Highlands,26.0,38.8] to retrieve them
	step
		'Next to you:
		.talk Master Mathias Shaw##47611
		..turnin If The Key Fits##28108
		..accept Pressing Forward##28109
	step
		goto 27.5,54.6
		.from Twilight Sentinel##47406+, Twilight Guardsman##47394+, Twilight Stalker##47401+
		.' Kill 30 Wyrm's Bend Cultists |q 28107/1
	step
		'Next to you:
		.talk Master Mathias Shaw##47611
		..turnin Paving the Way##28107
	step
		goto 22.8,56.1
		.' Go to this spot
		.' Secure the Entrance to Grim Batol |q 28109/1
	step
		goto 22.1,56.6
		.talk Calen##47605
		..turnin Pressing Forward##28109
	step
		goto 21.8,57.0
		.talk Alexstrasza the Life-Binder##47603
		..accept Enter the Dragon Queen##28712
	step
		goto 14.9,16.3
		.talk Lirastrasza##49417
		..turnin Enter the Dragon Queen##28712
	step
		goto 14.1,15.4
		.talk Calen##49810
		..accept Battle of Life and Death##28758
	step
		goto 14.1,15.1
		.clicknpc Vermillion Vanguard##49910
		.' Use the abilities on your hotbar on Twilight Shadowdrakes
		.kill 8 Twilight Shadowdrake##49873 |q 28758/1
	step
		goto 22.1,56.6
		.talk Calen##47605
		..turnin Battle of Life and Death##28758
		..accept And the Sky Streaked Red##28171
	step
		goto 59.1,69.8
		.talk Lirastrasza##47902
		..turnin And the Sky Streaked Red##28171
		..accept A Fitting End##28191
		..accept Blackout##28173
	step
		goto 59.0,69.8
		.talk Velastrasza##47904
		..accept Shining Through the Dark##28175
	step
		goto 63.9,78.0
		.' Use Alexstrasza's Tear in the small cave beneath this huge tree |use Alexstrasza's Tear##63139
		.' Plant Alexstrasza's Tear |q 28175/1
	step
		goto 62.7,76.2
		.from Obsidian Viletongue##47796+, Obsidian Charscale##47797+
		.kill 10 Obsidian Dragonkin |q 28191/1
		.' Use your Wyrmhunter Hooks on Obsidian Pyrewings |use Wyrmhunter Hooks##63092 |tip You will get a message on your screen when the Obsidian Pyrewing is almost dead.  When you see that message, use your Wyrmhunter Hooks on another Obsidian Pyrewing to jump to it.  If you fall, it can hurt you a lot.
		.kill 8 Obsidian Pyrewing##46141 |q 28173/1
	step
		goto 59.1,69.8
		.talk Lirastrasza##47902
		..turnin A Fitting End##28191
		..turnin Blackout##28173
	step
		goto 59.0,69.8
		.talk Velastrasza##47904
		..turnin Shining Through the Dark##28175
	step
		goto 59.1,69.8
		.talk Lirastrasza##47902
		..accept Following the Young Home##28176
	step
		goto 59.3,82.5
		.' Use your Mother's Flame next to the big blue spikes eggs |use Mother's Flame##63126
		.' Hatch the Obsidian Whelps |q 28176/1
	step
		goto 55.4,83.5 |n
		.' Enter the cave |goto 55.4,83.5,0.5 |noway |c
	step
		goto 49.8,85.8
		.' Go to this spot
		.' Infiltrate the Obsidian Lair |q 28176/2
	step
		goto 44.9,91.0
		.talk Baleflame##47905
		..turnin Following the Young Home##28176
		..accept Last of Her Kind##28247
		.from Obsidia##47929
		.' Defeat Obsidia |q 28247/1
	step
		goto 55.4,83.5 |n
		.' Leave the cave |goto 55.4,83.5,0.5 |noway |c
	step
		goto 59.1,69.8
		.talk Lirastrasza##47902
		..turnin Last of Her Kind##28247
		..accept Victors' Point##28248
	step
		goto 43.4,57.4
		.talk Kurdran Wildhammer##45668
		..turnin Victors' Point##28248
		..accept Ogres & Ettins##27492
	step
		goto 43.4,57.3
		.talk Cassius the White##45669
		..accept Call in the Artillery##27496
		..accept SI:7 Drop##27490
	step
		goto 43.6,57.2
		.talk Ben Mora##49599
		.home Victor's Point
	step
		goto 43.9,57.3
		.talk Desmond Chadsworth##47118
		..fpath Victor's Point
	step
		goto 43.8,57.2
		.talk Angus Stillmountain##45904
		..' Tell him you're here to lead the Wildhammer squad and drop off the SI:7 agents
		.' Get your Wildhammer Squad |q 27490/1
	step
		goto 39.2,64.5
		.' Go to this spot and land on the flashing blue X on the ground
		.' Drop off the SI:7 |q 27490/2
	step
		goto 38.8,64.3
		.' Use your Artillery Flare |use Artillery Flare##61363
		.' Target the Northern Building |q 27496/1
	step
		goto 40.0,64.4
		.' Use your Artillery Flare |use Artillery Flare##61363
		.' Target the Northeastern Building |q 27496/2
	step
		goto 40.4,69.2
		.' Use your Artillery Flare |use Artillery Flare##61363
		.' Target the Southwestern Building |q 27496/3
	step
		goto 41.4,71.2
		.' Use your Artillery Flare |use Artillery Flare##61363
		.' Target the Southern Building |q 27496/4
	step
		goto 41.1,69.8
		.from Bloodeye Magelord##45795+, Bloodeye Brute##45787+, Twilight Ettin##45838+
		.kill 10 Bloodeye Clan Ogres & Ettins |q 27492/1
	step
		goto 43.4,57.3
		.talk Cassius the White##45669
		..turnin Call in the Artillery##27496
		..turnin SI:7 Drop##27490
	step
		goto 43.4,57.4
		.talk Kurdran Wildhammer##45668
		..turnin Ogres & Ettins##27492
		..accept Move the Mountain##27494
	step
		goto 38.1,66.2
		.click Hidden Explosives##9393
		.' Detonate the Hidden Explosives |q 27494/1
		.' Click the Quest Complete box that pops up
		..turnin Move the Mountain##27494
		..accept Signal the Attack##27498
	step
		goto 40.5,62.3
		.' Use your Attack Signal at the top of this tower |use Attack Signal##61511
		.' Signal the Attack |q 27498/1
		.' Click the Quest Complete box that pops up
		..turnin Signal the Attack##27498
		..accept Four Heads are Better than None##27500
	step
		goto 39.8,71.3 |n
		.' Enter the cave |goto 39.8,71.3,0.5 |noway |c
	step
		goto 37.6,71.3
		.from Za'brox##46017
		.get Za's Head |q 27500/1
		.get Brox's Head |q 27500/4
	step
		goto 38.7,70.2
		.from Beeble'phod##46018
		.get Phod's Head |q 27500/2
		.get Beeble's Head |q 27500/3
	step
		goto 43.4,57.3
		.talk Cassius the White##45669
		..turnin Four Heads are Better than None##27500
		..accept Up to the Citadel##27502
	step
		goto 38.9,64.0
		.talk SI:7 Squad Commander##46076
		..' Tell him you're ready
		.' Speak to the Squad commander |q 27502/1
	step
		'Follow the SI:7 Squad Commander and the SI:7 Agents up the path
		.' Escort the SI:7 |q 27502/2
		.' Click the Quest Complete box that pops up
		..turnin Up to the Citadel##27502
		..accept Just You and Mathias##27636
	step
		goto 36.4,66.0
		.talk Master Mathias Shaw##45796
		.|tip He is stealthed at the bottom of this tower
		..turnin Just You and Mathias##27636
		..accept Dark Assassins##27652
		..accept Bring the Hammer Down##27654
		..accept Help from the Earthcaller##27657
	step
		goto 37.5,88.7
		.talk Earthcaller Yevaa##46242
		..turnin Help from the Earthcaller##27657
		..accept Portal Overload##27659
		..accept Spirit of the Loch##27660
	step
		goto 37.6,88.7
		.talk Initiate Goldmine##46243
		..accept Unbinding##27662
	step
		goto 44.1,81.4
		.click the Air Portal Controller##9849 |tip It is high in the sky.
		.kill Debilitated Aetharon##46270 |q 27659/2
	step
		goto 38.0,80.2
		.click Earth Portal Controller##9849
		.|tip It is on the ground
		.kill Debilitated Apexar##46273 |q 27659/1
	step
		goto 33.2,62.4
		.click Water Portal Controller##9849
		.kill Debilitated Edemantus##46272 |q 27659/3
	step
		goto 27.6,63.9
		.talk Countess Verrall##46413
		..turnin Spirit of the Loch##27660
		..accept Fire the Cannon##27661
	step
		goto 35.2,67.4
		.from Corrupted Elementalist##46204+, Citadel Veteran##46205+, Twilight Vindicator##46203+
		.kill 10 Twilight Citadel cultists |q 27654/1
		.from Dark Assassin##46202+
		.get 5 Dark Assassin's Pendant |q 27652/1
		.from Enslaved Tempest##46328+, Enslaved Waterspout##46329+, Enslaved Inferno##46327+
		.' Free 10 Enslaved Elementals |q 27662/1
	step
		goto 40.8,79.0
		.kill Lord Cannon##46785 |q 27661/1
	step
		goto 37.6,88.7
		.talk Initiate Goldmine##46243
		..turnin Unbinding##27662
	step
		goto 37.5,88.7
		.talk Earthcaller Yevaa##46242
		..turnin Portal Overload##27659
	step
		goto 36.4,66.0
		.talk Master Mathias Shaw##45796
		..turnin Dark Assassins##27652
		..turnin Bring the Hammer Down##27654
		..accept Distract Them for Me##27688
		..accept The Elementium Axe##27695
	step
		goto 27.6,63.9
		.talk Countess Verrall##46413
		..turnin Fire the Cannon##27661
		..accept Water of Life##27719
	step
		goto 35.1,61.1
		.' Use your Water of Life next to the Corpse of Forgemaster Finlay |use Water of Life##62503 |tip He's chained to an anchor, drowned underwater.
		.' Extract Artifact Information |q 27719/1
		|modelnpc Corpse of Forgemaster Finlay##46819+
	step
		goto 36.4,66.0
		.talk Master Mathias Shaw##45796
		..turnin Water of Life##27719
	step
		goto 36.1,70.7
		.kill Master Klem##46342 |q 27688/2 |tip Mathias Shaw will come and kill him for you after you've fought him for a little bit.
	step
		goto 40.2,84.0
		.from Blindeye the Guardian##46399
		.get The Elementium Axe |q 27695/1
	step
		goto 42.3,83.5
		.kill Mia the Rose##46343 |q 27688/3 |tip She's in a small room at the top of this big building.  Mathias Shaw will come and kill her for you after you've fought her for a little bit.
	step
		goto 43.4,88.5
		.kill Dame Alys Finnsson##46341 |q 27688/1 |tip Mathias Shaw will come and kill her for you after you've fought her for a little bit.
	step
		goto 36.4,66.0
		.talk Master Mathias Shaw##45796
		..turnin Distract Them for Me##27688
		..turnin The Elementium Axe##27695
		..accept Dragon, Unchained##27700
	step
		goto 32.4,68.7
		.' Use The Elementium Axe |use The Elementium Axe##62248
		.' Free Lirastrasza |q 27700/1
		' |modelnpc 46456
	step
		goto 36.4,66.0
		.talk Master Mathias Shaw##45796
		..turnin Dragon, Unchained##27700
		..accept Coup de Grace##27702
	step
		goto 37.5,75.4
		.from Twilight Skyterror##46416+ |tip They are all over this area so you may need to search.
		.|tip They are laying on the ground with 1 health
		.' Deliver 5 Coup de Graces |q 27702/1
	step
		goto 36.4,66.0
		.talk Master Mathias Shaw##45796
		..turnin Coup de Grace##27702
		..accept Back to the Elementium Depths##27711
	step
		goto 37.5,88.7
		.talk Initiate Goldmine##46243
		..turnin Back to the Elementium Depths##27711
		..accept Mr. Goldmine's Wild Ride##27720
	step
		goto 37.5,88.7
		.talk Initiate Goldmine##46243
		..' Tell him you're ready for that wild ride
		.' Ride the Mine Cart to the End of the Line |q 27720/2
	step
		'Next to you:
		.talk Initiate Goldmine##46513
		..turnin Mr. Goldmine's Wild Ride##27720
		..accept A Little on the Side##27742
		..accept While We're Here##27743
	step
		goto 37.4,93.2
		.click Elementium Shard##10035+
		.get 6 Elementium Shard |n
		.click Twilight Rune of Earth##465
		..accept Rune Ruination##27744
	step
		goto 35.2,90.4
		.click Elementium Shard##10035+
		.get 6 Elementium Shard |n
		.click Twilight Rune of Water##465
		.' Destroy the Rune of Water |q 27744/2
	step
		goto 33.5,88.4
		.click Elementium Shard##10035+
		.get 6 Elementium Shard |n
		.click Twilight Rune of Air##465
		.' Destroy the Rune of Air |q 27744/3
	step
		goto 34.3,86.6
		.click Elementium Shard##10035+
		.get 6 Elementium Shard |n
		.click Twilight Rune of Fire##465
		.' Destroy the Rune of Fire |q 27744/4
	step
		goto 34.5,86.3
		.from Twilight Miner##46610+, Depths Overseer##46579+
		.kill 12 Elementium Depths cultists |q 27743/1
		.click Elementium Shard##10035+
		.get 6 Elementium Shard |q 27742/1
	step
		'Next to you:
		.talk Initiate Goldmine##46513
		..turnin A Little on the Side##27742
		..turnin While We're Here##27743
		..turnin Rune Ruination##27744
		..accept A Fiery Reunion##27745
	step
		goto 36.4,83.8
		.from Magmatooth##46611
		.get Fire Portal Controller |q 27745/2
	step
		goto 36.4,83.8
		.' Use your Fire Portal Controller |use Fire Portal Controller##62394
		.' Use the Fire Portal Controller at the Fire Portal |q 27745/1
	step
		goto 37.5,88.7
		.talk Initiate Goldmine##46243
		..turnin A Fiery Reunion##27745
		..accept Mathias Needs You##27782
	step
		goto 36.4,66.0
		.talk Master Mathias Shaw##45796
		..turnin Mathias Needs You##27782
		..accept The Hammer of Twilight##27784
	step
		goto 45.4,88.0
		.clicknpc The Hammer of Twilight##46717
		..turnin The Hammer of Twilight##27784
		..accept Skullcrusher the Mountain##27787
		.' Watch the cutscene
		.' Survive Skullcrusher's Backhand |q 27787/1
	step
		goto 45.4,87.9
		.kill Skullcrusher the Mountain##46732 |q 27787/2 |tip Follow the instructions that pop up on your screen.
	step
		goto 43.4,57.4
		.talk Kurdran Wildhammer##45668
		..turnin Skullcrusher the Mountain##27787
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- EVENTS
--------------------------------------------------------------------------------------------------------------------------------------
-- DARKMOON FAIRE --
ZygorGuidesViewer:RegisterInclude("A_Darkmoon_Faire_Dailies",[[
		author support@zygorguides.com
	step
		goto Darkmoon Island,54.3,53.1
		.talk Zina Sharpworth##55266
		.buy Sack o' Tokens##78909 |n
		.' Open your Sack o' Tokens in your bags |use Sack o' Tokens##78906
		.collect 20 Darkmoon Faire Game Tokens##71083
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		..accept It's Hammer Time##29463
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		.' Tell her:
		.' <Ready to whack!> |havebuff Interface\Icons\inv_hammer_32
	step
		.' Use the _Whack!_ on your bar and whack the Gnolls in the Barrels
		.' The Gnolls will pop up in the Barrels, but be careful not to hit the _Doll_ or you will get stunned.
		.' Whack 30 Gnolls |q 29463/1
	step
		goto Darkmoon Island,53.3,54.4
		.talk Mola##54601
		..turnin It's Hammer Time##29463
	step
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		..accept The Humanoid Cannonball##29436
		|next "quest"
	step
	label	"target"
		goto Darkmoon Island,57.1,89.6
		.talk Teleportologist Fozlebub##57850
		.' Tell him:
		.' <Teleport me to the cannon.> |goto 52.7,56.0,1 |noway |c
	step
	label	"quest"
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		.' Tell her:
		.' <Launch me!>
		'Wait for the Cannon to Launch you |havebuff Interface\Icons\Spell_Magic_FeatherFall
	step
		goto Darkmoon Island,56.4,93.3
		.' You will be launched throught the air.
		.' Use the ability on your action bar to drop dpwn into the target. You will gain more points for getting closer to the middle.
		.' Earn 5 Target Points |q 29436/1
		.' Click here to try again |confirm |next "target"
	step
		goto Darkmoon Island,57.1,89.6
		.talk Teleportologist Fozlebub##57850
		.' Tell him:
		.' <Teleport me to the cannon.> |goto 52.7,56.0,1 |noway |c
	step
		goto Darkmoon Island,52.5,56.2
		.talk Maxima Blastenheimer##15303
		..turnin The Humanoid Cannonball##29436
	step
		goto 49.3,60.8
		.talk Rinling##14841
		..accept He Shoots, He Scores!##29438
	step
		goto 49.3,60.8
		.talk Rinling##14841
		.' Tell him:
		.' <Let's shoot!> |havebuff Interface\Icons\INV_Weapon_Rifle_05
	step
		'Shoot at the 3 targets.
		.' When you see a green marker appear over a target, make sure that you are aimed at it and _shoot_ |tip To aim, simply move the camera to face your current target.
		.' Shoot 25 Targets |q 29438/1
	step
		goto 49.3,60.8
		.talk Rinling##14841
		..turnin He Shoots, He Scores!##29438
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		..accept Tonk Commander##29434
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		.' Tell him:
		.' <Ready to Play.> |invehicle |c
	step
		'Use your _Cannon_ ability to shoot _Tonk Targets_.
		.from Tonk Target##33081+
		.' Destroy 30 Tonk Targets |q 29434/1
	step
		goto Darkmoon Island,50.7,65.1
		.talk Finlay Coolshot##54605
		..turnin Tonk Commander##29434
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		..accept Target: Turtle##29455
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		.' Tell her:
		.' <Ready to play!> |havebuff Interface\Icons\INV_Jewelry_Ring_03
	step
		'Use your _Ring Toss_ ability to throw rings on the turtle.  |tip When aiming, move the marker over the middle of the turtle.
		.' Land 3 Rings on Dubenko |q 29455/1
		'|modelnpc Dubenko##54490
	step
		goto 51.6,77.8
		.talk Jessica Rogers##54485
		..turnin Target: Turtle##29455
]])

ZygorGuidesViewer:RegisterInclude("A_Darkmoon_Faire_Quests",[[
	step
		goto Stormwind City 49.6,74.9
		.talk Stanly McCormick##30730
		.buy 5 Light Parchment##39354
		|only if skill("Inscription")>74
	step
		goto Elwynn Forest,43.8,65.8
		.talk Innkeeper Farley##295
		.buy 5 Moonberry Juice##1645 |q 29506
		|only if skill("Alchemy")>74
	step
		goto Elwynn Forest 42.0,67.0
		.talk Tharynn Bouden##66
		.buy 1 Coarse Thread##2320
		.buy 1 Blue Dye##6260
		.buy 1 Red Dye##2604
		|only if skill("Tailoring")>74
	step
		goto Elwynn Forest 42.0,67.0
		.talk Tharynn Bouden##66
		.buy 5 Coarse Thread##2320
		.buy 5 Blue Dye##6260
		.buy 10 Shiny Bauble##6529
		|only if skill("Leatherworking")>74
	step
		goto Elwynn Forest 42.0,67.0
		.talk Tharynn Bouden##66
		.buy 5 Simple Flour##30817 |q 29509
		|only if skill("Cooking")>74
	step
		goto Darkmoon Island 55.4,54.8
		.talk Selina Dourman##10445
		..accept Banners, Banners Everywhere!##29520
		|only if skill("Tailoring")>74
	step
		goto Darkmoon Island,51.9,60.9
		.talk Professor Thaddeus Paleo##14847
		..accept Fun for the Little Ones##29507
		|only if skill("Archaeology")>74
	step
		goto Darkmoon Island,49.3,60.7
		.talk Rinling##14841
		..accept Rearm, Reuse, Recycle##29518
		|only if skill("Mining")>74
	step
		goto Darkmoon Island,49.3,60.8
		.talk Rinling##14841
		..accept Talkin' Tonks##29511
		|only if skill("Engineering")>74
	step
		goto 49.3,60.9
		.talk Rinling##14841
		..accept Eyes on the Prizes##29517
		|only if skill("Leatherworking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..accept Putting the Crunch in the Frog##29509
		|only if skill("Cooking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..accept Spoilin' for Salty Sea Dogs##29513
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island 53.2,75.8
		.talk Sayge##14822
		..accept Writing the Future##29515
		|only if skill("Inscription")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Putting the Carnies Back Together Again##29512
		|only if skill("First Aid")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Tan My Hide##29519
		|only if skill("Skinning")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..accept Herbs for Healing##29514
		|only if skill("Herbalism")>74
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		..accept A Fizzy Fusion##29506
		|only if skill("Alchemy")>74
	step
		goto 55.0,70.8
		.talk Chronos##14833
		..accept Keeping the Faire Sparkling##29516
		|only if skill("Jewelcrafting")>74
	step
		goto Darkmoon Island,53.2,75.8
		.talk Sayge##14822
		..accept Putting Trash to Good Use##29510
		|only if skill("Enchanting")>74
	step
		goto Darkmoon Island,51.1,82.0
		.talk Yebb Neblegear##14829
		..accept Baby Needs Two Pair of Shoes##29508
		|only if skill("Blacksmithing")>74
	step
		goto Darkmoon Island,51.7,91.6
		.' Equip your Fishing Pole |equipped Fishing Pole##6256 |use Fishing Pole##6256 |q 29513
		.' Use your Fishing ability to catch _Sea Herrings_ |cast Fishing##7620
		.' Catch 5 Great Sea Herring |q 29513/1
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island,47.9,74.5
		.' Use your Darkmoon Bandage on Injured Carnies |use Darkmoon Bandage##71978
		.' Heal 4 Injured Carnies |q 29512/1
		'|modelnpc 54518
		|only if skill("First Aid")>74
	step
		'All around the Island
		.click Discarded Weapon##10777+
		.collect 6 Discarded Weapon##72018 |n
		.' Disenchant the Discarded Weapons |use Discarded Weapon##72018
		.' Collect 6 Soothsayer's Dust |q 29510/1
		|only if skill("Enchanting")>74
	step
		'All around the Island
		.click Tonk Scrap##6314
		.' Collect 6 pieces of Tonk Scrap |q 29518/1
		|only if skill("Mining")>74
		'|model 7975
	step
		'All around the Island
		.click Bits of Glass##238
		.collect 5 Bits of Glass##72052 |n
		.' Click the Bits of Glass in your bags |use Bit of Glass##72052
		.' Make 5 Sparkling Gemstones |q 29516/1
		|only if skill("Jewelcrafting")>74
	step
		.' All around the Island
		.' Use your Battered Wrench to repair Damaged Tonk's |use Battered Wrench##72110
		.' Repair 5 Damaged Tonk's |q 29511/1
		'|modelnpc 54504
		|only if skill("Engineering")>74
	step
		.' All around the Island
		.click Darkblossom##209284
		.' Gather 6 Darkblossom |q 29514/1
		|only if skill("Herbalism")>74
	step
		.' All around the Island
		.click Staked Skins##10750
		.' Scrape 4 Staked Skins |q 29519/1
		|only if skill("Skinning")>74
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		.buy 5 Fizzy Faire Drink##19299 |q 29506
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island,50.7,90.8
		.click Portal to Elwynn Forest##04396
		.' Teleport to Elwynn Forest |goto Elwynn Forest |noway |c
		|only if skill("Archaeology")>74
	step
		'Open your world map, find dig sites in Kalimdor and go to them |tip They look like small shovel icons on your world map that spawn in random places.  Once you get to the zone where the dig site is located, you will see the dig site on your map as a red highlighted area.
		.' You can find _Fossil Fragments_ in these locations:
		.' Desolace
		.' Dustwallow Marsh
		.' Stonetalon Mountains
		.' Southern Barrens
		.' Tanaris
		.' Un'Goro Crater
		.' Use your Survey ability inside the dig site area and follow the Telesope until you find a fragment |cast Survey##80451
		.earn 15 Fossil Fragments##393 |q 29507
		|only if skill("Archaeology")>74
	step
		 goto Elwynn Forest,41.8,69.6
		.click Portal to Darkmoon Island
		.' Telport to Darkmoon Island |goto Darkmoon Island |noway |c
		|only if skill("Archaeology")>74
	step
		goto Darkmoon Island,56.0,52.9 |n
		.' Follow the Path to the Darkmoon Faire |goto Darkmoon Island,56.0,52.9,1 |noway |c
		|only skill("Archaeology")>74
	step
		goto Darkmoon Island,50.4,69.5
		.' Use the Cocktail Shaker in your bags to make Moonberry Fizz |use Cocktail Shaker##72043
		.' Create 5 Sevings of Moonberry Fizz |q 29506/1
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island 50.0,66.2
		.' Use the Darkmoon Banner Kit in your bags to plant a banner here. |use Darkmoon Banner Kit##72048
		.' Plant a Darkmoon Banner |q 29520/1
		|only if skill("Tailoring")>74
	step
		goto Darkmoon Island,52.7,68.1
		.' Click the Plump Frogs in your bags |use Plump Frogs##72056
		.collect 5 Breaded Frog##72057 |n
		.' Throw the Breaded Frogs in the cauldron |use Breaded Frog##72057
		.' Fry 5 Crunchy Frogs |q 29509/1
		|only if skill("Cooking")>74
	step
		goto 55.3,71.7
		.' Use the Iron Stock in your bags to make Horseshoes |use Iron Stock##71964
		.collect 4 Horseshoes##71967 |q 29508
		|only if skill("Blacksmithing")>74
	step
		.' Use the Bundle of Exotic Herbs in your bags to create Prophetic Ink |use Bundle of Exotic Herbs##71971
		.collect Prophetic Ink##71972 |n
		.' Use Prophetic Ink to create Fortunes |use Prophetic Ink##71972 |tip Each one requires 1 Light Parchment to create.
		.get 5 Fortune##71974+ |q 29515/1
		|only if skill("Inscription")>74
	step
		'Use the _Darkmoon Craftsman's Kit_ in your bags to create Darkmoon Prizes |use Darkmoon Craftsman's Kit##71977
		.collect 5 Darkmoon Prize##71976 |q 29517/1
		|only if skill("Leatherworking")>74
	step
		goto Darkmoon Island,51.9,60.9
		.talk Professor Thaddeus Paleo##14847
		..turnin Fun for the Little Ones##29507
		|only if skill("Archaeology")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..turnin Putting the Crunch in the Frog##29509
		|only if skill("Cooking")>74
	step
		goto Darkmoon Island,52.9,68.0
		.talk Stamp Thunderhorn##14845
		..turnin Spoilin' for Salty Sea Dogs##29513
		|only if skill("Fishing")>74
	step
		goto Darkmoon Island 53.2,75.8
		.talk Sayge##14822
		..turnin Writing the Future##29515
		|only if skill("Inscription")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Putting the Carnies Back Together Again##29512
		|only if skill("First Aid")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Tan My Hide##29519
		|only if skill("Skinning")>74
	step
		goto 55.0,70.8
		.talk Chronos##14833
		..turnin Keeping the Faire Sparkling##29516
		|only if skill("Jewelcrafting")>74
	step
		goto 49.3,60.9
		.talk Rinling##14841
		..turnin Eyes on the Prizes##29517
		|only if skill("Leatherworking")>74
	step
		goto Darkmoon Island,49.3,60.8
		.talk Rinling##14841
		..turnin Talkin' Tonks##29511
		|only if skill("Engineering")>74
	step
		goto Darkmoon Island,55.0,70.8
		.talk Chronos##14833
		..turnin Herbs for Healing##29514
		|only if skill("Herbalism")>74
	step
		goto 50.5,69.6
		.talk Sylannia##14844
		..turnin A Fizzy Fusion##29506
		|only if skill("Alchemy")>74
	step
		goto Darkmoon Island,49.3,60.7
		.talk Rinling##14841
		..turnin Rearm, Reuse, Recycle##29518
		|only if skill("Mining")>74
	step
		goto Darkmoon Island,53.2,75.8
		.talk Sayge##14822
		..turnin Putting Trash to Good Use##29510
		|only if skill("Enchanting")>74
	step
		goto Darkmoon Island,51.3,81.8
		.' Use the Horshoes in your bag on Baby|use Horseshoe##71967
		.' Put New Horshoes On Baby |q 29508/1
		|only if skill("Blacksmithing")>74
		'|modelnpc 54510
	step
		goto Darkmoon Island,51.1,82.0
		.talk Yebb Neblegear##14829
		..turnin Baby Needs Two Pair of Shoes##29508
		|only if skill("Blacksmithing")>74
	step
		goto Darkmoon Island,47.9,67.1
		.talk Kerri Hicks##14832
		..accept Test Your Strength##29433
	step
		goto Darkmoon Island,55.6,55.0
		.talk Selina Dourman##10445
		.' Tell her:
		.' <Darkmoon Adventurer's Guide?>
		.collect Darkmoon Adventurer's Guide##71634 |q 29433
	step
		'These next 3 items have to be _obtained from Battlegrounds_
		.' When you kill an opponent, _loot_ their body for a chance to get _each item_.
		.collect Adventurer's Journal##71953 |n
		.accept The Captured Journal##29458 |use Adventurer's Journal##71953
		.collect Banner of the Fallen##71951 |n
		.accept A Captured Banner##29456 |use Banner of the Fallen##71951
		.collect Captured Insignia##71952 |n
		.accept The Enemy's Insignia##29457 |use Captured Insignia##71952
	step
		'These next 5 items have to be _obtained from Dungeons_ listed below
		.collect Mysterious Grimoire##71637 |n |tip You can get this in Heroic Scholomance from Darkmaster Gandling
		..accept An Inriguing Grimoire##29445 |use Mysterious Grimoire##71637
		.collect Monstrous Egg##71636 |n |tip You can get this in Stormstout Brewery from Hoptallus
		..accept An Exotic Egg##29444 |use Monstrous Egg##71636
		.collect A Treatise on Strategy##7175 |n |tip You can get this in Stormstout Brewery from Hoptallus
		..accept The Master Strategist##29451 |use A Treatise on Strategy##7175
		.collect Ornate Weapon##71638 |n |tip You can get this in Heroic Scarlet Monastery from Brother Korloff
		..accept A Wondrous Weapon##29446 |use Ornate Weapon##71638
		.collect Imbued Crystal##71635 |n |tip You can get this in Heroic Scarlet Monastery from High Inquisitor Whitemane
		..accept A Curious Crystal##29443 |use Imbued Crystal##71635
	step
		'The next item can only be obtained from any 10 man Cataclysm Raid Boss
		.collect Soothsayer's Runes##71716 |n
		..accept Tools of Divination##29464 |use Soothsayer's Runes##71716
	step
		.' Kill any Creature Player or NPC that gives _experience or honor_ to gain Grisly Trophies |tip You need to leave Darkmoon Island to find anything to kill.
		.' Collect 250 Grisly Trophy's |q 29433/1
	step
		goto Darkmoon Island,47.9,67.1
		.talk Kerri Hicks##14832
		..turnin Test Your Strength##29433
	step
		goto Darkmoon Island,51.9,60.9
		.talk Professor Thaddeus Paleo##14847
		..turnin The Captured Journal##29458
		..turnin A Captured Banner##29456
		..turnin The Enemy's Insignia##29457
		..turnin The Master Strategist##29451
		..turnin A Wondrous Weapon##29446
		..turnin A Curious Crystal##29443
		..turnin Tools of Divination##29464
	step
		goto Darkmoon Island 51.0,81.2
		.talk Yebb Neblegear##14829
		..turnin An Exotic Egg##29444
	step
		goto Darkmoon Island 53.6,76.0
		.talk Sayge##14822
		..turnin An Intriguing Grimoire##29445
]])

ZygorGuidesViewer:RegisterInclude("A_Darkmoon_Faire_Achievements",[[
	step
	label	"main"
		'To earn Achievements for the Darkmoon Faire, you will need to complete Dailies, Quests and other tasks.
		.' Click here to do the Dailies Achievements |confirm always |next "dailies"
		.' or
		.' Click here to do the Profession Quests Achievements |confirm always |next "professions"
		.' or
		.' Click here for the Non-Questing Achievements |confirm always |next "no_quest"
	step
	label	"dailies"
		'You have earned the Achievement Bullseye! |achieve 6021 |only if achieved(6021)
		.' You still need to earn the Achievement Bullseye! |achieve 6021 |only if not achieved(6021)
		.' You have earned the Achievement Quick Shot! |achieve 6022 |only if achieved(6022)
		.' You still need to earn the Achievement Quick Shot! |achieve 6022 |only if not achieved(6022)
		.' You have earned the Achievement Step Right Up! |achieve 6020 |only if achieved(6020)
		.' You still need to earn the Achievement Step Right Up! |achieve 6020 |only if not achieved(6020)
		|confirm always
	step
		#include "A_Darkmoon_Faire_Dailies"
		|next "main"
	step
	label	"professions"
		'You have earned the Achievement Faire Favors |achieve 6032 |only if achieved(6032)
		.' You still need to earn the Achievement Faire Favors |achieve 6032 |only if not achieved(6032)
		.' You have earned the Achievement Darkmoon Dungeoneer |achieve 6027 |only if achieved(6027)
		.' You still need to earn the Achievement Darkmoon Dungeoneer |achieve 6027 |only if not achieved(6027)
		.' You have earned the Achievement Darkmoon Defender |achieve 6028 |only if achieved(6028)
		.' You still need to earn the Achievement Darkmoon Defender |achieve 6028 |only if not achieved(6028)
		.' You have earned the Achievement Darkmoon Despoiler |achieve 6029 |only if achieved(6029)
		.' You still need to earn the Achievement Darkmoon Despoiler |achieve 6029 |only if not achieved(6029) |tip
		|confirm always
	step
		#include "A_Darkmoon_Faire_Quests"
	step
		goto Darkmoon Island,55.6,55.0
		.talk Selina Dourman##10445
		.' Tell her:
		.' <Darkmoon Adventurer's Guide?>
		.collect Darkmoon Adventurer's Guide##71634 |q 29433
	step
		'These next 3 items have to be _obtained from Battlegrounds_
		.' When you kill an opponent, _loot_ their body for a chance to get _each item_.
		.collect Adventurer's Journal##71953 |n
		.accept The Captured Journal##29458 |use Adventurer's Journal##71953
		.collect Banner of the Fallen##71951 |n
		.accept A Captured Banner##29456 |use Banner of the Fallen##71951
		.collect Captured Insignia##71952 |n
		.accept The Enemy's Insignia##29457 |use Captured Insignia##71952
	step
		'These next 5 items have to be _obtained from Dungeons_ listed below
		.collect Mysterious Grimoire##71637 |n |tip You can get this in Heroic Scholomance from Darkmaster Gandling
		..accept An Inriguing Grimoire##29445 |use Mysterious Grimoire##71637
		.collect Monstrous Egg##71636 |n |tip You can get this in Stormstout Brewery from Hoptallus
		..accept An Exotic Egg##29444 |use Monstrous Egg##71636
		.collect A Treatise on Strategy##7175 |n |tip You can get this in Stormstout Brewery from Hoptallus
		..accept The Master Strategist##29451 |use A Treatise on Strategy##7175
		.collect Ornate Weapon##71638 |n |tip You can get this in Heroic Scarlet Monastery from Brother Korloff
		..accept A Wondrous Weapon##29446 |use Ornate Weapon##71638
		.collect Imbued Crystal##71635 |n |tip You can get this in Heroic Scarlet Monastery from High Inquisitor Whitemane
		..accept A Curious Crystal##29443 |use Imbued Crystal##71635
	step
		'The next item can only be obtained from any 10 man Cataclysm Raid Boss
		.collect Soothsayer's Runes##71716 |n
		..accept Tools of Divination##29464 |use Soothsayer's Runes##71716
	step
		.' Kill any Creature Player or NPC that gives _experience or honor_ to gain Grisly Trophies |tip You need to leave Darkmoon Island to find anything to kill.
		.' Collect 250 Grisly Trophy's |q 29433/1
	step
		goto Darkmoon Island,47.9,67.1
		.talk Kerri Hicks##14832
		..turnin Test Your Strength##29433
	step
		goto Darkmoon Island,51.9,60.9
		.talk Professor Thaddeus Paleo##14847
		..turnin The Captured Journal##29458
		..turnin A Captured Banner##29456
		..turnin The Enemy's Insignia##29457
		..turnin The Master Strategist##29451
		..turnin A Wondrous Weapon##29446
		..turnin A Curious Crystal##29443
		..turnin Tools of Divination##29464
	step
		goto Darkmoon Island 51.0,81.2
		.talk Yebb Neblegear##14829
		..turnin An Exotic Egg##29444
	step
		goto Darkmoon Island 53.6,76.0
		.talk Sayge##14822
		..turnin An Intriguing Grimoire##29445
		|next "main"
	step
	label	"no_quest"
		'You have earned the Achievement Darkmoon Duelist! |achieve 6023 |only if achieved(6023)
		.' You still need to earn the Achievement Darkmoon Duelist! |achieve 6023 |only if not achieved(6023)
		'You have earned the Achievement Fairegoer's Feast! |achieve 6026 |only if achieved(6026)
		.' You still need to earn the Achievement Fairegoer's Feast! |achieve 6026 |only if not achieved(6026)
		'You have earned the Achievement Taking the Show on the Road! |achieve 6030 |only if achieved(6030)
		.' You still need to earn the Taking the Show on the Road! |achieve 6030 |only if not achieved(6030)
		'You have earned the Achievement I Was Promised a Pony! |achieve 6025 |only if achieved(6025)
		.' You still need to earn the I Was Promised a Pony! |achieve 6025 |only if not achieved(6025) |tip
		|confirm always
	step
		goto Darkmoon Island,50.5,69.5
		.talk Sylannia##14844
		.buy Cheap Beer##19222 |n
		.' Drink Cheap Beer |achieve 6026/12 |use Cheap Beer##19222
		.buy Darkmoon Special Reserve##19221 |n
		.' Drink Darkmoon Special Reserve |achieve 6026/13 |use Special Reserve##19221
		.buy Fizzy Faire Drink##19299 |n
		.' Drink Fizzy Faire Drink |achieve 6026/14 |use Fizzy Faire Drink##19299
		.buy Bottled Winterspring Water##19300 |n
		.' Drink Bottled Winterspring Water |achieve 6026/11 |use Bottled Winterspring Water##19300
		.buy Iced Berry Slush##33234 |n
		.' Drink Iced Berry Slush |achieve 6026/17 |use Iced Berry Slush##33234
		.buy Fizzy Faire Drink "Classic"##33236 |n
		.' Drink Fizzy Faire Drink "Classic" |achieve 6026/15 |use Fizzy Faire Drink "Classic"##33236
		.buy Fresh-Squeezed Limeade##44941 |n
		.' Drink Fresh-Squeezed Limeade |achieve 6026/16 |use Fresh-Squeezed Limeade##44941
		.buy Sasparilla Sinker##74822 |n
		.' Drink Sasparilla Sinker |achieve 6026/18 |use Sasparilla Sinker##74822
	step
		goto Darkmoon Island,52.8,68.0
		.talk Stamp Thunderhorn##14845
		.buy Darkmoon Dog##19223 |n
		.' Eat Darkmoon Dog |achieve 6026/3 |use Darkmoon Dog##19223
		.buy Spiced Beef Jerky##19304 |n
		.' Eat Spiced Beef Jerky |achieve 6026/10 |use Spiced Beef Jerky##19304
		.buy Pickled Kodo Foot##19305 |n
		.' Eat Pickled Kodo Foot |achieve 6026/7 |use Pickled Kodo Foot##19305
		.buy Red Hot Wings##19224 |n
		.' Eat Red Hot Wings |achieve 6026/8 |use Red Hot Wings##19224
		.buy Crunchy Frog##19306 |n
		.' Eat Crunchy Frog |achieve 6026/2 |use Crunchy Frog##19306
		.buy Deep Fried Candybar##19225 |n
		.' Eat Deep Fried Candybar |achieve 6026/4 |use Deep Fried Candybar##19225
		.buy Funnel Cake##33246 |n
		.' Eat Funnel Cake |achieve 6026/6 |use Funnel Cake##33246
		.buy Forest Strider Drumstick##33254 |n
		.' Eat Forest Strider Drumstick |achieve 6026/5 |use Forest Strider Drumstick##33254
		.buy Corn-Breaded Sausage##44940 |n
		.' Eat Corn-Breaded Sausage |achieve 6026/1 |use Corn-Breaded Sausage##44940
		.buy Salty Sea Dog##73260 |n
		.' Eat Salty Sea Dog |achieve 6026/9 |use Salty Sea Dog##73260
		.' Earn the Achievement Fairegoer's Feast |achieve 6026
	step
		goto Darkmoon Island,56.8,81.4
		.clicknpc Darkmoon Pony##55715
		.' Earn the Achievement I Was Promised a Pony |achieve 6025
	step
		goto Darkmoon Island,48.4,71.9
		.talk Boomie Sparks##55278
		.buy 6 Darkmoon Firework##74142
	step
		 goto Darkmoon Island,50.7,90.8
		.click Portal to Elwynn Forest##04396
		.' Teleport to Elwynn Forest |goto Elwynn Forest |noway |c
	step
		'Go to Stormwind |goto Stormwind City |c
		'|goto Stormwind City 55,55
		.' Use your Darkmoon Firework |achieve 6030/6 |use Darkmoon Firework##74142
	step
		'Goto Ironforge |goto Ironforge 56,47 |c
		.' Use your Darkmoon Firework |achieve 6030/4 |use Darkmoon Firework##74142
	step
		'Goto Darnassus |goto Darnassus 46,44 |c
		.' Use your Darkmoon Firework |achieve 6030/2 |use Darkmoon Firework##74142
	step
		'Goto The Exodar |goto The Exodar 53,38 |c
		.' Use your Darkmoon Firework |achieve 6030/3 |use Darkmoon Firework##74142
	step
		goto Shattrath City 62,42
		.' Use your Darkmoon Firework |achieve 6030/5 |use Darkmoon Firework##74142
	step
		'Goto Dalaran |goto Dalaran 71,45 |c
		.' Use your Darkmoon Firework |achieve 6030/1 |use Darkmoon Firework##74142
	step
		goto Darkmoon Island,46.8,78.8
		.' Click Darkmoon Deathmatch Gate and enter the Deathmatch Arena
		.' Once inside, you will need to fight anyone inside, if you win, you will earn an achievement.
		.' Earn the Achievement Darkmoon Duelist! |achieve 6023
		.' Deafeat 12 combatants in the Deathmatch Arena
		.' Earn the Achievement Darkmoon Dominator |achieve 6024
		|next "main"
]])

-- HALLOWS END --
ZygorGuidesViewer:RegisterInclude("Hallows_End_Quests_Alliance",[[
	step
		goto Stormwind City,61.7,74.2
		.talk Human Commoner##18927
		..accept Costumed Orphan Matron##11356
		..accept A Season for Celebration##29074
	step
		goto Elwynn Forest,32.0,50.4
		.talk Jesper##15310
		..accept Hallow's End Treats for Jesper!##8311
	step
		goto Elwynn Forest,32.0,50.5
		.talk Celestine of the Harvest##51665
		..turnin A Season for Celebration##29074
	step
		goto 32.4,50.9
		.talk Gretchen Fenlow##51934
		..accept A Friend in Need##29430
	step
		goto Elwynn Forest,42.6,64.4
		.talk Costumed Orphan Matron##24519
		..turnin Costumed Orphan Matron##11356
		..accept Fire Brigade Practice##11360
	step
		goto 42.5,64.5
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 11360
	step
		goto 42.6,60.2
		.' Use your Water Bucket on the burning scarecrows |use Water Bucket##32971
		.' Fight 5 Fires |q 11360/1
		.' Collect more Water Buckets from the Water Barrel at [42.7,62.0]
	step
		goto 42.6,64.4
		.talk Costumed Orphan Matron##24519
		..' You will only be able to accept 1 of the 2 daily quests
		..turnin Fire Brigade Practice##11360
	step
		goto 42.4,65.9
		.' Click the Large Jack-o'-Lantern |tip It's a burning pumpkin laying in the road.
		..accept Smash the Pumpkin##12133
	step
		goto 42.6,64.4
		.talk Costumed Orphan Matron##24519
		..' You will only be able to turn in 1 of the 2 daily quests
		..turnin Smash the Pumpkin##12133
		..accept Stop the Fires!##11131 |or
		..accept "Let the Fires Come!"##12135|or
	step
		goto 42.5,64.5
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 11131
	step
		goto 42.4,65.6
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 11131/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [42.5,64.5]
	step
		goto 42.5,64.5
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 12135
	step
		goto 42.4,65.6
		.' Wait until the fires appear on the buildings in Goldshire
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 12135/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [42.5,64.5]
	step
		goto 42.6,64.4
		.talk Costumed Orphan Matron##24519
		..' You will only be able to turn in 1 of the 2 daily quests
		..turnin Stop the Fires!##11131 |or
		..turnin "Let the Fires Come!"##12135 |or
	step
		goto Stormwind City 60.4,75.3
		.talk Innkeeper Allison##6740
		..accept Flexing for Nougat##8356
	step
		goto 60.4,75.3
		.' While targeting Innkeeper Allison:
		.' Flex for Innkeeper Allison |script DoEmote("FLEX") |q 8356/1
	step
		goto 60.4,75.3
		.talk Innkeeper Allison##6740
		..turnin Flexing for Nougat##8356
	step
		goto Stormwind City,60.1,75.1
		.talk Anson Hastings##53949
		..turnin A Friend in Need##29430
		..accept Missing Heirlooms##29392
	step
		goto Ironforge,18.1,51.5
		.talk Innkeeper Firebrew##5111
		..accept Chicken Clucking for a Mint##8353
	step
		goto 18.1,51.5
		.' While targeting Innkeeper Firebrew:
		.' Cluck like a Chicken for Innkeeper Firebrew |script DoEmote("CHICKEN") |q 8353/1
	step
		goto 18.1,51.5
		.talk Innkeeper Firebrew##5111
		..turnin Chicken Clucking for a Mint##8353
	step
		goto 36.4,3.6
		.talk Talvash del Kissel##6826
		..accept Incoming Gumdrop##8355
	step
		goto 36.4,3.6
		.' While targeting Talvash del Kissel:
		.' Make Train sounds for Talvash del Kissel |script DoEmote("TRAIN") |q 8355/1
	step
		goto 36.4,3.6
		.talk Talvash del Kissel##6826
		..turnin Incoming Gumdrop##8355
	step
		goto Stormwind City 24.0,44.8
		.' Search the courier's cabin. |q 29392/1
	step
		goto Stormwind City 24.0,44.8
		.talk Hired Courier##53950
		..turnin Missing Heirlooms##29392
		..accept Fencing the Goods##29398
	step
		goto 61.2,70.8
		.'Track the thief's trail. |q 29398/1
	step
		goto 61.2,70.8
		.talk Auctioneer Fitch##8719
		.' Ask if anyone suspicious tried to list a crate of goods recently
		..turnin Fencing the Goods##29398
		..accept Shopping Around##29399
	step
		goto 64.2,46.3
		.' Investigate the Shady Lady. |q 29399/1 |tip There will be a bit of dialog before completing the objective.
	step
		goto 64.2,46.3
		.talk Hudson Barnes##54021
		..turnin Shopping Around##29399 |tip You will have to wait until he finishes talking and the white question mark turns yellow to turn this in.
		..accept Taking Precautions##29402
	step
		goto Stormwind City 62.9,75.0
		.talk Keldric Boucher##1257
		.buy 5 Crystal Vial##3371 |q 29402/2
	step
		goto 55.2,14.5
		.click Blood Nettle##10249
		..get 5 Blood Nettle |q 29402/3
	step
		goto Stormwind City 52.8,74.2
		.talk Jessara Cordell##1318
		.' If she doesn't have any for sale, you will have to use the _Auction House_ or disenchant low level gear.
		.buy 2 Crystal Vial##10940 |q 29402/1
	step
		goto 64.2,46.3
		.talk Hudson Barnes##54021
		..turnin Taking Precautions##29402
		..accept The Collector's Agent##29403
	step
		'Enter the Cathedral of Light |goto Stormwind City,52.7,50.5,0.5 |c
	step
		'Go down into the Cathedral of Light catacombs |goto 51.3,44.2 |c
	step
		goto 55.3,43.5
		.from Unleashed Void##54114+
		.' Meeting Disrupted |q 29403/1
	step
		goto 55.3,43.5
		.click Stolen Crate##335
		..turnin The Collector's Agent##29403
		..accept What Now?##29411
	step
		goto Stormwind City,60.1,75.1
		.talk Anson Hastings##53949
		..turnin What Now?##29411
	step
		goto 60.1,75.1
		.click Anson's Crate##335
		..accept The Creepy Crate##29413 |instant
	step
		goto Darnassus,62.5,32.8
		.talk Innkeeper Saelienne##6735
		..accept Dancing for Marzipan##8357
	step
		goto 62.5,32.8
		.' While targeting Innkeeper Saelienne:
		.' Dance for Innkeeper Saelienne |script DoEmote("DANCE") |q 8357/1
	step
		goto 62.5,32.8
		.talk Innkeeper Saelienne##6735
		..turnin Dancing for Marzipan##8357
	step
		goto Elwynn Forest,32.0,50.4
		.talk Jesper##15310
		..turnin Hallow's End Treats for Jesper!##8311
]])

ZygorGuidesViewer:RegisterInclude("Hallows_End_Dailies_Alliance",[[
	step
		goto Elwynn Forest,32.0,50.5
		.talk Celestine of the Harvest##51665
		..accept A Time to Gain##29075
	step
		goto Elwynn Forest,32.7,49.5
		.' Click the Bonfire
		.' Use the Bonfire |q 29075/1
	step
		goto Elwynn Forest,32.0,50.5
		.talk Celestine of the Harvest##51665
		..turnin A Time to Gain##29075
	step
		goto 32.1,50.6
		.talk Keira##52064
		..accept A Time to Lose##29371
	step
		goto 32.4,50.9
		.talk Gretchen Fenlow##51934
		..accept Stink Bombs Away!##29054
		..accept Clean Up in Stormwind##29144
	step
		goto Stormwind City,71.6,87.4
		.' Use Arcane Cleanser on Stink Bombs |tip They look like orange mists all around Stormwind. |use Arcane Cleanser##69191
		.' Remove 10 Stink Bombs |q 29144/1
		.' You can find more at [63.2,72.0]
		.' You can find more at [73.0,59.0]
		.' You can find more at [79.1,40.1]
		.' You can find more at [65.0,38.5]
		.' You can find more at [54.6,54.2]
		.' You can find more at [49.5,83.0]
	step
		goto Elwynn Forest,32.4,50.9
		.talk Gretchen Fenlow##51934
		..turnin Clean Up in Stormwind##29144
	step
		goto 32.2,50.8
		.talk Gertrude Fenlow##52548
		.' Tell her you are ready to fly |invehicle |c
	step
		.' Use the _Toss Stink Bomb_ ability on your action bar all around _Undercity_
		.' Drop 25 Stink Bombs |q 29054/1
		.' Click the _Return Home_ button on your action bar |outvehicle
	step
		goto Elwynn Forest,32.3,50.9
		.talk Gretchen Fenlow##51934
		..turnin Stink Bombs Away!##29054
	step
		goto Elwynn Forest,42.6,64.4
		.talk Costumed Orphan Matron##24519
		..' You will only be able to accept 1 of the 2 daily quests
		..accept Stop the Fires!##11131 |or
		..accept "Let the Fires Come!"##12135 |or
	step
		goto 42.5,64.5
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 11131
	step
		goto 42.4,65.6
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 11131/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [42.5,64.5]
	step
		goto 42.5,64.5
		.' Click the Water Barrel |tip It looks like a huge bucket of water.
		.collect Water Bucket##32971 |q 12135
	step
		goto 42.4,65.6
		.' Wait until the fires appear on the buildings in Goldshire
		.' Use your Water Bucket on the fires all around this area |use Water Bucket##32971
		.' Put Out the Fires |q 12135/1 |tip You will need a group of people to complete this quest.  It is best to do this quest at peak hours.
		.' Collect more Water Buckets from the Water Barrel at [42.5,64.5]
	step
		goto 42.4,65.9
		.' Click the Large Jack-o'-Lantern |tip It's a burning pumpkin laying in the road.
		..accept Smash the Pumpkin##12133
	step
		goto 42.6,64.4
		.talk Costumed Orphan Matron##24519
		..' You will only be able to turnin 1 of the 2 daily quests
		..turnin Stop the Fires!##11131
		..turnin "Let the Fires Come!"##12135
		..turnin Smash the Pumpkin##12133
	step
		goto Undercity,68.2,15.6
		.' Use the Dousing Agent in your Bags on the Burning Wickerman |use Dousing Agent##68648
		.' Douse the Horde's Wickerman |q 29371/1
		.' Note that you will be flagged for _PvP Combat_ while attempting to do this step.
	step
		goto Elwynn Forest,32.1,50.6
		.talk Keira##52064
		..turnin A Time to Lose##29371
]])

ZygorGuidesViewer:RegisterInclude("Hallows_End_Achievements_Alliance",[[
// Eastern Kingdoms
	step
		goto Stormwind City,60.5,75.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stormwind, The Trade District |achieve 966/19
	step
		goto Elwynn Forest,43.7,65.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Elwynn Forest, Goldshire |achieve 966/10
	step
		goto Redridge Mountains,26.5,41.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Redridge Mountains, Lakeshire |achieve 966/17
	step
		goto Searing Gorge 39.5,66.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Searing Gorge, Iron Summit |achieve 966/18
	step
		goto Loch Modan,35.5,48.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Loch Modan, Thelsamar |achieve 966/15
	step
		goto Loch Modan 83.0,63.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Loch Modan, Farstrider Lodge |achieve 966/14
	step
		goto Ironforge,18.3,51.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Ironforge, The Commons |achieve 966/13
	step
		goto Dun Morogh,54.5,50.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dun Morogh, Kharanos |achieve 966/7
	step
		goto Wetlands,10.8,61.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Wetlands, Menethil Harbor |achieve 966/23
	step
		goto Wetlands 26.1,26.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Wetlands, Swiftgear Station |achieve 966/24
	step
		goto Wetlands 58.2,39.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Wetlands, Greenwarden's Grove |achieve 966/26
	step
		goto Arathi Highlands 39.8,48.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Arathi Highlands, Refuge Pointe |achieve 966/1
	step
		goto The Hinterlands,14.2,44.6
		.' Go upstairs in the inn
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hinterlands, Aerie Peak |achieve 966/11
	step
		goto The Hinterlands 66.2,44.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hinterlands, Stormfeather Outpost |achieve 966/12
	step
		goto Eastern Plaguelands,75.6,52.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Eastern Plaguelands, Light's Hope Chapel |achieve 966/9
	step
		goto Western Plaguelands 43.4,84.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Western Plaguelands, Chillwind Camp |achieve 966/22
	step
		goto Badlands 65.9,35.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Badlands, Fuselight |achieve 966/3
	step
		goto Badlands 20.9,56.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Badlands, Dragon's Mouth |achieve 966/2
	step
		goto Swamp of Sorrows 71.7,14.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Swamp of Sorrows, Bogpaddle |achieve 966/20
	step
		goto Swamp of Sorrows 28.9,32.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Swamp of Sorrows, The Harborage |achieve 966/21
	step
		goto Westfall,52.9,53.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Westfall, Sentinel Hill |achieve 966/25
		.' If you do not find the Candy Bucket here then it will be located at [56.8,47.3]
	step
		goto Duskwood,73.8,44.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Duskwood, Darkshire |achieve 966/8
	step
		goto Blasted Lands 60.7,14.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blasted Lands, Nethergarde Keep |achieve 966/4
	step
		goto Blasted Lands 44.4,87.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blasted Lands, Surwich |achieve 966/5
	step
		goto Northern Stranglethorn 53.1,67.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Northern Stranglethorn, Fort Livingston |achieve 966/16
	step
		goto The Cape of Stranglethorn,40.9,73.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Cape of Stranglethorn, Booty Bay |achieve 966/6
// Kalimdor
	step
		goto Northern Barrens,67.3,74.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Barrens, Ratchet |achieve 963/15
	step
		goto Southern Barrens 39.0,11.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Southern Barrens, Honor's Stand |achieve 963/18
	step
		goto Southern Barrens 65.6,46.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Southern Barrens, Northwatch Hold |achieve 963/19
	step
		goto Southern Barrens 49.0,68.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Southern Barrens, Fort Triumph |achieve 963/17
	step
		goto Dustwallow Marsh 55.9,49.6
		.talk Zidormi##63546
		.' Ask her to show you Theramore before it's destruction.
		|confirm
	step
		goto Dustwallow Marsh,66.6,45.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dustwallow Marsh, Theramore |achieve 963/9
	step
		goto 41.9,74.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dustwallow Marsh, Mudsprocket |achieve 963/8
	step
		goto Tanaris,52.5,27.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Tanaris, Gadgetzan |achieve 963/25
	step
		goto Tanaris 55.7,61.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Tanaris, Bootleggers Outpost |achieve 963/24
	step
		goto Un'Goro Crater 55.2,62.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Un'goro Crater, Marshal's Stand |achieve 963/27
	step
		goto Silithus,55.5,36.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Silithus, Cenarion Hold |achieve 963/16
	step
		goto Feralas,46.3,45.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Feralas, Feathermoon |achieve 963/14
	step
		goto Feralas 51.0,17.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Feralas, Dreamer's Rest |achieve 963/13
	step
		goto Desolace 56.7,50.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Desolace,Karnum's Glade |achieve 963/6
	step
		goto Desolace,66.3,6.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Desolace, Nijel's Point |achieve 963/7
	step
		goto Stonetalon Mountains 71.02,79.08
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Northwatch Expedition Base |achieve 963/21
	step
		goto Stonetalon Mountains 59.1,56.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Windshear Hold |achieve 963/23
	step
		goto Stonetalon Mountains 31.5,60.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Farwatcher's Glen |achieve 963/20
	step
		goto Stonetalon Mountains 39.5,32.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Stonetalon Mountains, Thal'darah Overlook |achieve 963/22
	step
		goto Ashenvale,37.0,49.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Ashenvale, Astranaar |achieve 963/1
	step
		goto Felwood 44.6,29.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Felwood, Whisperwind Grove |achieve 963/12
	step
		goto Felwood 61.8,26.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Felwood, Talonbranch Glade |achieve 963/11
	step
		goto Winterspring,59.8,51.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Winterspring, Everlook |achieve 963/28
	step
		goto Darkshore,50.8,18.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Darkshore, Lor'danel |achieve 963/4
	step
		goto The Exodar,59.3,18.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Exodar, Seat of the Naaru |achieve 963/10
	step
		goto Azuremyst Isle,48.5,49.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Azuremyst Isle, Azure Watch |achieve 963/2
	step
		goto Bloodmyst Isle,55.7,60.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Bloodmyst Isle, Blood Watch |achieve 963/3
	step
		goto Darnassus,62.3,33.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Darnassus, Craftsmen's Terrace |achieve 963/5
	step
		goto Teldrassil,55.4,52.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Teldrassil, Dolanaar |achieve 963/26
	step
		goto Hellfire Peninsula,54.3,63.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hellfire Peninsula, Honor Hold |achieve 969/4
	step
		goto 23.4,36.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Hellfire Peninsula, Temple of Telhamat |achieve 969/5
	step
		goto Shattrath City,56.3,81.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shattrath City, Scryer's Tier |achieve 969/11
		only if rep ('The Scryers')>=Neutral
	step
		goto Shattrath City,28.2,49.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shattrath City, Aldor Rise |achieve 969/11
		only if rep ('The Aldor')>=Neutral
	step
		goto Terokkar Forest,56.6,53.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Terokkar Forest, Allerian Stronghold |achieve 969/12
	step
		goto Shadowmoon Valley,37.0,58.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shadowmoon Valley, Wildhammer Stronghold |achieve 969/10
	step
		goto 56.4,59.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shadowmoon Valley, Sanctum of the Stars |achieve 969/9
		only if rep ('The Scryers')>=Neutral
	step
		goto 61.0,28.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Shadowmoon Valley, Altar of Sha'tar |achieve 969/9
		only if rep ('The Aldor')>=Neutral
	step
		goto Nagrand,54.2,75.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Nagrand, Telaar |achieve 969/6
	step
		goto Zangarmarsh,78.5,62.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zangarmarsh, Cenarion Refuge |achieve 969/13
	step
		goto 67.2,49.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zangarmarsh, Telredor |achieve 969/15
	step
		goto 41.9,26.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zangarmarsh, Orebor Harborage |achieve 969/14
	step
		goto Blade's Edge Mountains,35.8,63.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blade's Edge Mountains, Sylvanaar |achieve 969/2
	step
		goto 61.0,68.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blade's Edge Mountains, Toshley's Station |achieve 969/3
	step
		goto 62.9,38.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Blade's Edge Mountains, Evergrove |achieve 969/1
	step
		goto Netherstorm,32.0,64.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Netherstorm, Area 52 |achieve 969/7
	step
		goto 43.3,36.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Netherstorm, The Stormspire |achieve 969/8
	step
		goto Borean Tundra/0 58.5,67.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Borean Tundra, Valiance Keep |achieve 5836/3
	step
		 goto Borean Tundra/0 78.5,49.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Borean Tundra, Unu'pe |achieve 5836/2
	step
		goto Borean Tundra/0 57.1,18.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Borean Tundra, Fizzcrank Airstrip |achieve 5836/1
	step
		goto Sholazar Basin/0 26.6,59.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Sholazar Basin, Nesingwary Base Camp |achieve 5836/17
	step
		goto Dragonblight/0 28.9,56.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Stars' Rest |achieve 5836/8
	step
		 goto Dragonblight/0 48.1,74.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Moa'ki Harbor |achieve 5836/7
	step
		goto Dragonblight/0 60.2,53.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Wyrmrest Temple |achieve 5836/10
	step
		goto Dragonblight/0 77.5,51.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dragonblight, Wintergarde Keep |achieve 5836/9
	step
		goto Grizzly Hills/0 31.9,60.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Grizzly Hills, Amberpine Lodge |achieve 5836/11
	step
		goto Grizzly Hills/0 59.6,26.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Grizzly Hills, Amberpine Lodge |achieve 5836/12
	step
		goto Howling Fjord/0 60.5,15.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, Fort Wildervar |achieve 5836/13
	step
		goto Howling Fjord/0 58.3,62.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, Valgarde |achieve 5836/15
	step
		goto Howling Fjord/0 30.8,41.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, Valgarde |achieve 5836/16
	step
		goto Howling Fjord/0 25.4,59.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Howling Fjord, Valgarde |achieve 5836/14
	step
		goto Zul'Drak/0 40.9,66.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zul'Drak, The Argent Stand |achieve 5836/21
	step
		goto Zul'Drak/0 59.3,57.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Zul'Drak, Zim'Torga |achieve 5836/22
	step
		goto The Storm Peaks/0 41.1,85.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Storm Peaks, K3 |achieve 5836/20
	step
		goto The Storm Peaks/0 28.7,74.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Storm Peaks, Frosthold |achieve 5836/19
	step
		goto The Storm Peaks/0 30.9,37.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Storm Peaks, Bouldercrag's Refuge |achieve 5836/18
	step
		goto Dalaran/1 48.2,41.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dalaran, The Legerdemain Lounge |achieve 5836/4
	step
		goto Dalaran/1 42.4,63.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dalaran, Silver Enclave |achieve 5836/5
	step
		goto Dalaran/2 38.2,59.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dalaran, The Underbelly |achieve 5836/6
	step
		goto Mount Hyjal/0 63.1,24.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Mount Hyjal, Nordrassil |achieve 5837/3
	step
		goto Mount Hyjal/0 42.7,45.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Mount Hyjal, Shrine of Aviana |achieve 5837/4
	step
		goto Mount Hyjal/0 18.6,37.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Mount Hyjal, Grove of Aessina |achieve 5837/2
	step
		 goto Deepholm/0 47.4,51.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Deepholm, Temple of Earth |achieve 5837/1
	step
		goto Abyssal Depths/0 54.7,72.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Darkbreak Cove |achieve 5837/11
	step
		goto Shimmering Expanse/0 49.7,57.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Tranquil Wash |achieve 5837/14
	step
		 goto Shimmering Expanse/0 49.2,41.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Silver Tide Hollow |achieve 5837/13
	step
		goto Kelp'thar Forest/0 63.5,60.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vashj'ir, Deepmist Grotto |achieve 5837/12
	step
		goto Twilight Highlands/0 79.5,78.5
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Twilight Highlands, Highbank |achieve 5837/6
	step
		goto Twilight Highlands/0 60.4,58.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Twilight Highlands, Firebeard's Patrol |achieve 5837/5
	step
		goto Twilight Highlands/0 43.5,57.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Twilight Highlands, Victor's Point |achieve 5837/8
	step
		goto Twilight Highlands/0 49.6,30.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Twilight Highlands, Thundermar |achieve 5837/7
	step
		goto Uldum/0 54.7,33.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Uldum, Ramkahen |achieve 5837/10
	step
		goto Uldum/0 26.6,7.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Uldum, Oasis of Vir'sar |achieve 5837/9
	step
		'You must be at least level 90 to complete this step:
		.' Use the Dungeon Finder to queue for The Headless Horseman
		.from Headless Horseman##23682
		.' Complete the Bring Me The Head of... Oh Wait achievement |achieve 255
	step
		'Keep using your Tricky Treats quickly until you puke |use Tricky Treat##33226 |tip You get these by completing Hallows End quests.
		.' Complete the Out With It achievement |achieve 288
	step
		goto Elwynn Forest,31.8,50.1
		.talk Dorothy##53728
		.buy 1 Tooth Pick##37604 |n
		.' Use your Tooth Pick |use Tooth Pick##37604
		.' Show off your sparkling smile by using a Tooth Pick |achieve 981
	step
		'Use your Weighted Jack-o'-Lanterns on the following races: |use Weighted Jack-o'-Lantern##34068 |tip You receive Weighted Jack-o'-Lanterns by doing the Hallow's End daily quests.  Make sure the player doesn't already have a jack-o-lantern on their head or you won't get credit.  The best places to complete this would be Dalaran, Shattrath, Stormwind, and Orgrimmar.
		.' Gnome |achieve 291/4
		.' Goblin |achieve 291/5
		.' Blood Elf |achieve 291/1
		.' Draenei |achieve 291/2
		.' Dwarf |achieve 291/3
		.' Human |achieve 291/6
		.' Night Elf |achieve 291/7
		.' Orc |achieve 291/8
		.' Tauren |achieve 291/9
		.' Troll |achieve 291/10
		.' Undead |achieve 291/11
		.' Worgen |achieve 291/12
	step
		'Have other players use Hallowed Wands on you while in a party to transform into the following:
		.' Transform into a Bat |achieve 283/1
		.' Transform into a Ghost |achieve 283/2
		.' Transform into a Leper Gnome |achieve 283/3
		.' Transform into a Ninja |achieve 283/4
		.' Transform into a Pirate |achieve 283/5
		.' Transform into a Skeleton |achieve 283/6
		.' Transform into a Wisp |achieve 283/7
	step
		goto Elwynn Forest,31.8,50.1
		.talk Dorothy##53728
		.buy 1 Sinister Squashling##33154 |n
		.buy 1 Hallowed Helm##33292 |n
		.' Use the Sinister Squashling |use Sinister Squashling##33154
		.' Obtain a Sinister Squashling pet |achieve 292/1
		.' Obtain a Hallowed Helm |achieve 292/2
	step
		'Use your G.N.E.R.D.S. |use G.N.E.R.D.S.##37583 |tip You can buy these from the Hallows End vendor. Use them every 30 minutes while PvPing to keep the buff on.  If you don't have the buff active while killing players, you won't get credit.
		.' Do any type of PvP of your choice |tip You must be killing players that give you honor.
		.' Earn 10 honorable kills while under the influence of the G.N.E.R.D. buff |achieve 1261
	step
		'Congratulations, you are now one of The Hallowed!
]])

ZygorGuidesViewer:RegisterInclude("Hallows_End_Achievements_Alliance_Pandaria",[[
	step
		goto The Jade Forest/0 44.8,84.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Jade Forest, Paw'don Village |achieve 7601/6
	step
		goto The Jade Forest/0 59.6,83.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Jade Forest, Pearlfin Village |achieve 7601/7
	step
		goto The Jade Forest/0 54.6,63.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Jade Forest, Jade Temple Grounds |achieve 7601/5
	step
		goto The Jade Forest/0 45.8,43.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Jade Forest, Dawn's Blossom |achieve 7601/3
	step
		goto The Jade Forest/0 41.7,23.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Jade Forest, Tian Monastery |achieve 7601/9
	step
		goto The Jade Forest/0 55.7,24.4
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Jade Forest, Sri-La Village |achieve 7601/8
	step
		goto The Jade Forest/0 48.1,34.6
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Jade Forest, Greenstone Village |achieve 7601/4
	step
		goto Kun-Lai Summit/0 72.7,92.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, Binan Village |achieve 7601/12
	step
		goto Kun-Lai Summit/0 54.1,82.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, Westwind Rest |achieve 7601/15
	step
		goto Kun-Lai Summit/0 57.5,60.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, One Keg |achieve 7601/14
	step
		goto Kun-Lai Summit/0 64.2,61.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, The Grummle Bazaar |achieve 7601/13
	step
		goto Kun-Lai Summit/0 62.5,28.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Kun-Lai Summit, Zouchin Village |achieve 7601/16
	step
		goto Townlong Steppes/0 71.1,57.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Townlong Steppes, Longying Outpost |achieve 7601/18
	step
		goto Vale of Eternal Blossoms 35.1,77.7
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vale of Eternal Blossoms, Mistfall Village |achieve 7601/19
	step
		goto Vale of Eternal Blossoms/3 37.8,66.0
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Vale of Eternal Blossoms, Shrine of Seven Stars |achieve 7601/20
	step
		goto The Veiled Stair/0 55.1,72.2
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in The Veiled Stair, Tavern in the Mists |achieve 7601/17
	step
		goto Valley of the Four Winds/0 83.7,20.1
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Valley of the Four Winds, Pang's Stead |achieve 7601/21
	step
		goto Valley of the Four Winds/0 19.9,55.8
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Valley of the Four Winds, Stoneplow |achieve 7601/22
	step
		goto Dread Wastes 55.9,32.3
		.click Candy Bucket##6404
		.' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dread Wastes, Klaxxi'vess |achieve 7601/1
	step
		goto Dread Wastes 55.2,71.2
		.click Candy Bucket##6404
		.' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Candy item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Dread Wastes, Soggy's Gamble |achieve 7601/2
	step
		goto Krasarang Wilds/0 75.9,6.9
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Krasarang Wilds, Zhu's Watch |achieve 7601/11
	step
		goto Krasarang Wilds/0 51.4,77.3
		.click Candy Bucket##6404
		..' Complete the Candy Bucket quest |tip If you cannot complete this quest because of a "Duplicate item found" message, open the Handful of Treats item in your bags and take out the contents. |use Handful of Treats##37586
		.' Visit the Candy Bucket in Krasarang Wilds, Marista |achieve 7601/10
]])

--  Pilgrims Bounty --
ZygorGuidesViewer:RegisterInclude("Pilgrims_Bounty_Quests_Alliance",[[
	step
		.' You will need to have 300 cooking in order to complete this guide.
		|confirm
	step
		goto Elwynn Forest,34.2,51.1
		.talk Bountiful Table Hostess##34653
		..accept Sharing a Bountiful Feast##14064
	step
		goto 34.3,51.1
		.clicknpc The Turkey Chair##34812 |tip They look like wooden chairs around a round white and green table with food on it.
		.' Use the first ability on your hotbar to Pass the food to other players who are sitting at the table |tip You must target the other players and use the Pass the Food ability.  Do this repeatedly until you get an achievement.
		.' Start a Food Fight! |achieve 3579
		.' Use the other abilities on your hotbar to eat the food |tip You will only be able to eat certain foods at each place on the table.  Once you eat the foods available to your spot 5 times, click the red arrow above your action bar to get out of the Turkey Chair.  Then, go sit in another Turkey Chair that has a type of food you haven't eaten yet.
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Gain the Spirit of Sharing |q 14064/1
	step
		goto 34.2,51.1
		.talk Bountiful Table Hostess##34653
		..turnin Sharing a Bountiful Feast##14064
	step
		goto 33.7,50.6
		.talk Ellen Moore##34710
		.skillmax Cooking,75
		.learn Spice Bread##37836
	step
		goto 34.1,51.5
		.talk Wilmina Holbeck##34682
		.buy Bountiful Cookbook##46809
	step
		'Use your Bountiful Cookbook |use Bountiful Cookbook##46809
		.collect Recipe: Spice Bread Stuffing##44860
		.collect Recipe: Pumpkin Pie##44862
		.collect Recipe: Cranberry Chutney##44858
		.collect Recipe: Candied Sweet Potato##44859
		.collect Recipe: Slow-Roasted Turkey##44859
	step
		'Use your Recipe: Spice Bread Stuffing to learn the recipe |use Recipe: Spice Bread Stuffing##44860
		.learn Spice Bread Stuffing##62050
	step
		goto 34.1,51.5
		.talk Gregory Tabor##34675
		..accept Spice Bread Stuffing##14023
	step
		goto 34.1,51.5
		.talk Wilmina Holbeck##34682
		.buy Simple Flour##30817 |n
		.buy Mild Spices##2678 |n
		.buy Autumnal Herbs##44835 |n
		.' Cook next to the Pilgrim's Bounty Cooking Fire at [33.8,50.8]
		.create 5 Spice Bread##37836,Cooking,5 total
	step
		.create 5 Spice Bread Stuffing##62050,Cooking,5 total  |q 14023/1
		.get 5 Spice Bread Stuffing |q 14023/2
		skill Cooking,100
		.' If you need to train your Cooking skill to allow a higher max level, talk to Ellen Moore at [33.7,50.6]
	step
		'Use your Recipe: Pumpkin Pie to learn the recipe |use Recipe: Pumpkin Pie##44862
		.learn Pumpkin Pie##62044
	step
		goto 33.9,50.8
		.talk Jasper Moore##34744
		..turnin Spice Bread Stuffing##14023
		..accept Pumpkin Pie##14024
	step
		goto 34.1,51.5
		.talk Wilmina Holbeck##34682
		.buy 5 Ripe Elwynn Pumpkin##46784
		.buy 5 Honey##44853
		.buy 5 Autumnal Herbs##44835
		.buy 5 Mild Spices##2678
		.buy 5 Simple Flour##30817
	step
		.' Cook next to the Pilgrim's Bounty Cooking Fire at [33.8,50.8]
		.create Pumpkin Pie##62044,Cooking,5 total |q 14024/1
		.get 5 Pumpkin Pie |q 14024/2
		.skill Cooking,160
		.' If you need to train your Cooking skill to allow a higher max level, talk to Ellen Moore at [33.7,50.6]	
	step
		'Use your Recipe: Cranberry Chutney to learn the recipe |use Recipe: Cranberry Chutney##44858
		.learn Cranberry Chuntney##62049
	step
		goto Dun Morogh,59.8,34.3
		.talk Edward Winslow##34644
		..turnin Pumpkin Pie##14024
		..accept Cranberry Chutney##14028
	step
		goto 59.77,34.34
		.talk Elizabeth Barker Winslow##34645
		.buy Tangy Southfury Cranberries##44854 |n
		.buy Honey##44853 |n
		.' Cook next to the Pilgrim's Bounty Cooking Fire at [59.61,34.94]
		.create 5 Cranberry Chutney##62049,Cooking,5 total |q 14028/1
		.get 5 Cranberry Chutney |q 14028/2
		.skill Cooking,220
		.' If you need to train your Cooking skill to allow a higher max level, talk to Caitrin Ironkettle at [52.9,36.1]
	step
		goto Ironforge,58.1,49.4
		.talk Gnome Commoner##19172
		..accept Pilgrim's Bounty##14022
	step
		goto Elwynn Forest,33.9,50.8
		.talk Jasper Moore##34744
		..turnin Cranberry Chutney##14028
		..accept They're Ravenous In Darnassus##14030
	step
		'Use your Recipe: Candied Sweet Potato to learn the recipe |use Recipe: Candied Sweet Potato##44859
		.learn Candied Sweet Potato##62051
	step
		goto 34.1,51.5
		.talk Gregory Tabor##34675
		..turnin Pilgrim's Bounty##14022
	step
		goto 34.1,51.5
		.talk Wilmina Holbeck##34682
		.buy 5 Ripe Elwynn Pumpkin##46784 |n
		.buy 5 Honey##44853 |n
		.buy 5 Autumnal Herbs##44835 |n
		.buy 5 Mild Spices##2678 |n
		.buy 5 Simple Flour##30817 |n
		.' Cook next to the Pilgrim's Bounty Cooking Fire at [33.8,50.8]
		.create Pumpkin Pie##62044,Cooking,5 total |q 14030
		.get 5 Pumpkin Pie |q 14030/2
	step
		goto 33.8,50.8
		.create 5 Spice Bread##37836,Cooking,5 total |n
		.' and
		.create 5 Spice Bread Stuffing##62050,Cooking,5 total  |q 14030
		.get 5 Spice Bread Stuffing |q 14030/1
		.skill Cooking,160
		.' If you need to train your Cooking skill to allow a higher max level, talk to Ellen Moore at [33.7,50.6]
	step
		goto Darnassus,61.5,49.0
		.talk Isaac Allerton##34676
		..turnin They're Ravenous In Darnassus##14030
		..accept Candied Sweet Potatoes##14033
	step
		goto 62.1,46.0
		.talk Ikaneba Summerset##34681
		.buy Teldrassil Sweet Potato##44855 |n
		.buy Honey##44853 |n
		.buy Autumnal Herbs##44835 |n
		.' Cook next to the Pilgrim's Bounty Cooking Fire at [61.6,49.1]
		.create 5 Candied Sweet Potatoes##62051,Cooking,5 total |q 14033/1
		.get 5 Candied Sweet Potatoes |q 14033/2
		.skill Cooking,280
		.' If you need to train your Cooking skill to allow a higher max level, talk to Mary Allerton at [66.5,35.1]
	step
		goto Elwynn Forest,34.1,51.5
		.talk Gregory Tabor##34675
		..turnin Candied Sweet Potatoes##14033
		..accept Slow-roasted Turkey##14035
	step
		'Use your Recipe: Slow-Roasted Turkey to learn the recipe |use Recipe: Slow-Roasted Turkey##44861
		.learn Slow-Roasted Turkey##62045
	step
		goto 42.5,62.8
		.from Wild Turkey##32820+ |tip You can find these all around Elwynn Forest, so you are not limited to staying in this area.  Ride around Elwynn Forest and look for Wild Turkeys, you should be able to find them easily if you ride around.
		.collect 20 Wild Turkey##44834 |q 14035
	step
		goto 34.1,51.5
		.talk Wilmina Holbeck##34682
		.buy 10 Honey##44853 |n
		.buy Autumnal Herbs##44835 |n
		.' Cook next to the Pilgrim's Bounty Cooking Fire at [33.8,50.8]
		.create 5 Slow-Roasted Turkey##62045,Cooking,5 total |q 14035/1
		.get 5 Slow-Roasted Turkey |q 14035/2
		.' Earn the Now We're Cookin' Achievement |achieve 3576
		.skill Cooking,300
		.' If you need to train your Cooking skill to allow a higher max level, talk to Ellen Moore at [33.7,50.6]
	step
		goto Darnassus,61.5,49.1
		.talk Isaac Allerton##34676
		..turnin Slow-roasted Turkey##14035
]])

ZygorGuidesViewer:RegisterInclude("Pilgrims_Bounty_Dailies_Alliance",[[
	step
	label	"start"
		These are the Dailies and Achievements for Pilgrim's Bounty. You can only do the Dailies once per day.
		|confirm always
	step
		#include "home_TradeDistrict"
	step
		goto Elwynn Forest,34.3,51.1
		.clicknpc The Turkey Chair##34812 |tip They look like wooden chairs around a round white and green table with food on it.
		.' Use the first ability on your hotbar to Pass the food to other players who are sitting at the table |tip You must target the other players and use the Pass the Food ability.  Do this repeatedly until you get an achievement.
		.' Start a Food Fight! |achieve 3579
		.' Use the other abilities on your hotbar to eat the food |tip You will only be able to eat certain foods at each place on the table.  Once you eat the foods available to your spot 5 times, click the red arrow above your action bar to get out of the Turkey Chair.  Then, go sit in another Turkey Chair that has a type of food you haven't eaten yet.
		.' Earn the Pilgrims Paunch in Stormwind |achieve 3556/4
	step
		'While still at the table, go to each of the chairs.
		.' While in each of the chairs, press 1.
		.' Pass the Candied Sweet Potatoes. |achieve 3558/1
		.' Pass the Cranberry Chutney. |achieve 3558/2
		.' Pass the Pumpkin Pie. |achieve 3558/3
		.' Pass the Slow-Roasted Turkey. |achieve 3558/4
		.' Pass the Spice Bread Stuffing. |achieve 3558/5
		.' Earn the Sharing is Caring Achievement. |achieve 3558
	step
		goto Elwynn Forest,33.9,50.8
		.talk Jasper Moore##34744
		..accept She Says Potato##14055
	step
		goto 33.7,50.6
		.talk Ellen Moore##34710
		..accept We're Out of Cranberry Chutney Again?##14053
	step
		goto Elwynn Forest,34.1,51.5
		.talk Wilmina Holbeck##34682
		.buy 20 Ripe Elwynn Pumpkin##46784 |q 14054
		.buy 20 Honey##44853 |q 14054
	step
		goto 42.5,62.8
		.from Wild Turkey##32820+ |tip You can find these all around Elwynn Forest, so you are not limited to staying in this area.
		.collect 20 Wild Turkey##44834 |q 14048 |future
	step
		goto Darnassus,61.9,46.2
		.talk Mary Allerton##34711
		..accept Easy As Pie##14054
	step
		goto 62.1,46.0
		.create Pumpkin Pie##62044,Cooking,20 total |q 14054/1
	step
		goto Darnassus,62.8,48.2
		.clicknpc The Turkey Chair##34812 |tip They look like wooden chairs around a round white and green table with food on it.
		.' Use the other abilities on your hotbar to eat the food |tip You will only be able to eat certain foods at each place on the table.  Once you eat the foods available to your spot 5 times, click the red arrow above your action bar to get out of the Turkey Chair.  Then, go sit in another Turkey Chair that has a type of food you haven't eaten yet.
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Earn the Pilgrims Paunch in Darnassus |achieve 3556/1
	step
		goto 61.7,49.1
		.talk Ikaneba Summerset##34681
		.buy 20 Teldrassil Sweet Potato##44855
		.buy 20 Honey##44853
		.buy 20 Autumnal Herbs##44835
	step
		goto Darnassus,61.9,46.2
		.talk Mary Allerton##34711
		..turnin Easy As Pie##14054
		.' Choose one of the following until you have all three pieces:
		.collect Pilgrim's Hat##46723
		.collect Pilgrim's Attire##46800
		.collect Turkey Shooter##44812 |tip You can collect multiple Turkey Shooters if you have the other 2 pieces.
		|confirm
	step
		goto 61.9,46.2
		.create 20 Candied Sweet Potato##62051,Cooking,20 total |q 14055/1
	step
		 goto 44.2,78.7
		.click Portal to Exodar##06955
		.' Teleport to The Exodar |goto The Exodar |noway |c
		|only if not achieved(3556)
	step
		goto The Exodar,53.9,32.4 |n
		.' Follow this ramp up and outside The Exodar |goto The Exodar,53.9,32.4,1 |noway |c
		|only if not achieved(3556)
	step
		goto The Exodar,75.7,52.3
		.clicknpc The Turkey Chair##34812 |tip They look like wooden chairs around a round white and green table with food on it.
		.' Use the other abilities on your hotbar to eat the food |tip You will only be able to eat certain foods at each place on the table.  Once you eat the foods available to your spot 5 times, click the red arrow above your action bar to get out of the Turkey Chair.  Then, go sit in another Turkey Chair that has a type of food you haven't eaten yet.
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Earn the Pilgrims Paunch in The Exodar |achieve 3556/2
		|only if not achieved(3556)
	step
		goto Dun Morogh,60.1,34.3
		.talk Caitrin Ironkettle##34708
		..accept Don't Forget The Stuffing!##14051
		..accept Can't Get Enough Turkey##14048
	step
		goto Dun Morogh,59.9,34.6
		.clicknpc The Turkey Chair##34812 |tip They look like wooden chairs around a round white and green table with food on it.
		.' Use the other abilities on your hotbar to eat the food |tip You will only be able to eat certain foods at each place on the table.  Once you eat the foods available to your spot 5 times, click the red arrow above your action bar to get out of the Turkey Chair.  Then, go sit in another Turkey Chair that has a type of food you haven't eaten yet.
		.' Eat each type of food 5 times in a row |tip You can see how many times you've eaten the food by looking at it's buff that it gives you next to your mini map.
		.' Earn the Pilgrims Paunch in Ironforge |achieve 3556/3
		.' Earn the Pilgrims Paunch Achievement! |achieve 3556
	step
		goto 59.8,34.3
		.talk Elizabeth Barker Winslow##34645
		.buy 20 Tangy Wetland Cranberries##44854
		.buy 20 Mild Spices##2678
		.buy 20 Simple Flour##30817
		.buy 60 Honey##44853
		.buy 40 Autumnal Herbs##44835
		.buy 20 Tangy Wetland Cranberries##44854
	step
		goto 60.0,34.4
		.create 20 Spice Bread##37836,Cooking,20 total |q 14051
	step
		goto 60.0,34.4
		.create 20 Spice Bread Stuffing##62050,Cooking,20 total |q 14051/1
	step
		goto Dun Morogh,60.1,34.3
		.talk Caitrin Ironkettle##34708
		..turnin Don't Forget The Stuffing!##14051
		.' Choose one of the following until you have all three pieces:
		.collect Pilgrim's Hat##46723
		.collect Pilgrim's Attire##46800
		.collect Turkey Shooter##44812 |tip You can collect multiple Turkey Shooters if you have the other 2 pieces.
		|confirm
	step
		goto 60.0,34.4
		.create 20 Slow-Roasted Turkey##62045,Cooking,20 total |q 14048/1
	step
		goto Dun Morogh,60.1,34.3
		.talk Caitrin Ironkettle##34708
		..turnin Can't Get Enough Turkey##14048
		.' Choose one of the following until you have all three pieces:
		.collect Pilgrim's Hat##46723
		.collect Pilgrim's Attire##46800
		.collect Turkey Shooter##44812 |tip You can collect multiple Turkey Shooters if you have the other 2 pieces.
		|confirm
	step
		goto 60.0,34.4
		.create Cranberry Chutney##62049,Cooking,20 total |q 14053/1
	step
		goto Elwynn Forest,33.9,50.8
		.talk Jasper Moore##34744
		..turnin She Says Potato##14055
		.' Choose one of the following until you have all three pieces:
		.collect Pilgrim's Hat##46723
		.collect Pilgrim's Attire##46800
		.collect Turkey Shooter##44812 |tip You can collect multiple Turkey Shooters if you have the other 2 pieces.
		|confirm
	step
		goto 33.7,50.6
		.talk Ellen Moore##34710
		..turnin We're Out of Cranberry Chutney Again?##14053
		.' Choose one of the following until you have all three pieces:
		.collect Pilgrim's Hat##46723
		.collect Pilgrim's Attire##46800
		.collect Turkey Shooter##44812 |tip You can collect multiple Turkey Shooters if you have the other 2 pieces.
		|confirm
		.' Earn the Pilgrims Progress Achievement |achieve 3596
	step
		goto 42.5,62.8
		.from Wild Turkey##32820+
		.' Quickly kill _40 Wild Turkeys_ and keep killing them until you earn the achievement: |tip You can see how many turkeys you have killed with the Turkey Tracker buff. |tip You can find more Turkeys all around Elwynn Forest.
		.' The Turkinator! |achieve 3578
	step
		.' You should have three pieces of the Pilgrim's Attire now
		.' Equip your Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800
	step
		goto Undercity,68.6,6.7
		.' While wearing your Pilgrim's Attire, sit at any table's chair |modelnpc The Turkey Chair##34812
		.' Equip your Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800
		.' Pilgrim's Peril of Undercity |achieve 3580/4
	step
		goto Eversong Woods,55.2,53.2
		|tip You can run up The Dead Scar most of the way to avoid Horde towns. This is the Grey line running up the map on the left.
		.' While wearing your Pilgrim's Attire, sit at any table's chair |modelnpc The Turkey Chair##34812
		.' Equip your Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800
		.' Pilgrim's Peril of Silvermoon City |achieve 3580/2
	step
		goto Thunder Bluff,28.6,62.8
		.' While wearing your Pilgrim's Attire, sit at any table's chair |modelnpc The Turkey Chair##34812
		.' Equip your Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800
		.' Pilgrim's Peril of Thunder Bluff |achieve 3580/3
	step
		goto Durotar,46.2,15.1
		.' While wearing your Pilgrim's Attire, sit at any table's chair |modelnpc The Turkey Chair##34812
		.' Equip your Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800
		.' Pilgrim's Peril of Orgrimmar |achieve 3580/1
		.' Earn the Pilgrim's Peril Achievement! |achieve 3580
	step
		goto Durotar,46.2,15.1
		.' You should have a few _Turkey Shooters_ from your daily quests, if you don't, you will need to do more daily's when possible for more.
		.' While in Durotar, shoot Horde Rogues with your Turkey Shooter. |use Turkey Shooter##44812
		.' Shoot a Blood Elf Rogue |achieve 3559/1
		.' Shoot a Orc Rogue |achieve 3559/7
		.' Shoot a Troll Rogue |achieve 3559/8
		.' Shoot a Undead Rogue |achieve 3559/9
		.' Shoot a Goblin Rogue |achieve 3559/4
	step
		.' You should have a few _Turkey Shooters_ from your daily quests, if you don't, you will need to do more daily's when possible for more.
		.' While in Elwynn Forest, shoot Alliance Rogues with your Turkey Shooter. |use Turkey Shooter##44812
		.' Shoot a Dwarf Rogue |achieve 3559/2
		.' Shoot a Gnome Rogue |achieve 3559/3
		.' Shoot a Human Rogue |achieve 3559/5
		.' Shoot a Night Elf Rogue |achieve 3559/6
		.' Shoot a Worgen Rogue |achieve 3559/10
	step
		goto Sethekk Halls,49.4,95.3 |n
		 .' Follow this stairway up and around |goto Sethekk Halls,49.4,95.3,0.5 |noway |c
	step
		goto Sethekk Halls,36.4,88.7 |n
		.' Keep following this path around |goto Sethekk Halls,36.4,88.7,1 |noway |c
	step
		goto Sethekk Halls/2 32.5,39.5
		.' Equip your Pilgrim's Attire |equipped Pilgrim's Attire##46800 |use Pilgrim's Attire##46800
		.' Equip your Pilgrim's Hat |equipped Pilgrim's Hat##46723 |use Pilgrim's Hat##46723
		.from Talon King Ikiss##18473
		.' Earn the Achievment Terokkar Turkey Time |achieve 3582
	step
		.' You have reached the End of this guide, you can only do the Dailys Once per day.
		Click here to start the Dailys over. |confirm always
		|next "end" |only if achieved(3478)
		|next "start" |only if not achieved(3478)
	step
	label	"end"
		.' Congratualtions, you have earned the Pilgrim Achievement!

]])

-- Feast of Winter Veil --

ZygorGuidesViewer:RegisterInclude("Feast of Winter Veil Quests",[[
		goto Ironforge,33.7,67.3
		.talk Wulmort Jinglepocket##13433
		..accept Greatfather Winter is Here!##7022
	step
		goto 33.1,65.5
		.talk Greatfather Winter##13444
		..turnin Greatfather Winter is Here!##7022
		..accept Treats for Greatfather Winter##7025
	step
		goto 30.2,59.4
		.talk Goli Krumn##1365
		..accept The Reason for the Season##7062
	step
		goto 60.1,36.4
		.talk Daryl Riknussun##5159
		.' Learn the Apprentice Cooking skill.
		|only if skill("Cooking")<=1
	step
		goto 77.5,11.8
		.talk Historian Karnik##2916
		..turnin The Reason for the Season##7062
		..accept The Feast of Winter Veil##7063
	step
		goto 33.7,67.3
		.talk Wulmort Jinglepocket##13433
		.buy 1 Recipe: Gingerbread Cookie##17200 |n
		.' Click the Recipe: Gingerbread Cookie recipe in your bags |use Recipe: Gingerbread Cookie##17200
		.learn Gingerbread Cookie##21143
		|confirm
	step
		goto 33.7,67.3
		.talk Wulmort Jinglepocket##13433
		.buy 5 Holiday Spices##17194 |q 7025
	step
		'Buy 5 Small Eggs from the Auction House:
		.collect 5 Small Egg##6889 |q 7025 |next "cook" |only if default
		.' Click here to farm these yourself. |confirm |next
	step
		goto Westfall 50.8,24.4
		.from Young Fleshripper##199+, Greater Fleshripper##154+
		.collect 5 Small Egg##6889 |q 7025
	step
	label "cook"
		goto Ironforge 32.1,62.8
		.create 5 Gingerbread Cookie##21143,Cooking,5 total |q 7025/1
	step
		goto 18.1,51.4
		.talk Innkeeper Firebrew##5111
		.buy Ice Cold Milk##1179 |q 7025
	step
		goto 18.1,51.4
		.talk Innkeeper Firebrew##5111
		.home Ironforge
	step
		goto 33.1,65.5
		.talk Greatfather Winter##13444
		..turnin Treats for Greatfather Winter##7025
	step
		goto 39.2,56.0
		.talk Muradin Bronzebeard##42928
		..turnin The Feast of Winter Veil##7063
	step
		goto Hillsbrad Foothills,42.3,41.1
		.talk Strange Snowman##13636
		..accept You're a Mean One...##7043
		|only if level>=80
	step
		goto Hillsbrad Foothills,43.6,39.0
		.from The Abominable Greench##54499
		.get Stolen Treats |q 7043/2 |tip They are the bags on the ground behind the Abominable Greench.
		.' Free Metzen the Reindeer. |q 7043/1 |tip After you defeat The Abominable Greench Metzen is freed.
		|only if level>=80 and havequest(7043)
	step
		goto Ironforge,33.7,67.3
		.talk Wulmort Jinglepocket##13433
		.turnin You're a Mean One...##7043 |only if level>=80 and havequest(7043)
		..accept A Smokywood Pastures' Thank You!##7045
	step
		goto 33.1,65.5
		.talk Greatfather Winter##13444
		..turnin A Smokywood Pastures' Thank You!##7045
]])

ZygorGuidesViewer:RegisterInclude("Feast of Winter Veil Achievements",[[
	step
		goto Ironforge,19.9,53.8
		.' Kiss a Winter Reveler every hour |script DoEmote("KISS") |tip You can only use this once per hour. The items you get are random.
		.collect 10 Handful of Snowflakes##34191 |n
		.collect 8 Mistletoe##21519 |n
		.collect 1 Preserved Holly##21213 |n
		.' Once you've collected these items, click here to proceed. |confirm
	step
		'Use a Handful of Snowflakes on the following race/class combinations |use Handful of Snowflakes##34191 |tip The best place to complete this is in major cities, but it can be done anywhere in the world.
		.' You can get more snowflakes by using /kiss on Winter Revelers at [19.9,53.8]
		.' Orc Death Knight |achieve 1687/1
		.' Human Warrior |achieve 1687/2
		.' Tauren Shaman |achieve 1687/3
		.' Night Elf Druid |achieve 1687/4
		.' Undead Rogue |achieve 1687/5
		.' Troll Hunter |achieve 1687/6
		.' Gnome Mage |achieve 1687/7
		.' Dwarf Paladin |achieve 1687/8
		.' Blood Elf Warlock |achieve 1687/9
		.' Draenei Priest |achieve 1687/10
	step
		goto Ironforge,33.7,67.3
		.talk Wulmort Jinglepocket##13433
		.buy Recipe: Hot Apple Cider##34413
		.buy Recipe: Egg Nog##17201
	step
		.learn Recipe: Hot Apple Cider##45022 |use Recipe: Hot Apple Cider##34413
		.learn Recipe: Egg Nog##21144 |use Recipe: Egg Nog##17201
		.create Egg Nog##21144,Cooking,1 total |achieve 1688/2
		.create Hot Apple Cider##45022,Cooking,1 total |achieve 1688/3 |tip Requires a cooking skill of 325
	step
		'Use the Tailoring profession or pay a tailor to create Red or Green Winter Clothes.
		.' You can buy the pattern from Wulmort Jinglepocket at [33.7,67.3]
		.collect Red Winter Clothes##34085
	step
		'Use the Leatherworking profession or pay a leatherworker to create Winter Boots
		.' You can buy the pattern from Wulmort Jinglepocket at [33.7,67.3]
		.collect Winter Boots##34086
	step
		'Queue for Heroic The Nexus dungeon.
		.' You can also run to the instance and do it.
		.from Grand Magus Telestra##26731
		.collect Red Winter Hat##21524
	step
		'Get the Smokywood Pastures Sampler from your mailbox |tip It should arrive within 24 hours after completing the Feast of Winter Veil quest section of this guide.
		.' Click the Smokywood Pastures Sampler in your bag |use Smokywood Pastures Sampler##17685
		.collect 1 Graccu's Mince Meat Fruitcake##21215
		.' Equip the Red Winter Clothes |use Red Winter Clothes##34085
		.' Equip the Winter Boots |use Winter Boots##34086
		.' Equip the Red Winter Hat |use Red Winter Hat##21524
		.' During the Feast of Winter Veil, wear 3 pieces of winter clothing and eat Graccu's Mince Meat Fruitcake |use Graccu's Mince Meat Fruitcake##21215 |achieve 277
	step
		goto Dun Morogh,60.3,33.9
		.' Use the Winter Wondervolt machine to turn into a Little Helper |Use them every 30 minutes while PvPing to keep the buff on.  If you don't have the buff active while killing players, you won't get credit.
		.' Do any type of PvP of your choice |tip We recommend Alterac Valley. You must be killing players that give you honor.
		.' Earn 50 honorable kills as a Little Helper from the Winter Wondervolt machine |achieve 252
	step
		'Make sure you have the following in your bags:
		.collect 8 Mistletoe##21519
		.collect Preserved Holly##21213
	step
		goto Ironforge,33.7,67.3
		.talk Wulmort Jinglepocket##13433
		.buy Snowball##17202
	step
		goto 39.2,56.0
		.' Use a snowball on Muradin Bronzebeard |use Snowball##17202
		.' Throw a snowball at Muradin Bronzebeard during the Feast of Winter Veil |achieve 1255
	step
		goto 76.9,51.2 |n
		.' Ride the Deep Run Tram to Stormwind City |goto Stormwind City |noway |c
	step
		goto 55.0,54.2
		.' Use your Mistletoe on Brother Kristoff |use Mistletoe##21519
		.' Use Mistletoe on Brother Kristoff in Stormwind City |achieve 1686/4
		|modelnpc 1444
	step
		 goto 51.6,46.4
		.' Use your Mistletoe on Brother Benjamin |use Mistletoe##21519 |tip He patrols in front of this entryway, so you may need to search for him.
		.' Use Mistletoe on Brother Benjamin in the Stormwind City |achieve 1686/8
		|modelnpc 5484
	step
		goto 52.4,45.8
		.' Use your Mistletoe on Brother Cassius |use Mistletoe##21519
		.' Use Mistletoe on Brother Cassius in the Stormwind City |achieve 1686/7
		|modelnpc 1351
	step
		goto 49.5,45.2
		.' Use your Mistletoe on Brother Joshua |use Mistletoe##21519
		.' Use Mistletoe on Brother Joshua in the Stormwind City |achieve 1686/5
		|modelnpc 5489
	step
		goto 52.6,43.2
		.' Use your Mistletoe on Brother Crowley |use Mistletoe##21519 |tip He is at the lower level of the cathedral, down the ramp.
		.' Use Mistletoe on Brother Crowley in the Stormwind City |achieve 1686/6
		|modelnpc 12336
	 step
		goto 60.4,75.3
		.talk Innkeeper Allison##6740
		.home Stormwind City
	step
		goto Elwynn Forest,41.1,66.0
		.' Use your Mistletoe on Brother Wilhelm |use Mistletoe##21519 |modelnpc 927
		.' Use Mistletoe on Brother Wilhelm in Goldshire |achieve 1686/2
	step
		goto Northern Stranglethorn,47.3,11.1
		.' Use your Mistletoe on Brother Nimetz |use Mistletoe##21519
		.' Use Mistletoe on Brother Nimetz in Northern Stranglethorn |achieve 1686/1
		|modelnpc 739
	step
		goto Dustwallow Marsh,67.4,47.4
		.' Use your Mistletoe on Brother Karman |use Mistletoe##21519
		.' Use Mistletoe on Brother Karman in Dustwallow Marsh |achieve 1686/3
	step
		.' The following achievements require a level 70 or higher character.
		|confirm
	step
		goto Blade's Edge Mountains,28.7,57.4
		.talk Chu'a'lor##23233
		..accept The Trouble Below##11057
		..accept The Crystals##11025
	step
		goto 29.2,53.7
		.from Apexis Flayer##22175+
		.get 5 Apexis Shard |q 11025/1
	step
		goto 28.8,57.4
		.talk Chu'a'lor##23233
		..turnin The Crystals##11025
		..accept An Apexis Relic##11058
	step
		goto 28.4,57.6
		.talk Torkus##23316
		..accept Our Boy Wants To Be A Skyguard Ranger##11030
	step
		goto 33.1,52.3
		.from Gan'arg Analyzer##23386+
		.collect Apexis Shard##32569 |n
		.' Click an Apexis Relic |tip It looks like a small multi-colored crystal floating in the air.
		..' Insert an Apexis Shard to begin.
		.' Stand on the white globe and watch as the crystal floating above you casts a beam on the surrounding clusters
		.' Click the clusters in the same color pattern as the crystal. |tip You must do this six times. If you mess up you will be given a few chances to correct yourself before you have to start the process over.
		.' Attain the Apexis Vibrations |q 11058/1
	step
		goto 51.1,15.6
		.from Bash'ir Arcanist##22243+, Bash'ir Spell-Thief##22242+, Bash'ir Raider##22241+
		.collect 10 Apexis Shard##32569
	step
		goto 32.8,40.5
		.click Fel Crystalforge##7391
		.' Purchase 1 Unstable Flask of the Beast
		.get Unstable Flask of the Beast |q 11030/1
	step
		goto 28.8,57.4
		.talk Chu'a'lor##23233
		..turnin An Apexis Relic##11058
		..accept The Relic's Emanation##11080
	step
		goto 28.4,57.7
		.talk Torkus##23316
		..turnin Our Boy Wants To Be A Skyguard Ranger##11030
	step
		goto 27.7,68.1
		.from Gan'arg Analyzer##23386+
		.collect Apexis Shard##32569 |n
		.' Click an Apexis Relic |tip It flooks like a small multi-colored crystal floating in the air
		.' Insert an Apexis Shard to begin.
		.' Stand on the white globe and watch as the crystal floating above you casts a beam on the surrounding clusters
		.' Click the clusters in the same color pattern as the crystal.
		.' You must do this six times. If you mess up you will be given a few chances to correct yourself before you have to start the process over.
		.' Attain the Apexis Vibrations |q 11080/1
	step
		goto 28.8,57.4
		.talk Chu'a'lor##23233
		..turnin The Relic's Emanation##11080
		..accept The Skyguard Outpost##11062
	step
		goto 27.4,52.7
		.talk Sky Commander Keller##23334
		..turnin The Skyguard Outpost##11062
	//END UNLOCKING DAILIES
	step
		goto 27.6,52.9
		.talk Sky Sergeant Vanderlip##23120
		..accept Bombing Run##11010
	step
		goto 36.8,39.4
		.' While on your flying mount, use your Skyguard Bombs on Fel Cannonball Stacks |use Skyguard Bombs##32456
		.' Destroy 15 Fel Cannonball Stacks |q 11010/1
	step
		goto 27.6,52.9
		.talk Sky Sergeant Vanderlip##23120
		..turnin Bombing Run##11010
		..accept Bomb Them Again!##11023
	step
		'Use Preserved Holly while riding your flying mount |use Preserved Holly##21213 |havebuff Interface\Icons\INV_Misc_Plant_03 |q 11023
	step
		goto 36.8,39.4
		.' While on riding the Reindeer Mount, use the Skyguard Bombs on Fel Cannonball Stacks |use Skyguard Bombs##32456
		.' Destroy 15 Fel Cannonball Stacks |q 11023/1
	step
		goto 27.6,52.9
		.talk Sky Sergeant Vanderlip##23120
		..turnin Bomb Them Again!##11023 |tip You have to be on your mount when turning in the quest.
		.' Complete the Bomb Them Again! quest while mounted on a flying reindeer during the Feast of Winter Veil |achieve 1282
	//DALARAN
	step
		goto Dalaran,50.3,63.2
		.' Get the Winter Veil Disguise Kit from your mailbox |tip It should arrive within 24 hours after completing the Feast of Winter Veil quest section of this guide.
		.' Equip the Winter Veil Disguise Kit in your bag |use Winter Veil Disguise Kit##17712
		.' Dance with another player wearing their snowman costume |script DoEmote("DANCE")
		.' During the Feast of Winter Veil, use your Winter Veil Disguise kit to become a snowman and then dance with another snowman in Dalaran |achieve 1690
	step
		goto Stormwind City,61.2,73.5
		.' This step can only be completed by logging into the server on December 25th.
		.' Click a present underneath the tree
		.' Open one of the presents underneath the Winter Veil tree once they are available. |achieve 1689
	step
		'Congratulations, you are now a Merry Maker!
]])

-- Lunar Festival --
ZygorGuidesViewer:RegisterInclude("Lunar Festival Main Quest",[[
	step
		goto Ironforge,30.9,61.6
		.talk Lunar Festival Emissary##15892
		..accept The Lunar Festival##8870
	step
		goto 28.8,16.2
		.talk Lunar Festival Harbinger##15895
		..turnin The Lunar Festival##8870
		..accept Lunar Fireworks##8867
	step
		goto 29.9,14.2
		.talk Lunar Festival Vendor##15898
		..buy 8 Small Blue Rocket##21558+
		..buy 2 Blue Rocket Cluster##21571+
	step
		goto 30.6,17.8
		.' Use Small Blue Rockets |use Small Blue Rocket##21558
		.' Use Blue Rocket Clusters |use Blue Rocket Cluster##21571
		.' Fire 8 Lunar Fireworks |q 8867/1
		.' Fire 2 Lunar Fireworks Clusters |q 8867/2
	step
		goto 28.8,16.2
		.talk Lunar Festival Harbinger##15895
		..turnin Lunar Fireworks##8867
		..accept Valadar Starsong##8883
	step
		goto 30.6,17.8
		.' Use the Lunar Festival Invitation while standing in the beam of light |use Lunar Festival Invitation##21711
		.' Go to the Moonglade |goto Moonglade |noway|c
	step
		goto Moonglade,53.6,35.3
		.talk Valadar Starsong##15864
		..turnin Valadar Starsong##8883
]])
ZygorGuidesViewer:RegisterInclude("Lunar Festival Elder Path",[[
// EASTERN KINGDOMS
	step
		goto Silverpine Forest,45.0,41.1
		.talk Elder Obsidian##15561
		..accept Obsidian the Elder##8645 |instant
	step
		goto Tirisfal Glades,61.9,53.9
		.talk Elder Graveborn##15568
		..accept Graveborn the Elder##8652 |instant
	step
		goto Undercity,66.6,38.2
		.talk Elder Darkcore##15564
		..accept Darkcore the Elder##8648 |instant |tip If you die trying to leave Undercity, just resurrect at the spirit healer you get sent to.
	step
		goto Western Plaguelands,69.0,73.0
		.talk Elder Moonstrike##15594
		..accept Moonstrike the Elder##8714 |instant
	step
		goto 63.5,36.1
		.talk Elder Meadowrun##15602
		..accept Meadowrun the Elder##8722 |instant |tip She is inside of the cave.
	step
		goto Eastern Plaguelands,35.6,68.8
		.talk Elder Windrun##15592
		..accept Windrun the Elder##8688 |instant
	step
		goto 75.7,54.6
		.talk Elder Snowcrown##15566
		..accept Snowcrown the Elder##8650 |instant
	step
		goto 27.7,11.7|n
		.' Enter the swirling portal to Stratholme. |goto Stratholme |noway|c
	step
		map Stratholme
		path follow loose;loop off;ants straight
		path	66.2,76.8	67.3,58.1	60.1,48.7
		path	59.9,31.9	68.3,22.9	78.7,22.1
		.' Follow the path to _Elder Farwhisper_.
		.talk Elder Farwhisper##15607
		..accept Farwhisper the Elder##8727
	step
		goto Stratholme,68.8,88.6 |n
		.' Leave Stratholme. |goto Eastern Plaguelands|noway|c
	step
		goto The Hinterlands,50.0,48.0
		.talk Elder Highpeak##15559
		.accept Highpeak the Elder##8643 |instant
	step
		goto Twilight Highlands,50.9,70.5
		.talk Elder Firebeard##55219
		.accept Firebeard the Elder##29737 |instant
	step
		goto 51.9,33.1
		.talk Elder Darkfeather##55218
		.accept Darkfeather the Elder##29736 |instant
	step
		goto Loch Modan,33.3,46.5
		.talk Elder Silvervein##15558
		..accept Silvervein the Elder##8642 |instant
	step
		goto Ironforge,28.1,17.0
		.talk Elder Bronzebeard##15871
		..accept Bronzebeard the Elder##8866 |instant
	step
		goto Dun Morogh,53.9,49.9
		.talk Elder Goldwell##15569
		..accept Goldwell the Elder##8653 |instant
	step
		goto Searing Gorge,21.3,79.1
		.talk Elder Ironband##15567
		..accept Ironband the Elder##8651 |instant
	step
		  goto Burning Steppes/14 65.9,41.9 |n
		  .' Enter the swirling portal to Blackrock Spire. |goto Blackrock Spire |noway|c
	step
		goto Blackrock Spire/3 61.8,40.0
		.talk Elder Stonefort##15560
		..accept Stonefort the Elder##8644
	step
		.' Enter the Blackrock Depths here. |goto Searing Gorge/16 39.0,18.2 |c
	step
		goto Blackrock Depths 50.5,62.9
		.' Follow the path to _Elder Morndeep_.
		.talk Elder Morndeep##15549
		..accept Morndeep the Elder##8619
	step
		goto Blackrock Depths,34.5,77.8 |n
		.' Leave Blackrock Depths. |goto Searing Gorge|noway|c
	step
		goto Burning Steppes/0 52.4,23.9
		.talk Elder Dawnstrider##15585
		..accept Dawnstrider the Elder##8683 |instant
	step
		goto 70.1,45.4
		.talk Elder Rumblerock##15557
		..accept Rumblerock the Elder##8636 |instant
	step
		goto Elwynn Forest,39.8,63.7
		.talk Elder Stormbrow##15565
		..accept Stormbrow the Elder##8649 |instant
	step
		goto 34.5,50.3
		.talk Elder Hammershout##15562
		..accept Hammershout the Elder##8646 |instant
	step
		goto Stormwind City,60.4,75.3
		.talk Innkeeper Allison##6740
		.home Trade District
	step
		goto Shimmering Expanse,57.3,86.2
		.talk Elder Moonlance##55228
		.accept Moonlance the Elder##29738 |instant
	step
		goto Westfall,56.6,47.1
		.talk Elder Skychaser##15577
		..accept Skychaser the Elder##8675 |instant |tip She is at the top of the tower.
	step
		goto Blasted Lands,54.3,49.5
		.talk Elder Bellowrage##15563
		..accept Bellowrage the Elder##8647 |instant
	step
		goto Swamp of Sorrows,69.7,54.1
		.' Follow the steps down and go to the swirling portal at [76.1,45.2]
		.' Enter the Swirling Portal to The Temple of Atal'Hakkar|goto The Temple of Atal'Hakkar|noway|c
	step
		goto The Temple of Atal'Hakkar,62.9,34.4
		.talk Elder Starsong##15593
		..accept Starsong the Elder##8713
	step
		goto 50.0,14.5
		.' Leave the instance. |goto Swamp of Sorrows|noway|c
	step
		goto Northern Stranglethorn,71.0,34.3
		.talk Elder Starglade##15596
		..accept Starglade the Elder##8716 |instant
	step
		goto The Cape of Stranglethorn,40.0,72.5
		.talk Elder Winterhoof##15576
		..accept Winterhoof the Elder##8674 |instant
// KALIMDOR
	step
		goto Northern Barrens,68.4,70.0
		.talk Elder Windtotem##15582
		..accept Windtotem the Elder##8680 |instant
	step
		goto 48.5,59.3
		.talk Elder Moonwarden##15597
		..accept Moonwarden the Elder##8717 |instant
	step
		goto Southern Barrens,41.5,47.5
		.talk Elder High Mountain##15588
		..accept High Mountain the Elder##8686 |instant
	step
		goto Mulgore,48.5,53.2
		.talk Elder Bloodhoof##15575
		..accept Bloodhoof the Elder##8673 |instant
	step
		goto Thunder Bluff,73.0,23.3
		.talk Elder Ezra Wheathoof##15580
		..accept Wheathoof the Elder##8678 |instant |tip If you die trying to leave Thunder Bluff, just resurrect at the spirit healer you get sent to.
	step
		goto Desolace,29.1,62.5 |n
		.' Enter the doorway to Maraudon. |goto Desolace,29.1,62.5 |noway|c
	step
		goto Maraudon/2 51.5,93.8
		.talk Elder Splitrock##15556
		..accept Splitrock the Elder##8635
	step
		.' Leave Maruadon. |goto Desolace|noway|c
	step
		goto Feralas/0 62.6,31.1
		.talk Elder Mistwalker##15587
		..accept Mistwalker the Elder##8685 |instant
	step
		goto Feralas,76.7,37.9
		.talk Elder Grimtotem##15581
		..accept Grimtotem the Elder##8679 |instant
	step
		goto Silithus,53.0,35.5
		.talk Elder Bladesing##15599
		..accept Bladesing the Elder##8719 |instant
	step
		goto 30.8,13.3
		.talk Elder Primestone##15570
		..accept Primestone the Elder##8654 |instant
	step
		goto Uldum,31.6,63.0
		.talk Elder Sekhemi##55210
		..accept Sekhemi the Elder##29741 |instant
	step
		goto 65.5,18.7
		.talk Elder Menkhaf##55211
		..accept Menkhaf the Elder##29742 |instant
	step
		goto Un'Goro Crater,50.4,76.2
		.talk Elder Thunderhorn##15583
		..accept Thunderhorn the Elder##8681 |instant
	step
		goto Tanaris,37.2,79.1
		.talk Elder Ragetotem##15573
		..accept Ragetotem the Elder##8671 |instant
	step
		goto 51.4,28.8
		.talk Elder Dreamseer##15586
		..accept Dreamseer the Elder##8684 |instant
	step
		goto 39.2,21.3 |n
		.' Enter Zul'Farrak. |goto Zul'Farrak |noway|c
	step
		goto Zul'Farrak,34.5,39.4
		.talk Elder Wildmane##15578
		..accept Wildmane the Elder##8676
	step
		goto 56.6,91.2 |n
		.' Leave Zul'Farrak. |goto Tanaris |noway|c
	step
		goto Thousand Needles,77.1,75.6
		.talk Elder Morningdew##15604
		..accept Morningdew the Elder##8724 |instant
	step
		goto 46.3,51.0
		.talk Elder Skyseer##15584
		..accept Skyseer the Elder##8682 |instant
	step
		goto Durotar,53.2,43.6
		.talk Elder Runetotem##15572
		..accept Runetotem the Elder##8670 |instant
	step
		goto Orgrimmar,52.3,60.0
		.talk Elder Darkhorn##15579
		..accept Darkhorn the Elder##8677 |instant |tip If you die trying to leave Orgrimmar, just resurrect at the spirit healer you get sent to.
	step
		goto Azshara,64.7,79.3
		.talk Elder Skygleam##15600
		..accept Skygleam the Elder##8720 |instant
	step
		goto Winterspring,60.0,49.9
		.talk Elder Stonespire##15574
		..accept Stonespire the Elder##8672 |instant
	step
		goto 53.2,56.6
		.talk Elder Brightspear##15606
		..accept Brightspear the Elder##8726 |instant
	step
		goto Mount Hyjal 62.5,22.8
		.talk Elder Evershade##55227
		..accept Evershade the Elder##29740
	step
		goto Mount Hyjal 26.7,62.0
		.talk Elder Windsong##55224
		..accept Windsong the Elder##29739
	step
		goto Ashenvale,35.4,48.9
		.talk Elder Riversong##15605
		..accept Riversong the Elder##8725 |instant
	step
		goto Felwood,38.4,52.9
		.talk Elder Nightwind##15603
		..accept Nightwind the Elder##8723 |instant
	step
		goto Darkshore,49.5,18.9
		.talk Elder Starweave##15601
		..accept Starweave the Elder##8721 |instant
	step
		goto Teldrassil,56.9,53.1
		.talk Elder Bladeleaf##15595
		..accept Bladeleaf the Elder##8715 |instant
	step
		goto Darnassus,38.8,32.3
		.talk Elder Bladeswift##15598
		..accept Bladeswift the Elder##8718 |instant
	step
		goto Deepholm,49.7,54.9
		.talk Elder Stonebrand##55217
		..accept Stonebrand the Elder##29735
	step
		goto Deepholm 27.7,69.2
		.talk Elder Deepforge##55216
		..accept Deepforge the Elder##29734
// NORTHREND
	step
		goto Borean Tundra,59.1,65.6
		.talk Elder Sardis##30348
		..accept Sardis the Elder##13012 |instant
	step
		goto 57.4,43.7
		.talk Elder Arp##30364
		..accept Arp the Elder##13033 |instant
	step
		goto 42.9,49.6
		.talk Elder Pamuya##30371
		..accept Pamuya the Elder##13029 |instant
	step
		goto Borean Tundra 33.8,34.4
		.talk Elder Northal##30360
		..accept Northal the Elder##13016 |instant
	step
		goto The Nexus/1 55.5,64.9
		.talk Elder Igasho##30536
		..accept Igasho the Elder##13021
	step
		goto Sholazar Basin,49.8,63.6
		.talk Elder Sandrene##30362
		..accept Sandrene the Elder##13018 |instant
	step
		goto 63.8,49.0
		.talk Elder Wanikaya##30365
		..accept Wanikaya the Elder##13024 |instant
	step
		goto Wintergrasp,49.0,13.9
		.' Click the Defender's Portal
		.' Go to the upper level of the Wintergrasp Fortress |goto Wintergrasp,50.4,15.9,0.1 |noway |c
	step
		goto 49.0,13.9
		.talk Elder Bluewolf##30368
		..accept Bluewolf the Elder##13026 |instant
	step
		goto Dragonblight 26.0,50.9 |n
		.' Enter Azjol-Nerub here |goto Azjol-Nerub/3 |noway |c
	step
		goto Azjol-Nerub/3 72.6,30.9
		.' Follow this path down |goto Azjol-Nerub/2 |noway |c
	step
		goto Azjol-Nerub/2 51.1,61.8
		.' Jump down this hole into the water below |goto Azjol-Nerub |noway |c
	step
		goto 21.8,43.6
		.talk Elder Nurgen##30533
		..accept Nurgen the Elder##13022
	step
		goto Dragonblight,29.7,55.9
		.talk Elder Morthie##30358
		..accept Morthie the Elder##13014 |instant
	step
		goto 35.1,48.3
		.talk Elder Skywarden##30373
		..accept Skywarden the Elder##13031 |instant
	step
		goto 48.8,78.2
		.talk Elder Thoim##30363
		..accept Thoim the Elder##13019 |instant
	step
		goto The Storm Peaks,41.2,84.7
		.talk Elder Graymane##30370
		..accept Graymane the Elder##13028 |instant
	step
		goto 28.9,73.7
		.talk Elder Fargal##30359
		..accept Fargal the Elder##13015 |instant
	step
		goto 31.3,37.6
		.talk Elder Stonebeard##30375
		..accept Stonebeard the Elder##13020 |instant
	step
		goto Halls of Stone,29.4,62.1
		.talk Elder Yurauk##30535
		..accept Yurauk the Elder##13066 |instant
	step
		goto The Storm Peaks,64.6,51.3
		.talk Elder Muraco##30374
		..accept Muraco the Elder##13032 |instant
	step
		map Gundrak
		path loop off
		path	59.1,49.2	58.2,68.5	50.9,73.6
		path	45.6,61.5
		.talk Elder Ohanzee##30537
		..accept Ohanzee the Elder##13065
	step
		map Gundrak
		path loop off
		path	45.6,61.5	50.9,73.6	58.2,68.5
		path	59.1,49.2
		.' Follow the path, going up the ramps and out of the instance. |goto Zul'Drak |noway|c
	step
		goto Zul'Drak,58.9,56.0
		.talk Elder Tauros##30369
		..accept Tauros the Elder##13027 |instant
	step
		goto Zul'Drak,28.5,86.9 |n
		.' Enter the swirling portal to Drak'Tharon Keep. |goto Drak'Tharon Keep |noway|c
	step
		goto Drak'Tharon Keep 68.9,79.1
		.talk Elder Kilias##30534
		..accept Kilias the Elder##13023 |instant
	step
		goto Grizzly Hills,60.6,27.7
		.talk Elder Beldak##30357
		..accept Beldak the Elder##13013 |instant
	step
		goto 80.5,37.1
		.talk Elder Lunaro##30367
		..accept Lunaro the Elder##13025 |instant
	step
		goto Grizzly Hills,64.2,47.0
		.talk Elder Whurain##30372
		..accept Whurain the Elder##13030 |instant
	step
		goto Howling Fjord 58.0,50.0 |n
		.' Enter the Utgarde Keep building here |goto Howling Fjord,58.0,50.0,0.5 |noway |c
	step
		goto Utgarde Keep/1 47.5,70.0
		.talk Elder Jarten##30531
		..accept Jarten the Elder##13017 |instant
	step
		goto Howling Fjord,57.3,46.7 |n
		.' Enter the swirling portal to Utgarde Pinnacle. |goto Utgarde Pinnacle/2 |noway|c
	step
		map Utgarde Pinnacle/2
		path loop off
		path 44.5,17.0		44.2,29.8	 38.5,35.9
		path 33.7,49.0		33.5,64.4	 35.5,69.1
		path 39.1,75.8
		.' Take the stairs down. |goto Utgarde Pinnacle |noway|c
	step
		map Utgarde Pinnacle
		path loop off
		path 35.9,77.9		36.2,86.9	 41.7,86.2
		path 46.1,81.9
		.' Go up the stairs. |goto Utgarde Pinnacle/2 |noway|c
	step
		map Utgarde Pinnacle/2
		path loop off
		path 54.0,77.0		51.8,76.2	51.8,81.4
		path 56.8,84.4		60.6,84.3	63.7,69.7
		path 68.3,68.4		 68.8,56.4	68.9,36.1
		.' Follow the path, clicking here to continue. |confirm
	step
		goto Utgarde Pinnacle,48.7,23.1
		.talk Elder Chogan'gada##30538
		..accept Chogan'gada the Elder##13067
]])
ZygorGuidesViewer:RegisterInclude("Lunar Festival Achievement",[[
	step
		goto Ironforge 29.9,14.2
		.talk Lunar Festival Vendor##15898
		.buy 10 Festival Firecracker##21747
		.buy 10 Red Rocket Cluster##21576
	step
		goto 30.7,18.8
		.' Use the _Festival Firecrackers_ as fast as you can.
		.' You will need to use 10 in 30 seconds.
		.' You can drag the Festival Firecrackers onto your action bar.  You will need to click the ground where you want to throw them.
		.use Festival Firecracker##21747
		.' Earn the _Frienzied Firecracker_ Achievement. |achieve 1552
	step
		goto 30.6,18.9
		.' Drag the _Red Rocket Clusters_ to you action bar.
		.' You will need to spam whatever button the Red Rocket Cluster is assigned to.
		.use Red Rocket Cluster##21576
		.' Earn _The Rockets Red Glare_ Achievement. |achieve 1281
	step
		goto 30.6,17.8
		.' Use the Lunar Festival Invitation while standing in the beam of light |use Lunar Festival Invitation##21711
		.' Go to the Moonglade |goto Moonglade |noway|c
	step
		goto Moonglade,53.6,35.3
		.talk Valadar Starsong##15864
		.buy Festive Green Dress##21157 |or
		.buy Festive Pink Dress##21538 |or
		.buy Festive Purple Dress##21539 |or
		.buy Festive Black Pant Suit##21541 |or
		.buy Festive Blue Pant Suit##21544 |or
		.buy Festive Teal Pant Suit##21543 |or
		.' Earn the _Lunar Festival Finery_ Achievement. |achieve 626
	step
		goto 53.6,35.3
		.talk Valadar Starsong##15864
		..accept Elune's Blessing##8868
	step
		goto 63.7,62.4
		.' Use your Green Rocket Clusters until Omen spawns |use Green Rocket Cluster##21574
		.from Omen##15467 |tip You will need a group of 4 or 5 to beat him.
		.' Receive Elune's Blessing|q 8868/1
	step
		goto Moonglade 53.6,35.3
		.talk Valadar Starsong##15864
		..turnin Elune's Blessing##8868
]])

-- Love is in the Air --
ZygorGuidesViewer:RegisterInclude("Love is in the Air Main Quest",[[
		goto Stormwind City,61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..accept Something Stinks##24655
	step
		goto 62.4,76.9
		.' Find Stormwind Guards that have the Heavily Perfumed buff on them|tip They are all over Stormwind and will have a glowing pink aura around them
		.' Use Snagglebolt's Air Analyzer on Stormwind Guards|use Snagglebolt's Air Analyzer##50131
		.' Analyze 6 Perfumed Guards|q 24655/1
	step
		goto Stormwind City,61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Something Stinks##24655
		..accept Pilfering Perfume##24656
	step
		' While disguised as a package-runner, RUN to the Crown Chemical Company's stockpile outside the gates of Stormwind|goto Elwynn Forest,34.0,47.4,0.3
		.' Get the Crown Chemical Co. Package |havebuff INV_Crate_03 |q 24656
	step
		' Quickly return the package they toss you to Inspector Snip Snagglebolt in Stormwind.|goto Stormwind City,61.6,75.3,0.3
		' Deliver the package in time |condition ZGV.questsbyid[24656] and ZGV.questsbyid[24656].complete |q 24656
		.' If you lose your disguise, ask the Inspector for another one and repeat the run.
	step
		goto Stormwind City,61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Pilfering Perfume##24656
		..accept Fireworks At The Gilded Rose##24848
	step
		goto Stormwind City,60.6,76.4
		.talk Marion Sutton##38325
		..turnin Fireworks At The Gilded Rose##24848
		..accept Hot On The Trail##24849
	step
		goto Stormwind City,63.2,79.1
		.' Search the Stormwind Counting House|q 24849/1
	step
		goto Stormwind City,61.2,70.9
		.' Search the Stormwind Auction House|q 24849/2
	step
		goto Stormwind City,61.3,65.0
		.' Search the Stormwind Barber Shop|q 24849/3
	step
		goto Stormwind City,60.6,76.4
		.talk Marion Sutton##38325
		..turnin Hot On The Trail##24849
		..accept A Friendly Chat...##24657
	step
		goto Stormwind City,27.43,34.8
		.talk Snivel Rustrocket##37715
		.' Talk to him until he gives you Snivel's Ledger
		..collect Snivel's Ledger##49915|q 24657/1
	step
		goto Stormwind City,61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin A Friendly Chat...##24657
]])
ZygorGuidesViewer:RegisterInclude("Love is in the Air Dailies",[[
		goto Ironforge,33.5,65.6
		.talk Kwee Q. Peddlefeet##16075
		..accept A Gift for the Lord of Ironforge##24609
	step
		goto Stormwind City,61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..' You have to be at least level 5 to accept a quest from him
		..accept Crushing the Crown##24658 |only if level >= 5 and level < 14
		..accept Crushing the Crown##24659 |only if level >= 14 and level < 23
		..accept Crushing the Crown##24660 |only if level >= 23 and level < 32
		..accept Crushing the Crown##24662 |only if level >= 32 and level < 41
		..accept Crushing the Crown##24663 |only if level >= 41 and level < 51
		..accept Crushing the Crown##24664 |only if level >= 51 and level < 61
		..accept Crushing the Crown##24665 |only if level >= 61 and level < 71
		..accept Crushing the Crown##24666 |only if level >= 71 and level < 81
		..accept Crushing the Crown##28934 |only if level >= 81
	step
		goto 62.4,75.4
		.talk Public Relations Agent##37675
		..accept A Perfect Puff of Perfume##24629 |or
		..accept A Cloudlet of Classy Cologne##24635 |or
		..accept Bonbon Blitz##24636 |or
	step
		goto Stormwind City,62.5,75.0
		.talk Kwee Q. Peddlefeet##16075
		..accept A Gift for the King of Stormwind##24597
	step
		'Run around Stormwind and:
		.' Use your Crown Cologne Sprayer on NPCs and other players without a red heart over their head |use Crown Cologne Sprayer##49669
		.' Give 10 Cologne Samples |q 24635/1
		|only if havequest(24635)
	step
		'Run around Stormwind and:
		.' Use your Crown Perfume Sprayer on NPCs and other players without a red heart over their head |use Crown Perfume Sprayer##49668
		.' Give 10 Perfume Samples |q 24629/1
		|only if havequest(24629)
	step
		'Run around Stormwind and:
		.' Use your Crown Chocolate Sampler on NPCs and other players without a red heart over their head |use Crown Chocolate Sampler##49670
		.' Give 10 Chocolate Samples |q 24636/1
		|only if havequest(24636)
	step
		goto Elwynn Forest,29.3,65.4
		.kill 5 Crown Lackey |q 24658/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24658/1
		only if level >= 5 and level < 14
		|only if havequest(24658)
	step
		'This step depends on your character's level and what you want to do.
		.' If you don't have alot of money, or don't want to spend any more, do this: |tip Go to a place where the mobs are at least green to you, they cannot be grey to you, or they won't drop the items you need.  Now, just kill the mobs until you collect 40 Lovely Charms.  You won't get a Lovely Charm from every mob you kill, so be prepared to grind for a while.
		..collect 40 Lovely Charm##49655 |n
		.' If you have a lot of money, or don't care about spending money and just want to do the quests very quickly, do this: |tip Go to the Auction House and buy 4 Lovely Charm Bracelets.
		.' If you chose to kill mobs, use your Lovely Charms to create 4 Lovely Charm Bracelets |use Lovely Charm##49655
		.collect 4 Lovely Charm Bracelet##49916
	step
		goto Stormwind City,61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Crushing the Crown##24658
		only if level >= 5 and level < 14
	step
		goto 62.4,75.4
		.talk Public Relations Agent##37675
		..turnin A Perfect Puff of Perfume##24629
		..turnin A Cloudlet of Classy Cologne##24635
		..turnin Bonbon Blitz##24636
	step
		goto 85.8,31.7
		.talk King Varian Wrynn##29611
		..turnin A Gift for the King of Stormwind##24597
	step
		goto Darnassus,45.4,57.8
		.talk Kwee Q. Peddlefeet##16075
		..accept A Gift for the High Priestess of Elune##24610
	step
		goto Darnassus 43.0,78.0
		.talk Tyrande Whisperwind##7999
		..turnin A Gift for the High Priestess of Elune##24610
	step
		goto The Exodar,73.6,57.0
		.talk Kwee Q. Peddlefeet##16075
		..accept A Gift for the Prophet##24611
	step
		goto 32.8,54.5
		.talk Prophet Velen##17468
		..turnin A Gift for the Prophet##24611
	step
		goto Ironforge,40.0,55.1
		.talk King Magni Bronzebeard##2784
		..turnin A Gift for the Lord of Ironforge##24609
	step
		goto Stormwind City,80,38.4
		.talk King Varian Wrynn##29611
		..turnin A Gift for the King of Stormwind##24597
	step
		goto 61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Crushing the Crown##24659
		only if level >= 14 and level < 23
	step
		goto Hillsbrad Foothills 34.5,58.4
		.kill 5 Crown Duster |q 24660/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24660/1
		only if level >= 23 and level < 32
		|only if havequest(24660)
	step
		goto Dustwallow Marsh 60.8,38.2
		.kill 5 Crown Hoodlum |q 24662/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24662/1
		only if level >= 32 and level < 41
		|only if havequest(24662)
	step
		goto The Hinterlands 23.6,53.7
		.kill 5 Crown Agent |q 24663/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24663/1
		only if level >= 41 and level < 51
		|only if havequest(24663)
	step
		goto Stormwind City 61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Crushing the Crown##24660 |only if level >= 23 and level < 32
		..turnin Crushing the Crown##24662 |only if level >= 32 and level < 41
		..turnin Crushing the Crown##24663 |only if level >= 41 and level < 51
		only if level >= 23 and level < 51
	step
		goto Winterspring 63.6,49.4
		.kill 5 Crown Sprinkler |q 24664/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24664/1
		only if level >= 51 and level < 61
		|only if havequest(24664)
	step
		goto Stormwind City 61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Crushing the Crown##24664
		only if level >= 51 and level < 61
	step
		goto Terokkar Forest 41.4,22.5
		.kill 5 Crown Underling |q 24665/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24665/1
		only if level >= 61 and level < 71
		|only if havequest(24665)
	step
		goto Stormwind City 61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Crushing the Crown##24665
		only if level >= 61 and level < 71
	step
		goto Crystalsong Forest,49.0,47.8
		.kill 5 Crown Sprayer |q 24666/2
		.' Use Snagglebolt's Khorium Bomb next to the big shaking Chemical Wagon |use Snagglebolt's Khorium Bomb##50130
		.' Destroy the Chemical Wagon |q 24666/1
		only if level >= 71 and level <=81
		|only if havequest(24666)
	step
		goto Stormwind City 61.6,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Crushing the Crown##24666
		only if level >= 71 and level <=81
	step
		goto Uldum 67.9,19.8
		.kill 5 Crown Technician##51613+ |q 28934/2
		.' Use Snagglebolt's Khorium Bomb near the Chemical Wagon. |use Snagglebolt's Khorium Bomb##50130
		.' Chemical Wagon Destroyed |q 28934/1
		only if level >=81
		|only if havequest(28934)
	step
		goto Stormwind City 61.5,75.3
		.talk Inspector Snip Snagglebolt##38066
		..turnin Crushing the Crown##28934
		only if level >= 81
]])
ZygorGuidesViewer:RegisterInclude("Love is in the Air Achievement",[[
		'You will need Love Tokens in order to purchase items from vendors in this guide section.
		.' You can get Love Tokens by completing the dailies in the Love is in the Air Dailies section.
		.' Click here to be taken directly to the Love is in the Air Dailies section. |confirm |next "dailies"
		.' Click here to continue to the vendors. |next "vendors" |confirm
	step
	label "dailies"
		#include Love is in the Air Dailies
	step
	label "vendors"
		goto Stormwind City,62.5,75.3
		.talk Lovely Merchant##37674
		.buy Bag of Heart Candies##21813 |n
		.' Get the 8 different types of Heart Candy:
		.' Be Mine! |collect 1 Heart Candy##21816
		.' I'll follow you all around Azeroth. |collect 1 Heart Candy##21818
		.' All yours. |collect 1 Heart Candy##21819
		.' I'm all yours! |collect 1 Heart Candy##21821
		.' Hot Lips. |collect 1 Heart Candy##21823
		.' You're Mine! |collect 1 Heart Candy##21822
		.' You're the best! |collect 1 Heart Candy##21820
		.' I LOVE YOU |collect 1 Heart Candy##21817
	step
		'Eat the 8 different type of Heart Candy:
		.' Be Mine! |achieve 1701/1 |use 1 Heart Candy##21816
		.' I'll follow you all around Azeroth. |achieve 1701/2 |use 1 Heart Candy##21818
		.' All yours. |achieve 1701/3 |use 1 Heart Candy##21819
		.' I'm all yours! |achieve 1701/4 |use 1 Heart Candy##21821
		.' Hot Lips. |achieve 1701/5 |use 1 Heart Candy##21823
		.' You're Mine! |achieve 1701/6 |use 1 Heart Candy##21822
		.' You're the best! |achieve 1701/7 |use 1 Heart Candy##21820
		.' I LOVE YOU |achieve 1701/8 |use 1 Heart Candy##21817
	step
		goto 62.5,75.2
		.talk Lovely Merchant##37674
		.buy 10 Silver Shafted Arrow##22200 |n
		.' Use your Silver Shafted Arrows on 10 players inside Ironforge |use Silver Shafted Arrow##22200
		.' Shoot 10 Players with the Silver Shafted Arrow |achieve 1188
	step
		goto 62.5,75.2
		.talk Lovely Merchant##37674
		.buy 1 Box of Chocolates##49909 |n
		.' Use your Box of Chocolates and get all the chocolate contained inside of it |use Box of Chocolates##49909
		.' Eat each type of chocolate:
		.' Sweet Surprise |achieve 1702/3 |use Sweet Surprise##22239
		.' Very Berry Cream |achieve 1702/4 |use Very Berry Cream##22238
		.' Buttermilk Delight |achieve 1702/1 |use Buttermilk Delight##22236  |tip Save the remaining Buttermilk Delights for a later achievement.
		.' Dark Desire |achieve 1702/2 |use Dark Desire##22237
	step
		goto 62.5,75.2
		.talk Lovely Merchant##37674
		.buy 10 Love Rocket##34258 |n
		.' Spam use your Love Rockets |use Love Rocket##34258
		.' Shoot off 10 Love Rockets in 20 seconds or less |achieve 1696
	step
		goto 62.5,75.2
		.talk Lovely Merchant##37674
		.buy 15 Handful of Rose Petals##22218 |achieve 1699
		.buy 1 Romantic Picnic Basket##34480 |achieve 1291
		.buy 1 "VICTORY" Perfume##49856 |achieve 1279
		.buy 5 Love Fool##22261 |achieve 1704
	step
		goto 75.4,53.5
		.talk Elly Langston##1328
		.buy 6 Flagon of Mead##2594 |achieve 1279
	step
		'I would suggest looking for horde while doing dailies.
		.' Dalaran might still be a good spot to search.
		.' Alternatively, you can search for horde in battlegrounds.
		.' Use your Handful of Rose Petals on the follow race/class combinations: |use Handful of Rose Petals##22218 |tip Save any extra Handfuls of Rose Petals you have, you'll need one later.
		.' Gnome Warlock |achieve 1699/1
		.' Orc Death Knight |achieve 1699/2
		.' Human Death Knight |achieve 1699/3
		.' Night Elf Priest |achieve 1699/4
		.' Orc Shaman |achieve 1699/5
		.' Tauren Druid |achieve 1699/6
		.' Undead Warrior |achieve 1699/7
		.' Troll Rogue |achieve 1699/8
		.' Blood Elf Mage |achieve 1699/9
		.' Draenei Paladin |achieve 1699/10
		.' Dwarf Hunter |achieve 1699/11
	step
		'In Dalaran:
		.' Find a player to have a picnic with you
		.' Use your Romantic Picnic Basket |use Romantic Picnic Basket##34480
		.' While having a picnic, use your Buttermilk Delight |use Buttermilk Delight##22236
		.' Enjoy a Buttermilk Delight with someone in Dalaran at a Romantic Picnic |achieve 1291
	step
		'Go to Wintergrasp in Northrend:
		.' Use your Love Fool anywhere inside Wintergrasp |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/1
	step
		goto Ironforge 42.4,35.7
		.' Find Sraaz |tip He's a gnome that walks around the circle around The Great Forge.
		.' Do the following exactly in order from top to bottom in the step:
		.' Use all 6 of your Flagons of Mead to get Completely Smashed |use Flagon of Mead##2594
		.' Use your "VICTORY" Perfume |use "VICTORY" Perfume##49856
		.' Use your Handful of Rose Petals on Sraaz |use Handful of Rose Petals##22218 |achieve 1279/1
		.' Kiss Sraaz |script DoEmote("KISS") |achieve 1279/2
	step
		'Go to the Gurubashi Arena in The Cape of Stranglethorn: |tip The Cape of Stranglethorn is the southern-most zone on the Eastern Kingdoms continent.
		.' Use your Love Fool anywhere inside the Gurubashi Arena |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/2
	step
		'Enter the Arathi Basin PvP Battleground:
		.' Use your Love Fool inside the Blacksmith subzone inside Arathi Basin |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/3
	step
		'Enter the Culling of Stratholme dungeon:
		.' Use your Love Fool anywhere inside the Culling of Stratholme dungeon |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/4
	step
		'Enter the Naxxramas raid:
		.' Use your Love Fool anywhere inside the Naxxramas raid |use Love Fool##22261
		.' Target the Love Fool and Pity it |script DoEmote("PITY") |achieve 1704/5
	step
		'Go to a place where the mobs are at least green to you, they cannot be grey to you, or they won't drop the items you need.
		.' Kill the mobs until you collect 120 Lovely Charms.  |tip You won't get a Lovely Charm from every mob you kill, so be prepared to grind for a while.
		.collect 120 Lovely Charm##49655 |n
		.' Use your Lovely Charms to create 12 Lovely Charm Bracelets |use Lovely Charm##49655
		.' Create 12 Lovely Charm Bracelets |achieve 260
	step
		'Kill these certain bosses in any of the following dungeons: |tip You can enter either Normal or Heroic difficulty, it doesn't matter.
		.' Drahga Shadowburner in Grim Batol
		.' Corla, Herald of Twilight in Blackrock Caverns
		.' High Priestess Azil in The Stonecore
		.' Admiral Ripsnarl in Deadmines
		.' Lord Godfrey in Shadowfang Keep
		.' Get either of these 2 items as a random drop from these bosses:
		.collect 1 Bouquet of Red Roses##22206 |n
		.collect 1 Bouquet of Ebon Roses##44731 |n
		.' Obtain a Bouquet of Red or Ebon Roses during the Love is in the Air celebration |achieve 1703
	step
		'Congratulations, you are a Fool For Love!
]])

-- Noblegarden --
ZygorGuidesViewer:RegisterInclude("Noblegarden Quests",[[
	step
		goto Darnassus,44.7,52.9
		.talk Night Elf Commoner##19173
		..accept Spring Collectors##13484
	step
		goto Teldrassil,55.6,51.4
		.talk Spring Collector##32799
		..turnin Spring Collectors##13484
		..accept The Great Egg Hunt##13480
	step
		goto 55.7,51.3
		.talk Noblegarden Vendor##32836
		..accept A Tisket, a Tasket, a Noblegarden Basket##13502
	step
		'Search around Dolanaar for Brightly Colored Eggs and click them:
		.click Brightly Colored Egg##1407+
		|tip There is at least one available at all times. If Dolanaar is too crowded with other players looking for eggs, you can also find them at Azure Watch, Goldshire, and Kharanos.
		.collect Brightly Colored Egg##45072+ |n
		.' Click Brightly Colored Eggs in your bags |use Brightly Colored Egg##45072
		.get 20 Brightly Colored Shell Fragment |q 13480/1
		.get 10 Noblegarden Chocolate |q 13502/1
	step
		goto 55.7,51.3
		.talk Noblegarden Vendor##32836
		..turnin A Tisket, a Tasket, a Noblegarden Basket##13502
	step
		goto 55.6,51.4
		.talk Spring Collector##32799
		..turnin The Great Egg Hunt##13480
]])
ZygorGuidesViewer:RegisterInclude("Noblegarden Achievements",[[
	step
		'You may be unable to complete some of the achievements if you are lower level.  So, if you find you cannot do something in this guide, simply skip it and do what you can
		|confirm
	step
		goto Teldrassil 55.5,51.0
		.click Brightly Colored Egg##1407+
		|tip There is at least one available at all times. If Dolanaar is too crowded with other players looking for eggs, you can also find them at Azure Watch, Goldshire, and Kharanos.
		.collect 100 Noblegarden Chocolate##44791+ |n
		.' Eat 100 Noblegarden Chocolates |achieve 2418 |use Noblegarden Chocolate##44791
		.' Discover a White Tuxedo Shirt by opening Brightly Colored Eggs |achieve 248/1
		.' Discover Black Tuxedo Pants by opening Brightly Colored Eggs |achieve 248/2
		.' Discover an Elegant Dress by opening Brightly Colored Eggs |achieve 249
	step
		'If you don't already have these items, collect Noblegarden Chocolates and purchase them from the Noblegarden Vendor at [55.7,51.3]:
		.collect Noblegarden Egg##44818 |achieve 2421 |tip It costs 5 Noblegarden Chocolates.
		.collect Blossoming Branch##44792 |achieve 2416 |tip It costs 10 Noblegarden Chocolates.
		.collect Spring Flowers##45073 |achieve 2422 |tip It costs 50 Noblegarden Chocolates.
		.collect Spring Robes##44800 |achieve 2436 |tip It costs 50 Noblegarden Chocolates.
		.collect Spring Rabbit's Foot##44794 |achieve 2419 |tip It costs 100 Noblegarden Chocolates.
	step
		goto Teldrassil 55.5,51.0
		.' Use your Spring Rabbit's Foot in your bags to get a Spring Rabbit companion |use Spring Rabbit's Foot##44794
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click the Companion's ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Dolanaar |tip Spring Rabbits look like small brown and white rabbits.
		.' Find your Spring Rabbit another one to love in Dolanaar |achieve 2419/2
	step
		goto Azuremyst Isle 49.1,52.0
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click the Companion's ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Azure Watch |tip Spring Rabbits look like small brown and white rabbits.
		.' Find your Spring Rabbit another one to love in Azure Watch |achieve 2419/1
	step
		goto Desolace 66.0,10.0
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in Desolace |achieve 2436/2
	step
		goto Thousand Needles 90.3,72.8
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in Thousand Needles |achieve 2436/5
	step
		goto Silithus 55.0,34.0
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in Silithus |achieve 2436/3
	step
		goto Un'Goro Crater 35.8,50.7
		.' Change into a bunny |tip You will need a friend to do this, or at least another player.  There should be plenty of players trying to do this achievement at the same time, so it should be easy to find help.  Have your friend, or other player, use their Blossoming Branch on you to turn you into a rabbit.
		.' Stand in this spot until you lay an egg
		.' Lay a Noblegarden Egg in the Golakka Hot Springs |achieve 2416
	step
		goto Tanaris 49.0,31.0
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800\
		.' Plant a flower in Tanaris |achieve 2436/4
	step
		goto Badlands 23.0,60.0
		'Equip your Spring Robes in your bags |equipped Spring Robes##44800 |use Spring Robes##44800
		.' Use your Spring Robes' ability to plant a flower |use Spring Robes##44800
		.' Plant a flower in The Badlands |achieve 2436/1
	step
		goto Dun Morogh 53.5,51.2
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click the Companion's ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Kharanos |tip Spring Rabbits look like small brown and white rabbits.
		.' Find your Spring Rabbit another one to love in Kharanos |achieve 2419/4
	step
		goto Stormwind City 71.0,72.0
		'Use your Noblegarden Egg anywhere in Stormwind City |use Noblegarden Egg##44818
		.' Hide a Brightly Colored Egg in Stormwind City |achieve 2421
	step
		goto Elwynn Forest 43.1,67.6
		.' Bring out your Spring Rabbit companion |tip Press P to bring up your Spellbook and click the Companion's ribbon, then click the Spring Rabbit icon.
		.' Find a player with a Spring Rabbit next to them around Goldshire |tip Spring Rabbits look like small brown and white rabbits.
		.' Find your Spring Rabbit another one to love in Goldshire |achieve 2419/3
	step
		goto Teldrassil 55.5,51.0
		'Equip your Black Tuxedo Pants and White Tuxedo Shirt
		.' Find another player who is wearing the Elegant Dress and perform the Kiss emote on them |script DoEmote("KISS") |tip The Elegant Dress looks like a long pink dress when worn.
		.' Kiss someone wearing an Elegant Dress while wearing a White Tuxedo Shirt and Black Tuxedo Pants |achieve 2576
	step
		'Find a female character of every race that are at least level 18 and do the following: |tip The best places to try and find them would be Dalaran, Shattrath, Stormwind, and Orgrimmar.
		.' Use your Spring Flowers on them |use Spring Flowers##45073
		.' Place bunny ears on a Blood Elf |achieve 2422/1
		.' Place bunny ears on a Tauren |achieve 2422/9
		.' Place bunny ears on a Draenei |achieve 2422/2
		.' Place bunny ears on a Human |achieve 2422/6
		.' Place bunny ears on a Troll |achieve 2422/10
		.' Place bunny ears on a Dwarf |achieve 2422/3
		.' Place bunny ears on a Night Elf |achieve 2422/7
		.' Place bunny ears on a Gnome |achieve 2422/4
		.' Place bunny ears on a Orc |achieve 2422/8
		.' Place bunny ears on a Goblin |achieve 2422/5
		.' Place bunny ears on an Undead |achieve 2422/11
		.' Place bunny ears on a Worgen |achieve 2422/12
	step
		'Congratulations, you are now a Noble Gardener!
]])

-- Children's Week --
ZygorGuidesViewer:RegisterInclude("Children's Week Stormwind",[[
		goto Stormwind City,56.3,54.0
		.talk Orphan Matron Nightingale##14450
		..accept Children's Week##1468
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.talk Human Orphan##14305
		..turnin Children's Week##1468
		..accept Cruisin' the Chasm##29093
		..accept The Biggest Diamond Ever!##29106
		..accept Malfurion Has Returned!##29107
	step
		goto Westfall,57.8,53.0
		.clicknpc Rental Chopper##52189
		.' Give Your Orphan a Chopper Tour of the Raging Chasm |q 29093/1
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.talk Human Orphan##14305
		..turnin Cruisin' the Chasm##29093
	step
		goto Ironforge 44.1,51.9 |n
		.' Enter the path to Old Ironforge here. |goto Ironforge 44.1,51.9 |noway |c
	step
		goto Ironforge 39.4,51.6 |n
		.' Follow the stairs leading up here. |goto Ironforge 39.4,51.6 |noway |c
	step
		goto Ironforge 33.2,47.8
		.' Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.' Take Your Orphan to Visit King Magni in Old Ironforge |q 29106/1
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.talk Human Orphan##14305
		..turnin The Biggest Diamond Ever!##29106
	step
		goto Darnassus,43.1,78.1
		.' Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.' Take Your Orphan to Visit Malfurion Stormrage |q 29107/1
		|tip He's on the second floor of this building. Go up the ramps inside to find him.
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.talk Human Orphan##14305
		..turnin Malfurion Has Returned!##29107
		..accept Let's Go Fly a Kite##29117
		..accept You Scream, I Scream...##29119
	step
		goto Stormwind City,58.8,64.1
		.talk Craggle Wobbletop##52358
		.buy 1 Dragon Kite 2-Pack##68890 |q 29117
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.' When your orphan is next to you:
		.' Use your Dragon Kite 2-Pack |use Dragon Kite 2-Pack##68890
		.' Fly Dragon Kites with Your Orphan |q 29117/1
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.talk Human Orphan##14305
		..turnin Let's Go Fly a Kite##29117
	step
		goto 49.0,89.7
		.talk Hans Coldhearth##52421
		.buy 1 Cone of Cold##69027 |q 29119
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.' When your orphan is next to you:
		.' Use your Cone of Cold |use Cone of Cold##69027
		.' Take Your Orphan Out for Ice Cream |q 29119/1
	step
		'Use your Human Orphan Whistle to summon your Human Orphan |use Human Orphan Whistle##18598
		.talk Human Orphan##14305
		..turnin You Scream, I Scream...##29119
		..accept A Warden of the Alliance##171
	step
		goto 58.8,64.1
		.talk Craggle Wobbletop##52358
		.buy 1 Foam Sword Rack##69057 |q 171/1
	step
		goto 56.3,54.0
		.talk Orphan Matron Nightingale##51988
		..turnin A Warden of the Alliance##171 |tip You will be able to choose from 4 pet companions or a 5 gold reward.  If you already have all 4 pets, choose the gold.  You will be able to do this quest each year, so you will be able to collect all 4 pets, eventually.
]])
ZygorGuidesViewer:RegisterInclude("Children's Week Shattrath",[[
		goto Shattrath City,74.9,47.9
		.talk Orphan Matron Mercy##22819
		..accept Children's Week##10943
	step
		'Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.talk Draenei Orphan##22818
		..turnin Children's Week##10943
		..accept Auchindoun and the Ring of Observance##10950
		..accept A Trip to the Dark Portal##10952
		..accept Jheel is at Aeris Landing!##10954
	step
		goto Nagrand,31.5,57.6
		.' Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.' Take Dornaa taken to Aeris Landing |q 10954/1
	step
		goto Nagrand,31.5,57.6
		.talk Jheel##22836
		..turnin Jheel is at Aeris Landing!##10954
	step
		goto Terokkar Forest,39.8,64.7
		.' Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.' Take Dornaa to the Ring of Observance |q 10950/1
	step
		'Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.talk Draenei Orphan##22818
		..turnin Auchindoun and the Ring of Observance##10950
	step
		goto Hellfire Peninsula,89.6,50.2
		.' Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.' Take Dornaa to the Dark Portal |q 10952/1
	step
		'Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.talk Draenei Orphan##22818
		..turnin A Trip to the Dark Portal##10952
		..accept The Seat of the Naaru##10956
		..accept Time to Visit the Caverns##10962
	step
		goto Tanaris,61.5,50.6 |n
		.' The path to Zaladormu starts here |goto Tanaris,61.5,50.6,1 |noway |c
	step
		goto Tanaris,64.9,50.0 |n
		.' Enter the Caverns of Time here |goto Tanaris,64.9,50.0,0.5 |noway |c
	step
		'Follow the path down to 59.9,57.2 |goto Tanaris,59.9,57.2 |tip You will end up underground, in the Caverns of Time, next to a big dragon named Zaladormu, who is laying on a big platform.
		.' Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.' Take Dornaa to the Caverns of Time |q 10962/1
	step
		goto 63.0,57.3
		.talk Alurmi##21643
		.buy 1 Toy Dragon##31951 |q 10962/2
	step
		'Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.talk Draenei Orphan##22818
		..turnin Time to Visit the Caverns##10962
	step
		goto The Exodar,58.0,41.4
		.' Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.' Take Dornaa to the Seat of the Naaru |q 10956/1
	step
		goto The Exodar,58.0,41.4
		.talk O'ros##17538
		..turnin The Seat of the Naaru##10956
		..accept Call on the Farseer##10968
	step
		goto The Exodar 31.3,27.8
		.' Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.' Take Dornaa to to Farseer Nobundo |q 10968/1
	step
		goto The Exodar 31.3,27.8
		.talk Farseer Nobundo##17204
		..turnin Call on the Farseer##10968
	step
		'Use your Draenei Orphan Whistle to summon your Draenei Orphan |use Draenei Orphan Whistle##31881
		.talk Draenei Orphan##22818
		..accept Back to the Orphanage##10966
	step
		goto Shattrath City,74.9,47.9
		.talk Orphan Matron Mercy##22819
		..turnin Back to the Orphanage##10966 |tip You will be able to choose from 4 pet companions. Only Egbert's Egg, Elekk Training Collar, and Sleepy Willy count toward an achievement.
]])
ZygorGuidesViewer:RegisterInclude("Children's Week Dalaran Oracles Quests",[[
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..accept Little Orphan Roo Of The Oracles##13926
		..' Ask about the orphans
		..' Speak to Orphan Matron Aria and accept to care for the Oracle Orphan |q 13926/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin Little Orphan Roo Of The Oracles##13926
		..accept The Biggest Tree Ever!##13929
		..accept The Bronze Dragonshrine##13933
		..accept Playmates!##13950
	step
		goto Grizzly Hills,50.8,42.8
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit Grizzlemaw |q 13929/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin The Biggest Tree Ever!##13929
	step
		goto Dragonblight,72.5,36.9
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit the Bronze Dragonshrine |q 13933/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin The Bronze Dragonshrine##13933
	step
		goto Borean Tundra,43.5,13.7
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit Winterfin Retreat |q 13950/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin Playmates!##13950
		..accept The Dragon Queen##13954
		..accept Meeting a Great One##13956
	step
		goto Sholazar Basin,40.3,83.0 |n
		.' Walk into the light to teleport to Un'Goro Crater |goto Un'Goro Crater |noway |c
	step
		goto Un'Goro Crater,47.5,9.2
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit The Etymidian |q 13956/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin Meeting a Great One##13956
	step
		goto Un'Goro Crater,50.5,7.8 |n
		.' Walk into the light to teleport to Sholazar Basin |goto Sholazar Basin |noway |c
	step
		goto Dragonblight,59.8,54.7
		.' Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Take Roo to visit Alexstrasza the Life-Binder |q 13954/1 |tip Alexstrasza the Life-Binder is at the top of Wyrmrest Temple.
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin The Dragon Queen##13954
		..accept A Trip To The Wonderworks##13937
	step
		goto Dalaran,44.9,45.6
		.talk Jepetto Joybuzz##29478
		.buy 1 Small Paper Zeppelin##46693
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.' Use your Small Paper Zeppelin on your Oracle Orphan |use Small Paper Zeppelin##46693
		.' Throw the Small Paper Zeppelin to Roo |q 13937/1
	step
		'Use your Oracle Orphan Whistle to summon your Oracle Orphan |use Oracle Orphan Whistle##46397
		.talk Oracle Orphan##33533
		..turnin A Trip To The Wonderworks##13937
		..accept Back To The Orphanage##13959
	step
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..turnin Back To The Orphanage##13959 |tip You will receive a Curious Oracle Hatchling pet companion in the mail.
]])
ZygorGuidesViewer:RegisterInclude("Children's Week Dalaran Wolvar Quests",[[
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..accept Little Orphan Kekek Of The Wolvar##13927
		..' Ask about the orphans
		..' Speak to Orphan Matron Aria and accept to care for the Wolvar Orphan |q 13927/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin Little Orphan Kekek Of The Wolvar##13927
		..accept Home Of The Bear-Men##13930
		..accept The Bronze Dragonshrine##13934
		..accept Playmates!##13951
	step
		goto Grizzly Hills,50.8,42.8
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Grizzlemaw |q 13930/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin Home Of The Bear-Men##13930
	step
		goto Dragonblight,72.5,36.9
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit the Bronze Dragonshrine |q 13934/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin The Bronze Dragonshrine##13934
	step
		goto Dragonblight,45.3,63.3
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Snowfall Glade |q 13951/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin Playmates!##13951
		..accept The Dragon Queen##13955
		..accept The Mighty Hemet Nesingwary##13957
	step
		goto Dragonblight,59.8,54.7
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Alexstrasza the Life-Binder |q 13955/1 |tip Alexstrasza the Life-Binder is at the top of Wyrmrest Temple.
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin The Dragon Queen##13955
	step
		goto Sholazar Basin,27.1,58.7
		.' Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Take Kekek to visit Hemet Nesingwary |q 13957/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin The Mighty Hemet Nesingwary##13957
		..accept A Trip To The Wonderworks##13938
	step
		goto Dalaran,44.9,45.6
		.talk Jepetto Joybuzz##29478
		.buy 1 Small Paper Zeppelin##46693
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.' Use your Small Paper Zeppelin on your Wolvar Orphan |use Small Paper Zeppelin##46693
		.' Throw the Small Paper Zeppelin to Kekek |q 13938/1
	step
		'Use your Wolvar Orphan Whistle to summon your Wolvar Orphan |use Wolvar Orphan Whistle##46396
		.talk Wolvar Orphan##33532
		..turnin A Trip To The Wonderworks##13938
		..accept Back To The Orphanage##28880
	step
		goto Dalaran,49.4,63.2
		.talk Orphan Matron Aria##34365
		..turnin Back To The Orphanage##28880 |tip You will receive a Curious Wolvar Pup pet companion in the mail.
]])
ZygorGuidesViewer:RegisterInclude("Children's Week Achievements",[[
		goto Stormwind City,56.3,54.0
		.talk Orphan Matron Nightingale##14450
		..' Ask her for another Orphan Whistle
		.collect 1 Human Orphan Whistle##18598
	step
		'Complete any 5 daily quests of your choice: |tip Make sure your orphan is standing next to you when turning in the daily quests, or you won't get credit for this achievement.
		.' Get the Daily Chores Achievement |achieve 1789
	step
		goto Stormwind City,61.3,75.0
		.talk Emmithue Smails##14481
		..buy Tigule and Foror's Strawberry Ice Cream##7228 |achieve 1788
	step
		'Purchase the follow items from the Auction House, or use your Cooking ability to create them, if you'd like:
		.collect 1 Tasty Cupcake##43490 |achieve 1788
		.collect 1 Delicious Chocolate Cake##33924 |achieve 1788
	step
		goto Dalaran,51.2,29.1
		.talk Aimee##29548
		..buy 1 Red Velvet Cupcake##42429 |achieve 1788
		..buy 1 Lovely Cake##42438 |achieve 1788
		..buy 1 Dalaran Doughnut##42430 |achieve 1788
		..buy 1 Dalaran Brownie##42431 |achieve 1788
	step
		'Use your Lovely Cake in your bags to place a cake on the ground |use Lovely Cake##42438
		.' Click the Lovely Cake
		.collect 1 Lovely Cake Slice##42434 |achieve 1788
	step
		'Use whichever Orphan Whistle you currently have to summon your Orphan, so that the Orphan is standing next to you:
		.' Eat Tigule and Foror's Strawberry Ice Cream |achieve 1788/1 |use Tigule and Foror's Strawberry Ice Cream##7228
		.' Eat Tasty Cupcake |achieve 1788/2 |use Tasty Cupcake##43490
		.' Eat Red Velvet Cupcake |achieve 1788/3 |use Red Velvet Cupcake##42429
		.' Eat Delicious Chocolate Cake |achieve 1788/4 |use Delicious Chocolate Cake##33924
		.' Eat Lovely Cake Slice |achieve 1788/5 |use Lovely Cake Slice##42434
		.' Eat Dalaran Brownie |achieve 1788/6 |use Dalaran Brownie##42431
		.' Eat Dalaran Doughnut |achieve 1788/7 |use Dalaran Doughnut##42430
	step
		'Use your Hearthstone while your Orphan is standing next to you |use Hearthstone##6948
		.' Get the Home Alone Achievement |achieve 1791
	step
		'The following achievements are a little more dynamic, so we cannot walk you step-by-step through getting them.
		|confirm
	step
		'Find a group, run the Utgarde Pinnacle dungeon, and defeat King Ymiron |tip Make sure your Orphan is standing next to you when you defeat King Ymiron, or else you won't get credit for the achievement.
		.' Get the Hail To The King, Baby Achievement |achieve 1790
	step
		'Enter the Eye of the Storm battleground and capture the flag |tip Make sure your Orphan is standing next to you when you capture the flag, or else you won't get credit for the achievement.
		.' Capture the flag in Eye of the Storm |achieve 1786/1
	step
		'Enter the Alterac Valley battleground and assault a tower |tip Make sure your Orphan is standing next to you when you assault the tower, or else you won't get credit for the achievement.
		.' Assault a tower in Alterac Valley |achieve 1786/2
	step
		'Enter the Arathi Basin battleground and assault a flag |tip Make sure your Orphan is standing next to you when you assault the flag, or else you won't get credit for the achievement.
		.' Assault a flag in Arathi Basin |achieve 1786/3
	step
		'Enter the Warsong Gulch battleground and return a fallen flag |tip Make sure your Orphan is standing next to you when you return the fallen flag, or else you won't get credit for the achievement.
		.' Return a fallen flag in Warsong Gulch |achieve 1786/4
	step
		'Congratulations, you do it For The Children! |achieve 1793/1
]])

-- Midsummer Fire Festival --
ZygorGuidesViewer:RegisterInclude("Midsummer Fire Festival Quests",[[
		goto Stormwind City,60.4,75.3
		.talk Innkeeper Allison##6740
		.home Trade District
	step
		goto Stormwind City,61.7,74.2
		.talk Human Commoner##18927
		..accept The Master of Summer Lore##11970
	step
		goto 49.5,72.3
		.talk Festival Loremaster##16817
		..turnin The Master of Summer Lore##11970
		..accept Incense for the Summer Scorchlings##11964
	step
		goto 49.3,72.3
		.talk Earthen Ring Elder##26221
		..accept Unusual Activity##11886
	step
		goto Stormwind City,50.0,72.3
		.talk Master Fire Eater##25975
		..accept Torch Tossing##11731
	step
		'Use your Practice Torches in your bags and throw them at the Torch Target Braziers nearby |use Practice Torches##34862 |tip You must throw the torches at the correct braziers.  Throw the torches at the Torch Target Braziers when they have a floating red arrow point down above them. You will have 40 seconds to complete this before the quest fails.
		.' Hit 8 braziers |q 11731/1
	step
		goto Stormwind City,50.0,72.3
		.talk Master Fire Eater##25975
		..turnin Torch Tossing##11731
		..accept Torch Catching##11657
	step
		goto 49.8,72.4
		.' Use your Unlit Torches in your bags next to the bonfire |use Unlit Torches##34833
		.' As soon as you light torch, it will fly in the air.  There will be a small round shadow on the ground indicating where the torch is flying.  Follow that shadow and catch the torch.  When you catch the torch, it will be thrown in the air again.  Follow the shadow again and catch the torch.  Do this until you've caught the torch 4 times in a row without it hitting the ground.
		.' Catch 4 torches in a row. |q 11657/1
	step
		goto 50.1,72.3
		.talk Master Fire Eater##25975
		..turnin Torch Catching##11657
	step
		goto Elwynn Forest,43.5,62.5
		.talk Summer Scorchling##26401
		..turnin Incense for the Summer Scorchlings##11964
	step
		goto 43.5,62.6
		.talk Elwynn Forest Flame Warden##25898
		..accept Honor the Flame##11816 |instant
	step
		goto Elwynn Forest,43.7,62.2
		.talk Fire Eater##25962
		..accept Playing with Fire##11882
	step
		goto Stormwind City,50.0,72.3
		.talk Master Fire Eater##25975
		..turnin Playing with Fire##11882
	step
		goto Teldrassil 54.9,52.8
		.talk Teldrassil Flame Warden##25906
		..accept Honor the Flame##11824 |instant
	step
		goto Azuremyst Isle,44.5,52.5
		.talk Azuremyst Isle Flame Warden##25888
		..accept Honor the Flame##11806 |instant
	step
		goto Bloodmyst Isle,55.8,67.9
		.talk Bloodmyst Isle Flame Warden##25891
		..accept Honor the Flame##11809 |instant
	step
		goto Darkshore 48.7,22.6
		.talk Darkshore Flame Warden##25893
		..accept Honor the Flame##11811 |instant
	step
		goto Winterspring,61.2,47.3
		.talk Winterspring Flame Warden##25917
		..accept Honor the Flame##11834 |instant
	step
		goto 58.1,47.3
 		.click Horde Bonfire##7734
		..accept Descrate this Fire!##11803 |instant
	step
		goto Azshara,60.4,53.3
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28919 |instant
	step
		goto Ashenvale,15.1,18.4
		.from Twilight Firesworn##25863+
		.get Twilight Correspondence |q 11886/1
	step
		goto 15.2,21.2
		.' Use the Totemic Beacon in your bags |use Totemic Beacon##35828
		.talk Earthen Ring Guide##25324
		..turnin Unusual Activity##11886
		..accept An Innocent Disguise##11891
	step
		goto Ashenvale,15.3,20.1
		.from Twilight Firesworn##25863+, Twilight Flameguard##25866+
		.get Twilight Correspondence |q 11886/1
	step
		goto Ashenvale,15.7,20.3
		.' Use your Totemic Beacon next to the blue bonfire |use Totemic Beacon##35828
		.talk Earthen Ring Guide##25324
		..turnin Unusual Activity##11886
		..accept An Innocent Disguise##11891
	step
		goto Ashenvale,9.6,13.2
		.' Use your Orb of the Crawler in this spot |use Orb of the Crawler##35237
		.' Get the Crab Disguise |havebuff Interface\Icons\Ability_Hunter_Pet_Crab
	step
		goto Ashenvale,9.2,12.6
		.' Listen to the plan of the Twilight Cultists |q 11891/1
	step
		goto Ashenvale,9.7,13.3
		.' Use your Totemic Beacon next to the blue bonfire |use Totemic Beacon##35828
		.talk Earthen Ring Guide##25324
		..turnin An Innocent Disguise##11891
		..accept Inform the Elder##29092
	step
		goto Darnassus,62.1,49.1
		.talk Earthen Ring Elder##26221
		..turnin Inform the Elder##29092
	step
		goto Ashenvale 51.6,66.6
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11765 |instant
	step
		goto Ashenvale,86.9,41.9
		.talk Ashenvale Flame Warden##25883
		..accept Honor the Flame##11805 |instant
	step
		goto Southern Barrens,48.3,72.2
		.talk Southern Barrens Flame Warden##51586
		..accept Honor the Flame##28926
	step
		goto Southern Barrens,40.7,67.3
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28914 |instant
	step
		goto Durotar 52.1,47.1
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11770 |instant
	step
		goto Orgrimmar,46.5,37.0
		.' Click the Flame of Orgrimmar |tip It's a huge blue bonfire.
		.collect Flame of Orgrimmar##23179 |n
		.' Click the Flame of Orgrimmar in your bags |use Flame of Orgrimmar##23179
		..accept Stealing Orgrimmar's Flame##9324 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto Northern Barrens,49.9,54.4
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11783 |instant
	step
		goto Stonetalon Mountains 49.3,51.3
		.talk Stonetalon Mountains Flame Warden##51588
		..accept Honor the Flame##28928 |instant
	step
		goto Stonetalon Mountains,53.0,62.3
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11780 |instant
	step
		goto Desolace 66.1,17.1
		.talk Desolace Flame Warden##25894
		..accept Honor the Flame##11812 |instant
	step
		goto 26.1,77.2
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11769 |instant
	step
		goto Feralas,46.8,43.7
		.talk Feralas Flame Warden##25899
		..accept Honor the Flame##11817 |instant
	step
		goto 72.5,47.7
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11773 |instant
	step
		goto Silithus,60.3,33.5
		.talk Silithus Flame Warden##25914
		..accept Honor the Flame##11831 |instant
	step
		goto Silithus 50.9,41.7
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11800 |instant
	step
		goto Un'Goro Crater 60.0,63.0
		.talk Un'Goro Crater Flame Warden##51606
		.accept Honor the Flame##28932 |instant
	step
		goto Un'Goro Crater 56.3,65.8
		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28920 |instant
	step
		goto Tanaris,49.8,28.1
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11802 |instant
	step
		goto Tanaris,52.6,30.3
		.talk Tanaris Flame Warden##25916
		..accept Honor the Flame##11833 |instant
	step
		goto Dustwallow Marsh,61.8,40.5
		.talk Dustwallow Marsh Flame Warden##25897
		..accept Honor the Flame##11815 |instant
	step
		goto 33.3,30.7
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11771 |instant
	step
		goto Mulgore,52.0,59.4
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11777 |instant
	step
		goto Thunder Bluff,21.7,27.5
		.' Click the Flame of Thunder Bluff |tip It's a huge blue bonfire.
		.collect Flame of Thunder Bluff##23180 |n
		.' Click the Flame of Thunder Bluff in your bags |use Flame of Thunder Bluff##23180
		..accept Stealing Thunder Bluff's Flame##9325 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto The Cape of Stranglethorn,52.0,67.6
		.talk Stranglethorn Vale Flame Warden##25915
		..accept Honor the Flame##11832 |instant
	step
		goto 50.5,70.7
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11801 |instant
	step
		goto Northern Stranglethorn,52.0,63.5
		.talk Northern Stranglethorn Flame Warden##51574
		..accept Honor the Flame##28922
	step
		goto 40.7,51.9
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28911 |instant
	step
		goto Blasted Lands,55.5,14.9
		.talk Blasted Lands Flame Warden##25890
		..accept Honor the Flame##11808 |instant
	step
		goto Blasted Lands 46.4,14.4
		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28917 |instant
	step
		goto Swamp of Sorrows 70.3,15.7
		.talk Swamp of Sorrows Flame Warden##51602
		..accept Honor the Flame##28929
	step
		goto Swamp of Sorrows,76.7,14.0
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11781 |instant
	step
		goto Duskwood 73.7,54.6
		.talk Duskwood Flame Warden##25896
		..accept Honor the Flame##11814 |instant
	step
		goto Westfall,44.8,62.1
		.talk Westfall Flame Warden##25910
		..accept Honor the Flame##11583
	step
		goto Redridge Mountains,24.9,53.4
		.talk Redridge Flame Warden##25904
		..accept Honor the Flame##11822 |instant
	step
		goto Burning Steppes,68.3,60.6
		.talk Burning Steppes Flame Warden##25892
		..accept Honor the Flame##11810 |instant
	step
		goto 51.5,29.2
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11768 |instant
	step
		goto Badlands,19.0,56.2
		.talk Badlands Flame Warden##51585
		..accept Honor the Flame##28925
	step
		goto 24.1,37.2
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11766 |instant
	step
		goto Loch Modan,32.6,41.0
		.talk Loch Modan Flame Warden##25902
		..accept Honor the Flame##11820 |instant
	step
		goto Ironforge,63.8,25.3
		.talk Festival Loremaster##16817
		..turnin Stealing Orgrimmar's Flame##9324
		..turnin Stealing Thunder Bluff's Flame##9325
	step
		goto Dun Morogh,53.8,45.2
		.talk Dun Morogh Flame Warden##25895
		..accept Honor the Flame##11813 |instant
	step
		goto Wetlands 13.5,47.1
		.talk Wetlands Flame Warden##25911
		..accept Honor the Flame##11828 |instant
	step
		goto Arathi Highlands,44.3,46.0
		.talk Arathi Flame Warden##25887
		..accept Honor the Flame##11804 |instant
	step
		goto 69.2,43.0
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11764 |instant
	step
		goto Hillsbrad Foothills,54.6,49.8
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11776 |instant
	step
		goto Western Plaguelands,43.6,82.5
		.talk Western Plaguelands Flame Warden##25909
		..accept Honor the Flame##11827 |instant
	step
		goto Western Plaguelands 29.2,57.4
		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28918 |instant
	step
		goto The Hinterlands,14.3,50.1
		.talk The Hinterlands Flame Warden##25908
		..accept Honor the Flame##11826 |instant
	step
		goto 76.6,74.6
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11784 |instant
	step
		goto Silverpine Forest,49.6,38.7
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11580 |instant
	step
		goto Tirisfal Glades,57.0,51.8
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11786 |instant
	step
		goto Undercity,67.9,8.3
		.' Click the Flame of Undercity |tip It's a huge blue bonfire.
		.collect Flame of Undercity##23181 |n
		.' Click the Flame of Undercity in your bags |use Flame of Undercity##23181
		..accept Stealing Undercity's Flame##9326 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto Ghostlands,47,26
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11774 |instant
	step
		goto Eversong Woods,46,50
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11772 |instant
	step
		goto Silvermoon City,69.0,43.4
		.' Click the Flame of Silvermoon |tip It's a huge blue bonfire.
		.collect Flame of Silvermoon##35568 |n
		.' Click the Flame of Silvermoon in your bags |use Flame of Silvermoon##35568
		..accept Stealing Silvermoon's Flame##11935 |tip It is recommended that you be level 80 when attempting to complete this guide step.
	step
		goto Ironforge,63.8,25.3
		.talk Festival Loremaster##16817
		..turnin Stealing the Undercity's Flame##9326
		..turnin Stealing Silvermoon's Flame##11935
		..accept A Thief's Reward##9365 |instant
	step
		goto Hellfire Peninsula,62.2,58.3
		.talk Hellfire Peninsula Flame Warden##25900
		..accept Honor the Flame##11818 |instant
	step
		goto Hellfire Peninsula,57.2,41.8
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11775 |instant
	step
		goto Netherstorm,32.3,68.2
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11799 |instant
	step
		goto Netherstorm,31.2,62.7
		.talk Netherstorm Flame Warden##25913
		..accept Honor the Flame##11830 |instant
	step
		goto Blade's Edge Mountains,50.0,59.0
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11767 |instant
	step
		goto Blade's Edge Mountains,41.6,65.9
		.talk Blade's Edge Flame Warden##25889
		..accept Honor the Flame##11807 |instant
	step
		goto Zangarmarsh,35.6,51.8
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11787 |instant
	step
		goto Zangarmarsh,68.8,52.0
		.talk Zangarmarsh Flame Warden##25912
		..accept Honor the Flame##11829 |instant
	step
		goto Nagrand,51.1,34.0
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11778 |instant
	step
		goto Nagrand,49.6,69.5
		.talk Nagrand Flame Warden##25903
		..accept Honor the Flame##11821 |instant
	step
		goto Terokkar Forest,51.9,43.2
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11782 |instant
	step
		goto Terokkar Forest,54.1,55.5
		.talk Terokkar Forest Flame Warden##25907
		..accept Honor the Flame##11825 |instant
	step
		goto Shadowmoon Valley,33.5,30.3
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##11779 |instant
	step
		goto Shadowmoon Valley,39.6,54.6
		.talk Shadowmoon Valley Flame Warden##25905
		..accept Honor the Flame##11823 |instant
	step
		goto Borean Tundra,55.1,20.0
		.talk Borean Tundra Flame Warden##32801
		..accept Honor the Flame##13485 |instant
	step
		goto Borean Tundra,51.1,11.8
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13441 |instant
	step
		goto Sholazar Basin,48.1,66.4
		.talk Sholazar Basin Flame Warden##32802
		..accept Honor the Flame##13486 |instant
	step
		goto Sholazar Basin,47.3,61.5
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13450 |instant
	step
		goto Dragonblight,38.5,48.3
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13451 |instant
	step
		goto Dragonblight,75.3,43.8
		.talk Dragonblight Flame Warden##32803
		..accept Honor the Flame##13487 |instant
	step
		goto Crystalsong Forest,78.2,75.0
		.talk Crystalsong Forest Flame Warden##32807
		..accept Honor the Flame##13491 |instant
	step
		goto Crystalsong Forest,80.4,52.7
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13457 |instant
	step
		goto The Storm Peaks,40.4,85.6
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13455 |instant
	step
		goto The Storm Peaks,41.4,86.7
		.talk Storm Peaks Flame Warden##32806
		..accept Honor the Flame##13490 |instant
	step
		goto Zul'Drak,40.4,61.3
		.talk Zul'Drak Flame Warden##32808
		..accept Honor the Flame##13492 |instant
	step
		goto Zul'Drak,43.3,71.3
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13458 |instant
	step
		goto Grizzly Hills,19.1,61.5
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13454 |instant
	step
		goto Grizzly Hills,33.9,60.5
		.talk Grizzly Hills Flame Warden##32805
		..accept Honor the Flame##13489 |instant
	step
		goto Howling Fjord,48.4,13.4
 		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##13453 |instant
	step
		goto Howling Fjord,57.8,16.1
		.talk Howling Fjord Flame Warden##32804
		..accept Honor the Flame##13488 |instant
	step
		goto Mount Hyjal 62.8,22.7
		.talk Hyjal Flame Guardian##51682
		..accept Honor the Flame##29030
	step
		goto 62.9,22.9
		.click Earthen Ring Bonfire##7734
		..turnin Honor the Flame##29030
	step
		goto Deepholm 49.4,51.3
		.talk Deepholm Flame Guardian##51698
		..accept Honor the Flame##29036
	step
		goto 49.4,51.3
		.click Earthen Ring Bonfire##7734
		..turnin Honor the Flame##29036
	step
		goto Twilight Highlands 47.2,28.9
		.talk Twilight Highlands Flame Warden##51650
		..accept Honor the Flame##28945 |instant
	step
		goto 53.4,46.4
		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28944 |instant
	step
		goto Shimmering Expanse 49.4,42.0
		.talk Vashj'ir Flame Guardian##51697
		..accept Honor the Flame##29031
	step
		goto 49.3,42.0
		.click Earthen Ring Bonfire##7734
		..turnin Honor the Flame##29031
	step
		goto Uldum 53.6,31.9
		.talk Uldum Flame Warden##51653
		..accept Honor the Flame##28950 |instant
	step
		goto 52.9,34.5
		.click Horde Bonfire##7734
		..accept Desecrate this Fire!##28948 |instant
]])
ZygorGuidesViewer:RegisterInclude("Midsummer Fire Festival Achievements",[[
		'Complete the Midsummer Fire Festival Quests guide section before doing this guide section.
		|confirm
	step
		' Open up your Dungeon Finder [I], and queue for The Frost Lord Ahune battle. |tip You must be at least level 89 to fight Lord Ahune.
		.from Lord Ahune##25740
		..' Complete the Ice the Frost Lord Achievement |achieve 263
	step
		goto Stormwind City 49.0,72.0
		.talk Midsummer Supplier##26123
		.buy 15 Juggling Torch##34599
		.buy 1 Mantle of the Fire Festival##23324
		.buy 1 Vestment of Summer##34685
		.buy 1 Sandals of Summer##34683
	step
		goto 50.5,73.1
		.' Equip your Mantle of the Fire Festival |use Mantle of the Fire Festival##23324
		.' Equip your Vestment of Summer |use Vestment of Summer##34685
		.' Equip your Sandals of Summer |use Sandals of Summer##34683
		.' Click the Ribbon Pole |tip It looks like a tall metal pole with a small fire on top of it.
		.' Let your character spin around for 1 minute
		.' Complete the Burning Hot Pole Dance Achievement |achieve 271
	step
		'Don't forget to put your regular gear back on
		|confirm
	step
		goto Dalaran,36.8,44.1
		.' Use your 40 Juggling Torches as fast as you can |tip You must juggle them all in under 15 seconds.  The best way to do this is to place your Juggling Torches on your hotbar.  Press the hotbar key and click the ground at the same time.  Keep spamming the hotbar key and clicking the ground at the same time as fast as possible and don't stop until you get the achievement.
		.' Complete the Torch Juggler Achievement |achieve 272
	step
		'Use your Hearthstone to go back to Stormwind |use Hearthstone##6948
	step
		'Congratulations, you are now The Flame Warden!
]])

-- Harvest Festival --
ZygorGuidesViewer:RegisterInclude("Harvest Festival Quests",[[
		goto Dun Morogh,59.7,34.3
		.talk Wagner Hammerstrike##15011
		..accept Honoring a Hero##8149
	step
		goto Western Plaguelands,52.0,83.4
		.' Use Uther's Tribute in front of Uther's statue |use Uther's Tribute##19850
		.' Place a Tribute at Uther's Tomb |q 8149/1
	step
		goto Dun Morogh,59.7,34.3
		.talk Wagner Hammerstrike##15011
		..turnin Honoring a Hero##8149
	step
		goto Dun Morogh,59.9,34.8
		.' You can click special food items on the table.
		.' In 2 days You will also get an item called Bounty of the Harvest in the mail.
		|confirm
	step
		'Congratulations, you've completed the Harvest Festival!
]])

-- Brewfest --
ZygorGuidesViewer:RegisterInclude("Brewfest Quests",[[
		goto Ironforge,30.8,62.9
		.talk Dwarf Commoner##19148
		..accept Brewfest!##11441
	step
		goto Dun Morogh,55.1,38.1
		.talk Ipfelkofer Ironkeg##24710
		..turnin Brewfest!##11441
	step
		goto 55.1,37.7
		.' NOTE: If you are on an EU server, you will be unable to accept these 2 quests. |tip So, just skip them, and also skip the guide steps where you complete the quest goals for these quests.
		.talk Goldark Snipehunter##23486
		..accept Brewfest!##11441
		..accept Brewfest!##11441
	step
		goto 55.1,37.7
		.talk Goldark Snipehunter##23486
		.' Ask him if there's another way you can help out if you don't like drinking, then ask for a pair of Synthebrew Goggles
		.collect Synthebrew Goggles##46735 |q 11117
	step
		 goto 54.7,38.1
		.talk Boxey Boltspinner##27215
		..accept Chug and Chuck!##12022
	step
		goto 54.8,37.9
		.' Click the Complimentary Brewfest Samplers |tip They looks like mugs of beer on the small tables on either side of you.
		.' Use your Complimentary Brewfest Samplers |use Complimentary Brewfest Sampler##33096
		.' Hit S.T.O.U.T. 5 Times |q 12022/1
	step
		goto 54.7,38.1
		.talk Boxey Boltspinner##27215
		..turnin Chug and Chuck!##12022
	step
		goto 53.7,38.6
		.talk Neill Ramstein##23558
		..accept Now This is Ram Racing... Almost.##11318
	step
		'As you run around on the ram:
		.' Use your Ram Racing Reins |use Ram Racing Reins##33306 |tip The ram runs slow by default.  You have to use the Ram Racing Reins to make it run at certain speeds for 8 seconds.  To make the ram Trot for 8 seconds, use the Ram Racing Reins every 2 seconds or so to keep the ram running at the speed just above the slow default speed.  To make the Ram Canter for 8 seconds, use the Ram Racing Reins a little more often than when you made the Ram Trot.  To make the Ram Gallop, just spam use the Ram Racing Reins.
		.' Maintain a Trot for 8 seconds |q 11318/1
		.' Maintain a Canter for 8 seconds |q 11318/2
		.' Maintain a Gallop for 8 seconds |q 11318/3
	step
		goto 53.7,38.6
		.talk Neill Ramstein##23558
		..turnin Now This is Ram Racing... Almost.##11318
		..accept There and Back Again##11122
	step
		map Dun Morogh
		path follow strict;loop;ants straight
		path	54.6,43.3	54.5,47.4	53.1,51.3
		path	53.7,51.8	54.5,47.7	54.6,43.4
		path	53.6,38.5
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Stop at every bucket of apples you see on the side of the road to refresh your Ram's fatigue level, allowing the Ram to run faster for longer.
		.' _FOLLOW THE WAYPOINT PATH_ Flynn Firebrew will throw you a keg when you get close
		.' Once you have a keg, run back and turn it in to Pol Amberstill at |tip Just get near him and you will throw the keg to him.
		.' Deliver 3 Kegs in Under 4 Minutes|q 11122/1
	step
		goto 53.7,38.6
		.talk Neill Ramstein##23558
		..turnin There and Back Again##11122
	step
		goto 55.1,37.7
		.talk Goldark Snipehunter##23486
		..accept Catch the Wild Wolpertinger!##11117
	step
		goto 55.1,37.7
		.talk Goldark Snipehunter##23486
		.' Tell him:
		.' < I'd like a pair of Synthebrew Goggles. >
		.collect Synthebrew Goggles##46735
	step
		'Use your Synthebrew Goggles |use Synthebrew Goggles##46735
		.' Equip the Synthebrew Goggles |havebuff Interface\Icons\Spell_Holy_SpiritualGuidence |q 11117
	step
		goto 54.5,38.5
		.' Use your Wolpertinger Net on Wild Wolpertingers |use Wolpertinger Net##32907 |tip They look like rabbits with antlers and wings running around on the ground around this area.
		.get 5 Stunned Wolpertinger |q 11117/1
		'|modelnpc Wild Wolpertinger##23487+
	step
		goto 55.1,37.7
		.talk Goldark Snipehunter##23486
		..turnin Catch the Wild Wolpertinger!##11117
		.collect Wolpertinger's Tankard |n
		.' Does Your Wopertinger Linger? |achieve 1936 |tip If you are on the EU server you will be able to achieve this in the Achievments Guide.
	step
		goto 55.1,37.7
		.talk Goldark Snipehunter##23486
		..accept Pink Elekks On Parade##11118
	step
		goto 56.4,37.8
		.talk Belbi Quikswitch##23710
		..turnin Another Year, Another Souvenir.##13932 |or
		.' or
		..turnin A New Supplier of Souvenirs##29396 |or
	step
		goto Elwynn Forest,33.5,50.7
		'Use your Synthebrew Goggles |use Synthebrew Goggles##46735
		.' Equip the Synthebrew Goggles |havebuff Interface\Icons\Spell_Holy_SpiritualGuidence |q 11118
		.' Use your Elekk Dispersion Ray on Elwynn Pink Elekks |use Elekk Dispersion Ray##32960
		.kill 3 Elwynn Pink Elekk |q 11118/2
	step
		goto Darnassus 67.3,46.1
		'Use your Synthebrew Goggles |use Synthebrew Goggles##46735
		.' Equip the Synthebrew Goggles |havebuff Interface\Icons\Spell_Holy_SpiritualGuidence |q 11118
		.' Use your Elekk Dispersion Ray on Azuremyst Pink Elekks |use Elekk Dispersion Ray##32960
		.kill 3 Azuremyst Pink Elekk |q 11118/3
	step
		goto The Exodar,78.4,57.4
		'Use your Synthebrew Goggles |use Synthebrew Goggles##46735
		.' Equip the Synthebrew Goggles |havebuff Interface\Icons\Spell_Holy_SpiritualGuidence |q 11118
		.' Use your Elekk Dispersion Ray on Teldrassil Pink Elekks |use Elekk Dispersion Ray##32960
		.kill 3 Teldrassil Pink Elekk |q 11118/1
	step
		goto Dun Morogh 55.1,37.7
		.talk Goldark Snipehunter##23486
		..turnin Pink Elekks On Parade##11118
	step
		'Use the Dungeon Finder (press I) to queue for Coren Direbrew |tip You must be level 89 do complete this quest.
		.' You will fight Coren Direbrew
		.from Coren Direbrew##23872
		.collect Direbrew's Dire Brew##38280 |n
		.' Click Direbrew's Dire Brew in your bags |use Direbrew's Dire Brew##38280
		..accept Direbrew's Dire Brew##12491
	step
		'Click the green eye on the edge of your minimap
		.' Teleport Out of the Dungeon and go to Dun Morogh |goto Dun Morogh |noway |c
	step
		goto 55.1,38.1
		.talk Ipfelkofer Ironkeg##24710
		..turnin Direbrew's Dire Brew##12491
]])
ZygorGuidesViewer:RegisterInclude("Brewfest Dailies",[[
		'You will only be able to do 1 of the first 2 dailies in this guide, per day. |tip Quests "Bark for the Barleybrews!" or "Bark for the Thunderbrews!".
		|confirm
	step
		goto Dun Morogh,56.1,38.0
		.talk Becan Barleybrew##23627
		..accept Bark for the Barleybrews!##11293
	step
		goto Dun Morogh,56.5,36.9
		..accept Bark for the Barleybrews!##11293 |or
		.' Or
		 goto 56.6,36.9
		.talk Daran Thunderbrew##23628
		..accept Bark for the Thunderbrews!##11294 |or
	step
		'Ride your ram into Ironforge |goto Ironforge |noway |c |q 11293
		goto Ironforge/0 15.8,84.6 |n
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		|only if havequest (11293)
	step
		'Ride your ram into Ironforge |goto Ironforge |noway |c |q 11294
		goto Ironforge/0 15.8,84.6 |n
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		|only if havequest (11294)
	step
		goto Ironforge,31.7,66.7
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark Outside the Bank |q 11293/1
		|only if havequest (11293)
	step
		goto 61.2,80.0
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Military Ward |q 11293/2
		|only if havequest (11293)
	step
		goto 65.3,24.4
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Hall of Explorers |q 11293/3
		|only if havequest (11293)
	step
		goto 29.5,14.2
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Mystic Ward |q 11293/4
		|only if havequest (11293)
	step
		goto Ironforge,31.7,66.7
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark Outside the Bank |q 11294/1
		|only if havequest (11294)
	step
		goto 61.2,80.0
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Military Ward |q 11294/2
		|only if havequest (11294)
	step
		goto 65.3,24.4
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Hall of Explorers |q 11294/3
		|only if havequest (11294)
	step
		goto 29.5,14.2
		.' Use your Ram Racing Reins as you run |use Ram Racing Reins##33306 |tip Just keep a Trot pace most of the time and only sometimes keep a Canter pace.  If you go too much faster than that, your ram will get tired and you will run out of time.
		.' Go to this spot
		.' Bark in the Mystic Ward |q 11294/4
		|only if havequest (11294)
	step
		goto Dun Morogh,56.1,38.0
		.talk Becan Barleybrew##23627
		..turnin Bark for the Barleybrews!##11293
		|only if havequest (11293)
	step
		goto Dun Morogh,56.5,36.9
		.talk Daran Thunderbrew##23628
		..turnin Bark for the Thunderbrews!##11294
		|only if havequest (11294)
	step
		goto 56.0,37.2
		.' Click the Dark Iron Mole Machine Wreckage |tip It looks like a big metal gear laying on ground in the middle of the festival.  It appears after the Dark Iron dwarves attack the Brewfest festival, so you may have to wait for it to appear.
		goto 56.0,37.1
		.' Click the Dark Iron Mole Machine Wreckage |tip You have to defend the three kegs at these locations in order for it to show up.
		.' Click the Complimentary Brewfest Sampler here [55.3,37.3]
		.' Click the Complimentary Brewfest Sampler here [55.7,38.1]
		.' Thow the Sampler's at the Dark Iron Dwarves and the Mole Machines. |use Complimentary Brewfest Sampler##33096
		..accept This One Time, When I Was Drunk...##12020
	step
		goto Dun Morogh,54.7,38.1
		.talk Boxey Boltspinner##27215
		..turnin This One Time, When I Was Drunk...##12020
		.' Down With The Dark Iron Achievement |achieve 1186
	step
		goto 53.7,38.6
		.talk Neill Ramstein##23558
		..accept Brew For Brewfest##29394 |instant
		.' On your Ram, run to Flynn Firebrew at|tip Flynn Firebrew will throw you a keg when you get close.
		.' Deliver as many kegs as you can within 4 minutes |tip You get 2 Brewfest Prize Tokens for each keg you deliver, so this is a good way to get some Brewfest Prize Tokens to join the Brew of the Month Club.
	step
		map Dun Morogh
		path follow strict;loop;ants straight
		path	54.6,43.3	54.5,47.4	53.1,51.3
		path	53.7,51.8	54.5,47.7	54.6,43.4
		path	53.6,38.5
		.' Follow this path to pick up Kegs from Flynn Firebrew and run them back to Neill Ramstein
		.' Use your Ram Racing Reins |use Ram Racing Reins##33306
]])
ZygorGuidesViewer:RegisterInclude("Brewfest Achievements",[[
		 goto Dun Morogh,55.6,38.2
		.talk Arlen Lochlan##23522
		.buy 1 The Essential Brewfest Pretzel##33043 |n
		.' Eat The Essential Brewfest Pretzels |achieve 1185/7 |use The Essential Brewfest Pretzel##33043
	step
		goto 56.5,37.7
		.talk Anne Summers##23521
		.buy 1 Spiced Onion Cheese##34065 |n
		.' Eat the Spiced Onion Cheese |achieve 1185/4 |use Spiced Onion Cheese##34065
	step
		goto 56.0,36.4
		.talk Keiran Donoghue##23481
		.buy 1 Dried Sausage##34063 |n
		.' Eat the Dried Sausage |achieve 1185/1 |use Dried Sausage##34063
		.buy 1 Succulent Sausage##34064 |n
		.' Eat the Succulent Sausage |achieve 1185/6 |use Succulent Sausage##34064
		.buy 1 Savory Sausage##33023 |n
		.' Eat the Savory Sausage |achieve 1185/3 |use Savory Sausage##33023
		.buy 1 Pickled Sausage##33024 |n
		.' Eat the Pickled Sausage |achieve 1185/2 |use Pickled Sausage##33024
		.buy 1 Spicy Smoked Sausage##33025 |n
		.' Eat Spicy Smoked Sausage |achieve 1185/5 |use Spicy Smoked Sausage##33025
		.buy 1 The Golden Link##33026 |n
		.' Eat The Golden Link |achieve 1185/8 |use The Golden Link##33026
	step
		.' Eat all of the Brewfest Foods!
		.' Achieve The Brewfest Diet! |achieve 1185
	step
		goto 56.4,37.8
		.talk Belbi Quikswitch##23710
		.buy 1 Fresh Brewfest Hops##37750 |achieve 303 |tip You must be at least level 20 to buy these.
	step
		'Use your Fresh Brewfest Hops |use Fresh Brewfest Hops##37750
		.' Make your Mount Festive for Brewfest! |achieve 303
	step
		'Complete the Brewfest daily quests each day until you have 200 Brewfest Prize Tokens
		.collect 200 Brewfest Prize Token##37829 |achieve 2796
	step
		goto 56.4,37.9
		.talk Belbi Quikswitch##23710
		.buy "Brew of the Month" Club Membership Form##37736 |n
		.' Click the "Brew of the Month" Club Membership Form in your bags |use "Brew of the Month" Club Membership Form##37736
		..accept Brew of the Month Club##12420
	step
		'Go inside Ironforge |goto Ironforge |noway |c
	step
		goto Ironforge,18.8,53.1
		.talk Larkin Thunderbrew##27478
		..turnin Brew of the Month Club##12420
		.' Achieve Brew of the Month! |achieve 2796
		.' Achieve Brewmaster! |achieve 1684
	step
		goto Dun Morogh,56.4,37.8
		.' If you are on the EU servers go here to buy your Wolpertinger Pet
		.buy Wolpertinger's Tankard##32233 |n
		.' Does Your Wopertinger Linger? |achieve 1936
	step
		'Congratulations, you are a Brewmaster!
]])
--------------------------------------------------------------------------------------------------------------------------------------
-- Professions
--------------------------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------------------------------------------------
-- Cooking
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("A_Stormwind_Cooking_Dailies",[[
	step
	label "swstart"
		'You will only be able to complete 1 of the following quests per day
		|confirm
	step
		goto Stormwind City,50.6,71.9
		.talk Robby Flay##42288
		.' You will only be able to complete 1 of the following quests per day
		..accept A Fisherman's Feast##26190 |or
		..accept Feeling Crabby?##26177 |or
		..accept Orphans Like Cookies Too!##26192 |or
		..accept Penny's Pumpkin Pancakes##26153 |or
		..accept The King's Cider##26183 |or
	step
		goto 54.9,68.2
		.click Barrel of Canal Fish##9591+ |tip They look like dark wooden barrels near fishermen all along the canals.
		.get 5 Gigantic Catfish |q 26190/1
	step
		goto 54.5,66.7
		.clicknpc Canal Crab##42339+ |tip They look like small crabs underwater all along in the canals.
		.get 10 Canal Crab |q 26177/1
	step
		goto 41.2,83.6
		.click Sack of Confectioner's Sugar##5511+ |tip They look like cloth white sacks.  This one is laying on the ground inside The Slaughtered Lamb building.
		.get 4 Confectioner's Sugar |q 26192/1
		.' You can find more Sacks of Confectioner's Sugar:
		.' at [51.0,96.2] |tip Laying on the floor, next to the fireplace in The Blue Recluse building.
		.' at [77.8,53.2] |tip Laying on the floor, next to the fireplace in Pig and Whistle Tavern building.
		.' at [66.0,31.9] |tip Laying on the bar inside The Golden Keg building.
	step
		goto 54.3,12.3
		.click Stormwind Pumpkin##60+ |tip They look like big orange pumpkins on the ground around this area.
		.get 6 Stormwind Pumpkin |q 26153/1
	step
		goto 55.0,74.0
		.click Juicy Apples##433+ |tip They look like red apples laying on the ground under apple trees along the streets of Stormwind City.  There are different types of trees in Stormwind, so only look under the rounder shaped trees with red apples in them.
		get 12 Juicy Apple |q 26183/1
	step
		goto 50.6,71.9
		.talk Robby Flay##42288
		.' You will only be able to complete 1 of the following quests per day
		..turnin A Fisherman's Feast##26190
		..turnin Feeling Crabby?##26177
		..turnin Orphans Like Cookies Too!##26192
		..turnin Penny's Pumpkin Pancakes##26153
		..turnin The King's Cider##26183
]])

ZygorGuidesViewer:RegisterInclude("A_Ironforge_Cooking_Dailies",[[
	step
		goto Ironforge,60.1,36.4
		.talk Daryl Riknussun##5159
		..accept A Fowl Shortage##29352 |or
		..accept A Round for the Guards##29351 |or
		..accept Can't Get Enough Spice Bread##29355 |or
		..accept I Need to Cask a Favor##29356 |or
		..accept Keepin' the Haggis Flowin'##29353 |or
	step
		goto Dun Morogh 53.9,50.7
		.click Cask of Drugan's IPA##7414
		|tip This is a timed quest. You will be forced to run automatically and have 3 mins to run the IPA back to the quest giver.
		'Pick up the Cask of Drugan's IPA |havebuff Interface\Icons\INV_Cask_01
		|only if havequest(29356)
	step
		goto Ironforge 60.1,36.5
		.' Deliver the Cask of Drugan's IPA |q 29356/2
	step
		goto Ironforge,58.9,41.2
		.' Click on the Sack of Oatmeal
		.get 4 Sack of Oatmeal##69985 |q 29353/2 |tip They look like shinning white bags on the ground all around Ironforge
		|only if havequest(29353)
	step
		goto Ironforge,61.9,72.5
		.talk Sognar Cliffbeard##5124
		.get 1 Bag o' Sheep Innards##69984 |q 29353/1
		|only if havequest(29353)
	step
		goto Ironforge,59.9,37.6 |q 29353
		.talk Emrul Riknussun##5160 |q 29353
		.get 5 Mild Spices##2678 |q 29353/3
		|only if havequest(29353)
	step
		goto Ironforge,57.9,50.0
		.' Offer your Ironforge Rations to the Ironforge Guards around Ironforge |use Ironforge Rations##69981
		.' 6 Ironforge Guards Fed |q 29351/1
		|only if havequest(29351)
	step
		goto Ironforge,59.9,37.6
		.talk Emrul Riknussun##5160
		.buy 10 Simple Flour##30817 |q 29355
		.buy 10 Mild Spices##2678 |q 29355
		|only if havequest(29355)
	step
		.create Spice Bread##37836,Cooking,10 total
		.get 10 Spice Bread |q 29355/1
		|only if havequest(29355)
	step
		goto Dun Morogh 59.8,35.2
		.clicknpc Dun Morogh Chicken##53568
		.get 6 Dun Morogh Chicken |q 29352/1
	step
		goto Ironforge 60.1,36.5
		.talk Daryl Riknussun##29351
		..turnin A Fowl Shortage##29352 |or
		..turnin A Round for the Guards##29351 |or
		..turnin Can't Get Enough Spice Bread##29355 |or
		..turnin I Need to Cask a Favor##29356 |or
		..turnin Keepin' the Haggis Flowin'##29353 |or
]])

ZygorGuidesViewer:RegisterInclude("A_Darnassus_Cooking_Dailies",[[
		goto Darnassus,50.0,36.6
		.talk Alegorn##4210
		..accept The Secret to Perfect Kimchi##29313 |or
		..accept Remembering the Ancestors##29314 |or
		..accept Back to Basics##29316 |or
		..accept Ribs for the Sentinels##29318 |or
		..accept Spice Bread Aplenty##29357 |or
	step
		goto Darnassus,43.2,78.4
		.' Click on the Blessed Rice Cakes
		.get Blessed Rice Cakes##69900 |q 29314/1
	step
		goto 48.0,37.0
		.' Click on the Buried Kimchi Jar |tip They look like shinning jars covered in dirt all over Darnassus
		.get 8 Buried Kimchi Jar |q 29313/1
	step
		goto 49.6,36.6
		.talk Fyldan##4223
		.buy 10 Simple Flour##30817 |q 29357 |n
		.buy 10 Mild Spices##2678 |q 29357 |n
		.create Spice Bread##37836,Cooking,10 total |n
		.get 10 Spice Bread |q 29357/1
	step
		'Click on the Rice Baskets found on the Craftmen's Terrace and the Warrior's Terrace |tip They look like shinning light-brown baskets
		.' Practice Making Rice Flour |q 29316/1
	step
		goto 52.2,35.6
		.' Create a basic campfire |cast Basic Campfire##818
		.' Cook your Uncooked Ribs (5) |use Uncooked Ribs##69904
		.collect 5 Delicious Ribs##69906 |n
		.' Feed the Delicious Ribs to the Darnassus Sentinels, located all over Darnassus |use Delicious Ribs##69906
		.' Feed Ribs to Sentinels (5) |q 29318/1
	step
		goto Darnassus,50.0,36.6
		.talk Alegorn##4210
		..turnin The Secret to Perfect Kimchi##29313
		..turnin Back to Basics##29316
		..turnin Ribs for the Sentinels##29318
		..turnin Spice Bread Aplenty##29357
	step
		goto Darnassus,69.2,39.9
		.' Click on the Shrine of the Ancestors
		..turnin Remembering the Ancestors##29314
]])

ZygorGuidesViewer:RegisterInclude("A_Kickin'_It_Up_a_Notch",[[
	step
	label "warning"
		.' The following quests are random and you can only do one per day. Click to proceed. |confirm always
	step
	label "hub"
		goto Shattrath City,61.8,15.6
		.talk The Rokk##24393
		.' You will only be able to accept one of these daily quests per day
		..accept Soup for the Soul##11381 |or
		..accept Super Hot Stew##11379 |or
		..accept Manalicious##11380 |or
		..accept Revenge is Tasty##11377 |or
	step
		goto Nagrand,56.2,73.3
		.talk Uriku##20096
		.buy Recipe: Roasted Clefthoof##27691 |n
		.' Click the Recipe: Roasted Clefthoof in your bags |use Recipe: Roasted Clefthoof##27691
		.learn Roasted Clefthoof##33287 |q 11381
	step
		goto Nagrand,58.5,46.8
		.from Clefthoof##18205+, Clefthoof Calf##19183+
		.collect 4 Clefthoof Meat##27678 |q 11381
		.' You can find more Clefthooves at [45.5,72.7]
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create Roasted Clefthoof##33287,Cooking,4 total |q 11381
	step
		goto 25.9,59.4
		.' Use your Cooking Pot to Cook up some Spiritual Soup |use Cooking Pot##33851
		.' Cook a Spiritual Soup |q 11381/1
	step
		goto Blade's Edge Mountains,62.5,40.3
		.talk Xerintha Ravenoak##20916
		.buy Recipe: Mok'Nathal Shortribs##31675 |n
		.' Click the Recipe: Mok'Nathal Shortribs in your bags |use Recipe: Mok'Nathal Shortribs##31675
		.learn Mok'Nathal Shortribs##31672 |q 11379
		.buy Recipe: Crunchy Serpent##31674 |n
		.' Click the Recipe: Crunchy Serpent in your bags |use Recipe: Mok'Nathal Shortribs##31674
		.learn Crunchy Serpent##31673 |q 11379
	step
		goto Blade's Edge Mountains,49.6,46.2
		.from Daggermaw Blackhide##22052+, Bladespire Raptor##20728+
		.collect 4 Raptor Ribs##31670+ |q 11379
	step
		goto 68.2,63.2
		.from Scalewing Serpent##20749+, Felsworn Scalewing##21123+
		.collect 1 Serpent Flesh##31671 |q 11379
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create 2 Mok'Nathal Shortribs##38867,Cooking,2 total |q 11379
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create 1 Crunchy Serpent##38868,Cooking,1 total |q 11379
	step
		goto 29.0,84.5
		.from Abyssal Flamebringer##19973+
		.' Use your Cooking Pot next to the Abyssal Flamebringer corpse to Cook up some Demon Broiled Surprise |use Cooking Pot##33852
		.get Demon Broiled Surprise |q 11379/1
	step
		goto Netherstorm,45.6,54.2
		.click Mana Berry Bush##28+
		.get 15 Mana Berry##33849+ |q 11380/1
	step
		goto Terokkar Forest,55.8,53.0
		.talk Supply Officer Mills##19038
		.buy Recipe: Warp Burger##27692 |n
		.' Click the Recipe: Warp Burger in your bags |use Recipe: Warp Burger##27692
		.learn Warp Burger##33288 |q 11377
	step
		goto 64.0,83.5
		.from Blackwind Warp Chaser##23219+
		.collect 3 Warped Flesh##27681 |q 11377
	step
		goto 67.6,74.7
		.from Monstrous Kaliri##23051+ |tip They fly around in the sky close to the tree outposts and bridges.
		.collect Giant Kaliri Wing##33838 |q 11377
	step
		goto 25.9,59.5
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create Warp Burger##33288,Cooking,3 total |q 11377
		.' Use your Cooking Pot to Cook up some Kaliri Stew |use Cooking Pot##33837
		.create Kaliri Stew##43718,Cooking,1 total |q 11377/1
	step
		goto Shattrath City,61.8,15.6
		.talk The Rokk##24393
		..turnin Soup for the Soul##11381
		..turnin Super Hot Stew##11379
		..turnin Manalicious##11380
		..turnin Revenge is Tasty##11377
	step
		'You've completed all the dailies you can do today. Click to go back to the dailies hub. |confirm |next "-warning" |only if not step:Find("+check"):IsComplete()
		'Checking achievements |next |only if default
	step
	label "check"
		.' Daily Completed "Revenge is Tasty" |achieve 906/1
		.' Daily Completed "Super Hot Stew" |achieve 906/2
		.' Daily Completed "Manalicious" |achieve 906/3
		.' Daily Completed "Soup for the Soul" |achieve 906/4
		.' Earn the Kickin' It Up a Notch Achievement |achieve 906
	step
		'Congratulations!  You've earned "Kickin' It Up a Notch" Achievement.
]])

ZygorGuidesViewer:RegisterInclude("A_The_Outland_Gourmet",[[
	step
	title +The Burning Crusade Recipes
		#include trainCooking
		.learn Stewed Trout##42296
		.learn Fisherman's Feast##42302
		.learn Hot Buttered Trout##42305
	//300 Buzzard Bites TBC
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Ravager Egg Roundup##9349
	step
		goto 39.0,88.4
		.from Razorfang Hatchling##16932+,Razorfang Ravager##16933+
		.get 12 Ravager Egg##23217 |q 9349/1
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..turnin Ravager Egg Roundup##9349
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Helboar, the Other White Meat##9361
	step
		goto 51.2,69.8
		.from Deranged Helboar##16863
		.collect 8 Tainted Helboar Meat##23270
	step
		'Use the Purification Mixture on the Tainted Meat |use Purification Mixture##23268
		.get 8 Purified Helboar Meat##23248 |q 9361/1
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..turnin Helboar, the Other White Meat##9361
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Smooth as Butter##9356
	step
		goto 61.0,66.6
		.from Bonestripper Buzzard##16972
		.get 12 Plump Buzzard Wing |q 9356/1
	step
		goto Hellfire Peninsula,49.2,74.8
		.talk Legassi##19344
		..accept Smooth as Butter##9356
		.collect 1 Recipe: Buzzard Bites##27684 |n
		.'_
		.learn Buzzard Bites##33279 |use Recipe: Buzzard Bites##27684
		//300 Ravager Dog TBC
	step
		//alliance:
		goto Hellfire Peninsula,54.2,63.6
		.talk Sid Limbardi##16826
		.buy 1 Recipe: Ravager Dog##27688 |n
		.'_
		.learn Ravager Dog##33284 |use Recipe: Ravager Dog##27688
	//300 Clam Bar TBC
	step
		goto Zangarmarsh,17.8,51.2
		.talk Mycah##18382
		.buy 1 Recipe: Clam Bar##30156 |n
		.'_
		.learn Clam Bar##36210 |use Recipe: Clam Bar##30156
	//300 Feltail Delight TBC blackened trout
	step
		//alliance:
		goto Zangarmarsh,42.2,27.8
		.talk Doba##20028
		.buy 1 Recipe Feltail Delight##27695 |n
		.buy 1 Recipe: Blackened Trout##27694 |n
		.'_
		.learn Feltail Delight##33291 |use Recipe Feltail Delight##27695
		.learn Blackened Trout##33290 |use Recipe: Blackened Trout##27694
	//310 Blackened Sporefish TBC
	step
		//both
		goto Zangarmarsh,78.0,66.0
		.talk Juno Dufrain##18911
		.buy 1 Recipe: Blackened Sporefish##27696 |n
		.'_
		.learn Blackened Sporefish##33292 |use Recipe: Blackened Sporefish##27696
	//310 Sporeling Snack TBC --help
	//320 Grilled Mudfish TBC, poached bluefish, talbuk steak. roasted clefthoof
	step
		//alliance
		goto Nagrand,56.2,73.2
		.talk Uriku##20096
		//horde
		.buy 1 Recipe: Grilled Mudfish##27697 |n
		.buy 1 Recipe: Talbuk Steak##27693 |n
		.buy 1 Recipe: Poached Bluefish##27698 |n
		.buy 1 Recipe: Roasted Clefthoof##27691 |n
		.'_
		.learn Talbuk Steak##33289 |use Recipe: Talbuk Steak##27693
		.learn Grilled Mudfish##33293 |use Recipe: Grilled Mudfish##27697
		.learn Poached Bluefish##33294 |use Recipe: Poached Bluefish##27698
		.learn Roasted Clefthoof##33287 |use Recipe: Roasted Clefthoof##27691
	//325 Golden Fish Sticks TBC + Spicy Crawdad TBC
	step
		//alliance
		goto Terokkar Forest,56.6,53.2
		.talk Innkeeper Biribi##19296
		.buy 1 Recipe: Golden Fish Sticks##27699 |n
		.buy 1 Recipe: Spicy Crawdad##27700 |n
		.'_
		.learn Golden Fish Sticks##33295 |use Recipe: Golden Fish Sticks##27699
		.learn Spicy Crawdad##33296 |use Recipe: Spicy Crawdad##27700
	//315 Blackened Basilisk TBC + warp burger
	step
		//allaince
		goto Terokkar Forest,55.8,53.0
		.talk Supply Officer Mills##19038
		//horde
		.buy 1 Recipe Blackened Basilisk##27690 |n
		.buy 1 Recipe: Warp Burger##27692 |n
		.'_
		.learn Blackened Basilisk##33286 |use Recipe Blackened Basilisk##27690
		.learn Warp Burger##33288 |use Recipe: Warp Burger##27692
	//325 Warp Burger TBC
	//335 Crunchy Serpent TBC + Mok'Nathal Shortribs TBC
	step
		goto Blade's Edge Mountains,62.4,40.2
		.talk Xerintha Ravenoak##20916
		.buy 1 Recipe: Mok'Nathal Shortribs##31675 |n
		.buy 1 Recipe: Crunchy Serpent##31674 |n
		.'_
		.learn Mok'Nathal Shortribs##38867 |use Recipe: Mok'Nathal Shortribs##31675
		.learn Crunchy Serpent##38868 |use Recipe: Crunchy Serpent##31674
	step
		'Use the Shattrath Cooking Dailies section of this guide to get these recipes: |tip It's not always guarenteed to come from these daily prizes so be patient
		'Make sure to choose the Crate of Meat
		.collect 1 Recipe: Spicy Hot Talbuk##33873 |n
		.'_
		.learn Spicy Hot Talbuk##43765 |use Recipe: Spicy Hot Talbuk##33873
	//300 Broiled Bloodfin TBC + Skullfish Soup TBC
	step
		//Barrel of fish
		'Use the Shattrath Cooking Dailies section of this guide to get these recipes: |tip It's not always guarenteed to come from these daily prizes so be patient
		'Make sure to choose the Barrel of Fish
		.collect 1 Recipe: Broiled Bloodfin##33869 |n
		.collect 1 Recipe: Skullfish Soup##33870 |n
		.'_
		.learn Broiled Bloodfin##43761 |use Recipe: Broiled Bloodfin##33869
		.learn Skullfish Soup##43707 |use Recipe: Skullfish Soup##33870
	//300 Kibler's Bits TBC
	step
		'Use the Shattrath Cooking Dailies section of this guide to get this recipe: |tip It's not always guarenteed to come from these daily prizes so be patient
		'You can choose either the Crate of Meat or Barrel of Fish
		.collect 1 Recipe: Kibler's Bits##33875 |n
		.'_
		.learn Kibler's Bits##43772 |use Recipe: Kibler's Bits##33875
	//300 Stormchops TBC
	step
		'Use the Shattrath Cooking Dailies or Dalaran Cooking Dailies section of this guide to get these recipes: |tip It's not always guarenteed to come from these daily prizes so be patient
		'You can choose either Crate of Meat, Barrel of Fish, or Small Spice Bag
		.collect 1 Recipe: Stormchops##33871 |n
		.collect 1 Recipe: Delicious Chocolate Cake##33925 |n
		.'_
		.learn Stormchops##43758 |use Recipe: Stormchops##33871
		.learn Delicious Chocolate Cake##43779 |use Recipe: Delicious Chocolate Cake##33925
	step
		'You can either purchase these items from the Acution House or farm them
		.collect 8 Small Eggs##6889
		.collect 2 Buzzard Meat##27671
		.collect 2 Clefthoof Meat##27678
		.collect 2 Jaggal Clam Meat##24477
		.collect 2 Talbuk Venison##27682
		.collect 1 Chunk o' Basilisk##27677
		.collect 1 Raptor Ribs##31670
		.collect 1 Ravager Flesh##27674
		.collect 1 Serpent Flesh##31671
		.collect 1 Strange Spores##27676
		.collect 1 Warped Flesh##27681
		.collect 3 Mageroyal##785
	step
		'You can either purchase these items from the Auction House or fish for them
		.collect 2 Barbed Gill Trout##27422
		.collect 1 Bloodfin Catfish##33823
		.collect 1 Crescent-Tail Skullfish##33824
		.collect 1 Enormous Barbed Gill Trout##27516
		.collect 1 Figluster's Mudfish##27435
		.collect 1 Golden Darter##27438
		.collect 1 Huge Spotted Feltail##27515
		.collect 1 Icefin Bluefish##27437
		.collect 1 Lightning Eel##13757
		.collect 1 Spotted Feltail##27425
		.collect 1 Zangarian Sporefish##27429
	step
		goto Stormwind City,60.8,74.8
		.talk Innkeeper Allison##6740
		.buy 5 Goldenbark Apple##4539
		.buy 4 Ice Cold Milk##1179
	step
		goto Stormwind City 77.6,53.1
		.talk Erika Tate##5483
		.buy 8 Simple Flour##30817
		.buy 4 Mild Spices##2678
	step
		goto Stormwind City,76.3,53.0
		.talk Reese Langston##1327
		.buy 1 Flask of Port##2593
	step
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Delicious Chocolate Cake##43779,Cooking,1 total
		.' Cook Delicious Chocolate Cake |achieve 1800/1
	step
		.create Blackened Trout##33290,Cooking,1 total
		.' Cook Blackened Trout |achieve 1800/2
	step
		.create Buzzard Bites##33279,Cooking,1 total
		.' Cook Buzzard Bites |achieve 1800/3
	step
		.create Clam Bar##36210,Cooking,1 total
		.' Cook Clam Bar |achieve 1800/4
	step
		.create Feltail Delight##33291,Cooking,1 total
		.' Cook Feltail Delight |achieve 1800/5
	step
		.create Ravager Dog##33284,Cooking,1 total
		.' Cook Ravager Dog |achieve 1800/6
	step
		.create Stormchops##43758,Cooking,1 total
		.' Cook Stormchops |achieve 1800/7
	step
		.create Blackened Sporefish##33292,Cooking,1 total
		.' Cook Blackened Sporefish |achieve 1800/8
	step
		.create Blackened Basilisk##33286,Cooking,1 total
		.' Cook Blackened Basilisk |achieve 1800/9
	step
		.create Grilled Mudfish##33293,Cooking,1 total
		.' Cook Grilled Mudfish |achieve 1800/10
	step
		.create Poached Bluefish##33294,Cooking,1 total
		.' Cook Poached Bluefish |achieve 1800/11
	step
		.create Broiled Bloodfin##43761,Cooking,1 total
		.' Cook Broiled Bloodfin |achieve 1800/12
	step
		.create Golden Fish Sticks##33295,Cooking,1 total
		.' Cook Golden Fish Sticks |achieve 1800/13
	step
		.create Kibler's Bits##43772,Cooking,1 total
		.' Cook Kibler's Bits |achieve 1800/14
	step
		.create Roasted Clefthoof##33287,Cooking,1 total
		.' Cook Roasted Clefthoof |achieve 1800/15
	step
		.create Talbuk Steak##33289,Cooking,1 total
		.' Cook Talbuk Steak |achieve 1800/16
	step
		.create Warp Burger##33288,Cooking,1 total
		.' Cook Warp Burger |achieve 1800/17
	step
		.create Crunchy Serpent##38868,Cooking,1 total
		.' Cook Crunchy Serpent |achieve 1800/18
	step
		.create Mok'Nathal Shortribs##38867,Cooking,1 total
		.' Cook Mok'Nathal |achieve 1800/19
	step
		.create Fisherman's Feast##42302,Cooking,1 total
		.' Cook Fisherman's Feast |achieve 1800/20
	step
		.create Hot Buttered Trout##42305,Cooking,1 total
		.' Cook Hot Buttered Trout |achieve 1800/21
	step
		.create Skullfish Soup##43707,Cooking,1 total
		.' Cook Skullfish Soup |achieve 1800/22
	step
		.create Spicy Crawdad##33296,Cooking,1 total
		.' Cook Spicy Crawdad |achieve 1800/23
	step
		.create Spicy Hot Talbuk##43765,Cooking,1 total
		.' Cook Spicy Hot Talbuk |achieve 1800/24
	step
		.create Stewed Trout##42296,Cooking,1 total
		.' Cook Stewed Trout |achieve 1800/25
	step
		.' Cook each of the Outland cooking recipes |achieve 1800
	step
		Congratulations! You're earned The Outland Gourmet achievement!
]])

ZygorGuidesViewer:RegisterInclude("A_The_Northrend_Gourmet",[[
	//Northern Stew
	step
	title +Wrath of the Lich King Recipes
		#include trainCooking
		.learn Dalaran Clam Chowder##58065
		.learn Grilled Sculpin##45563
		.learn Mammoth Meal##45549
		.learn Pickled Fangtooth##45566
		.learn Poached Nettlefish##45565
		.learn Rhino Dogs##45553
		.learn Roasted Worg##45552
	step
		#include trainCooking
		.learn Shoveltusk Steak##45550
		.learn Smoked Salmon##45564
		.learn Worm Delight##45551
		.learn Fisherman's Feast##42302
		.learn Hot Buttered Trout##42305
		.learn Great Feast##45554
		.learn Black Jelly##64358
		.learn Darkbrew Lager##88015
		.learn Blackened Surprise##88006
	step
		alliance
		goto Borean Tundra 57.8,71.4
		.talk Rollick MacKreel##26989
		..accept Northern Cooking##13088
	step
		goto 45,47.4
		.from Wooly Rhino Matriarch##25487+,Wooly Rhino Calf##25488+
		.get 4 Chilled Meat##43013 |q 13088
	step
		//alliance
		goto 57.8,71.4
		.talk Rollick MacKreel##26989
		..turnin Northern Cooking##13088
		.learn Northern Stew##57421
	//Emotions food
	step
		goto 54.6,70.0
		.from Crypt Crawler##25227
		.collect 1 Recipe: Bad Clams##43509
		.collect 1 Recipe: Last Week's Mammoth##43508
		.collect 1 Recipe: Haunted Herring##43510
		.collect 1 Recipe: Tasty Cupcake##43507
	step
		.learn Bad Clams##58523 |use Recipe: Bad Clams##43509
		.learn Haunted Herring##58525 |use Recipe: Haunted Herring##43510
		.learn Last Week's Mammoth##58521 |use Recipe: Last Week's Mammoth##43508
		.learn Tasty Cupcake##58512 |use Recipe: Tasty Cupcake##43507
	step
		fly Nesingwary Base Camp
	step
		goto Sholazar Basin 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..accept Some Make Lemonade, Some Make Liquor##12634
	step
		goto 37.6,61.8
		.' Click the Sturdy Vines|tip They look like brown vines that hang from trees around this area. Sometimes a Dwarf will fall out and give you fruit you need.
		.' Click the fruit that falls to the ground or talk to the dwarf that falls
		.get Orange |q 12634/1
		.get 2 Banana Bunch|q 12634/2
		.get Papaya |q 12634/3
	step
		goto 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..turnin Some Make Lemonade, Some Make Liquor##12634
		..accept Still At It##12644
	step
		goto 26.7,60
		.talk "Tipsy" McManus##28566
		..'Tell him you are ready to start the distillation process
		.' Click the items on the ground or on the machine that he yells at you during the process, it's random
		.' Click the barrel on the ground when the process is done
		.get Thunderbrew's Jungle Punch|q 12644/1
	step
		goto 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..turnin Still At It##12644
		..accept The Taste Test##12645
	step
		goto 27.4,59.4
		.' Use your Jungle Punch Sample on Hadrius Harlowe|use Jungle Punch Sample##38697|tip Standing next to a tiki torch.
		.' Complete Hadrius' taste test |q 12645/2
	step
		goto 27.1,58.6
		.' Use your Jungle Punch Sample on Hemet Nesingwary|use Jungle Punch Sample##38697|tip Standing in front of a tent.
		.' Complete Hemet's taste test |q 12645/1
	step
		goto 26.8,60.1
		.talk Grimbooze Thunderbrew##29157
		..turnin The Taste Test##12645
	step
		goto Dalaran/2 44.2,25.6
		.talk Washed-Up Mage##32516
		..accept Fletcher's Lost and Found##13571 |instant
	step
		'Use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		'Use the Dalaran Cooking Dailies section of this guide to earn Dalaran Cooking Awards to buy the following recipes: |tip You will need a total of 74 Dalaran Cooking Awards to get all of the recipes
		goto Dalaran,70.1,38.2
		#include "vendor_Cooking_Dalaran"
		.buy 1 Recipe: Mega Mammoth Meal##43018
		.buy 1 Recipe: Tender Shoveltusk Steak##43019
		.buy 1 Recipe: Spiced Worm Burger##43020
		.buy 1 Recipe: Very Burnt Worg##43021
		.buy 1 Recipe: Worg Tartare##44954
		.buy 1 Recipe: Mighty Rhino Dogs##43022
		.buy 1 Recipe: Poached Northern Sculpin##43023 //50
		.buy 1 Recipe: Firecracker Salmon##43024
		.buy 1 Recipe: Spicy Blue Nettlefish##43025
		.buy 1 Recipe: Imperial Manta Steak##43026
		.buy 1 Recipe: Spicy Fried Herring##43027
		.buy 1 Recipe: Rhinolicious Wormsteak##43028
	step
		'Use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		.learn Mega Mammoth Meal##45555 |use Recipe: Mega Mammoth Meal##43018
		.learn Tender Shoveltusk Steak##45556 |use Recipe: Tender Shoveltusk Steak##43019
		.learn Spiced Worm Burger##45557 |use Recipe: Spiced Worm Burger##43020
		.learn Very Burnt Worg##45558 |use Recipe: Very Burnt Worg##43021
		.learn Worg Tartare##62350 |use Recipe: Worg Tartare##44954
		.learn Mighty Rhino Dogs##45559 |use Recipe: Mighty Rhino Dogs##43022
		.learn Poached Northern Sculpin##45567 |use Recipe: Poached Northern Sculpin##43023
		.learn Firecracker Salmon##45568 |use Recipe: Firecracker Salmon##43024
		.learn Spicy Blue Nettlefish##45571 |use Recipe: Spicy Blue Nettlefish##43025
		.learn Imperial Manta Steak##45570 |use Recipe: Imperial Manta Steak##43026
		.learn Spicy Fried Herring##57433 |use Recipe: Spicy Fried Herring##43027
		.learn Rhinolicious Wormsteak##57434 |use  Recipe: Rhinolicious Wormsteak##43028
	step
		'Use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		'Use the Dalaran Cooking Dailies section of this guide to earn Dalaran Cooking Awards to buy the following recipes: |tip You will need a total of 74 Dalaran Cooking Awards to get all of the recipes
		goto Dalaran,70.1,38.2
		#include "vendor_Cooking_Dalaran"
		.buy 1 Recipe: Critter Bites##43029
		.buy 1 Recipe: Hearty Rhino##43030
		.buy 1 Recipe: Snapper Extreme##43031
		.buy 1 Recipe: Blackened Worg Steak##43032
		.buy 1 Recipe: Cuttlesteak##43033
		.buy 1 Recipe: Spiced Mammoth Treats##43034
		.buy 1 Recipe: Blackened Dragonfin##43035
		.buy 1 Recipe: Dragonfin Fillet##43036
		.buy 1 Recipe: Tracker Snacks##43037
		.buy 1 Recipe: Gigantic Feast##43505
		.buy 1 Recipe: Small Feast##43506
		.buy 1 Recipe: Fish Feast##43017
	step
		'Use the Professions section of this guide to get to 450 cooking |only if skill("Cooking")<450
		.learn Critter Bites##57435 |use Recipe: Critter Bites##43029
		.learn Hearty Rhino##57436 |use Recipe: Hearty Rhino##43030
		.learn Snapper Extreme##57437 |use Recipe: Snapper Extreme##43031
		.learn Blackened Worg Steak##57438 |use Recipe: Blackened Worg Steak##43032
		.learn Cuttlesteak##57439 |use Recipe: Cuttlesteak##43033
		.learn Spiced Mammoth Treats##57440 |use Recipe: Spiced Mammoth Treats##43034
		.learn Blackened Dragonfin##57441 |use Recipe: Blackened Dragonfin##43035
		.learn Dragonfin Fillet##57442 |use Recipe: Dragonfin Fillet##43036
		.learn Tracker Snacks##57443 |use Recipe: Tracker Snacks##43037
		.learn Gigantic Feast##58527 |use Recipe: Gigantic Feast##43505
		.learn Small Feast##58528 |use Recipe: Small Feast##43506
		.learn Fish Feast##57423 |use Recipe: Fish Feast##43017
	step
		'You can either buy these from the Auction House or farm them
		.collect 1 Barrelhead Goby##41812
		.collect 4 Bonescale Snapper##41808
		.collect 5 Chilled Meat##43013
		.collect 8 Chunk o' Mammoth##34736
		.collect 2 Deep Sea Monsterbelly##41800
		.collect 2 Dragonfin Angelfish##41807
		.collect 1 Essence of Undeath##12808
		.collect 2 Fangtooth Herring##41810
		.collect 6 Glacial Salmon##41809
		.collect 2 Imperial Manta Ray##41809
		.collect 1 Moonglow Cuttlefish##41801
		.collect 1 Mote of Shadow##22577
		.collect 4 Musselback Sculpin##41806
		.collect 6 Nettlefish##51813
		.collect 1 Northern Egg##43501
		.collect 23 Northern Spices##43007
		.collect 7 Rhino Meat##43012
		.collect 3 Rockfin Grouper##41803
		.collect 4 Shoveltusk Flank##43009
		.collect 3 Succulent Clam Meat##36782
		.collect 5 Worg Haunch##43011
		.collect 5 Worm Meat##43010
	step
		goto Stormwind City 77.6,53.1
		.talk Erika Tate##5483
		.buy 2 Simple Flour##30817
	step
		goto Stormwind City 60.8,74.8
		.talk Innkeeper Allison##6740
		.buy 2 Tundra Berries##35949
		.buy 1 Savory Snowplum##35948
	step
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Bad Clams##58523,Cooking,1 total
		.' Cook Bad Clams |achieve 1777/1
	step
		'create Baked Manta Ray##45569,Cooking,1 total
		.' Cook Baked Manta Ray |achieve 1777/2
	step
		.create Blackened Dragonfin##57441,Cooking,1 total
		.' Cook Blackened Dragonfin |achieve 1777/3
	step
		.create Blackened Worg Steak##57438,Cooking,1 total
		.' Cook Blackened Worg Steak |achieve 1777/4
	step
		.create Critter Bites##57435,Cooking,1 total
		.' Cook Critter Bites |achieve 1777/5
	step
		.create Cuttlesteak##57439,Cooking,1 total
		.' Cook Cuttlesteak |achieve 1777/6
	step
		.create Dalaran Clam Chowder##58065,Cooking,1 total
		.' Cook Dalaran Clam Chowder |achieve 1777/7
	step
		.create Dragonfin Filet##57442,Cooking,1 total
		.' Cook Dragonfin Filet |achieve 1777/8
	step
		.create Firecracker Salmon##45568,Cooking,1 total
		.' Cook Firecracker Salmon |achieve 1777/9
	step
		.create Fish Feast##57423,Cooking,1 total
		.' Cook Fish Feast |achieve 1777/10
	step
		.create Gigantic Feast##58527,Cooking,1 total
		.' Cook Gigantic Feast |achieve 1777/11
	step
		.create Great Feast##45554,Cooking,1 total
		.' Cook Great Feast |achieve 1777/12
	step
		.create Grilled Bonescale##45561,Cooking,1 total
		.' Cook Grilled Bonescale |achieve 1777/13
	step
		.create Grilled Sculpin##45563,Cooking,1 total
		.' Cook Grilled Sculpin |achieve 1777/14
	step
		.create Haunted Herring##58525,Cooking,1 total
		.' Cook Haunted Herring |achieve 1777/15
	step
		.create Hearty Rhino##57436,Cooking,1 total
		.' Cook Hearty Rhino |achieve 1778/16
	step
		.create Imperial Manta Steak##45570,Cooking,1 total
		.' Cook Imperial Manta Steak |achieve 1778/17
	step
		.create Kungaloosh##53056,Cooking,1 total
		.' Cook Kungaloosh |achieve 1778/18
	step
		.create Last Week's Mammoth##58521,Cooking,1 total
		.' Cook Last Week's Mammoth |achieve 1778/19
	step
		.create Mammoth Meal##45549,Cooking,1 total
		.' Cook Mammoth Meal |achieve 1778/20
	step
		.create Mega Mammoth Meal##45555,Cooking,1 total
		.' Cook Mega Mammoth Meal |achieve 1778/21
	step
		.create Mighty Rhino Dogs##45559,Cooking,1 total
		.' Cook Mighty Rhino Dogs |achieve 1778/22
	step
		.create Northern Stew##57421,Cooking,1 total
		.' Cook Northern Stew |achieve 1778/23
	step
		.create Pickeled Fangtooth##45566,Cooking,1 total
		.' Cook Pickeled Fangtooth |achieve 1778/24
	step
		.create Poached Nettlefish##45565,Cooking,1 total
		.' Cook Poached Nettlefish |achieve 1778/25
	step
		.create Poached Northern Sculpin##45567,Cooking,1 total
		.' Cook Poached Northern Sculpin |achieve 1778/26
	step
		.create Rhino Dogs##45553,Cooking,1 total
		.' Cook Rhino Dogs |achieve 1778/27
	step
		.create Rhinolicious Wormsteak##57434,Cooking,1 total
		.' Cook Rhinolicious Wormsteak |achieve 1778/28
	step
		.create Roasted Worg##45552,Cooking,1 total
		.' Cook Roasted Worg |achieve 1778/29
	step
		.create Sauteed Goby##45562,Cooking,1 total
		.' Cook Sauteed Goby |achieve 1778/30
	step
		.create Shoveltusk Steak##45550,Cooking,1 total
		.' Cook Shoveltusk Steak |achieve 1779/31
	step
		.create Small Feast##58528,Cooking,1 total
		.' Cook Small Feast |achieve 1779/32
	step
		.create Smoked Rockfin##45560,Cooking,1 total
		.' Cook Smoked Rockfin |achieve 1779/33
	step
		.create Smoked Salmon##45564,Cooking,1 total
		.' Cook Smoked Salmon |achieve 1779/34
	step
		.create Snapper Extreme##57437,Cooking,1 total
		.' Cook Snapper Extreme |achieve 1779/35
	step
		.create Spiced Mammoth Treats##57440,Cooking,1 total
		.' Cook Spiced Mammoth |achieve 1779/36
	step
		.create Spiced Worm Burger##45557,Cooking,1 total
		.' Cook Spiced Worm Burger |achieve 1779/37
	step
		.create Spicy Blue Nettlefish##45571,Cooking,1 total
		.' Cook Spicy Blue Nettlefish |achieve 1779/38
	step
		.create Spicy Fried Herring##57433,Cooking,1 total
		.' Cook Spicy Fried Herring |achieve 1779/39
	step
		.create Tasty Cupcake##58512,Cooking,1 total
		.' Cook Tasty Cupcake |achieve 1779/40
	step
		.create Tender Shoveltusk Steak##45556,Cooking,1 total
		.' Cook Tender Shoveltusk Steak |achieve 1779/41
	step
		.create Tracker Snacks##57443,Cooking,1 total
		.' Cook Tracker Snacks |achieve 1779/42
	step
		.create Very Burnt Worg##45558,Cooking,1 total
		.' Cook Very Burnt Worg |achieve 1779/43
	step
		.create Worg Tartare##62350,Cooking,1 total
		.' Cook Worg Tartare |achieve 1779/44
	step
		.create Worm Delight##45551,Cooking,1 total
		.' Cook Worm Delight |achieve 1779/45
		..' Cook 45 of the Northrend recipes |achieve 1779
	step
		'Congratulations! You've earned the Northrend Gourment achievement!
]])

ZygorGuidesViewer:RegisterInclude("A_Our_Daily_Bread",[[
	step
	label "begin"
	title +Dalaran Cooking Dailies
		goto Dalaran,70.0,39.0
		.talk Awilo Lon'gomba##29631
		.' You will only be able to accept, and turn in, 1 of these 5 daily quests per day, and they all require you have 350+ Cooking skill:
		..accept Cheese for Glowergold##13115 |or
		..accept Convention at the Legerdemain##13113 |or
		..accept Infused Mushroom Meatloaf##13112 |or
		..accept Mustard Dogs!##13116 |or
		..accept Sewer Stew##13114 |or
	step
		goto Dalaran,40.8,65.4
		.talk Katherine Lee##28705
		.' You will only be able to accept, and turn in, 1 of these 5 daily quests per day, and they all require you have 350+ Cooking skill:
		..accept Cheese for Glowergold##13103 |or
		..accept Convention at the Legerdemain##13101 |or
		..accept Infused Mushroom Meatloaf##13100 |or
		..accept Mustard Dogs!##13107 |or
		..accept Sewer Stew##13102 |or
	step
		goto 54.7,31.5
		.' Click the Aged Dalaran Limburger|tip They look like piles and pieces of yellow cheese on the tables inside this building.
		.collect 1 Aged Dalaran Limburger##43137 |q 13103
		.' Click the Half Full Glasses of Wine|tip They look like small blue-ish wine glasses sitting on tables, and on the ground, inside this building.  They spawn in random locations.
		.collect 6 Half Full Dalaran Wine Glass##43138 |q 13103
		.' You can find more Half Full Glasses of Wine inside the building at [49.4,39.3]
	step
		'Use your Empty Cheese Serving Platter in your bags|use Empty Cheese Serving Platter##43139
		.get 1 Wine and Cheese Platter |q 13103/1
	step
		goto 55.0,30.8
		.' Click a Full Jug of Wine|tip They look like small blue-ish green jugs sitting on the ground inside this building.  They spawn in random locations.
		.get 1 Jug of Wine |q 13101/2
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 4 Chilled Meat##43013 |q 13101
	step
		'Use your Cooking ability to cook 4 Northern Stew|tip You will need a cooking fire to do this.
		.get 4 Northern Stew |q 13101/1
	step
		'The entrance to the Dalaran sewers starts here|goto Dalaran,60.2,47.7,0.3|c|q 13100
	step
		goto Dalaran/2 59.5,43.6
		.from Underbelly Rat##32428+
		.collect 4 Infused Mushroom##43100 |q 13100
	step
		'Leave the Dalaran sewers|goto Dalaran,60.2,47.7,0.3|c|q 13100
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 2 Chilled Meat##43013 |q 13100
	step
		'Use your Meatloaf Pan in your bags|use Meatloaf Pan##43101|tip You will need a cooking fire to do this.
		.get 1 Infused Mushroom Meatloaf |q 13100/1
	step
		goto Dalaran,67.7,40.0
		.' Click the Wild Mustard|tip They look like small, and kind of hard to see, bushy yellow flowers on the ground around this area.  They spawn randomly in grassy areas.
		.collect 4 Wild Mustard##43143 |q 13107
		.' You can find more Wild Mustard flowers:
		..' at [50.3,48.3]
		..' at [37.2,43.9]
	step
		goto Borean Tundra,46.7,43.6
		.from Wooly Rhino Calf##25488+, Wooly Rhino Matriarch##25487+, Wooly Rhino Bull##25489+
		.collect 4 Rhino Meat##43012 |q 13107
	step
		'Use your Cooking ability to cook 4 Rhino Dogs|tip You will need a cooking fire to do this.
		.collect 4 Rhino Dogs##34752 |q 13107
	step
		'Use your Empty Picnic Basket in your bags|use Empty Picnic Basket##43142
		.get 1 Mustard Dog Basket! |q 13107/1
	step
		goto Crystalsong Forest,26.9,45.5
		.' Click the Crystalsong Carrots|tip they look like carrots sticking out of the ground, at the base of trees around this area underneath Dalaran.  They spawn in random locations around this area.
		.collect 4 Crystalsong Carrot##43148 |q 13102
	step
		goto Dragonblight,30.0,49.8
		.from Rabid Grizzly##26643+, Blighted Elk##26616+
		.collect 4 Chilled Meat##43013 |q 13102
	step
		'Use your Stew Cookpot in your bags|use Stew Cookpot##43147|tip You will need a cooking fire to do this.
		.get 1 Vegetable Stew |q 13102/1
	step
		goto Dalaran,36.6,27.8
		.talk Ranid Glowergold##28718
		..turnin Cheese for Glowergold##13103
	step
		goto Dalaran,48.6,37.5
		.talk Arille Azuregaze##29049
		..turnin Convention at the Legerdemain##13101
	step
		goto Dalaran,52.3,55.6
		.talk Orton Bennet##29527
		..turnin Infused Mushroom Meatloaf##13100
	step
		goto Dalaran,68.6,42.0
		.talk Archmage Pentarus##28160
		..turnin Mustard Dogs!##13107
	step
		'The entrance to the Dalaran sewers starts here|goto Dalaran,60.2,47.7,0.3|c|q 13102
	step
		goto Dalaran,35.5,57.6
		.talk Ajay Green##29532
		..turnin Sewer Stew##13102
	step
		'You have completed the daily quest for today.
		.' Click here to go back to the beginning of the guide. |confirm |next "begin"
		|next |only if achieved(1782)
	step
		'Congratulations, you have obtained the Our Daily Bread achievement!
]])

ZygorGuidesViewer:RegisterInclude("A_Critter_Gitter",[[
	step
		'You can either buy these from the Auction House or farm them
		.collect 10 Critter Bites##43004
		.' Click here to go farm for these |confirm |next "farm1"
		|next "gitter"
	step
	label farm1
		'You can either buy these from the Auction House or farm them
		.collect 20 Chilled Meat##43013
		.collect 10 Northern Spices##43007
		.' Click here to go farm for these |confirm |next "farm2"
		|next "make"
	step
	label farm2
	title +Chilled Meat
		goto Borean Tundra,78.2,24.0
		.from Scourged Mammoth##25452+
		.collect 20 Chilled Meat##43013
	step
	title +Northern Spices
		'Use the Dalaran Cooking Dailies section of this guide to get Small Spice Bags
		.collect Spice Bag##44113 |n
		.collect 10 Northern Spices##43007
	step
	label make
	title +Critter Gitter
		'Get someone to make your 10 Critter Bites |tip Ask in your guild or in trade for someone to make these. Be sure to tip well!
		.' Or... |only if skill("Cooking")>=400
		'Build a Basic Campfire |cast Basic Campfire##818 |only if skill("Cooking")>=400
		.create Critter Bites##57435,Cooking,10 total |only if skill("Cooking")>=400
		.collect 10 Critter Bites##43004
		.' Click here if you don't have the recipe |confirm |next "recipe" |only if skill("Cooking")>=400
		|next "gitter"
	step
	label recipe
		'Use the Dalaran Cooking Dailies section of this guide to earn 3 Dalaran Cooking Awards
		.earn 3 Dalaran Cooking Award##81
	step
		goto Dalaran,70.2,37.2
		.talk Misensi##31031
		.buy 1 Recipe: Critter Bites##43029
	step
		.learn Critter Bites##57435
	step
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Critter Bites##57435,Cooking,10 total
		.collect 10 Critter Bites##43004
	step
	label gitter
		goto Eastern Plaguelands,4.7,35.5
		'Target the Beetles, Scorpions, and Cockroaches and use the Critter Bites on them |use Critter Bites##43004
		|tip Use all 10 Critter Bites as quick as possible. These critters are scattered all throughout the tunnel.
		.' Coerce 10 critters to be your pet within 3 minutes or less |achieve 1781
	step
		'Congratulations! You've earned the Critter Gitter achievement!
]])

ZygorGuidesViewer:RegisterInclude("A_Dinner_Impossible",[[
	step
		'You can either buy these items from the auction house or use the Cooking professions guide to reach level 375 Cooking, otherwise you cannot complete this achievement. |only if skill("Cooking")<375
		'You can either buy these items from the auction house or farm them |only if skill("Cooking")>=375
		.collect 5 Great Feast##34753
		.' Click here to go farm these materials |confirm |next "farm1"
		|next usefeast
	step
		#include trainCooking
		.learn Great Feast##45554
	step
	label farm1
		'You can either buy these items from the auction house or farm them
		.collect 5 Chunk o'Mammoth##34736
		.collect 5 Shoveltusk Flank##43009
		.collect 5 Worm Meat##43010
		.collect 10 Chilled Meat##43013
		.' Click here to go farm these materials |confirm |next "farm2"
		|next makefeast
	step
	label farm2
		goto 78.2,24.0
		.from Scourged Mammoth##25452+
		.collect 5 Chunk o'Mammoth##34736
		.collect 10 Chilled Meat##43013
	step
		goto 76.2,23.0
		.from Tundra Crawler##25454+
		.collect 5 Worm Meat##43010
	step
		goto Howling Fjord 73.6,40.0
		.from Shoveltusk##23690+
		.collect 5 Shoveltusk Flank##43009
	step
	label makefeast
		'Have someone make the Great Feasts for you |tip Ask in your guild or in trade for someone to make these |only if skill("Cooking")<375
		'Create a basic campfire |cast Basic Campfire##818 |only if skill("Cooking")>=375
		.create 5 Great Feast##45554,Cooking,4 total |only if skill("Cooking")>=375
		.collect 5 Great Feast##34753
	step
	label usefeast
		'Push [H] on your keyboard to open your Player vs. Player interface
		.' Click on Alterac Valley and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept
		..' Go to Alterac Valley |goto Alterac Valley |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753
		.' Present a Great Feast in Alterac Valley |achieve 1785/1 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push [H] on your keyboard to open your Player vs. Player interface
		.' Click on Arathi Basin and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept
		..' Go to Arathi Basin |goto Arathi Basin |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753
		.' Present a Great Feast in Arathi Basin |achieve 1785/2 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push the [H] key on your keyboard to open your Player vs. Player interface
		.' Click on Warsong Gulch and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept
		..' Go to Warsong Gulch |goto Warsong Gulch |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753
		.' Present a Great Feast in Warsong Gulch |achieve 1785/3 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push [H] on your keyboard to open your Player vs. Player interface
		.' Click on Strand of the Ancients and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept
		..' Go to Strand of the Ancients |goto Strand of the Ancients |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753
		.' Present a Great Feast in Strand of the Ancients |achieve 1785/4 |tip You can leave the battleground now, but you will have to wait 15 minutes to complete the next step
	step
		'Push [H] on your keyboard to open your Player vs. Player interface
		.' Click on Arathi Basin and then click on the Join Battle button on the lower left-hand corner of the Player vs. Player interface
		..' Wait for the que to pop-up in the middle of your screen and click on accept
		..' Go to Eye of the Storm |goto Arathi Basin |noway |c
	step
		'Use one of your Great Feasts |use Great Feast##34753
		.' Present a Great Feast in Eye of the Storm |achieve 1785/5
	step
		Congratulations! You've earned the Dinner Impossible achievement!
]])

ZygorGuidesViewer:RegisterInclude("A_Captain_Rumsey's_Lager",[[
	step
		'Use the Shattrath or Dalaran Cooking Dailies, or the Fishing Dailies of this guide to get this recipe: |tip It's not always guarenteed to come from these daily prizes so be patient
		.collect 1 Recipe: Captain Rumsey's Lager##34834
	step
		.learn Captain Rumsey's Lager##45695 |use Recipe: Captain Rumsey's Lager##34834
	step
		goto Stormwind City,76.3,53.0
		.talk Reese Langston##1327
		.buy 1 Flask of Port##2593
		.buy 1 Flagon of Mead##2594
		.buy 1 Skin of Dwarven Stout##2596
	step
		.create Captain Rumsey's Lager##45695,Cooking,1 total
		.' Brew up Captain Rumsey's Lager |achieve 1801
	step
		'Congratulations! You've earned the Captain Rumsey's Lager achievement!
]])

ZygorGuidesViewer:RegisterInclude("A_MOP_Cooking_Dailies",[[
		'Proceeding to Cooking School Bell |only if completedq(31521)
		'Proceeding to Cooking Dailies |only if not completedq(31521) |next dailies
	step
		'Use the Cooking School Bell in your Bags |use Cooking School Bell##86425
		'If you do not have this yet, you can buy it from Nam Ironpaw here: [Valley of the Four Winds 53.6,51.2]
		.talk Nomi##64337
		..accept Lesson 1: Sliced Peaches##31332
		'|modelnpc Nam Ironpaw##64395
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Pandaren Peach##74660 |q 31332/1
	step
		'Use the Cooking School Bell in your Bags |use Cooking School Bell##86425
		.talk Nomi##64337
		..turnin Lesson 1: Sliced Peaches##31332
	step
	label	dailies
		goto Valley of the Four Winds 53.4,51.6
		.talk Jian Ironpaw##58716
		..accept The Truffle Shuffle##30330
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 53.0,51.3
		.talk Kol Ironpaw##58712
		..accept Fatty Goatsteak##30332
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 52.5,51.7
		.talk Yan Ironpaw##58715
		..accept The Thousand-Year Dumpling##30328
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 52.8,51.8
		.talk Anthea Ironpaw##58713
		..accept Cindergut Peppers##30329
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 52.6,51.6
		.talk Mei Mei Ironpaw##58714
		..accept The Mile-High Grub##30331
		.'_
		.' Click here if this quest is not available today |confirm
	step
		goto 32.5,23.9
		.' Use the _Master's Pot_ in your bags next to the bonfire. |use Master's Pot##79895
		.' Create 20 Mushan Tail Stew |q 30331/1
		|only if havequest(30331)
	step
		goto 31.2,36.0
		.from Kunzen Hunter##59121+, Kunzen Herdskeeper##59122+, Kunzen Ritualist##+59123, Kunzen Rockflinger##59120+,Kunzen Collector##59124+
		.collect 4 Cindergut Pepper##79864
		|only if havequest(30329)
	step
		goto 44.0,22.2 |n
		.' Enter the cave here |goto 44.0,22.2 <5 |noway |c
		|only if havequest(30328)
	step
		.click Preserved Vegetable##11054+
		.get 7 Preserved Vegetables |q 30328/1
		|only if havequest(30328)
	step
		goto 28.5,33.3
		.click Shadelight Truffle##11275+
		|tip You can find these aruond the trees here
		.get 8 Shadelight Truffle |q 30330/2
		.' Use your Shadelight Truffles in your bag |use Shadelight Truffle Spores##80127
		.' Plant 8 Shadelight Spores |q 30330/1
		|only if havequest(30330)
	step
		goto Valley of the Four Winds 29.7,41.4
		.from Stout Shaghorn##59139+
		.get 4 Fatty Goatsteak |q 30332/1
		|only if havequest(30332)
	step
		goto Valley of the Four Winds 52.8,51.8
		.talk Anthea Ironpaw##58713
		..turnin Cindergut Peppers##30329
	step
		goto Valley of the Four Winds 53.4,51.6
		.talk Jian Ironpaw##58716
		..turnin The Truffle Shuffle##30330
	step
		goto 52.5,51.7
		.talk Yan Ironpaw##58715
		..turnin The Thousand-Year Dumpling##30328
	step
		goto 53.0,51.3
		.talk Kol Ironpaw##58712
		..turnin Fatty Goatsteak##30332
	step
		goto 52.6,51.6
		.talk Mei Mei Ironpaw##58714
		..turnin The Mile-High Grub##30331
	step
		'You have reached the end of the dailies for today.
		'Click here to go back to the beginning of the Pandaria Cooking Dailies |confirm |next "dailies"
]])

ZygorGuidesViewer:RegisterInclude("Nomi_Dailies",[[
	step
	label "nomistart"
		.' Use Cooking School Bell##86425
		.' Talk to Nomi, standing next to you. |use
		..accept Lesson 1: Sliced Peaches##31332 |or
		..accept Lesson 2: Instant Noodles##31333 |or
		..accept Lesson 3: Toasted Fish Jerky |or
		..accept Lesson 4: Dried Needle Mushrooms |or
		..accept Lesson 5: Pounded Rice Cake |or
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Pandaren Peach##31332 |q 31332/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Instant Noodles##74854 |q 31333/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Golden Carp##74866 |q 31334/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Needle Mushrooms##85583 |q 31335/1
	step
		goto Valley of the Four Winds 53.6,51.2
		.talk Sungshin Ironpaw##64231
		.buy 5 Rice##74851 |q 31336/1
	step
		.' Talk to Nomi, standing next to you.
		..turnin Lesson 1: Sliced Peaches##31332 |or
		..turnin Lesson 2: Instant Noodles##31333 |or
		..turnin Lesson 3: Toasted Fish Jerky |or
		..turnin Lesson 4: Dried Needle Mushrooms |or
		..turnin Lesson 5: Pounded Rice Cake |or
	step
		'You have reached the end of the dailies for today.
		'Click here to go back to the beginning of the Nomi Cooking Dailies |confirm |next "nomistart"
]])

ZygorGuidesViewer:RegisterInclude("second_that_emotion",[[
	step
		'You can either purchase these from the Auction House or farm for them:
		.collect 1 Bad Clams##43491
		.collect 1 Haunted Herring##43492
		.collect 1 Last Week's Mammoth##43488
		.collect 1 Tasty Cupcake##43490
		.' Click here to go farm for these |confirm |next "farm1"
		|next "eat"
	step
	label farm1
		'You can either purchase these from the Auction House or farm for them:
		.collect 1 Succulent Clam Meat##36782
		.collect 1 Mote of Shadow##22577
		.collect 1 Chunk o' Mammoth##34736
		.collect 1 Northern Egg##43501
		.collect 1 Fangtooth Herring##41810
		.collect 1 Essence of Undeath##12808
		.' Click here to go farm for these ||confirm |next "farm2"
		|next "make"
	step
	label farm2
	title +Succulent Clam Meat
		goto Borean Tundra,41.2,17.6
		.from Winterfin Warrior##25217+
		.collect Darkwater Clam##36781 |n
		'Open the Darkwater Clams in your bags |use Darkwater Clam##36781
		.collect 1 Succulent Clam Meat##36782
	step
	title +Chunk o' Mammoth
		goto Borean Tundra,78.2,24.0
		.from Scourged Mammoth##25452+
		.collect 1 Chunk o' Mammoth##34736
	step
	title +Northern Egg
		goto Borean Tundra,85.2,36.2
		.from Carrion Condor##26174
		.collect 1 Northern Egg##43501
	step
	title +Fangtooth Herring (Requires Fishing)
		goto Howling Fjord,60.2,33.6
		'Fish at this spot
		.collect 1 Fangtooth Herring##41810
	step
	title +Essence of Undeath
		goto Western Plaguelands,69.1,73.0 |n
		.' Enter Scholomance here |goto Scholomance |noway |c
	step
		'Kill all undead mobs in the dungeon
		.collect 1 Essence of Undeath##12808
	step
	title +Second That Emotion
	label make
		'Get someone to make your Bad Clams, Last Week's Mammoth, Haunted Herring, and Tasty Cupcake |tip Ask in your guild or in trade for someone to make these. Be sure to tip well! |only if skill("Cooking")<350
		'Make your Bad Clams, Last Week's Mammoth, Haunted Herring, and Tasty Cupcake |only if skill("Cooking")>=350
		'Build a Basic Campfire |cast Basic Campfire##818 |only if skill("Cooking")>=350
		.create Haunted Herring##58525,Cooking,1 total |only if skill("Cooking")>=350
		.create Bad Clams##58523,Cooking,1 total |only if skill("Cooking")>=350
		.create Last Week's Mammoth##58521,Cooking,1 total |only if skill("Cooking")>=350
		.create Tasty Cupcake##58512,Cooking,1 total |only if skill("Cooking")>=350
		.collect 1 Haunted Herring##43492
		.collect 1 Bad Clams##43491
		.collect 1 Last Week's Mammoth##43488
		.collect 1 Tasty Cupcake##43490
		.' Click here if you don't have these recipes |confirm |next "recipes" |only if skill("Cooking")>=350
		|next "eat"
	step
	label recipes
		goto Borean Tundra,54.6,70.0
		.from Crypt Crawler##25227
		.collect 1 Recipe: Bad Clams##43509
		.collect 1 Recipe: Last Week's Mammoth##43508
		.collect 1 Recipe: Haunted Herring##43510
		.collect 1 Recipe: Tasty Cupcake##43507
	step
		.learn Bad Clams##58523 |use Recipe: Bad Clams##43509
		.learn Haunted Herring##58525 |use Recipe: Haunted Herring##43510
		.learn Last Week's Mammoth##58521 |use Recipe: Last Week's Mammoth##43508
		.learn Tasty Cupcake##58512 |use Recipe: Tasty Cupcake##43507
	step
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Haunted Herring##58525,Cooking,1 total
		.create Bad Clams##58523,Cooking,1 total
		.create Last Week's Mammoth##58521,Cooking,1 total
		.create Tasty Cupcake##58512,Cooking,1 total
		.collect 1 Haunted Herring##43492
		.collect 1 Bad Clams##43491
		.collect 1 Last Week's Mammoth##43488
		.collect 1 Tasty Cupcake##43490
	step
	label eat
		'Eat the Haunted Herring to become scared |use Haunted Herring##43492
		.' Eat Haunted Herring |achieve 1780/2
	step
		'Eat the Bad Clams to become angry |use Bad Clams##43491
		.' Eat Bad Clams |achieve 1780/1
	step
		'Eat the Last Week's Mammoth to become sad |use Last Week's Mammoth##43488
		.' Eat Last Week's Mammoth |achieve 1780/3
	step
		'Eat the Tasty Cupcake to become happy! |use Tasty Cupcake##43490
		.' Eat Tasty Cupcake |achieve 1780/4
		..' Eat each one of the "emotion" foods |achieve 1780
]])

ZygorGuidesViewer:RegisterInclude("the_cake_is_not_a_lie",[[
	step
		'Complete dailies in Shattrath City until you get the recipe for the Delicious Chocolate Cake:
		|confirm
	step
		'Routing to the proper section |next "create" |only if _G.IsSpellKnown(43779)
		'Routing to the proper section |next "dailies" |only if default
	step
	label "dailies"
		goto Shattrath City,61.8,15.6
		.talk The Rokk##24393
		.' You will only be able to accept one of these daily quests per day
		..accept Soup for the Soul##11381 |or |next "soup"
		..accept Super Hot Stew##11379 |or |next "stew"
		..accept Manalicious##11380 |or |next "mana"
		..accept Revenge is Tasty##11377 |or |next "tasty"
	step
	label "soup"
		goto Nagrand,56.2,73.3
		.talk Uriku##20096
		.buy Recipe: Roasted Clefthoof##27691 |n
		.' Click the Recipe: Roasted Clefthoof in your bags |use Recipe: Roasted Clefthoof##27691
		.learn Roasted Clefthoof##33287 |q 11381
	step
		goto Nagrand,58.5,46.8
		.from Clefthoof##18205+, Clefthoof Calf##19183+
		.collect 4 Clefthoof Meat##27678 |q 11381
		.' You can find more Clefthooves at  45.5,72.7
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create Roasted Clefthoof##33287,Cooking,4 total |q 11381
	step
		goto 25.9,59.4
		.' Use your Cooking Pot to Cook up some Spiritual Soup |use Cooking Pot##33851
		.' Cook a Spiritual Soup |q 11381/1
		|next "turnin"
	step
	label "stew"
		goto Blade's Edge Mountains,62.5,40.3
		.talk Xerintha Ravenoak##20916
		.buy Recipe: Mok'Nathal Shortribs##31675 |n
		.' Click the Recipe: Mok'Nathal Shortribs in your bags |use Recipe: Mok'Nathal Shortribs##31675
		.learn Mok'Nathal Shortribs##31672 |q 11379
		.buy Recipe: Crunchy Serpent##31674 |n
		.' Click the Recipe: Crunchy Serpent in your bags |use Recipe: Mok'Nathal Shortribs##31674
		.learn Crunchy Serpent##31673 |q 11379
	step
		goto Blade's Edge Mountains,49.6,46.2
		.from Daggermaw Blackhide##22052+, Bladespire Raptor##20728+
		.collect 4 Raptor Ribs##31670+ |q 11379
	step
		goto 68.2,63.2
		.from Scalewing Serpent##20749+, Felsworn Scalewing##21123+
		.collect 1 Serpent Flesh##31671 |q 11379
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create 2 Mok'Nathal Shortribs##38867,Cooking,2 total |q 11379
	step
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create 1 Crunchy Serpent##38868,Cooking,1 total |q 11379
	step
		goto 29.0,84.5
		.from Abyssal Flamebringer##19973+
		.' Use your Cooking Pot next to the Abyssal Flamebringer corpse to Cook up some Demon Broiled Surprise |use Cooking Pot##33852
		.get Demon Broiled Surprise |q 11379/1
		|next "turnin"
	step
	label "mana"
		goto Netherstorm,45.6,54.2
		.click Mana Berry Bush##186729+
		.get 15 Mana Berry##33849+ |q 11380/1
		|next "turnin"
	step
	label "tasty"
		goto Terokkar Forest,55.8,53.0
		.talk Supply Officer Mills##19038
		.buy Recipe: Warp Burger##27692 |n
		.' Click the Recipe: Warp Burger in your bags |use Recipe: Warp Burger##27692
		.learn Warp Burger##33288 |q 11377
	step
		goto 64.0,83.5
		.from Blackwind Warp Chaser##23219+
		.collect 3 Warped Flesh##27681 |q 11377
	step
		goto 67.6,74.7
		.from Monstrous Kaliri##23051+ |tip They fly around in the sky close to the tree outposts and bridges.
		.collect Giant Kaliri Wing##33838 |q 11377
	step
		goto 25.9,59.5
		.' Build a Basic Campfire |cast Basic Campfire##818
		.create Warp Burger##33288,Cooking,3 total |q 11377
		.' Use your Cooking Pot to Cook up some Kaliri Stew |use Cooking Pot##33837
		.create Kaliri Stew##43718,Cooking,1 total |q 11377/1
		|next "turnin"
	step
	label "turnin"
		goto Shattrath City,61.8,15.6
		.talk The Rokk##24393
		..turnin Soup for the Soul##11381
		..turnin Super Hot Stew##11379
		..turnin Manalicious##11380
		..turnin Revenge is Tasty##11377
	step
		.' You have completed the maximum amount of Shattrath Cooking dailies you can do today.
		.collect Recipe: Delicious Chocolate Cake##33925 |n |tip You are not guaranteed to get this recipe - it is random, so try to have patience.
		.' Click the Recipe: Delicious Chocolate Cake |use Recipe: Delicious Chocolate Cake##33925
		.learn Delicious Chocolate Cake##43779
		.'_
		.' Click here to go back to the beginning of the dailies for today if you haven't received the cake pattern. |confirm |next "dailies"
	step
	label "create"
		goto Stormwind City 75.7,54.1
		.talk Maegan Tillman##44237
		.buy 4 Ice Cold Milk##1179
	step
		goto Stormwind City 76.3,53.0
		.talk Reese Langston##1327
		.buy 1 Flask of Port##2593
	step
		goto Stormwind City 77.6,53.0
		.talk Erika Tate##5483
		.buy 8 Simple Flour##30817
		.buy 4 Mild Spices##2678
	step
		'From the Auction House:
		.buy 3 Mageroyal##785
		.buy 8 Small Egg##6889 |next "HaveEggs"
		.' Or...
		.' Click this line if you would rather farm the Small Eggs |confirm
	step
		goto Westfall,55.8,30.2
		.from Fleshripper##1109+, Young Fleshripper##199+
		.collect 8 Small Egg##6889
		.' You can find more at [55.0,18.9]
	step
	label "HaveEggs"
		'Build a Basic Campfire |cast Basic Campfire##818
		.create Delicious Chocolate Cake##43779,Cooking,1 total |n
		.' Earn The Cake Is Not A Lie Achievement |achieve 877
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Fishing
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("A_Old_Gnome_and_the_Sea",[[
	step
		goto Redridge Mountains,27.6,48.7
		.' Look for Sagefish Schools in the water.  Walk along the lake in Lakeshire until you find one if you're unable to see one at this spot.
		.' It looks like a swarm of fish.
		.' Use you fishing skill until your lure is inside of the school of fish, then catch one. |cast Fishing##7620
		.' Earn The Old Gnome and the Sea Achievement. |achieve 153
	step
		'Congratulations! You've earned The Old Gnome and the Sea achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_The_Scavenger",[[
	step
		goto Zangarmarsh 57.0,56.0
		.' Look for Steam Pump Flotsam in the water around this area and fish from it |cast Fishing##7620
		.' Fish from Steam Pump Flotsam |achieve 1257/1
	step
		goto Northern Stranglethorn 55.0,64.0
		.' Look for Schooner Wreckage around this area |tip You may need to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Schooner Wreckage |achieve 1257/3
	step
		'Go to The Cape of Stranglethorn |goto The Cape of Stranglethorn 50,50 <500
	step
		goto 30.9,81.5
		.' Look for Bloodsail Wreckage around this area |tip You may need to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Bloodsail Wreckage |achieve 1257/2
	step
		goto Tanaris 67.4,38.2
		.' Look for Floating Wreckage around this area |tip You may have to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Floating Wreckage |achieve 1257/5
	step
		goto Feralas,63.1,51.5
		.' Look for Waterlogged Wreckage around this area |tip You may have to fish from other pools to get this to show up |cast Fishing##7620
		.' Fish from Waterlogged Wreckage |achieve 1257/4
	step
		.' Successfully fish in each of the junk nodes |achieve 1257
	step
		'Congratulations! You've earned The Scavenger achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_The_Fishing_Diplomat",[[
	step
		goto Stormwind City 69.0,92.2
		.' Use your fishing skill in the moat in front of Stormwind City |cast Fishing##7620
		.' Fish in Stormwind City |achieve 150/2
	step
		goto Northern Barrens,70.2,4.4 |n
		.' Cross the bridge over into Orgrimmar |goto Orgrimmar
	step
		goto Orgrimmar,24.8,62.8
		.' Use your fishing skill in the pond |cast Fishing##7620
		.' Fish in Orgrimmar |achieve 150/1
	step
		.' Earn The Fishing Diplomat. |achieve 150
	step
		'Congratulations! You've earned The Fishing Diplomat achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_Mr._Pinchy's_Magical_Crawdad_Box",[[
	step
		.' You will need track fishing in order to help you find Highland Mixed Schools.
		.learn Find Fish##43308  |next "HaveFishTracking"
		.' Click here if you _do not_ have Find Fish. |confirm
	step
		goto Zangarmarsh/0 60.4,44.7
		.' Search _Serpent Lake_ for _Steam pump Floatsam_.
		.' Use your fishing skill. |use Fishing Pole##6256
		.collect Heavy Supply Crate###27481+ |n
		.' Use the Heavy Supply Crates. |use Heavy Supply Crate###27481
		.collect Weather-Beaten Journal##34109
		.' Use your Weather-Beaten Journal to learn find fish. |use Weather-Beaten Journal##34109
		.learnspell Find Fish##43308
	step
	label "HaveFishTracking"
		goto Terokkar Forest,65.0,76.8
		.' Use your Find Fish ability to locate Highland Mixed Schools
		.' Use your fishing skill to fish in the pond |cast Fishing##7620
	step
		goto Terokkar Forest,63.4,76.9
		.' Fish around this large pool of water from Highland Mixed Schools.
		.' Additional Pools can be found at Lake Ere'Noru, [60.6,59.9]
		.' and Lake Jorune, [45.0,40.5]
		.collect Magical Crawdad Box##27445
		.' Earn the Mr. Pinchy's Magical Crawdad Box achievement. |achieve 726
	step
		'Congratulations! You've earned the Mr. Pinchy's Magical Crawdad Box achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_The_Lurker_Above",[[
	step
		.' In order to earn this achievement, you will need to be in a raid group.
		.' You will also need to be at least Level 70.
		.' It would be best if you picked up Elixirs of Water Walking
		.' You won't need a certain level of fishing, but the high level you are, the higher change you have of fishing up 'The Lurker Below'.
		.' Click here after you  have read the requirements for this achievement. |confirm
	step
		goto Zangarmarsh,50.4,41.0 |n
		.' Swim down underwater through the tube to the Coilfang Reservoir |goto 51.9,38.0 |c
	step
		 goto Serpentshrine Cavern,13.5,59.6
		 .' Ride the elevator down
		.' Click here once you're at the bottom and off of the elevator |confirm
	step
		goto Serpentshrine Cavern,19.6,68.5
		.' Walk up the ramp and ride the elevator up.
		.' Click here once you ride the elevator up. |confirm
	step
		goto Serpentshrine Cavern,22.7,72.8 |n
		.' Use your water walking potion and jump into the water. |use Elixir of Water Walking##8827
		.' If you jump into the water without water walking, fish will attack you and you will have to kill them before using your Elixir.
		.' Walk over to the wooden circle with the Strange pool in the center |goto Serpentshrine Cavern,38.6,59.5 |c
	step
		.' Once you're there, use your fishing ability and make sure that your lure lands in the Strange Pool. |cast Fishing##7620
		.' Earn The Lurker Above Achievement. |achieve 144
	step
		'Congratulations! You've earned The Lurker Above achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_Old_Man_Barlowned",[[
	step
		.' In order the earn this achievement, you will need to have completed these 5 daily quests:
		.' Crcolisks in the City |achieve 905/1
		.' Bait Bandits |achieve 905/2
		.' Felblood Fillet |achieve 905/3
		.' The One That Got Away |achieve 905/4
		.' Shrimpin' Ain't Easy |achieve 905/5
		.' Click here to proceed |confirm
	step
		goto Terokkar Forest,38.7,12.8
		.talk Old Man Barlo##25580
		.' You will only be able to pick up 1 of 5 dailies per day.
		.accept Crocolisks in the City##11665 |or
		.accept Bait Bandits##11666 |or
		.accept Felblood Fillet##11669 |or
		.accept The One That Got Away##11667 |or
		.accept Shrimpin' Ain't Easy##11668 |or
	step
		goto Stormwind City,54.9,69.7
		.' Use your Fishing skill to fish in the water all around the wooden dock |cast Fishing##7620
		..get Baby Crocolisk##34864 |q 11665/1
		only if havequest(11665)
	step
		goto Terokkar Forest,51.8,37.2
		.' Fish in the river here |cast Fishing##7620
		..get Blackfin Darter##34865 |q 11666/1
		only if havequest(11666)
	step
		goto Nagrand,37.4,47.1
		.' Use your fishing ability to fish in the lake. |cast Fishing##7620
		..get World's Largest Mudfish##34868 |q 11667/1
		only if havequest(11667)
	step
		goto Zangarmarsh,77.9,79.7
		.' Fish from the Lake here |cast Fishing##7620
		.'Click the Bloated Barbed Gill Trout in your bags|use Bloated Barbed Gill Trout##35313
		..get Giant Freshwater Shrimp##34866 |q 11668/1
		only if havequest(11668)
	step
		goto Shadowmoon Valley,18.9,22.2
		.' Use your fishing ability in the green lava. |cast Fishing##7620
		..get Monstrous Felblood Snapper |q 11669/1
		only if havequest(11669)
	step
		goto Terokkar Forest,38.7,12.8
		.talk Old Man Barlo##25580
		.' You will only be able to pick up 1 of 5 dailies per day.
		.turnin Crocolisks in the City##11665 |or
		.turnin Bait Bandits##11666 |or
		.turnin Felblood Fillet##11669 |or
		.turnin The One That Got Away##11667 |or
		.turnin Shrimpin' Ain't Easy##11668 |or
	step
		.' Crocolisks in the City |achieve 905/1
		.' Bait Bandits |achieve 905/2
		.' Felblood Fillet |achieve 905/3
		.' The One That Got Away |achieve 905/4
		.' Shrimpin' Ain't Easy |achieve 905/5
	step
		.' Earn the Old Man Barlowned Achievement. |achieve 905
	step
		'Congratulations! You've earned the Old Man Barlowned achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_Outland_Angler",[[
	step
		.' In order to earn this achievement, you will need to fish from 6 different pools of fish in the Outlands.
		.' Click here to proceed. |confirm
	step
		goto Zangarmarsh,72.5,59.9
		.' Use your fishing skill on Sporefish School's around Umberfen Lake |cast Fishing##7620
		.' Fish from a Sporefish School |achieve 1225/6
	step
		goto Terokkar Forest,60.8,59.0 |n
		.' You will need to fly to reach the Highland Mixed Schools.  There are two more spots you can check for them below:
		.' The large Skettis Lake |goto 66.4,80.0 |n
		.' Lake Jorune |goto 45.9,39.5 |n
		.' Fish from a Highland Mixed School |achieve 1225/5
	step
		map Terokkar Forest
		path follow loose;loop off;ants straight // this stays until the end of the guide.
		path	 60.5,51.9	62.9,48.1	63.6,45.0
		path	 60.0,36.5
		.' Follow the stream until you find a School of Darters or Brackish Mixed School in the river.
		.' Use your fishing skill to fish from both Brackish Mixed or School of Darters
		.' Fish from a School of Darters |achieve 1225/4
		.' Fish from a Brackish Mixed School |achieve 1225/1
	step
		map Nagrand
		path follow loose;loop off;ants straight // this stays until the end of the guide.
		path	 47.2,44.4	48.7,45.3	51.1,43.2
		path	 50.9,47.6	48.8,48.1	47.4,48.6
		path	 46.5,47.6
		.' Follow the stream until you find a Bluefish and a Mudfish School.
		.' Use your fishing skill to fish from both a Bluefish and a Mudfish School |cast Fishing##7620
		.' Fish from a Bluefish School |achieve 1225/2
		.' Fish from a Mudfish School |achieve 1225/3
	step
		.' Earn the Outland Angler Achievement. |achieve 1225
	step
		'Congratulations! You've earned the Outland Angler achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_Northrend_Angler_Angler",[[
	step
		.' In order to earn this achievement, you will have to fish from 10 different schools of fish in Northrend.
		.' Click here to proceed. |confirm
	step
		.' Borean Man O'War School |achieve 1517/1
		.' Dragonfin Angelfish School |achieve 1517/2
		.' Glacial Salmon School |achieve 1517/3
		.' Imperial Manta Ray School |achieve 1517/4
		.' Musselback Sculpin School |achieve 1517/5
		.' Deep Sea Monsterbelly School |achieve 1517/6
		.' Fangtooth Herring School |achieve 1517/7
		.' Glassfin Minnow School |achieve 1517/8
		.' Moonglow Cuttlefish School |achieve 1517/9
		.' Neettlefish School |achieve 1517/10
		.' Click here to proceed. |confirm
	step
		map Borean Tundra
		path follow loose;loop off;ants straight // this stays until the end of the guide.
		path	54.3,75.2	49.5,79.0	45.8,80.9
		path	43.4,78.5	40.3,77.0
		.' Follow the coast until you find and Imperial Manta Ray and a Borean Man O' War School.  You mayb need to fish out other schools in order to force new ones to spawn.
		.' Fish from an Imperial Manta Ray School |achieve 1517/4 |cast Fishing##7620
		.' Fish from a Borean Man O' War School |achieve 1517/1 |cast Fishing##7620
	step
		goto Borean Tundra,51.2,42.4
		.' You will be able to find Musselback Sculpin Schools around Lake Kum'uya.
		.' Fish from a Musselback Scuplin School |achieve 1517/5
	step
		goto Borean Tundra,82.7,59.5
		.' Around the Glacier, you will find Schools of Moonglow Cuttlefish and Deep Sea Monsterbelly.
		.' Fish from a Deep Sea Monsterbelly School |achieve 1517/6 |cast Fishing##7620
		.' Fish from a Moonglow Cuttlefish School |achieve 1517/9 |cast Fishing##7620
	step
		goto Sholazar Basin,46.8,64.7
		.' All around River's Heart, you will find schools of Nettlefish.
		.' Fish from a Nettlefish School |achieve 1517/10 |cast Fishing##7620
	step
		goto Dragonblight,42.3,67.8
		.' You can find Dragonfin Angelfish School all along Lake Indu'le.
		.' Fish from a Dragonfin Angelfish School |achieve 1517/2 |cast Fishing##7620
	step
		goto Crystalsong Forest,49.0,54.1
		.' Along the Twilight Rivulet you will find schools of Glassfin Minnow.
		.' Fish from a Glassfin Minnow School |achieve 1517/8 |cast Fishing##7620
	step
		map Grizzly Hills
		path follow loose;loop off;ants straight // this stays until the end of the guide.
		path	26.4,64.9	28.6,60.8	29.5,55.8
		.' You can find Schools of Glacial Salmon along this river.
		.' Fish from a Glacial Salmon School |achieve 1517/3 |cast Fishing##7620
	step
		map Howling Fjord
		path follow loose;loop off;ants straight // this stays until the end of the guide.
		path	59.5,58.8	60.8,60.3	60.6,64.5
		.' You can find Fangtooth Herring Schools along Daggercap Bay.
		.' Fish from a Fangtooth Herring School |achieve 1517/7 |cast Fishing##7620
	step
		.' Earn the Northrend Angler Achievement. |achieve 1517 |cast Fishing##7620
	step
		'Congratulations! You've earned the Northrend Angler achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_Fish_Don't_Leave_Footprints",[[
	step
		goto Northern Stranglethorn,31.0,37.7
		.' Use your fishing skill fish from Schooner Wreckage along The Savage Coast.  You may need to fish out the other schools of fish to get them to spawn. |cast Fishing##7620
		.collect Weather-Beaten Journal##34109
		.' Use the Weather-Beaten Journal. |use Weather-Beaten Jounral##34109
		.' Earn the Fish Don't Leave Footprints achievement. |achieve 1243
	step
		.' Congratulations, you have earned the Fish Don't Leave Footprints achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_The_Coin_Master",[[
	step
		.' This guide will help you earn the achievements A Penny For Your Thoughts, Silver in the City, There's Gold In That There Fountain, and finally, The Coin Master.
		.' Click here to proceed. |confirm
	step
		.' Here is your current progression on The Coin Master.
		.' A Penny For Your Thoughts. |achieve 2096/1
		.' Silver in the City. |achieve 2096/2
		.' There's a Gold In That There Fountain. |achieve 2096/3
		.' Click here to proceed. |confirm
	step
		goto Dalaran,52.6,66.5
		.' This fountain is where you will be fishing from to earn these achievements. Use your fishing skills to fish up Copper, Silver and Gold Coins. |cast Fishing##7620
		.' Earn the A Penny For Your Thoughts achievement. |achieve 2096/1
		.' Earn the Silver in the City achievement. |achieve 2096/2
		.' Earn the There's Gold In That There Fountain achievement. |achieve 2096/3
		.' This achievement takes a lot of time, so try to be patient.
	step
		.' Earn the A Penny For Your Thoughts Achiement. |achieve 2094
		.' Earn the Silver in the City achievement. |achieve 2095
		.' Earn the There's Gold In That There Fountain achievement. |achieve 1957
		.' Earn The Coin Master achievement. |achieve 2096
	step
		.' Congratulation, you have earned The Coin Master achievement!
]])
ZygorGuidesViewer:RegisterInclude("A_Master_Angler_of_Azeroth",[[
	step
		'To earn this Achievement, you need to go to Booty Bay, accept this quest and be the first to complete it.
		.' You can start this quest every _Sunday_ from _2pm to 4pm SERVER TIME_.
		|confirm
	step
		goto Stormwind City,55.0,69.7
		.talk Catherine Leland##5494
		.buy 1 Fishing Pole##6256
		.buy 10 Shiny Bauble##6529
		.' Or
		|confirm
	step
		goto The Cape of Stranglethorn,41.7,73.0
		.talk Riggle Bassbait##15077
		..accept Master Angler##8193
	step
		goto The Cape of Stranglethorn,39.1,57.9
		.' Make sure you have you're fishing pole equipped and fish in these area's for Tasty Fish |use Fishing Pole##6256
		.' Attach your Shiny Bauble to your fishing pole to increase your fishing skill slightly |use Shiny Bauble##6529
		.get 40 Speckled Tastyfish##19807 |q 8193
		.' You can find more schools of fish here: [37.9,55.6]
		.' Here [36.3,53.8]
		.' Here [36.1,50.9]
		.' And here [36.2,47.7]
	step
		goto The Cape of Stranglethorn,41.7,73.0
		.talk Riggle Bassbait##15077
		..turnin Master Angler##8193
		.' Be the first to turn in this quest to earn the achievement
		.' Earn Master Angler Achievement |achieve 306
]])
ZygorGuidesViewer:RegisterInclude("A_Master_Angler_of_Northrend",[[
	step
		'To earn this Achievement, you need to go to Northrend, catch a _Blacktip Shark_ and be the first to turn it in.
		.' You can start fishing every _Saturday_ at _2pm SERVER TIME_, you will hear the NPC yell out that the
		.' contest has started, make sure you are next to a school of fish, and start fishing!
		|confirm
	step
		goto Stormwind City,55.0,69.7
		.talk Catherine Leland##5494
		.buy 1 Fishing Pole##6256
		.buy 10 Shiny Bauble##6529
		.' Or
		|confirm
	step
		goto Dalaran,44.7,63.3
		.talk Isirami Fairwind##32413
		.home Dalaran
	step
		goto Dalaran,52.4,65.2
		.talk Elder Clearwater##38294
		.turnin Kalu'ak Fishing Derby##24803
	step
		goto Dalaran,56.0,46.8
		.click Teleport to Violet Stand Crystal##8070
		.' Teleport to the Violet Stand |goto Crystalsong Forest |noway |c
	step
		map Crystalsong Forest
		path follow loose;loop off;ants straight
		path	22.5,35.4
		path	25.2,43.4	29.6,45.2	34.0,47.9
		path	38.7,54.4	44.8,56.7	50.3,56.4
		.' Follow this path and turn your _Track Fishing_ on.
		.' Fish up a _Blacktip Shark_ from any school of fish.|use Fishing Pole##6256
		.' Attach your Shiny Bauble to your fishing pole to increase your fishing skill slightly |use Shiny Bauble##6529
		.collect Blacktip Shark##50289
	step
		goto Dalaran,52.4,65.2
		.talk Elder Clearwater##38294
		.turnin Kalu'ak Fishing Derby##24803
		.' If you are the first to turn in this quest you will get an achievement
		.' Earn the Achievement Master Angler of Azeroth |achieve 306
]])
ZygorGuidesViewer:RegisterInclude("A_Darnassus_Fishing_Dailies",[[
	label dailies
		goto Darnassus,49.1,61.0
		.talk Astaia##4156
		.' You will only be able to accept one of the five quests listed.
		.accept Happy as a Clam Digger##29321 |or
		.accept Stocking Up##29323 |or
		.accept A Slippery Snack##29325 |or
		.accept The Sister's Pendant##29324 |or
		.accept An Old Favorite##29359 |or
	step
		goto Teldrassil 55.6,92.5
		.' Go underwater and click the giant clams.
		.get 10 Teldrassil Clam##69910 |q 29321/1
		only if havequest(29321)
	step
		goto Darnassus,49.0,60.8
		.' Use your fishing ability on the dock. |cast Fishing##7620
		.get 5 Lake Whitefish##69912 |q 29323/1
		only if havequest(29323)
	step
		goto Teldrassil,54.7,92.9
		.' Click the Baby Octopus in the water.
		.get 6 Baby Octopus##69915 |q 29325/1
		only if havequest (29325)
	step
		.' Fish next to Astaia until you get Aquinne's Moon Pendant. |cast Fishing##7620
		.get Aquinne's Moon Pendant##69913 |q 29324/1
		only if havequest (29324)
	step
		goto Teldrassil,55.6,91.7
		.' Fish in the water until you catch 8 Kaldorei Herring. |cast Fishing##7620
		.get 8 Kaldorei Herring##69987 |q 29359/1
		only if havequest (29359)
	step
		goto Darnassus,49.1,61.0
		.talk Astaia##4156
		.' You will only be able to accept one of the five quests listed.
		.turnin Happy as a Clam Digger##29321 |or
		.turnin Stocking Up##29323 |or
		.turnin A Slippery Snack##29325 |or
		.turnin The Sister's Pendant##29324 |or
		.turnin An Old Favorite##29359 |or
]])
ZygorGuidesViewer:RegisterInclude("A_Ironforge_Fishing_Dailies",[[
		goto Ironforge,48.1,7.6
		.talk Grimnur Stonebrand##5161
		.accept Cold Water Fishing##29342 |or
		.accept One fer the Ages##29343 |or
		.accept Fish fer Squirky##29344 |or
		.accept Live Bait##29347 |or
		.accept The Gnomish Bait-o-Matic##29350 |or
	step
		goto Dun Morogh,83.92,51.19
		.' Use your fishing ability in Helm's Bed Lake. |cast Fishing##7620
		get 5 Arctic Char##69931 |q 29342/1
		only if havequest(29342)
	step
		goto Ironforge,46.5,14.5
		.' Use your fishing skill until you catch Young Ironjaw. |cast Fishing##7620
		.get Young Ironjaw##69932 |q 29343
		only if havequest(29343)
	step
		goto Ironforge,71,10
		.' Click the sparkling plaque
		.' Display Young Ironjaw |q 29343/1
		only if havequest(29343)
	step
		goto Ironforge,46.5,14.5
		.' Use your fishing skill to fish up 3 Blind Minnows. |cast Fishing##7620
		.get 3 Blind Minnow##69933 |q 29344
		only if havequest (29344)
	step
		goto Ironforge,48.6,8.6
		.' Feed Squirky with the Blind Minnow you caught. |use Blind Minnow##69933
		.' Feed Squirky |q 29344/1
		only if havequest (29344)
	step
		goto Dun Morogh,84,51
		.' Use Grimnur's Bait on yourself then jump into the water. |use Grimnur's Bait##69940
		.' Make sure you're not in the water when you use the bait.
		.' Catch Cold Water Crayfish |q 29347/1
		.' IMPORTANT! Do not mount after you catch the cold water crayfish.
		only if havequest (29347)
	step
		goto Dun Morogh,75.6,52.8
		.' Take the Crayfish to Cook Ghilm |q 29347/2
		only if havequest (29347)
	step
		goto Dun Morogh,75.6,52.8
		.talk Cook Ghilm##1355
		.turnin Live Bait##29347
		only if havequest (29347)
	step
		goto Ironforge,48.1,6.5
		.talk Tansy Puddlefizz##5162
		.buy 5 Shiny Bauble##6529 |q 29350
		only if havequest (29350)
	step
		goto Ironforge,67.9,42.5
		.talk Gearcutter Cogspinner##5175
		.buy Hair Trigger##39684 |q 29350
		only if havequest (29350)
	step
		.' Look for traps throughout the Ironforge Deeprun Tram station.
		.click Rat Trap##10547+
		.collect 3 Rat Trap##69980 |n
		.' Use your Bait-o-Matic Blueprints to make a Gnomish Bait-o-Matic |use Bait-o-Matic##69979
		.get Gnomish Bait-o-Matic##69978 |q 29350/1
		only if havequest (29350)
	step
		goto Ironforge,48.1,7.6
		.talk Grimnur Stonebrand##5161
		.turnin Cold Water Fishing##29342 |or
		.turnin One fer the Ages##29343 |or
		.turnin Fish fer Squirky##29344 |or
		.turnin The Gnomish Bait-o-Matic##29350 |or
]])
ZygorGuidesViewer:RegisterInclude("A_Stormwind_Fishing_Dailies",[[
	step
		goto Stormwind City,55.0,69.7
		.talk Catherine Leland##5494
		.' You will only be able to pick up one of these quests.
		.accept Hitting a Walleye##26414 |or
		.accept Diggin' For Worms##26420 |or
		.accept Rock Lobster##26442 |or
		.accept Big Gulp##26488 |or
		.accept Thunder Falls##26536 |or
	step
		goto Stormwind City,56.5,41.6
		.' Use your fishing ability to fish in the lake. |cast Fishing##7620
		.get Hardened Walleye##58503 |q 26414
		only if havequest (26414)
	step
		goto 58.3,13.2
		.' Look for sparkling mounds in the grass around the pond.
		.collect 1 Overgrown Earthworm##58788 |q 26420 |n
		.' Use the Overgrown Earthworm |use Overgrown Earthworm##58788
		.' Fish in Olivia's Pond |cast Fishing##7620
		.get Crystal Bass##58787 |q 26420/1
		only if havequest (26420)
	step
		goto Stormwind City,22.4,29.0
		.' Swim around Stormwind Harbor and click The Stormwind Lobster Traps
		.get 6 Rock Lobster##58809 |q 26442/1
		only if havequest (26442)
	step
		goto Stormwind City,69.1,92.2
		.' Use your fishing skill in the moat. |cast Fishing##7620
		.get Royal Monkfish##58856 |n
		.' Click the Royal Monkfish |use Royal Monkfish##58856
		.collect Precious Locket##58864
		only if havequest (26488)
	step
		goto Elwynn Forest,27.1,60.6
		.' Use your fishing skill in the water here. |cast Fishing##7620
		.get 4 Violet Perch##58899 |q 26536/1
		only if havequest (26536)
	step
		goto Stormwind City,55.0,69.7
		.talk Catherine Leland##5494
		.' You will only be able to pick up one of these quests.
		.turnin Hitting a Walleye##26414 |or
		.turnin Diggin' For Worms##26420 |or
		.turnin Rock Lobster##26442 |or
		.turnin Big Gulp##26488 |or
		.turnin Thunder Falls##26536 |or
]])

-----------------------------------------------------------------------------------------
-- Dailies
-----------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("A_Sons_Hodir_Pre-Quests",[[
		goto The Storm Peaks,41,86.4
		.talk Jeer Sparksocket##29431
		..turnin Luxurious Getaway!##12853
		..accept Clean Up##12818
	step
		goto The Storm Peaks 41.1,85.9
		.talk Smilin' Slirk Brassknob##29904
		.home K3
	step
		goto 41.1,86.1
		.talk Gretchen Fizzlespark##29473
		..accept They Took Our Men!##12843
		..accept Equipment Recovery##12844
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..accept Reclaimed Rations##12827
		..accept Expression of Gratitude##12836
	step
		goto 40.8,84.5
		.talk Skizzle Slickslide##29721
		..fpath K3
	step
		goto 39.8,86.4
		.click Charred Wreckage##6866
		.get 10 Charred Wreckage|q 12818/1
	step
		goto 35,83.8
		.from Savage Hill Scavenger##29404+, Savage Hill Brute##29623+
		.click Dried Gnoll Rations##335
		.get 16 Dried Gnoll Rations|q 12827/1
	step
		goto 30.3,85.7
		.kill Gnarlhide##30003|q 12836/1
	step
		goto 41,86.4
		.talk Jeer Sparksocket##29431
		..turnin Clean Up##12818
		..accept Just Around the Corner##12819
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Reclaimed Rations##12827
		..turnin Expression of Gratitude##12836
		..accept Ample Inspiration##12828
	step
		goto 35.1,87.8
		.click Sparksocket's Tools##1209
		.get Sparksocket's Tools|q 12819/1
	step
		goto 41,86.4
		.talk Jeer Sparksocket##29431
		..turnin Just Around the Corner##12819
		..accept Slightly Unstable##12826
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Slightly Unstable##12826
		..accept A Delicate Touch##12820
	step
		goto 43.1,81.2
		.' Use your Improved Land Mines to place mines on the ground close to each other|use Improved Land Mines##40676|tip Garm Invaders and Snowblind Followers will run over the mines and die.
		.kill 12 Garm Attackers|q 12820/1
		'|modelnpc 29619
		'|modelnpc 29618
	step
		goto 41.7,80
		.talk Tore Rumblewrench##29430
		..accept Moving In##12829
		..accept Ore Repossession##12830
	step
		goto 41.7,80
		.click the U.D.E.D. Dispenser##2029
		.' Retrieve a bomb from the dispenser
		.collect U.D.E.D.##40686|q 12828
	step
		'Go to [43.9,79.0] quickly
		.' Use your U.D.E.D. on an Ironwool Mammoth|use U.D.E.D.##40686|tip They walk around this area spread out.
		.click  Mammoth Meat##2951
		.get 8 Hearty Mammoth Meat|q 12828/1
	step
		.' Go into the cave |goto 40.4,77.8 |noway |c
		.kill 12 Crystalweb Spiders |q 12829/1
		'|modelnpc 29412
	step
		goto 41.5,74.9
		.talk Injured Goblin Miner##29434
		..accept Only Partly Forgotten##12831
	step
		goto 47.1,72.3
		.from Icetip Crawler##29461
		.get 1 Icetip Venom Sac|q 12831/1
	step
		goto 44,75.9
		.kill Snowblind Diggers##29413 |n
		.get 5 Impure Saronite Ore|q 12830/1
	step
		goto 43.5,75.2
		.talk Injured Goblin Miner##29434
		..turnin Only Partly Forgotten##12831
		..accept Bitter Departure##12832
	step
		goto 43.5,75.2
		.talk Injured Goblin Miner##29434
		..'Tell the miner you're ready
		.' Escort the Injured Goblin Miner to K3. |q 12832/1
	step
		'Fly up to [39.8,73.3]
		.kill Sifreldar Storm Maiden##29323+ |n
		.collect 5 Cold Iron Key##40641|n
		.click Rusty Cage##7469+
		.' Free 5 Goblin Prisoners |q 12843/1
		.click K3 Equipment##335
		.get 8 K3 Equipment|q 12844/1
	step
		goto 41.7,80
		.talk Tore Rumblewrench##29430
		..turnin Moving In##12829
		..turnin Ore Repossession##12830
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin A Delicate Touch##12820
		..turnin Ample Inspiration##12828
		..turnin Bitter Departure##12832
		..accept Opening the Backdoor##12821
	step
		goto 41.1,86.1
		.talk Gretchen Fizzlespark##29473
		..turnin They Took Our Men!##12843
		..accept Leave No Goblin Behind##12846
		..turnin Equipment Recovery##12844
	step
		goto 45.1,82.4
		.click Transporter Power Cell##8099
		.get Transporter Power Cell|q 12821/2
	step
		goto 50.7,81.9
		.' Use your Transporter Power Cell next to the Teleportation Pad|use Transporter Power Cell##40731|tip It looks like a tall machine with a fan in the bottom of it.
		.' Activate the Garm Teleporter |q 12821/1
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Opening the Backdoor##12821
		..accept Know No Fear##12822
	step
		goto 50.0,81.8
		.talk Gino##29432
		..accept A Flawless Plan##12823
	step
		'Go inside the cave to [50.5,77.8]
		.' Use your Hardpacked Explosive Bundle next to Frostgut's Altar|use Hardpacked Explosive Bundle##41431|tip It's a stone altar with a bunch of melted red candles on it.  Follow the path in the cave that spirals up all the way to the top of the cave to find it.
		.kill Tormar Frostgut##29626 |q 12823/2
	step
		goto 48.1,81.9
		.kill 6 Garm Watcher##29409+ |q 12822/1
		.kill 8 Snowblind Devotee##29407+ |q 12822/2
	step
		'Go outside and go to [50.0,81.8]
		.talk Gino##29432
		..turnin A Flawless Plan##12823
		..accept Demolitionist Extraordinaire##12824
	step
		Fly up into the cave to [42.8,68.9]
		.talk Lok'lira the Crone##29481
		..turnin Leave No Goblin Behind##12846
		..accept The Crone's Bargain##12841
	step
		goto 44.2,68.9
		.from Overseer Syra##29518
		.get 1 Runes of the Yrkvinn|q 12841/1
	step
		goto 42.8,68.9
		.talk Lok'lira the Crone##29481
		..turnin The Crone's Bargain##12841
		..accept Mildred the Cruel##12905
	step
		goto 44.4,68.9
		.talk Mildred the Cruel##29885
		..turnin Mildred the Cruel##12905
		..accept Discipline##12906
	step
		goto 44.8,70.3
		.' Use your Disciplining Rod on Exhausted Vrykul|use Disciplining Rod##42837|tip They are sitting on the ground inside these side tunnels inside this mine.
		.' Discipline 6 Exhausted Vrykul |q 12906/1
		'|modelnpc 30146
	step
		goto 44.4,68.9
		.talk Mildred the Cruel##29885
		..turnin Discipline##12906
		..accept Examples to be Made##12907
	step
		goto 45.4,69.1
		.kill 1 Garhal##30147 |q 12907/1
	step
		goto 44.4,68.9
		.talk Mildred the Cruel##29885
		..turnin Examples to be Made##12907
		..accept A Certain Prisoner##12908
	step
		goto 42.8,68.9
		.talk Lok'lira the Crone##29481
		..turnin A Certain Prisoner##12908
		..accept A Change of Scenery##12921
	step
		.' Follow the path in the mine east out to the other side to [47.5,69.1]
		.talk Lok'lira the Crone##29975
		..turnin A Change of Scenery##12921
		..accept Is That Your Goblin?##12969
	step
		goto 48.2,69.8
		.talk Agnetta Tyrsdottar##30154
		.' Tell her to skip the warmup
		.kill 1 Agnetta Tyrsdottar##30154 |q 12969/1
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin Is That Your Goblin?##12969
		..accept The Hyldsmeet##12970
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..'Ask her about her proposal
		.' Listen to Lok'lira's proposal |q 12970/1
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin The Hyldsmeet##12970
		..accept Taking on All Challengers##12971
	step
		goto 51,66.4
		.talk Victorious Challenger##30012
		.kill 6 Victorious Challenger##30012+ |q 12971/1
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin Taking on All Challengers##12971
		..accept You'll Need a Bear##12972
	step
		goto 48.4,72.1
		.talk Iva the Vengeful##29997
		..accept Off With Their Black Wings##12942
		..accept Yulda's Folly##12968
	step
		goto 48.4,72.1
		.talk Thyra Kvinnshal##30041
		..accept Aberrations##12925
	step
		goto 53.1,65.7
		.talk Brijana##29592
		..turnin You'll Need a Bear##12972
		..accept Going Bearback##12851
	step
		goto 53.1,65.7
		.clicknpc Icefang##29598
		.' While riding Icefang, use the Flaming Arrow ability on your hotbar to shoot arrows at the Frostworgs and Frost Giants|petaction Flaming Arrow
		.' Burn 7 Frostworgs |q 12851/1
		.' Burn 15 Frost Giants |q 12851/2
		'|modelnpc 29358
		'|modelnpc 29351
	step
		goto 53.1,65.7
		.talk Brijana##29592
		..turnin Going Bearback##12851
		..accept Cold Hearted##12856
	step
		'Fly to 63.9,62.5|goto 63.9,62.5
		.click Captive Proto-Drake##29708
		.' Use your Ice Shard ability on the Brunnhildar Prisoners|petaction Ice Shard|tip The Brunnhildar Prisoners look like blue blocks of ice around this area on the ground.
		.' When your Proto-Drake is holding 3 Brunnhildar Prisoners, start flying toward Brunnhildar Village, the drake will eventually go on autopilot.  Repeat this process 2 more times.
		.' Rescue 9 Brunnhildar Prisoners |q 12856/1
		.' Free 3 Proto-Drakes |q 12856/2
		'|modelnpc 29639
	step
		goto 53.1,65.7
		.talk Brijana##29592
		..turnin Cold Hearted##12856
		..accept Deemed Worthy##13063
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin Deemed Worthy##13063
		..accept Making a Harness##12900
	step
		goto 47.9,74.7
		.kill Icemane Yeti##29875+|n
		.get 3 Icemane Yeti Hide|q 12900/1
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin Making a Harness##12900
		..accept The Last of Her Kind##12983
		..accept The Slithering Darkness##12989
	step
		goto 55.8,63.9
		.'Kill 8 Ravenous Jormungar##29605+ |q 12989/1 |tip They are inside the cave.
	step
		goto 54.8,60.4
		.clicknpc Injured Icemaw Matriarch##29563
		.' The bear runs back to Brunnhildar Village
		.' Rescue the Icemaw Matriarch |q 12983/1
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin The Last of Her Kind##12983
		..accept The Warm-Up##12996
		..turnin The Slithering Darkness##12989
	step
		'Use your Reins of the Warbear Matriarch outside the building to ride a bear|invehicle|c|use Reins of the Warbear Matriarch##42481
	step
		goto 50.8,67.7
		.' Use the abilities on your hotbar to fight Kirgaraak|tip He's a big white yeti.
		.' Defeat Kirgaraak |q 12996/1
		'|modelnpc 29352
	step
		'Click the red arrow to get off the bear|script VehicleExit()|outvehicle|c
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin The Warm-Up##12996
		..accept Into the Pit##12997
	step
		goto 49.1,69.4
		.' Use your Reins of the Warbear Matriarch inside The Pit of the Fang to ride a bear|use Reins of the Warbear Matriarch##42499
		.' Use the abilities on your hotbar to fight Hyldsmeet Warbears
		.kill 6 Hyldsmeet Warbear##30174+ |q 12997/1
	step
		'Click the red arrow to get off the bear|script VehicleExit()|outvehicle|c
	step
		goto 49.7,71.8
		.talk Astrid Bjornrittar##29839
		..turnin Into the Pit##12997
		..accept Prepare for Glory##13061
	step
		goto 47.5,69.1
		.talk Lok'lira the Crone##29975
		..turnin Prepare for Glory##13061
		..accept Lok'lira's Parting Gift##13062
	step
		goto 50.9,65.6
		.talk Gretta the Arbiter##29796
		..turnin Lok'lira's Parting Gift##13062
		..accept The Drakkensryd##12886
	step
		'You fly off on a drake and start flying in circles around a tower:
		.' Use your Hyldnir Harpoon in your bags on Hyldsmeet Proto-Drakes to harpoon over to a new drake|use Hyldnir Harpoon##41058
		.kill Hyldsmeet Drakerider##29694+ |n
		.' Repeat this process 9 more times
		.' Defeat 10 Hyldsmeet Drakeriders |q 12886/1
	step
		'They look like light fixtures on the side of the stone columns.
		.' Use your Hyldnir Harpoon in your bags on a Column Ornament to get off the drake|outvehicle|c|use Hyldnir Harpoon##41058
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin The Drakkensryd##12886
		..accept Sibling Rivalry##13064
	step
		goto 33.4,58
		.talk Thorim##29445
		..'Ask him what became of Sif
		.' Hear Thorim's History |q 13064/1
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin Sibling Rivalry##13064
		..accept Mending Fences##12915
	step
		goto 27.3,63.7
		.kill 12 Nascent Val'kyr##29570+ |q 12942/1
		.kill Valkyrion Aspirant##29569+ |n
		.collect 6 Vial of Frost Oil##41612|q 12925
	step
		goto 23.7,58.3
		.' Use your Vials of Frost Oil on the Plagued Proto-Drake Eggs|use Vial of Frost Oil##41612|tip They look like brown spiked eggs sitting in the yellow water around this area.
		.' Try to get 6 at a time
		.' Destroy 30 Plagued Proto-Drake Eggs |q 12925/1
		'|model 3891
	step
		goto 24,61.8
		.kill Yulda the Stormspeaker##30046 |q 12968/1
		.click Harpoon Crate##8217
		..accept Valkyrion Must Burn##12953
	step
		goto 26,59.8
		.clicknpc Valkyrion Harpoon Gun##30066
		.' Use the Flaming Harpoon ability on your hotbar to shoot the tan bundles of straw near buildings and in wagons around this area|petaction Flaming Harpoon
		.' Start 6 Fires |q 12953/1
	step
		'Click the red arrow to get off the gun|script VehicleExit()|outvehicle|c
	step
		goto The Storm Peaks 40.9,85.3
		.talk Ricket##29428
		..turnin Demolitionist Extraordinaire##12824
		..turnin Know No Fear##12822
		..accept Overstock##12833
	step
		goto 43.1,81.2
		.' Use your Improved Land Mines to place mines on the ground close to each other|use Improved Land Mines##40676|tip Garm Invaders and Snowblind Followers will run over the mines and die.
		.kill 12 Garm Invader|q 12833/1
		'|modelnpc 29619
		'|modelnpc 29618
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..turnin Overstock##12833
	step
		goto 48.4,72.1
		.talk Thyra Kvinnshal##30041
		..turnin Aberrations##12925
	step
		goto 48.4,72.1
		.talk Iva the Vengeful##29997
		..turnin Off With Their Black Wings##12942
		..turnin Yulda's Folly##12968
		..turnin Valkyrion Must Burn##12953
	step
		goto 75.8,63
		.click Granite Boulder##7750+
		.' Use Thorim's Charm of Earth on the Stormforged Iron Giants|use Thorim's Charm of Earth##41505
		.' Help the dwarves kill them
		.kill 5 Stormforged Iron Giant##29375+  |q 12915/2
		.collect Slag Covered Metal##41556 |q 12922 |future |n
		.use Slag Covered Metal##41556
		..accept The Refiner's Fire##12922
	step
		goto 75.4,63.5
		.from Seething Revenant##29504+
		.get 10 Furious Spark|q 12922/1
	step
		goto 77.2,62.9
		.click Granite Boulder##7750
		.' Use Thorim's Charm of Earth on Fjorn|use Thorim's Charm of Earth##41505|tip He's a huge fire giant, holding a huge smithing hammer.
		.' Help the dwarves kill him
		.kill Fjorn##29503 |q 12915/1
	step
		goto 77.2,62.9
		.click Fjorn's Anvil##7481
		..turnin The Refiner's Fire##12922
		..accept A Spark of Hope##12956
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin A Spark of Hope##12956
		..turnin Mending Fences##12915
		..accept Forging an Alliance##12924
	step
		goto 62.6,60.9
		.talk Halvdan##32571
		..fpath Dun Niffelem
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..accept You Can't Miss Him##12966
	step
		goto 75.4,63.6
		.talk Njormeld##30099
		..turnin You Can't Miss Him##12966
		..accept Battling the Elements##12967
	step
		goto 75.7,63.9
		.clicknpc Snorri##30123 |invehicle |c
	step
		goto 76.7,63.4
		.' Use the Gather Snow ability on your hotbar to gather snow from Snowdrifts|petaction Gather Snow|tip The Snowdrifts look like piles of snow on the ground.
		.' Use the Throw Snowball ability on your hotbar to throw the snow at Seething Revenants|petaction Throw Snowball
		.kill 10 Seething Revenant##30120+ |q 12967/1
	step
		'Click the red arrow on your hotbar to leave Snorri|script VehicleExit()|outvehicle|c
	step
		goto 75.4,63.6
		.talk Njormeld##30099
		..turnin Battling the Elements##12967
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin Forging an Alliance##12924
		..accept A New Beginning##13009
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481
		..accept Hot and Cold##12981
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..accept In Memoriam##12975
	step
		goto 69.7,60.2
		.kill Brittle Revenant##30160+ |n
		.collect 6 Essence of Ice##42246 |q 12981
	step
		goto 75.3,62.8
		.' Use your Essences of Ice next to Smoldering Scraps|use Essence of Ice##42246
		.click  Frozen Iron Scrap##8231+
		.get 6 Frozen Iron Scrap|q 12981/1
	step
		goto 72.1,49.4
		.click Horn Fragment##8222+
		.get 8 Horn Fragment|q 12975/1
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..turnin In Memoriam##12975
		..accept A Monument to the Fallen##12976
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin A Monument to the Fallen##12976
	step
		goto 63.2,62.9
		.click Fjorn's Anvil##7481+
		..turnin Hot and Cold##12981
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..accept Blowing Hodir's Horn##12977
	step
		goto 72.1,51.8
		.kill Niffelem Forefather##29974+, Restless Frostborn Ghost##30144+ |n
		.' Use Hodir's Horn on their corpses|use Hodir's Horn##42164
		.' Free 5 Niffelem Forefathers |q 12977/1
		.' Free 5 Restless Frostborn |q 12977/2
	step
		goto 64.1,65.1
		.click Hodir's Horn##7352
		..turnin Blowing Hodir's Horn##12977
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..accept Forging a Head##12985
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..accept Jormuttar is Soo Fat...##13011
	step
		goto 69.7,58.9
		.' Use your Diamond Tipped Pick on Dead Iron Giants|use Diamond Tipped Pick##42424
		.kill Stormforged Ambusher##30208+ |n
		.get 8 Stormforged Eye|q 12985/1
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin Forging a Head##12985
		..accept Mounting Hodir's Helm##12987
	step
		goto 64.3,59.2
		.' Fly to the tip of this ice spike
		.' Use the Tablets of Pronouncement in your bags|use Tablets of Pronouncement##42442
		.' Mount Hodir's Helm |q 12987/1
	step
		goto 63.2,63.2
		.talk Njormeld##30127
		..turnin Mounting Hodir's Helm##12987
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221+
		..accept Polishing the Helm##13006
	step
		goto 55.6,63.4
		.kill Viscous Oil##30325+ |n
		.get 5 Viscous Oil|q 13006/1
		.' Use your Everfrost Razor on Dead Icemaw Bears|use Everfrost Razor##42732
		.collect 1 Icemaw Bear Flank##42733|q 13011
		'|modelnpc 30292
	step
		goto 54.7,60.8
		.' Follow the path inside the cave to this spot
		.' Use your Icemaw Bear Flank while standing on the small frozen pond with a bunch of rocks on it|use Icemaw Bear Flank##42733
		.kill 1 Jormuttar##30340 |q 13011/1
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin A New Beginning##13009
		..accept Veranus##13050
	step
		goto 43.7,67.4
		.click Small Proto-Drake Egg##7398+
		.get 5 Small Proto-Drake Egg|q 13050/1
		.' You can find more Small Proto-Drake Eggs at [45.2,66.9] |n
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin Veranus##13050
		..accept Territorial Trespass##13051
	step
		goto 38.7,65.6
		.' Stand in this big nest
		.' use the Stolen Proto-Dragon Eggs in your bags|use Stolen Proto-Dragon Eggs##42797
		.' Lure Veranus |q 13051/1
	step
		goto 33.4,58
		.talk Thorim##29445
		..turnin Territorial Trespass##13051
		..accept Krolmir, Hammer of Storms##13010
	step
		goto 64.2,59.2
		.click Hodir's Helm##8221
		..turnin Polishing the Helm##13006
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..turnin Jormuttar is Soo Fat...##13011
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..'Ask him what has become of Krolmir
		.' Discover Krolmir's Fate |q 13010/1
	step
		goto 71.4,48.8
		.talk Thorim##30390
		..turnin Krolmir, Hammer of Storms##13010
		..accept The Terrace of the Makers##13057
	step
		goto 56.3,51.4
		.talk Thorim##30295
		..turnin The Terrace of the Makers##13057
		..accept The Earthen Oath##13005
		..accept Loken's Lackeys##13035
	step
		goto 57.3,46.7
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.' Fight mobs around this area
		.kill 7 Iron Sentinel##29984+ |q 13005/1
		.kill 20 Iron Dwarf Assailant##29978+ |q 13005/2
	step
		goto 55.3,43.3
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.kill Eisenfaust##30341 |q 13035/1
	step
		goto 48.6,45.6
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.kill Halefnir the Windborn##30376 |q 13035/2
	step
		goto 45,38.1
		.' Use your Horn of the Peaks to summon earthen helpers|use Horn of the Peaks##42840
		.kill Duronn the Runewrought##30353 |q 13035/3
	step
		goto 56.3,51.4
		.talk Thorim##30295
		..turnin The Earthen Oath##13005
		..turnin Loken's Lackeys##13035
		..accept The Reckoning##13047
	step
		goto 35.9,31.5
		.talk Thorim##30399
		..'Tell him you are with him
		.' Witness the Reckoning |q 13047/1
	step
		goto 65.4,60.2
		.talk King Jokkum##30105
		..turnin The Reckoning##13047
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..accept When All Else Fails##12862
	step
		goto 40.9,85.3
		.talk Ricket##29428
		..'Tell her you are ready to head further into Storm Peaks
		.'You will fly to Frosthold|goto 28.6,74.6,0.5|noway|c
	step
		goto 29.5,74.3
		.talk Faldorf Bitterchill##29750
		..fpath Frosthold
	step
		goto 29.5,74.1
		.talk Archaeologist Andorin##29650
		..accept On Brann's Trail##12854
	step
		goto 29.4,73.8
		.talk Lagnus##29743
		..accept Offering Thanks##12863
	step
		goto 28.8,74.1
		.talk Rork Sharpchin##29744
		..turnin When All Else Fails##12862
		..accept Ancient Relics##12870
	step
		goto The Storm Peaks 28.7,74.4
		.talk Gunda Boldhammer##29926
		.home Frosthold
	step
		goto 29.2,74.9
		.talk Glorthal Stiffbeard##29727
		..turnin Offering Thanks##12863
		..accept Missing Scouts##12864
	step
		goto 29.8,75.7
		.talk Fjorlin Frostbrow##29732
		..accept Loyal Companions##12865
	step
		goto 36.4,77.3
		.talk Frostborn Scout##29811
		..'Ask him if he is okay
		.' Locate the Missing Scout |q 12864/1
	step
		goto 46.5,68.3
		.kill Vrykuls |n
		.' Get 10 Relics of Ulduar |q 12870/1
	step
		'Go outside to 44.5,60.4|goto 44.5,60.4
		.kill Ice Steppe Rhino##29469+, Ice Steppe Bull##30445+ |n
		.collect 8 Fresh Ice Rhino Meat##41340|q 12865
	step
		goto 36.1,64.1
		.click Disturbed Snow##5333
		.get Burlap-Wrapped Note|q 12854/1
	step
		goto 33.2,73.7
		.' Use your Fresh Ice Rhino Meat on Stormcrest Eagles at the top of this mountain|use Fresh Ice Rhino Meat##41340
		.' Feed 8 Stormcrest Eagles |q 12865/1
		'|modelnpc 29854
	step
		goto 29.5,74.1
		.talk Archaeologist Andorin##29650
		..turnin On Brann's Trail##12854
		..accept Sniffing Out the Perpetrator##12855
	step
		goto 28.8,74.1
		.talk Rork Sharpchin##29744
		..turnin Ancient Relics##12870
	step
		goto 29.2,74.9
		.talk Glorthal Stiffbeard##29727
		..turnin Missing Scouts##12864
		..accept Stemming the Aggressors##12866
	step
		goto 29.8,75.7
		.talk Fjorlin Frostbrow##29732
		..turnin Loyal Companions##12865
		..accept Baby Stealers##12867
	step
		goto 33,66.8
		.click Eagle Egg##1867+
		.get 15 Stormcrest Eagle Egg|q 12867/1
		.kill 8 Frostfeather Screecher##29792+ |q 12866/1
		.kill 8 Frostfeather Witch##29793+ |q 12866/2
	step
		goto 36.4,64.1
		.' Use the Frosthound's Collar in your bags next to this broken down tent|use Frosthound's Collar##41430
		.' Use the abilities on your hotbar to keep the dwarves away from you
		.' Track down the thief |q 12855/1
	step
		goto 48.5,60.8
		.kill Tracker Thulin##29695 |q 12855/2
		.collect Brann's Communicator##40971|q 12871
	step
		'Use Brann's Communicator in your bags|use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Sniffing Out the Perpetrator##12855
		..accept Pieces to the Puzzle##12858
	step
		goto 37.6,43.5
		.kill Library Guardian##29724 |n
		.collect 6 Inventor's Disk Fragment##41130|n
		.' Click the Inventor's Disk Fragments in your bags to combine them|use Inventor's Disk Fragment##41130
		.get The Inventor's Disk|q 12858/1
	step
		'Use Brann's Communicator in your bags|use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Pieces to the Puzzle##12858
		..accept Data Mining##12860
	step
		goto 38.5,44.2
		.' Use The Inventor's Disk on Databanks|use The Inventor's Disk##41179|tip They look like floating round star things.
		.' Gather 7 Hidden Data |q 12860/1
		'|modelnpc 29746
	step
		'Use Brann's Communicator in your bags|use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Data Mining##12860
		..accept The Library Console##13415
	step
		goto 37.4,46.8
		.click Inventor's Library Console##8177
		..turnin The Library Console##13415
		..accept Norgannon's Shell##12872
	step
		'Click the Charged Disk in your bags|use Charged Disk##44704
		.from Archivist Mechaton##29775
		.get Norgannon's Shell|q 12872/1
	step
		'Use Brann's Communicator in your bags|use Brann's Communicator##40971
		.talk Brann Bronzebeard##29579
		..turnin Norgannon's Shell##12872
		..accept Aid from the Explorers' League##12871
		..accept The Exiles of Ulduar##12885
	step
		goto 30.6,36.3
		.talk Breck Rockbrow##29950
		..fpath Bouldercrag's Refuge
	step
		'Go inside the building to 31.4,38.1|goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Exiles of Ulduar##12885
		..accept Rare Earth##12930
	step
		goto The Storm Peaks 29.4,73.8
		.talk Lagnus##29743
		..turnin Aid from the Explorers' League##12871
		..accept The Frostborn King##12873
	step
		goto 29.2,74.9
		.talk Glorthal Stiffbeard##29727
		..turnin Stemming the Aggressors##12866
	step
		goto 29.8,75.7
		.talk Fjorlin Frostbrow##29732
		..turnin Baby Stealers##12867
	step
		goto 30.31,74.8
		.talk Yorg Stormheart##29593
		..turnin The Frostborn King##12873
		..accept Fervor of the Frostborn##12874
	step
		goto 29.8,75.7
		.talk Fjorlin Frostbrow##29732
		..'Tell him you are ready for your test|goto The Storm Peaks,53.5,35.1,0.5|c
	step
		goto 53.6,35.1
		.click Battered Storm Hammer##1107
		.collect Battered Storm Hammer##42624|q 12874
	step
		goto 53.5,37.9
		.' Use your Battered Storm Hammer on The Iron Watcher repeatedly|use Battered Storm Hammer##42624
		.' While he is stunned, run away so the Hammer can recharge
		.' When his health is low enough, he will run to the end of the bridge. Throw your hammer one last time and he will fall off
		.kill The Iron Watcher##30142 |q 12874/1
	step
		goto 30.31,74.8
		.talk Yorg Stormheart##29593
		..turnin Fervor of the Frostborn##12874
		..accept An Experienced Guide##12875
	step
		goto 29.8,75.7
		.talk Fjorlin Frostbrow##29732
		..accept Unwelcome Guests##12876
	step
		goto 27.0,66.9|n
		.' The path to An Experienced Guide and Unwelcome Guests starts here|goto The Storm Peaks,27.0,66.9,0.2|noway|c
	step
		goto 26.3,66.7
		.kill 10 Stormforged Invaders|q 12876/1
		.from Stormforged Pillager##29586+, Stormforged Loreseeker##29843+
		.get 5 Frostweave Cloth|q 12930/2
	step
		goto 25.2,68.5
		.talk Drom Frostgrip##29751
		..turnin An Experienced Guide##12875
		..accept The Lonesome Watcher##12877
	step
		goto 27.1,67.3
		.from the Stormforged Monitor##29862
		.get Frostgrip's Signet Ring|q 12877/1
	step
		goto 39.6,59.8
		.talk Creteus##30052
		..turnin The Lonesome Watcher##12877
		..accept Fate of the Titans##12986
	step
		goto 52.6,56.9
		.' Use Creteus's Mobile Databank at the top of this temple|use Creteus's Mobile Databank##42679
		.' Investigate the Temple of Winter |q 12986/2
	step
		goto 64.3,46.7
		.' Use Creteus's Mobile Databank in this broken temple|use Creteus's Mobile Databank##42679
		.' Investigate the Temple of Life |q 12986/3
	step
		goto 53.5,42.3
		.' Use Creteus's Mobile Databank Databank at the top of this temple|use Creteus's Mobile Databank##42679
		.' Investigate the Temple of Order |q 12986/4
	step
		goto 45.6,49.2
		.' Use Creteus's Mobile Databank Databank at the top of this temple|use Creteus's Mobile Databank##42679
		.' Investigate the Temple of Invention |q 12986/1
	step
		goto 39.6,59.8
		.talk Creteus##30052
		..turnin Fate of the Titans##12986
		..accept The Hidden Relic##12878
	step
		goto 41.5,62.1|n
		.' The path to The Hidden Relic starts here|goto The Storm Peaks,41.5,62.1,0.2|noway|c
	step
		goto 44.5,64.5
		.click The Guardian's Charge##1387
		..turnin The Hidden Relic##12878
		..accept Fury of the Frostborn King##12879
	step
		goto 38.2,61.7
		.talk Creteus##30082
		..turnin Fury of the Frostborn King##12879
		..accept The Master Explorer##12880
	step
		goto 39.6,56.4
		.talk Brann Bronzebeard##30382
		..turnin The Master Explorer##12880
		..accept The Brothers Bronzebeard##12973
	step
		.click Brann's Flying Machine##34120
		.kill the dwarves that jump on the plane as you fly|n
		.' Accompany Brann Bronzebeard to Frosthold |q 12973/1
	step
		goto 30.3,74.8
		.talk Velog Icebellow##30401
		..turnin The Brothers Bronzebeard##12973
	step
		goto 29.8,75.7
		.talk Fjorlin Frostbrow##29732
		..turnin Unwelcome Guests##12876
		..accept Pushed Too Far##12869
	step
		goto 44.6,59.8
		.' Use the abilities on your hotbar to fight Stormpeak Wyrms flying in the air around this area
		.kill 16 Stormpeak Wyrm##29753+ |q 12869/1
	step
		goto 29.8,75.7
		.' Click the red arrow on your hotbar to get off the eagle|script VehicleExit()
		.talk Fjorlin Frostbrow##29732
		..turnin Pushed Too Far##12869
	step
		goto 28.3,29.4
		.click Enchanted Earth##8194
		.get 7 Enchanted Earth|q 12930/1
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin Rare Earth##12930
		..accept Fighting Back##12931
		..accept Relief for the Fallen##12937
	step
		goto The Storm Peaks 30.9,37.3
		.talk Magorn##29963
		.home Bouldercrag's Refuge
	step
		goto 28.1,36.7
		.from Stormforged Raider##29377+, Stormforged Reaver##29382+ |n
		.kill 10 Stormforged Attacker|q 12931/1
		.' Use your Telluric Poultice on Fallen Earthen Defenders|use Telluric Poultice##41988
		.' Heal 8 Fallen Earthen Defenders |q 12937/1
		'|modelnpc 30035
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin Fighting Back##12931
		..turnin Relief for the Fallen##12937
		..accept Slaves of the Stormforged##12957
		..accept The Dark Ore##12964
	step
		'Go inside the mine to 27.5,49.7|goto 27.5,49.7
		.kill 3 Stormforged Taskmaster##29369+ |q 12957/2
		.talk Captive Mechagnome##29384
		.' Attempt to free 8 Captive Mechagnomes |q 12957/1
		.clicknpc Ore Cart##25986
		.get 5 Dark Ore Sample|q 12964/1
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin Slaves of the Stormforged##12957
		..turnin The Dark Ore##12964
		..accept The Gifts of Loken##12965
	step
		goto 31.3,38.2
		.talk Bruor Ironbane##30152
		..accept Facing the Storm##12978
	step
		goto 25,42.9
		.from Stormforged Champion##29370+, Stormforged Magus##29374+, Stormforged War Golem##29380+
		.kill 10 Nidavelir Stormforged|q 12978/1
	step
		goto 24,42.6
		.click Loken's Fury##8224
		.' Destroy Loken's Fury |q 12965/1
	step
		goto 26.2,47.7
		.click Loken's Power##8224
		.' Destroy Loken's Power |q 12965/2
	step
		goto 24.6,48.4
		.click Loken's Favor##8224
		.' Destroy Loken's Favor |q 12965/3
	step
		goto 25,42.9
		.from Stormforged War Golem##29380+, Stormforged Champion##29370+, Stormforged Magus##29374+
		.kill 10 Nidavelir Stormforged|q 12978/1
		.from Stormforged War Golem##29380+
		.collect 1 Dark Armor Plate##42203|n
		.' Click the Dark Armor Plate in your bags |use Dark Armor Plate##42203
		..accept Armor of Darkness##12979
	step
		goto 28.7,43.3
		.from Stormforged War Golem##29380+
		..get 4 Dark Armor Sample |q 12979/1
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Gifts of Loken##12965
	step
		goto 31.3,38.2
		.talk Bruor Ironbane##30152
		..turnin Facing the Storm##12978
		..turnin Armor of Darkness##12979
		..accept The Armor's Secrets##12980
	step
		'The entrance to Mimir's Workshop starts here |goto 33.6,39.6,0.5 |c
	step
		goto 32.0,40.7
		.talk Attendant Tock##30190
		.' Tell him you found a strange armor plate
		.' Investigate the Armor Plate |q 12980/1
	step
		'Leave Mimir's Workshop |goto 33.6,39.6,0.5 |c
	step
		goto 31.3,38.2
		.talk Bruor Ironbane##30152
		..turnin The Armor's Secrets##12980
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..accept Valduran the Stormborn##12984
	step
		goto 24.4,52.1
		.' Use Bouldercrag's War Horn inside this building near Valduran the Stormborn |use Bouldercrag's War Horn##42419
		.' Help fight Valduran the Stormborn
		.kill Valduran the Stormborn##29368 |q 12984/1
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin Valduran the Stormborn##12984
		..accept Destroy the Forges!##12988
	step
		goto 31.3,38.2
		.talk Bruor Ironbane##30152
		..accept Hit Them Where it Hurts##12991
	step
		goto 29.0,45.8
		.' Use Bouldercrag's Bomb next to the Lightning Forge |use Bouldercrag's Bomb##42441 |tip The Lightning Forge looks like a big brown dwarf head with a big blue crystal on top of it.
		.' Damage the North Lightning Forge |q 12988/1
	step
		goto 29.5,45.9
		.' Use Bouldercrag's Bomb next to the Lightning Forge |use Bouldercrag's Bomb##42441 |tip The Lightning Forge looks like a big brown dwarf head with a big blue crystal on top of it.
		.' Damage the Central Lightning Forge |q 12988/2
	step
		goto 30.2,46.1
		.' Use Bouldercrag's Bomb next to the Lightning Forge |use Bouldercrag's Bomb##42441 |tip The Lightning Forge looks like a big brown dwarf head with a big blue crystal on top of it.
		.' Damage the South Lightning Forge |q 12988/3
	step
		goto 30.0,46.3
		.kill 10 Stormforged Artificer##29376 |q 12991/1
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin Destroy the Forges!##12988
	step
		goto 31.3,38.2
		.talk Bruor Ironbane##30152
		..turnin Hit Them Where it Hurts##12991
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..accept A Colossal Threat##12993
	step
		goto 28.9,44.1
		.click Colossus Attack Specs##210
		.get Click the Colossus Attack Specs |q 12993/1
	step
		goto 29.9,45.8
		.click Colossus Defense Specs##210
		.get Click the Colossus Defense Specs |q 12993/2
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin A Colossal Threat##12993
		..accept The Heart of the Storm##12998
	step
		'The entrance to the big round metal door starts here |goto 32.4,63.9,0.5 |c |tip It's a big metal hole on in the side of the mountain.
	step
		goto 36.2,60.9
		.click Heart of the Storm##7800
		.' Attempt to Secure the Heart of the Storm |q 12998/1
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Heart of the Storm##12998
		..accept The Iron Colossus##13007
	step
		goto 27.2,35.9
		.click Jormungar Control Orb##7951
		.' Start controlling a Jormungar |invehicle |c |q 13007
	step
		goto 27.2,42.0
		.' In order to move as the Jormungar, use the Submerge ability on your hotbar.  When you want to come back up to the surface, use the Emerge ability while submerged underground.
		.kill Iron Colossus##30300 |q 13007/1 |tip In order to kill the Iron Colossus, simply spam your Jormungar Strike and Acid Breath abilities when the Iron Colossus is close to you.  When he jumps up to do a ground slam, quickly use your Submerge ability and run away from the Iron Colossus.  Do not try to get behind him, as well will just spin around and ground slam you.  Repeat this process
	step
		'Click the red arrow button on your hotbar to stop controlling the Jormungar |outvehicle |c |q 13007
	step
		goto 31.4,38.1
		.talk Bouldercrag the Rockshaper##29801
		..turnin The Iron Colossus##13007
]])
ZygorGuidesViewer:RegisterInclude("A_Argent_Tourney_PreQ",[[
	step
		goto Zul'Drak,39.5,66.9
		.talk Commander Falstaav##28059
		..accept Parachutes for the Argent Crusade##12740
	step
		goto 38.4,67.1
		.' Use your Crusader Parachute on Argent Shieldmen and Argent Crusaders |use Crusader Parachute##39615 |tip It won't work on all of them.
		.' Equip 10 Argent forces with a parachute |q 12740/1
	step
		goto 39.5,66.9
		.talk Commander Falstaav##28059
		..turnin Parachutes for the Argent Crusade##12740
	step
		goto 40.3,66.6
		.talk Commander Kunz##28039
		..accept Pa'Troll##12596
	step
		goto 35,52.1
		.talk Alchemist Finklestein##28205
		..accept Lab Work##12557
	step
		'Go into the 2 rooms next to you:
		.' They are items on shelves that you can click
		.' Click a Muddy Mire Maggot and get it |q 12557/1 |tip Muddy Mide Maggots look like an open bag of grain on the ground.
		.' Click a Withered Batwing and get it |q 12557/2 |tip Withered Batwings looks like bone wings.
		.' Click a Chilled Serpent Mucus and get it |q 12557/4 |tip Chilled Serpent Mucus looks like a skinny green vial.
		.' Click an Amberseed and get it |q 12557/3 |tip Amberseeds look like spiked potatoes.
	step
		goto 35,52.1
		.talk Alchemist Finklestein##28205
		..turnin Lab Work##12557
		.' Complete Alchemist Finklestein's task |q 12596/4
	step
		goto 48.2,63.9
		.talk Captain Grondel##28043
		..accept Creature Comforts##12599
	step
		goto 46.9,61.4
		.' Click Dead Thornwoods|tip They look like curved thorny roots coming out of the water around this area.
		.get 20 Dead Thornwood|q 12599/1
	step
		goto 48.2,63.9
		.talk Captain Grondel##28043
		..turnin Creature Comforts##12599
		.' Complete Captain Grondel's Task |q 12596/3
	step
		goto 48.8,78.9
		.talk Captain Brandon##28042
		..accept Something for the Pain##12597
	step
		goto 44.9,79.5
		.' Click the Mature Water-Poppy plants |tip They look like tall white-leaved plants with purple bulbs at the top.
		.get 5 Mature Water-Poppy|q 12597/1
	step
		goto 48.8,78.9
		.talk Captain Brandon##28042
		..turnin Something for the Pain##12597
		.' Complete Captain Brandon's Task |q 12596/1
	step
		goto 58.1,72.4
		.talk Captain Rupert##28044
		..accept Throwing Down##12598
	step
		goto 53.4,68.7
		.' Use your High Impact Grenade next to Nerubian Tunnels |use High Impact Grenade##38574 |tip They look like squarish pyramid dirt mounds around this area.
		.' Seal 5 Nerubian Tunnels |q 12598/1
	step
		goto 58.1,72.4
		.talk Captain Rupert##28044
		..turnin Throwing Down##12598
		.' Complete Captain Rupert's Task |q 12596/2
	step
		goto 40.3,66.6
		.talk Commander Kunz##28039
		..turnin Pa'Troll##12596
]])
ZygorGuidesViewer:RegisterInclude("A_SSO_PreQuest_Dailies",[[
	step
		goto Shattrath City 49.1,42.5
		.talk Exarch Nasuun##24932
		..accept Maintaining the Sunwell Portal##11514
	step
		goto 62.8,36.0
		.talk Lord Torvos##25140
		..accept Sunfury Attack Plans##11877
	step
		goto 62.8,35.6
		.talk Emissary Mordin##19202
		..accept Gaining the Advantage##11875
		only if skill("Skinning")>300 or skill("Mining")>300 or skill("Herbalism")>300
	step
		goto Shattrath City,61.7,52.1
		.talk Harbinger Haronem##19475
		..accept The Multiphase Survey##11880
	step
		goto Nagrand,50.3,40.4
		.from Clefthoof Bull##17132+,Talbuk Thorngrazer##17131+,Wild Elekk##18334+
		.' Skin their corpses in order to collect the Nether Residue.
		.get 8 Nether Residue##35229 |q 11875/1
		only if skill("Skinning")>=300
	step
		goto 40.8,31.6
		.' Mine inside the cave and collect Nether Residue.
		.collect 8 Nether Residue##35229 |q 11875/1
		.' You can check [Nagrand,50.0,56.6] for more Mining Nodes.
		only if skill("Mining")>=300
	step
		goto Nagrand,38.3,65.3
		.' Fly around the Spirit Fields looking for Fiery Red Orbs on the ground.
		.' Use your Multiphase Spectrographic Goggles on the Orbs. |use Multiphase Spectrographic Goggles##35233
		..goal 6 Multiphase Readings Taken |q 11880/1
	step
		goto Blade's Edge Mountains,54.0,18.1
		.from Unbound Ethereal##22244+,Bash'ir Raider##22241+,Bash'ir Arcanist##22243+,Bash'ir Spell-Thief##22242+
		.collect 1 Bash'ir Phasing Device |n
		'Use the Bash'ir Phasing Device. |use Bash'ir Phasing Device##34248
		.' Become Out of Phase |havebuff Interface\Icons\Ability_Mage_Invisibility
		.click Smuggled Mana Cell##7257
		.' Collect 10 Smuggled Mana Cell |q 11514/1
	step
		goto Netherstorm,25.9,66.8
		.from Sunfury Bloodwarder##18853+,Sunfury Captain##19453+,Sunfury Magister##18855+,Sunfury Geologist##19779+,Sunfury Astromancer##19643
		.get Sunfury Attack Plans |q 11877/1
	step
		goto Shattrath City,62.8,36.0
		.talk Lord Torvos##25140
		.turnin Sunfury Attack Plans##11877
	step
		goto 62.8,35.6
		.talk Emissary Mordin##19202
		.turnin Gaining the Advantage##11875
	step
		goto 61.6,52.2
		.talk Harbinger Haronem##19475
		.turnin The Multiphas Survey##11880
	step
		goto 49.1,42.5
		.talk Exarch Nasuun##24932
		.turnin Maintaining the Sunwell Portal##11514
	step
		goto Isle of Quel'Danas,47.5,35.4
		.talk Astromancer Darnarian##25133
		..accept Know Your Ley Lines##11547
	step
		goto 47.5,35.1
		.talk Battlemage Arynna##25057
		..accept The Air Strikes Must Continue##11533
	step
		goto 47.6,35.1
		.talk Harbinger Inuuro##25061
		..accept The Battle Must Go On##11537
	step
		goto 48.8,37.2
		.talk Anchorite Ayuri##25112
		..accept Your Continued Support##11548
		.' This quest requires that you give 10 Gold in trade of reputation with the Shattered Sun Offensive, you should be able to turn it in immidiately.
		..turnin Your Continued Support##11548
	step
		goto 50.6,39.0
		.talk Vindicator Kaalan##25108
		..accept Keeping the Enemy at Bay##11543
	step
		goto 49.3,40.4
		.talk Magister Ilastar##25069
		..accept Crush the Dawnblade##11540
	step
		goto 50.6,40.8
		.talk Smith Hauthaa##25046
		..accept Don't Stop Now....##11536
		..accept Ata'mal Armaments##11544
	step
		goto 51.5,32.5
		.talk Mar'nah##24975
		..accept Rediscovering Your Roots##11521
		..accept Open for Business##11546
	step
		goto 53.8,34.3
		.talk Captain Valindria##25088
		..accept Disrupt the Greengill Coast##11541
	step
		goto 47.5,30.5
		.talk Captain Theris Dawnhearth##24967
		..accept Arm the Wards!##11523
		..accept The Missing Magistrix##11526
	step
		goto 47.1,30.7
		.talk Vindicator Xayann##24965
		..accept Further Conversions##11525
	step
		goto Isle of Quel'Danas,44.3,28.5
		.from Wretched Fiend##24966+
		.collect 4 Mana Remnants##34338 |q 11523 |c
		.kill Erratic Sentry##24972+ |n
		.' Use Attuned Crystal Cores on the Erratic Sentries corpse. |use Attuned Crystal Cores##34368
		..goal 5 Converted Sentry Deployed |q 11525/1
		.click Bloodberry Bush##28
		..collect 5 Bloodberry |q 11546/1 |tip They can be found all around this area on the ground.
	step
		goto Isle of Quel'Danas,42.1,35.7
		.kill 6 Dawnblade Summoner |q 11540/1
		.kill 6 Dawnblade Blood Knight |q 11540/2
		.kill 3 Dawnblade Marksman |q 11540/3
		.' Use your Astromancer's Crystal to sample the Bloodcrystal's density. |use Astromancer's Crystal##34533
		.' Bloodcrystal Reading Taken |q 11547/3
	step
		goto Isle of Quel'Danas,46.5,35.5
		.' Use the Mana Remnants to Energize the Crystal Ward. |use Mana Remnants##34338
		.' Energize a Crystal Ward |q 11523/1
	step
		goto 48.5,25.2
		.talk Ayren Cloudbreaker##25059
		.' Tell him you Need to Intercept the Dawnblade Reinforcements.
		.' Use your Flaming Oil to set fire to the ships sails as you fly around. |use Flaming Oil##34489
		.' Sin'loren sails burned |q 11543/1
		.' Bloodoath sails burned |q 11543/2
		.' Dawnchaser sails burned |q 11543/3
	step
		.kill 6 Dawnblade Reservist##25087+ |q 11543/4
		.' You can find more at [Isle of Quel'Danas,51.1,9.7]
		.' Another spot for them is at [Isle of Quel'Danas,55.2,11.8]
	step
		goto Isle of Quel'Danas,52.4,17.4
		.talk Unrestrained Dragonhawk##25236
		.' Ride the dragonhawk to Sun's Reach. |goto Isle of Quel'Danas,48.4,25.3 |noway|c
	step
		goto Isle of Quel'Danas,48.5,25.2
		.talk Ayren Cloudbreaker##25059
		.' Tell him you've been ordered to undertake an airstrike.
		.' Use your Arcane Charges on mobs once you get to the Dead Scar. |use Arcane Charges##34475
		.kill 2 Pit Overlord##25031+ |q 11533/1
		.kill 3 Eredar Sorcerer##25033+ |q 11533/2
		.kill 12 Wrath Enforcer##25030+ |q 11533/3
	step
		goto Isle of Quel'Danas,48.5,43.7
		.kill Emissary of Hate##25003 |n
		.' Use your Shattered Sun Banner on his corpse. |use Shattered Sun Banner##34414
		.' Impale the Emissary of Hate |q 11537/1
		.kill 6 Burning Legion Demon |q 11537/2
		.' Use your Astromancer's Crystal to sample the Portal's density. |use Astromancer's Crystal##34533
		.' Portal Reading Taken |q 11547/1
	step
		.' Take this path back to they shoreside. |goto Isle of Quel'Danas,57.3,38.6 |c
	step
		goto Isle of Quel'Danas,64.1,49.9
		.from Darkspine Myrmidon##25060+
		..collect Darkspine Chest Key##34477 |n
		.from Darkspine Siren##25073+
		..collect Orb of Murloc Control##34483 |n
		.' Use your Orbs of Murloc Control on Greengill Slaves along the shore. |use Orb of Murloc Control##34483
		.' Free 10 Greengill Slaves |q 11541/1
		.' Use your Darkspine Chest Keys on the Darkspine Ore Chest.
		.get 3 Darkspine Iron Ore |q 11536/1
	step
		goto Isle of Quel'Danas,61.1,62.0
		.' Use your Astromancer's Crystal to sample the Shrine's density. |use Astromancer's Crystal##34533
		.' Shrine Reading Taken |q 11547/2
	step
		goto Isle of Quel'Danas,53.8,34.3
		.talk Captain Valindria##25088
		..turnin Disrupt the Greengill Coast##11541
	step
		goto 50.6,40.7
		.talk Smith Hauthaa##25046
		..turnin Don't Stop Now....##11536
	step
		goto 50.6,39.0
		.talk Vindicator Kaalan##25108
		..turnin Keeping the Enemy at Bay##11543
	step
		goto 49.3,40.4
		.talk Magister Ilastar##25069
		..turnin Crush the Dawnblade##11540
	step
		goto 51.5,32.5
		.talk Mar'nah##24975
		..turnin Open for Business##11546
	step
		goto 47.5,35.3
		.talk Astromancer Darnarian##25133
		.turnin Know Your Ley Lines##11547
	step
		goto 47.5,35.1
		.talk Battlemage Arynna##25057
		.turnin The Air Strikes Must Continue##11533
	step
		goto 47.6,35.1
		.talk Harbinger Inuuro##25061
		.turnin The Battle Must Go On##11537
	step
		goto 47.5,30.5
		.talk Captain Theris Dawnhearth##24967
		.turnin Arm the Wards!##11523
	step
		goto 47.1,30.7
		.talk Vindicator Xayann##24965
		.turnin Further Conversions##11525
	step
		goto Isle of Quel'Danas,48.5,44.7
		|use Captured Legion Scroll##34420
		.' Teleport to Hellfire Peninsula |goto Hellfire Peninsula,58.6,18.7,0.5 |noway|c
	step
		goto Hellfire Peninsula,58.2,17.6
		.talk Magistrix Seyla##24937
		.turnin The Missing Magistrix##11526
		..accept Blood for Blood##11515
		..accept Blast the Gateway##11516
	step
		goto Hellfire Peninsula,66.4,20.1
		.from Wrath Herald##24919+
		.collect 4 Demonic Blood##34259
		.' use the Sizzling Embers to summon a Living Flare. |use Sizzling Embers##34253
		.kill Incandescent Fel Spark##22323+ |n
		.' Once you see a message that says _"Living Flare becomes unstable with brimming energy!"_ take it to [Hellfire Peninsula,58.6,18.7].
		.' Legion Gateway Destroyed |q 11516/1
	step
		goto 59.9,21.0
		.' Use your Fel Siphon on Felblood Initiates. |use Fel Siphon##34257
		.kill 4 Emaciated Felblood##24918 |q 11515/1
	step
		goto Hellfire Peninsula,58.2,17.6
		.talk Magistrix Seyla##24937
		.turnin Blast the Gateway##11516
		.turnin Blood for Blood##11515
	step
		goto Terokkar Forest,59.7,10.3
		.from Razorthorn Flayer##24920+
		..collect Razorthorn Flayer Gland##34255 |q 11521 |n
		.' Use your Razorthorn Flayer Gland on Razorthorn Ravagers. |use Razorthorn Flayer Gland##34255
		.' Use your pets Expose Razorthorn Root ability on mounds of dirt around the area. |cast Expose Razorthorn Root##44935
		.collect 5 Razorthorn Root##34254 |q 11521/1
	step
		 goto Shadowmoon Valley,68.5,37.5
		.from Shadowmoon Chosen##22084+,Shadowmoon Slayer##22082+,Shadowmoon Darkweaver##22081+
		.collect 5 Ata'mal Armament##34500 |q 11544
	step
		goto Isle of Quel'Danas,51.5,32.5
		.talk Mar'nah##24975
		.turnin Rediscovering Your Roots##11521
	step
		goto 50.6,40.7
		.' Click the Ata'mal Armaments and cleanse them at Hauthaa's Anvil. |use Ata'mal Armament##34500
		.' Cleanse 5 Ata'mal Metals |q 11544/1
	step
		goto 50.6,40.7
		.talk Smith Hauthaa##25046
		..turnin Ata'mal Armaments##11544
]])
ZygorGuidesViewer:RegisterInclude("A_Therazane_PreQuest", [[
	step
		goto Stormwind City,62.9,71.6
		.click Hero's Call Board##10016
		..accept Hero's Call: Deepholm!##27727
	step
		goto 74.5,19.0
		.talk Naraat the Earthspeaker##45226
		..turnin Hero's Call: Deepholm!##27727
		..accept The Maelstrom##27203
	step
		goto The Maelstrom,33.4,50.2
		.talk Thrall##45042
		..turnin The Maelstrom##27203
		..accept Deepholm, Realm of Earth##27123
	step
		goto 32.5,52.0
		.clicknpc Wyvern##45005
		.' You will fly into Deepholm |goto Deepholm,49.9,54.7,0.5 |noway |c
	step
		goto Deepholm,49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Deepholm, Realm of Earth##27123
		..accept Gunship Down##26245
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..accept Elemental Energy##27136
		..accept The Earth Claims All##26244
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..accept Where's Goldmine?##26409
	step
		goto 49.2,51.9
		.talk Caretaker Nuunwa##45300
		.home Temple of Earth
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Where's Goldmine?##26409
		..accept Explosive Bonding Compound##26410
		..accept Something that Burns##27135
	step
		goto 45.5,57.9
		.from Rockslice Flayer##42606+, Rockslice Ripper##42607+
		.get 5 Quartzite Resin |q 26410/1
		.' You can find more Rockslice Flayers around [42.5,55.6]
	step
		goto 51.1,61.6
		.' Use your Depleted Totem |use Depleted Totem##60835
		.from Lodestone Elemental##43258+, Energized Geode##43254+ |tip Kill them next to your Depleted Totems.
		.' Energize the Totem 8 Times |q 27136/1
	step
		goto 52.0,58.9
		.' Use Goldmine's Fire Totem in the red lava spot |use Goldmines's Fire Totem##60834
		.from Magmatooth##45099
		.get The Burning Heart |q 27135/1
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Explosive Bonding Compound##26410
		..turnin Something that Burns##27135
		..accept Apply and Flash Dry##26411
	step
		goto 46.6,57.2
		.' Use your Explosive Bonding Compound on Flint Oremantle |use Explosive Bonding Compound##58502 |modelnpc Flint Oremantle##43036+
		.' Apply the Explosive Bonding Compound |q 26411/1
	step
		goto 46.5,57.3
		.talk Initiate Goldmine##42574
		..turnin Apply and Flash Dry##26411
		..accept Take Him to the Earthcaller##26413
	step
		goto 49.5,53.3
		.' Introduce Flint Oremantle to Earthcaller Yevaa |q 26413/1
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..turnin Take Him to the Earthcaller##26413
		..accept To Stonehearth's Aid##26484
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin Elemental Energy##27136
	step
		goto 56.1,74.2
		.clicknpc Slain Cannoneer##43032
		.' Receive the Second Clue |q 26245/2
	step
		goto 53.5,73.8
		.clicknpc Captain Skullshatter##43048
		.' Receive the First Clue |q 26245/1
	step
		goto 53.6,73.8
		.click Captain's Log##6891
		..accept Captain's Log##26246
	step
		goto 56.7,76.4
		.clicknpc Unexploded Artillery Shell##43044
		.' Receive the Third Clue |q 26245/3
	step
		goto 55.9,74.9
		.kill 5 Deepstone Elemental##43026+ |q 26244/1
	step
		goto 49.6,52.9
		.talk Maruut Stonebinder##43065
		..turnin Gunship Down##26245
		..turnin Captain's Log##26246
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin The Earth Claims All##26244
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..accept Diplomacy First##26247
	step
		goto 62.4,52.6
		.talk Stormcaller Mylra##42684 |tip She's up above in an airship patrolling this area.
		..turnin Diplomacy First##26247
		..accept All Our Friends Are Dead##26248
		..accept The Admiral's Cabin##26249
	step
		'All around on this air ship:
		.' Use your Spirit Totem on Slain Crew Members |use Spirit Totem##58167
		.' Receive 6 Slain Crew Member Information |q 26248/1
		|modelnpc Slain Crew Member##42681+
	step
		'Enter the doorway on the main deck of the air ship:
		.talk First Mate Moody##43082
		..turnin The Admiral's Cabin##26249
		..accept Without a Captain or Crew##26427
	step
		'Leave through the doorway and immediately turn right:
		.click Bottle of Whiskey##9712 |tip Located on the life boat.
		.get Bottle of Whiskey |q 26427/1
	step
		'All around on the deck of the air ship:
		.click Spool of Rope##7538
		.get Spool of Rope |q 26427/2
	step
		'Enter the doorway on the main deck of the air ship:
		.talk First Mate Moody##43082
		..turnin Without a Captain or Crew##26427
	step
		'Go to the very top of the air ship:
		.talk Stormcaller Mylra##42684
		..turnin All Our Friends Are Dead##26248
		..accept Take No Prisoners##26251
		..accept On Second Thought, Take One Prisoner##26250
	step
		'Go onto the main deck of the ship and go down the stairs to the deck below:
		.' Fight Mor'norokk the Hateful until he surrenders |tip He's downstairs in the airship, in the very back of the first level you come to.
		.talk Mor'norokk the Hateful##42801
		.' Subdue Mor'norokk the Hateful |q 26250/1
	step
		'All around on this lower deck of the air ship:
		.kill 6 Twilight Saboteur##42885 |q 26251/1
	step
		'Go to the very top of the air ship:
		.talk Stormcaller Mylra##42684
		..turnin Take No Prisoners##26251
		..turnin On Second Thought, Take One Prisoner##26250
		..accept Some Spraining to Do##26254
	step
		Next to Stormcaller Mylra:
		.clicknpc Stormbeak##42887
		.' Interrogate Mok'norrok |q 26254/1
	step
		'When you land on the air ship again:
		.talk Stormcaller Mylra##42684
		..turnin Some Spraining to Do##26254
		..accept Return to the Temple of Earth##26255
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Return to the Temple of Earth##26255
		..accept Deathwing's Fall##26258
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..accept Blood of the Earthwarder##26259
	step
		goto 59.4,58.2
		.' Go to this spot
		.' Reach Deathwing's Fall |q 26258/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Deathwing's Fall##26258
		..accept Bleed the Bloodshaper##26256
	step
		goto 61.5,60.6
		.from Twilight Bloodshaper##43218+
		.get Twilight Orders |q 26256/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Bleed the Bloodshaper##26256
		..accept Question the Slaves##26261
	step
		goto 62.8,59.5
		.click Slavemaster's Coffer##41
		.collect 1 Twilight Slaver's Key##60739 |q 26261
	step
		goto 61.2,60.1
		.from Living Blood##43123+
		.get 5 Blood of Neltharion |q 26259/1
	step
		goto 64.5,65.5
		.click Ball and Chain##181+
		.' Free 6 Enslaved Miners |q 26261/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Question the Slaves##26261
		..accept The Forgemaster's Log##26260
	step
		goto 63.7,55.4
		.click Forgemaster's Log##6891
		..turnin The Forgemaster's Log##26260
		..accept Silvermarsh Rendezvous##27007
	step
		goto 70.6,61.2
		.' Go to this spot
		.' Reach Upper Silvermarsh |q 27007/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Silvermarsh Rendezvous##27007
		..accept Quicksilver Submersion##27010
	step
		goto 71.8,64.3
		.click Trogg Crate##9855
		.collect Trogg Crate##60809 |q 27010
		.from Murkstone Trogg##44936
		.collect 1 Maziel's Research##60816 |n
		.' Click Maziel's Research in your bags |use Maziel's Research##60816
		..accept Twilight Research##27100
	step
		goto 74.9,64.8
		.' Use your Trogg Crate in the water and swim to this spot |use Trogg Crate##60809
		.' Watch the dialogue
		.' Uncover the World Pillar Fragment Clue |q 27010/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Quicksilver Submersion##27010
		..accept The Twilight Overlook##27061
	step
		goto 72.5,65.2
		.from Mercurial Ooze##43158+
		.get 4 Twilight Research Notes |q 27100/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Twilight Research##27100
		..accept Maziel's Revelation##27101
	step
		goto 67.2,70.2
		.click Maziel's Journal##2530
		..turnin Maziel's Revelation##27101
		..accept Maziel's Ascendancy##27102
	step
		goto 69.5,68.0 |n
		.' Enter the cave |goto 69.5,68.0,0.5 |noway |c
	step
		goto 72.8,62.0
		.kill Maziel##44967 |q 27102/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Maziel's Ascendancy##27102
	step
		goto 69.5,68.0 |n
		.' Leave the cave |goto 69.5,68.0,0.5 |noway |c
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin The Twilight Overlook##27061
		..accept Big Game, Big Bait##26766
		..accept To Catch a Dragon##26768
	step
		goto 58.0,84.8
		.from Jadecrest Basilisk##43981+
		.' Use Mylra's Knife on Jadecrest Basilisk corpses |use Mylra's Knife##60382
		.get 5 Side of Basilisk Meat |q 26766/1
		.from Twilight Dragonstalker##43992+
		.get Twilight Snare |q 26768/1
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin Big Game, Big Bait##26766
		..turnin To Catch a Dragon##26768
		..accept Testing the Trap##26771
	step
		goto 50.9,85.3
		.' Use your Trapped Basilisk Meat |use Trapped Basilisk Meat##60773
		.kill Stonescale Matriarch##44148 |q 26771/1
	step
		goto 64.5,82.1
		.talk Stormcaller Mylra##44010
		..turnin Testing the Trap##26771
		..accept Abyssion's Minions##26857
	step
		goto 64.6,82.2
		.talk Seer Galekk##44222
		..accept Block the Gates##26861
	step
		goto 68.7,75.0
		.' Use your Stormstone next to the swirling blue portal |use Stormstone##60501
		.' Disrupt the Twilight Gate |q 26861/1
	step
		goto 71.2,75.1
		.' Use your Stormstone next to the structure with the floating yellow crystal |use Stormstone##60501
		.' Disrupt the Elemental Gate |q 26861/2
	step
		goto 69.9,76.7
		.from Scalesworn Cultist##44221+, Twilight Scalesister##43967+, Twilight Dragonspawn##43966+
		.' Defeat 8 Abyssion's Underlings |q 26857/1
	step
		goto 64.6,82.2
		.talk Seer Galekk##44222
		..turnin Block the Gates##26861
	step
		goto 64.5,82.2
		.talk Stormcaller Mylra##44010
		..turnin Abyssion's Minions##26857
		..accept The World Pillar Fragment##26876
	step
		goto 69.9,76.9
		.' Use your Earthen Ring Banner |use Earthen Ring Banner##60810
		.from Abyssion##44289
		.click The First Fragment of the World Pillar##9779
		.get The Upper World Pillar Fragment |q 26876/1
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin The World Pillar Fragment##26876
	step
		goto 49.7,52.9
		.talk Seer Kormo##43397
		..turnin Blood of the Earthwarder##26259
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin To Stonehearth's Aid##26484
		..accept The Quaking Fields##27931
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..turnin The Quaking Fields##27931
		..accept The Axe of Earthly Sundering##27932
		..accept Elemental Ore##27933
	step
		goto 32.2,79.1
		.' Use The Axe of Earthly Sundering on Emerald Colossi |use The Ace of Earthly Sundering##60490
		.kill 5 Sundered Emerald Colossus##44229 |q 27932/1
		.from Jade Rager##44220+
		.get 6 Elemental Ore |q 27933/1
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..turnin The Axe of Earthly Sundering##27932
		..turnin Elemental Ore##27933
		..accept One With the Ground##27934
	step
		goto 30.6,77.7
		.talk Slate Quicksand##47195
		..' Tell him you are ready for the ritual
		.' Complete the One With the Ground Ritual |q 27934/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin One With the Ground##27934
		..accept Bring Down the Avalanche##27935
	step
		goto 46.9,89.1
		.kill Avalanchion##44372 |q 27935/1
	step
		goto 43.4,82.0 |n
		.' Leave the cave |goto 43.4,82.0,0.5 |noway |c
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin Bring Down the Avalanche##27935
		..accept Stonefather's Boon##26499
	step
		goto 28.2,69.6
		.talk Earthbreaker Dolomite##43160
		..accept We're Surrounded##26500
	step
		goto 29.7,68.8
		.kill 12 Stone Trogg Ambusher##43134+ |q 26500/1
		.' Use Stonefather's Banner next to Stone Hearth Defenders |use Stonefather's Banner##58884 |modelnpc Stonehearth Defender##43138+
		.' Grant the Stonefather's Boon 12 times |q 26499/1
	step
		goto 28.2,69.6
		.talk Earthbreaker Dolomite##43160
		..turnin We're Surrounded##26500
		..accept Thunder Stones##26502
	step
		goto 27.9,68.7
		.talk Crag Rockcrusher##43071
		..turnin Stonefather's Boon##26499
		..accept Sealing the Way##26501
	step
		goto 27.3,67.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Shrine |q 26501/4
	step
		goto 26.0,68.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Barracks |q 26501/3
	step
		goto 26.2,69.8
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Inn |q 26501/2
	step
		goto 27.3,70.1
		.' Use your Rockslide Reagent on the Earthen Geomancer |use Rockslide Reagent##58885 |modelnpc Earthen Geomancer##43170+
		.' Seal the Armory |q 26501/1
		.click Thunder Stone##9722+
		.get 12 Thunder Stone |q 26502/1
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Sealing the Way##26501
		..accept Shatter Them!##26537
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..turnin Thunder Stones##26502
		..accept Fixer Upper##26564
	step
		goto 24.6,62.2
		.talk Earthmender Deepvein##43319
		..accept Battlefront Triage##26591
	step
		goto 23.9,60.3
		.' Use Deepvein's Patch Kit on Injured Earthens |use Deepvein's Patch Kit##58965 |modelnpc Injured Earthen##43233
		.' Patch up 10 Injured Earthen |q 26591/1
		.' Click Catapult Parts |tip They look kind of like big metal parts laying on the ground around this area.
		.get 6 Catapult Part |q 26564/1
		.from Stone Trogg Berserker##43228+, Stone Trogg Geomancer##43234+, Needlerock Rider##43250+
		.kill 12 Fractured Battlefront stone troggs |q 26537/1
		.' You can also look around 23.1,53.9 for more
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Shatter Them!##26537
	step
		goto 24.6,62.2
		.talk Earthmender Deepvein##43319
		..turnin Battlefront Triage##26591
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..turnin Fixer Upper##26564
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..accept Troggzor the Earthinator##26625
	step
		goto 22.6,56.9
		.from Troggzor the Earthinator##43456
		.get The Earthinator's Cudgel |q 26625/1
	step
		goto 24.5,62.4
		.talk Gravel Longslab##43168
		..turnin Troggzor the Earthinator##26625
	step
		goto 24.8,62.2
		.talk Clay Mudaxle##43169
		..accept Rush Delivery##27126
	step
		goto 20.7,61.6
		.talk Peak Grindstone##45043
		..turnin Rush Delivery##27126
		..accept Close Escort##26632
	step
		goto 20.7,61.6
		.talk Peak Grindstone##45043
		..' Tell him you're ready to escort the catapult |tip You need to be near the catapult or it will stop
		.' Safely Escort the Earthen Catapult |q 26632/1
		|modelnpc Earthen Catapult##43509+
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Close Escort##26632
		..accept Keep Them off the Front##26755
	step
		goto 22.4,52.0
		.clicknpc Earthen Catapult##43509
		.' Use your Fire Catapult ability on your hotbar on the Stone Trogg and Fungal mobs
		.' Bombard 30 Reinforcements |q 26755/1
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Keep Them off the Front##26755
		..accept Reactivate the Constructs##26762
	step
		goto 22.8,52.1
		.talk Flint Oremantle##43898
		..accept Mystic Masters##26770
	step
		goto 22.6,47.6
		.clicknpc Deactivated War Construct##43984
		.' Reactivate 5 Deactivated War Constructs |q 26762/1
		.kill 5 Needlerock Mystic |q 26770/1
		.'|tip Activate the golems before attacking mystics.
	step
		goto 22.8,52.1
		.talk Flint Oremantle##43898
		..turnin Mystic Masters##26770
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Reactivate the Constructs##26762
		..accept Down Into the Chasm##26834
	step
		goto 27.6,44.8
		.talk Slate Quicksand##44143
		..turnin Down Into the Chasm##26834
		..accept Sprout No More##26791
		..accept Fungal Monstrosities##26792
	step
		goto 27.6,44.7
		.clicknpc War Guardian##44126
		.' Obtain a War Guardian for the Sprout No More quest |q 26791/1
		.' Obtain a War Guardian for the Fungal Monstrosities quest |q 26792/1
	step
		goto 26.8,41.8
		.kill 5 Fungal Monstrosity##44035+ |q 26792/2
		.clicknpc Giant Mushroom##44049+
		.' Destroy 5 Giant Mushrooms |q 26791/2
	step
		goto 27.6,44.8
		.talk Slate Quicksand##44143
		..turnin Sprout No More##26791
		..turnin Fungal Monstrosities##26792
		..accept A Slight Problem##26835
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin A Slight Problem##26835
		..accept Rescue the Stonefather... and Flint##26836
	step
		goto 24.5,31.1
		.from Bouldergut##44151
		.' Rescue Stonefather Oremantle |q 26836/1
	step
		goto 22.7,52.0
		.talk Pyrium Lodestone##43897
		..turnin Rescue the Stonefather... and Flint##26836
		..accept The Hero Returns##27937
	step
		goto 28.0,68.6
		.talk Stonefather Oremantle##44204
		..turnin The Hero Returns##27937
		..accept The Middle Fragment##27938
	step
		goto 28.0,68.7
		.click The Stonefather's Safe##7608
		.get The Middle Fragment of the World Pillar |q 27938/1
	step
		goto 49.5,53.3
		.talk Earthcaller Yevaa##42573
		..turnin The Middle Fragment##27938
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..accept The Very Earth Beneath Our Feet##26326
	step
		goto 46.1,45.6
		.talk Earthcaller Torunscar##42730
		..turnin The Very Earth Beneath Our Feet##26326
		..accept Crumbling Defenses##26312
		..accept On Even Ground##26314
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..accept Core of Our Troubles##26313
	step
		goto 44.3,43.7
		.from Irestone Rumbler##42780+
		.get Irestone Core##58168 |q 26313/1 |n
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Stormcaller Mylra |q 26312/2
		|modelnpc Servant of Therazane##42781+
	step
		goto 44.5,41.3
		.from Irestone Rumbler##42780+
		.get Irestone Core##58168 |q 26313/1 |n
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Tawn Winterbluff |q 26312/1
		|modelnpc Servant of Therazane##42781+
	step
		goto 47.6,42.8
		.from Irestone Rumbler##42780+
		.get Irestone Core##58168 |q 26313/1 |n
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Relieve Hargoth Dimblaze |q 26312/3
		|modelnpc Servant of Therazane##42781+
	step
		goto 46.2,42.2
		.from Irestone Rumbler##42780+
		.get 6 Irestone Core |q 26313/1
		.' Use your Elementium Grapple Line on Servants of Therazane |use Elementium Grapple Line##58169 |tip Run away from the Servants of Therazane to bring them down.
		.' Bring down 3 Servants of Therazane |q 26314/1
		|modelnpc Servant of Therazane##42781+
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..turnin Core of Our Troubles##26313
	step
		goto 46.1,45.6
		.talk Earthcaller Torunscar##42730
		..turnin Crumbling Defenses##26312
		..turnin On Even Ground##26314
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..accept Imposing Confrontation##26315
	step
		goto 49.2,40.1
		.' Use your Earthen Ring Proclamation on Boden the Imposing |use Earthen Ring Proclamation##58177 |tip He's a huge rock giant that walks around this area.
		.' Seek Peace with Boden the Imposing |q 26315/1
		|modelnpc Boden the Imposing##42471+
	step
		goto 46.2,45.7
		.talk Earthmender Norsala##42731
		..turnin Imposing Confrontation##26315
		..accept Rocky Relations##26328
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin Rocky Relations##26328
		..accept Hatred Runs Deep##26376
		..accept Unsolid Ground##26377
	step
		goto 56.5,41.0
		.talk Quartz Stonetender##42899
		..accept Loose Stones##26375
	step
		goto 60.2,39.4
		.kill Dragul Giantbutcher##42921 |q 26376/1
	step
		goto 59.5,41.5
		.click Jade Crystal Cluster##9694+
		.collect 6 Jade Crystal Cluster##58500 |q 26377
		.' Use your Delicate Chain Smasher next to Quartz Rocklings |use Delicate Chain Smasher##58254 |tip They look like small rock giants around this area.
		.' Release 6 Quartz Rocklings |q 26375/1
		|modelnpc Quartz Rockling##42900+
	step
		'Use the Jade Crystal Clusters |use Jade Crystal Cluster##58500
		.collect Jade Crystal Composite##58783 |q 26377
	step
		goto 59.6,41.4
		.' Use your Jade Crystal Composite |use Jade Crystal Composite##58783
		.' Lure an Agitated Tunneler |q 26377/1
	step
		goto 59.3,40.6
		.from Twilight Laborer##42924+, Twilight Priestess##42823+, Twilight Duskwarden##42917+
		.kill 12 Lorthuna's Gate Cultists |q 26376/2
	step
		goto 56.5,41.0
		.talk Quartz Stonetender##42899
		..turnin Loose Stones##26375
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin Hatred Runs Deep##26376
		..turnin Unsolid Ground##26377
		..accept Violent Gale##26426
	step
		goto 51.7,31.6
		.' Get next to Felsen the Enduring
		.' Find Felsen the Enduring |q 26426/1
		' |modelnpc 43805
	step
		goto 58.4,25.7
		.' Fly to the mouth of this cave
		.' Find the entrance to the Crumbling Depths |q 26426/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Violent Gale##26426
		..accept Depth of the Depths##26869
	step
		goto 64.5,21.7 |n
		.' Follow the path |goto 64.5,21.7,0.5 |noway |c
	step
		goto 65.3,18.4 |n
		.' Follow the path |goto 65.3,18.4,0.5 |noway |c
	step
		goto 66.4,20.6
		.click Gigantic Painite Cluster##9815
		..turnin Depth of the Depths##26869
		..accept A Rock Amongst Many##26871
	step
		goto 64.3,23.5
		.' Follow the path to this spot, then jump down |goto 64.3,23.5,0.5 |noway |c
	step
		goto 58.3,25.5 |n
		.' Leave the cave |goto 58.3,25.5,0.5 |noway |c
	step
		goto 56.5,42.7
		.talk Diamant the Patient##42467
		..turnin A Rock Amongst Many##26871
		..accept Entrenched##26436
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Entrenched##26436
		..accept Intervention##26438
		..accept Making Things Crystal Clear##26437
	step
		goto 34.1,35.2
		.talk Berracite##43344
		..accept Putting the Pieces Together##26439
	step
		goto 30.5,46.8
		.from Jaspertip Borer##42524+, Jaspertip Swarmer##42521+, Jaspertip Ravager##42525+
		.kill 12 Jaspertip flayers |q 26438/1
		.click Chalky Crystal Formation##9715+
		.get 8 Chalky Crystal Formation |q 26437/1
		.clicknpc Dormant Stonebound Elemental##43115
		.' Reform 6 Stonebound Elementals |q 26439/1
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Intervention##26438
		..turnin Making Things Crystal Clear##26437
	step
		goto 34.1,35.2
		.talk Berracite##43344
		..turnin Putting the Pieces Together##26439
	step
		'Next to you:
		.talk Pebble##43116
		..accept Clingy##26440
	step
		goto 30.1,47.7
		.' Get next to the huge green crystals
		.' Bring Pebble to the crystal formation |q 26440/1
	step
		'Next to you:
		.talk Pebble##43116
		..turnin Clingy##26440
		..accept So Big, So Round...##26441
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin So Big, So Round...##26441
		..accept Petrified Delicacies##26507
		..accept Rock Bottom##26575
	step
		goto 47.6,26.8
		.kill Gorgonite##43339 |q 26575/1
	step
		goto 47.5,26.8
		.clicknpc Petrified Stone Bat##43182+
		.get 12 Petrified Stone Bat |q 26507/1
	step
		'Next to you:
		.talk Pebble##43116
		..turnin Petrified Delicacies##26507
	step
		goto 34.3,34.3
		.talk Kor the Immovable##42469
		..turnin Rock Bottom##26575
		..accept Steady Hand##26576
		..accept Rocky Upheaval##26577
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..turnin Steady Hand##26576
		..accept Don't. Stop. Moving.##26656
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..' Tell him you are ready to escort a group of elementals across the open.
		.' Speak to Terrath the Steady |q 26656/1
	step
		goto 51.1,14.7
		.' Go to this spot
		.' Escort 5 Opalescent Guardians to safety |q 26656/2 |tip Run on the ground with your mount, don't fly or you the rock elementals will disappear when you get too far away from them.
		' |modelnpc 43591
	step
		goto 39.9,19.4
		.talk Terrath the Steady##42466
		..turnin Don't. Stop. Moving.##26656
		..accept Hard Falls##26657
		..accept Fragile Values##26658
	step
		goto 35.4,22.5
		.from Stone Trogg Beast Tamer##43598 |tip He moves all around this area capturing basilisks, so you may need to look around a bit for him.
		.get Stonework Mallet |q 26658/1
	step
		goto 36.5,18.8
		.kill 6 Stone Drake##42522 |q 26657/1 |tip They will fall to the ground with half health, so you can kill them, even though they are elite.
	step
		goto 40.0,19.4
		.talk Terrath the Steady##42466
		..turnin Hard Falls##26657
		..turnin Fragile Values##26658
		..accept Resonating Blow##26659
	step
		goto 32.7,24.3
		.' Use your Stonework Mallet next to the Pale Resonating Crystal |use Stonework Mallet##60266
		.' Strike the Pale Resonating Crystal |q 26659/1
		.from Aeosera##43641 |tip Click the Boulder Platforms to jump from rock to rock while fighting Aeosera.  When she is casting her Searing Breath ability, jump to another rock and attack her while she is breathing fire to the other rock.  Repeat this until she surrenders.
		.' Defeat Aeosera |q 26659/2
		|model Pale Resonating Crystal##6415
	step
		goto 33.1,24.1
		.talk Terrath the Steady##42466
		..turnin Resonating Blow##26659
		.' If Terrath the Steady doesn't spawn at the appropriate spot, go to [40.0,19.4]
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Rocky Upheaval##26577
		..accept Doomshrooms##26578
		..accept Gone Soft##26579
		..accept Familiar Intruders##26580
	step
		goto 71.8,47.6
		.talk Windspeaker Lorvarius##43395
		..turnin Familiar Intruders##26580
		..accept A Head Full of Wind##26581
	step
		goto 73.6,40.8
		.kill 8 Fungal Behemoth##42475+ |q 26579/1
		.from Doomshroom##43388+
		.' Destroy 10 Doomshrooms |q 26578/1
		.' Gather a sample of the red mist |q 26581/1 |tip There are small clouds of red mist that float around on the ground around this area.  Walk into one of them to gather a sample.
		.' You will be able to find more Fungal Behemoths and Doomshrooms around [76.6,44.4]
	step
		goto 71.8,47.6
		.talk Windspeaker Lorvarius##43395
		..turnin A Head Full of Wind##26581
		..accept Unnatural Causes##26582
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Doomshrooms##26578
		..turnin Gone Soft##26579
		..turnin Unnatural Causes##26582
		..accept Shaken and Stirred##26584
		..accept Corruption Destruction##26585
	step
		goto 68.5,26.4
		.talk Ruberick##43442
		..accept Wrath of the Fungalmancer##26583
	step
		goto 68.6,29.1 |n
		.' Enter the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 69.8,31.9
		.talk Earthmender Norsala##43503
		..' Tell her you're ready when she is |q 26583/1
		.kill Fungalmancer Glop##43372 |q 26583/2 |tip Follow him each time he runs away.  Avoid the mushrooms as you walk, they will give you a debuff.  While fighting Fungalmancer Glop, avoid the Boomshrooms he creates.
	step
		goto 70.2,33.8 |n
		.' Follow the path up |goto 70.2,33.8,0.5 |noway |c
	step
		goto 68.6,29.1 |n
		.' Leave the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 68.5,26.3
		.talk Ruberick##43442
		..turnin Wrath of the Fungalmancer##26583
	step
		goto 69.4,24.8
		.kill 8 Verlok Pillartumbler##43513+ |q 26584/1
		.click Verlok Miracle-Grow##6895
		.get 8 Verlok Miracle-Grow |q 26585/1
	step
		goto 72.2,54.0
		.talk Gorsik the Tumultuous##42472
		..turnin Shaken and Stirred##26584
		..turnin Corruption Destruction##26585
		..accept At the Stonemother's Call##26750
	step
		goto 56.3,12.2
		.talk Therazane##42465
		..turnin At the Stonemother's Call##26750
		..accept Audience with the Stonemother##26752
	step
		'Watch the dialogue
		.' Attend the Stonemother's Audience |q 26752/1
	step
		goto 56.1,13.5
		.talk Earthcaller Torunscar##43809
		..turnin Audience with the Stonemother##26752
		..accept Rallying the Earthen Ring##26827
	step
		ding 83
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..accept The Twilight Plot##27004
	step
		goto 47.3,51.4
		.talk Prospector Brewer##44802
		..accept Fly Over##27006
	step
		goto 39.0,74.2
		.' Go to this spot next to the big white portal
		.' Investigate the Master's Gate |q 27006/1
	step
		goto 40.1,72.2
		.from Twilight Cryptomancer##44855+, Twilight Crusher##44849+, Twilight Armsman##44847+
		.get Masters' Gate Plans |q 27004/1
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..turnin The Twilight Plot##27004
	step
		goto 47.3,51.4
		.talk Prospector Brewer##44802
		..turnin Fly Over##27006
		..accept Fight Fire and Water and Air with...##27042
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..accept Decryption Made Easy##27040
	step
		goto 40.8,66.3
		.from Bound Water Elemental##44886
		.' Acquire the Water Ward |q 27042/2
	step
		goto 36.0,67.4
		.from Bound Fire Elemental##44887
		.' Acquire the Fire Ward |q 27042/1
	step
		goto 40.5,72.4
		.from Bound Air Elemental##44885
		.' Acquire the Air Ward |q 27042/3
	step
		goto 40.2,67.5
		.click One-Time Decryption Engine##9842+
		.' Decrypt 6 Plans |q 27040/1
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Decryption Made Easy##27040
		..accept The Wrong Sequence##27058
	step
		goto 39.1,73.9
		.click the Waygate Controller##9849
		.' Destroy the Waygate |q 27058/1
	step
		goto 39.9,62.2
		.kill Haethen Kaul##44835 |q 27042/4 |tip He's up on a huge floating rock.
	step
		goto 47.3,51.4
		.talk Explorer Mowi##44799
		..turnin The Wrong Sequence##27058
		..accept That's No Pyramid!##28292
	step
		goto 47.3,51.4
		.talk Prospector Brewer##44802
		..turnin Fight Fire and Water and Air with...##27042
	step
		goto 48.0,53.7
		.' Talk with Windspeaker Lorvarius, Yuldris Smolderfury, Tawn Winterbluff, Earthcaller Yevaa and Tharm Wildfire at the below locations:
		.' [48.5,50.1]
		.' [47.4,50.9]
		.' [48.1,49.9]
		..' Tell them you are joining an assault on Lorthuna's Gate and they are needed.
		.' Rally 5 Earthen Ring |q 26827/1
		' |modelnpc Windspeaker Lorvarius##43836+
		' |modelnpc Yuldris Smolderfury##45034+
		' |modelnpc Earthcaller Yevaa##44646+
		' |modelnpc Tawn Winterbluff##44634+
		' |modelnpc Tharm Wildfire##44631+
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43065
		..turnin Rallying the Earthen Ring##26827
		..accept Our Part of the Bargain##26828
	step
		goto 63.3,25.0
		.talk Therazane##44025
		..turnin Our Part of the Bargain##26828
		..accept The Stone March##26829
		..accept Therazane's Mercy##26832
	step
		goto 62.6,26.9
		.talk Boden the Imposing##44080
		..accept The Twilight Flight##26831
	step
		goto 62.4,31.8
		.from High Priestess Lorthuna##42914 |tip She is in a small room on the top of this building.  She is elite, but you can still kill her.  She will run away when she is almost dead.
		.' Defeat High Priestess Lorthuna |q 26832/2
	step
		goto 58.9,32.9
		.from Boldrich Stonerender##42923
		.' Defeat Boldrich Stonerender |q 26832/1
	step
		goto 63.1,38.1
		.from Zoltrik Drakebane##42918 |tip You will eventually get on a stone drake and fly after Zoltrik Drakebane.  You can use your Jump ability to jump onto his drake, if you are a melee class.  Either way, you will land on a rock with him and kill him there.
		.' Defeat Zoltrik Drakebane |q 26831/1
	step
		goto 64.1,36.9
		.talk Terrath the Steady##42614
		..turnin The Twilight Flight##26831
	step
		goto 60.3,33.2
		.from Defaced Earthrager##44076+, Twilight Soulreaper##42916+, Twilight Priestess##42823+
		.kill 15 Twilight Precipice Cultists |q 26829/1
	step
		goto 63.3,25.0
		.talk Therazane##44025
		..turnin The Stone March##26829
		..turnin Therazane's Mercy##26832
		..accept Word In Stone##26833
	step
		goto 49.6,53.0
		.talk Maruut Stonebinder##43818
		..turnin Word In Stone##26833
		..accept Undying Twilight##26875
	step
		goto 50.7,49.6
		.kill 12 Twilight Invaders |q 26875/1
		.kill Desecrated Earthrager##44683 |q 26875/2
		.' Click the Quest Complete box that displays on the right side of the screen under your minimap
		..turnin Undying Twilight##26875
		..accept The Binding##26971
		' |modelnpc 44681
	step
		goto 49.6,52.9
		.kill High Priestess Lorthuna##43837 |q 26971/1
	step
		goto 49.6,52.9
		.talk Earthcaller Torunscar##43835
		..turnin The Binding##26971
	step
		goto 49.8,53.4
		.talk Therazane##43792
		..accept The Stone Throne##26709
	step
		goto 56.4,12.1
		.talk Therazane##42465
		..turnin The Stone Throne##26709
]])
ZygorGuidesViewer:RegisterInclude("A_Therazane_DailyQuest", [[
	step
	label "dailies"
		goto Deepholm,56.1,14.4
		.talk Felsen the Enduring##43805
		..accept Fear of Boring##27046
		..accept Motes##27047
		..accept Beneath the Surface##28488 |tip This quest can be offered at random and may not be offered everyday.
	step
		goto 56.6,14.1
		.talk Terrath the Steady##43806
		..accept The Restless Brood##28391 |tip This quest can be offered at random if you have at least Revered reputation with Therazane.  However, the quest may not be offered everyday.
		only if rep ('Therazane') >= Revered
	step
		goto 55.4,14.2
		.talk Pyrite Stonetender##44945
		..accept Lost In The Deeps##26710 |tip This quest can be offered at random and may not be offered everyday.
	step
		goto 57.3,12.5
		.talk Gorsik the Tumultuous##43804
		..accept Soft Rock##27049
		..accept Fungal Fury##27050
	step
		goto 59.6,14.0
		.talk Ruberick##44973
		..accept Through Persistence##27051
		..accept Glop, Son of Glop##28390 |only if rep ('Therazane') >= Revered |tip This quest can be offered at random if you have at least Revered reputation with Therazane.  However, the quest may not be offered everyday.
	step
		goto 32.7,24.3
		.' Use your Stonework Mallet next to the Pale Resonating Crystal |use Stonework Mallet##60266 |tip It's a huge green crystal sitting on the ground.
		.' Strike the Pale Resonating Crystal |q 28391/1
		.from Aeosera##43641 |tip Click the Boulder Platforms to jump from rock to rock while fighting Aeosera.  When she is casting her Breath Fire ability, jump to another rock and attack her while she is breathing fire to the other rock.  Repeat this until she surrenders.
		.' Defeat Aeosera |q 28391/2
		only if rep ('Therazane') >= Revered
	step
		goto 56.6,14.1
		.talk Terrath the Steady##43806
		..turnin The Restless Brood##28391
		only if rep ('Therazane') >= Revered
	step
		goto 58.3,25.6 |n
		.' Enter the cave |goto 58.3,25.6,0.5 |noway |c
	step
		goto 61.3,26.2
		.talk Ricket##44968
		..accept Underground Economy##27048 |tip This quest can be offered at random and may not be offered everyday.
	step
		goto 66.1,28.1
		.' Follow the path inside the cave
		.' Click the Ruby Gemstone Cluster |tip It looks like 3 dark colored spinning rings with a bunch of red crystals spinning above them.
		.from Enormous Gyreworm##48533
		.get Ruby Crystal Cluster |q 28488/1
	step
		goto 63.6,23.0
		.' Use Ricket's Tickers next to Deep Alabaster Crystals |use Ricket's Tickers##65514 |tip They look like huge white rocks around this area.
		.get 3 Deep Alabaster Crystal |q 27048/1
	step
		goto 62.6,23.9 |n
		.' Follow this path |goto 62.6,23.9,0.5 |noway |c
	step
		goto 61.8,19.7
		.' Use Ricket's Tickers next to Deep Celestite Crystals |use Ricket's Tickers##65514 |tip They look like huge blue rocks around this area.
		.get 3 Deep Celestite Crystal |q 27048/2
	step
		goto 62.0,18.0 |n
		.' Follow this path |goto 62.0,18.0,0.5 |noway |c
	step
		goto 64.4,18.6
		.' Use Ricket's Tickers next to Deep Amethyst Crystals |use Ricket's Tickers##65514 |tip They look like huge purple rocks around this area.
		.get 3 Deep Amethyst Crystal |q 27048/3
	step
		goto 65.3,18.4 |n
		.' Follow this path |goto 65.3,18.4,0.5 |noway |c
	step
		goto 66.4,20.2
		.' Use Ricket's Tickers next to Deep Garnet Crystals |use Ricket's Tickers##65514 |tip They look like huge red rocks around this area.
		.get 3 Deep Garnet Crystal |q 27048/4
	step
		goto 63.6,23.9
		.' All around inside this cave:
		.from Gorged Gyreworm##42766+, Gyreworm##44257+
		.kill 10 Gyreworm |q 27046/1
		.' Click Painite Shards |tip They look like small green glowing crystals sitting on the ground all around inside this cave.
		.get 10 Painite Mote |q 27047/1
	step
		goto 63.1,20.8
		.talk Pebble##49956
		..' Tell him to follow you
	step
		goto 64.2,17.6 |n
		.' Follow this path |goto 64.2,17.6,0.5 |noway |c
	step
		goto 61.3,26.2
		.talk Ricket##44968
		..turnin Underground Economy##27048
	step
		goto 58.3,25.6 |n
		.' Leave the cave |goto 58.3,25.6,0.5 |noway |c
	step
		goto 58.3,25.6
		.' Wait in this spot until Pebble bobbles around appreciatively and then disappears into the distance
		.' Bring Pebble to safety |q 26710/1
	step
		goto 74.0,41.2
		.kill 8 Fungal Behemoth |q 27049/1
		.from Verlok Grubthumper##43367+, Verlok Shroomtender##43368+
		.get Bag of Verlok Miracle-Grow |q 27051/1
		.' Click Sprouting Crimson Mushrooms |tip They look like tiny mushrooms on the ground around this area.  Try to only click the solid blue, solid red or white-brown ones.  The blue ones with red spots will explode and hurt you.
		.' Destroy 10 Freshly Sprouted Mushrooms |q 27050/1
	step
		goto 68.6,29.1 |n
		.' Enter the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto 69.8,31.9
		.talk Earthmender Norsala##43503
		..' Tell her you're ready when she is
		.kill Fungalmancer Glop |q 28390/1 |tip Follow him each time he runs away.  Avoid the mushrooms as you walk, they will give you a debuff.  While fighting Fungalmancer Glop, kill the Boomshrooms he creates.  Don't let them grow too big, they will explode and deal a lot of damage.
	step
		goto 70.2,33.8 |n
		.' Follow the path up |goto 70.2,33.8,0.5 |noway |c
	step
		goto 68.6,29.1 |n
		.' Leave the cave |goto 68.6,29.1,0.5 |noway |c
	step
		goto Deepholm,56.1,14.4
		.talk Felsen the Enduring##43805
		..turnin Fear of Boring##27046
		..turnin Motes##27047
		..turnin Beneath the Surface##28488
	step
		goto 55.4,14.2
		.talk Pyrite Stonetender##44945
		..turnin Lost In The Deeps##26710
	step
		goto 57.3,12.5
		.talk Gorsik the Tumultuous##43804
		..turnin Soft Rock##27049
		..turnin Fungal Fury##27050
	step
		goto 59.6,14.0
		.talk Ruberick##44973
		..turnin Through Persistence##27051
		..turnin Glop, Son of Glop##28390 |only if rep ('Therazane') >= Revered
	step
		'You have reached the end of the dailies for today.
		'Click here to be taken back to the beginning of the dailies |confirm |next "dailies"
]])
ZygorGuidesViewer:RegisterInclude("A_Baradin_Hold_Dailies", [[
	step
	label "begin"
		'You will only be able to accept a total of 6 quests in the following guide steps.
		|confirm
	step
		goto Tol Barad Peninsula,72.9,60.9
		.talk Sergeant Gray##48254
		..accept Bomb's Away!##28275
		..accept Cannonball!##27987
		..accept Ghostbuster##27978
		..accept Taking the Overlook Back##27991
		..accept WANTED: Foreman Wellson##27975
		..accept Watch Out For Splinters!##27973
		|noquest
	step
		goto 73.4,59.2
		.talk Commander Marcus Johnson##47240
		..accept Claiming The Keep##28059
		..accept Leave No Weapon Behind##28063
		..accept Not The Friendliest Town##28130
		..accept Teach A Man To Fish.... Or Steal##28137
		..accept Walk A Mile In Their Shoes##28065
		|noquest
	step
		goto 73.7,57.6
		.talk Camp Coordinator Brack##48255
		..accept A Sticky Task##27948
		..accept Boosting Morale##27972
		..accept Captain P. Harris##27970
		..accept Rattling Their Cages##27971
		..accept Shark Tank##28050
		..accept Thinning the Brood##27944
		|noquest
	step
		goto 74.8,59.6
		.talk Lieutenant Farnsworth##48250
		..accept Finish The Job##28046
		..accept First Lieutenant Connor##27967
		..accept Magnets, How Do They Work?##27992
		..accept Salvaging the Remains##27966
		..accept The Forgotten##27949
		|noquest
	step
		goto 74.3,42.8 |n
		.' Follow the path up |goto 74.3,42.8,0.5 |noway |c
	step
		goto 78.6,42.0
		.kill Commander Largo##47304 |q 27991/1 |tip He's at the top of the tower.
	step
		goto 78.2,49.0
		.from Overlook Spectre##47182+, Ghastly Worker##47183+, Overlook Spirit##47181+
		.' Slay 14 Largo's Overlook Ghosts |q 27978/1
		.click Cannonball Stack##4177
		.get 4 Stack of Cannonballs |q 27987/1
	step
		goto 69.3,23.1
		.click String of Fish##6705+
		.get 22 Rustberg Seabass |q 28137/1
	step
		goto 67.6,37.1
		.from Suspicious Villager##47657+, Apprehensive Worker##47659+, Rustberg Bandit##47627+
		.kill 14 Rustberg Village Residents |q 28130/1
	step
		goto 54.2,47.0
		.kill 12 Darkwood Lurker##46508+ |q 27944/1
	step
		goto 54.2,47.0
		.from Darkwood Broodmother##46507+
		.get 4 Sticky Silk Gland |q 27948/1
	step
		goto 47.9,8.1
		.kill Captain P. Harris##47287 |q 27970/1 |tip He's walking around on this broken boat.
	step
		goto 49.4,19.8
		.kill Tank##46608 |q 28050/1 |tip He's an elite shark that swims in the water around this area.  This is a group quest, so you will probably need help.
		.click Barrel of Southsea Rum##9095+
		.get 6 Barrel of Southsea Rum |q 27972/1
	step
		goto 49.0,29.4
		.kill 8 Shipwrecked Sailor##46605+ |q 27971/1
	step
		goto 36.1,27.3
		.kill Keep Lord Farson##47447 |q 28059/1 |tip He's upstairs in the fort.
	step
		goto 37.8,29.1
		.talk Farson Hold Prisoner##48308
		..' Tell you're here to help him escape
		.' Escort the Farson Prisoner |q 28065/1 |tip Follow the Farson Hold Prisoner and protect him.
	step
		goto 41.2,35.8
		.click Rack of Rifles##8972
		.get 12 Rusty Rifle |q 28063/1
	step
		goto 27.2,47.7
		.kill Foreman Wellson##46648 |q 27975/1
	step
		goto 22.2,36.3
		.clicknpc Wellson Cannon##48283
		.' Shoot the boats
		.' Destroy 10 Wellson Supply Boats |q 28275/1
	step
		goto 30.1,43.9
		.click Shipyard Lumber##1109
		.get 15 Shipyard Lumber |q 27973/1
	step
		goto 40.2,57.9
		.kill 5 Restless Infantry##46823 |q 28046/1
		.' Use your Magnatized Scrap Collector |use Magnatized Scrap Collector##62829
		.click Siege Scrap##6868+
		.get 7 Siege Engine Scrap |q 27992/1
	step
		goto 38.4,77.6
		.kill First Lieutenant Connor##46571 |q 27967/1
	step
		goto 38.1,71.5
		.from Wandering Soul##46586+, Forgotten Ghoul##46569+
		.get 9 Cursed Femur |q 27966/1
		.click Forgotten Soldier's Tombstone##2452
		.' Release 6 Tortured Souls |q 27949/1
	step
		goto 72.9,60.9
		.talk Sergeant Gray##48254
		..turnin Bomb's Away!##28275
		..turnin Cannonball!##27987
		..turnin Ghostbuster##27978
		..turnin Taking the Overlook Back##27991
		..turnin WANTED: Foreman Wellson##27975
		..turnin Watch Out For Splinters!##27973
	step
		goto 73.4,59.2
		.talk Commander Marcus Johnson##47240
		..turnin Claiming The Keep##28059
		..turnin Leave No Weapon Behind##28063
		..turnin Not The Friendliest Town##28130
		..turnin Teach A Man To Fish.... Or Steal##28137
		..turnin Walk A Mile In Their Shoes##28065
	step
		goto 73.7,57.6
		.talk Camp Coordinator Brack##48255
		..turnin A Sticky Task##27948
		..turnin Boosting Morale##27972
		..turnin Captain P. Harris##27970
		..turnin Rattling Their Cages##27971
		..turnin Shark Tank##28050
		..turnin Thinning the Brood##27944
	step
		goto 74.8,59.6
		.talk Lieutenant Farnsworth##48250
		..turnin Finish The Job##28046
		..turnin First Lieutenant Connor##27967
		..turnin Magnets, How Do They Work?##27992
		..turnin Salvaging the Remains##27966
		..turnin The Forgotten##27949
	step
		'The following daily quests will only be available if the Alliance faction currently controls Tol Barad.
		.' Click here to continue |confirm
		.' Click here if your faction does not control Tol Barad |confirm |next "end"
	step
		goto Tol Barad,50.9,49.7
		.talk Sergeant Parker##48066
		..accept A Huge Problem##28122
		..accept Swamp Bait##28162
		..accept The Leftovers##28163
	step
		goto 51.4,49.6
		|modelnpc 2nd Lieutenant Wansworth##48061
		..Click here if 2nd Lieutenant Wansworth is present. |confirm |next wansworth_is_here
		|modelnpc Commander Stevens##48039
		..Click here if Commander Stevens is present. |confirm |next stevens_is_here
		|modelnpc Marshal Fallows##48074
		..Click here if Marshal Fallows is present. |confirm |next fallows_is_here
		'Only one of these NPCs will be available.
	step
	label "wansworth_is_here"
		goto 51.4,49.6
		.talk 2nd Lieutenant Wansworth##48061
		..accept D-Block##28165
		..accept Svarnos##28185
		..accept Cursed Shackles##28186
		|next exit
	step
	label "stevens_is_here"
		goto 51.5,49.5
		.talk Commander Stevens##48039
		..accept Clearing the Depths##28117
		..accept Learning From The Past##28120
		..accept The Imprisoned Archmage##28118
		|next exit
	step
	label "fallows_is_here"
		goto 51.5,49.6
		.talk Marshal Fallows##48074
		..accept Food From Below##28232
		..accept Prison Revolt##28188
		..accept The Warden##28223
		|next exit
	step
	label "exit"
		goto 42.7,39.1 |n
		.' Enter the underground jail |goto 42.7,39.1,0.5 |noway |c
	step
		goto 48.3,30.7
		.from Svarnos##47544+
		.get Svarnos' Cursed Collar |q 28185/1
	step
		goto 44.4,30.5
		.from Imprisoned Imp##47549+, Cell Watcher##47542+, Shivan Destroyer##47540+, Jailed Wrathguard##47548+
		.' Slay 10 Demons |q 28165/1
		.click Cursed Shackle##181
		.get 8 Cursed Shackles |q 28186/1
	step
		goto 42.1,41.8
		.from Baradin Crocolisk##47591+
		.get 8 Crocolisk Hide |q 28162/1
	step
		goto 44.0,69.2 |n
		.' Enter the underground jail |goto 44.0,69.2,0.5 |noway |c
	step
		goto 37.5,71.7
		.from Warden Silva##48036
		.get Warden's Keys |q 28223/1
	step
		goto 40.9,78.2
		.from Imprisoned Worker##47550+, Exiled Mage##47552+
		.' Slay 10 Prisoners |q 28188/1
		.click Crate of Cellblock Rations##347+
		.get 12 Cellblock Ration |q 28232/1
	step
		goto 60.8,50.1 |n
		.' Enter the underground jail |goto 60.8,50.1,0.5 |noway |c
	step
		goto 56.8,54.8
		.from Archmage Galus##47537
		.get Archmage Galus' Staff |q 28118/1
	step
		goto 51.4,49.5
		.from Captive Spirit##47531+, Ghastly Convict##47590+
		.' Slay 9 Ghosts |q 28117/1
		.click Dusty Prison Journal##8051+
		.get 4 Dusty Prison Journal |q 28120/1
	step
		goto 51.1,29.7
		.from Horde Mage Infantry##47608+, Horde Shaman Infantry##47610+, Horde Rogue Infantry##47609+, Horde Druid Infantry##47607+
		.kill 12 Horde Infantry |q 28163/1
	step
		goto 52.8,36.7
		.kill Problim##47593 |q 28122/1 |tip He patrols around Baradin Hold.  Some searching may be required.
	step
		goto Tol Barad,50.9,49.7
		.talk Sergeant Parker##48066
		..turnin A Huge Problem##28122
		..turnin Swamp Bait##28162
		..turnin The Leftovers##28163
	step
		goto 51.4,49.6
		.talk 2nd Lieutenant Wansworth##48061
		..turnin D-Block##28165
		..turnin Svarnos##28185
		..turnin Cursed Shackles##28186
	step
		goto 51.5,49.5
		.talk Commander Stevens##48039
		..turnin Clearing the Depths##28117
		..turnin Learning From The Past##28120
		..turnin The Imprisoned Archmage##28118
	step
		goto 51.5,49.6
		.talk Marshal Fallows##48074
		..turnin Food From Below##28232
		..turnin Prison Revolt##28188
		..turnin The Warden##28223
	step
	label "end"
		'You have reached the end of the dailies for today.
		.' Click here to return to the beginning of the guide. |confirm |next "begin"
]])
ZygorGuidesViewer:RegisterInclude("A_Firelands_PreQuests", [[
	step
		goto Stormwind City,62.9,71.6
		.' Click the Hero's Call Board |tip It's a big white stone hanging board with a gold lion head on it.
		..accept Hero's Call: Mount Hyjal!##27726
	step
		goto 82.6,28.2
		.talk Cenarion Emissary Jademoon##15187
		..' Ask her to send you to Moonglade
		.' Teleport to Moonglade |goto Moonglade |noway |c
	step
		goto Moonglade,45.5,44.9
		.talk Emissary Windsong##39865
		..turnin Hero's Call: Mount Hyjal!##27726
		..accept As Hyjal Burns##25316
	step
		goto 46.1,45.6
		.' Click Aronus |tip It's a green dragon flying in place in this spot.
		.' You will fly to Mount Hyjal |goto Mount Hyjal |noway |c
	step
		goto 63.1,24.1
		.talk Sebelia##40843
		.home Nordrassil
	step
		goto Mount Hyjal,62.0,24.9
		.talk Ysera##40928
		..turnin As Hyjal Burns##25316
		..accept Protect the World Tree##25317
	step
		goto 64.0,22.7
		.talk Anren Shadowseeker##39925
		..accept The Earth Rises##25460
	step
		goto 64.1,22.5
		.talk Tholo Whitehoof##40278
		..accept Inciting the Elements##25370
	step
		goto 67.1,22.6
		.kill 8 Scalding Rock Elemental |q 25460/1
		.' Click Juniper Berries |tip They look like small green bushes with small red berries on them, at the base of trees around this area.
		.collect 4 Juniper Berries##53009 |n
		.' Use your Juniper Berries on Faerie Dragons |use Juniper Berries##53009 |tip They look like small blue flying dragons around this area.
		.' Follow the Faerie Dragons to find Twilight Inciters
		.kill 4 Twilight Inciter |q 25370/1
	step
		goto 64.1,22.5
		.talk Tholo Whitehoof##40278
		..turnin Inciting the Elements##25370
		..accept Flames from Above##25574
	step
		goto 64.0,22.7
		.talk Anren Shadowseeker##39925
		..turnin The Earth Rises##25460
	step
		goto 55.8,15.4
		.' Use Tholo's Horn to call for an emerald dragon |use Tholo's Horn##55122
		.' Burn the Infiltrators' Encampment |q 25574/1
	step
		goto 64.1,22.5
		.talk Tholo Whitehoof##40278
		..turnin Flames from Above##25574
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin Protect the World Tree##25317
		..accept War on the Twilight's Hammer##25319
	step
		goto 47.6,35.5
		.talk Windspeaker Tamila##39869
		..accept The Flameseer's Staff##25472
	step
		goto 43.3,27.4
		.' Click Charred Staff Fragments |tip They look like small white pieces on the ground around this area.
		.get 8 Charred Staff Fragment |q 25472/1
	step
		goto 47.2,25.6
		.kill 4 Twilight Flamecaller |q 25319/1
		.kill 10 Twilight Vanquisher |q 25319/2
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin War on the Twilight's Hammer##25319
		..turnin The Flameseer's Staff##25472
		..accept Flamebreaker##25323
	step
		goto 48.5,29.2
		.' Use your Flameseer's Staff on Blazebound Elementals |use Flameseer's Staff##53107
		.kill 30 Unbound Flame Spirit |q 25323/1
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin Flamebreaker##25323
		..accept The Return of Baron Geddon##25464
	step
		goto 44.1,26.8
		.' Use your Flameseer's Staff on Baron Geddon |use Flameseer's Staff##54463 |tip He's a big fire elemental standing in the middle of this crater.
		.' Weaken Baron Geddon 20 Times |q 25464/1 |tip Run away when you see Galrond of the Claw yell "Look out!".
	step
		goto 47.7,35.5
		.talk Malfurion Stormrage##15362
		..turnin The Return of Baron Geddon##25464
	step
		goto 47.6,35.5
		.talk Windspeaker Tamila##39869
		..accept Emerald Allies##25430
	step
		goto 48.4,18.9
		.talk Alysra##38917
		..turnin Emerald Allies##25430
		..accept The Captured Scout##25320
	step
		goto 44.5,18.9
		.talk Scout Larandia##40096
		..turnin The Captured Scout##25320
		..accept Twilight Captivity##25321
	step
		goto 44.5,21.5
		.from Twilight Overseer##40123
		.get Twilight Overseer's Key |q 25321/1
	step
		goto 44.5,18.9
		.talk Scout Larandia##40096
		..turnin Twilight Captivity##25321
		..accept Return to Alysra##25424
	step
		goto 48.4,18.9
		.talk Alysra##38917
		..turnin Return to Alysra##25424
		..accept A Prisoner of Interest##25324
	step
		goto 52.5,17.3 |n
		.' Enter the cave |goto 52.5,17.3,0.5 |noway |c
	step
		goto 56.8,18.8
		.talk Captain Saynna Stormrunner##40139
		..turnin A Prisoner of Interest##25324
		..accept Through the Dream##25325
	step
		goto 52.5,17.3 |n
		.' Leave the cave |goto 52.5,17.3,0.5 |noway |c |tip Follow the path up.
	step
		goto 52.2,17.4
		.talk Alysra##40178
		..turnin Through the Dream##25325
		..accept Return to Nordrassil##25578
	step
		goto 62.0,24.9
		.talk Ysera##40928
		..turnin Return to Nordrassil##25578
		..accept The Return of the Ancients##25584
	step
		goto 35.7,19.4
		.talk Oomla Whitehorn##39429
		..turnin The Return of the Ancients##25584
		..accept Harrying the Hunters##25255
	step
		goto 35.7,19.7
		.talk Jadi Falaryn##39427
		..accept End of the Supply Line##25233
		..accept In the Rear With the Gear##25234
	step
		goto 38.1,23.0
		.kill 6 Twilight Hunter |q 25255/1
		.kill 4 Twilight Proveditor |q 25233/1 |tip They walk with 3 Twilight slaves and a Twilight Slavedriver.
		.' Click Twilight Supplies |tip The Twilight Slaves are carrying them.  You can get the supplies after you kill the Twilight Proveditor and Twilight Slavedriver.
		.get 36 Twilight Supplies |q 25234/1
	step
		goto 35.7,19.7
		.talk Jadi Falaryn##39427
		..turnin End of the Supply Line##25233
		..turnin In the Rear With the Gear##25234
		..accept The Voice of Goldrinn##25268
	step
		goto 35.7,19.4
		.talk Oomla Whitehorn##39429
		..turnin Harrying the Hunters##25255
	step
		goto 30.1,31.3
		.talk Ian Duran##39433
		..turnin The Voice of Goldrinn##25268
		..accept Goldrinn's Ferocity##25271
	step
		goto 29.3,30.3
		.from Lycanthoth Vandal##39445+
		.get 6 Polluted Incense |q 25271/1
	step
		goto 30.1,31.3
		.talk Ian Duran##39433
		..turnin Goldrinn's Ferocity##25271
		..accept Lycanthoth the Corruptor##25273
	step
		goto 32.4,37.3
		.' Use Lycanthoth's Incense next to Lycanthoth's Altar |use Lycanthoth's Incense##52682 |tip Inside the cave.
		.kill Lycanthoth |q 25273/1
	step
		goto 32.3,37.0
		.talk Spirit of Goldrinn##39627
		..turnin Lycanthoth the Corruptor##25273
	step
		goto 29.6,29.3
		.talk Spirit of Goldrinn##39627
		..accept The Shrine Reclaimed##25280
	step
		goto 28.2,29.8
		.talk Ian Duran##39433
		..turnin The Shrine Reclaimed##25280
		..accept Cleaning House##25278
	step
		goto 28.2,29.9
		.talk Rio Duran##39434
		..accept From the Mouth of Madness##25297
	step
		goto 28.6,30.2
		.talk Royce Duskwhisper##39435
		..accept The Eye of Twilight##25300
	step
		goto 28.9,32.2
		.' Click a Bitterblossom |tip They look like purple flowers around this small island.
		.get Bitterblossom |q 25297/2
	step
		goto 27.6,34.2
		.' Click a Stonebloom |tip They look like piles of red-ish bags on the ground around this area.
		.get Stonebloom |q 25297/1
	step
		goto 27.2,35.2
		.' Click the Eye of Twilight |tip It looks like a glowing purple ball in a metal rod with a hook on it.
		..turnin The Eye of Twilight##25300
		..accept Mastering Puppets##25301
	step
		goto 28.4,35.8
		.' Click a Darkflame Ember |tip They are purple glowing coals sitting in a brazier.
		.get Darkflame Ember |q 25297/3
	step
		goto 28.4,36.4
		.' Click the Twilight Cauldron |tip It's a metal pot with blue smoke coming out of it.
		..turnin From the Mouth of Madness##25297
		..accept Free Your Mind, the Rest Follows##25298
	step
		goto 27.0,36.0 |n
		.' Enter the cave |goto 27.0,36.0,0.5 |noway |c
	step
		goto 27.2,40.8
		.talk Kristoff Manheim##39797
		..accept Gar'gol's Gotta Go##25328 |tip This quest is currently bugged, so some players are able to accept the quest while others cannot.
	step
		goto 26.5,38.5
		.' Click Gar'gol's Personal Treasure Chest |tip It's a small metal chest sitting on a small stone mound.
		.get Rusted Skull Key |q 25328/1
	step
		goto 25.8,41.7
		.' Click The Twilight Apocrypha |tip It's an open book layin on a wooden crate at the very back of the cave.
		..turnin Mastering Puppets##25301
		..accept Elementary!##25303
	step
		goto 26.0,41.8
		.' Click the Crucible of Fire |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Fire |q 25303/3
	step
		goto 25.7,41.7
		.' Click the Crucible of Earth |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Earth |q 25303/1
	step
		goto 25.8,41.9
		.' Click the Crucible of Air |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Air |q 25303/2
	step
		goto 26.0,41.6
		.' Click the Crucible of Water |tip It looks like a floating glowing hourglass.
		.' Activate the Crucible of Water |q 25303/4
	step
		goto 25.8,41.7
		.' Click The Twilight Apocrypha |tip It's an open book layin on a wooden crate at the very back of the cave.
		..turnin Elementary!##25303
		..accept Return to Duskwhisper##25312
	step
		.' While inside the cave do the following:
		.from Hovel Brute##39642+, Hovel Shadowcaster##39643+
		.' Slay 8 Minion of Gar'gol |q 25278/1
		.talk Twilight Servitor##39644
		..' Administor the drought
		.' Free 8 Twilight Servitors |q 25298/1
	step
		goto 27.2,40.8
		.talk Kristoff Manheim##39797
		..turnin Gar'gol's Gotta Go##25328
		..accept Get Me Outta Here!##25332
	step
		goto 27.1,36.0 |n
		.' Leave the cave |goto 27.1,36.0,0.5 |noway |c |q 25332
		.' Escort Kristoff Out |q 25332/1
	step
		goto 28.6,30.2
		.talk Royce Duskwhisper##39435
		..turnin Return to Duskwhisper##25312
		..turnin Get Me Outta Here!##25332
	step
		goto 28.2,29.8
		.talk Ian Duran##39433
		..turnin Cleaning House##25278
		..accept Sweeping the Shelf##25352
		..accept Lightning in a Bottle##25353
	step
		goto 28.2,29.9
		.talk Rio Duran##39434
		..turnin Free Your Mind, the Rest Follows##25298
	step
		goto 27.4,39.2
		.kill 8 Twilight Stormcaller |q 25352/1
		.kill 5 Howling Riftdweller |q 25352/2
		.' Click a Lightning Channel |tip They look like rods standing upright around this area, with lamps at the top of them.
		.get Charged Condenser Jar |q 25353/1
	step
		'Use your Totem of Goldrinn |use Totem of Goldrinn##52853
		.talk Spirit of Goldrinn##39627
		..turnin Lightning in a Bottle##25353
		..accept Into the Maw!##25618
	step
		goto 26.2,41.0 |n
		.' Go inside the blue portal |goto 26.2,41.0,0.5 |noway |c
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Into the Maw!##25618
		..accept Forged of Shadow and Flame##25575
		..accept Crushing the Cores##25577
	step
		goto 26.3,42.0
		.talk Yargra Blackscar##40837
		..accept Rage of the Wolf Ancient##25576
	step
		.' Do the following in the Firelands Forgeworks
		.kill 12 Dark Iron Laborer |q 25576/1
		.from Searing Guardian##40841+
		.collect 8 Smoldering Core##55123 |n
		.' Use your Smoldering Cores next to Twilight Anvils |use Smoldering Core##55123 |tip They are small anvils sitting on the ground around this area.
		.' Destroy 8 Smoldering Cores |q 25577/1
		.' Click Twilight Arms Crates |tip They look like wooden boxes sitting on the ground around this area.
		.' Destroy 10 Twilight Arms Crates |q 25575/1
	step
		goto 26.3,42.0
		.talk Yargra Blackscar##40837
		..turnin Rage of the Wolf Ancient##25576
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Forged of Shadow and Flame##25575
		..turnin Crushing the Cores##25577
		..accept Cindermaul, the Portal Master##25599
	step
		goto 30.7,41.7
		.kill Cindermaul |q 25599/1
		.' Click the Battered Stone Chest |tip It spawns after you kill Cindermaul.
		.get Tome of Openings |q 25599/2
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Cindermaul, the Portal Master##25599
		..accept Forgemaster Pyrendius##25600
	step
		goto 31.6,46.0
		.' Click the Portal Runes |tip They are brown metal plates on the ground on this small circular island in the lava.
		.' Lure Forgemaster Pyrendius onto the activated Portal Runes |tip This will weaken him and allow you to kill him.
		.kill Forgemaster Pyrendius |q 25600/1
	step
		goto 26.3,41.9
		.talk Jordan Olafson##40834
		..turnin Forgemaster Pyrendius##25600
		..accept Return from the Firelands##25611
	step
		goto 25.9,40.9 |n
		.' Go inside the blue portal |goto 25.9,40.9 <30 |noway |c
	step
		goto 28.2,29.8
		.talk Ian Duran##39433
		..turnin Sweeping the Shelf##25352
		..turnin Return from the Firelands##25611
	step
		goto Mount Hyjal 28.2,29.8
		.talk Vision of Ysera##46987
		..accept Aviana's Legacy##27874
	step
		goto 28.2,29.9
		.talk Rio Duran##39434
		..accept The Fires of Mt. Hyjal##25630
	step
		goto 19.0,40.9
		.talk Laina Nightsky##39927
		..turnin The Fires of Mt. Hyjal##25630
		..accept Fighting Fire With ... Anything##25381
		..accept Disrupting the Rituals##25382
	step
		goto 19.2,37.9
		.talk Mylune##39930
		..accept Save the Wee Animals##25385
	step
		goto 19.0,37.0
		.talk Matoclaw##39928
		..accept If You're Not Against Us...##25404
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..' Tell him you've been sent to request his aid, then tell him he could be destroyed, then ask him if he will help you
		.' Persuade Blackhorn |q 25404/1
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin If You're Not Against Us...##25404
		..accept Seeds of Their Demise##25408
	step
		goto 21.8,43.7
		.from Wailing Weed##40066+
		.get 8 Bileberry |q 25408/1
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin Seeds of Their Demise##25408
		..accept A New Master##25411
	step
		goto 14.4,45.4
		.from Twilight Inferno Lord##39974
		.' Use your Bottled Bileberry Brew on the corpse of a Twilight Inferno Lord |use Bottled Bileberry Brew##53120
		.' Subjugate a Twilight Inferno Lord |q 25411/1
		.talk Subjugated Inferno Lord##40093
		..turnin A New Master##25411
		..accept The Name Never Spoken##25412
	step
		goto 14.3,45.4
		.' Click the Southern Firestone |tip It looks like a metal stand with a small flame at the top of it.
		.' Examine the Southern Firestone |q 25412/3
	step
		goto 11.6,41.5
		.' Click the Central Firestone |tip It looks like a metal stand with a small flame at the top of it.
		.' Examine the Central Firestone |q 25412/2
	step
		goto 9.6,36.5
		.' Click the Northern Firestone |tip It looks like a metal stand with a small flame at the top of it.
		.' Examine the Northern Firestone |q 25412/1
	step
		goto 13.3,41.4
		.kill 10 Raging Firestorm |q 25381/1
		.kill 6 Twilight Inferno Lord |q 25382/1
		.' Click Panicked Bunnies and Terrified Squirrels |tip They are small and run around this area.
		.get 10 Frightened Animal |q 25385/1
	step
		goto 19.0,40.9
		.talk Laina Nightsky##39927
		..turnin Fighting Fire With ... Anything##25381
		..turnin Disrupting the Rituals##25382
	step
		goto 19.2,37.9
		.talk Mylune##39930
		..turnin Save the Wee Animals##25385
		..accept Oh, Deer!##25392
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin The Name Never Spoken##25412
		..accept Black Heart of Flame##25428
	step
		goto 12.9,41.4
		.' Use your Charred Branch while in the burning forest area |use Charred Branch##53464
		.from Thol'embaar##40107
		.get Black Heart of Thol'embaar |q 25428/1
	step
		goto 14.5,40.8
		.' Click 3 Injured Fawns |tip They look like tiny deer laying on the ground around this area.
		.' Lead the Injured Fawns back to Mylune at [19.2,37.9]
		.' Escort 3 Injured Fawns Home |q 25392/1
	step
		goto 19.2,37.9
		.talk Mylune##39930
		..turnin Oh, Deer!##25392
	step
		goto 22.3,44.9
		.talk Tyrus Blackhorn##39933
		..turnin Black Heart of Flame##25428
	step
		goto 19.0,40.9
		.talk Laina Nightsky##39927
		..accept Last Stand at Whistling Grove##25940
	step
		goto 13.6,32.8
		.talk Keeper Taldros##39932
		..turnin Last Stand at Whistling Grove##25940
		..accept The Bears Up There##25462
	step
		 goto 14.2,32.1
		.' Click the Climbing Tree |tip They look like small ladders leaning aginst the trees around this area.
		.' Click Hyjal Bear Cubs in the tree
		.' Use your Climb Up ability to climb to the top of the tree
		.' Use your Chuck-a-bear ability to throw the cubs down |tip Aim the yellow arrow at the bearskin trampoline on the ground.
		.' Rescue 6 Hyjal Bear Cubs |q 25462/1
	step
		goto 13.6,32.8
		.talk Keeper Taldros##39932
		..turnin The Bears Up There##25462
		..accept Smashing Through Ashes##25490
	step
		goto 21.6,59.1
		.kill 8 Charbringer |q 25490/1
	step
		 goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##39858
		..turnin Smashing Through Ashes##25490
		..accept Durable Seeds##25491
		..accept Fresh Bait##25493
	step
		goto 27.1,63.0
		.talk Rayne Feathersong##40331
		..accept Firebreak##25492
	step
		goto 36.2,58.6
		.kill 10 Lava Surger |q 25492/1
		.from Core Hound##+
		..get 4 Core Hound Entrails |q 25493/1
		.' Click Scorched Soil |tip They look like piles of dirt around this area.
		..get 10 Hyjal Seedling |q 25491/1
	step
		 goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##39858
		..turnin Durable Seeds##25491
		..turnin Fresh Bait##25493
		..accept Hell's Shells##25507
	step
		goto 27.1,63.0
		.talk Rayne Feathersong##40331
		..turnin Firebreak##25492
		..accept Prepping the Soil##25502
	step
		goto 33.0,64.6
		.' Click the Flameward |tip It's a floating stone in a golden claw stand.
		.' Activate the Flameward |q 25502/1
		.' Defend the Flameward |q 25502/2
	step
		goto 39.3,54.1
		.' Use your Heap of Incendosaur Innards near Nemesis |use Heap of Incendosaur Innards##54744 |tip Nemesis is a huge turtle that walks all around The Flamewake area, so you may need to search for him.
		.' Click Nemesis when he becomes friendly
		.get Nemesis Shell Fragment |q 25507/1
	step
		goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##39858
		..turnin Hell's Shells##25507
		..accept Tortolla Speaks##25510
	step
		goto 27.1,63.0
		.talk Rayne Feathersong##40331
		..turnin Prepping the Soil##25502
	step
		goto 24.7,55.7
		.talk Tortolla##41504
		..turnin Tortolla Speaks##25510
		..accept Breaking the Bonds##25514
		..accept Children of Tortolla##25519
	step
		goto 23.8,56.0
		.' Click the Rod of Subjugation |tip It's a huge metal rod with an orange spinning ball on top of it.
		..' Disable Rod of Subjugation 1 |q 25514/1
	step
		goto 25.3,54.8
		.' Click the Rod of Subjugation |tip It's a huge metal rod with an orange spinning ball on top of it.
		..' Disable Rod of Subjugation 2 |q 25514/2
	step
		goto 24.7,55.7
		.talk Tortolla##41504
		..turnin Breaking the Bonds##25514
	step
		goto 24.4,57.4
		.from Deep Corruptor##40561+ |tip They are found underwater
		.' Save 6 Tortolla's Eggs |q 25519/1
	step
		goto 24.7,55.7
		.talk Tortolla##41504
		..turnin Children of Tortolla##25519
		..accept An Ancient Awakens##25520
	step
		goto 27.1,62.6
		.talk Arch Druid Hamuul Runetotem##39858
		..turnin An Ancient Awakens##25520
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin Aviana's Legacy##27874
		..accept An Offering for Aviana##25663
	step
		goto 42.2,45.5
		.talk Thisalee Crow##41006
		..accept The Wormwing Problem##25655
		..accept Scrambling for Eggs##25656
	step
		goto 40.3,44.3
		.' Use your Sacred Nectar next to Aviana's Burial Circle |use Sacred Nectar##55208
		..' Offer the Nectar |q 25663/1
		.talk Mysterious Winged Spirit##41068
		..turnin An Offering for Aviana##25663
		..accept A Plea From Beyond##25665
	step
		goto 38.5,43.0
		.from Wormwing Screecher##41027+, Wormwing Swifttalon##41028+
		..' Kill 10 Wormwing Harpies |q 25655/1
		.' Click Stolen Hyjal Eggs |tip They look like big white eggs sitting at the base of trees around this area.
		..get 8 Hyjal Egg |q 25656/1
	step
		goto 42.2,45.5
		.talk Thisalee Crow##41006
		..turnin The Wormwing Problem##25655
		..turnin Scrambling for Eggs##25656
		..accept A Bird in Hand##25731
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin A Plea From Beyond##25665
		..accept A Prayer and a Wing##25664
	step
		goto 38.3,44.2
		.' Click the Harpy Signal Fire |tip It's a brazier with red fire in it.
		..' Fight Marion Wormwing until she gets captured |q 25731/1
		.talk Marion Wormwing##41112
		..' Ask her why she is stealing eggs, then tell Thisalee to kill her
		..' Interrogate Marion Wormwing |q 25731/2
	step
		goto 35.7,42.3
		.' Use your Enormous Bird Call in Blaithe's Roost |use Enormous Bird Call##55211 |tip It's a huge bird nest sitting on top of this mountain peak.
		.from Blaithe##41084
		..get Ancient Feather |q 25664/1
	step
		goto 42.2,45.5
		.talk Thisalee Crow##41006
		..turnin A Bird in Hand##25731
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin A Prayer and a Wing##25664
	step
		goto 43.5,45.9
		.talk Skylord Omnuron##40997 |tip He is up on the platform above Choluna.
		..accept Fact-Finding Mission##25740
	step
		 goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Fact-Finding Mission##25740
		..accept Sethria's Brood##25746
		..accept A Gap in Their Armor##25758
	step
		goto 31.3,77.1
		.' Click the Codex of Shadows |tip It's an open book sitting on a wooden box.
		..accept The Codex of Shadows##25763
	step
		goto 30.9,76.9
		.from Twilight Dragonkin##41029+, Twilight Dragonkin Armorers##41030+
		..' Slay 12 Sethria's Minions |q 25746/1
		.' Click Twilight Armor Plates |tip They look like tan pieces of metal laying on the ground around this area.
		..get 8 Twilight Armor Plate |q 25758/1
	step
		goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Sethria's Brood##25746
		..turnin A Gap in Their Armor##25758
		..accept Disassembly##25761
		..turnin The Codex of Shadows##25763
		..accept Egg Hunt##25764
	step
		goto 31.6,75.8
		.' Use Thisalee's Shiv on Twilight Juggernauts |use Thisalee's Shiv##55883 |tip Use Thisalee's Shive multiple times to remove the Twilight Juggernauts' Armor Plating and make them weaker.
		..kill 3 Twilight Juggernaut |q 25761/1
		.' Click Shadow Cloak Generators |tip They look like blue glowing machines around this area.
		..' Unveil and Defend Aviana's Egg |q 25764/1
	step
		goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Disassembly##25761
		..turnin Egg Hunt##25764
		..accept Sethria's Demise##25776
	step
		goto 35.5,98.0
		.' Fight Sethria
		..' Use Thisalee's Signal Rocket when Sethria turns into a dragon |use Thisalee's Signal Rocket##56003
		..kill Sethria |q 25776/1
	step
		goto 32.8,70.8
		.talk Thisalee Crow##41006
		..turnin Sethria's Demise##25776
		..accept Return to the Shrine##25795
	step
		goto 44.4,46.2
		.talk Choluna##41005
		..turnin Return to the Shrine##25795
		..accept An Ancient Reborn##25807
	step
		goto 44.3,48.0
		.' Use Herald's Incense next to Aviana's Egg |use Herald's Incense##56016 |tip Aviana's Egg is in the tree tower, in a side room.
		.' Burn Herald's Incense |q 25807/1
	step
		goto 44.2,47.8
		.talk Aviana##41308
		..turnin An Ancient Reborn##25807
	step
		goto 44.1,45.9
		.talk Morthis Whisperwing##41003
		..accept The Hatchery Must Burn##25810
	step
		goto 43.8,46.0
		.talk Vision of Ysera##47002
		..accept The Last Living Lorekeeper##25830
		.' If you cannot pick up the quest, go here to get it: [62.0,24.9]
	step
		goto 39.1,58.3 |n
		.' Go inside the blue portal |goto 39.1,58.3,0.3 |noway |c
	step
		goto 37.2,56.2
		.talk Farden Talonshrike##40578
		..turnin The Hatchery Must Burn##25810
		..accept Flight in the Firelands##25523
	step
		goto 37.2,56.1
		.' Click the Twilight Weapon Rack |tip It's a wooden stand with some weapons leaning against it.
		.collect Twilight Firelance##52716 |q 25523
	step
		 goto 37.4,56.0
		 .' Equip the Twilight Firelance |equipped Twilight Firelance##52716 |q 25523
		.' Click Aviana's Guardian to ride it |invehicle |tip They are hippogryphs.
	step
		goto 36.6,53.4
		.' Use your Flap ability on your hotbar repeatedly to fly to this green flag
		.' Land next to the Guardian Flag |tip It's a green flag on this small floating island.
		.' Visit the Guardian Flag |q 25523/1
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Flight in the Firelands##25523
		..accept Wave One##25525
	step
		goto 35.4,51.7
		.' Use your Flap ability on your hotbar repeatedly to fly around this area
		.' Fly into Twilight Buzzards to joust them
		.kill 10 Twilight Knight Rider |q 25525/1
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Wave One##25525
		..accept Wave Two##25544
	step
		goto 35.4,51.7
		.' Use your Flap ability on your hotbar repeatedly to fly around this area
		.' Fly into Twilight Firebirds to joust them |tip Be careful, don't let the burning Falling Boulders hit you.
		.kill 10 Twilight Lancer |q 25544/1
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Wave Two##25544
		..accept Egg Wave##25560
	step
		goto 36.6,53.3
		.' Use your Flap ability on your hotbar repeatedly to fly around this area
		.' Run over Firelands Eggs |tip They look like blue eggs on the ground around this area.
		.' Destroy 40 Firelands Eggs |q 25560/1
		.' You can find more Firelands Eggs at [39.3,54.1]
	step
		goto 37.2,56.2
		.' Use your Flap ability on your hotbar repeatedly to fly to this spot
		.talk Farden Talonshrike##40578
		..turnin Egg Wave##25560
		..accept Return to Aviana##25832
	step
		'Click the red arrow on your hot bar to get off the hippogryph |outvehicle |c
	step
		goto 39.1,58.1 |n
		.' Don't forget to equip your real weapon again
		.' Go inside the blue glowing orb |goto 39.1,58.1,0.5 |noway |c
	step
		goto 44.3,48.0
		.talk Aviana##41308
		..turnin Return to Aviana##25832
	step
		goto 27.4,55.6
		.talk Nordu##41381
		..turnin The Last Living Lorekeeper##25830
		..accept Firefight##25842
	step
		goto 27.1,54.5
		.kill 5 Fiery Tormentor |q 25842/1
	step
		goto 27.4,55.6
		.talk Nordu##41381
		..turnin Firefight##25842
		..accept Aessina's Miracle##25372
	step
		goto 19.5,37.8
		.talk Arch Druid Hamuul Runetotem##39858
		..turnin Aessina's Miracle##25372
]])
ZygorGuidesViewer:RegisterInclude("A_Frenzyheart_PreQuests", [[
		goto Sholazar Basin,50.5,62.1
		.talk Tamara Wobblesprocket##28568
		..accept The Part-time Hunter##12654
	step
		goto 50.5,77.3
		.from Pitch##28097
		.get Pitch's Remains |q 12654/1
	step
		goto 50.5,76.6
		.talk Tracker Gekgek##28095
		..accept Playing Along##12528
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin Playing Along##12528
		..accept The Ape Hunter's Slave##12529
	step
		'Talk to Goregek the Gorilla Hunter who is following you
		..accept Tormenting the Softknuckles##12530
	step
		goto 57.5,73.3
		.kill 8 Hardknuckle Forager |q 12529/1
	step
		goto 61.1,71.7
		.kill 6 Hardknuckle Charger |q 12529/2
	step
		goto 66.9,73.2
		.' Use your Softknuckle Poker on Softknuckles |use Softknuckle Poker##38467 |tip Softknuckles are baby gorillas.
		.' A Hardknuckle Matriarch will spawn eventually
		.kill 1 Hardknuckle Matriarch |q 12530/1
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Ape Hunter's Slave##12529
		..turnin Tormenting the Softknuckles##12530
		..accept The Wasp Hunter's Apprentice##12533
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..accept The Sapphire Queen##12534
	step
		goto 59.6,75.8
		.kill 6 Sapphire Hive Wasp |q 12533/1
		.kill 9 Sapphire Hive Drone |q 12533/2
	step
		goto 59.4,79.1|n
		.' The path down to The Sapphire Queen starts here |goto 59.4,79.1,0.3 |noway |c |q 12534
	step
		'Follow the path down to 57.1,79.3 |goto 57.1,79.3
		.from Sapphire Hive Queen##28087
		.get Stinger of the Sapphire Queen |q 12534/1
	step
		'Go outside to 55.0,69.1|goto 55.0,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Wasp Hunter's Apprentice##12533
		..turnin The Sapphire Queen##12534
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..accept Flown the Coop!##12532
	step
		'They are all around the village
		.' Click the Chicken Escapees
		.get 12 Captured Chicken |q 12532/1
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..turnin Flown the Coop!##12532
		..accept The Underground Menace##12531
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..accept Mischief in the Making##12535
	step
		goto 56.6,84.6
		.' Click the Skyreach Crystal Formations |tip They look like white crystal cluster on the ground along the river bank.
		.get 8 Skyreach Crystal Cluster |q 12535/1
	step
		goto 49.8,85
		.from Serfex the Reaver##28083
		.get Claw of Serfex |q 12531/1
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Underground Menace##12531
		..turnin Mischief in the Making##12535
		..accept A Rough Ride##12536
	step
		goto 57.3,68.4
		.talk Captive Crocolisk##28298
		..'Tell him let's do this
		.' Travel to Mistwhisper Refuge |q 12536/1
	step
		'When you jump off the crocodile:
		.talk Zepik the Gorloc Hunter##28668
		..turnin A Rough Ride##12536
		..accept Lightning Definitely Strikes Twice##12537
		..accept The Mist Isn't Listening##12538
	step
		goto 45.4,37.2
		.' Use your Skyreach Crystal Clusters next to the stone monument |use Skyreach Crystal Clusters##38510 |tip It's a tall rectangle stone monument.
		.' Click the Arranged Crystal Formation that appears
		.' Sabotage the Mistwhisper Weather Shrine |q 12537/1
	step
		goto 45.5,39.8
		.' Kill 12 Mistwhisper Gorlocs |q 12538/1
	step
		'Use Zepik's Hunting Horn if Zepik is not standing next to you: |use Zepik's Hunting Horn##38512
		.talk Zepik the Gorloc Hunter##28216
		..turnin Lightning Definitely Strikes Twice##12537
		..turnin The Mist Isn't Listening##12538
		..accept Hoofing It##12539
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin Hoofing It##12539
		..accept Just Following Orders##12540
	step
		goto 55.7,64.9
		.talk Injured Rainspeaker Oracle##28217
		..' Pull it to its feet
		.' Kill the crocodile that spawns
		.' Locate the Injured Rainspeaker Oracle |q 12540/1
	step
		goto 55.7,64.9
		.talk Injured Rainspeaker Oracle##28217
		..turnin Just Following Orders##12540
		..accept Fortunate Misunderstandings##12570
		..'Tell him you are ready to travel to his village now.
		.' Escort the Injured Rainspeaker Oracle to Rainspeaker Canopy |q 12570/1
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Fortunate Misunderstandings##12570
		..accept Make the Bad Snake Go Away##12571
	step
		'Use Lafoo's Bug Bag if Lafoo is not standing next to you: |use Lafoo's Bug Bag##38622
		.talk Lafoo##28120
		..accept Gods like Shiny Things##12572
	step
		goto 57.5,52.4
		.kill 1 Venomtip |q 12571/2 |tip He walks back and forth on this small path near the waterfall.
	step
		goto 52.4,53.2
		'Use Lafoo's Bug Bag if Lafoo is not standing next to you: |use Lafoo's Bug Bag##38622
		.' Stand on top of the twinkles of light on the ground around this area
		.' Lafoo will dig up the treasure
		.' Click the random items that appear on the ground
		.get 6 Shiny Treasures |q 12572/1
		.kill 10 Emperor Cobra |q 12571/1
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Make the Bad Snake Go Away##12571
		..accept Making Peace##12573
		..turnin Gods like Shiny Things##12572
	step
		goto 51.3,64.6
		.talk Shaman Vekjik##28315
		..'Tell him you brought an offering
		.' Extend the Peace Offering to Shaman Vekjik |q 12573/1
	step
		goto 50.5,62.1
		.talk Tamara Wobblesprocket##28568
		..turnin The Part-time Hunter##12654
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Making Peace##12573
		..accept Back So Soon?##12574
	step
		goto 42.1,38.6
		.talk Mistcaller Soo-gan##28114
		..turnin Back So Soon?##12574
		..accept The Lost Mistwhisper Treasure##12575
		..accept Forced Hand##12576
	step
		goto 40.4,26.4
		.kill 8 Frenzyheart Spearbearer |q 12576/1
		.kill 6 Frenzyheart Scavenger |q 12576/2
	step
		goto 41.3,19.8
		.kill 1 Warlord Tartek |q 12575/1 |tip He comes walking up on a red dragon.
	step
		goto 41.6,19.5
		.' Click the Mistwhisper Treasure |tip It's a yellow glowing floating orb, hovering over a tree stump altar.
		.get Mistwhisper Treasure |q 12575/2
	step
		goto 42.1,38.6
		.talk Mistcaller Soo-gan##28114
		..turnin The Lost Mistwhisper Treasure##12575
		..turnin Forced Hand##12576
		..accept Home Time!##12577
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Home Time!##12577
		..accept The Angry Gorloc##12578
	step
		goto 75.3,54.1
		.' Travel to Mosswalker Village |q 12578/1
	step
		'Use Moodle's Stress Ball if Moodle is not standing next to you:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin The Angry Gorloc##12578
		..accept The Mosswalker Savior##12580
		..accept Lifeblood of the Mosswalker Shrine##12579
	step
		goto 75.4,52.4
		.talk Mosswalker Victim##28113
		.' Rescue 6 Mosswalker Victims |q 12580/1
	step
		'Use Moodle's Stress Ball if Moodle is not standing next to you:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin The Mosswalker Savior##12580
	step
		goto 68.9,54.6
		.' Click Lifeblood Shards on the ground |tip They look like small red crystals on the ground around this area.
		.get 10 Lifeblood Shard |q 12579/1
	step
		goto 54.5,56.6
		'You can also use Moodle's Stress Ball if you have it in your bags:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin Lifeblood of the Mosswalker Shrine##12579
		..accept A Hero's Burden##12581
]])
ZygorGuidesViewer:RegisterInclude("A_Frenzyheart_Dailies", [[
		' During this next part you will fight a boss.
		.' If you kill Jaloot during the fight, you will be able to pick up the Frenzyheart Tribe quest, and vice versa.
		.' NOTE** _You must kill Artuis Slowly if you are high level_. This will decrease your Reputation with the _Oracles_ to _Hated_
		'|from Jaloot##28667
		|confirm always
	step
		goto 70.8,58.7
		.' Enter the cave here
		.' Follow the path inside the cave up to [72.2,57.3]
		.kill Artruis the Heartless##28659 |q 12581/1
		.click Artruis' Phylactery##4712
		|tip This will spawn after the fight
		..turnin A Hero's Burden##12581
		..talk Zepik the Gorloc Hunter##28668
		...accept Frenzyheart Champion##12582
		...accept Return of the Lich Hunter##12692
		.' If you cannot accept than you will need to wait until the next day and try again.  |confirm always
	step
		goto 55.4,69.6
		.talk Elder Harkek##28138
		.turnin Return of the Lich Hunter##12692
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..accept Chicken Party!##12702
		.' Tell him you need to find Goregek
		.collect Goregek's Shackles##38619 |q 12702
	step
		goto 55.7,69.5
		.talk Rejek##29043
		.' You will only be able to accept, and turn in, 1 of these 4 daily quests per day:
		..accept A Hero's Headgear##12758 |or
		..accept Rejek: First Blood##12734 |or
		..accept Strength of the Tempest##12741 |or
		..accept The Heartblood's Strength##12732 |or
	step
		goto 55.5,68.7
		.talk Vekgar##29146
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept Kartak's Rampage##12703 |or
		..accept Secret Strength of the Frenzyheart##12760 |or
		..accept Tools of War##12759 |or
	step
		'They are all around the village
		.' Use your Chicken Net on the Chicken Escapees if you cannot catch them easily |use Chicken Net##38689
		.' Click the Chicken Escapees
		.get 12 Captured Chicken |q 12702/1
	step
		goto 33.1,47.3
		.from Venture Co. Ruffian##28124+, Venture Co. Excavator##28123+
		.collect Venture Co. Explosives##39651 |q 12758
	step
		goto 26.0,35.4
		.from Stormwatcher##28877+
		.' Use your Venture Co. Explosives on a Stormwatcher's corpse |use Venture Co. Explosives##39651
		.' Click the Stormwatcher's Head that spawns
		.get Stormwatcher's Head |q 12758/1
	step
		goto 59.7,70.9
		.from Hardknuckle Charger##28096+
		.' Use Rejek's Blade on a Hardknuckle Charger's corpse |use Rejek's Blade##39577
		.' Blood your Blade on a Hardknuckle Charger |q 12734/2
	step
		goto 59.3,75.7
		.from Sapphire Hive Wasp##28086+
		.' Use Rejek's Blade on a Sapphire Hive Wasp's corpse |use Rejek's Blade##39577
		.' Blood your Blade on a Sapphire Hive Wasp |q 12734/1
	step
		goto 43.1,40.4
		.from Mistwhisper Warrior##28109+, Mistwhisper Oracle##28110+
		.' Use Rejek's Blade on 3 Mistwhisper mob's corpse |use Rejek's Blade##39577
		.' Blood your Blade on 3 Mistwhisper Members |q 12734/3
	step
		goto 26.5,35.1
		.from Aqueous Spirit##28862+
		.collect 3 Essence of the Monsoon##39616 |q 12741
		.from Storm Revenant##28858+
		.collect 3 Essence of the Storm##39643 |q 12741
	step
		goto 22.4,33.8
		.' Stand right up next to the tall stone altar |tip You may even need to rub against, or stand next to it so that you are touching it.
		.' Feel the True Power of the Tempest |q 12741/1
	step
		goto 59.7,23.9
		.from Goretalon Matriarch##29044 |tip It looks like a white eagle perched up on a hill, next to a nest with 1 egg in it.
		.collect Matriarch's Heartblood##39573 |q 12732
	step
		goto 33.8,52.1
		.' Use Rejek's Vial while standing in the water at the top of the Suntouched Pillar |use Rejek's Vial##39574
		.collect Suntouched Water##39576 |n
		.' Click the Suntouched Water in your bags |use Suntouched Water##39576
		.get Suntouched Heartblood |q 12732/1
	step
		goto 31.6,69.5
		.from Sparktouched Warrior##28111+, Sparktouched Oracle##28112+
		.collect Oracle Blood##39265 |q 12703
	step
		goto 23.3,83.0
		.' Use your Oracle Blood next to the Altar of Kartak |use Oracle Blood##39265 |tip The Altar of Kartak has a big skull on top of it, with long curved horns.  There are 3 small fires at the base of the altar, also.
		.' Take Control of Kartak |invehicle |c |q 12703
	step
		goto 30.7,78.0
		.' Use Kartak's abilities to kill Oracle mobs around this area
		.kill 50 Sparktouched Gorloc |q 12703/1
	step
		goto 30.1,70.7
		.' Drink the Secret Strength of the Frenzyheart in your bags |use Secret Strength of the Frenzyheart##39737
		.from Sparktouched Warrior##28111+, Sparktouched Oracle##28112+
		.' Kill 30 Sparktouched Gorlocs |q 12760/1
	step
		goto 24.0,83.1
		.' Click Zepik's Trap Stash |tip Zepik's Trap Stash looks like a small brown chest on the ground, next to some wiry stick huts.
		.collect Spike Bomb##39697 |q 12759
		.collect Ensnaring Trap##39695 |q 12759
		.collect Volatile Trap##39696 |q 12759
	step
		goto 28.4,76.1
		.' Use your Spike Bomb |use Spike Bomb##39697
		.' Use your Ensnaring Trap |use Ensnaring Trap##39695
		.' Use your Volatile Trap |use Volatile Trap##39696
		.' Use your traps near Oracles mobs around this area
		.' Kill 50 Sparktouched Gorlocs |q 12759/1
	step
		goto 23.4,83.3
		.talk Shaman Jakjek##28106
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..turnin Kartak's Rampage##12703
		..turnin Secret Strength of the Frenzyheart##12760
		..turnin Tools of War##12759
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..turnin Chicken Party!##12702
	step
		goto 55.7,69.5
		.talk Rejek##29043
		.' You will only be able to accept, and turn in, 1 of these 4 daily quests per day:
		..turnin A Hero's Headgear##12758
		..turnin Rejek: First Blood##12734
		..turnin Strength of the Tempest##12741
		..turnin The Heartblood's Strength##12732
]])
ZygorGuidesViewer:RegisterInclude("A_Oracles_PreQuests", [[
		goto Sholazar Basin,50.5,62.1
		.talk Tamara Wobblesprocket##28568
		..accept The Part-time Hunter##12654
	step
		goto 50.5,77.3
		.from Pitch##28097
		.get Pitch's Remains |q 12654/1
	step
		goto 50.5,76.6
		.talk Tracker Gekgek##28095
		..accept Playing Along##12528
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin Playing Along##12528
		..accept The Ape Hunter's Slave##12529
	step
		.talk Goregek the Gorilla Hunter##28214
		'If he is not following your, use his Shackles in your bags. |use Goregek's Shackles##38619
		..accept Tormenting the Softknuckles##12530
	step
		goto 57.5,73.3
		.kill 8 Hardknuckle Forager##28098+ |q 12529/1
	step
		goto 61.1,71.7
		.kill 6 Hardknuckle Charger##28096+ |q 12529/2
	step
		goto 66.9,73.2
		.' Use your Softknuckle Poker on Softknuckles |use Softknuckle Poker##38467 |tip Softknuckles are baby gorillas.
		.' A Hardknuckle Matriarch will spawn eventually
		.kill 1 Hardknuckle Matriarch##28213 |q 12530/1
		'|from Softknuckle##28127+
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Ape Hunter's Slave##12529
		..turnin Tormenting the Softknuckles##12530
		..accept The Wasp Hunter's Apprentice##12533
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..accept The Sapphire Queen##12534
	step
		goto 59.6,75.8
		.kill 6 Sapphire Hive Wasp##28086+ |q 12533/1
		.kill 9 Sapphire Hive Drone##28085+ |q 12533/2
	step
		goto 59.4,79.1|n
		.' The path down to The Sapphire Queen starts here |goto 59.4,79.1,0.3 |noway |c |q 12534
	step
		'Follow the path down to 57.1,79.3 |goto 57.1,79.3
		.from Sapphire Hive Queen##28087
		.get Stinger of the Sapphire Queen |q 12534/1
	step
		'Go outside to 55.0,69.1|goto 55.0,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Wasp Hunter's Apprentice##12533
		..turnin The Sapphire Queen##12534
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..accept Flown the Coop!##12532
	step
		'Throw your Chicken Net at the Chicken Escapees |use Chicken Net##38689
		.clicknpc Chicken Escapee##28161+
		.get 12 Captured Chicken |q 12532/1
	step
		goto 55.5,69.7
		.talk Elder Harkek##28138
		..turnin Flown the Coop!##12532
		..accept The Underground Menace##12531
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..accept Mischief in the Making##12535
	step
		goto 56.6,84.6
		.click the Skyreach Crystal Formation##7927+
		|tip They are in the rocky areas along this river.
		.get 8 Skyreach Crystal Cluster |q 12535/1
	step
		goto 49.8,85
		.from Serfex the Reaver##28083
		|tip You will find him along the bank of this river. Look for the rumbling rocks.
		.get Claw of Serfex |q 12531/1
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin The Underground Menace##12531
		..turnin Mischief in the Making##12535
		..accept A Rough Ride##12536
	step
		goto 57.3,68.4
		.talk Captive Crocolisk##28298
		..'Tell him let's do this
		.' Travel to Mistwhisper Refuge |q 12536/1
	step
		'When you jump off the crocodile:
		.talk Zepik the Gorloc Hunter##28668
		..turnin A Rough Ride##12536
		..accept Lightning Definitely Strikes Twice##12537
		..accept The Mist Isn't Listening##12538
	step
		goto 45.4,37.2
		.' Use your Skyreach Crystal Clusters next to the stone monument |use Skyreach Crystal Clusters##38510 |tip It's a tall rectangle stone monument.
		.' Click the Arranged Crystal Formation that appears
		.' Sabotage the Mistwhisper Weather Shrine |q 12537/1
	step
		goto 45.5,39.8
		.' Kill 12 Mistwhisper Gorlocs |q 12538/1
	step
		'Use Zepik's Hunting Horn if Zepik is not standing next to you: |use Zepik's Hunting Horn##38512
		.talk Zepik the Gorloc Hunter##28216
		..turnin Lightning Definitely Strikes Twice##12537
		..turnin The Mist Isn't Listening##12538
		..accept Hoofing It##12539
	step
		goto 55,69.1
		.talk High-Shaman Rakjak##28082
		..turnin Hoofing It##12539
		..accept Just Following Orders##12540
	step
		goto 55.7,64.9
		.talk Injured Rainspeaker Oracle##28217
		..' Pull it to its feet
		.' Kill the crocodile that spawns
		.' Locate the Injured Rainspeaker Oracle |q 12540/1
	step
		goto 55.7,64.9
		.talk Injured Rainspeaker Oracle##28217
		..turnin Just Following Orders##12540
		..accept Fortunate Misunderstandings##12570
		..'Tell him you are ready to travel to his village now.
		.' Escort the Injured Rainspeaker Oracle to Rainspeaker Canopy |q 12570/1
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Fortunate Misunderstandings##12570
		..accept Make the Bad Snake Go Away##12571
	step
		'Use Lafoo's Bug Bag if Lafoo is not standing next to you: |use Lafoo's Bug Bag##38622
		.talk Lafoo##28120
		..accept Gods like Shiny Things##12572
	step
		goto 57.5,52.4
		.kill 1 Venomtip##28358 |q 12571/2 |tip He walks back and forth on this small path near the waterfall.
	step
		goto 52.4,53.2
		'Use Lafoo's Bug Bag if Lafoo is not standing next to you: |use Lafoo's Bug Bag##38622
		.' Stand on top of the twinkles of light on the ground around this area
		.' Lafoo will dig up the treasure
		.' Click the random items that appear on the ground
		.get 6 Shiny Treasures |q 12572/1
		.kill 10 Emperor Cobra |q 12571/1
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Make the Bad Snake Go Away##12571
		..accept Making Peace##12573
		..turnin Gods like Shiny Things##12572
	step
		goto 51.3,64.6
		.talk Shaman Vekjik##28315
		..'Tell him you brought an offering
		.' Extend the Peace Offering to Shaman Vekjik |q 12573/1
	step
		goto 50.5,62.1
		.talk Tamara Wobblesprocket##28568
		..turnin The Part-time Hunter##12654
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Making Peace##12573
		..accept Back So Soon?##12574
	step
		goto 42.1,38.6
		.talk Mistcaller Soo-gan##28114
		..turnin Back So Soon?##12574
		..accept The Lost Mistwhisper Treasure##12575
		..accept Forced Hand##12576
	step
		goto 40.4,26.4
		.kill 8 Frenzyheart Spearbearer##28080 |q 12576/1
		.kill 6 Frenzyheart Scavenger##28081 |q 12576/2
	step
		goto 41.3,19.8
		.kill 1 Warlord Tartek##28105 |q 12575/1 |tip He comes walking up on a red dragon.
	step
		goto 41.6,19.5
		.click the Mistwhisper Treasure##7951
		|tip It's a yellow glowing floating orb, hovering over a tree stump altar.
		.get Mistwhisper Treasure |q 12575/2
	step
		goto 42.1,38.6
		.talk Mistcaller Soo-gan##28114
		..turnin The Lost Mistwhisper Treasure##12575
		..turnin Forced Hand##12576
		..accept Home Time!##12577
	step
		goto 54.6,56.3
		.talk High-Oracle Soo-say##28027
		..turnin Home Time!##12577
		..accept The Angry Gorloc##12578
	step
		goto 75.3,54.1
		.' Travel to Mosswalker Village |q 12578/1
	step
		'Use Moodle's Stress Ball if Moodle is not standing next to you:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin The Angry Gorloc##12578
		..accept The Mosswalker Savior##12580
		..accept Lifeblood of the Mosswalker Shrine##12579
	step
		goto 75.4,52.4
		.talk Mosswalker Victim##28113
		.' Rescue 6 Mosswalker Victims |q 12580/1
	step
		'Use Moodle's Stress Ball if Moodle is not standing next to you:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin The Mosswalker Savior##12580
	step
		goto 68.9,54.6
		.' Click Lifeblood Shards on the ground |tip They look like small red crystals on the ground around this area.
		.get 10 Lifeblood Shard |q 12579/1
	step
		goto 54.5,56.6
		'You can also use Moodle's Stress Ball if you have it in your bags:|use Moodle's Stress Ball##38624
		.talk Moodle##28122
		..turnin Lifeblood of the Mosswalker Shrine##12579
		..accept A Hero's Burden##12581
]])
ZygorGuidesViewer:RegisterInclude("A_Oracles_Dailies", [[
		' During this next part you will fight a boss.
		.' If you kill Zepik the Gorloc Hunter during the fight, you will be able to pick up the Oracle quest, and vice versa.
		.' NOTE** _You must kill Artuis Slowly if you are high level_. This will decrease your Reputation with the _Frenzyheart Tribe_ to _Hated_
		'|from Zepik the Gorloc Hunter##28668
		|confirm always
	step
		goto 70.8,58.7
		.' Enter the cave here
		.' Follow the path inside the cave up to [72.2,57.3]
		.kill Artruis the Heartless##28659 |q 12581/1
		.click Artruis' Phylactery##4712
		|tip This will spawn after the fight
		..turnin A Hero's Burden##12581
		..talk Jaloot##28667
		...accept Hand of the Oracles##12689
		...accept Return of the Friendly Dryskin##12695
		.' If you cannot accept than you will need to wait until the next day and try again. |confirm
	step
		goto 54.6,56.4
		.talk High-Oracle Soo-say##28027
		..turnin Return of the Friendly Dryskin##12695
	step
		goto 54.6,56.4
		.talk High-Oracle Soo-say##28027
		..accept Appeasing the Great Rain Stone##12704
		.' Tell him you need to find Lafoo
		.collect Lafoo's Bug Bag##38622 |q 12704
	step
		goto 53.3,56.5
		.talk Oracle Soo-nee##29006
		.' You will only be able to accept, and turn in, 1 of these 4 daily quests per day:
		..accept A Cleansing Song##12735 |or
		..accept Song of Fecundity##12737 |or
		..accept Song of Reflection##12736 |or
		..accept Song of Wind and Water##12726 |or
	step
		goto 54.2,53.8
		.talk Oracle Soo-dow##29149
		.' You will only be able to accept, and turn in, 1 of these 3 daily quests per day:
		..accept Mastery of the Crystals##12761 |or
		..accept Power of the Great Ones##12762 |or
		..accept Will of the Titans##12705 |or
	step
		goto 52.4,53.2
		'Use Lafoo's Bug Bag if Lafoo is not standing next to you:|use Lafoo's Bug Bag##38622
		.' Stand on top of the twinkles of light on the ground around this area
		.' Lafoo will dig up the treasure
		.' Click the random items that appear on the ground
		.get 6 Shiny Treasures|q 12704/1
	step
		goto 42.7,42.8
		.' Use your Chime of Cleansing in this spot |use Chime of Cleansing##39572
		.kill Spirit of Atha |q 12735/1
	step
		goto 49.4,62.7
		.' Use your Chime of Cleansing in this spot |use Chime of Cleansing##39572
		.kill Spirit of Ha-Khalan |q 12735/2
	step
		goto 48.8,70.5
		.' Use your Chime of Cleansing in this spot |use Chime of Cleansing##39572
		.kill Spirit of Koosu |q 12735/3
	step
		goto 26.2,37.1
		.' Use your Horn of Fecundity next to Soaked Fertile Dirt piles |use Horn of Fecundity##39599
		.' Play the Song of Fecundity 8 Times |q 12737/1
	step
		goto 50.0,37.4
		.' Use your Didgeridoo of Contemplation at the top of The Glimmering Pillar |use Didgeridoo of Contemplation##39598
		.' Contemplate at the Glimmering Pillar |q 12736/1
	step
		goto 33.6,52.3
		.' Use your Didgeridoo of Contemplation at the top of The Suntouched Pillar |use Didgeridoo of Contemplation##39598
		.' Contemplate at the Suntouched Pillar |q 12736/4
	step
		goto 36.4,74.7
		.' Use your Didgeridoo of Contemplation at the top of The Mosslight Pillar |use Didgeridoo of Contemplation##39598
		.' Contemplate at the Mosslight Pillar |q 12736/2
	step
		goto 53.3,79.4
		.' Use your Didgeridoo of Contemplation at the top of The Skyreach Pillar |use Didgeridoo of Contemplation##39598
		.' Contemplate at the Skyreach Pillar |q 12736/3
	step
		goto 26.2,37.1
		.' Use your Drums of the Tempest to take control of Haiphoon, the Great Tempest |use Drums of the Tempest##39571
		.' Haiphoon has 2 forms: Water and Air |tip When in Haiphoon's Water form, use Haiphoon's abilities to fight Storm Revenants around this area.  When the Storm Revenants are weak, use Haiphoon's Devour Wind ability to eat them.  When in Haiphoon's Air form, use Haiphoon's abilities to fight Aqueous Spirits around this area.  When the Aqueous Spirits are weak, use Haiphoon's Devour Water ability to eat them.  After eating an elemental, you will take on Haiphoon's matching form of that elemental you last ate.  Keep repeating this process.
		.' Devour 3 Aqueous Spirits |q 12726/1
		.' Devour 3 Storm Revenants |q 12726/2
	step
		goto 33.0,75.7
		.' Click the Sparktouched Crystal Defenses |tip It looks like a small bamboo chest sitting at the base of a tree, next to a small hut.
		.collect 1 Crystal of the Violent Storm##39694 |q 12761
		.collect 1 Crystal of Unstable Energy##39693 |q 12761
		.collect 1 Crystal of the Frozen Grip##39689 |q 12761
	step
		goto 22.2,78.0
		.' Use your Crystal of the Frozen Grip |use Crystal of the Frozen Grip##39689
		.' Use your Crystal of the Violent Storm |use Crystal of the Violent Storm##39694
		.' Use your Crystal of Unstable Energy |use Crystal of Unstable Energy##39693
		.' Use your crystals near Frenzyheart mobs around this area
		.' Kill 50 Frenzyheart Attackers |q 12761/1
	step
		goto 65.5,60.2
		.' Use your Dormant Polished Crystal at the top of the Lifeblood Pillar, next to the big red crystal |use Dormant Polished Crystal##39747
		.get Energized Polished Crystal |q 12762/2
	step
		goto 22.2,78.0
		.' Use your Energized Polished Crystal |use Energized Polished Crystal##39748 |tip This will give you a buff that will heal you a lot every time you do damage to an enemy, so you can fight a LOT of mobs at once.
		.' Kill 30 Frenzyheart Attackers |q 12762/1
	step
		goto 22.9,76.0
		.from Frenzyheart Ravager##28078+, Frenzyheart Hunter##28079+
		.collect 1 Tainted Crystal##39266 |q 12705
	step
		goto 33.7,75.0
		.' Use your Tainted Crystal next to the tall stone altar |use Tainted Crystal##39266
		.' Take control of Soo-holu |invehicle |c |q 12705
	step
		goto 22.2,78.0
		.' Use Soo-holu's abilities to kill Frenzyheart mobs around this area
		.kill 50 Frenzyheart Attacker |q 12705/1
	step
		goto 33.5,74.8
		.talk Lightningcaller Soo-met##28107
		..turnin Mastery of the Crystals##12761
		..turnin Power of the Great Ones##12762
		..turnin Will of the Titans##12705
	step
		goto 53.3,56.5
		.talk Oracle Soo-nee##29006
		.' You will only be able to accept, and turn in, 1 of these 4 daily quests per day:
		..turnin A Cleansing Song##12735
		..turnin Song of Fecundity##12737
		..turnin Song of Reflection##12736
		..turnin Song of Wind and Water##12726
	step
		goto 54.6,56.4
		.talk High-Oracle Soo-say##28027
		..turnin Appeasing the Great Rain Stone##12704
]])
ZygorGuidesViewer:RegisterInclude("A_Wyrmrest_Pre-Quests", [[
		goto Dragonblight 29.0,55.4
		.talk Image of Archmage Aethas Sunreaver##26471
		..accept Rifle the Bodies##12000
	step
		goto 22.3,54.1
		.' Loot the Dead Mage Hunter bodies on the ground
		.collect Mage Hunter Personal Effects bags |n
		.click the Mage Hunter Personal Effects bags|use Mage Hunter Personal Effects##35792
		..get Moonrest Gardens Plans|q 12000/1
		|modelnpc Dead Mage Hunter##32572
	step
		goto 29.0,55.4
		.talk Image of Archmage Modera##26673
		..turnin Rifle the Bodies##12000
		..accept Prevent the Accord##12004
	step
		goto 18.4,58.9
		.from Wind Trader Mu'fah##26496
		.get Wind Trader Mu'fah's Remains |q 12004/1
	step
		'Go inside the building to 19.4,58.1|goto Dragonblight,19.4,58.1
		.from Goramosh##26349
		.get The Scales of Goramosh |q 12004/2
		.collect Goramosh's Strange Device##36746 |n
		.' Click Goramosh's Strange Device|use Goramosh's Strange Device##36746
		..accept A Strange Device##12055
	step
		goto 29.0,55.4
		.talk Image of Archmage Modera##26673
		..turnin A Strange Device##12055
		..turnin Prevent the Accord##12004
		..accept Projections and Plans##12060
	step
		goto 22.2,54.8
		.' Use your Surge Needle Teleporter anywhere inside Moonrest Gardens|use Surge Needle Teleporter##36747
		.' Move toward the center of the platform you get teleported onto
		.' Observe the Object on the Surge Needle|goal Object on the Surge Needle observed|q 12060/1
	step
		'Use your Surge Needle Teleporter to go back down to the ground|goto 22.6,57.0,0.3|use Surge Needle Teleporter##36747|noway|c
	step
		goto 29.0,55.4
		.talk Image of Archmage Modera##26673
		..turnin Projections and Plans##12060
		..accept The Focus on the Beach##12065
	step
		goto 26.4,65
		.from Captain Emmy Malin##26762
		.get Ley Line Focus Control Ring|n
		.' Use the Ley Line Focus Control Ring next to the half-circle|use Ley Line Focus Control Ring##36751|tip It's a big half-circle purple glowing thing.
		.' Retrieve ley line focus information|goal Ley line focus information retrieved|q 12065/1
	step
		goto 29.0,55.4
		.talk Image of Archmage Modera##26673
		..turnin The Focus on the Beach##12065
		..accept Atop the Woodlands##12083
	step
		goto 32.2,70.6
		.from Lieutenant Ta'zinni##26815
		.collect Ley Line Focus Amulet##36779 |n
		|confirm  |only if not completedq(12083)
		.collect Lieutenant Ta'zinni's Letter##36780 |n |only if not completedq(12083)
		.' Click Lieutenant Ta'zinni's Letter|use Lieutenant Ta'zinni's Letter##36780 |only if not completedq(12083)
		..accept A Letter for Home##12067 |only if not completedq(12083)
	step
		goto 32.2,71.2
		.' Use your Ley Line Focus Control Amulet on the Ley Line Focus|use Ley Line Focus Control Amulet##36779|tip It's a big half-circle purple glowing thing.
		.' Retrieve Ley Line Focus information|goal Ley line focus information retrieved|q 12083/1
	step
		goto 29.0,55.4
		.talk Image of Archmage Modera##26673
		..turnin Atop the Woodlands##12083
		..accept Search Indu'le Village##12098
	step
		goto 40.3,66.9
		.' Click Mage-Commander Evenstar's body floating underwater
		..turnin Search Indu'le Village##12098
		..accept The End of the Line##12107
	step
		goto 39.8,66.9
		.' Use your Ley Line Focus Control Talisman on the Ley Line Focus|use Ley Line Focus Control Talisman##36815|tip It's a big half-circle purple glowing thing underwater.
		.' Retrieve Ley Line Focus information|goal Ley Line Focus information retrieved|q 12107/1
	step
		goto 53,66.4
		.' Go to this spot on the cliff to Observe Azure Dragonshrine|goal Azure Dragonshrine observed|q 12107/2
	step
		goto 29.0,55.4
		.talk Image of Archmage Modera##26673
		..turnin The End of the Line##12107
		..accept Gaining an Audience##12119
	step
		goto 57.9,54.2
		.talk Tariolstrasz##26443
		..turnin Gaining an Audience##12119
		..accept Speak with your Ambassador##12766
	step
		goto Dragonblight/0 60.0,55.1
		.talk Lauriel Trueblade##27803
		..turnin Speak with your Ambassador##12766
		..accept Report to the Ruby Dragonshrine##12461
	step
		goto Dragonblight/0 52.2,50.0
		.talk Ceristrasz##27506
		..turnin Report to the Ruby Dragonshrine##12461
		..accept Heated Battle##12448
	step
		goto Dragonblight/0 50.4,52.2
		.' Help kill the following:
		.' 12 Frigid Ghoul Attackers|kill 12 Frigid Ghoul Attacker|q 12448/1
		.' 8 Frigid Geist Attackers|kill 8 Frigid Geist Attacker|q 12448/2
		.' 1 Frigid Abomination Attacker|kill 1 Frigid Abomination Attacker|q 12448/3
	step
		goto Dragonblight/0 52.2,50.0
		.talk Ceristrasz##27506
		..turnin Heated Battle##12448
		..accept Return to the Earth##12449
	step
		goto 46.7,52.8
		.' Click the Ruby Acorns|tip The Ruby Acorns look like red stones on the ground around this area.
		.get Ruby Acorns|n
		.' Use the Ruby Acorns on the Ruby Keeper corpses|use Ruby Acorn##37727|tip The Ruby Keepers look like huge red dragons on fire.
		.' Return 6 Ruby Keepers to the Earth|goal 6 Ruby Keeper Returned to the Earth|q 12449/1
	step
		goto Dragonblight/0 52.2,50.0
		.talk Ceristrasz##27506
		..turnin Return to the Earth##12449
		..accept Through Fields of Flame##12450
	step
		'Go into the valley to 48.2,47.8|goto 48.2,47.8
		.kill 6 Frigid Necromancer|q 12450/1
	step
		'Go into the tree trunk to 47.7,49.1|goto 47.7,49.1
		.from Dahlia Suntouch##27680
		.' Cleanse the Ruby Corruption|goal Ruby Corruption Cleansed|q 12450/2
	step
		goto Dragonblight/0 52.2,50.0
		.talk Ceristrasz##27506
		..turnin Through Fields of Flame##12450
		..accept The Steward of Wyrmrest Temple##12768
	step
		goto 57.9,54.2
		.talk Tariolstrasz##26443
		..turnin The Steward of Wyrmrest Temple##12768
		..accept Informing the Queen##12123
	step
		goto 57.9,54.2
		.talk Tariolstrasz##26443
		..'Tell him you want to go to the top of the temple|goto 59.7,53.1,0.5|noway|c
	step
		goto 59.8,54.7
		.talk Alexstrasza the Life-Binder##26917
		..turnin Informing the Queen##12123
		..accept Report to Lord Afrasastrasz##12435
	step
		goto 59.5,53.3
		.talk Torastrasza##26949
		..'Tell him you want to go to Lord Afrasastrasz|goto 59.2,54.3,0.5|noway|c
]])
ZygorGuidesViewer:RegisterInclude("A_Wyrmrest_Dailies", [[
		goto Dragonblight 59.2,54.3
		.talk Lord Afrasastrasz##27575
		..turnin Report to Lord Afrasastrasz##12435
		..accept Defending Wyrmrest Temple##12372
	step
		goto 58.3,55.2
		.talk Wyrmrest Defender##27629
		..'Tell him you are ready to get into the fight
		.' Fly around Wyrmrest Temple fighting the blue dragons in the sky using your abilities on your hotbar
		.kill 3 Azure Dragon|q 12372/1
		.kill 5 Azure Drake|q 12372/2
	step
		'Fly southwest to 55.1,66.4|goto 55.1,66.4
		.' Fly into the huge purple swirling column
		.' Use your Destabilize Azure Dragonshrine ability|petaction Destabilize Azure Dragonshrine
		.' Destabilize the Azure Dragonshrine|q 12372/3
	step
		goto 58.7,54.5|n
		'Click the red arrow to get off the dragon on the middle level of the temple|script VehicleExit()|outvehicle|c
	step
		goto 59.2,54.3
		.talk Lord Afrasastrasz##27575
		..turnin Defending Wyrmrest Temple##12372
]])
-----------------------------------------------------------------------------------------
-- MoP Dailies/Reputations
-----------------------------------------------------------------------------------------


ZygorGuidesViewer:RegisterInclude("A_Anglers", [[
	step
		'You must have fishing in order to accept dailies from this faction.
		|confirm
	step
	label "dailies"
		'There will only be three dailies available from the following questgivers. It is possible for one questgiver to give you two quests in the same day, but it is unlikely.
		|confirm
	step
		goto Krasarang Wilds 67.9,45.2
		.talk Fisherman Haito##59584
		..accept Shocking!##30584 |or
		..accept Jagged Abalone##30586 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 67.5,44.6
		.talk Fiznix##60136
		..accept Like Bombing Fish In A Barrel##30678 |or
		..accept Scavenger Hunt##30698 |or
		.'_
		.' If this quest is unavailable today, click here. |confirm
	step
		goto 67.5,43.5
		.talk Angler Shen##59586
		..accept Snapclaw##30700 |or
		..accept Fishing for a Bruising##30588 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 68.3,43.5
		.talk John "Big Hook" Marsock##60674
		..accept Bright Bait##30754 |or
		..accept Jumping the Shark##30753 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 67.6,42.5
		.talk Trawler Yotimo##60135
		..accept Armored Carp##30613 |or
		..accept Huff & Puff##30658 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 68.4,42.1
		.talk Elder Fisherman Rassan##60673
		..accept What Lurks Below##30585 |or
		..accept Who Knew Fish Liked Eggs?##30598 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 67.2,41.2
		.talk Fo Fook##60675
		..accept Piranha!##30763 |or
		..accept Viseclaw Soup##30701 |or
		.'_
		.' If these quests are unavailable today, click here. |confirm
	step
		goto 68.4,43.1
		.clicknpc Frenzied Reef Shark##60408
		.' Ride the shark. |invehicle |c
		|only if havequest(30753)
	step
		'Use the abilities on your hotbar to kill the shark, make sure not to let your grip bar reach zero.
		.kill Frenzied Reef Shark##60408 |q 30753/1
		|only if havequest(30753)
	step
		goto 69.1,37.9
		.click Jagged Abalone##261
		.get 9 Jagged Abalone Meat##80277 |q 30586/1
		|only if havequest(30586)
	step
		'Enter the underwater cave here. |goto 71.3,38.5 <5 |c
		|only if havequest(30700)
	step
		goto 73.9,38.4
		.from Snapclaw##60401
		.get Snapclaw's Claw##80831 |q 30700/1
		|only if havequest(30700)
	step
		'Leave the cave. |goto 71.3,38.5 <5 |c
		|only if havequest(30700)
	step
		goto 65.6,30.5
		'Use your fishing skill to fish up 7 Dojani Eel. |cast Fishing##131474
		.get 7 Dojani Eel |q 30584/1
		|only if havequest(30584)
	step
		goto 62.4,40.9
		.kill 8 Riverblade Raider##59714+ |q 30588/1
		|only if havequest(30588)
	step
		goto 55.1,45.7
		.from Viseclaw Fry##61090+, Viseclaw Fisher##58880+
		.get 16 Viseclaw Fisher Eye##80832+ |q 30701/1
		|only if havequest(30701)
	step
		goto 59.8,38.8
		.click Suncrawler //unknow model wtf
		.get 7 Suncrawler##81116 |q 30754/1
		|only if havequest(30754)
	step
		goto 59.3,46.3
		'Use your Goblin Fishing Bomb to kill Sting Rays. |use Goblin Fishing Bomb##80599 |tip You can kill the Sting Rays by other means, using the bombs is much quicker though.
		.from Sting Ray##60278+
		.get 3 Stinger##80600+ |q 30678/1
		|only if havequest(30678)
	step
		goto 36.8,43.3
		'Use your fishing skill to fish up 5 Wolf Piranha.
		.get 5 Wolf Piranha |q 30763/1
		|only if havequest(30763)
	step
		goto 34.4,31.4
		'Use your fishing skill in the Mysterious Whirlpool until Narjon the Gulper appears. |tip When Narjon spawns, make sure to equip your weapon quickly.
		.from Narjon the Gulper##59689 |q 30585/1
		.get Beloved Ring##80262 |q 30585/2
		|only if havequest(30585)
	step
		goto 51.4,62.2
		'Use your Anglers Fishing Spear near a Prickly Puffer |use Anglers Fishing Spear##80403 |tip The closer you are the easier it is to hit the fish.
		.from Prickly Puffer##60037
		.get 5 Prickly Puffer Spine##80529 |q 30658/1
		|only if havequest(30658)
	step
		goto 67.5,44.8
		.click Goblin Fishing Raft
		.' Ride a Goblin Fishing Raft |havebuff Rafting
		|only if havequest(30698)
	step
		goto 64.3,50.7
		'Use your fishing skill in the Shipwreck Debris pools to fish up 15 Rusty Shipwreck Debris.
		.get 15 Shipwreck Debris |q 30698/1
		.' You can find more Debris at [64.3,50.6]
		|only if havequest(30698)
	step
		goto 65.2,47.5
		.click Pristine Crane Egg##1867
		.get Pristine Crane Egg |q 30598/1
		|only if havequest(30598)
	step
		goto 70.1,51.2
		'Use your Anglers Fishing Spear near an Armored Carp |use Anglers Fishing Spear##80403 |tip The closer you are the easier it is to hit the fish.
		.from Armored Carp##59936+
		.get 5 Armored Carp##80437 |q 30613/1
		|only if havequest(30613)
	step
		goto 68.2,42.7
		'Use the Pristine Crane Egg in your bags |use Pristine Crane Egg##80303
		.' Use your fishing skill in the Crane Yolk Pool and fish up a Silver Goby.
		.get Silver Goby##80310 |q 30598/2
		|only if havequest(30598)
	step
		goto 68.4,42.1
		.talk Elder Fisherman Rassan##60673
		..turnin What Lurks Below##30585
		..turnin Who Knew Fish Liked Eggs?##30598
	step
		goto 67.5,44.6
		.talk Fiznix##60136
		..turnin Like Bombing Fish In A Barrel##30678
		..turnin Scavenger Hunt##30698
	step
		goto 67.5,43.5
		.talk Angler Shen##59586
		..turnin Snapclaw##30700
		..turnin Fishing for a Bruising##30588
	step
		goto 67.6,42.5
		.talk Trawler Yotimo##60135
		..turnin Armored Carp##30613
		..turnin Huff & Puff##30658
	step
		goto 67.9,45.2
		.talk Fisherman Haito##59584
		..turnin Shocking!##30584
		..turnin Jagged Abalone##30586
	step
		goto 68.3,43.5
		.talk John "Big Hook" Marsock##60674
		..turnin Bright Bait##30754
		..turnin Jumping the Shark##30753
	step
		goto 67.2,41.2
		.talk Fo Fook##60675
		..turnin Piranha!##30763
		..turnin Viseclaw Soup##30701
	step
		goto 68.4,43.4
		.talk Nat Pagle##63721
		..buy 1 Grand Commendation of the Anglers##93225 |n
		.' Use the Commendation of the Anglers you just purchased. |condition ZGV:GetReputation("The Anglers").hasBonus |use Grand Commendation of the Anglers##93225
		|only if rep("The Anglers")>=Revered
	step
		'You have reached the end of this guide.
		.' Click here to go back to the dailies. |confirm |next "dailies"
]])

ZygorGuidesViewer:RegisterInclude("A_Klaxxi", [[
	step
		'This guide requires that you have completed all of the quests in the Dread Wastes.
		'The following questlines are required to access all of the possible dailies for the Klaxxi.
		.' A Cry From Darkness |achieve 6540/1
		.' Falling to Pieces |achieve 6540/2
		.' Blood of Ancients |achieve 6540/3
		.' Mazu's Bounty |achieve 6540/4
		..' Please refer to Zygor's Leveling and Loremaster guides for assistance in completing these questlines. |only if not achieved(6540) and not ZGV.guidesets['LevelingAMOP']
		..' Click here to go to Zygor's Leveling and Loremaster guides for assistance in completing these questlines. |confirm |next "Zygor's Alliance Loremaster Guides\\Pandaria 85-90\\Dread Wastes" |only if not achieved(6540) and ZGV.guidesets['LevelingAMOP']
		|confirm
	step
	label	klaxxi start
		goto Dread Wastes 55.0,35.4
		.talk Malik the Unscathed##62774
		..accept The Empress' Gambit##31959
		|only if rep("The Klaxxi")>=Exalted
	step
		goto Dread Wastes 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..accept Dreadspinner Extermination##31231 |or 2
		..accept Nope Nope Nope##31235 |or 2
		..accept Culling the Swarm##31109 |or 2
		..accept Mistblade Destruction##31267 |or 2
		..accept Eradicating the Zan'thik##31111 |or 2
		..accept Vess-Guard Duty##31505 |or 2
		|noquest
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		..accept Dark Skies##31216
		|noquest
	step
		goto 54.8,36.2
		.talk Hisek the Swarmkeeper##63785
		..accept Debugging the Terrace##31237 |or
		..accept Quiet Now##31510 |or
		..accept Infection##31272 |or
		..accept Ordnance Disposal##31504 |or
		|noquest
	step
		goto 54.3,36.1
		.talk Korven the Prime##62180
		..accept An Ancient Empire##31232 |or 2
		..accept Sap Tapping##31233 |or 2
		..accept Sampling the Empire's Finest##31496 |or 2
		..accept The Fight Against Fear##31270 |or 2
		..accept The Scale-Lord##31269 |or 2
		..accept Meltdown##31507 |or 2
		|noquest
	step
		goto 54.3,35.9
		.talk Rik'kal the Dissector##65253
		..accept Bad Genes##31271 |or 2
		..accept Wing Clip##31502 |or 2
		..accept Shortcut to Ruin##31503 |or 2
		..accept Putting An Eye Out##31234 |or 2
		..accept Specimen Request##31508 |or 2
		..accept Fear Takes Root##31509 |or 2
		|noquest
	step
		goto 54.3,35.8
		.talk Kaz'tik the Manipulator##63758
		..accept Brain Food##31238 |or 2
		..accept Sonic Disruption##31487 |or 2
		..accept Free From Her Clutches##31494 |or 2
		..accept A Little Brain Work##31268 |or 2
		..accept Kunchong Treats##31024  |or 2
		..accept Rampage Against the Machine##31808 |or 2
		..accept Shackles of Manipulation##31506 |or 2
		|noquest
//terrace of gurthan
	step
		goto 55.1,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		.' Tell him:
		.' <Please Fly me to the Terrace of Gurthan.> |invehicle
		|only if havequest(31237) or havequest(31231)
	step
		 goto 67.9,24.3
		 .' Kill creatures until you get the buff:
		 .' Pheremone Tracking |havebuff Interface\Icons\Ability_Rogue_BloodyEye
		 .' Locate and kill Eye's of the Empress. |tip Start looking for red mist on the groud first.
		 .kill 6 Eye of the Empress##63783+ |q 31237/1
		|only if havequest(31237) or havequest(31231)
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		.' Talk to Xaril and tell him:  |q 31216/1
		.' <I am ready to fly, Xaril.> |invehicle
		|only if havequest(31216)
	step
		'Use the _Venom Bomb_ to kill the small enemies.
		.' Use the _Paralyzing Syrum_ then immidiately the _Venom Bomb_ to kill the larger enemies.
		.kill 200 Mantid |q 31216/2
		.kill 3 Kunchong |q 31216/3
		|only if havequest(31216)
	step
		'Click the Return to Klaxxi'vess button on your action bar |outvehicle
		|only if havequest(31216)
	step
		goto 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		.' Ask him to fly you to the Clutches of Shek'zeer. |invehicle
		|only if havequest(31109)
	step
		goto 38.3,30.3
		'Use the Sonic Divebomb ability on your new hotbar to land. |outvehicle
		tip It's a good idea to land on Karanosh <Kunchong Matriarch>, she drops a daily quest item.
		|only if havequest(31109)
	step
		'Enter this building. |goto 37.0,28.1 <5 |c
		goto 37.4,29.3
		.click Central Feeder##12991
		.' Sample the Central Feeder |q 31496/1
		|only if havequest(31496)
	step
		'Enter this building. |goto 39.3,29.3 <5 |c
		goto 39.1,30.5
		.click Northeast Feeder##12991
		.' Sample the Northeast Feeder |q 31496/4
		|only if havequest(31496)
	step
		goto 39.3,30.9
		.kill Vess-Guard Na'kal##64890 |q 31503/1
		|only if havequest(31503)
	step
		'Enter this building. |goto 38.3,32.0 <5 |c
		goto 37.9,33.1
		.click East Feeder##12991
		.' Sample the East Feeder |q 31496/2
		|only if havequest(31496)
	step
		'Enter this building. |goto 36.3,32.3 <5 |c
		goto 37.0,32.8
		.click North Feeder##12991
		.' Sample the North Feeder |q 31496/3
		|only if havequest(31496)
	step
		goto 35.2,31.3
		.from Shek'zeer Needler##64714+
		.get 24 Needler Wings##87401 |q 31502/1
		|only if havequest(31502)
	step
		goto 66.0,19.3
		.from Greatback Mushan##62029
		.get 6 Mushan Tongue##85665 |q 31238/1
		.' You can find more Mushan around [56.9,23.4]
		|only if havequest(31238)
	step
		'In order to do the 'hidden' quest for this area, you must have at least one other person to help you.
		|confirm
		|only if havequest(31237) or havequest(31231)
	step
		goto 66.2,31.8
		.' Around this location you should be able to see a _green rune_ and a _red rune_.
		.' One person will need to _/lay_ on the _green rune_, while the other must _/kneel_ at the _red rune_. This will cause a level 90 Elite to spawn.
		.' This daily is active for everyone in the area, so you should find some help easily.
		.from Warlord Gurthan##65502
		.collect Ashes of Warlord Gurthan##88715 |future |q 31677
		|only if havequest(31237) or havequest(31231)
	step
		.' Click the _Ashes of Warlord Gurthan_ in your bags |use Ashes of Warlord Gurthan##88715
		..accept The Warlord's Ashes##31677
		|only if havequest(31237) or havequest(31677) or havequest(31231)
	step
		goto 73.2,22.5
		'Use the Shado-Pan Dragon Gun on Dreadspinner Eggs |use Shado-Pan Dragon Gun##82807 |only if havequest(31235)
		.' Destroy 20 Dreadspinner Eggs |q 31235/1 |only if havequest(31235)
		.kill 8 Dreadspinner Tender##61981+ |q 31231/1 |only if havequest(31231)
		|only if havequest(31235) or havequest(31231)
	step
		goto 68.1,30.0
		.click Gurthani Tablet
		.get 8 Gurthani Tablet##85634 |q 31232/1
		|only if havequest(31232)
	step
		goto 67.7,37.1
		.from Mire Beast##63731+
		.get 1 Pristine Mire Beast Eye## |q 31234/1
		|only if havequest(31234)
	step
		goto 66.6,43.8
		.click Amber Tap |tip These are located on trees. Look for Sapfly packs to find these easier. |modelnpc Sapfly##62386
		.click Amber Pot
		.get 6 Amber Sap##85664 |q 31233/1
		|only if havequest(31233)
	step
		goto 42.0,33.7
		.click Pheromone Mine
		.' Disable 8 Pheromone Mines |q 31504/1
		.' You can find more mines around [48.1,31.4]
		|only if havequest(31504)
	step
		goto 44.9,35.6
		.' Use the Sonic Disruption Fork on Dread Kunchong. |use Sonic Disruption Fork##87394 |only if havequest(31487)
		.kill 4 Dread Kunchong##64717 |q 31487/1 |only if havequest(31487)
		.kill 6 Shek'zeer Manipulator##64720 |q 31487/2 |only if havequest(31487)
		.click Kunchong Cage |only if havequest(31494)
		.' Free 8 Kunchong Hatchlings |q 31494/1 |only if havequest(31494)
		|only if havequest(31487) or havequest(31494)
	step
		goto 44.4,43.0
		.from Shek'zeer Swarmborn##62582+, Shek'zeer Needler##64714+, Shek'zeer Bladesworn##62563+, Shek'zeer Clutch-Keeper##64559+
		.' Kill 40 Shek'zeer Mantid. |q 31109/1
		tip It's by far fastest to kill the tiny Shek'zeer Swarmborn by the dozen.
		|only if havequest(31109)
	step
		goto 41.4,33.2
		.from Karanosh##64724 |tip She wanders around this area, so you may have to search for her.
		.collect Enormous Kunchong Mandibles##87878
		.' Click the Enormous Kunchong Mandibles in your bags |use Enormous Kunchong Mandibles##87878
		..accept The Matriarch's Maw##31599
		|only if havequest(31109)
	step
		goto 58.6,51.1
		.kill 15 Horrorscale Scorpid##62162+ |q 31270/1 |only if havequest(31270)
		.from Chillwater Turtle##62160+ |only if havequest(31024)
		.get 4 Meaty Turtle Haunch##82869 |q 31024/1 |only if havequest(31024)
		|only if havequest(31270) or havequest(31024)
	step
		goto 62.0,65.8
		.kill 3 Ik'thik Genemancer##63257+ |q 31271/1
		.kill 6 Ik'thik Egg-Drone##63176+ |q 31271/2
		|only if havequest(31271)
	step
		goto 61.4,70.3
		.' Use the Sonic Emitter in your bags on Ik'thik Amberstingers. |use Sonic Emitter##85884
		.from Ik'thik Amberstinger##63728+
		.get 3 Amber-Encrusted Brain##85885 |q 31268/1
		|only if havequest(31268)
	step
		 goto 60.7,67.7
		.from Bluehide Mushan##63729+, Needleback Porcupine##65118+, Bonedust Moth##63725+ |tip Make sure that they have the Infected buff before you attack them. Only wildlife with that buff will count for this quest.
		.kill 6 Infected wildlife |q 31272/1
		|only if havequest(31272)
	step
		'Enter the tunnel here. |goto 66.8,63.8 <5 |c
		|only if havequest(31269)
	step
		goto 66.5,66.0
		.kill Mistblade Scale-Lord##63179 |q 31269/1
		|only if havequest(31269)
	step
		'Leave the tunnel. |goto 66.8,63.8 <5 |c
		|only if havequest(31269)
	step
		goto 67.2,59.3
		.kill 6 Mistblade Ripper##61970+ |q 31267/1
		|only if havequest(31267)
	step
		goto 55.1,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		.' Ask him to fly you to Zan'vess |invehicle
		|only if havequest(31111) or havequest(31508) or havequest(31506) or havequest(31111) or havequest(31510)
	step
		goto 31,70
		'Use the Sonic Divebomb ability on your new hotbar to land. |outvehicle
		|only if havequest(31111) or havequest(31508) or havequest(31506) or havequest(31111) or havequest(31510)
	step
		'As you complete quests in this area:
		.click Dreadspore Bulbs##391
		.' Destroy 15 Dreadspore Bulbs |q 31509/1 |n
		|confirm
		|only if havequest(31509)
	step
		goto 31.5,69.6
		.from Kypari Crawler##65231+ |only if havequest(31508)
		.get 6 Kyparite Shards |q 31508/1 |only if havequest(31508)
		.from Thought-Bound Miner##64970+ |only if havequest(31506)
		.get 6 Zan'thik Shackles |q 31506/1 |only if havequest(31506)
		.kill 6 Zan'thik Impaler##64971+ |q 31111/1 |only if havequest(31111)
		.kill 6 Zan'thik Manipulator##64973+ |q 31111/2 |only if havequest(31111)
		|only if havequest(31506) or havequest(31111) or havequest(31508)
	step
		goto 33.4,61.0
		.from Kypa'rak##65229
		.collect 1 Massive Kyparite Core |n
		.'_
		.' Click the Massive Kyparite Core in your bags |use Massive Kyparite Core##87871
		..accept Kypa'rak's Core##31598
		|only if havequest(31111) or havequest(31508) or havequest(31506) or havequest(31111) or havequest(31510)
	step
		goto 29.1,74.7
		..kill Vess-Guard Vik'az##64979+ |q 31505/1
		|only if havequest(31505)
	step
		goto 23.0,77.3
		.kill 6 Zan'thik Amberhusk##64982+ |q 31507/1
		|only if havequest(31507)
	step
		'All around this area
		.click Dreadspore Bulbs##391
		.' Destroy 15 Dreadspore Bulbs |q 31509/1
		|only if havequest(31509)
	step
		goto 24.2,86.2
		.click Zan'thik Resonating Crystal##214455
		.kill Adjunct Sek'ot##64995 |q 31510/1
		|only if havequest(31510)
	step
		goto 50.8,41.3
		.clicknpc Kovok##63765
		.' Locate Kovok |q 31808/1
		|only if havequest(31808)
	step
		'Use the abilities on your hotbar to complete your task.
		.from Ik'thik Slayer, Ik'thik Kunchong, Ik'thik Warrior
		.' Kill 200 Mantid |q 31808/2
		|only if havequest(31808)
	step
		goto 55.0,35.4
		.talk Ambersmith Zikk##64599
		..turnin Kypa'rak's Core##31598
		..turnin The Matriarch's Maw##31599
		|only if havequest(31598) or havequest(31599)
	step
		goto 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..turnin Dreadspinner Extermination##31231
		..turnin Nope Nope Nope##31235
		..turnin Culling the Swarm##31109
		..turnin Mistblade Destruction##31267
		..turnin Eradicating the Zan'thik##31111
		..turnin Vess-Guard Duty##31505
		..turnin The Warlord's Ashes##31677
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		..turnin Dark Skies##31216
	step
		goto 54.8,36.2
		.talk Hisek the Swarmkeeper##63785
		..turnin Debugging the Terrace##31237
		..turnin Quiet Now##31510
		..turnin Infection##31272
		..turnin Ordnance Disposal##31504
	step
		goto 54.3,36.1
		.talk Korven the Prime##62180
		..turnin An Ancient Empire##31232
		..turnin Sap Tapping##31233
		..turnin Sampling the Empire's Finest##31496
		..turnin The Fight Against Fear##31270
		..turnin The Scale-Lord##31269
		..turnin Meltdown##31507
	step
		goto 54.3,35.9
		.talk Rik'kal the Dissector##65253
		..turnin Bad Genes##31271
		..turnin Wing Clip##31502
		..turnin Shortcut to Ruin##31503
		..turnin Putting An Eye Out##31234
		..turnin Specimen Request##31508
		..turnin Fear Takes Root##31509
	step
		goto 54.3,35.8
		.talk Kaz'tik the Manipulator##63758
		..turnin Brain Food##31238
		..turnin Sonic Disruption##31487
		..turnin Free From Her Clutches##31494
		..turnin A Little Brain Work##31268
		..turnin Kunchong Treats##31024
		..turnin Rampage Against the Machine##31808
		..turnin Shackles of Manipulation##31506
		|next |only if rep("The Klaxxi")>=Revered and not completedq(31465)
		|next "exalted" |only if rep("The Klaxxi")>=Exalted and not completedq(31612)
		|next end |only if default
	step
		goto 55.0,35.6
		.talk Ambersmith Zikk##64599
		..buy 1 Grand Commendation of the Klaxxi##92522 |n
		.' Use the Commendation of the Klaxxi you just purchased. |condition ZGV:GetReputation("The Klaxxi").hasBonus |use Grand Commendation of the Klaxxi##92522
		|only if rep("The Klaxxi")>=Revered
	step
		goto 55.1,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..accept Beneath The Heart Of Fear##31018
	step
		goto 29.0,42.4 |n
		.' Enter this tunnel |goto 29.0,42.4 <5 |noway |c
	step
		goto 30.7,40.3
		.kill Adjunct Ek'vem##62073+ |q 31018/1
	step
		goto 33.4,40.2
		.kill Adjunct Ikkess##62074+ |q 31018/2
	step
		goto 33.4,44.3
		.kill Adjunct Suruz##62075+ |q 31018/3
	step
		goto 30.7,44.4
		.kill Adjunct Tzikzi##62076+ |q 31018/4
	step
		goto 31.9,42.5
		.click Ancient Amber Chunk
		.' Wake Xaril the Poisoned Mind |q 31018/5
	step
		goto 29.0,42.4 |n
		.' Exit the tunnel here |goto 29.0,42.4 <5 |noway |c
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		..turnin Beneath The Heart Of Fear##31018
		..accept Venomous Intent##31208
		..accept Dark Wings, Dark Things##31209
		..accept A Shade of Dread##31210
	step
		goto 24.7,41.8
		.from Ruby Venomtail##63588+, Dread Scarab##63587+
		.get 150 Scarab Wing |q 31209/1
		.get 8 Venomous Stinger |q 31208/1
		.click Dreadshade##5031
		.get 8 Dreadshade |q 31210/1
		.' You can find more around [26.4,36.4]
		.' And here [26.2,30.8]
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		..turnin Venomous Intent##31208
		..turnin Dark Wings, Dark Things##31209
		..turnin A Shade of Dread##31210
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		..accept The Poisoned Mind##31211
	step
		goto 28.6,42.1
		.talk Xaril the Poisoned Mind##62151
		.' Tell him:
		.' <I am ready to fly, Xaril.> |invehicle |q 31211
	step
		'Use the _Venom Syrum_ to kill the small enemies.
		.' Use the _Paralyzing Syrum_ then immidiately the _Venom Syrum_ to kill the larger enemies.
		.' Speak to Xaril the Poisoned Mind |q 31211/1
		.kill 200 Mantid |q 31211/2
		.kill 3 Kunchong |q 31211/3
		'|from Krik'thik Wingguard##63613+, Ik'thik Warrior##63635+, Ik'thik Slayer##63636+ Dread Behemoth##65513+, Krik'thik Battletank##63625+,
	step
		goto 54.9,36.2
		.talk Xaril the Poisoned Mind##62151
		..turnin The Poisoned Mind##31211
	step
		goto 54.8,34.1
		.talk Kor'ik##64815
		..accept Dropping Our Signal##31439
	step
		goto 56.3,58.2
		.' Use your Tuning Fork on the Amber Rock |use Klaxxi Tuning Fork##87202
		.' Awaken Hisek the Swarmkeeper |q 31439/1
	step
		goto 56.3,58.2
		.talk Hisek the Swarmkeeper##64672
		..turnin Dropping Our Signal##31439
		..accept Corruption Runs Deep##31441
	step
		goto 56.2,57.6
		.kill Kor'ik##64583+ |q 31441/1
	step
		goto 56.3,57.6
		.talk Hisek the Swarmkeeper##64705
		..turnin Corruption Runs Deep##31441
		..accept Damage Control##31458
		..accept Extracting Answers##31465
	step
		goto 55.6,47.1
		.click Kypari Ik Beacon##11971
		.' Deactivate Kypari Ik Resonating Crystal |q 31458/2
	step
		goto 50.5,45.8
		.kill 5 Ik'thik Whisperer##64622+ |q 31458/1
		.from Ik'thik Swarmborn##64831+
		.get 6 Venom-Coated Mandible |q 31465/1
	step
		goto 54.8,36.2
		.talk Hisek the Swarmkeeper##63785
		..turnin Damage Control##31458
		..turnin Extracting Answers##31465
		|next |only if rep("The Klaxxi")>=Exalted and not completedq(31612)
		|next klaxxi start
	step
	label "exalted"
		goto 40.4,34.4
		.talk Malik the Unscathed##66776
		.' Report to Malik the Unscathed |q 31959/1
	step
		.' Click the Auto complete quest box that appears below your minimap:
		..turnin The Empress' Gambit##31959
		..accept The Wrath of Shek'zeer##31609
	step
		.' While you are completing this quest, you will need to assist your Mantid Swarm in defeating 25 Mantid Subjugates.
		|confirm
		|modelnpc 66789
		|modelnpc 66788
		|modelnpc 66790
	step
		goto 44.6,35.2
		.kill Akkolon##66783 |q 31609/1
		|tip You will have Paragons waiting in thie area to help you. If Akkolon is not in this location, you will have to wait to allow him to respawn.
	step
		goto 41.6,39.8
		.kill Shox'tik##66784 |q 31609/2
		|tip You will have Paragons waiting in thie area to help you. If Shox'tik is not in this location, you will have to wait to allow him to respawn.
	step
		goto 43.8,29.6
		.kill Manifestation of Terror##66785 |q 31609/3
		|tip You will have Paragons waiting in thie area to help you. If the Manifestation of Terror is not in this location, you will have to wait to allow it to respawn.
	step
		goto 43.4,33.0
		.kill 25 Mantid Subjugates |q 31609/4
	step
		goto 55.0,35.9
		.talk Kil'ruk the Wind-Reaver##62538
		..turnin The Wrath of Shek'zeer##31609
		..accept Shadow of the Empire##31612
	step
		.' Follow Kil'ruk the Wind-Rever into the chamber
		.' Walk with Kil'ruk |q 31612/1
	step
		goto Dread Wastes 55.1,35.9
		.talk Kil'ruk the Wind-Reaver##66800
		..turnin Shadow of the Empire##31612
		|next end
	step
	label end
		'This is the end of this guide.
		.' Click here to return to the beginning of the dailies |confirm |next "klaxxi start"
]])

ZygorGuidesViewer:RegisterInclude("A_Tillers_PreQuest", [[
		goto Valley of the Four Winds 52.0,48.0
		.talk Farmer Yoon##58721
		..accept A Helping Hand##30252
	step
		goto 51.8,48.8
		.click Unbudging Rock
		.' Clear 8 Unbudging Rocks |q 30252/1
	step
		goto 52.8,47.9
		.talk Farmer Yoon##58646
		..turnin A Helping Hand##30252
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Learn and Grow I: Seeds##30535
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.' Tell him you're there to pick up seeds.
		.' Get a Packet of Green Cabbage Seeds |q 30535/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow I: Seeds##30535
		..accept Learn and Grow II: Tilling and Planting##30254
	step
		goto 52.0,48.3
		.clicknpc Untilled Soil##59985+
		.' Till 2 patches of Soil. |q 30254/1
		.' Use the EZ-Gro Green Cabbage Seeds in your bags on the Tilled Soil. |use EZ-Gro Green Cabbage Seeds##80302
		.' Plant seeds in 2 patches of Tilled Soil. |q 30254/2
		|modelnpc Tilled Soil##59990+
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow II: Tilling and Planting##30254
		..accept Learn and Grow III: Tending Crops##30255
	step
		goto 52.0,48.3
		.' Use the Rusty Watering Can on the Parched EZ-Gro Green Cabbage |use Rusty Watering Can##79104
		.' Water 2 parched Ez-Gro Green Cabbage |q 30255/1
		|modelnpc Parched EZ-Gro Green Cabbage##59987
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow III: Tending Crops##30255
		..accept Learn and Grow IV: Harvesting##30256
	step
		goto 52.0,48.3
		.clicknpc Ripe EZ-Gro Green Cabbage##59833
		.get 2 EZ-Gro Green Cabbage |q 30256/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow IV: Harvesting##30256
		..accept Learn and Grow V: Halfhill Market##30257
	step
		goto 52.8,48.0
		.click Dark Soil
		.get Marsh Lily |q 30257/1
	step
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow V: Halfhill Market##30257
		..accept Learn and Grow VI: Gina's Vote##31945
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.buy 1 Scallion Seeds##80591
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Scallion Seeds on the Tilled Soil |use Scallion Seeds##80591
		.' Plant Scallion Seeds |q 31945/1
		|modelnpc Tilled Soil##59990+
	step
	label info
		'Click here for information on Bursting Crops |next "bursting" |confirm
		'Click here for information on Parched Crops |next "parched" |confirm
		'Click here for information on Infested Crops |next "infested" |confirm
		'Click here for information on Wiggling Crops |next "wiggling" |confirm
		'Click here for information on Alluring Crops |next "alluring" |confirm
		'Click here for information on Smothered Crops |next "smothered" |confirm
		'Click here for information on Wild Crops |next "wild" |confirm
		'Click here for information on Runty Crops |next "runty" |confirm
		'Click here for information on Tangled Crops |next "tangled" |confirm
	step
	label bursting
		'Unless you got a Bursting Scallion immediately after planting your Scallions, you will have to wait a full day until you can pick your crops.
		.' Click here if you are ready to harvest your crops. |confirm
		.' Click here to start doing dailies. |next "dailies" |confirm
	step
		goto 52.0,48.4
		.clicknpc Bursting Scallions##63160
		.clicknpc Ripe Scallions##63165
		.' Harvest Ripe Scallions |q 31945/2
		.get 5 Scallion##74843 |q 31945/3
		|next "exit"
	step
	label runty
		goto 52.0,48.4
		.clicknpc Runty Scallions##63166
		.' Press your Space Bar and jump.
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label wiggling
		goto 52.0,48.4
		.clicknpc Wiggling Scallions##63169
		.from Voracious Virmen##60039
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label infested
		goto 52.2,48.3
		.click Vintage Bug Sprayer
		.collect Vintage Bug Sprayer##80513 |n
		.' Use your Vintage Bug Sprayer on the Infested Scallions |use Vintage Bug Sprayer##80513
		|modelnpc Infested Scallions##63162
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label alluring
		goto 52.2,48.3
		.clicknpc Alluring Scallions##63159
		.from Swooping Plainshawk##60072
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label wild
		goto 52.0,48.4
		.clicknpc Wild Scallions##63170
		.' Ride the Scallion |invehicle |c
	step
		'Spam the Flex ability on your new hotbar, when the plant tries to cast Vine Slam, interrupt it with your Gnaw ability.
		.' Build 50 stacks on Dominance. |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label tangled
		goto 52.0,48.4 |n
		.clicknpc Tangled Scallions##63168
		.' Run to [51.7,48.9]
		'|goto 51.7,48.9 <5 |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label parched
		goto 52.0,48.4
		.' Use the Rusty Watering Can on the Parched Scallions |use Rusty Watering Can##79104
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Parched Scallions##63163
	step
	label smothered
		goto 52.0,48.4
		.clicknpc Encroaching Weed##60185
		.' Ride the Weed |invehicle |c
	step
		'Spam the Pull ability on your new hotbar.
		.' Pull the Weed |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Smothered Scallions##63167
	step
	label exit
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow VI: Gina's Vote##31945
]])
ZygorGuidesViewer:RegisterInclude("A_Tillers_DailyQuest", [[
	step
		'Proceeding to the Tiller's Dailies  |next "dailies" |condition completedq(31945) |only if completedq(31945)
		'Proceeding to the Tiller's Prequests |next |condition not completedq(31945) |only if not completedq(31945)
	step
		goto Vale of Eternal Blossoms 87.1,60.9
		.talk Tang Ironhoe##64036
		..accept The Tillers##31372
	step
		goto Valley of the Four Winds 52.0,48.0
		.talk Farmer Yoon##58721
		..turnin The Tillers##31372
		..accept A Helping Hand##30252
	step
		goto 51.8,48.8
		.click Unbudging Rock
		.' Clear 8 Unbudging Rocks |q 30252/1
	step
		goto 52.8,47.9
		.talk Farmer Yoon##58646
		..turnin A Helping Hand##30252
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Learn and Grow I: Seeds##30535
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.' Tell him you're there to pick up seeds.
		.' Get a Packet of Green Cabbage Seeds |q 30535/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow I: Seeds##30535
		..accept Learn and Grow II: Tilling and Planting##30254
	step
		goto 52.0,48.3
		.clicknpc Untilled Soil##59985+
		.' Till 2 patches of Soil. |q 30254/1
		.' Use the EZ-Gro Green Cabbage Seeds in your bags on the Tilled Soil. |use EZ-Gro Green Cabbage Seeds##80302
		.' Plant seeds in 2 patches of Tilled Soil. |q 30254/2
		|modelnpc Tilled Soil##58563
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow II: Tilling and Planting##30254
		..accept Learn and Grow III: Tending Crops##30255
	step
		goto 52.0,48.3
		.' Use the Rusty Watering Can on the Parched EZ-Gro Green Cabbage |use Rusty Watering Can##79104
		.' Water 2 parched Ez-Gro Green Cabbage |q 30255/1
		|modelnpc Parched EZ-Gro Green Cabbage##59987
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow III: Tending Crops##30255
		..accept Learn and Grow IV: Harvesting##30256
	step
		goto 52.0,48.3
		.clicknpc Ripe EZ-Gro Green Cabbage##59833
		.get 2 EZ-Gro Green Cabbage |q 30256/1
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin Learn and Grow IV: Harvesting##30256
		..accept Learn and Grow V: Halfhill Market##30257
	step
		goto 52.8,48.0
		.click Dark Soil
		.get Marsh Lily |q 30257/1
	step
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow V: Halfhill Market##30257
		..accept Learn and Grow VI: Gina's Vote##31945
	step
		goto 52.9,52.2
		.talk Merchant Greenfield##58718
		.buy 1 Scallion Seeds##80591 |q 31945
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Scallion Seeds on the Tilled Soil |use Scallion Seeds##80591
		.' Plant Scallion Seeds |q 31945/1
		|modelnpc Tilled Soil##58563
	step
	label info
		'Click here for information on Bursting Crops |next "bursting" |confirm
		'Click here for information on Parched Crops |next "parched" |confirm
		'Click here for information on Infested Crops |next "infested" |confirm
		'Click here for information on Wiggling Crops |next "wiggling" |confirm
		'Click here for information on Alluring Crops |next "alluring" |confirm
		'Click here for information on Smothered Crops |next "smothered" |confirm
		'Click here for information on Wild Crops |next "wild" |confirm
		'Click here for information on Runty Crops |next "runty" |confirm
		'Click here for information on Tangled Crops |next "tangled" |confirm
	step
	label bursting
		'Unless you got a Bursting Scallion immediately after planting your Scallions, you will have to wait a full day until you can pick your crops.
		.' Click here if you are ready to harvest your crops. |confirm
		.' Click here to start doing dailies. |next "dailies" |confirm
	step
		goto 52.0,48.4
		.clicknpc Bursting Scallions##63160
		.clicknpc Ripe Scallions##63165
		.' Harvest Ripe Scallions |q 31945/2
		.get 5 Scallion##74843 |q 31945/3
		|next "exit"
	step
	label runty
		goto 52.0,48.4
		.clicknpc Runty Scallions##63166
		.' Press your Space Bar and jump.
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label wiggling
		goto 52.0,48.4
		.clicknpc Wiggling Scallions##63169
		.from Voracious Virmen##60039
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label infested
		goto 52.2,48.3
		.click Vintage Bug Sprayer
		.collect Vintage Bug Sprayer##80513 |n
		.' Use your Vintage Bug Sprayer on the Infested Scallions |use Vintage Bug Sprayer##80513
		|modelnpc Infested Scallions##63162
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label alluring
		goto 52.2,48.3
		.clicknpc Alluring Scallions##63159
		.from Swooping Plainshawk##60072
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label wild
		goto 52.0,48.4
		.clicknpc Wild Scallions##63170
		.' Ride the Scallion |invehicle |c
	step
		'Spam the Flex ability on your new hotbar, when the plant tries to cast Vine Slam, interrupt it with your Gnaw ability.
		.' Build 50 stacks on Dominance. |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label tangled
		goto 52.0,48.4 |n
		.clicknpc Tangled Scallions##63168
		.' Run to [51.7,48.9]
		'|goto 51.7,48.9 <5 |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
	step
	label parched
		goto 52.0,48.4
		.' Use the Rusty Watering Can on the Parched Scallions |use Rusty Watering Can##79104
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Parched Scallions##63163
	step
	label smothered
		goto 52.0,48.4
		.clicknpc Encroaching Weed##60185
		.' Ride the Weed |invehicle |c
	step
		'Spam the Pull ability on your new hotbar.
		.' Pull the Weed |outvehicle |c
	step
		.' Click here to return to the information page. |next "info" |confirm
		.' Click here when you are have tilled your crops. |next "bursting" |confirm
		|modelnpc Smothered Scallions##63167
	step
	label exit
		goto 53.1,51.8
		.talk Gina Mudclaw##58706
		..turnin Learn and Grow VI: Gina's Vote##31945
	step
	label dailies
		goto Valley of the Four Winds 51.9,48.3
		'Start each day out by harvesting the crops from the previous day.
		|confirm
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646 |tip He will only have 2 quests a day.
		..accept The Kunzen Hunter-Chief##30336 |or 2
		..accept That Dangling Carrot##31670 |or 2
		..accept Stealing is Bad... Re-Stealing is OK##30334 |or 2
		..accept The Cabbage Test##31669 |or 2
		..accept It's Melon Time##31942 |or 2
		..accept A Pumpkin-y Perfume##31672 |or 2
		..accept Stalling the Ravage##30335 |or 2
		..accept Red Blossom Leeks, You Make the Croc-in' World Go Down##31673 |or 2
		..accept Squash Those Foul Odors##31941 |or 2
		..accept The Lesser of Two Evils##30333 |or 2
		..accept The White Turnip Treatment##31675 |or 2
		..accept The Pink Turnip Challenge##31674 |or 2
		..accept Which Berries? Witchberries.##31943 |or 2
		..accept Why Not Scallions?##31671 |or 2
		..accept Simian Sabotage##30337 |or 2
		|only if not completedq(32682)
	step
		goto 53.0,51.8
		.talk Farmer Yoon##58646 |tip He will only have 1 quest a day.
		..accept The Kunzen Hunter-Chief##30336 |or
		..accept Stealing is Bad... Re-Stealing is OK##30334 |or
		..accept Stalling the Ravage##30335 |or
		..accept The Lesser of Two Evils##30333 |or
		..accept Simian Sabotage##30337 |or
		|only if completedq(32682)
	step
		goto 52.7,50.5
		.talk Andi##64464 |tip He will only have 1 quest a day.
		..accept A Gift For Fung##30475 |or
		..accept A Gift For Chee Chee##30471 |or
		..accept A Gift For Haohan##30477 |or
		..accept A Gift For Jogu##30478 |or
		..accept A Gift For Sho##30472 |or
		..accept A Gift For Tina##30470 |or
		..accept A Gift For Ella##30474 |or
		..accept A Gift For Old Hillpaw##30476 |or
		..accept A Gift For Fish##30473 |or
		..accept A Gift For Gina##30479 |or
	step
		goto 53.1,51.7
		.talk Ella##58647
		..accept You Have to Burn the Ropes##30327
		.'_
		.' Click here if Ella is not in town |confirm
	step
		goto 53.0,51.7
		.talk Haohan Mudclaw##57402
		..accept Pest Problems##30319
		.'_
		.' Click here if Haohan is not in town |confirm
	step
		goto 53.1,51.7
		.talk Tina Mudclaw##58761
		..accept They Don't Even Wear Them##30323
		.'_
		.' Click here if Tina is not in town |confirm
	step
		goto 53.1,52.1
		.talk Chee Chee##58709
		..accept Not in Chee-Chee's Backyard##30324
		.'_
		.' Click here if Chee-Chee is not in town |confirm
	step
		goto 52.8,51.8
		.talk Fish Fellreed##58705
		..accept The Kunzen Legend-Chief##30326
		.'_
		.' Click here if Fish Felreed is not in town |confirm
	step
		goto 52.9,51.7
		.talk Farmer Fung##57298
		..accept Water, Water Everywhere##30317
		.'_
		.' Click here if Farmer Fung is not in town |confirm
	step
		goto 53.1,52.1
		.talk Sho##58708
		..accept Where It Counts##30325
		.'_
		.' Click here if Sho is not in town |confirm
	step
		goto 53.6,52.5
		.talk Jogu the Drunk##58710
		..accept Weed War II##30321
		.'_
		.' Click here if Jogu has no available quests. |confirm
	step
		goto 53.0,51.8
		.talk Old Hillpaw##58707
		..accept Chasing the Chicken##30318
		.'_
		.' Click here if Old Hillpaw is not in town. |confirm
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		..accept Money Matters##30322
		.'_
		.' If this quest is unavailable click here. |confirm
	step
		goto 55.1,50.3
		.talk Innkeeper Lei Lan##59582
		.' Tell her you are here on behalf of Gina Mudclaw.
		.' Innkeeper Lei Lan's Payment |q 30322/3
		|only if havequest(30322)
	step
		goto 55.6,52.1
		.talk Lolo Lio##59585
		.' Tell him you are here on behalf of Gina Mudclaw.
		.' Lolo Lio's Payment |q 30322/4
		|only if havequest(30322)
	step
		goto 56.1,49.6
		.talk Trader Jambeezi##59583
		.' Tell him you are here on behalf of Gina Mudclaw.
		.' Trader Jambeezi's Payment |q 30322/2
		|only if havequest(30322)
	step
		goto 56.7,47.1
		.talk Spicemaster Jin Jao##59581
		.' Tell him you are here on behalf of Gina Mudclaw.
		.' Spicemaster Jin Jao's Payment |q 30322/1
		|only if havequest(30322)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Juicycrunch Carrot Seeds##80590
		|only if havequest(31670)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Green Cabbage Seeds##79102
		|only if havequest(31669)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Witchberry Seeds##89326
		|only if havequest(31943)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Scallion Seeds##80591
		|only if havequest(31671)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 White Turnip Seeds##80595
		|only if havequest(31675)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Pink Turnip Seeds##80594
		|only if havequest(31674)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Jade Squash Seeds##89328
		|only if havequest(31941)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Striped Melon Seeds##89329
		|only if havequest(31942)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Mogu Pumpkin Seeds##80592
		|only if havequest(31672)
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 1 Red Blossom Leek Seeds##80593
		|only if havequest(31673)
	step
		goto 56.5,50.4
		.talk Wing Nga##60231
		.' Tell her that you'd like to borrow one of Farmer Fung's kites.
		.' Ride a kite. |invehicle |c
		|only if havequest(30317)
	step
		.' Use your Water Buckest ability on the Dusty Spots below you. |tip They are outlined by a yellow circle.
		.' Water 35 Dusty Spots |q 30317/1
		|only if havequest(30317)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Scallion Seeds on the Tilled Soil |use Scallion Seeds##80591
		.' Plant Scallion Seeds |q 31671/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31671)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Juicycrunch Carrot Seed on the Tilled Soil |use Juicycrunch Carrot Seeds##80590
		.' Plant 1 Juicycrunch Carrot Seed |q 31670/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31670)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Witchberry Seeds on the Tilled Soil |use Witchberry Seeds##89326
		.' Plant Witchberry Seeds |q 31943/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31943)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Mogu Pumpkin Seeds on the Tilled Soil |use Mogu Pumpkin Seeds##80592
		.' Plant Mogu Pumpkin Seeds |q 31672/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31672)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Jade Squash Seeds on the Tilled Soil |use Jade Squash Seeds##89328
		.' Plant Jade Squash Seeds |q 31941/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31941)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your White Turnip Seeds on the Tilled Soil |use White Turnip Seeds##80595
		.' Plant White Turnip Seeds |q 31675/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31675)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Pink Turnip Seeds on the Tilled Soil |use Pink Turnip Seeds##80594
		.' Plant Pink Turnip Seeds |q 31674/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31674)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Green Cabbage Seeds on the Tilled Soil |use Green Cabbage Seeds##79102
		.' Plant Green Cabbage Seeds |q 31669/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31669)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Striped Melon Seeds on the Tilled Soil |use Striped Melon Seeds##89329
		.' Plant Striped Melon Seeds |q 31942/1
		|modelnpc Tilled Soil##58563+
		|only if havequest(31942)
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Red Blossom Leek Seeds on the Tilled Soil |use Red Blossom Leek Seeds##80593
		.' Plant Red Blossom Leek Seeds |q 31673/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31673)
	step
		goto 45.9,48.5
		.click Goldenfire Orchid##10921
		.get Goldenfire Orchid |q 30479/1
		.' You can also find this here: [41.6,42.8]
		.' or here: [37.5,37.3]
		|only if havequest(30479)
	step
		goto 42.4,50.0
		.talk Lost Dog##59533
		..accept Lost and Lonely##30526
		|only if repval('The Tillers','Revered')>=13000
	step
		goto 38.5,51.7
		.talk Gai Lan##57385
		.' Ask him, "What Weeds?"
		.' Get the Weed War buff. |havebuff Interface\Icons\INV_Misc_Herb_05
		|only if havequest(30321)
	step
		.clicknpc Ugly Weed##57306
		.clicknpc Nasty Weed##57308
		.click Weed-B-Gone Gas Bomb |tip Use the new button available to you to clear a lot of weeds at once
		.' Pull 100 Weeds |q 30321/1
		|only if havequest(30321)
	step
		goto 31.3,53.2
		.clicknpc Hillpaw's Chicken##58918 |tip Most of these chickens are disguised animals. When you pick one up click the button that appears on your screen.
		.' You can deliver lost hens to the chicken coop here [30.4,52.5]
		.get Old Hillpaw's Prize Chicken##80223 |q 30318/1
		|only if havequest(30318)
	step
		goto 37.4,37.3
		.from Monstrous Plainshawk##59641
		.collect 1 Bloody Plainshawk Leg##80232
		|only if havequest(30475)
	step
		goto 39.6,45.3
		.talk Wika-Wika##59532
		.' Mook-mooks?
		.' Get the Pest Problems buff. |havebuff Pest Problems
		|only if havequest(30319)
	step
		goto 39.6,45.3
		.clicknpc Black-Nose Marmot##59530
		.' Stomp 25 Black-Nose Marmot |q 30319/1
		|only if havequest(30319)
	step
		goto 30.2,46.0
		.from Teeku##59130, Jim-Jim##59128, Jokka-Jokka##59126, Kon-Kon##59127
		.' Kill the Kunzen-Hunter Chief. |q 30336/1
		|only if havequest(30336)
	step
		goto 29.2,38.2
		.from Skyrange Mushan##64309+
		.get 20 Tasty T-Bone |q 30526/1
		|only if havequest(30526)
	step
		goto 32.0,32.1
		.click Kunzen Rope
		.' Burn 6 ropes |q 30327/1
		|only if havequest(30327)
	step
		goto 29.7,34.5
		.click Yu-Ping Soup Cauldron
		.get Yu-Ping Soup##79870 |q 30472/1
		|only if havequest(30472)
	step
		goto 29.7,34.5
		.kill 1 Kunzen Ritualist##59123 |q 30325/3
		.click Blazing Ember##5746
		.' Kick 4 Blazing Ember |q 30325/2
		.click Kunzen Ritual Candle##11320
		.' Throw 8 Kunzen Ritual Candles |q 30325/1
		|only if havequest(30325)
	step
		goto 31.6,28.7
		.from Buk-Buk##59133+, Bimba##59135+, Yammo##59134+, Rit-Rit##59132+
		.get 1 Kunzen Legend-Book##79866 |q 30326/1
		|only if havequest(30326)
	step
		goto 33.6,23.9
		.click Authentic Valley Stir Fry
		.get Authentic Valley Stir Fry |q 30471/1
		|only if havequest(30471)
	step
		goto 34.0,24.1
		.click Yak Statuette
		.get Yak Statuette##79828 |q 30473/1
		|only if havequest(30473)
	step
		goto 32.7,30.6
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen tools exploded |q 30337/2
		|only if havequest(30337)
	step
		goto 30.4,28.1
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen weapons exploded |q 30337/1
		|only if havequest(30337)
	step
		goto 32.1,25.9
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen beer exploded |q 30337/3
		|only if havequest(30337)
	step
		goto 35.0,22.0
		'Use the Barrel of Fireworks in your bags. |use Barrel of Fireworks##79885
		.' Stolen grain exploded |q 30337/4
		|only if havequest(30337)
	step
		goto 34.2,23.5
		.from Kunzen Rockflinger##59120+, Kunzen Collector##59124+, Kunzen Ravager##59119+, Kunzen Hunter##59121+
		.' Kill 12 Kunzen hozen |q 30335/1
		|only if havequest(30335)
	step
		goto 34.2,23.5
		.click Stolen Vegetable |only if havequest(30334)
		.get 16 Stolen Vegetable##79824 |q 30334/1 |only if havequest(30334)
		.from Kunzen Rockflinger##59120+, Kunzen Collector##59124+, Kunzen Ravager##59119+ |only if havequest(30324) or havequest(30474)
		.' Kill 8 Kunzen tribe members. |q 30324/1 |only if havequest(30324)
		.get Spicy Shrimp Dumplings##79871 |q 30474/1 |only if havequest(30474)
	step
		goto 44.1,29.1
		.from Enormous Cattail Grouper##59639
		.get Enormous Cattail Grouper Tooth |q 30477/1
		|only if havequest(30477)
	step
		'Enter this warren. |goto 46.9,21.1 <5 |c
		|only if havequest(30333)
	step
		goto 48.7,18.7
		.kill Springtail Warren-Mother##59516 |q 30333/1
		|only if havequest(30333)
	step
		'Leave the warren. |goto 46.9,21.1 <5 |c
		|only if havequest(30333)
	step
		'Enter this warren. |goto 44.0,22.3 <5 |c
		|only if havequest(30470)
	step
		goto 44.7,19.6
		.from Springtail Littlewhisker##59515+, Springtail Trapper##59513+, Springtail Burrower##59514+
		.get Stolen Circlet##80138 |q 30323/1
		.get Ransacked Ring##80137 |q 30323/2
		.get Buglarized Bracelet##80139 |q 30323/3
		|only if havequest(30323)
	step
		'Leave the warren. |goto 44.0,22.3 <5 |c
		|only if havequest(30470)
	step
		'This item could be in either warren or the patch of land seperating the two entrances.
		.click Chrysoberyl Outcropping##7456
		.get Uncut Chrysoberyl |q 30470/1
		|only if havequest(30470)
	step
		goto 44.2,28.8
		.click Freshwater Oyster
		.get Blue Freshwater Pearl## |q 30476/1
		|only if havequest(30476)
	step
		goto 42.4,50.0
		.talk Lost Dog##59533
		..turnin Lost and Lonely##30526
		|only if havequest(30526)
	step
		goto 52.6,47.8
		.click Yoon's Apples
		.collect 8 Yoon's Apple##80234
		|only if havequest(30478)
	step
		goto 52.8,47.9
		.click Yoon's Craneberries
		.collect 50 Yoon's Craneberry##80235
		|only if havequest(30478)
	step
		goto 53.2,52.2
		.talk Bobo Ironpaw##58717
		.' Tell him you've got all this fruit here.
		.get Apple-Berry Hooch |q 30478/1
		|only if havequest(30478)
	step
		goto 53.0,51.3
		.talk Kol Ironpaw##58712
		.' Ask him if he could grill your plainshawk leg.
		.get Grilled Plainshawk Leg##80233 |q 30475/1
		|only if havequest(30475)
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin The Kunzen Hunter-Chief##30336
		..turnin That Dangling Carrot##31670
		..turnin Stealing is Bad... Re-Stealing is OK##30334
		..turnin The Cabbage Test##31669
		..turnin It's Melon Time##31942
		..turnin A Pumpkin-y Perfume##31672
		..turnin Stalling the Ravage##30335
		..turnin Red Blossom Leeks, You Make the Croc-in' World Go Down##31673
		..turnin Squash Those Foul Odors##31941
		..turnin The Lesser of Two Evils##30333
		..turnin The White Turnip Treatment##31675
		..turnin The Pink Turnip Challenge##31674
		..turnin Which Berries? Witchberries.##31943
		..turnin Why Not Scallions?##31671
		..turnin Simian Sabotage##30337
		|only if not completedq(32682)
	step
		goto 53.0,51.8
		.talk Farmer Yoon##58646 |tip He will only have 1 quest a day.
		..turnin The Kunzen Hunter-Chief##30336 |or
		..turnin Stealing is Bad... Re-Stealing is OK##30334 |or
		..turnin Stalling the Ravage##30335 |or
		..turnin The Lesser of Two Evils##30333 |or
		..turnin Simian Sabotage##30337 |or
		|only if completedq(32682)
	step
		goto 52.9,51.7
		.talk Farmer Fung##57298
		..turnin Water, Water Everywhere##30317
		..turnin A Gift For Fung##30475 |only if havequest(30475)
	step
		goto 52.8,51.8
		.talk Fish Fellreed##58705
		..turnin The Kunzen Legend-Chief##30326
		..turnin A Gift For Fish##30473 |only if havequest(30473)
	step
		goto  53.0,51.7
		.talk Ella##58647
		..turnin You Have to Burn the Ropes##30327
		..turnin A Gift For Ella##30474 |only if havequest(30474)
	step
		goto 53.1,52.1
		.talk Sho##58708
		..turnin Where It Counts##30325
		..turnin A Gift For Sho##30472 |only if havequest(30472)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		..turnin Money Matters##30322
		..turnin A Gift For Gina##30479 |only if havequest(30479)
	step
		goto 53.1,51.9
		.talk Old Hillpaw##58707
		..turnin Chasing the Chicken##30318
		..turnin A Gift For Old Hillpaw##30476 |only if havequest(30476)
	step
		goto 53.1,51.7
		.talk Tina Mudclaw##58761
		..turnin A Gift For Tina##30470 |only if havequest(30470)
		..turnin They Don't Even Wear Them##30323
	step
		goto 53.0,51.7
		.talk Haohan Mudclaw##57402
		..turnin Pest Problems##30319
		..turnin A Gift For Haohan##30477 |only if havequest(30477)
	step
		goto 53.6,52.5
		.talk Jogu the Drunk##58710
		..turnin Weed War II##30321
		..turnin A Gift For Jogu##30478 |only if havequest(30478)
	step
		goto 53.1,52.1
		.talk Chee Chee##58709
		..turnin Not in Chee-Chee's Backyard##30324
		..turnin A Gift For Chee Chee##30471 |only if havequest(30471)
		|next "honored" |only if rep('The Tillers')==Honored
		|next "revered" |only if rep('The Tillers')==Revered
		|next "exalted" |only if rep('The Tillers')==Exalted
		|next "end" |only if rep('The Tillers')<=Friendly
	step
	label honored
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Growing the Farm I: The Weeds##30260
	step
		goto 38.6,51.7
		.talk Gai Lan##57385
		..turnin Growing the Farm I: The Weeds##30260
		..accept Growing the Farm I: A Little Problem##30516
	step
		goto 36.5,51.1
		.click Spideroot
		.get 6 Spideroot |q 30516/1
	step
		goto 38.6,51.7
		.talk Gai Lan##57385
		..turnin Growing the Farm I: A Little Problem##30516
		|next "revered" |only if rep('The Tillers')>=Revered
		|next |only if default
	step
		goto 51.9,48.3
		'When you arrive at Sunsong Ranch you will get a buff. After 15 minutes your ranch will be expanded. |tip You cannot buy your farm upgrade until the expansion is done.
		|confirm
		|only if not completedq(31936)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		.buy 1 "Jinyu Princess" Irrigation System##89812 |q 31936
	step
		'Click the "Jinyu Princess" Irrigation System in your bags. |use "Jinyu Princess" Irrigation System##89812
		..accept The "Jinyu Princess" Irrigation System##31936
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin The "Jinyu Princess" Irrigation System##31936
		|next mungmung |only if repval('The Tillers','Honored')>=5600 and completedq(31936) and not completedq(31946)
		|next "end" |only if default
	step
	label revered
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		..buy 1 Grand Commendation of the Tillers##93226 |n
		.' Use the Commendation of the Tillers you just purchased. |condition ZGV:GetReputation("The Tillers").hasBonus |use Grand Commendation of the Tillers##93226
		|only if rep("The Tillers")>=Revered
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Growing the Farm II: The Broken Wagon##30523
		|next "fung" |only if repval('The Tillers','Revered')>=4200
		|next "mungmung" |only if completedq(31936) and not completedq(31946)
		|only if completedq(30516) and rep('The Tillers')>=Revered
	step
		goto 41.7,30.0
		.talk Fish Fellreed##58705
		..turnin Growing the Farm II: The Broken Wagon##30523
		..accept Growing the Farm II: Knock on Wood##30524
	step
		goto 42.8,29.1
		.click Boat Planks
		.get 100 Waxed Plank##80136 |q 30524/1
	step
		goto 41.7,30.0
		.talk Fish Fellreed##58705
		..turnin Growing the Farm II: Knock on Wood##30524
	step
		goto 51.9,48.3
		'When you arrive at Sunsong Ranch you will get a buff. After 15 minutes your ranch will be expanded. |tip You cannot buy your farm upgrade until the expansion is done.
		|confirm
		|only if not completedq(31937)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		.buy 1 "Thunder King" Pest Repellers##89813 |q 31937
	step
		'Click the "Thunder King" Pest Repellers in your bags. |use "Thunder King" Pest Repellers##89813
		..accept "Thunder King" Pest Repellers##31937
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin "Thunder King" Pest Repellers##31937
		|next "end"
	step
	label mungmung
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Mung-Mung's Vote I: A Hozen's Problem##30258
		|next "fung" |only if completedq(31946)
	step
		goto 44.2,34.3
		.talk Mung-Mung##57401
		..turnin Mung-Mung's Vote I: A Hozen's Problem##30258
		..accept Mung-Mung's Vote II: Rotten to the Core##30259
	step
		goto 42.7,38.2
		.click Partially Chewed Carrot
		.get 10 Partially Chewed Carrot##80116 |q 30259/1
	step
		goto 44.2,34.3
		.talk Mung-Mung##57401
		..turnin Mung-Mung's Vote II: Rotten to the Core##30259
		..accept Mung-Mung's Vote III: The Great Carrot Caper##31946
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 2 Juicycrunch Carrot Seeds##80590 |q 31946
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Juicycrunch Carrot Seeds on the Tilled Soil |use Juicycrunch Carrot Seeds##80590
		.' Plant 2 Juicycrunch Carrot Seeds |q 31946/1
		|modelnpc Tilled Soil##58563
	step
		'Wait a day for the carrots to grow and then harvest them.
		.' Harvest 2 Ripe Juicycrunch Carrots |q 31946/2
		.get 10 Juicycrunch Carrot##74841 |q 31946/3
	step
		goto 44.2,34.3
		.talk Mung-Mung##57401
		..turnin Mung-Mung's Vote III: The Great Carrot Caper##31946
		|next "end"
	step
	label fung
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..accept Farmer Fung's Vote I: Yak Attack##30517
		|next "nana" |only if repval('The Tillers','Revered')>=8400
		.' Click here if this quest is not available yet |confirm |next end
	step
		goto 48.3,33.9
		.talk Farmer Fung##57298
		..turnin Farmer Fung's Vote I: Yak Attack##30517
		..accept Farmer Fung's Vote II: On the Loose##30518
	step
		goto 51.0,36.7
		.clicknpc Escaped Shagskin##59491
		.' Ride 5 Escaped Shagskin to [50.4,34.7] |q 30518/1
	step
		goto 48.3,33.9
		.talk Farmer Fung##57298
		..turnin Farmer Fung's Vote II: On the Loose##30518
		..accept Farmer Fung's Vote III: Crazy For Cabbage##31947
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 3 Green Cabbage Seeds##79102 |q 31947
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Green Cabbage Seeds on the Tilled Soil |use Green Cabbage Seeds##79102
		.' Plant 3 Green Cabbage Seeds |q 31947/1
		|modelnpc Tilled Soil##58563
	step
		'Wait a day for the Green Cabbage to grow and then harvest them.
		.' Harvest 3 Green Cabbage |q 31947/2
		.get 15 Green Cabbage##74840 |q 31947/3
	step
		goto 48.3,33.9
		.talk Farmer Fung##57298
		..turnin Farmer Fung's Vote III: Crazy For Cabbage##31947
	step
	label nana
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..accept Nana's Vote I: Nana's Secret Recipe##30519
		|next "haohan" |only if repval('The Tillers','Revered')>=16800
		.' Click here if this quest is not available yet |confirm |next end
	step
		goto 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Nana's Vote I: Nana's Secret Recipe##30519
		..accept Nana's Vote II: The Sacred Springs##31948
	step
		goto 56.7,21.7
		.from Thousand-Year Guardian##66850+
		.' You may have to kill the Guardian first, then collect the water
		'Use the Empty Pitcher while standing under the waterfall. |use Empty Pitcher##89902
		.' Thousand-Year Water |q 31948/1
	step
		goto 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Nana's Vote II: The Sacred Springs##31948
		..accept Nana's Vote III: Witchberry Julep##31949
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 3 Witchberry Seeds##89326 |q 31949
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Witchberry Seeds on the Tilled Soil |use Witchberry Seeds##89326
		.' Plant 3 Witchberry Seeds |q 31949/1
		|modelnpc Tilled Soil##58563
		|only if havequest(31949)
	step
		'Wait a day for the Witchberries to grow and then harvest them.
		.' Harvest 3 Witchberries |q 31949/2
		.get 15 Witchberries##74846 |q 31949/3
	step
		goto 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Nana's Vote III: Witchberry Julep##31949
	step
	label haohan
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..accept Haohan's Vote I: Bungalow Break-In##30521
		.' Click here if this quest is not available yet |confirm |next end
	step
		goto 44.6,34.1
		.talk Haohan Mudclaw##57402
		..turnin Haohan's Vote I: Bungalow Break-In##30521
		..accept Haohan's Vote II: The Real Culprits##30522
	step
		goto 39.4,43.6
		.clicknpc Muddy Tracks##52171
		.' Investigate 8 Suspicious Footprints. |q 30522/1 |tip When you click the eighth footprint a hozen will attack you.
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote II: The Real Culprits##30522
		..accept Haohan's Vote III: Pure Poison##30525
	step
		'Enter this warren |goto 47.0,20.9 <5 |c
	step
		.click Cave Lily
		.get Cave Lily##80141 |q 30525/2
	step
		'Leave this warren |goto 47.0,20.9 <5 |c
	step
		'Enter this warren |goto 44.0,22.2 <5 |c
	step
		.click Bloodbloom##2313
		.get Bloodbloom##80140 |q 30525/1
	step
		'Leave this warren |goto 44.0,22.2 <5 |c
	step
		goto 42.5,22.3
		.click Violet Lichen##2314
		.get Violet Lichen |q 30525/4
	step
		'Enter this warren |goto 39.4,20.4 <5 |c
	step
		.click Ghostcap##9844
		.get Ghostcap##80142 |q 30525/3
	step
		'Leave this warren |goto 39.4,20.4 <5 |c
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote III: Pure Poison##30525
		..accept Haohan's Vote IV: Melons For Felons##30527
	step
		goto 52.9,52.1
		.talk Merchant Greenfield##58718
		.buy 4 Striped Melon Seeds##89329 |q 30527
	step
		goto 52.0,48.4
		.clicknpc Untilled Soil##58562
		.' Use your Striped Melon Seeds on the Tilled Soil |use Striped Melon Seeds##89329
		.' Plant 4 Striped Melon Seeds |q 30527/1
		|modelnpc Tilled Soil##58563
	step
		'Wait a day for the Striped Melons to grow and then harvest them.
		.' Harvest 4 Striped Melons |q 30527/2
		.get 20 Striped Melon##74848 |q 30527/3
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote IV: Melons For Felons##30527
		..accept Haohan's Vote V: Chief Yip-Yip##30528 //20000 Revered?
	step
		'Enter the cave here |goto 33.1,20.2 <5 |c
	step
		goto 32.4,20.6
		.kill Chief Yip-Yip##59567 |q 30528/1
		'Use the _Throw Melon_ button on your screen when he begins casting _Charging Up_. This will cause him to stop attacking and take increased damage for a few seconds.
	step
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..turnin Haohan's Vote V: Chief Yip-Yip##30528
	step
		goto 52.0,49.0
		'After some talking, the Offering Bowl should light up for you to click.
		.click Offering Bowl
		|confirm
		|next "end"
	step
	label exalted
		goto 52.2,48.8
		.talk Farmer Yoon##58646
		..accept Growing the Farm III: The Mossy Boulder##30529
		.' Click here if this quest is not available yet |confirm |next end
		|next |only if default
	step
		goto 44.6,34.1
		.talk Haohan Mudclaw##57402
		..turnin Growing the Farm III: The Mossy Boulder##30529
	step
		goto 51.9,48.3
		'When you arrive at Sunsong Ranch you will get a buff. After 15 minutes your ranch will be expanded. |tip You cannot buy your farm upgrade until the expansion is done.
		|confirm
		|only if not completedq(31938)
	step
		goto 53.2,51.8
		.talk Gina Mudclaw##58706
		.buy 1 "Earth-Slasher" Master Plow##89814 |q 31938
	step
		'Click the "Earth-Slasher" Master Plow in your bags. |use "Earth-Slasher" Master Plow##89814
		..accept The "Earth-Slasher" Master Plow##31938
	step
		goto 52.3,48.8
		.talk Farmer Yoon##58646
		..turnin The "Earth-Slasher" Master Plow##31938
	step
		goto Valley of the Four Winds 54.7,47.0
		.talk Nana Mudclaw##64597
		..accept Inherit the Earth##32682
		|only if rep('The Tillers')==Exalted and not completedq(32682)
	step
		goto Valley of the Four Winds 52.2,48.8
		.talk Farmer Yoon##58646
		.' Ask him if he will join the council of the Tillers Union. |q 32682/1
		|only if rep('The Tillers')==Exalted and not completedq(32682)
	step
		goto Valley of the Four Winds 54.7,47.0
		.talk Nana Mudclaw##64597
		..turnin Inherit the Earth##32682 |tip This quest opens up the farm to you, granting you a place to rest and set your hearthstone, as well as opening up new quests known as work orders that allow you to gain reputation with other factions through farming.
		|only if rep('The Tillers')==Exalted and not completedq(32682)
	step
		goto 52.0,49.0
		.click Tillers Shrine##11506
		..accept A Second Hand##30534
	step
		'For this quest you must be _Best Friends_ with one of the 10 Tiller NPCs. Please refer to the Reputations guides for assistance in gaining rep for an individual.
		|confirm
	step
		'Go to your _Best Friend's_ home.
		.' Ask them: <Friend>, how'd you like to help us run the farm? |q 30534/1
	step
		goto 52.0,49.0
		.click Tillers Shrine##11506
		..turnin A Second Hand##30534
	step
	label end
		'The last thing to do with The Tillers each day is to plant as many crops as your farm can hold. Each crop harvest will award reputation so do this every day.
		.' Click here to go back to the beginning of the dailies section. |next "dailies" |confirm
]])

ZygorGuidesViewer:RegisterInclude("A_Cloud_Serpent_Pre", [[
		goto Vale of Eternal Blossoms 85.8,62.3
		.talk Instructor Windspear##64484
		..accept The Order of the Cloud Serpent##31373
	step
		goto The Jade Forest 57.8,45.0
		.talk Instructor Skythorn##58228
		..turnin The Order of the Cloud Serpent##31373
	step
		goto 57.7,45.0
		.talk Elder Anli##58564
		..accept Wild Things##30134
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225
		..turnin Wild Things##30134
		..accept Beating the Odds##30135
		..accept Empty Nests##30136
		..accept Egg Collection##30137
	step
		goto 64.4,31.1
		.' Use the Silken Rope in your bags on Windward Hatchlings |use Silken Rope##78947
		.' Get 6 Hatchlings and bring them to [65.8,31.2]
		.' Return 6 Windward Hatchlings to their nests. |q 30136/1
	step
		goto 68.1,31.2
		.from Slitherscale Ripper##58212+, Slitherscale Eggdrinker##63532+
		.' Kill 8 Slitherscale saurok. |q 30135/1
		.click Serpent Egg
		.get 6 Serpent Egg##78959 |q 30137/1
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225
		..turnin Beating the Odds##30135
		..turnin Empty Nests##30136
		..turnin Egg Collection##30137
		..accept Choosing the One##30138
		..turnin Choosing the One##30138
	step
		goto 65.3,31.7
		.talk Instructor Tong##58225 |tip You will only accept one of the following quests.
		..accept The Rider's Journey##30139 |or
		..accept The Rider's Journey##30140 |or
		..accept The Rider's Journey##30141 |or
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228 |tip You will only turn in one of the following quests.
		..turnin The Rider's Journey##30139
		..turnin The Rider's Journey##30140
		..turnin The Rider's Journey##30141
		..accept It's A...##30142
	step
		.' Watch the scene and see your egg hatch.
		.' Egg Hatched. |q 30142/1
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228
		..turnin It's A...##30142
]])

ZygorGuidesViewer:RegisterInclude("A_Cloud_Serpent", [[
	step
	label	start
		'Proceeding to Order of the Cloud Serpent Dailies |condition completedq(30142) |next "dailies" |only if completedq(30142)
		'Moving to the Order of the Cloud Serpent prequests. |next |condition not completedq(30142) |only if not completedq(30142)
	step
		#include "A_Cloud_Serpent_Pre"
	step
	label dailies
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		..accept Catch!##30151 |or 2
		..accept Pooped##31704 |or 2
		..accept Feeding Time##30156 |or 2
		..accept The Easiest Way To A Serpent's Heart##30154 |or 2
		..accept Sweet as Honey##30150 |or 2
		|noquest
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if not completedq(30143)
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		..accept Catch!##30151 |or 2
		..accept Pooped##31704 |or 2
		..accept Pooped##31716 |or 2
		..accept Feeding Time##30156 |or 2
		..accept The Easiest Way To A Serpent's Heart##30154 |or 2
		..accept Sweet as Honey##30150 |or 2
		|noquest
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if completedq(30143)
	step
		goto 57.6,45.1
		.talk Instructor Skythorn##58228
		..accept Restoring the Balance##30155 |or 2
		..accept Disarming the Enemy##30158 |or 2
		..accept Thinning The Pack##31698 |or 2
		..accept Weeping Widows##31706 |or 2
		..accept A Tangled Web##31707 |or 2
		..accept Monkey Mischief##31712 |or 2
		|noquest
	step
		goto 57.5,44.7
		.talk Jenova Longeye##58413
		..accept Just a Flesh Wound##30148 |only if skill("First Aid")>=525
		..accept A Feast for the Senses##30149 |only if skill("Cooking")>=525
		..accept Fragments of the Past##30147 |only if skill("Archaeology")>=525
		..accept Snack Time##30146 |only if skill("Fishing")>=1
		|tip NOTE: You will be able to accept Fragments of the Past at any level Archaeology, but won't be able to do the quest unless your skill in Archaeology is 525 or more.
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..accept Slitherscale Suppression##31194 |or 2
		..accept Madcap Mayhem##31703 |or 2
		..accept Dark Huntress##31701 |or 2
		..accept On The Prowl##31702 |or 2
		..accept The Seed of Doubt##31711 |or 2
		..accept The Trainer's Challenge: Qua-Ro Whitebrow##31721 |or 2
		..accept The Trainer's Challenge: Ace Longpaw##31717 |or 2
		..accept The Trainer's Challenge: Suchi the Sweet##31720 |or 2
		..accept The Trainer's Challenge: Big Bao##31718 |or 2
		..accept The Big Kah-Oona##31715 |or 2
		|noquest
	step
		goto 58.3,45.0
		.talk Ningna Darkwheel##58509
		..accept Sprite Fright##31699 |or
		..accept The Shoe Is On The Other Foot##31700 |or
		|noquest
	step
		goto 58.5,44.7
		.talk Suchi the Sweet##58510
		..accept Preservation##30159 |or
		..accept Emptier Nests##30157 |or
		|noquest
	step
		goto 57.5,44.0
		.talk Big Bao##58508
		..accept Lingering Doubt##31709
		|noquest
	step
		goto 57.3,43.5
		.talk Qua-Ro Whitebrow##58511
		..accept Serpent's Scale##31708
		..accept Saving the Serpents##31714
		|noquest
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..accept The Sky Race##30152
		|noquest
	step
		goto 58.0,43.7
		.talk Ace Longpaw##58506
		..accept The Big Brew-haha##31713
		|noquest
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		.' Tell her you are ready to start the Sky Race.
		.' Ride your Dragon! |invehicle
		|only if havequest(30152)
	step
		path	60.6,39.4	59.7,31.5	61.3,25.2
		path	66.3,36.0	66.2,42.4	66.8,51.4
		path	64.0,51.0	60.4,52.9	61.8,54.5
		path	58.7,46.8	58.4,46.4	58.1,46.0
		'Follow this path and collect the checked flags hanging off of the Checkpoint balloons. As you fly, gain speed by flying through cloud rings
		.' Pass 10 Checkpoints. |q 30152/1
		.' Pass underneath the Finish Line |q 30152/2
		|only if havequest(30152)
	step
		goto 57.3,43.5
		.talk Qua-Ro Whitebrow##58511
		.' Challenge him to a duel!
		.' Defeat Qua-Ro Whitebrow |q 31721/1
		|only if havequest(31721)
	step
		goto 58.0,43.7
		.talk Ace Longpaw##58506
		.' Challenge him to a duel!
		.' Defeat Ace Longpaw |q 31717/1
		|only if havequest(31717)
	step
		goto 57.5,44.0
		.talk Big Bao##58508
		.' Challnge him to a duel!
		.' Defeat Big Bao |q 31718/1
		|only if havequest(31718)
	step
		goto 58.5,44.7
		.talk Suchi the Sweet##58510
		.' Challenge her to a duel!
		.' Defeat Suchi the Sweet |q 31720/1
		|only if havequest(31720)
	step
		goto 69.8,31.3
		.kill Slitherscale Lizard-Lord##63536 |q 31194/1
		|only if havequest(31194)
	step
		goto 68.1,31.2 |only if havequest(30155) or havequest(30158)
		.from Slitherscale Ripper##58212+, Slitherscale Eggdrinker##63532+ |only if havequest(30155)
		.' Kill 8 Slitherscale saurok |q 30155/1 |only if havequest(30155)
		.click Slitherscale Weapons |only if havequest(30158)
		.get 5 Slitherscale Harpoon##79025 |q 30158/1 |only if havequest(30158)
		.click Serpent Egg |only if havequest(30159)
		.get 8 Serpent Eggs |q 30159/1 |only if havequest(30159)
	step
		goto 64.6,33.3
		.from Saltback Turtle##58218+, Saltback Yearling##58219+
		.collect 15 Saltback Meat Scrap##79028 |n
		.' Use the meat scraps to make a Saltback meat |use Saltback Meat Scrap##79028
		.collect 3 Saltback Meat##79027 |n
		.' Use the meat to feed your Hatchling |use Saltback Meat##79027 |q 30156/1
	step
		goto 57.2,45.2
		.' Use the Bouncy Ball in your bags. |use Bouncy Ball##79043
		.' Catch the Bouncy Ball whenever your Hatchling tosses it up, this will be every second throw.
		.' Catch the Ball 8 times. |q 30151/1
		|only if havequest(30151)
	step
		goto 55.1,46.5
		.click Hatchling Poop##9572 |tip It is all around this area.
		.get 5 Tiny Bags of Poop |q 31704/1
		|only if havequest(31704)
	step
		goto 55.1,46.5
		.click Hatchling Poop##9572 |tip It is all around this area.
		.get 5 Big Bags of Poop |q 31716/1
		|only if havequest(31716)
	step
		goto 57.5,45.4
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Pooped##31704
		|only if havequest(31704)
	step
		goto 57.5,45.4
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Pooped##31716
		|only if havequest(31716)
	step
		goto 62.7,27.4
		.kill Shadowfae Madcap##65613 |q 31703/1
		|only if havequest(31703)
	step
		goto 64.7,25.7
		.kill Windward Huntress##63538 |q 31701/1
		|only if havequest(31701)
	step
		goto 63.8,22.3
		.kill Windward Saber## |q 31702/1
		|only if havequest(31702)
	step
		goto 62.8,24.7
		.from Windward Tiger##63537 |only if havequest(30154)
		.get 5 Tiger Flank##85282 |q 30154/1 |only if havequest(30154)
		.kill 7 Shadowfae Trickster |q 31699/1 |only if havequest(31699)
		.from Windward Alpha+, Windward Tiger##63537+ |only if havequest(31698)
		.' Kill 8 Windward Tigers. |q 31698/1 |only if havequest(31698)
		.click Stolen Boots |only if havequest(31700)
		.get 14 Stolen Boots##89054 |q 31700/1 |only if havequest(31700)
	step
		'Enter the cave here. |goto 58.0,31.7 <5 |c
		|only if havequest(31708) or havequest(31710) or havequest(31706) or havequest(31711) or havequest(31709) or havequest(31707)
	step
		goto The Jade Forest/15 62.7,25.7
		.' Use the Sha Attunement Device next to this Disturbance |use Sha Attunement Device##88966
		.' Measure the Northeastern Sha Disturbance |q 31709/2
		|only if havequest(31709)
	step
		goto The Jade Forest/15 37.0,31.9
		.' Use the Sha Attunement Device next to this Disturbance |use Sha Attunement Device##88966
		.' Measure the Northwestern Sha Disturbance |q 31709/1
		|only if havequest(31709)
	step
		goto The Jade Forest/15 35.7,40.2
		.kill Seed of Doubt |q 31711/1
		|only if havequest(31711)
	step
		 goto The Jade Forest/15 61.0,74.1
		.' Use the Sha Attunement Device next to this Disturbance |use Sha Attunement Device##88966
		.' Measure the Southern Sha Disturbance |q 31709/3
		|only if havequest(31709)
	step
		.' Kill Widowspawn |only if havequest(31710)
		.get 100 Tiny Spider Eye's |q 31710/1 |only if havequest(31710)
		.kill 7 Weeping Widow |q 31706/1 |only if havequest(31706)
		.click Serpent's Scale |only if havequest(31708)
		.get 25 Serpent's Scale##88895 |q 31708/1 |only if havequest(31708)
		.from Widow's Web##65634+ |only if havequest(31707)
		.' Free 5 Sri-La Villagers |q 31707/1 |only if havequest(31707)
	step
		'Leave the cave. |goto The Jade Forest/15 75.8,19.0 |c
		|only if havequest(31708) or havequest(31710) or havequest(31706) or havequest(31711) or havequest(31709) or havequest(31707)
	step
		goto The Jade Forest/16 45.8,77.8
		.kill 1 Lord Oona##65628 |q 31715/1
		|only if havequest(31715)
	step
		goto The Jade Forest/0 55.2,28.4
		.click Serpent
		.collect 10 Rescued Serpent##88894 |q 31714/1
		|only if havequest(31714)
	step
		goto 55.2,28.4
		.from Oona Brewchugger##65624
		.click Stolen Sri-La Keg
		.' Collect 100 Sri-La Stout |q 31713/1
		|modeldisplay 11025
		|only if havequest(31713)
	step
		goto 55.2,28.0
		.from Oona Goon##65621+, Oona Brewchugger##65624+, Oona Tuna-Catcher##65623+
		.' Kill 13 Oona hozen |q 31712/1
		|only if havequest(31712)
	step
		goto The Jade Forest 64.5,31.1
		.' Use your Silken Rope on _Windward Hatchlings_. |use Silken Rope##78947
		.' Bring the Windward Hatchlings to the nest at [63.4,31.4].
		.' Return 6 Windward Hatchlings |q 30157/1
		|modelnpc 58243
		|modelnpc 58220
		|modelnpc 58244
		|only if havequest(30157)
	step
		'Use your First Aid skill to create 8 _Windwool Bandages_ or _Heavy Windwool Bandages_.
		'You can also ask other players to sell you some bandages.
		.create 8 Heavy Windwool Bandage##102698,First Aid,8 total |only if skill("First Aid")>=550 and skill("First Aid")<600
		--.collect 8 Windwool Bandage##72985 |or
		.' or
		.create 8 Heavy Windwool Bandage##102699,First Aid,8 total  |only if skill("First Aid")>=600
		--.collect 8 Heavy Windwool Bandage##72986 |or
		|only if havequest(30148)
	step
		goto 63.9,31.1
		.' Use your Windwool Bandages on Injured Hatchlings |use Windwool Bandage##72985
		.' Heavy Windwool Bandages work, too. |use Heavy Windwool Bandage##72986
		.' Bandage 8 Injured Hatchlings |q 30148/1
		|modelnpc Injured Hatchling##58416
		|only if havequest(30148)
	step
		goto 57.0,43.0
		.' Equip your Fishing Pole |use Fishing Pole##6256
		.' Use your Fishing skill to fish in the water here |cast Fishing##7620 |tip You will have to fish from Pools if you have low Fishing Skill.
		.get 10 Sugar Minnow##79046 |q 30146/1 |only if havequest(30146)
		.collect 10 Golden Carp##74866 |only if havequest(30149)
		|only if havequest(30146) or havequest(30149)
	step
		'Use your Cooking skill to create 5 Fish Cakes.
		.create 5 Fish Cake##104297,Cooking,5 total |q 30149/1 |or
		.buy 5 Fish Cake##74641 |or
		'You can ask other players to sell you some, if they happen to have leftovers.
		|only if havequest(30149)
	step
		goto The Jade Forest 55.1,47.2
		.from Honeykeeper##58363+
		.get 30 Honeycomb##79030 |q 30150/1
		|only if havequest(30150)
	step
		goto 58.0,43.7
		.talk Ace Longpaw##58506
		..turnin The Big Brew-haha##31713
		|only if havequest(31713)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564 |tip You will only have a couple of these quests.
		..turnin Slitherscale Suppression##31194
		..turnin Dark Huntress##31701
		..turnin On The Prowl##31702
		..turnin Restoring the Balance##30155
		..turnin Disarming the Enemy##30158
		..turnin Madcap Mayhem##31703
		..turnin The Easiest Way To A Serpent's Heart##30154
		..turnin Sprite Fright##31699
		..turnin Thinning The Pack##31698
		..turnin The Shoe Is On The Other Foot##31700
		..turnin Weeping Widows##31706
		..turnin The Seed of Doubt##31711
		..turnin A Tangled Web##31707
		..turnin The Sky Race##30152
		..turnin The Trainer's Challenge: Qua-Ro Whitebrow##31721
		..turnin The Trainer's Challenge: Ace Longpaw##31717
		..turnin The Trainer's Challenge: Suchi the Sweet##31720
		..turnin The Trainer's Challenge: Big Bao##31718
		..turnin Preservation##30159
		..turnin Lingering Doubt##31709
		..turnin Emptier Nests##30157
		..turnin Monkey Mischief##31712
		..turnin The Big Kah-Oona##31715
		..turnin Saving the Serpents##31714
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Tiny Treats##31710
		|only if havequest(31710)
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if not completedq(30143)
	step
		goto 57.5,45.3
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		|only if completedq(30143)
	step
		'Open your world map, find dig sites in Pandaria, then go to them |tip They look like small shovel icons on your world map that spawn in random places.  Once you get to the zone where the dig site is located, you will see the dig site on your map as a red highlighted area.
		.' Use your Survey ability inside the dig site area |cast Survey##80451
		.' A telescope will appear, follow the direction it points in and continue using your Survey ability to eventually find the artifacts |tip Each dig site has 6 artifacts you can find.
		.' Click the Archaeology Fragments that spawn on the ground
		.get 6 Serpentrider Relic## |q 30147/1
		|only if havequest(30147)
	step
		goto 57.5,44.7
		.talk Jenova Longeye##58413
		..turnin Just a Flesh Wound##30148 |only if skill("First Aid")>=525
		..turnin A Feast for the Senses##30149 |only if skill("Cooking")>=525
		..turnin Fragments of the Past##30147
		..turnin Snack Time##30146
	step
		goto 57.5,45.4
		'Talk to Your Hatchling |tip Your Hatchling is whichever color egg you chose in the prequests.
		|modelnpc Your Hatchling##58416
		|modelnpc Your Hatchling##58213
		..turnin Sweet as Honey##30150
		|only if havequest(30150)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..turnin Catch!##30151
		|only if havequest(30151)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..accept Needle Me Not##31705
		|only if completedq(30151)
	step
		goto 57.0,41.2
		.' Use the Golden Honey in your bags |use Golden Honey##89113
		.kill Orchard Needler |q 31705/1
		|only if havequest(31705)
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..turnin Needle Me Not##31705
		|next "exalted" |only if rep("Order of the Cloud Serpent")==Exalted
		|next "revered" |only if rep("Order of the Cloud Serpent")==Revered
		|next "end" |only if rep("Order of the Cloud Serpent")<=Revered
	step
	label revered
		goto The Jade Forest 56.6,44.4
		.talk San Redscale##58414
		..buy 1 Grand Commendation of the Order of the Cloud Serpent##93229 |n
		.' Use the Commendation of the Order of the Cloud Serpent you just purchased. |condition ZGV:GetReputation("Order of the Cloud Serpent").hasBonus |use Grand Commendation of the Order of the Cloud Serpent##93229
		|only if rep("Order of the Cloud Serpent")>=Revered
	step
		goto 57.6,44.9
		.talk Elder Anli##58564
		..accept They Grow Like Weeds##30143
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		.' Ask Instructor Windbalde how your serpent is doing.
		.' Speak to Instructor Windblade |q 30143/1
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin They Grow Like Weeds##30143
		..accept Flight Training: Ring Round-Up##30144
	step
		'The color of Cloud Serpent depends on your egg color choice when you unlocked the dailies for this faction.
		.clicknpc Golden Cloud Serpent##58429
		.clicknpc Azure Cloud Serpent##58441
		.clicknpc Jade Cloud Serpent##58442
		.' Ride your Cloud Serpent |invehicle |c
		|only if havequest(30144)
	step
		'Fly your Cloud Serpent through the rings made from clouds.
		.' Fly through 6 Cloud Rings |q 30144/1
	step
		goto 58.6,43.7
		.' Click the Leave Vehicle button |outvehicle |c
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin Flight Training: Ring Round-Up##30144
		..accept Flight Training: Full Speed Ahead##30145
	step
		'The color of Cloud Serpent depends on your egg color choice when you unlocked the dailies for this faction.
		.clicknpc Golden Cloud Serpent##58429
		.clicknpc Azure Cloud Serpent##58441
		.clicknpc Jade Cloud Serpent##58442
		.' Ride your Cloud Serpent |invehicle |c
		|only if havequest(30145)
	step
		'Follow Instructor Windblade through the course, her mounts flies faster than yours so fly through some of the cloud rings to maintain speed with your guide. If you move too slowly or get too far away from the guide, the course will restart.
		.' Finish the course |q 30145/1
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin Flight Training: Full Speed Ahead##30145
		..accept Flight Training: In Due Course##30187
	step
		'The color of Cloud Serpent depends on your egg color choice when you unlocked the dailies for this faction.
		.clicknpc Golden Cloud Serpent##58429
		.clicknpc Azure Cloud Serpent##58441
		.clicknpc Jade Cloud Serpent##58442
		.' Ride your Cloud Serpent |invehicle |c
		|only if havequest(30187)
	step
		path	strict; curved; loop
		path	60.6,39.4	59.7,31.5	61.3,25.2
		path	66.3,36.0	66.2,42.4	66.8,51.4
		path	64.0,51.0	60.4,52.9	61.8,54.5
		path	58.7,46.8	58.4,46.4
		'Follow this path and collect the checked flags hanging off of the Checkpoint balloons. As you fly, gain speed by flying through cloud rings
		.' Pass 10 Checkpoints |q 30187/1
	step
		goto 58.6,43.7
		.talk Instructor Windblade##58420
		..turnin Flight Training: In Due Course##30187
		|next "end"
	step
	label exalted
		goto 57.6,45.0
		.talk Elder Anli##58564
		..accept Riding the Skies##31811
	step
		'Watch the cinematic
		.' Join the Order of the Cloud Serpent |q 31811/1
	step
		goto 57.6,45.0
		.talk Elder Anli##58564
		..turnin Riding the Skies##31811
	step
		Proceeding to the next step |next end |only if default
		Proceeding to Riding the Skies Quest |next exalted |only if rep('Order of the Cloud Serpent')==Exalted
	step
	label	exalted
		goto 57.7,44.9
		.talk Elder Anli##58564
		..accept Riding the Skies##31810
	step
		goto 57.7,44.9
		.talk Elder Anli##58564
		..turnin Riding the Skies##31810
	step
	label end
		'This the end of our daily guide.
		.' Click here to go back to the beginning |confirm |next start
]])

ZygorGuidesViewer:RegisterInclude("August_Celestials",[[
	step
	label startaug
		goto Vale of Eternal Blossoms 84.6,63.7
		.talk Sage Whiteheart##64032
		.' The following quests will only be available the first time you are sent to a new area. They are random and Sage Lotusbloom will only have one at a time.
		..accept Challenge At The Temple of the Red Crane##31378 |or |next "crane" |only if not completedq(31378)
		..accept Attack At The Temple of the Jade Serpent##31376  |or |next "serpent" |only if not completedq(31377)
		..accept Defense At Niuzao Temple##31382 |or |next "ox" |only if not completedq(31382)
		..accept Trial At The Temple of the White Tiger##31380 |or |next "tiger" |only if not completedq(31380)
		.' If no quest is available, ask her how you can help the August Celestials today. Then click on whichever spirit needs you today.
		.' Niuzao the Black Ox |confirm |next "ox"
		.' Yu'lon the Jade Serpent |confirm |next "serpent"
		.' Xuen the White Tiger |confirm |next "tiger"
		.' Chi-Ji the Red Crane |confirm |next "crane"
// Crane
	step
	label crane
		goto Krasarang Wilds 31.3,63.4
		.talk Thelonius##60506
		..turnin Challenge At The Temple of the Red Crane##31378
		|only if not completedq(31378)
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..accept Students of Chi-Ji##30718
		..accept Champion of Chi-Ji##30740 |only if achieved(7287)
	step
		goto 31.5,63.7
		.talk Yan Quillpaw##60529
		..accept Gifts of the Great Crane##30717
	step
		goto 31.1,63.5
		.talk Kuo-Na Quillpaw##60528
		..accept Chasing Hope##30716
	step
		goto 34.6,82.0
		.talk Champion of Chi-Ji##60546
		.' Let's fight!
		.' Defeat a Champion of Chi-Ji |q 30740/1
		|only if havequest(30740)
	step
		goto 31.2,73.9
		.from 10 Student of Chi-Ji##60601+
		.' Duel 10 Students of Chi-Ji |q 30718/1
		.click Cerulean Gift of the Crane
		.click Crimson Gift of the Crane
		.click Bronze Gift of the Crane
		|tip The Gifts look like feathers laying around on the ground.
		.get 10 Gift of the Great Crane##80938+ |q 30717/1
		.' Find 3 Spirits of the Crane |q 30716/1 |tip They look like stealthed birds roaming around the isle in set paths. Run into them.
	step
		goto 31.3,63.6
		.talk Kuo-Na Quillpaw##60528
		..turnin Chasing Hope##30716
	step
		goto 31.3,63.6
		.talk Yan Quillpaw##60529
		..turnin Gifts of the Great Crane##30717
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..turnin Students of Chi-Ji##30718
		..accept Ellia Ravenmane##30725 |or
		..accept Minh Do-Tan##30726 |or
		..accept Ellia Ravenmane: Rematch##30727 |or
		..accept Fat Long-Fat##30728 |or
		..accept Julia Bates##30729 |or
		..accept Dextrous Izissha##30730 |or
		..accept Kuo-Na Quillpaw##30731 |or
		..accept Ellia Ravenmane: Revenge##30732 |or
		..accept Tukka-Tuk##30733 |or
		..accept Huck Wheelbarrow##30734 |or
		..accept Mindel Sunspeaker##30735 |or
		..accept Yan Quillpaw##30736 |or
		..accept Fat Long-Fat: Rematch##30737 |or
		..accept Thelonius##30738 |or
		..accept Ellia Ravenmane: Redemption##30739 |or
		|only if not achieved(7287)
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..turnin Students of Chi-Ji##30718
		..turnin Champion of Chi-Ji##30740
		|only if achieved(7287)
		|next "end"
	step
		goto 32.0,70.7
		.talk Fat Long-Fat##60534 |tip He is on the very top of this building.
		.' Let's fight!
		.' Defeat Fat Long-Fat |q 30728/1
	step
		goto 31.8,71.2
		.talk Ellia Ravenmane##60530
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30725/1
	step
		goto 32.1,69.9
		.talk Mindel Sunspeaker##60541
		.' Let's fight!
		.' Defeat Mindel Sunspeaker |q 30735/1
	step
		goto 32.0,76.5
		.talk Minh Do-Tan##60532
		.' Let's fight!
		.' Defeat Minh Do-Tan |q 30726/1
	step
		goto 34.1,75.1
		.talk Tukka-Tuk##60539
		.' Let's fight!
		.' Defeat Tukka-Tuk |q 30733/1
	step
		goto 36.4,75.6
		.talk Ellia Ravenmane##60545
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30739/1
	step
		goto 31.7,80.3
		.talk Dextrous Izissha##60536
		.' Let's fight!
		.' Defeat Dextrous Izissha |q 30730/1
	step
		goto 34.8,82.6
		.talk Fat Long-Fat##60543
		.' Let's fight!
		.' Defeat Fat Long-Fat |q 30737/1
	step
		goto 36.6,74.8
		.talk Kuo-Na Quillpaw##60537
		.' Let's fight!
		.' Defeat Kuo-Na Quillpaw |q 30731/1
	step
		goto 35.2,75.1
		.talk Ellia Ravenmane##60533
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30727/1
	step
		goto 28.9,75.5
		.talk Julia Bates##60535
		.' Let's fight!
		.' Defeat Julia Bates |q 30729/1
	step
		goto 27.9,70.3
		.talk Huck Wheelbarrow##60540
		.' Let's fight!
		.' Defeat Huck Wheelbarrow |q 30734/1
	step
		goto 36.5,76.2
		.talk Yan Quillpaw##60542
		.' Let's fight!
		.' Defeat Yan Quillpaw |q 30736/1
	step
		goto 34.5,83.3
		.talk Ellia Ravenmane##60538
		.' Let's fight!
		.' Defeat Ellia Ravenmane |q 30732/1
	step
		goto 28.8,72.4
		.talk Thelonius##60544
		.' Let's fight!
		.' Defeat Thelonius |q 30738/1
	step
		goto 31.3,63.4
		.talk Thelonius##60506
		..turnin Ellia Ravenmane##30725 |or
		..turnin Minh Do-Tan##30726 |or
		..turnin Ellia Ravenmane: Rematch##30727 |or
		..turnin Fat Long-Fat##30728 |or
		..turnin Julia Bates##30729 |or
		..turnin Dextrous Izissha##30730 |or
		..turnin Kuo-Na Quillpaw##30731 |or
		..turnin Ellia Ravenmane: Revenge##30732 |or
		..turnin Tukka-Tuk##30733 |or
		..turnin Huck Wheelbarrow##30734 |or
		..turnin Mindel Sunspeaker##30735 |or
		..turnin Yan Quillpaw##30736 |or
		..turnin Fat Long-Fat: Rematch##30737 |or
		..turnin Thelonius##30738 |or
		..turnin Ellia Ravenmane: Redemption##30739 |or
		|only if not achieved(7287)
		|next "end"
////Not always here,
	step
	label serpent
		goto The Jade Forest 53.9,61.9
		.talk Elder Sage Tai-Feng##57324
		..turnin Attack At The Temple of the Jade Serpent##31376 |only if havequest(31376)
		..accept Arrows of Fortune##30065
		..accept Hidden Power##30066
		..accept The Darkness Around Us##30006
		'Click here if he has no quests today. |confirm
	step
		goto 53.9,61.9
		.talk Elder Sage Storm-Sing##57319
		..accept Behind the Masks##30063 |or
		..accept Saving the Sutras##30064 |or
		'Click here if he has no quests today. |confirm
	step
		goto 56.5,53.6
		.click Ancient Sutra
		.get 6 Ancient Sutra##77432 |q 30064/1
		|only if havequest(30064)
	step
		goto 55.3,57.4
		.click Defender's Arrow |only if havequest(30065)
		.get 10 Defender's Arrow##77452+ |q 30065/1 |only if havequest(30065)
		.' Use the Stack of Mantras in your bags on Yu'lon Adepts and Yu'lon Guardians |use Stack of Mantras##77475 |only if havequest(30066)
		.' Deliver 6 Ancient Mantras |q 30066/1 |only if havequest(30066)
		|modelnpc Yu'lon Guardian##57400
		|modelnpc Yu'lon Adept##57316
	step
		goto 54.5,54.1
		.from Final Doubt##57330+, Lingering Doubt##57396+ |only if havequest(30063)
		.get 8 Mask of Doubt##77419+ |q 30063/1 |only if havequest(30063)
		|only if havequest(30063)
	step
		goto 53.4,54.2
		.from Final Doubt##57330+, Lingering Doubt##57396+, Shadow Of Doubt##57389
		.' Kill 15 Sha Invaders |q 30006/1
		|only if havequest(30006)
	step
		goto 53.9,61.9
		.talk Elder Sage Storm-Sing##57319
		..turnin Behind the Masks##30063
		..turnin Saving the Sutras##30064
	step
		goto The Jade Forest 53.9,61.9
		.talk Elder Sage Tai-Feng##57324
		..turnin Arrows of Fortune##30065
		..turnin Hidden Power##30066
		..turnin The Darkness Around Us##30006
		..accept Flames of the Void##30068 |or
		..accept The Shadow of Doubt##30067 |or
		|noquest
	step
		goto 57.5,62.3
		.kill 1 Shadow of Doubt##57389 |q 30067/1
		|only if havequest(30067)
	step
		goto 54.1,60.9
		.clicknpc War Serpent##57871
		.' Ride the War Serpent |invehicle
		|only if havequest(30068)
	step
		'Fly around the Jade Temple Grounds and extinguish Void Flames. |tip they look like black fire.
		.' If you run out of water you can refill it in the river [53.9,58.0]
		.' Douse 6 Void Flames |q 30068/1
		|only if havequest(30068)
	step
		goto 53.9,61.9
		.' Click the Leave Vehicle button. |outvehicle
		|only if havequest(30068)
	step
		goto 53.9,61.9
		.talk Elder Sage Tai-Feng##57324
		..turnin The Shadow of Doubt##30067
		..turnin Flames of the Void##30068
		|next "end"
/// Temple of the White Tiger. Not giving rep for August Celstials.
	step
	label tiger
		goto Kun-Lai Summit 67.2,55.9
		.talk Xuen##60968
		..turnin Trial At The Temple of the White Tiger##31380
		|only if havequest(31380)
	step
		goto 67.2,55.9
		.talk Xuen##60968
		..accept Round 1: Brewmaster Chani##30879 |or
		..accept Round 1: The Streetfighter##30880 |or
		..accept Contending With Bullies##31517 |tip This quest may not be available.
		|confirm
	step
		goto 71.1,55.8
		.kill Shonuf##64757 |q 31517/1
		|only if havequest(31517)
	step
		goto 71.0,51.8
		.talk Brewmaster Chani##60996
		.' Challenge her. |tip She has a lot of health but isn't too difficult to kill. She will toss Bitter Brew on the ground, so kite her out of it. She also has an AoE cone called The Steamer, you can avoid this by either moving out of it, or interrupting the channel.
		.'Defeat Brewmaster Chani |q 30879/1
		|only if havequest(30879)
	step
		goto 71.0,51.8
		.talk Lun-Chi##60994
		.' Challenge her.
		.' Defeat The Streetfighter |q 30880/1
		|only if havequest(30880)
	step
		goto 70.3,51.3
		.talk Xuen##60968
		..turnin Round 1: Brewmaster Chani##30879
		..turnin Round 1: The Streetfighter##30880
		..turnin Contending With Bullies##31517
		..accept Round 2: Clever Ashyo & Ken-Ken##30881 |or
		..accept Round 2: Kang Bramblestaff##30882 |or
	step
		goto 71.7,45.4
		.talk Kang Bramblestaff##60978
		.' Challenge him.
		.' Defeat Kang Bramblestaff |q 30882/1
		|only if havequest(30882)
	step
		goto 71.7,45.4
		.talk Clever Ashyo##60980
		.' Challenge him. |tip Kill Ken-Ken first as he is the weaker of the two. He will cast Ken-Ken Rampage causing him to whirlwind, when he does momentarily switch to Ashyo. Ashyo will summon Water Spouts and Healing Spheres. The Spheres are top priority and the Spouts are easily avoidable.
		.' Defeat Clever Ashyo |q 30881/1
		.' Defeat Ken-Ken |q 30881/2
		|modelnpc Ken-Ken##60979
		|only if havequest(30881)
	step
		goto 71.8,44.9
		.talk Xuen##60968
		..turnin Round 2: Clever Ashyo & Ken-Ken##30881
		..turnin Round 2: Kang Bramblestaff##30882
		..accept Round 3: The Wrestler##30883 |or
		..accept Round 3: Master Boom Boom##30885 |or
	step
		goto 66.7,46.5
		.talk Master Boom Boom##61013
		.' Challenge him. |tip He will constantly toss Dynamite at you that will put a landmine on the ground if you walk over it. When he starts the fuse on his boom box, be out of the middle of the arena by the time it finishes.
		.' Defeat Master Boom Boom |q 30885/1
		|only if havequest(30885)
	step
		goto 66.7,46.5
		.talk The Wrestler##60997
		.' Challenge him. |tip Click on the chairs around the room to increase your damage and cause The Wrestler to be stunned for 10 seconds. If you space these out enough, you could potentially kill him before he can hurt you. Periodically he will grapple and throw you, it does not do much damage but it prevents control of your character. Finally, he uses a Sling Sweat ability which puts a blue puddle on the ground that reduces your movement speed and does damage.
		.' Defeat The Wrestler |q 30883/1
		|only if havequest(30883)
	step
		goto 66.4,46.3
		.talk Xuen##60968
		..turnin Round 3: The Wrestler##30883
		..turnin Round 3: Master Boom Boom##30885
		..accept Round 4: The P.U.G.##30907 |or
		..accept Round 4: Master Windfur##30902 |or
	step
		goto 68.8,43.8
		.talk Master Windfur##61012
		.' Challenge him.
		.' Defeat Master Windfur. |q 30902/1
		|only if havequest(30902)
	step
		'Enter the building and go to [69.0,43.7]
		.talk Healiss##61004
		.' Challenge him. |tip Defeat the P.U.G. by first kill Healiss. He will attempt to run away and only has one healing spell that he may try to use, it is called Jungle Remedy, save Interrupts and Stuns for this ability. Next deal with Tankiss, he has more health but is a greater threat than Hackiss, his only ability is called Ground Pummel which will knock you can and deal some damage. Finally kill Hackiss, his only ability is Backstab. This will leave a small bleed on you.
		.' Defeat Hackiss |q 30907/1
		.' Defeat Healiss |q 30907/2
		.' Defeat Tankiss |q 30907/3
		|modelnpc Hackiss##61007
		|modelnpc Tankiss##61006
		|only if havequest(30907)
	step
		goto 68.5,44.6
		.talk Xuen##60968
		..turnin Round 4: The P.U.G.##30907
		..turnin Round 4: Master Windfur##30902
	step
		goto Kun-Lai Summit 68.5,56.5
		.talk Lin Tenderpaw##60981
		..accept The Torch of Strength##31492
		.' Click here if the quest isn't available. |confirm
	step
		'For this quest you must go up the path, avoiding all of the tornadoes that roam around. If you mount, or touch a tornado, you will have to go back to Lin and start the quest over.
		|confirm
		|only if havequest(31492)
	step
		goto 69.6,53.0 |n
		.' Enter the first temple here. |goto 69.6,53.0 |noway |c
		|only if havequest(31492)
	step
		goto 66.9,51.2 |n
		.' Enter the second temple here. |goto 66.9,51.2 |noway |c
		|only if havequest(31492)
	step
		goto 68.6,46.6
		.' Click _The Strong Brazier_ to light it.
		.' Light the Strong Brazier |q 31492/1
		|only if havequest(31492)
	step
		goto Kun-Lai Summit 68.5,56.5
		.talk Lin Tenderpaw##60981
		..turnin The Torch of Strength##31492
		|next "end"
		|only if havequest(31492)
	step
		|next "end"
/// Niuzao Temple. Possible unlock hub at revered.
	step
	label "ox"
		goto Townlong Steppes 39.3,62.3
		.talk Ogo the Elder##61580
		..turnin Defense At Niuzao Temple##31382 |only if havequest(31382)
		..accept The Siege Swells##30956 |or
		..accept The Unending Siege##30952 |or
	step
		goto 39.3,62.3
		.talk Ogo the Younger##61581
		..accept The Big Guns##30959 |or
		..accept A Blade is a Blade##30954 |or
	step
		goto 39.2,62.1
		.talk Yak-Keeper Kyana##61585
		..accept Fallen Sentinels##30953
		.' If this quest is unavailable today, click here. |confirm
	step
		goto 39.4,61.9
		.talk Sentinel Commander Qipan##61584
		..accept The Overwhelming Swarm##30957
		.' If this quest is unavailable today, click here. |confirm
	step
		goto 38.9,62.4
		.talk High Adept Paosha##61583
		..accept In Battle's Shadow##30958 |or
		..accept Paying Tribute##30955 |or
	step
		'The following can all be done around Niuzao Temple:
		.' Use your Pot of Fire on Sra'thik War Wagons |use Pot of Fire##82346 |modelnpc Sra'thik War Wagon##61510 |only if havequest(30959)
		.' Cause 3 Sri'thik War Wagons to explode. |q 30959/1 |only if havequest(30959)
		.from Sra'thik Swiftclaw##61508+, Sra'thik Warcaller##61502+, Sra'thik Fleshrender##61514+ |only if havequest(30956)
		.' Kill 25 Sri'thik attackers |q 30956/1 |only if havequest(30956)
		.kill 4 Sra'thik Kunchong##61509+ |q 30957/1 |only if havequest(30957)
		.click Loose Brick |only if havequest(30958)
		.' Throw 10 Loose Stones up to Niuzao Stonemasons |q 30958/1 |only if havequest(30958)
		.' Use your Yak's Milk Flask on Wounded Niuzao Sentinels. |use Yak's Milk Flask##82381 |tip Normal healing spells will also heal the Sentinels if you have them. |only if havequest(30953)
		.' Heal 8 Niuzao Sentinels |q 30953/1 |only if havequest(30953)
		.click Niuzao Food Supply |only if havequest(30955)
		.' Gather 6 Food for Niuzao |q 30955/1 |only if havequest(30955)
		.from Sra'thik Warcaller##61502+, Sra'thik Swiftclaw##61508+ |only if havequest(30952)
		.' Kill 12 Sra'thik attackers |q 30952/1 |only if havequest(30952)
		.click Sra'thik Weapon |tip After you kill a Sra'thik a weapon may drop. |only if havequest(30954)
		.get 10 Sra'thik Weapon##82353 |q 30954/1 |only if havequest(30954)
	step
		goto 39.3,62.3
		.talk Ogo the Elder##61580
		..turnin The Siege Swells##30956
		..turnin The Unending Siege##30952
	step
		goto 39.3,62.3
		.talk Ogo the Younger##61581
		..turnin The Big Guns##30959
		..turnin A Blade is a Blade##30954
	step
		goto 39.2,62.1
		.talk Yak-Keeper Kyana##61585
		..turnin Fallen Sentinels##30953
		..turnin In Battle's Shadow##30958
	step
		goto 39.4,61.9
		.talk Sentinel Commander Qipan##61584
		..turnin The Overwhelming Swarm##30957
	step
		goto 38.9,62.4
		.talk High Adept Paosha##61583
		..turnin Paying Tribute##30955
	step
	label "end"
		goto Vale of Eternal Blossoms 84.6,63.7
		.talk Sage Whiteheart##64032
		..buy 1 Grand Commendation of the August Celestials##93224 |n
		.' Use the Commendation of the August Celestials you just purchased. |condition ZGV:GetReputation("August Celestials").hasBonus |use Grand Commendation of the August Celestials##93224
		|only if rep("August Celestials")>=Revered
	step
		'You have reached the end of this daily guide.
		.' Click here to return to the start of the dailies. |next "startaug" |confirm
]])

ZygorGuidesViewer:RegisterInclude("Shado_Pan_Daily_A",[[
	step
	label shado_dailies
		goto Townlong Steppes 49.3,71.0
		'Click here if Master Snowdrift is the questgiver today |next |confirm |modelnpc 63009
		.' He can be found here: [49.5,70.6]
		'Click here if Ban Bearheart is the questgiver today |next "bearheart" |confirm |modelnpc 62304
		.' He can be found here [49.0,70.5]
		'Click here if Ling of the Six Pools is the questgiver today |next "ling" |confirm |modelnpc 63614
		.' She can be found here: [49.0,71.3]
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..accept The Challenger's Ring: Chao the Voice##31127
		|only if not completedq(31127)
		|only if rep('Shado-Pan')>=Honored
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..accept The Challenger's Ring: Lao-Chin the Iron Belly##31128
		|only if rep('Shado-Pan')>=Revered
	step
		goto 49.3,72.0
		.talk Lao-Chin the Iron Belly##62978
		.' I'm here to challenge you! |q 31128/1
		|only if havequest(31128)
	step
		goto 50.6,67.8
		.talk Lao-Chin the Iron Belly##63135
		.' All right, let's do this!
		.' Defeat Lao-Chin the Iron Belly |q 31128/2
		|only if havequest(31128)
	step
		goto 49.6,70.5
		.talk Master Snowdrift##63009
		..turnin The Challenger's Ring: Lao-Chin the Iron Belly##31128
		|only if havequest(31128)
	step
		goto 49.7,70.5
		.talk Chao the Voice##62550
		.' Tell her you're here to challenge her! |q 31127/1
		|only if havequest(31127)
	step
		goto 50.1,68.3
		.talk Chao the Voice##63125
		.' Let's do this.
		.' Defeat Chao the Voice |q 31127/2
		|only if havequest(31127)
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..turnin The Challenger's Ring: Chao the Voice##31127
		|only if havequest(31127)
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009 |tip You will only be able to accept 4 of the following dailies.
		..accept Assault Fire Camp Gai-Cho##31113 |or 4
		..accept Assault Deadtalker's Plateau##31114 |or 4
		..accept The Enemy of My Enemy... Is Still My Enemy!##31119 |or 4
		..accept Spirit Dust##31116 |or 4
		..accept The Deadtalker Cipher##31118 |or 4
	step
		'Talk to Chao the Voice or Protector Yi and ask one of them to come with you. They will help you in combat and allow you to turnin your quests outside of this questing hub.|tip Yi patrols so you may need to search for him.
		.' Chao the Voice at [49.7,70.5] |modelnpc 62550
		.' Protector Yi at [49.3,71.3] |modelnpc 62546
		|confirm
		|only if not completedq(31128)
	step
		'Talk to Chao the Voice, Protector Yi or Lao-Chin the Iron Belly and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.|tip Yi patrols so you may need to search for him.
		.' Chao the Voice at [49.7,70.5] |modelnpc 62550
		.' Protector Yi at [49.3,71.3] |modelnpc 62546
		.' Lao-Chin the Iron Belly at [49.3,71.9] |modelnpc 62978
		|confirm
		|only if completedq(31128)
	step
		goto 63.4,43.3
		.from Gai-Cho Yaungol##62552+, Gai-Cho Earthtalker##62553+, Gai-Cho Pitchthrower##62608+ |only if havequest(31113)
		.' Kill 16 Gai-Cho Yaungol, Earthtalkers, or Pitchthrowers. |q 31113/1 |only if havequest(31113)
		.click Highly Explosive Yaungol Oil Barrel |only if havequest(31119)
		.collect Highly Explosive Yaungol Oil##84762 |n |tip You can only carry 10 at a time, so you may need to make multiple trips. |only if havequest(31119)
	step
		goto 60.2,48.6
		'Use your Highly Explosive Yaungol Oil to kill as many enemies in this area as you can in 1 hit. |use Highly Explosive Yaungol Oil Barrel##84762
		.from Gai-Cho Boltshooter##62589+, Gai-Cho Cauterizer##62577+, Gai-Cho Gatewatcher##62568+, Kri'thik Aggressor##62572+, Kri'thik Screecher##62602+
		.' Kill 100 Gai-Cho Battledfired Combatants |q 31119/1
		.' If you run out of oil, you can find more here [63.4,43.3]
		|only if havequest(31119)
	step
		goto 51.1,51.8
		.kill 8 Deadtalker Corpsedefiler##62677+ |q 31114/1 |only if havequest(31114)
		.kill Deadtalker Crusher##62844 |q 31114/2 |tip He is elite but with your companion you should be able to defeat him. |only if havequest(31114)
		.from Defiled Spirit##62679 |only if havequest(31116)
		.collect Ancient Spirit Dust##84727 |n |only if havequest(31116)
		.click Defiled Yaungol Remains |only if havequest(31116)
		.' Return 8 Spirits to Their Remains |q 31116/1 |only if havequest(31116)
	step
		goto 51.1,51.8
		.from Deadtalker Crusher##62844+, Deadtalker Corpsedefiler##62677+ |only if havequest(31118)
		.get Ciphered Scroll##84759 |q 31118/1 |only if havequest(31118)
	step
		'Next to you will either be Chao the Voice or Protector Yi:
		.'Talk to Chao the Voice |modelnpc 62550
		.'Talk to Protector Yi |modelnpc 62546
		..turnin Assault Fire Camp Gai-Cho##31113
		..turnin Assault Deadtalker's Plateau##31114
		..turnin The Enemy of My Enemy... Is Still My Enemy!##31119
		..turnin Spirit Dust##31116
		..turnin The Deadtalker Cipher##31118
		|only if not completedq(31128)
	step
		'Next to you will either be Chao the Voice, Protector Yi, or Lao-Chin the Iron Belly:
		.'Talk to Chao the Voice |modelnpc 62550
		.'Talk to Protector Yi |modelnpc 62546
		.'Talk to Lao-Chin the Iron Belly |modelnpc 62978
		..turnin Assault Fire Camp Gai-Cho##31113
		..turnin Assault Deadtalker's Plateau##31114
		..turnin The Enemy of My Enemy... Is Still My Enemy!##31119
		..turnin Spirit Dust##31116
		..turnin The Deadtalker Cipher##31118
		|only if completedq(31128)
	step
		'Click the Quest Discovered box that displays on the right side of the screen under your minimap
		..accept Uruk!##31117 |or
		..accept Cheng Bo!##31120 |or
	step
		goto 50.4,48.9
		.kill Uruk##62613 |q 31117/1
	step
		goto 60.7,42.1
		.kill 1 Cheng Bo##62554 |q 31120/1
	step
		goto 49.6,70.5
		.talk Master Snowdrift##63009
		..turnin Uruk!##31117 |or
		..turnin Cheng Bo!##31120 |or
		|next "end"
	step
	label bearheart
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..accept The Challenger's Ring: Snow Blossom##31038
		|only if not completedq(31038)
		|only if rep('Shado-Pan')>=Honored
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..accept The Challenger's Ring: Yalia Sagewhisper##31104
		|only if rep('Shado-Pan')>=Revered
	step
		goto 48.9,70.1
		.talk Snow Blossom##62380
		.' Ask her to meet in the Challenger's Ring. |q 31038/1
		|only if havequest(31038)
	step
		goto 50.2,67.9
		.talk Snow Blossom##62834
		.' I challenge you!
		.' Defeat Snow Blossom |q 31038/2
		|only if havequest(31038)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..turnin The Challenger's Ring: Snow Blossom##31038
		|only if havequest(31038)
	step
		goto 48.9,70.0
		.talk Yalia Sagewhisper##62303
		.' Ask her to meet you in the Challenger's Ring. |q 31104/1
		|only if havequest(31104)
	step
		goto 50.4,67.7
		.talk Yalia Sagewhisper##62850
		.' I challenge you!
		.' Defeat Yalia Sagewhisper |q 31104/2
		|only if havequest(31104)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..turnin The Challenger's Ring: Yalia Sagewhisper##31104
		|only if havequest(31104)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..accept The Mogu Menace##31105 |or 4
		..accept The Mogu Menace##31106 |or 4
		..accept The Mogu Menace##31039 |or 4
		..accept Bronze Claws##31044 |or 4
		..accept Illusions Of The Past##31045 |or 4
		..accept Grave Consequences##31048 |or 4
		..accept Dark Arts##31043 |or 4
		..accept Onyx Hearts##31042 |or 4
		..accept Born Free##31047 |or 4
		..accept Spiteful Sprites##31040 |or 4
		..accept Egg Rescue!##31041 |or 4
		..accept Little Hatchlings##31046 |or 4
	step
		'Talk to Snow Blossom or Fei Li and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		.' Snow Blossom at [48.9,70.1] |modelnpc 62380
		.' Fei Li at [48.8,70.2] |modelnpc 62354
		|confirm
		|only if not completedq(31104)
	step
		'Talk to Snow Blossom, Fei Li, or Yalia Sagewhisper and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		.' Snow Blossom at [48.9,70.1] |modelnpc 62380
		.' Fei Li at [48.8,70.2] |modelnpc 62354
		.' Yalia Sagewhisper at [48.8,70.0] |modelnpc 62303
		|confirm
		|only if completedq(31104)
	step
		goto 28.8,22.4
		.talk Moshu the Arcane##62810
		..accept Through the Portal##31110
		|only if not completedq(31110)
	step
		goto 32.8,25.1
		.clicknpc Ball and Chain##62539 |only if havequest(31047)
		.' Free 6 Wild Cloudriders |q 31047/1 |only if havequest(31047)
		.click Shan'ze Cage |only if havequest(31046)
		.' Free 20 Cloudrider Hatchlings. |q 31046/1 |only if havequest(31046)
		.click Shiny Egg |only if havequest(31041)
		.get 8 Cloudrunner Egg |q 31041/1 |only if havequest(31041)
	step
		goto 24.4,15.2
		.kill 3 Shan'ze Illusionist##62440+ |q 31045/1|only if havequest(31045)
		.click Shan'ze Tablet |only if havequest(31043)
		.get 8 Shan'ze Tablet |q 31043/1 |only if havequest(31043)
		.click Mogu Burial Urn |only if havequest(31048)
		.kill 24 Shan'ze Ancestor##62285+ |q 31048/1 |only if havequest(31048)
		.from Onyx Stormclaw##62448 |only if havequest(31042)
		.get 4 Onyx Heart |q 31042/1 |only if havequest(31042)
	step
		goto 28.5,18.5
		.from Shan'ze Serpentbinder##62293+, Shan'ze Beastmaster##62530+ |only if havequest(31105) or havequest(31106) or havequest (31039)
		.' Kill 12 Shan'ze Serpentbinders or Beastmasters |q 31105/1 |only if havequest(31105)
		.' Kill 12 Shan'ze Serpentbinders or Beastmasters |q 31106/1 |only if havequest(31106)
		.' Kill 12 Shan'ze Serpentbinders or Beastmasters |q 31039/1 |only if havequest(31039)
		.from Bronze Quilen##62266+ |only if havequest(31044)
		.get 20 Bronze Claw##83153+ |q 31044/1 |only if havequest(31044)
	step
		goto 23.0,19.5
		.from Darkwoods Pixie##62268+, Darkwoods Charmer##62457+
		.' Kill 30 Darkwoods Sprites or Darkwoods Charmers. |q 31040/1
		|only if havequest(31040)
	step
		.from Shan'ze Serpentbinder##62293+, Shan'ze Illusionist##62440+, Shan'ze Ancestor##62285+, Shan'ze Beastmaster##62515+, Darkwoods Charmer##62520
		.get 1000 Ancient Arcane Powder##84102+ |q 31110/1
		|only if havequest(31110)
	step
		'Next to you will either be Fei Li or Snow Blossom
		.talk Fei Li##62354
		.talk Snow Blossom##62380
		..turnin The Mogu Menace##31105
		..turnin The Mogu Menace##31106
		..turnin The Mogu Menace##31039
		..turnin Bronze Claws##31044
		..turnin Illusions Of The Past##31045
		..turnin Grave Consequences##31048
		..turnin Dark Arts##31043
		..turnin Onyx Hearts##31042
		..turnin Born Free##31047
		..turnin Spiteful Sprites##31040
		..turnin Egg Rescue!##31041
		..turnin Little Hatchlings##31046
		..accept When The Dead Speak##31062 |or
		..accept Riding the Storm##31061 |or
		..accept In Sprite Of Everything##31049 |or
		|only if not completedq(31104)
	step
		'Next to you will either be Fei Li, Snow Blossom, or Yalia Sagewhisper
		.talk Fei Li##62354
		.talk Snow Blossom##62380
		.talk Yalia Sagewhisper##62303
		..turnin The Mogu Menace##31105
		..turnin The Mogu Menace##31106
		..turnin The Mogu Menace##31039
		..turnin Bronze Claws##31044
		..turnin Illusions Of The Past##31045
		..turnin Grave Consequences##31048
		..turnin Dark Arts##31043
		..turnin Onyx Hearts##31042
		..turnin Born Free##31047
		..turnin Spiteful Sprites##31040
		..turnin Egg Rescue!##31041
		..turnin Little Hatchlings##31046
		..accept When The Dead Speak##31062 |or
		..accept Riding the Storm##31061 |or
		..accept In Sprite Of Everything##31049 |or
		|only if completedq(31104)
	step
		goto 30.9,12.6
		.' Use the Bronze Claws on the Cloudrunners around this area. |use Bronze Claws##83134
		.from Shan'ze Cloudrunner##62584
		.' Free 8 Shan'ze Cloudriders |q 31061/1
		|only if havequest(31061)
	step
		'Click the Leave Vehicle button. |outvehicle
		|only if havequest(31061)
	step
		'Enter the tunnel here. |goto 20.3,15.8 <10 |c
		|only if havequest(31049)
	step
		goto 19.5,13.8
		.kill Darkwoods Faerie##62522 |q 31049/1
		|only if havequest(31049)
	step
		'Leave the tunnel here. |goto 20.3,15.8 <5 |c
		|only if havequest(31049)
	step
		goto 32.3,9.5
		.kill 1 Shan'ze Deathspeaker##62559 |q 31062/1 |tip Make sure you destroy his Spirit Gems, if you let them pile up they can overwhelm you.
		|only if havequest(31062)
	step
		goto 28.8,22.4
		.talk Moshu the Arcane##62810
		..turnin Through the Portal##31110
		|only if havequest(31110)
	step
		goto 49.0,70.4
		.talk Ban Bearheart##62304
		..turnin When The Dead Speak##31062
		..turnin Riding the Storm##31061
		..turnin In Sprite Of Everything##31049
		|next "end"
// LING
	step
	label ling
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..accept The Challenger's Ring: Hawkmaster Nurong##31220
		|
		|only if not completedq(31220)
		|only if rep('Shado-Pan')>=Honored
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..accept The Challenger's Ring: Tenwu of the Red Smoke##31221
		|only if rep('Shado-Pan')>=Revered
	step
		goto 48.9,71.2
		.talk Tenwu of the Red Smoke##63616
		.' Ask him to meet you in the Challenger's Ring. |q 31221/1
		|only if havequest(31221)
	step
		goto 50.6,68.5
		.talk Tenwu of the Red Smoke##64471
		.' Let's see if you can back that talk up.
		.' Defeat Temwu of the Red Smoke |q 31221/2
		|only if havequest(31221)
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..turnin The Challenger's Ring: Tenwu of the Red Smoke##31221
		|only if havequest(31221)
	step
		goto 49.0,70.9
		.talk Hawkmaster Nurong##63618 |tip He walks around a bit.
		.' Ask him to meet you in the Challenger's Ring. |q 31220/1
		|only if havequest(31220)
	step
		goto 50.7,68.2
		.talk Hawkmaster Nurong##64470
		.' Let's go!
		.' Defeat Hawkmaster Nurong |q 31220/2
		|only if havequest(31220)
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..turnin The Challenger's Ring: Hawkmaster Nurong##31220
		|only if havequest(31220)
	step
		goto 49.0,71.3
		.talk Ling of the Six Pools##63614
		..accept Sra'vess Wetwork##31196 |or 4
		..accept The Bigger They Come...##31197 |or 4
		..accept A Morale Victory##31198 |or 4
		..accept Destroy the Siege Weapons!##31199 |or 4
		..accept Fumigation##31200 |or 4
		..accept Friends, Not Food!##31201 |or 4
	step
		'Talk to Hawkmaster Nurong or Taoshi and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		'Hawkmaster Nurong at [48.7,71.2] |modelnpc 63618
		'Taoshi at [48.7,71.0] |modelnpc 63617
		|confirm
		|only if not completedq(31221)
	step
		'Talk to Hawkmaster Nurong, Taoshi, or Tenwu of the Red Smoke and ask one of them to come with you. They will help you in combat and allow you to turn in your quests outside of this questing hub.
		'Hawkmaster Nurong at [48.7,71.2] |modelnpc 63618
		'Taoshi at [48.7,71.0] |modelnpc 63617
		'Tenwu of the Red Smoke [48.9,71.2] |modelnpc 63616
		|confirm
		|only if completedq(31221)
	step
		goto 48.7,71.1
		.talk Ku-Mo##65341
		..accept Seeking Father##30933
		.' If this quest is unavailable, click here. |confirm
		|only if not completedq(30933)
	step
		goto 27.5,54.6
		.click Sra'thik Siege Weapon##11683
		.' Small Southern Siege Weapon destroyed |q 31199/2
		|only if havequest(31199)
	step
		goto 25.8,53.8
		.click Sra'thik Siege Weapon##11683
		.' Large Southern Siege Weapon destroyed |q 31199/1
		|only if havequest(31199)
	step
		goto 23.5,55.5
		.click Sra'thik Idol##11724
		.' Southern Idol destroyed |q 31198/1
		|only if havequest(31198)
	step
		goto 21.5,49.2
		.click Sra'thik Idol##11724
		.' Central Idol destroyed |q 31198/3
		|only if havequest(31198)
	step
		goto 27.2,41.2
		.click Sra'thik Siege Weapon##11683
		.' Large Northern Siege Weapon destroyed |q 31199/3
		|only if havequest(31199)
	step
		goto 26.2,39.8
		.click Sra'thik Siege Weapon##11683
		.' Small Northern Siege Weapon destroyed |q 31199/4
		|only if havequest(31199)
	step
		goto 27.8,41.9
		.click Sra'thik Idol##11724
		.' Eastern Idol destroyed |q 31198/4
		|only if havequest(31198)
	step
		goto 23.6,44.7
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Egg Chamber bombed |q 31200/3
		|only if havequest(31200)
	step
		goto 22.0,41.6
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Torture Cell bombed |q 31200/4
		|only if havequest(31200)
	step
		goto 21.2,43.2
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Slaughtering Pit bombed |q 31200/5
		|only if havequest(31200)
	step
		goto 21.0,45.9
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Amber Vault bombed |q 31200/1
		|only if havequest(31200)
	step
		goto 16.2,45.8
		.click Sra'thik Idol##11724
		.' Western Idol destroyed |q 31198/2
		|only if havequest(31198)
	step
		goto 17.6,58.0
		.talk Shado-Pan Trainee##64459
		.' Tell them "No you're not!"
		.' Shado-Pan Trainee at Southern Feeding Pit freed. |q 31201/3
		|only if havequest(31201)
	step
		goto 17.4,57.0
		.talk Shado-Pan Trainee##64460
		.' Tell them "No you're not!"
		.' Shado-Pan Trainee at Southern Feeding Pit freed. |q 31201/2
		|only if havequest(31201)
	step
		goto 17.4,57.0
		.talk Sentinel Ku-Yao##61694
		.' Tell him his son has been looking for him.
		.' Search for Sentinel Ku-Yao. |q 30933/1
		|only if havequest(30933)
	step
		goto 18.0,53.5
		.talk Shado-Pan Trainee##64461
		.' Tell them "No you're not!"
		.' Shado-Pan Trainee at Southern Feeding Pit freed. |q 31201/1
		|only if havequest(31201)
	step
		goto 23.9,47.3
		'Use the Bag of Shado-Pan Gas Bombs at this location. |use Bag of Shado-Pan Gas Bombs##86532
		.' Nutriment Cell bombed |q 31200/2
		|only if havequest(31200)
	step
		goto Townlong Steppes/0 23.3,52.1
		'Make sure you have done the following around Sra'vess:
		.from Sra'thik Mutilator##63678+, Sra'thik Cacophyte##63680+, Sra'thik Drone##63677+, Sra'thik Regenerator##63681+, Sra'thik Swiftwing##63683+ |only if havequest(31196)
		.' Kill 15 Lesser Sra'thik mantid. |q 31196/1 |only if havequest(31196)
		.from Sra'thik Swarm-Leader##63685+, Sra'thik Vessguard##63686+, Sra'thik Will-Breaker##63684+, Sra'thik Deathmixer##63688+ |only if havequest(31197)
		.' Kill 4 Greater Sra'thik mantid. |q 31197/1 |only if havequest(31197)
	step
		'Next to you is either Hawkmaster Nurong or Taoshi
		.talk Taoshi##63617
		.talk Hawkmaster Nurong##63618
		..turnin Sra'vess Wetwork##31196
		..turnin The Bigger They Come...##31197
		..turnin A Morale Victory##31198
		..turnin Destroy the Siege Weapons!##31199
		..turnin Fumigation##31200
		..turnin Friends, Not Food!##31201
		|only if not completedq(31221)
	step
		'Next to you is either Hawkmaster Nurong, Taoshi, or Tenwu.
		.'Talk to Taoshi |modelnpc 63617
		.'Talk to Hawkmaster Nurong |modelnpc 63618
		.'Talk to Tenwu of the Red Smoke |modelnpc 63616
		..turnin Sra'vess Wetwork##31196
		..turnin The Bigger They Come...##31197
		..turnin A Morale Victory##31198
		..turnin Destroy the Siege Weapons!##31199
		..turnin Fumigation##31200
		..turnin Friends, Not Food!##31201
		|only if completedq(31221)
	step
		'Click the Quest Discovered box that displays on the right side of the screen under your minimap
		..accept Target of Opportunity: Sra'thik Hivelord##31204 |or
		..accept Target of Opportunity: Sra'thik Swarmlord##31203 |or
	step
		goto 16.4,40.9
		.kill Sra'thik Swarmlord##63693 |q 31203/1
		|only if havequest(31203)
	step
		goto Townlong Steppes 27.1,44.1
		'Enter the cave here |goto Townlong Steppes 27.1,44.1 |noway |c
		|only if havequest(31204)
	step
		goto 24.3,44.0
		.kill Sra'thik Hivelord##63694 |q 31204/1
		|only if havequest(31204)
	step
		goto 48.7,71.1
		.talk Ku-Mo##65341
		..turnin Seeking Father##30933
		|only if havequest(30933)
	step
		goto 49.0,71.4
		.talk Ling of the Six Pools##63614
		..turnin Target of Opportunity: Sra'thik Hivelord##31204 |or
		..turnin Target of Opportunity: Sra'thik Swarmlord##31203 |or
		|next "end"
/// Exalted Reputation
	step
	label end
		goto 48.8,70.6
		.talk Rushi the Fox##64595
		..buy 1 Grand Commendation of the Shado-Pan##93220 |n
		.' Use the Commendation of the Shado-Pan you just purchased. |condition ZGV:GetReputation("Shado-Pan").hasBonus |use Grand Commendation of the Shado-Pan##93220
		|only if rep("Shado-Pan")>=Revered
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..accept Mogu Incursions##31266
		|only if rep('Shado-Pan')==Exalted and not completedq(31266)
	step
		goto 48.8,58.6
		.kill Shan'ze Spymaster##63888 |q 31266/1
		|only if rep('Shado-Pan')==Exalted and not completedq(31266)
	step
		goto 49.4,70.6
		.talk Master Snowdrift##63009
		..turnin Mogu Incursions##31266
		..accept Surprise Attack!##31277
		|only if rep('Shado-Pan')==Exalted and not completedq(31277)
	step
		goto 42.6,63.9
		.talk Ban Bearheart##63908
		.' Tell him "Let's go".
		.' Join the battle of Niuzao Temple |q 31277/1
		|only if havequest(31277)
	step
		goto 41.3,60.0
		'Wait for the dialogue to end and fight off the invasion.
		.from Shan'ze Brutalizer##63933+
		.from Hei Feng##63920 |tip When he casts Deep Breath step behind him.
		.' Defeat the Mogu Invasion |q 31277/2
		|only if havequest(31277)
	step
		goto 49.2,71.0
		.talk Ban Bearheart##62304
		..turnin Surprise Attack!##31277
		|only if havequest(31277)
	step
		'You have reached the end of this daily guide.
		.' Click here to return to the start of the dailies. |next "shado_dailies" |confirm
]])

ZygorGuidesViewer:RegisterInclude("Golden_Lotus_PreQuests",[[
		goto Kun-Lai Summit 72,94.2
		.talk Wanderer Chu##64521
		..accept Temple of the White Tiger##31392
		|only if not completedq(31394)
	step
		goto 68.8,43.1
		.talk Anduin Wrynn##64540
		..turnin Temple of the White Tiger##31392 |only if not completedq(31394)
		..accept A Celestial Experience##31394
	step
		goto 68.9,42.8
		'Talk to Xuen |q 31394/1 |modelnpc Xuen##64528
		.from Spirit of Violence##64656
		.' Pass the First Test |q 31394/2
		.from Spirit of Anger##64684
		.' Pass the Second Test |q 31394/3
		.from Spirit of Hatred##64744
		.' Pass the Third Test |q 31394/4
	step
		goto 68.8,43.1
		.talk Anduin Wrynn##64540
		..turnin A Celestial Experience##31394
		..accept A Witness to History##31512 |or
		..accept A Witness to History##31511 |or
	step
		goto 55.5,91.3
		.talk Anduin Wrynn##64848
		.' Tell him "Let's find out!" |q 31512/1 |only if havequest(31512)
		.' Tell him "Let's find out!" |q 31511/1 |only if havequest(31511)
	step
		goto Vale of Eternal Blossoms/3 35.4,65.9
		.talk Matron Vi Vinh##64149
		..turnin A Witness to History##31511
		.' or
		..turnin A Witness to History##31512
]])

ZygorGuidesViewer:RegisterInclude("Golden_Lotus",[[
	step
	label "dailies"
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Kun Autumnlight##58920
		..accept Mantid Under Fire##30243
		..accept Bloodied Skies##30266
		|noquest
	step
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Anji Autumnlight##58919
		..accept The Thunder Below##30280
		..accept The Crumbling Hall##30277
		|noquest
	step
		goto Vale of Eternal Blossoms/0 20.1,75.6
		.talk Hai-Me Heavyhands##58962 |tip He walks around the Trainees in this area.
		..accept The Battle Ring##30306
	step
		goto Vale of Eternal Blossoms/0 18.5,71.6
		.talk Yumi Goldenpaw##58743
		..accept Survival Ring: Blades##30242
		..accept Survival Ring: Flame##30240
		|noquest
	step
		goto Vale of Eternal Blossoms/0 18.1,63.5
		.talk Kelari Featherfoot##58704
		..accept Roll Club: Serpent's Spine##30261
	step
		goto Vale of Eternal Blossoms/0 18.1,63.5
		.talk Kelari Featherfoot##58704
		.' Tell him: <Let's roll>. |q 30261/1
		|only if havequest(30261)
	step
		'Hold down your right mouse button to help you maneuver through the course. |tip Grab as many speed boosts as you can to make it go quicker.
		.' Complete the Serpent's Spine Roll Course. |q 30261/2
		|only if havequest(30261)
	step
		goto Vale of Eternal Blossoms/0 18.1,63.5
		.talk Kelari Featherfoot##58704
		..turnin Roll Club: Serpent's Spine##30261
		|only if havequest(30261)
	step
		goto Vale of Eternal Blossoms 19.7,74.2
		.from Shado-Pan Trainee##58992+
		.' Defeat 20 Shado-Pan Trainees. |q 30306/1
		|only if havequest(30306)
	step
		goto Vale of Eternal Blossoms 19.2,67.5
		.' Stay within the circle and avoid the posts with blades surrounding them and the running pandas.
		.' Live through the Survival Ring for 90 seconds |q 30242/1
		|only if havequest(30242)
	step
		goto 19.2,67.5
		.' Stay within the circle and avoid getting hit by the fireworks.
		.' Live through the Survival Ring for 90 seconds |q 30240/1
		|only if havequest(30240)
	step
		goto Vale of Eternal Blossoms 5.4,72.3
		.click Setting Sun Turret
		.' Mount a turret. |invehicle |c |tip It's on the upper level of the tower here.
		|only if havequest(30266)
	step
		.kill 30 Krik'thik Swarmer##63973+ |q 30266/1
		|only if havequest(30266)
	step
		'Click the Leave Vehicle button. |outvehicle
		|only if havequest(30266)
	step
		goto Vale of Eternal Blossoms 3.9,51.7
		.clicknpc Hot Oil Cauldron##64369
		.' Use the abilities on your hotbar to kill 80 Krik'thik Hivelings |q 30243/1 |tip Use the Ignitable Oil Bucket first, followed by the Shado-Pan Torch.
	step
		goto Vale of Eternal Blossoms 22.4,26.9
		'Traverse the following rooms by only stepping on the _green tiles_, other tiles will harm you.
		|confirm
		|only if havequest(30280) or havequest(30277)
	step
		goto Vale of Eternal Blossoms/19 53.9,68.3
		.kill Milau##64965 |q 30280/1 |tip Milau has several deadly abilities. He will cast a Lightning Breath in any direction, do not be in front of him when he does this. He also starts casting Lightning Pools, constantly move until he is done. Periodically he will pull you to the middle of the room and cast Lightning Sweep. While he is casting get as much distance on him as you can.
		|only if havequest(30280)
	step
		goto Vale of Eternal Blossoms/18 42.1,27.2
		.click Deactivate Final Spirit Wall
		.' Deactivate the Final Spirit Wall |q 30277/1
		|only if havequest(30277)
	step
		goto 49.4,30.6
		.click Ancient Guo-Lai Artifact
		.get Ancient Guo-Lai Artifact |q 30277/2
		|only if havequest(30277)
	step
		goto Vale of Eternal Blossoms/0 18.5,71.5
		.talk Yumi Goldenpaw##58743
		..turnin Survival Ring: Blades##30242
	step
		goto Vale of Eternal Blossoms/0 20.1,75.6
		.talk Hai-Me Heavyhands##58962 |tip He walks around the Trainees in this area.
		..turnin The Battle Ring##30306
	step
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Anji Autumnlight##58919
		..turnin The Thunder Below##30280
		..turnin The Crumbling Hall
	step
		goto Vale of Eternal Blossoms/0 21.4,71.6
		.talk Kun Autumnlight##58920
		..turnin Mantid Under Fire##30243
		..turnin Bloodied Skies##30266
	step
	label end
		'You have reached the end of the guide for today.
		.' Click here to go back to the beginning of the dailies. |confirm |next "dailies"
]])

ZygorGuidesViewer:RegisterInclude("Operation_Shieldwall_Daily",[[
		goto Vale of Eternal Blossoms 83.9,58.6
		.talk Lyalia##64610
		..accept Meet the Scout##32246 |tip This will be available upon entering Vale of Eternal Blossoms.
	step
		goto Krasarang Wilds 85.3,29.1
		.talk Scout Lynna##68311
		..turnin Meet the Scout##32246
	step
		goto Krasarang Wilds 85.3,29.1
		.talk King Varian Wrynn##61796
		..accept A King Among Men##32247
	step
		goto Krasarang Wilds 79.6,25.0
		.talk Marshal Troteman##68331
		.' Marshal Troteman found |q 32247/2
	step
		goto Krasarang Wilds 80.4,17.5
		.talk Hilda Hornswaggle##68312
		.' Hilda Hornswaggle found |q 32247/3
	step
		goto Krasarang Wilds 84.6,22.0
		.from Horde Raider##68332+, Horde Hunter##68334+, Horde Priest##67904+
		..kill 25 Horde |q 32247/1
	step
		.talk King Varian Wrynn##61796 |tip He is standing next to you.
		..turnin A King Among Men##32247
		..accept Lion's Landing##32109
	step
		goto Krasarang Wilds 85.6,29.1
		.click Flare Launcher##6544
		..turnin Lion's Landing##32109
//Lions landing Achievement ^
	step
		goto Krasarang Wilds 88.3,34.7
		.fpath Lion's Landing
	step
	label dailies
		goto Krasarang Wilds 89.7,33.1
		.talk Marshal Troteman##68331
		..accept Priorities, People!##32116 |next Ruins of Ogudei
		|noquest
	step
		goto Krasarang Wilds 89.8,32.4
		.talk Amber Kearnen##68908
		..accept Send A Message##32451 |or |next Skyfire
		..accept And Then There Were Goblins##32452 |or |next Skyfire
		|noquest
//Lions Landing
	step
		goto Krasarang Wilds 89.7,32.8
		.talk Mishka##67630
		..accept Resource Gathering##32149
		..accept Supply Block##32150
	step
		goto Krasarang Wilds 89.7,33.1
		.talk Marshal Troteman##68331
		..accept Attack! Move!##32148 |or 3
		..accept Tower Defense##32151 |or 3
		..accept Hero Killer##32153 |or 3
		..accept Siege Damage##32152 |or 3
	step
		goto Krasarang Wilds 76.8,19.2
		.from Bilgewater Sapper##67929+
		..get Bilgewater Blasting Cap |q 32152/1 |only if havequest(32152)
		..get 20 Animatable Stone |q 32151/1 |only if havequest(32151)
		|only if havequest(32152) or havequest(32151)
	step
		goto Krasarang Wilds 79.1,27.2
		'|modelnpc Mazuru##67646
		.' Kill a Horde Hero |q 32153/1
		|only if havequest(32153)
	step
		goto Krasarang Wilds 78.2,28.9
		.kill 8 Domination Point Supply Cart##67756+ |q 32150/1 |only if havequest(32150)
		.clicknpc Domination Point Demolisher##67671 |only if havequest(32152)
		.' Destroy a Domination Point Demolisher |q 32152/2 |only if havequest(32152)
		|only if havequest(32150) or havequest(32152)
	step
		goto Krasarang Wilds 77.0,24.3
		.from Dominance Shaman##67520+, Domination Point Raider##67826+
		.' Kill 12 Domination Point Shaman or Raider |q 32148/1
		.click Hastily Abandoned Lumber##1248
		.' Get 12 Lion's Landing Lumber |q 32149/1
		|only if havequest(32149) or havequest(32148)
	step
		goto Krasarang Wilds 89.7,32.8
		.talk Mishka##67630
		..turnin Resource Gathering##32149
		..turnin Supply Block##32150
	step
		goto Krasarang Wilds 89.7,33.1
		.talk Marshal Troteman##68331
		..turnin Attack! Move!##32148
		..turnin Tower Defense##32151
		..turnin Hero Killer##32153
		..turnin Siege Damage##32152 |or 3
		|next "friend1" |only if repval('Operation: Shieldwall','Friendly')>=950 and not completedq(32426)
		|next "friend2" |only if repval('Operation: Shieldwall','Friendly')>=4500 and not completedq(32383)
		|next "honored1" |only if repval('Operation: Shieldwall','Honored')>=2850 and not completedq(32362)
		|next "honored2" |only if repval('Operation: Shieldwall','Honored')>=6800 and not completedq(32243)
		|next "honored3" |only if repval('Operation: Shieldwall','Honored')>=10750 and not completedq(32316)
		|next "revered1" |only if repval('Operation: Shieldwall','Revered')>=2700 and not completedq(32371)
		|next "revered2" |only if repval('Operation: Shieldwall','Revered')>=6650 and not completedq(32393)
		|next "revered3" |only if repval('Operation: Shieldwall','Revered')>=8665 and not completedq(32423)
		|next "revered4" |only if repval('Operation: Shieldwall','Revered')>=15500 and not completedq(32335)
		|next "revered5" |only if repval('Operation: Shieldwall','Revered')>=18500 and not completedq(32338)
		|next "exalted" |only if rep("Operation: Shieldwall")==Exalted
		|next "endg" |only if default
// The Skyfire
	step
	label Skyfire
		goto Krasarang Wilds 89.1,33.9 |n
		.' Click the portal to the _Skyfire_. |goto Krasarang Wilds 18.1,79.6 <5 |noway|c
		.' If the portal isn't available, click here. |confirm
	step
		goto Krasarang Wilds 16.5,79.2
		.talk Sky Admiral Rogers##67386
		..turnin Send A Message##32451
		..turnin And Then There Were Goblins##32452
		..accept Hammer to Fall##32146
		..accept We Will Rock You##32142
		..accept The Only Good Goblin...##32157
		|confirm
	step
		.talk Tinkmaster Overspark##67976
		..accept A Kind of Magic##32143
		|confirm
	step
		goto Krasarang Wilds/0 16.7,78.6
		.talk Mishka##54614
		..accept Under Pressure##32144 |or
		..accept It's Only Right##32156 |or
	step
		goto Krasarang Wilds 16.7,78.6
		.talk Seraphine of the Winter##68182
		..accept Two Step Program##32158 |or
		..accept Undermining the Under Miner##32433 |or
		|confirm
	step
		goto Krasarang Wilds 16.9,78.6
		.talk Sully "The Pickle" McLeary##54616
		..accept Burn Out!##32154 |or 2
		..accept Dis-Assembly Required##32446 |or 2
		..accept Circle of Life##32159 |or 2
		|confirm
	step
		goto Krasarang Wilds 11.6,67.9
		.clicknpc Scout-o-Meter Mk I##67544
		.' Eliminate the Beachhead Demolishers |q 32143/1
		|only if havequest(32143)
	step
		goto Krasarang Wilds 10.8,60.9
		.' click the Scout-o-Meter Mk II
		.' Eliminate the Horde Wolves |q 32143/2
		|only if havequest(32143)
	step
		goto Krasarang Wilds/0 12.7,56.6
		.' click the Scout-o-Meter Mk III
		.' Destroy the Horde Bomb Stockpile |q 32143/3
		|only if havequest(32143)
	step
		'Click the quest complete box on the top right of the screen.
		..turnin A Kind of Magic##32143
		..accept Don't Lose Your Head##32145
		|only if havequest(32143) or completedq(32143)
	step
		goto Krasarang Wilds 10.8,58.1
		..kill 1 Or'Dac##67435 |q 32145/1
		|only if havequest(32145)
	step
		goto Krasarang Wilds 13.4,56.3
		..kill 1 Chief Bombgineer Snicklefritz##67427 |q 32145/3
		|only if havequest(32145)
	step
		goto Krasarang Wilds/0 13.4,57.9
		..kill 1 Stone Guard Ruk'Ra##67429 |q 32145/2
		|only if havequest(32145)
	step
		goto Krasarang Wilds 11.9,60.4
		.click Horde Supply Crate##335
		..get 8 Horde Supply Crates Destroyed |q 32144/1
		..kill 5 Heavy Mook##67399+ |q 32146/1
		..kill 10 Domination Orc##67357+ |q 32142/1
		|only if havequest(32146) or havequest(32142)
	step
		goto Krasarang Wilds/0 15.3,59.1
		.' Use your _Unstable Explosives_. |use Unstable Explosive##93187
		.' Northwestern Fuel Tank destroyed |q 32154/3
		|only if havequest(32154)
	step
		goto Krasarang Wilds 19.6,62.1
		..kill 1 Shredmaster Packle##67371 |q 32158/1
		|only if havequest(32158)
	step
		goto Krasarang Wilds/0 19.0,61.4
		.from Jungle Shredder##67285+
		.' Use your _Re-Configured Remote_ on Jungle Shredders. |use Re-Configured Remote##93180
		..get 6 Scrap Metal |q 32446/1
		|only if havequest(32446)
	step
		goto Krasarang Wilds 22.2,61.3
		.kill Grezik Oregrind##67373 |q 32433/1
		|only if havequest(32433)
	step
		goto Krasarang Wilds 19.9,60.4
		.' Click on mounds of dirt in the area.
		.' Plant 11 Energized Seeds |q 32159/1
		|only if havequest(32159)
	step
		goto Krasarang Wilds/0 25.4,59.5
		.' Use your _Unstable Explosives_. |use Unstable Explosive##93187
		.' Northeastern Fuel Tank destroyed |q 32154/1
		|only if havequest(32154)
	step
		goto Krasarang Wilds/0 23.9,54.6
		.' Use your _Unstable Explosives_. |use Unstable Explosive##93187
		.' Northern Fuel Tank destroyed |q 32154/2
		|only if havequest(32154)
	step
		goto Krasarang Wilds/0 24.6,56.6
		..kill 10 Bilgewater Goblins |q 32157/1
		.clicknpc Fallen Shieldwall Soldier##68700
		.' Get 7 Shieldwall Soldier Dog Tags |q 32156/1
		'|modelnpc 67281
		'|modelnpc 67283
		'|modelnpc 67637
		|only if havequest(32157) or havequest(32156)
	step
		goto Krasarang Wilds/0 16.7,78.6
		.talk Mishka##54614
		..turnin Under Pressure##32144
		..turnin It's Only Right##32156
	step
		goto Krasarang Wilds 16.7,78.6
		.talk Seraphine of the Winter##68182
		..turnin Two Step Program##32158
		..turnin Undermining the Under Miner##32433
	step
		goto Krasarang Wilds 16.9,78.6
		.talk Sully "The Pickle" McLeary##54616
		..turnin Burn Out!##32154
		..turnin Dis-Assembly Required##32446
	step
		goto Krasarang Wilds 16.5,79.2
		.talk Sky Admiral Rogers##67386
		..turnin Hammer to Fall##32146
		..turnin We Will Rock You##32142
		..turnin The Only Good Goblin...##32157
	step
		.talk Tinkmaster Overspark##67976
		..turnin A Kind of Magic##32143
		..turnin Don't Lose Your Head##32145
		|next "friend1" |only if repval('Operation: Shieldwall','Friendly')>=950 and not completedq(32426)
		|next "friend2" |only if repval('Operation: Shieldwall','Friendly')>=4500 and not completedq(32383)
		|next "honored1" |only if repval('Operation: Shieldwall','Honored')>=2850 and not completedq(32362)
		|next "honored2" |only if repval('Operation: Shieldwall','Honored')>=6800 and not completedq(32243)
		|next "honored3" |only if repval('Operation: Shieldwall','Honored')>=10750 and not completedq(32316)
		|next "revered1" |only if repval('Operation: Shieldwall','Revered')>=2700 and not completedq(32371)
		|next "revered2" |only if repval('Operation: Shieldwall','Revered')>=6650 and not completedq(32393)
		|next "revered3" |only if repval('Operation: Shieldwall','Revered')>=8665 and not completedq(32423)
		|next "revered4" |only if repval('Operation: Shieldwall','Revered')>=15500 and not completedq(32335)
		|next "revered5" |only if repval('Operation: Shieldwall','Revered')>=18500 and not completedq(32338)
		|next "exalted" |only if rep("Operation: Shieldwall")==Exalted
		|next "endg" |only if default
// Ruins of Ogudei
	step
	label Ruins of Ogudei
		goto Krasarang Wilds 80.3,17.6 |n
		.' Enter the Ruins of Ogudei. |goto Krasarang Wilds/0 80.3,17.6 <5 |noway|c
		|only if havequest(32116)
	step
		goto Krasarang Wilds/1 30.1,27.5
		.talk Hilda Hornswaggle##68312
		..turnin Priorities, People!##32116
		..accept The Spirit Trap##32121 |or 5
		..accept Shackles of the Past##32115 |or 5
		..accept Eviction Notice##32347 |or 5
		..accept Oi Ain't Afraid o' No Ghosts!##32346 |or 5
		..accept Ogudei's Lieutenants##32122 |or 5
		..accept It Is A Mystery##32119 |or 5
		|only if havequest(32116) or completedq(32116)
	step
		.' Go down the steps here. |goto Krasarang Wilds/1 66.1,50.4 |c
	step
		'Walk around this cave and pay attention to your Anamoly Reader above your actionbars. This quest is like a "Hot & Cold" game, where the closer you get, the greater anamoly reading you get. Once you have 100%, you will automatically disperse the anamoly.
		.' Disperse the anamoly |q 32119/1
		|only if havequest(32119)
	step
		goto Krasarang Wilds/2 50.3,26.7
		..kill 12 Spiritbound Arcanist##68070+ |q 32346/1 |only if havequest(32346)
		.from Troubled Slave Spirit##68074+ |only if havequest(32115)
		.' 14 Troubled Slave Spirits released |q 32115/1 |only if havequest(32115)
	step
		goto Krasarang Wilds/2 72.7,15.4
		.from Spirit Trap##68061+
		..goal 3 Spirit Trap destroyed |q 32121/1
	step
		.' Go down the steps here. |goto Krasarang Wilds/2 62.4,39.0 |c
	step
		goto Krasarang Wilds/3 66.3,48.3
		.from Reliquary Scout##67861+, Reliquary Blood Knight##68126+, Reliquary Mage##68114+
		.' Kill 10 Reliquary |q 32347/1
	step
		.' Go up the path here. |goto Krasarang Wilds/3 79.8,43.4 |c
	step
		.' Go down the path here. |goto Krasarang Wilds/2 72.7,41.5 |c
	step
		goto Krasarang Wilds/2 67.4,81.0
		.kill Gen-li, Twister of Words##68169 |q 32122/1
		.kill Meng-do, Strength of Mountains##68170 |q 32122/2
	step
		.' Go up the steps here. |goto Krasarang Wilds/2 56.4,38.9 |c
	step
		goto Krasarang Wilds/1 30.1,27.5
		.talk Hilda Hornswaggle##68312
		..turnin The Spirit Trap##32121
		..turnin Shackles of the Past##32115
		..turnin Eviction Notice##32347
		..turnin Oi Ain't Afraid o' No Ghosts!##32346
		..turnin Ogudei's Lieutenants##32122
		..turnin It Is A Mystery##32119
		|next "friend1" |only if repval('Operation: Shieldwall','Friendly')>=950 and not completedq(32426)
		|next "friend2" |only if repval('Operation: Shieldwall','Friendly')>=4500 and not completedq(32383)
		|next "honored1" |only if repval('Operation: Shieldwall','Honored')>=2850 and not completedq(32362)
		|next "honored2" |only if repval('Operation: Shieldwall','Honored')>=6800 and not completedq(32243)
		|next "honored3" |only if repval('Operation: Shieldwall','Honored')>=10750 and not completedq(32316)
		|next "revered1" |only if repval('Operation: Shieldwall','Revered')>=2700 and not completedq(32371)
		|next "revered2" |only if repval('Operation: Shieldwall','Revered')>=6650 and not completedq(32393)
		|next "revered3" |only if repval('Operation: Shieldwall','Revered')>=8665 and not completedq(32423)
		|next "revered4" |only if repval('Operation: Shieldwall','Revered')>=15500 and not completedq(32335)
		|next "revered5" |only if repval('Operation: Shieldwall','Revered')>=18500 and not completedq(32338)
		|next "exalted" |only if rep("Operation: Shieldwall")==Exalted
		|next "endg" |only if default
//First Quest Chain
	step
	label "friend1"
		goto Krasarang Wilds 89.5,32.6
		.talk Admiral Taylor##67940
		..accept The Best Around##32380
		|only if repval('Operation: Shieldwall','Friendly')>=950 and not completedq(32426)
	step
		.' Bizmo's Brawlpub Located |q 32380/1
		.' Go down the ramp here. |goto Deeprun Tram/1 52.2,42.4 |c
		|only if havequest(32380)
	step
		goto Deeprun Tram/2 70.3,46.5
		.talk Barkeep Townsley##68526
		.' Ask her if she is the agent following Connelly.
		.' Agent Townsley located |q 32380/2
		..turnin The Best Around##32380
		..accept To Catch A Spy##32381
		|only if not completedq(32426)
	step
		goto Deeprun Tram/2 70.7,46.5
		.talk Barkeep Townsley##68526
		.' Tell her you're ready for the first clue.
		.'  Find Keith and talk to him here. [Deeprun Tram/2 64.8,22.7].
		.talk Keith "The Party" Westin##3001
		.' Pink Marmot delivered |q 32381/1
		|only if havequest(32381)
	step
		goto Deeprun Tram/2 70.1,47.2
		.talk Barkeep Townsley##68526
		.' Tell her you're ready for the second clue.
		.'  [Deeprun Tram/2 49.7,33.6]
		.talk Twix Gearspark##68540
		.' Rusty Dagger delivered |q 32381/2
		|only if havequest(32381)
	step
		goto Deeprun Tram/2 70.1,47.2
		.talk Barkeep Townsley##68526
		.' Tell her you're ready for the thrid clue.
		.' [Deeprun Tram/2 66.9,59.7]
		.talk Tasha Windpaw##68539
		.' Pink Marmot delivered |q 32381/3
		|only if havequest(32381)
	step
		goto Deeprun Tram/2 70.1,47.2
		.talk Barkeep Townsley##68526
		..turnin To Catch A Spy##32381
		..accept Stirred, Not Shaken##32426
		|only if not completedq(32426)
	step
		.' Go up the ramp here. |goto Deeprun Tram/2 31.7,19.7 |c
		|only if havequest(32426)
	step
		goto Deeprun Tram/2 26.3,79.3
		.' Professor Kilt located |q 32426/1
		|only if havequest(32426)
	step
		goto Deeprun Tram/2 24.5,81.4
		.talk Professor Kilt##68531
		..turnin Stirred, Not Shaken##32426
		|only if havequest(32426)
		|next endg
// 4500 Rep
	step
	label "friend2"
		goto Krasarang Wilds/0 89.6,32.6
		.talk Admiral Taylor##67940
		..accept He's In Deep##32382
		|only if repval('Operation: Shieldwall','Friendly')>=4500 and not completedq(32383)
	step
		goto Krasarang Wilds 88.3,34.2
		.talk Fennie Hornswaggle##68741
		.' Ask her to take you to Fire Camp Bataar.
		.' Find Connelly in Kun-Lai Summit |q 32382/1
		|only if havequest(32382)
	step
		goto Kun-Lai Summit 59.2,84.3
		.talk Cousin Goottooth##68417
		..turnin He's In Deep##32382
		..accept Bugging Out##32383
		..accept He Won't Even Miss It##32397
		|only if not completedq(32383) or not completedq(32397)
	step
		.' Use your Grummle Disguise Kit. |use Grummle Disguise Kit##92950
		.' Pay attention for _Nero_ the wolf. It will see through your costume.
		goto Kun-Lai Summit 58.6,83.8
		.clicknpc Shaggy Longhorn##2877
		.' Garrosh distracted |q 32397/1
		|only if havequest(32397)
	step
		goto Kun-Lai Summit 58.4,84.0
		.clicknpc Mogu Statue##68913
		.' Large Tent bugged. |q 32383/1
		|only if havequest(32383)
	step
		goto Kun-Lai Summit 58.3,84.2
		.' Click the Weathered Jounral on the edge of the table.
		..get Weathered Journal |q 32397/2
		|only if havequest(32397)
	step
		goto Kun-Lai Summit 58.0,84.6
		.clicknpc Mogu Statue##68913
		.' Small Tent bugged. |q 32383/2
		|only if havequest(32383)
	step
		goto Kun-Lai Summit 58.2,85.0
		.clicknpc Mogu Statue##68913
		.' Supplies bugged. |q 32383/3
		|only if havequest(32383)
	step
		goto Kun-Lai Summit 59.3,84.3
		.talk Cousin Goottooth##68417
		..turnin Bugging Out##32383
		..turnin He Won't Even Miss It##32397
		|only if havequest(32383) or havequest(32397)
		|next endg
// 2850 Honoroed
	step
	label "honored1"
		goto Krasarang Wilds 89.6,32.6
		.talk Admiral Taylor##67940
		..accept The Kirin Tor##32331
		|only if repval('Operation: Shieldwall','Honored')>=2850 and not completedq(32362)
	step
		goto Krasarang Wilds 89.2,33.6 |n
		.' Use the Portal to The Purple Parlor |q 32331/1 |tip Make sure you use this portal rather than going to the dungeon yourself, this is a phased version of Dalaran, so you must use the portal to go through.
		|only if havequest(32331)
	step
		goto 924/1 26.7,39.0
		.talk Anduin Wrynn##68106
		..turnin The Kirin Tor##32331
		..accept The Fate of Dalaran##32362
		|only if not completedq(32362)
	step
		goto 924/1 26.7,39.3
		'|modelnpc Lady Jaina Proudmoore##68651
		.' Speak with Jaina Proudmoore. |q 32362/1
		|only if havequest(32362)
	step
		goto 924/1 26.8,39.0
		.talk Anduin Wrynn##68106
		..turnin The Fate of Dalaran##32362
		|only if havequest(32362)
	step
		goto 924/1 22.7,39.6
		.' Click the portal to send you back to Lion's Landing. |goto Krasarang Wilds /0 89.0,33.6 |noway |c
		|next endg
// 6800 Honored
	step
	label "honored2"
		goto Krasarang Wilds 89.6,32.6
		.talk Admiral Taylor##67940
		..accept To Mogujia##32193
		|only if repval('Operation: Shieldwall','Honored')>=6800 and not completedq(32243)
	step
		goto Krasarang Wilds 88.3,34.3
		.talk Fennie Hornswaggle##68741
		.' Ask her to take you Mogujia.
		.' Find Brann Bronzebeard |q 32193/1
		|only if havequest(32193)
	step
		goto Kun-Lai Summit 59.8,76.0
		.talk Brann Bronzebeard##67682
		..turnin To Mogujia##32193
		|only if havequest(32193)
	step
		goto Kun-Lai Summit 59.8,76.0
		.talk Hilda Hornswaggle##67716
		..accept The Source of Korune Power##32243
		|only if not completedq(32243)
	step
		goto Kun-Lai Summit 60.0,75.3
		.talk Sarannha Skyglaive##67734
		..accept Bad Blood##32194
		|only if not completedq(32243)
	step
		goto Kun-Lai Summit 58.1,71.0
		.from Korune Spellweaver##68815
		..get Sha-Touched Claw |q 32243/1
		|only if havequest(32243)
	step
		goto Kun-Lai Summit 58.5,74.5
		.from Silvermoon Runeseeker##67806+, Dominance Mage##67804+, Dominance Knight##67805+
		..get 5 Korune Artifact |q 32194/1
		|only if havequest(32194)
	step
		goto Kun-Lai Summit 60.0,75.3
		.talk Sarannha Skyglaive##67734
		..turnin Bad Blood##32194
		|only if havequest(32194)
	step
		goto Kun-Lai Summit 59.8,76.0
		.talk Hilda Hornswaggle##67716
		..turnin The Source of Korune Power##32243
		|only if havequest(32243)
		|next endg
// 10,750 Honoroed
	step
	label "honored3"
		goto Krasarang Wilds 89.6,32.6
		.talk Admiral Taylor##67940
		..accept Anduin's Plea##32315
		|only if repval('Operation: Shieldwall','Honored')>=10750 and not completedq(32316)
	step
		goto Krasarang Wilds 88.3,34.3
		.talk Fennie Hornswaggle##68741
		.' Ask her to take you to Shrine of Seven Stars. |goto Vale of Eternal Blossoms |noway|c
		|only if havequest(32315)
	step
		goto Vale of Eternal Blossoms/4 65.8,32.9
		.talk Anduin Wrynn##67948
		.' Find Anduin |q 32315/1
		..turnin Anduin's Plea##32315
		..accept Heart Of The Alliance##32316
		|only if not completedq(32316)
	step
		.' Walk around the shrine clicking Sha-Touched Footmen.
		.from Sha-Touched Footman##68006+
		. 6 Sha-Touched Footmen saved |q 32316/1
		|only if havequest(32316)
	step
		goto Vale of Eternal Blossoms/4 67.4,43.5
		.talk King Varian Wrynn##68242
		..turnin Heart Of The Alliance##32316
		|only if havequest(32316)
		|next endg
// 2700 Revered
	step
	label "revered1"
		goto Krasarang Wilds 89.6,32.6
		.talk Admiral Taylor##67940
		..accept The Kun-Lai Expedition##32370
		|only if repval('Operation: Shieldwall','Revered')>=2700 and not completedq(32371)
	step
		goto Krasarang Wilds 88.3,34.3
		.talk Fennie Hornswaggle##68741
		.' Ask her to fly you to Garrash'ar Advance.
		.' Find Connelly at the Grummle Bazaar |q 32370/1
		|only if havequest(32370)
	step
		goto Kun-Lai Summit 65.0,60.8
		.talk Agent Connelly##68375
		..turnin The Kun-Lai Expedition##32370
		..accept A Kor'kron In Our Midst##32377
		|only if not completedq(32371)
	step
		goto Kun-Lai Summit 60.9,57.7
		.from Kor'kron Reaver##68367, Kor'Kron Honor Guard##68369, Kor'Kron Scout##68368
		.collect Kor'kron Helmet##92763 |n
		.collect Kor'kron Armor##92764 |n
		.collect Kor'kron Boots##92765 |n
		.' Once you've collected all 3, click on them to create a Kor'Kron Disguise. |use Kor'Kron Helmet##92763
		.' Obtain a Kor'Kron Disguise. |q 32377/1
		|only if havequest(32377)
	step
		.' Click the auto complete quest box that pops up in the top right corner.
		..turnin A Kor'kron In Our Midst##32377
		..accept Memory Wine##32371
		|only if not completedq(32371)
	step
		.' Use your Kor'kron Disguise. |q 32371/1 |use Kor'kron Disguise##92766
		|only if havequest(32371)
	step
		goto Kun-Lai Summit 60.4,55.2
		.click Memory Wine##13445
		.' Drink Memory Wine |q 32371/2
		.' Witness Shan Kien's Past |q 32371/3
		|only if havequest(32371)
	step
		goto Kun-Lai Summit 65.0,60.8
		.talk Agent Connelly##68375
		..turnin Memory Wine##32371
		|only if havequest(32371)
		|next endg
// 6650 Revered
	step
	label "revered2"
		goto Krasarang Wilds/0 89.6,32.6
		.talk Admiral Taylor##67940
		..accept The Ruins of Korune##32393
		|only if repval('Operation: Shieldwall','Revered')>=6650 and not completedq(32393)
	step
		goto Krasarang Wilds 88.3,34.3
		.talk Fennie Hornswaggle##68741
		.' Ask her to take you to the Ruins of Korune.
		.' Find Sarannha Skyglaive at the Ruins of Korune |q 32393/1
		|only if havequest(32393)
	step
		goto Kun-Lai Summit 32.8,26.3
		.talk Sarannha Skyglaive##67734
		..turnin The Ruins of Korune##32393
		..accept The Divine Bell##32394
		|only if havequest(32393) or not completedq(32394)
	step
		goto Kun-Lai Summit 33.1,26.7  |n
		.' Enter the Ruins of Korune |goto Kun-Lai Summit/20 |noway|c
		|only if havequest(32394)
	step
		goto Kun-Lai Summit/20 48.2,41.3
		.' Watch the dialog, then follow _Dreadweaver Avartu_, killing Kor'kron Tomb Guardians afterwards.
		|confirm
		|only if havequest(32394)
	step
		.' Run through the hallway, avoiding the glowing white marks on the ground. |goto Kun-Lai Summit/20 36.3,79.3 |c
		|only if havequest(32394)
	step
		.' Go down the steps here. |goto Kun-Lai Summit/21 33.6,76.9 |c
		|only if havequest(32394)
	step
		.' Fight your way up the steps here. |goto Kun-Lai Summit/21 65.1,44.8 |c
		|only if havequest(32394)
	step
		goto Kun-Lai Summit/21 56.2,31.3
		.from Dreadweaver Avartu##68504 |q 32394/1
		|only if havequest(32394)
	step
		goto Kun-Lai Summit/21 60.8,22.4
		.' Recover the Divine Bell |q 32394/2
		|only if havequest(32394)
	step
		goto Kun-Lai Summit/21 62.5,25.8
		.talk Sarannha Skyglaive##67734
		..turnin The Divine Bell##32394
		|only if havequest(32394)
		|next endg |only if default
		|next |only if repval('Operation: Shieldwall','Revered')>=8665
// 8665 Revered
	step
	label "revered3"
		goto Krasarang Wilds/0 89.6,32.6
		.talk Admiral Taylor##67940
		..accept Darnassus Attacked?##32414
		|only if repval('Operation: Shieldwall','Revered')>=8665 and not completedq(32423)
	step
		goto Krasarang Wilds/0 89.0,33.6
		.talk Seamus Goldenkicks##67848 |q 32414/1
		.' Ask him to snd you to Darnassus. |goto Darnassus
	step
		goto Darnassus/0 39.0,32.7
		.talk Lady Jaina Proudmoore##68651
		..turnin Darnassus Attacked?##32414
		..accept Tracking the Thieves##32460
		|only if not completedq(32423)
	step
		.' There will be white orbs that appear.
		.' They will form a path as you follow them.
		.' Track the Thieves |q 32460/1
		|only if havequest(32460)
	step
		goto Teldrassil/0 40.0,50.5
		.talk Lady Jaina Proudmoore##68651
		..turnin Tracking the Thieves##32460
		..accept Jaina's Resolution##32416
		|only if havequest(32460) or not completedq(32416)
	step
		.' Click the portal to Dalaran. |q 32416/1
		|tip It should be next to you
		|only if havequest(32416)
	step
		.' There will be a short cutscene. Afterwards, speak with _Vereesa_.
		goto 924/1 34.2,48.8
		.talk Vereesa Windrunner##68687
		..turnin Jaina's Resolution##32416
		..accept Nowhere to Run##32421
		..accept Nowhere to Hide##32419
		..accept Sewer Cleaning##32417
		..accept Unfair Trade##32418
		..accept Cashing Out##32420
		|only if not completedq(32423)
	step
		goto 924/1 70.0,43.5
		.from Sunreaver Dragonhawk##68762
		.' Render 5 Sunreaver Dragonhawks incapable of flying. |q 32421/1
		|only if havequest(32421)
	step
		goto 41.4,36.2
		.kill Inkmaster Aelon##68752 |q 32418/1
		|only if havequest(32418)
	step
		goto 36.7,33.4
		.kill Sintharia Cinderweave##68755 |q 32418/4
		|only if havequest(32418)
	step
		goto 39.3,25.3
		.kill Gearmage Astalon |q 32418/3
		|only if havequest(32418)
	step
		goto 43.9,26.3
		.kill Tolyria##68754 |q 32418/2
		|only if havequest(32418)
	step
		goto 53.5,15.6
		.kill Magister Brasael##68751 |q 32420/1
		|only if havequest(32420)
	step
		goto 58.7,31.9
		.' Slay 16 Sunreavers in the Sunreaver's Sanctuary |q 32419/1
		'|modelnpc 68051
		'|modelnpc 68761
		'|modelnpc 68760
		|only if havequest(32419)
	step
		goto 48.0,32.6 |n
		.' Jump down the well here. |goto 924/2 |noway|c
		|only if havequest(32417)
	step
		goto 924/2 50.2,47.0
		.' Slay 12 Sunreavers in the Dalaran Sewers |q 32417/1
		'|modelnpc 68756
		'|modelnpc 68758
		'|modelnpc 68757
		|only if havequest(32417)
	step
		goto 924/1 34.3,48.6
		.talk Vereesa Windrunner##68687
		..turnin Nowhere to Run##32421
		..turnin Nowhere to Hide##32419
		..turnin Sewer Cleaning##32417
		..turnin Unfair Trade##32418
		..turnin Cashing Out##32420
		..accept What Had To Be Done##32423
		|only if not completedq(32423)
	step
		goto Krasarang Wilds 87.8,33.0
		.talk King Varian Wrynn##68690
		..turnin What Had To Be Done##32423
		|only if havequest(32423)
		|next endg
// 15,500 Revered
	step
	label "revered4"
		goto Krasarang Wilds/0 89.6,32.6
		.talk Admiral Taylor##67940
		..accept The Harmonic Mallet##32355
		|only if repval('Operation: Shieldwall','Revered')>=15500 and not completedq(32335)
	step
		goto Krasarang Wilds 88.3,34.3
		.talk Fennie Hornswaggle##68741
		.' Ask her to take you to the Valley of Emperors.
		.' Find Anduin at the Tomb of Conquerors |q 32355/1
		|only if havequest(32355) or not completedq(32335)
	step
		goto Kun-Lai Summit 53.0,46.4
		.talk Anduin Wrynn##68004
		..turnin The Harmonic Mallet##32355
		..accept The Monkey King##32321
		|only if not completedq(32335)
	step
		goto Kun-Lai Summit 53.0,46.4
		.' Talk with Anduin Wrynn |q 32321/1
		.' Ask him why he is here.
		'|modelnpc 68004
		|only if havequest(32321) or not completedq(32335)
	step
		.' Enter the Tomb of Conquerors. |goto Kun-Lai Summit/17 88.1,54.6 <5 |c
		|only if havequest(32321) or not completedq(32335)
	step
		.' Follow Anduin through the Tomb.
		.' Escort Anduin Wrynn. |q 32321/2
		'|modelnpc 68004
		|only if havequest(32321) or not completedq(32335)
	step
		.' Anduin will cast a spell, releasing _The Monkey King_ as well as _The Jade Warlord_.
		.from The Jade Warlord##68005
		.' Release The Monkey King |q 32321/3
		|only if havequest(32321) or not completedq(32335)
	step
		.talk The Monkey King##68003 |tip He should be standing at the center of the room next to Anduin.
		..turnin The Monkey King##32321
		..accept The First Riddle: Mercy##32332
		..accept The Second Riddle: Fellowship##32333
		..accept The Third Riddle: Strength##32334
		|only if not completedq(32335)
	step
		.' Go down the ramp here. |goto Kun-Lai Summit/0 68.9,45.5 <5 |c
		|only if havequest(32334) or not completedq(32335)
	step
		goto Kun-Lai Summit/0 70.1,45.6
		.talk The Monkey King##68538
		.' Tell him that you challange him.
		.' Challenger defeated |q 32334/1
		|only if havequest(32334) or not completedq(32335)
	step
		goto The Jade Forest 33.4,34.2
		.' Ring the Gong of Fellowship. |q 32333/1
		.from Sam the Wise##64694 |q 32333/2
		.' Click the keg that appears after you defeat him.
		.get The Metal Brew##92557 |q 32333/3
		|only if havequest(32333) or not completedq(32335)
	step
		goto Dread Wastes 65.7,71.7
		.click Untamed Amber##11644
		.from Untamed Ambertail##68117
		.get Untamed Amber##92539 |q 32332/1
		|only if havequest(32332) or not completedq(32335)
	step
		goto Krasarang Wilds 88.8,31.8
		.talk The Monkey King##68538
		..turnin The First Riddle: Mercy##32332
		..turnin The Second Riddle: Fellowship##32333
		..turnin The Third Riddle: Strength##32334
		..accept The Greatest Prank##32335
		|only if not completedq(32335)
	step
		.' Listen to The Monkey King's story. |q 32335/1
		|only if havequest(32335) or not completedq(32335)
	step
		goto Krasarang Wilds/0 89.0,31.7
		.talk Anduin Wrynn##68004
		..turnin The Greatest Prank##32335
		|only if havequest(32335)
		|next endg |only if default
		|next |only if repval('Operation: Shieldwall','Revered')>=18500
// 18,500 Revered
	step
	label "revered5"
		goto Krasarang Wilds 88.8,31.8
		.talk The Monkey King##68538
		..accept The Handle##32336
		..accept The Head##32337
		..accept The Harmonic Ointment##32338
		|only if repval('Operation: Shieldwall','Revered')>=18500 and not completedq(32338)
	step
		goto Krasarang Wilds 43.6,86.0
		.talk Chief Ingoo Ingoo XVII##68545
		.' Tell him that's the real monkey king.
		.from Chief Ingoo Ingoo XVII##68545
		.get Mallet Handle##92561 |q 32336/1
		|only if havequest(32336)
	step
		oto Krasarang Wilds/0 43.4,86.6
		.talk The Monkey King##68544
		.turnin The Handle##32336
		|only if not completedq(32337) and not completedq(32338) and not completedq(32336)
	step
		goto Valley of the Four Winds 23.0,30.6
		.talk Royal Finder##68554
		.' Find the Royal Finder |q 32337/1
		|only if havequest(32337)
	step
		goto 24.8,28.2 |tip Inside of the tunnel entrance.
		.from Skiggit##68547
		.click Mallet Head##13458
		.get Mallet Head##92560 |q 32337/2
		|only if havequest(32337)
	step
		goto Townlong Steppes 62.6,34.0
		.from The Blade##61010
		.get Harmonic Ointment##92562 |q 32338/1
		|only if havequest(32338)
	step
		goto Krasarang Wilds 88.8,31.8
		.talk The Monkey King##68538
		..turnin The Head##32337
		..turnin The Harmonic Ointment##32338
		|only if havequest(32337) or havequest(32338)
		|next endg |only if default
		|next "exalted" |only if repval('Operation: Shieldwall','Exalted')>=1
// Exalted
	step
	label "exalted"
		goto Krasarang Wilds/0 89.6,32.6
		.talk Admiral Taylor##67940
		..accept The Bell Speaks##32400
		|only if repval('Operation: Shieldwall','Exalted')>=1 and not completedq(32455)
	step
		goto Krasarang Wilds 88.3,34.3
		.talk Fennie Hornswaggle##68741
		.' Ask her to take you to Emperor's Reach.
		.' Find Anduin at Emperor's Reach |q 32400/1
		|only if havequest(32400)
	step
		goto Kun-Lai Summit 56.4,34.4
		.talk Anduin Wrynn##68939
		..turnin The Bell Speaks##32400
		..accept Breath of Darkest Shadow##32401
		|only if havequest(32400) and not completedq(32401) and not completedq(32455)
	step
		goto Kun-Lai Summit 55.9,32.5
		.' Wait until the Horde become afflicted by the Sha.
		.from Kor'kron Juggernaut##68940
		.' Once the Juggernauts are defeated, Ishi will get possessed.
		.kill Ishi##68936 |q 32401/1
		.' Destroy the Divine Bell |q 32401/2
		|only if havequest(32401)
	step
		goto Kun-Lai Summit 55.9,32.5
		.talk Anduin Wrynn##68987
		..turnin Breath of Darkest Shadow##32401
		..accept The Silence##32455
		|only if not completedq(32455)
	step
		.' Use your _Alliance Flare Gun_ |use Alliance Flare Gun##93362 |q 32455/1
		|only if havequest(32455)
	step
		goto Krasarang Wilds 87.7,33.1
		.talk Admiral Taylor##69090
		..turnin The Silence##32455
		|only if havequest(32455)
	step
	label "endg"
		goto Krasarang Wilds 89.6,33.4
		.talk Agent Malley##69059
		..buy 1 Grand Commendation of Operation: Shieldwall##93231 |n
		.' Use the Commendation of Operation: Shieldwall you just purchased. |condition ZGV:GetReputation("Operation: Shieldwall").hasBonus |use Grand Commendation of Operation: Shieldwall##93231
		|only if rep("Operation: Shieldwall")>=Revered
	step
		.' You have reached the end of the guide.
		.' Click here to go back to the start. |confirm |next dailies
]])

ZygorGuidesViewer:RegisterInclude("Beastmaster_Dailies",[[
	step
		'Routing to proper section |next |only if not completedq(32109)
		'Routing to proper section |next "token" |only if completedq(32109)
	step
		goto Krasarang Wilds 85.3,29.1
		.talk Scout Lynna##68311
		..turnin Meet the Scout##32246
	step
		goto Krasarang Wilds 85.3,29.1
		.talk King Varian Wrynn##61796
		..accept A King Among Men##32247
	step
		goto Krasarang Wilds 79.6,25.0
		.talk Marshal Troteman##68331
		.' Marshal Troteman found |q 32247/2
	step
		goto Krasarang Wilds 80.4,17.5
		.talk Hilda Hornswaggle##68312
		.' Hilda Hornswaggle found |q 32247/3
	step
		goto Krasarang Wilds 84.6,22.0
		.from Horde Raider##68332+, Horde Hunter##68334+, Horde Priest##67904+
		..kill 25 Horde |q 32247/1
	step
		.talk King Varian Wrynn##61796 |tip He is standing next to you.
		..turnin A King Among Men##32247
		..accept Lion's Landing##32109
	step
		goto Krasarang Wilds 85.6,29.1
		.click Flare Launcher##6544
		..turnin Lion's Landing##32109
//Lions landing Achievement
	step
		'This guide will take you through the bonus quests for Operation: Shieldwall.
		'These quests do not offer any reputation, but they do offer Valor Points and the Lesser Charms of Good Fortune.
		|confirm
	step
	label "route"
		'Routing to proper section |next "token" |only if itemcount(91877)<30
		'Routing to proper section |next "menu" |only if itemcount(91877)>=30
	step
	label "token"
		goto Krasarang Wilds 11.9,60.4
		.from Heavy Mook##67399+, Dominance Grunt##67357+, Bloodhilt Honor Guard##67334, Dominance Raider##67346+
		.collect 30 Domination Point Commission##91877
	step
	label "menu"
		'Click here to go purchase and accept the Sturdy Tiger Trap questline. |confirm |next "tiger"
		.'_
		'Click here to go purchase and accept the Sturdy Crane Snare questline. |confirm |next "crane"
		.'_
		'Click here to go purchase and accept the Sturdy Crab Crate questline. |confirm |next "crab"
	step
	label "crane"
		goto Krasarang Wilds/0 89.5,33.5
		.talk Proveditor Grantley##67881
		.buy Sturdy Crane Snare##91854
	step
		'Click the _Sturdy Crane Snare_ in your bags. |use Sturdy Crane Snare##91854
		..accept Beastmaster's Hunt: The Crane##32164
	step
		goto Krasarang Wilds/0 73.2,44.6
		.from Great Crane##59763+
		..get Pristine Jet Crownfeather##91815 |q 32164/2
	step
		goto Krasarang Wilds/0 34.5,71.2
		.from Child of Chi-Ji##60616+
		..get 5 Pristine Golden Crownfeather |q 32164/1
	step
		goto Krasarang Wilds 39.2,61.9
		.click Mound of Dirt##12093
		..turnin Beastmaster's Hunt: The Crane##32164
	step
		goto Krasarang Wilds 39.3,61.8
		.talk Ancient Bloodcrown Crane##67555
		..accept Beastmaster's Quarry: The Crane##32184
	step
		goto Krasarang Wilds 84.3,18.9
		.talk Huntsman Blake##67558
		..turnin Beastmaster's Quarry: The Crane##32184
		|next group
	step
	label tiger
		goto Krasarang Wilds/0 89.5,33.5
		.talk Proveditor Grantley##67881
		.buy Sturdy Tiger Trap##91855
	step
		'Click the _Sturdy Tiger Trap_ in your bags. |use Sturdy Tiger Trap##91855
		..accept Beastmaster's Hunt: The Tiger##32165
	step
		goto Dread Wastes 51.5,67.2
		.from Wasteland Yak##66549+, Wasteland Calf##66595+
		..get 25 Unbruised Yak Haunch##91816 |q 32165/1
	step
		goto Krasarang Wilds/0 13.9,41.3
		.click Mound of Dirt##12093
		..turnin Beastmaster's Hunt: The Tiger##32165
	step
		goto Krasarang Wilds/0 13.9,41.2
		.talk Krasari Elder##67556
		..accept Beastmaster's Quarry: The Tiger##32185
	step
		goto Krasarang Wilds 84.3,18.9
		.talk Huntsman Blake##67558
		..turnin Beastmaster's Quarry: The Tiger##32185
		|next group
	step
	label crab
		goto Krasarang Wilds/0 89.5,33.5
		.talk Proveditor Grantley##67881
		.buy Sturdy Crab Crate##91856
	step
		'Click the _Sturdy Crab Crate_ in your bags. |use Sturdy Crab Crate##91856
		..accept Beastmaster's Hunt: The Crab##32166
	step
		goto Krasarang Wilds 47.4,91.7
		.from Unga Villager##60358+
		..get 30 Funky Rotten Fish |q 32166/1
	step
		goto Krasarang Wilds 56.3,42.1
		.click Mound of Dirt##12093
		..turnin Beastmaster's Hunt: The Crab##32166
	step
		goto Krasarang Wilds 56.4,42.2
		.' Talk to the Captured Colossal Viseclaw
		..accept Beastmaster's Quarry: The Crab##32186
	step
		goto Krasarang Wilds 84.3,18.9
		.talk Huntsman Blake##67558
		..turnin Beastmaster's Quarry: The Crab##32186
	step
	label group
		goto Krasarang Wilds 84.3,18.9
		.talk Huntsman Blake##67558
		.' The dailies you have completed will determine which enemies are available to you to fight.
		.' Click here to fight the _Ancient Bloodcrown Crane_. |confirm |next bc
		.' Click here to fight the _Krasari Elder_. |confirm |next ke
		.' Click here to fight the _Colossal Viseclaw_. |confirm |next cv
	step
	label bc
		.' Tell him you would like to fight the Bloodcrown Crane.
		.' During the fight, pay attention to the songs that it uses.
		.' Some can be interrupted while others simply need to be avoided.
		.from Ancient Bloodcrown Crane##67555
		..accept Ancient's Fall##32170
	step
		goto Krasarang Wilds 84.3,18.9
		.talk Huntsman Blake##67558
		.turnin Ancient's Fall##32170
		|next EOG
	step
	label ke
		.' Tell him you would like to fight the Krasari Elder.
		.' During the fight, you will want to stay close to it at _ALL TIMES_.
		.' It will occassionally vanish, if you have a hunter simply put a flare out.
		.from Krasari Elder##67556
		..accept End of an Elder##32171
	step
		goto Krasarang Wilds 84.3,18.9
		.talk Huntsman Blake##67558
		.turnin End of an Elder##32171
		|next EOG
	step
	label cv
		.' Tell him you would like to fight the Colossal Viseclaw.
		.' During the fight, you will want to kite him around.
		.' He will have a damage reduction buff that decreases while he moves.
		.' If it reaches _0_, the buff will reset.
		.from Colossal Viseclaw##67508
		..accept A Colossal Victory##32172
	step
		goto Krasarang Wilds 84.3,18.9
		.talk Huntsman Blake##67558
		..turnin A Colossal Victory##32172
		|next EOG
	step
	label EOG
		.' You have reached the end of the guide.
		.' Click here to return to the beginning. |confirm |next "route"
]])

ZygorGuidesViewer:RegisterInclude("A_Beasts_of_Fable_D",[[
		goto Vale of Eternal Blossoms 86.6,60.0
		.talk Sara Finkleswitch##64572
		..accept Beasts of Fable Book I##32604
		..accept Beasts of Fable Book II##32868
		..accept Beasts of Fable Book III##32869
	step
		goto Vale of Eternal Blossoms 11.0,70.9
		.' _No-No_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying attacks.
		.' I would suggest that you use flying pets against this enemy.
		.' No-No defeated |q 32869/2
		'|modelnpc 68559
	step
		goto Valley of the Four Winds 40.5,43.7
		.' _Lucky Yi_
		.' This enemy is a critter.
		.' Is is strong against Elementals and weak to beast attacks.
		.' I would suggest using beast pets against this enemy.
		.' Lucky Yi defeated |q 32868/2
		'|modelnpc 68561
	step
		goto Valley of the Four Winds 25.3,78.5
		.' _Greyhoof_
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Greyhoof defeated |q 32868/1
		'|modelnpc 68560
	step
		goto Krasarang Wilds 36.3,37.3
		.' _Skitterer Xi'a_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying pets.
		.' I would suggest using flying pets against this enemy.
		.' Xi'a defeated |q 32868/3
		'|modelnpc 68566
	step
		goto Dread Wastes 26.1,50.2
		.' _Gorespine_
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Gorespine defeated |q 32869/1
		'|modelnpc 68558
	step
		goto Townlong Steppes 72.3,79.8
		.' _Ti'un the Wanderer_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying pets.
		.' I would suggest using flying pets against this enemy.
		.' Ti'un the Wanderer defeated |q 32869/3
		'|modelnpc 68562
	step
		goto Kun-Lai Summit 35.2,56.2
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Kafi defeated |q 32604/2
		'|modelnpc 68563
	step
		goto Kun-Lai Summit 67.9,84.7
		.' _Dos-Ryga_
		.' This enemy is aquatic.
		.' It is strong against undead and weak to flying pets.
		.' I would suggest using flying pets against this enemy.
		.' Dos-Ryga defeated |q 32604/3
		'|modelnpc 68564
	step
		goto The Jade Forest 48.4,71.0
		.' _Ka'wi the Gorger_
		.' This enemy is a beast.
		.' It is strong against humanoids and weak against mechanical pets.
		.' I would suggest using a team of mechanical pets against this enemy.
		.' Ka'wi the Gorger defeated |q 32604/1
		'|modelnpc 68555
	step
		goto The Jade Forest 57.0,29.1
		.' _Nitun_
		.' This enemy is a critter.
		.' Is is strong against Elementals and weak to beast attacks.
		.' I would suggest using beast pets against this enemy.
		.' Nitun defeated |q 32604/4
		'|modelnpc 68565
	step
		goto Vale of Eternal Blossoms 86.6,60.0
		.talk Sara Finkleswitch##64572
		..turnin Beasts of Fable Book I##32604
		..turnin Beasts of Fable Book II##32868
		..turnin Beasts of Fable Book III##32869
]])

ZygorGuidesViewer:RegisterInclude("Kirin_Tor_Offensive",[[
	label start
		'Moving to the Kirin Tor Offensive Dailies |next "dailies" |only if default
		'Moving to the Kirin Tor Offensive prequests. |next |only if not completedq(32681)
		'Moving to the First Scenario |next "scenario1" |only if thunderstage()>=2 and not completedq(32644)
		'Moving to the Second Scenario |next "scenario2" |only if thunderstage()>=3 and not completedq(32654)
		'Moving to the Third Scenario |next "scenario3" |only if thunderstage()>=4 and not completedq(32652)
		'Moving to the Fourth Scenario |next "scenario4" |only if thunderstage()>=5 and not completedq(32655)
		'Moving to the Fifth Scenario |next "post5" |only if thunderstage()>5 and not completedq(32656)
///prequests
	step
	label prequests
		goto Vale of Eternal Blossoms 83.9,58.6
		.talk Lyalia##64610
		..accept Thunder Calls##32679
	step
		goto Townlong Steppes 49.9,69.0
		.talk Vereesa Windrunner##70360
		..turnin Thunder Calls##32679
		..accept The Storm Gathers##32681
	step
		goto 49.9,69.0
		.talk Vereesa Windrunner##70360
		.' Tell her that you are ready to go.
		.' Speak with Vereesa |q 32681/1
		.' Isle of Thunder discovered |q 32681/2
	step
		goto Isle of Thunder 34.6,89.5
		.talk Lady Jaina Proudmoore##67992
		..turnin The Storm Gathers##32681
		|next "start"
//stage2
	step
	label scenario1
		goto Isle of Thunder/0 34.6,89.4
		.talk Lady Jaina Proudmoore##67992
		..accept The Assault on Shaol'mara##32644
	step
		goto 34.6,89.4
		.talk Lady Jaina Proudmoore##67992
		.' Tell her you are ready! |q 32644/1
		.' Enter the _The Assault on Shaol'mara_ Scenario |goto 933 |noway|c
	step
		.' Enter the Assault on Shaol'mara Scenario. |goto 933 |noway|c
	step
		goto 933 35.0,89.8
		.clicknpc Silver Covenant Hippogryph##70234
		scenariogoal 22869
	step
		scenariogoal 22654
	step
		scenariostage 1
	step
		goto 52.4,59.3
		.from Shaol'mara Beastcaller##70286+,Shaol'mara Raptor##70288+
		scenariogoal 22655
	step
		scenariostage 2
	step
		goto 58.0,65.9
		.from Zandalari Barricade##69515+, Zeb'tula Spearanger##69518+, Shaol'mara Stoneshield##70291+
		scenariogoal 22656
	step
		scenariostage 3
	step
		goto 59.6,68.3
		.from Anki##69531, Beastcaller Pakutesh##69532 |tip Pakutesh will jump off of Anki once he is defeated.
		scenariogoal 22870
		scenariogoal 22871
	step
		scenariostage 4
	step
		goto 64.3,73.0
		.from Arcanital Mara'kah##69538
		.' While fighting Arcanital Mara'kah, the mask puts down yellow protection fields.
		.' Position yourself so that you are IN the yellow field, while Mara'kah is OUT of the field.
		scenariogoal 22872
	step
		scenariostage 5
	step
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..turnin The Assault on Shaol'mara##32644
		|next "start"
//stage3
	step
	label scenario2
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..accept Tear Down This Wall!##32654
	step
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		.' Tell her you're ready to tear down the wall! |q 32654/1
		.' Enter the _Tear Down This Wall!_ Scenario |goto 933 |noway|c
	step
		goto 933 48.4,50.9
		.' Click the _Heavy Explosive_
		.' Acquire the Heavy Explosives.
		scenariogoal 22696
	step
		scenariostage 1
	step
		goto 55.8,57.7
		.talk Vereesa Windrunner##69949
		.' Deliver the explosive to Vereesa
		scenariogoal 22700
	step
		scenariostage 2
	step
		goto 56.3,56.1
		.' Click the Heavy Explosives to detonate them.
		scenariogoal 22702
	step
		scenariostage 3
	step
		goto 54.7,45.8
		.' Follow Vereesa Windrunner along the path.
		.from War-God Al'chukla##69755+ |scenariogoal 23004
		.' Secure the lower city |q 32654/2
	step
		scenariostage 4
	step
		goto 54.1,46.2 |n
		.' Click the Portal to the Isle of Thunder |goto Isle of Thunder/0 64.1,72.5 |noway |c
	step
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..turnin Tear Down This Wall!##32654
		|next "start"
//stage4
	step
	label scenario3
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..accept To the Skies!##32652
	step
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		.' Tell her you're ready! |q 32652/1
		.' Enter the _To the Skies!_ Scenario |goto 933 |noway|c
	step
		goto 933 63.3,74.3
		.clicknpc Thunderwing##70208
		.' Mount the Thunderwing.
		scenariogoal 22666
	step
		.' Approach the Mine Entrace.
		scenariogoal 22701
	step
		scenariostage 1
	step
		.from Zandalari Beastcaller##69521+
		.' You will be attacked by _Zandalari Beastcallers_.
		.' Use the icon that appears at the bottom of your screen to jump to the enemy Thunderwing and kill them.
		scenariogoal 22668
	step
		scenariostage 2
	step
		goto 48.2,25.3
		.from Beastmaster Horaki##69559+
		scenariogoal 22669
	step
		scenariostage 3
	 step
		goto 933 49.3,26.0
		.talk Taoshi##69810
		.' Tell her lets go.
		scenariogoal 22738
	step
		scenariostage 4
	step
		.' Watch _Taoshi_ get rid of the Cave-in.
		scenariogoal 22740
	step
		goto 933/1 34.8,55.1
		.' Make your way to the Mine Entrance.
		scenariogoal 22741
	step
		scenariostage 5
	step
		goto 28.7,68.8
		.from Slavemaster Shiaxu##69923
		scenariogoal 22672
		.' Unlock the Mine door.
		scenariogoal 22739
		.' Assault the Lightning Vein Mines |q 32652/2
	step
		scenariostage 6
	step
		goto 31.4,77.7 |n
		.' Click the _Portal to the Isle of Thunder_. |goto Isle of Thunder/0 64.1,72.5 |noway |c
	step
		goto Isle of Thunder 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..turnin To the Skies!##32652
		|next "start"
//stage5
	step
	label scenario4
		goto Isle of Thunder/0 63.2,73.9
		.talk Taoshi##70297
		..accept A Bold Idea##32655
	step
		goto Isle of Thunder/0 63.2,73.9
		.talk Taoshi##70297
		.' Tell her let's break into the shipyard. |goto 933 62.5,54.6 |noway|c
	step
		goto 63.3,54.4
		.clicknpc Thunderwing##69458
		.' Intercept the Zandalari Patrol.
		scenariogoal 22661
	step
		scenariostage 1
	step
		.' While on the _Thunderwing_ use your ability on the toolbar to disable Sentry Totems.
		'|modelnpc 69505
		scenariogoal 23007
	step
		scenariostage 2
	step
		.' Follow _Taoshi_ around the ship and sneak up behind the _Veteran Wingriders_ she marks for you.
		.' When the enemies are inside your red circle, use the _Knock Out_ ability that pops up on your screen.
		scenariogoal 23003
		scenariogoal 22663
		|modelnpc Veteran Wingrider##69552
	step
		scenariostage 3
	step
		goto 67.2,47.3
		.from Captain Halu'kal##69482+
		scenariogoal 22664
	step
		scenariostage 4
	step
		goto 59.2,43.9
		.' Make your way up the pathway here, avoiding patrols and sentry towers.
		.' There will be big blue circles on the ground representing what they can see.
		scenariogoal 22665
	step
		scenariostage 5
	step
		goto 59.2,43.8
		.from Hu'seng the Gatekeeper##69483
		scenariogoal 22667
		scenariogoal 22810
	step
		scenariostage 6
	step
		goto 58.4,42.8
		.' Click Deactivated Access Generator
		scenariogoal 22809
	step
		scenariostage 7
	step
		goto 57.8,41.9 |n
		.' Click the portal to the Violet Rise. |goto Isle of Thunder |noway|c
	step
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..turnin A Bold Idea##32655
		|next "start"
//stage5end
	step
	label post5
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..accept The Fall of Shan Bu##32656
		.' Talk to her to queue up for the solo scenario.
		.' Enter The Fall of Shan Bu Scenario |goto 933 |noway |c
	step
		goto 933 59.0,43.8
		.talk Vereesa Windrunner##69615
		.' Tell her that you're ready. |scenariogoal 22742
	step
		goto 933 58.1,41.3
		scenariogoal 22799
		.kill 14 Zandalari Stoneshield##69527+ |scenariogoal 22675
		scenariostage 1 |override
	step
		goto 933 57.9,41.0
		.kill 2 Palace Gatekeeper##69510+ |scenariogoal 22685
		scenariostage 2 |override
	step
		goto 933 59.3,38.9
		scenariogoal 22807
	step
		goto 933 59.9,38.2
		.from Quilen Guardian##69506+, Zandalari Stoneshield##69865+, Shan'ze Electrocutioner##69525+ |scenariogoal 22734
		scenariostage 3 |override
	step
		goto 933 60.0,37.8
		.from Shan Bu##69534+, Onyx Stormclaw##69580+ |scenariogoal 22683
		scenariostage 4 |override
	step
		goto 933 58.2,42.5 |n
		.' Click the Portal to the Isle of Thunder |goto Isle of Thunder/0 64.1,72.5|noway|c
	step
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..turnin The Fall of Shan Bu##32656
		|next "start"
//dailies
	step
	label dailies
		goto Isle of Thunder 34.6,89.5
		.talk Lady Jaina Proudmoore##67992
		..accept Za'Tual##32733 |or
		..accept Competing Magic##32576 |or
		|noquest
		|only if thunderstage()==1
	step
		goto 34.5,89.5
		.talk Captain Elleane Wavecrest##67995
		..accept Ihgaluk Crag##32732
		|noquest
		|only if thunderstage()==1
	step
		goto 34.7,89.2
		.talk Vereesa Windrunner##67993
		..accept The Court of Bones##32731
		|noquest
		|only if thunderstage()==1
	step
		goto 31.6,83.1
		.talk Archmage Lan'dalock##70517
		..turnin Za'Tual##32733
		..accept Harbingers of the Loa##32540 |or 2
		..accept Dangers of Za'Tual##32543 |or 2
		..accept Surgical Strike##32542 |or 2
		|noquest
		|only if havequest(32733) or completedq(32733)
		|only if thunderstage()==1
	step
		goto 31.5,83.2
		.talk Ako##69673
		..accept Pterrible Ptorment##32544
		..accept Preventing a Future Threat##32541
		|noquest
		|only if thunderstage()==1
	step
		goto 31.7,83.2
		.talk Dalvin Jaacor##69674
		..accept Dark Offerings##32539
		..accept Heinous Sacrifice##32538
		|noquest
		|only if thunderstage()==1

----------------------------- STAGE 2
	step
		goto 63.2,72.2
		.clicknpc Assignment Map##70567
		..'Click PvE at the assignment screen. |questchoice 26 64 -- PvE
		|only if thunderstage()>=2 and completedq(32644)
	step
		goto Isle of Thunder/0 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..accept Za'Tual##32733
		|noquest
		|only if thunderstage()>=2 and completedq(32644)
	step
		goto 63.2,72.1
		.talk Vereesa Windrunner##67993
		..accept The Court of Bones##32731 |or 2
		..accept The Shuddering Moor##32574 |or 2
		..accept The Zandalari Colossus##32575 |or 2
		|noquest
		|only if thunderstage()>=2 and completedq(32644)
	step
		goto 63.5,73.6
		.talk Warmage Yurias##67994
		..accept A Wing to Fly On##32571
		|noquest
		|only if thunderstage()>=2 and completedq(32644)
	step
		goto 62.7,73.6
		.talk Captain Elleane Wavecrest##67995
		..accept Ihgaluk Crag##32732 |or 2
		..accept The Sleepless Legion##32572 |or 2
		..accept Enemies Beneath the Tower##32573 |or 2
		|noquest
		|only if thunderstage()>=2 and completedq(32644)
// Ihgaluk Crag
	step
		goto Isle of Thunder 42.4,75.0
		.talk Archmage Modera##67996
		..turnin Ihgaluk Crag##32732
		..accept Subtle Encouragement##32606
		..accept De-Constructed##32537
		..accept Manipulating the Saurok##32536
		..accept The Skumblade Threat##32535
		|noquest
		|only if havequest(32732) or completedq(32732)
		|only if thunderstage()==1
	step
		goto Isle of Thunder 42.3,75.2
		.talk Lyalia##69675
		..accept The Residents of Ihgaluk##32545
		|noquest
		|only if completedq(32732) and thunderstage()==1
	step
		goto Isle of Thunder 42.4,74.9
		.talk Sanitation Sorcerer Stephen Litmatch##69677
		..accept The Creeping Carpet of Ihgaluk##32547
		..accept Just Some Light Clean-Up Work##32546
		..accept Left To Rot##32548
		|noquest
		|only if completedq(32732) and thunderstage()==1
	step
		goto Isle of Thunder 55.7,74.4
		.talk Archmage Modera##67996
		..turnin Ihgaluk Crag##32732
		..accept Subtle Encouragement##32606
		..accept De-Constructed##32537
		..accept Manipulating the Saurok##32536
		..accept The Skumblade Threat##32535
		|noquest
		|only if thunderstage()>=2 and completedq(32644) and (havequest(32732) or completedq(32732))
	step
		goto 55.9,74.4
		.talk Lyalia##69675
		..accept The Residents of Ihgaluk##32545
		|noquest
		|only if completedq(32732) and thunderstage()>=2
	step
		goto 55.5,74.5
		.talk Sanitation Sorcerer Stephen Litmatch##69677
		..accept The Creeping Carpet of Ihgaluk##32547
		..accept Just Some Light Clean-Up Work##32546
		..accept Left To Rot##32548
		|noquest
		|only if completedq(32732) and thunderstage()>=2 and completedq(32644)
	step
		goto Isle of Thunder 42.3,75.0
		.talk Image of Archmage Vargoth##69678
		..accept Skin of the Saurok##32549 |tip NOTE: This quest will give you the ability to disguise yourself as a saurok. This spell will happen automatically whenever you are outside of combat and inside Ihgaluk Crag. If you try to attack another saurok, the disguise will vanish and all saurok will be hostile to you until you are out of combat again.
		|only if not completedq(32549) and thunderstage()==1
	step
		goto Isle of Thunder 47.2,79.6
		.from Skumblade Filthmonger##69228+, Skumblade Brute##69338+, Skumblade Scavenger##69227+ |q 32549/1
		|only if havequest(32549)
	step
		.' Click the quest complete box that appears below your minimap.
		..turnin Skin of the Saurok##32549
		|only if havequest(32549)
	step
		'While going through Ihgaluk Crag:
		.' Anytime you kill a saurok, click the _Plant Mogu Weapon_ icon that appears at the center of your screen.
		|confirm
		|only if havequest(32606)
	step
		goto Isle of Thunder 52.7,80.2
		.from Quivering Filth##69251+
		.' Disperse 75 Filth |q 32546/1
		|only if havequest(32546)
	step
		goto 51.6,84.4
		.talk Magister Lyanis##69684 |tip He's in a magic bubble inside the cave here, you will need to approach him in order to see him.
		..' Speak with Magister Lyanis |q 32536/2
		|only if havequest(32536)
	step
		goto 51.3,78.8
		..kill 1 Skumblade Brute##69338+ |q 32545/1
		|only if havequest(32545)
	step
		goto 50.8,73.4
		.talk Magistrix Sanal##69686 |tip She's in a magic bubble, you will need to approach her in order to see her. If you have trouble finding her, look for the moving streaks of light.
		.' Speak with Magistrix Sanal |q 32536/3
		|only if havequest(32536)
	step
		map Isle of Thunder
		path follow loose;loop;ants straight
		path 51.8,74.4	53.3,77.0	54.3,79.3
		path 55.1,82.2	55.1,82.2	55.3,84.2
		path 54.9,86.7	53.9,88.3	52.4,90.4
		path 50.8,90.5	49.2,89.5	49.4,85.8
		path 49.8,84.0	49.4,82.0	49.2,79.8
		path 50.1,78.4	50.4,77.1	50.6,75.8
		.clicknpc Distressed Sunreaver Construct##69290 |tip It runs around in a large area, follow the path if you have trouble finding it.
		.' Recover Distressed Construct |q 32537/3
		|only if havequest(32537)
	step
		goto Isle of Thunder 49.8,76.2
		.kill 1 Skumblade Saur-Priest##69229+ |q 32545/2 |tip He's on top of the mountain on a cliffside.
		|only if havequest(32545)
	step
		goto 48.0,88.7
		..kill 1 Skumblade Seadragon##69226+ |q 32545/3
		|only if havequest(32545)
	step
		goto Isle of Thunder/0 53.6,91.2
		.clicknpc Buried Sunreaver Construct##69288
		.' Recover Buried Construct |q 32537/2
		|only if havequest(32537)
	step
		goto Isle of Thunder/0 46.6,71.9
		.clicknpc Malfunctioning Sunreaver##69289
		.' Recover Malfunctioning Construct |q 32537/4
		|only if havequest(32537)
	step
		goto Isle of Thunder/0 44.2,81.8
		.clicknpc Disabled Sunreaver Construct##69439
		.' Recover Disabled Construct |q 32537/1
		|only if havequest(32537)
	step
		goto Isle of Thunder/0 45.1,84.0
		.talk Magister Yalis##69682 |tip He's in a magic bubble, you will need to approach him in order to see him. If you have trouble finding him, look for the moving streaks of light.
		.' Speak with Magister Yalis |q 32536/1
		|only if havequest(32536)
	step
		goto Isle of Thunder 53.2,90.0
		..kill Skumblade Seadragon##69226 |q 32545/3
		|only if havequest(32545)
	step
		goto Isle of Thunder/0 53.6,91.2
		.talk Buried Silver Covenant Construct##69688
		.' Recover Buried Construct |q 32537/2
		|only if havequest(32537)
	step
		goto 45.6,76.5
		.' Ride around the area, stepping on top of roaches. |only if havequest(32547)
		.' 150 Ihgaluk Roachs crushed |q 32547/1 |only if havequest(32547)
		.' You can find additional roaches around [49.1,79.4].
		|modelnpc 69234
		|only if havequest(32547)
	step
		goto Isle of Thunder 50.1,78.0
		.kill 3 Fetid Meat Pile##69247 |q 32548/1 |only if havequest(32548)
		|only if havequest(32548)
	step
		goto Isle of Thunder 52.3,82.6
		.from Skumblade Fleshripper##69210+, Skumblade Scavenger##69227+, Skumblade Filthmonger##69228+
		..kill 10 Skumblade saurok |q 32535/1 |only if havequest(32535)
		.' Click the _Plant Mogu Weapon_ icon that appears at the center of your screen. |only if havequest(32606)
		..' Plant 9 Mogu Weapons on Skumblade corpses |q 32606/1 |only if havequest(32606)
		|only if havequest(32606) or havequest(32535) or havequest(32548)
//VH Daily
	step
		goto Isle of Thunder/0 54.6,57.4
		.' Follow the Coordinates on the Map here. |tip The Pterrorwing will be flying and landing around these 6 different locations.
		.clicknpc Wild Pterrorwing Hatchling##69428
		.' Recover a Wild Thunder Ptrerrorwing Hatchling |q 32571/1
		'|goto 53.8,65.1
		'|goto 49.8,64.9
		'|goto 52.7,60.3
		'|goto 51.1,54.9
		'|goto 53.4,52.2
		'|goto 54.6,57.4
		|only if havequest(32571)
	step
		goto Isle of Thunder 49.5,65.4
		.from Shan'ze Animator##70069+, Shan'ze Animator##70069+, Shan'ze Bloodseeker##69431+ |only if havequest(32573)
		..kill 7 Diremoor Shan'ze mogu |q 32573/1 |only if havequest(32573)
		..kill 6 Animated Warrior##67473+ |q 32572/1 |only if havequest(32572)
		|tip If you lure the enemies into the squad of soldiers here, they will do the killing for you.
		|only if havequest(32572) or havequest(32573)
	step
		goto Isle of Thunder/0 42.3,64.0
		..kill Zandalari Colossus##69405 |q 32575/1 |tip It patrols around this half of the Diremoor path. Some searching may be necessary.
		|only if havequest(32575)
	step
		goto Isle of Thunder/0 50.5,51.4
		..kill 1 Mighty Devilsaur##69406 |q 32574/1 |tip It patrols around this half of the Diremoor path. Some searching may be necessary.
		|only if havequest(32574)
// Za'Tual
	step
		goto Isle of Thunder/0 42.2,66.3
		.talk Archmage Lan'dalock##70517
		..turnin Za'Tual##32733
		..accept Harbingers of the Loa##32540
		..accept Dangers of Za'Tual##32543
		..accept Surgical Strike##32542
		|noquest
		|only if thunderstage()>=2 and completedq(32644) and (havequest(32733) or completedq(32733))
	step
		goto 42.3,66.3
		.talk Dalvin Jaacor##69674
		..accept Dark Offerings##32539
		..accept Heinous Sacrifice##32538
		|noquest
		|only if completedq(32733) and thunderstage()>=2
	step
		goto 42.1,66.5
		.talk Ako##69673
		..accept Pterrible Ptorment##32544
		..accept Preventing a Future Threat##32541
		|noquest
		|only if completedq(32733) and thunderstage()>=2
	step
		goto Isle of Thunder 39.8,65.3
		.click Tec'uat's Sacrificial Altar##13502
		.' Tec'uat's Altar destroyed |q 32538/2
		|only if havequest(32538)
	step
		goto Isle of Thunder/0 41.1,69.4
		.from Zandalari Arcweaver##69224+
		.' Tormented Skyscreamer freed |q 32544/1
		|only if havequest(32544)
	step
		goto Isle of Thunder 38.7,78.6
		.click Pa'chek's Sacrificial Altar##13502
		.' Pa'chek's Altar destroyed |q 32538/3
		|only if havequest(32538)
	step
		goto 33.9,76.0
		.click Cha'lat's Sacrificial Altar##13502
		.' Cha'lat's Altar destroyed |q 32538/1
		|only if havequest(32538)
	step
		goto 36.5,70.0
		.from Zandalari Arcanital##69281, Zandalari Spiritweaver##69285
		..kill 2 Harbingers of the Loa |q 32540/1
		.' You can wait for this one to respawn, or find another at [38.9,76.5]
		|only if havequest(32540)
	step
		goto Isle of Thunder 30.9,77.5
		.' Run over _Hatchling Skyscreamers_ to frighten them.
		.' 12 Hatchling Skyscreamers frightened |q 32541/1
		'|modelnpc Hatchling Skyscreamer##69128+
		|only if havequest(32541)
	step
		goto Isle of Thunder/0 40.1,72.4
		.click Zandalari Offering##13585
		..' 6 Zandalari Offerings destroyed |q 32539/1
		.' More offerings can be found around [40.6,74.1]
		|only if havequest(32539)
	step
		goto Isle of Thunder 35.3,75.8
		.kill 3 Zandalari Beastcaller##69065+ |q 32542/1
		.kill 3 Zandalari Jaguar Warrior##69171+ |q 32542/2
		.kill 3 Zandalari Spiritbinder##69225+ |q 32542/3
		|only if havequest(32542)
	step
		goto 40.7,74.2
		.from Zandalari Stoneshield##69223+, Zandalari Commoner##69170+, Zandalari Beastcaller##69065+, Zandalari Jaguar Warrior##69171+, Zandalari Spiritbinder##69225+ |q 32543/1 |only if havequest(32543)
		|only if havequest(32543)
// The Court of Bones
	step
		goto Isle of Thunder/0 40.2,59.6
		.talk Narasi Snowdawn##67997
		..turnin The Court of Bones##32731
		..accept Soul Surrender##32526
		..accept Grave Circumstances##32527
		|noquest
		|only if havequest(32731) or completedq(32731)
	step
		goto 40.1,59.3
		.talk Danara Silverglass##69668
		..accept Rise No More!##32532
		..accept Ashes of the Enemy##32525
		..accept Stone Cold##32533
		..accept Into the Crypts##32528
		|noquest
		|only if havequest(32731) or completedq(32731)
	step
		goto 40.1,59.1
		.talk Vylene Amaranth##69670
		..accept The Call of Thunder##32529 |or
		..accept The Bloodletter##32530 |or
		..accept The Conquest of Stone##32531 |or
		|noquest
		|only if havequest(32731) or completedq(32731)
	step
		goto 36.9,53.0
		.click Tormentor's Cage##12111 |tip They will be all over the Court of Bones, usually close to walls. |only if havequest(32526)
		..' Rescue 6 Scouts  |q 32526/1
		|only if havequest(32526)
	step
		goto Isle of Thunder/0 35.0,47.9
		..kill Kaida the Bloodletter##69250 |q 32530/1
		|only if havequest(32530)
	step
		goto Isle of Thunder/0 33.0,56.7
		.from Shan'ze Thundercaller##69264+
		|tip You will need to just down in the water here.
		.' Shan'ze Thundercallers' ritual stopped |q 32529/1
		|only if havequest(32529)
	step
		goto Isle of Thunder/0 35.1,63.8
		.from Shan'ze Soulripper##69903+
		..' Disrupt the Ancient Stone Conqueror ritual |q 32531/1
		|only if havequest(32531)
	step
		goto Isle of Thunder 36.8,56.5 |subzone Hall of the Exalted
		.' Use your Incantation of Gura here. |use Incantation of Gura##93803
		..kill 1 Gura the Reclaimed##69241 |q 32528/1
		|only if havequest(32528)
	step
		goto Isle of Thunder 35.5,52.3
		.from Shan'ze Gravekeeper##69235+, Shan'ze Thundercaller##69264+ |q 32527/1 |only if havequest(32527) |tip The Thundercallers will cast Chain Lightning which places a circular spell under your character that you will need to move out of to avoid heavy damage.
		.from Risen Ancestor##69237+ |q 32532/1 |only if havequest(32532)
		.from Grave Guardian##69240+ |q 32533/1 |only if havequest(32533) |tip They sit as stone statues, you need to activate them first.
		.clicknpc Mummified Remains##69331+ |only if havequest(32525)
		.' Use your _Blessed Torch_ on Mummified Remains. |use Blessed Torch##93751 |only if havequest(32525)
		.' 8 Mummified Remains burned |q 32525/1 |only if havequest(32525)
		|only if havequest(32532) or havequest(32526) or havequest(32527) or havequest(32533)
// Court of Bones
	step
		goto 40.1,59.1
		.talk Vylene Amaranth##69670
		..turnin The Call of Thunder##32529
		..turnin The Bloodletter##32530
		..turnin The Conquest of Stone##32531
	step
		goto 40.1,59.3
		.talk Danara Silverglass##69668
		..turnin Rise No More!##32532
		..turnin Into the Crypts##32528
		..turnin Ashes of the Enemy##32525
		..turnin Stone Cold##32533
	step
		goto Isle of Thunder/0 40.2,59.6
		.talk Narasi Snowdawn##67997
		..turnin Soul Surrender##32526
		..turnin Grave Circumstances##32527
	step
		goto Isle of Thunder/0 40.2,59.6
		.talk Narasi Snowdawn##67997
		..accept The Beast Pens##32567
		..accept Imposing Threat##32581
		|noquest
		|next beast_pens |only if havequest(32567)
		|only if thunderstage()>=3 and completedq(32731)
// Ihgaluk Crag Turnins
	step
		goto 42.1,66.5
		.talk Ako##69673
		..turnin Pterrible Ptorment##32544
		..turnin Preventing a Future Threat##32541
		|only if thunderstage()>=2
	step
		goto 42.3,66.3
		.talk Dalvin Jaacor##69674
		..turnin Dark Offerings##32539
		..turnin Heinous Sacrifice##32538
		|only if thunderstage()>=2
	step
		goto Isle of Thunder/0 42.2,66.3
		.talk Archmage Lan'dalock##70517
		..turnin Harbingers of the Loa##32540
		..turnin Dangers of Za'Tual##32543
		..turnin Surgical Strike##32542
		..accept Among the Bones##32578
		..accept No Time To Rest##32568
		..accept Encroaching Force##32580
		..accept The Beast Pens##32567
		|noquest
		|only if thunderstage()>=2 and (havequest(32733) or completedq(32733))
	step
		goto Isle of Thunder 55.5,74.4
		.talk Sanitation Sorcerer Stephen Litmatch##69677
		..turnin The Creeping Carpet of Ihgaluk##32547
		..turnin Just Some Light Clean-Up Work##32546
		..turnin Left To Rot##32548
		|only if thunderstage()>=2 and completedq(32732)
	step
		goto Isle of Thunder 55.9,74.4
		.talk Lyalia##69675
		..turnin The Residents of Ihgaluk##32545
		|only if thunderstage()>=2 and completedq(32732)
	step
		goto Isle of Thunder 55.8,74.4
		.talk Archmage Modera##67996
		..turnin Subtle Encouragement##32606
		..turnin The Skumblade Threat##32535
		..turnin De-Constructed##32537
		..turnin Manipulating the Saurok##32536
		|only if thunderstage()>=2 and (havequest(32732) or completedq(32732))
	step
		goto Isle of Thunder 55.8,74.4
		.talk Archmage Modera##67996
		..accept Among the Bones##32578
		..accept No Time To Rest##32568
		..accept Imposing Threat##32581
		..accept Encroaching Force##32580
		..accept The Beast Pens##32567
		..accept Competing Magic##32579
		|noquest
		|only if thunderstage()>=2 and (havequest(32732) or completedq(32732))
// Za'Tual
	step
		goto Isle of Thunder 42.4,75.0
		.talk Archmage Modera##67996
		..turnin Subtle Encouragement##32606
		..turnin De-Constructed##32537
		..turnin Manipulating the Saurok##32536
		..turnin The Skumblade Threat##32535
		|only if thunderstage()==1 and (havequest(32606) or havequest(32537) or havequest(32536) or havequest(32535))
	step
		goto Isle of Thunder 42.3,75.2
		.talk Lyalia##69675
		..turnin The Residents of Ihgaluk##32545
		|only if havequest(32545) and thunderstage()==1
	step
		goto Isle of Thunder 42.4,74.9
		.talk Sanitation Sorcerer Stephen Litmatch##69677
		..turnin The Creeping Carpet of Ihgaluk##32547
		..turnin Just Some Light Clean-Up Work##32546
		..turnin Left To Rot##32548
		|only if completedq(32732) and thunderstage()==1
	step
		goto Isle of Thunder/0 31.6,83.1
		.talk Archmage Lan'dalock##70517
		..turnin Harbingers of the Loa##32540
		..turnin Dangers of Za'Tual##32543
		..turnin Surgical Strike##32542
		|only if havequest(32540) or havequest(32543) or havequest(32542)
		|only if thunderstage()==1
	step
		goto Isle of Thunder/0 31.5,83.2
		.talk Ako##69673
		..turnin Pterrible Ptorment##32544
		..turnin Preventing a Future Threat##32541
		|only if thunderstage()==1
	step
		goto Isle of Thunder/0 31.7,83.2
		.talk Dalvin Jaacor##69674
		..turnin Dark Offerings##32539
		..turnin Heinous Sacrifice##32538
		|only if thunderstage()==1
// Violet Rise Turnin
	step
		goto Isle of Thunder/0 62.7,73.6
		.talk Captain Elleane Wavecrest##67995
		..turnin The Sleepless Legion##32572
		..turnin Enemies Beneath the Tower##32573
	step
		goto 63.5,73.6
		.talk Warmage Yurias##67994
		..turnin A Wing to Fly On##32571
	step
		goto 63.2,72.1
		.talk Vereesa Windrunner##67993
		..turnin The Shuddering Moor##32574
	step
		goto Isle of Thunder/0 63.2,72.1
		.talk Vereesa Windrunner##69600
		..turnin The Zandalari Colossus##32575
	step
		goto Isle of Thunder 63.2,72.2
		.talk Lady Jaina Proudmoore##67992
		..accept The Beast Pens##32567 |or 2
		..accept Imposing Threat##32581 |or 2
		..accept Imposing Threat##32577 |or 2
		..accept Encroaching Force##32580 |or 2
		..accept No Time To Rest##32568 |or 2
		..accept Among the Bones##32578 |or 2
		..accept Competing Magic##32579 |or 2
		|noquest
		|only if thunderstage()>=2 and (completedq(32572) or completedq(32573) or completedq(32571) or completedq(32574) or completedq(32575))
	step
		goto Isle of Thunder 34.6,89.5
		.talk Lady Jaina Proudmoore##67992
		..accept The Beast Pens##32567 |or
		..accept Imposing Threat##32581 |or
		..accept Imposing Threat##32577 |or
		..accept Encroaching Force##32580 |or
		..accept No Time To Rest##32568 |or
		..accept Among the Bones##32578 |or
		..accept Competing Magic##32576 |or
		..accept Competing Magic##32579 |or
		|noquest
		|only if thunderstage()==1
// Conqueror's Terrace
	step
		goto Isle of Thunder 61.8,61.4
		.kill Nurkala##69663 |q 32580/1 |only if havequest(32580)
		.kill Nurkala##69663 |q 32584/1 |only if havequest(32584)
		|only if havequest(32580) or havequest(32584)
	step
		goto Isle of Thunder/0 45.7,59.5
		..kill 1 Horgak the Enslaver##70176 |q 32581/1 |only if havequest(32581)
		..kill 1 Horgak the Enslaver##70176 |q 32577/1 |only if havequest(32577)
		|only if havequest(32581) or havequest(32577)
	step
		goto Isle of Thunder/0 43.9,69.0
		..kill 1 Arcweaver Jor'guva##69665 |q 32579/1 |only if havequest(32579)
		..kill 1 Arcweaver Jor'guva##69665 |q 32576/1 |only if havequest(32576)
		|only if havequest(32579) or havequest(32576)
//The Beast Pens
	step
	label beast_pens
		goto Isle of Thunder 51.9,47.0
		.' Find Scout Captain Daelin at the Beast Pens |q 32567/1
		|only if havequest(32567)
	step
		goto 51.8,47.1
		.talk Scout Captain Daelin##67998
		..turnin The Beast Pens##32567
		..accept Saur Loser##32550 |or 2
		..accept Compy Stomp##32551 |or 2
		..accept Dino Might##32554 |or 2
		|noquest
		|only if havequest(32567) or completedq(32567)
	step
		goto 51.8,47.2
		.talk Miura Brightweaver##67999
		..accept Direhorn vs Devilsaur##32553
		..accept Loa-saur##32552
		|noquest
		|only if completedq(32567) or completedq(32567)
	step
		goto Isle of Thunder 58.5,51.9
		.from Zandalari Soultwister##69296+, Zandalari Haruspex##69297+, Zandalari Bloodguard##69294+,Zandalari Acolyte##69295+ |q 32560
		..kill 8 Conqueror's Terrace Zandalari |q 32560/1
		|only if havequest(32560)
	 step
		goto Isle of Thunder 53.3,44.3
		.from Loa-Infused Bladetalon##69306+
		..kill Loa Speaker##69302 |q 32552/1
		|only if havequest(32552)
	step
		goto Isle of Thunder/0 53.4,42.2
		.from 6 Master Caller##69286+, Zandalari Fetish-Binder##69155
		..'Binding ritual disrupted |q 32553/1
		|only if havequest(32553)
	 step
		goto Isle of Thunder 49.2,40.9
		.from Zandalari Fetish-Binder##69155+, Zandalari Beastlord##69144+, Zandalari Fetish-Binder##69155+, Zandalari Saurcaller##69154+ |only if havequest(32550)
		.kill 10 Beast Pens Trolls |q 32550/1 |only if havequest(32550)
		.click Saur Fetish |only if havequest(32554)
		..' Saur Fetish can be found around [50.7,43.2] |only if havequest(32554)
		..collect 5 Saur Fetish##93668 |n |only if havequest(32554)
		.' Use the _Saur Fetish_ on Raptors, Compys, Skyscreamers or Direhorns. |only if havequest(32554)
		..' 5 Saur Fetish used |q 32554/1 |use Saur Fetish##93668 |only if havequest(32554)
		.kill 5 Raptor |q 32551/1 |only if havequest(32551)
		..' You can find more raptors around [49.6,37.9] |only if havequest(32551)
		.kill 10 Trained Compy |q 32551/2 |only if havequest(32551)
		|only if havequest(32550) or havequest(32551) or havequest(32554)
	step
		goto Isle of Thunder 51.8,47.1
		.talk Scout Captain Daelin##67998
		..turnin Compy Stomp##32551
		..turnin Saur Loser##32550
		..turnin Dino Might##32554
		|only if havequest(32551) or completedq(32551) or havequest(32550) or completedq(32550)
	step
		goto 51.8,47.2
		.talk Miura Brightweaver##67999
		..turnin Direhorn vs Devilsaur##32553
		..turnin Loa-saur##32552
		..accept Maximum Capacitor##32586 |or
		..accept On Her Magic-ey Secret Service##32588 |or
		|noquest
		|only if havequest(32552) or havequest(32553) or completedq(32552) or completedq(32553)
	step
		goto Isle of Thunder 51.8,47.1
		.talk Scout Captain Daelin##67998
		..accept Among the Bones##32578 |or
		..accept No Time To Rest##32568 |or
		..accept Encroaching Force##32584 |or
		|noquest
		|only if completedq(32567)
//Post Beast Pen Hubs
	step
		goto Isle of Thunder/0 49.3,33.0 |n
		.' Enter the cave here. |goto Isle of Thunder/1|noway|c
		|only if havequest(32586) or havequest(32588)
	step
		goto Isle of Thunder/1 34.6,70.8
		.' Use your Arcane Emancipator on _Agent Reginald_. |use Arcane Emancipator##93761
		.' Agent Reginald rescued |q 32588/1
		'|modelnpc 69751
		|only if havequest(32588)
	step
		goto Isle of Thunder/1 40.8,53.8
		.' Use your Arcane Emancipator on _Agent Grisel_. |use Arcane Emancipator##93761
		.' Agent Grisel rescued |q 32588/2
		'|modelnpc 69752
		|only if havequest(32588)
	step
		goto Isle of Thunder/1 49.4,44.0
		.' Use your Arcane Emancipator on _Agent Grisel_. |use Arcane Emancipator##93761
		.' Agent Crowley rescued |q 32588/3
		'|modelnpc 69754
		|only if havequest(32588)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326 |q 32588/4
		|only if havequest(32588)
	step
		goto Isle of Thunder/1 21.0,69.9
		.click Lightning Drill
		.' Destroy the Western Lightning Drill |q 32586/1
		|only if havequest(32586)
	step
		goto Isle of Thunder/1 32.6,37.5
		.click Lightning Drill
		.' Destroy the Central Lightning Drill |q 32586/2
		|only if havequest(32586)
	step
		goto Isle of Thunder/1 62.2,15.4
		.click Lightning Drill
		.' Destroy the Eastern Lightning Drill |q 32586/3
		|only if havequest(32586)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326 |q 32586/4
		|only if havequest(32586)
	step
		.' Click the Quest Complete box to turn in the quest:
		..turnin Maximum Capacitor##32586 |only if havequest(32586)
		..turnin On Her Magic-ey Secret Service##32588 |only if havequest(32588)
		..accept Forge Ahead!##32587
		|only if havequest(32586) or completedq(32586) or havequest(32588) or completedq(32588)
	step
		goto Isle of Thunder/0 57.7,34.0
		.from Itoka##69461 |q 32587/1
		|only if havequest(32587)
	step
		goto Isle of Thunder 55.7,38.6
		.from Fleshcrafter Hoku##69435
		..get Mogu Codex Fragment |q 32587/2
		|only if havequest(32587)
	step
		goto 61.9,52.0
		.talk Scout Captain Daelin##67998
		..turnin No Time To Rest##32568
		..accept Keep It Secret##32560
		..accept Out of Enemy Hands##32557
		..accept Even Giants Fall##32559
		|noquest
		|only if havequest(32568) or completedq(32568)
	step
		goto Isle of Thunder 61.9,52.1
		.talk Miura Brightweaver##67999
		..accept The More You Know##32556
		..accept Centuries in Sentries##32555
		..accept All In the Family##32558
		|noquest
		|only if completedq(32568)
	step
		goto Isle of Thunder/0 60.2,54.2
		.from Priest of the Serpent##69567
		..kill Guardian Tak'u##69336 |q 32559/1
		|only if havequest(32559)
	step
		goto Isle of Thunder/0 59.4,56.7
		 .from Spiritbinder Tu'chek##69301
		.get Mask of the Dark Mystic |q 32558/1
		|only if havequest(32560)
	step
		goto Isle of Thunder/0 56.7,46.3
		.from Arcanital Ra'kul##69300
		.get Mask of the Dark Mystic |q 32558/2
		|only if havequest(32560)
	step
		goto Isle of Thunder 56.5,47.7
		.click Ritual Artifict
		..get 6 Ritual Artifact |q 32556/1
		|only if havequest(32556)
	step
		goto Isle of Thunder 55.7,50.7
		.from Zandalari Acolyte##69295+, Zandalari Bloodguard##69294+, Zandalari Haruspex##69297+, Zandalari Soultwister##69296+ |q 32206/1 |only if havequest(32206)
		.from Spirit-Bound Sentry##69335+ |only if havequest(32555)
		.' Use your _Resonance Siphon_ _Spirit-Bound Sentry_ corpses. |use Resonance Siphon##93806 |only if havequest(32555)
		.' 5 Zandalari Spirits captured |q 32555/1 |only if havequest(32555)
		|only if havequest(32555) or havequest(32206)
	step
		goto 59.0,51.3
		.from Zandalari Bloodguard##69294+, Zandalari Haruspex##69297+, Zandalari Soultwister##69296+
		..kill 8 Conqueror's Terrace Zandalari |q 32560/1
		.click Loa-Infused Blades |only if havequest(32557)
		..get 7 Loa-Infused Blade |q 32557/1 |only if havequest(32557)
		.' You can find more around [58.1,48.9]
		|only if havequest(32560) or havequest(32557)
	step
		goto 61.9,52.0
		.talk Scout Captain Daelin##67998
		..turnin Keep It Secret##32560
		..turnin Out of Enemy Hands##32557
		..turnin Even Giants Fall##32559
		|only if completedq(32568)
	step
		goto Isle of Thunder/0 61.9,52.1
		.talk Miura Brightweaver##67999
		..turnin The More You Know##32556
		..turnin All In the Family##32558
		..turnin Centuries in Sentries##32555
		|only if completedq(32560) or completedq(32557) or completedq(32559)
	step
		goto Isle of Thunder/0 61.9,52.1
		.talk Miura Brightweaver##67999
		..accept Maximum Capacitor##32586
		..accept On Her Magic-ey Secret Service##32588
		|noquest
		|only if completedq(32560) or completedq(32557) or completedq(32559)
	step
		goto 61.9,52.0
		.talk Scout Captain Daelin##67998
		..accept Raining Bones##32582
		..accept Encroaching Force##32585
		|noquest
		|only if completedq(32568)
	step
		goto 61.9,52.0
		.talk Scout Captain Daelin##67998
		..turnin Encroaching Force##32585
		..turnin Raining Bones##32582
		|only if completedq(32568)
	step
		goto Isle of Thunder/0 49.3,33.0 |n
		.' Enter the cave here. |goto Isle of Thunder/1|noway|c
		|only if havequest(32586) or havequest(32588)
	step
		goto Isle of Thunder/1 34.6,70.8
		.' Use your Arcane Emancipator on _Agent Reginald_. |use Arcane Emancipator##93761
		.' Agent Reginald rescued |q 32588/1
		'|modelnpc 69751
		|only if havequest(32588)
	step
		goto Isle of Thunder/1 40.8,53.8
		.' Use your Arcane Emancipator on _Agent Grisel_. |use Arcane Emancipator##93761
		.' Agent Grisel rescued |q 32588/2
		'|modelnpc 69752
		|only if havequest(32588)
	step
		goto Isle of Thunder/1 49.4,44.0
		.' Use your Arcane Emancipator on _Agent Grisel_. |use Arcane Emancipator##93761
		.' Agent Crowley rescued |q 32588/3
		'|modelnpc 69754
		|only if havequest(32588)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326 |q 32588/4
		|only if havequest(32588)
	step
		goto Isle of Thunder/1 21.0,69.9
		.click Lightning Drill
		.' Destroy the Western Lightning Drill |q 32586/1
		|only if havequest(32586)
	step
		goto Isle of Thunder/1 32.6,37.5
		.click Lightning Drill
		.' Destroy the Central Lightning Drill |q 32586/2
		|only if havequest(32586)
	step
		goto Isle of Thunder/1 62.2,15.4
		.click Lightning Drill
		.' Destroy the Eastern Lightning Drill |q 32586/3
		|only if havequest(32586)
	step
		goto Isle of Thunder/0 54.9,31.3
		.from Metal Lord Mono-Han##69326+ |q 32586/4
		|only if havequest(32586)
	step
		.' Click the Quest Complete box to turn in the quest:
		..turnin Maximum Capacitor##32586
		..turnin On Her Magic-ey Secret Service##32588
		..accept Forge Ahead!##32587
		|only if havequest(32586) or completedq(32586) or havequest(32588) or completedq(32588)
	step
		goto Isle of Thunder/0 57.7,34.0
		.from Itoka##69461 |q 32587/1
		|only if havequest(32587)
	step
		goto Isle of Thunder 55.7,38.6
		.from Fleshcrafter Hoku##69435
		..get Mogu Codex Fragment |q 32587/2
		|only if havequest(32587)
	 step
		goto Isle of Thunder 58.7,42.7
		.talk Scout Captain Daelin##70552
		..turnin Forge Ahead!##32587
	step
		goto Isle of Thunder 58.7,42.8
		.talk Taoshi##69413
		..accept Extended Shore Leave##32607 |or
		..accept Raiding the Vault##32608 |or
		|only if completedq(32587) and thunderstage()>=5
	step
		goto Isle of Thunder/0 62.3,40.2
		.' Click the door to The Swollen Vault.
		.' Enter the Swollen Vault. |goto Isle of Thunder/2 |noway|c
		|only if havequest(32608)
	step
		goto Isle of Thunder/2 57.6,65.6
		.from Lu-Shero##69274
		..collect Hoard-Keeper's Key##95374
		|only if havequest(32608)
	step
		goto Isle of Thunder/2 33.0,28.7
		.click Stormy Chest
		..get Choker of Storms |q 32608/1
		|only if havequest(32608)
	step
		goto Isle of Thunder 63.8,38.9
		.' Click Workshop Orders
		.' Workshop Orders |q 32607/2
		|only if havequest(32607)
	step
		goto Isle of Thunder/0 41.9,79.4
		..kill Zur'chaka the Bonecrafter##69666 |q 32578/1
		..kill Zur'chaka the Bonecrafter##69666 |q 32582/1
		|only if havequest(32578) or havequest(32582)
	 step
		goto Isle of Thunder/0 61.8,61.5
		.from Nurkala##69663 |q 32585/1 |only if havequest(32585)
		.from Nurkala##69663 |q 32580/1 |only if havequest(32580)
		.from Nurkala##69663 |q 32584/1 |only if havequest(32584)
		|only if havequest(32580) or havequest(32584) or havequest(32585)
	step
		goto Isle of Thunder/0 43.9,69.0
		..kill 1 Arcweaver Jor'guva##69665 |q 32579/1 |only if havequest(32579)
		..kill 1 Arcweaver Jor'guva##69665 |q 32576/1 |only if havequest(32576)
		|only if havequest(32579) or havequest(32576)
	step
		goto Isle of Thunder/0 41.9,79.4
		..kill Zur'chaka the Bonecrafter##69666 |q 32578/1
		|only if havequest(32578)
	step
		goto Isle of Thunder/0 68.3,45.3
		.from Arcweaver Uzan##69272 |q 32607/1
		|only if havequest(32607)
	step
		goto 63.2,72.3
		.talk Lady Jaina Proudmoore##67992
		..turnin Among the Bones##32578
		..turnin Encroaching Force##32580
		..turnin Encroaching Force##32584
		..turnin Raiding the Vault##32608
		..turnin Imposing Threat##32581
		..turnin Extended Shore Leave##32607
		..turnin Competing Magic##32576 |or
		..turnin Competing Magic##32579 |or
		|only if thunderstage()>=2
	step
		goto Isle of Thunder 34.6,89.5
		.talk Lady Jaina Proudmoore##67992
		..turnin Imposing Threat##32581 |or
		..turnin Imposing Threat##32577 |or
		..turnin Encroaching Force##32580 |or
		..turnin Encroaching Force##32584 |or
		..turnin Among the Bones##32578 |or
		..turnin Competing Magic##32576 |or
		..turnin Competing Magic##32579 |or
		|noquest
		|only if thunderstage()==1
	step
	label "end"
		'You have reached the end of the dailies for today.
		.' Click here to go back to the beginning of the guide. |confirm |next "start"
		.' Congratulations, you are now _Exalted_ with the _Kirin Tor Offensive_! |only if rep("Kirin Tor Offensive")==Exalted

]])


ZygorGuidesViewer:RegisterInclude("Kirin_Tor_Offensive_STAGE_1",[[

]])



--------------------------------------------------------------------------------------------------------------------------------------
-- ACHIEVEMENTS
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("A_Marista_Hub",[[
	step
		goto Krasarang Wilds 51.7,75.3
		.talk Tony Tuna##60182
		..accept Particular Plumage##30667
	step
		goto 51.5,76.9
		.talk Jay Cloudfall##60173
		..accept Sudden, Unexpected Crocolisk Aggression##30666
	step
		goto 46.4,68.6
		.from Crimson Lory##60198+
		.get 6 Crimson Tailfeather##80678+ |q 30667/2
		.from Emerald Lory##60200+
		.get 6 Emerald Tailfeather##80677+ |q 30667/1
		.from Dusky Lory##60196+
		.get 6 Dusky Tailfeather##80679+ |q 30667/3
 		.from Mortbreath Skulker##60202+, Mortbreath Snapper##60201+
 		.' Kill 8 Mortbreath crocolisk |q 30666/1
	step
		goto 51.7,75.3
		.talk Tony Tuna##60182
		..turnin Particular Plumage##30667
	step
		goto 51.5,76.9
		.talk Jay Cloudfall##60173
		..turnin Sudden, Unexpected Crocolisk Aggression##30666
		..accept Build Your Own Raft##30668
	step
		goto 52.3,77.9
		.click Tough Kelp
		.get Tough Kelp##80804 |q 30668/2
	step
		goto 52.4,76.2
		.click Spare Plank
		.get 4 Spare Plank##80685 |q 30668/1
	step
		goto 51.5,76.9
		.talk Jay Cloudfall##60173
		..turnin Build Your Own Raft##30668
		..accept The Lorewalker on the Lake##30669
	step
		goto 51.7,76.6
		.click Your Raft
		.' Pick up your raft |q 30669/1
	step
		goto 46.0,78.9
		.talk Wise Ana Wu##60139
		..turnin The Lorewalker on the Lake##30669
		..accept Wisdom Has A Price##30671
		..accept Misery##30691
	step
		.' Go underwater and enter the cave |goto 46.0,79.9 <5 |c
	step
		goto 46.2,83.5
		.from Nahassa##60203+ |tip Nahassa will use an ability called Feverish Deathbite that will cause you to hallucinate many more crocolisks have spawned, they aren't really there so don't panic.
		.' Put Nahassa out of his misery |q 30691/1
	step
		'Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin Misery##30691
	step
		.' Exit the cave |goto 46.0,79.9 <5 |c
	step
		goto 46.0,79.0
		.from Great Grey Shark##60204+, Nayeli Hammerhead##60432+
		.get 5 Shark Fillet##80810+ |q 30671/1
	step
		goto 46.0,78.9
		.talk Wise Ana Wu##60139
		..turnin Wisdom Has A Price##30671
		..accept Balance##30672
	step
		goto 45.1,84.9
		'Run over one of the piles of fish along the beach.
		'Click the Quest Discovered box that displays on the right side of the screen under your minimap
		..accept Balance Without Violence##30674
	step
		.from Unga Fish-Getter##60299+
		.collect 1 Confusing Treasure Map##80827 |n
		.' Click the Confusing Treasure Map in your bags |use Confusing Treasure Map##80827
		..accept Buried Hozen Treasure##30675
	step
		goto 46.1,86.7
		.clicknpc Flailing Carp##60367 |tip You can find these all along the beach
		.' Throw 6 Flailing Carp back into the water |q 30674/1
		.kill 10 Unga Fish-Getter##60299+ |q 30672/1
		.click Lump of Sand
		.get Buried Hozen Treasure##80817 |q 30675/1
	step
		'Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin Balance Without Violence##30674
		..turnin Buried Hozen Treasure##30675
	step
		goto 51.5,76.8
		.talk Jay Cloudfall##60173
		..turnin Balance##30672
	step
		goto Krasarang Wilds 29.7,39.0
		.talk Tired Shushen##58278
		..accept Thieving Raiders##30168
		..accept Raid Leader Slovan##30169
	step
		goto 31.8,29.0
		.kill Slovan##58285 |q 30169/1
		.from Riverblade Flesh-hunter##58274
		.get 5 Pillaged Jinyu Loot##78958 |q 30168/1
	step
		goto Krasarang Wilds 29.7,39.1
		.talk Tired Shushen##58278
		..turnin Thieving Raiders##30168
		..turnin Raid Leader Slovan##30169
	step
		goto 24.6,39.2
		.clicknpc Dawnchaser Captive##58608
		.' Rescue 8 Captives |q 30163/1
		.kill 8 Korjan Reclaimer##58614+ |q 30229/1
		.click Mogu Artifact
		.get 10 Mogu Artifact##79120+ |q 30230/1
	step
		goto 28.8,50.6
		.talk Kang Bramblestaff##56112
		..turnin Re-Reclaim##30230
	step
		goto 28.7,50.9
		.talk Kor Bloodtusk##58114
		..turnin For the Tribe##30163
		..turnin The Greater Danger##30229
	step
		goto 24.9,34.3
		.talk Ambassador Han##58630
		..accept The Mantid##30175
	step
		goto 16.0,39.8
		.talk Sunwalker Dezco##58607
		..accept The Stoneplow Convoy##30164
	step
		goto 15.3,35.3
		.clicknpc Stoneplow Envoy##58955
		.' Save 7 Stoneplow Envoy |q 30164/1
		.from Ik'thallik Precursor##58367+, Ik'thallik Vanguard##58368+
		.' Kill 10 Ik'thallik Mantid |q 30175/1
	step
		goto 16.0,39.8
		.talk Sunwalker Dezco##58607
		..turnin The Stoneplow Convoy##30164
	step
		goto 15.7,39.7
		.talk Ambassador Len##58954
		..turnin The Mantid##30175
	step
		goto 16.0,39.8
		.talk Sunwalker Dezco##58607
		..accept For Family##30174
	step
		goto 23.6,48.8
		.talk Kor Bloodtusk##58670
		.' Try to free Kor from his bonds
		.kill Groundbreaker Brojai##58224 |q 30174/1 |tip He will summon adds one at a time. They aren't too difficult to kill.
	step
		goto 28.9,50.8
		.talk Sunwalker Dezco##58607
		..turnin For Family##30174
		..accept Warn Stoneplow##30241
	step
		goto Valley of the Four Winds 19.5,56.8
		.talk Loon Mai##56720
		..turnin Warn Stoneplow##30241
	step
		goto 18.1,55.9
		.talk Mudmug##56474
		..accept It Does You No Good In The Keg##30653
	step
		goto Valley of the Four Winds 18.0,56.3
		.talk Loon Mai##56720
		..accept The Swarm Begins##30622
	step
		goto Valley of the Four Winds 18.0,56.5
		.talk Mei Barrelbottom##59855
		..accept The Mantidote##30623
	step
		goto Valley of the Four Winds 17.5,50.2
		.' Deliver beer to Zhu's Wardens |q 30653/1
	step
		goto Valley of the Four Winds 15.2,55.4
		.' Deliver beer to Crane Wing Priests |q 30653/2
	step
		goto Valley of the Four Winds 13.0,56.0
		.' Deliver beer to Tauren Settlers |q 30653/4
	step
		goto Valley of the Four Winds 10.7,55.5
		.' Deliver beer to Shado-Pan |q 30653/3
	step
		.' Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin It Does You No Good In The Keg##30653
	step
		goto 13.4,54.6
		.from Ik'thallik Infestor##56721+, Ik'thik Warrior##56722+
		.' Kill 15 Ik'thallik Infestors or Warriors |q 30622/1
		.' Use Ken-Ken's mask on Ik'thik Wing Commanders. |use Ken-Ken's Mask##80337
		.from Manifestation of Fear##59874+
		.' Defeat 5 Manifestation of Fear that come out of Ik'thik Wing Commanders. |q 30623/1
	step
		.' Click the Complete Quest box that displays on the right side of the screen under your minimap
		..turnin The Mantidote##30623
	step
		goto 11.6,49.5
		.talk Guard Captain Oakenshield##57198
		..turnin The Swarm Begins##30622
		..accept Students No More##30625
	step
		'The students you are looking for can be at one of four locations fighting one of the quest mobs below. Find the students and kill the follow monsters:
		.'Ik'thallik Tendon-Slicer at [9.5,54.0]
		.kill Ik'thallik Tendon-Slicer##59888 |q 30625/3
		.'Ik'thallik Fearmonger at [9.5,58.2]
		.kill Ik'thallik Fearmonger##59889 |q 30625/4
		.'Ik'thallik Bloodrager at [8.9,54.2]
		.kill Ik'thallik Bloodrager##59887 |q 30625/1
		.'Ik'thik Incubator at [8.9,51.0]
		.kill Ik'thik Incubator##59890 |q 30625/2
	step
		goto 11.6,49.5
		.talk Guard Captain Oakenshield##57198
		..turnin Students No More##30625
		..accept Retreat!##30626
	step
		goto 18.0,56.3
		.talk Loon Mai##56720
		..turnin Retreat!##30626
	step
		goto 17.9,55.7
		.talk Master Bruised Paw##59856
		..accept The Savior of Stoneplow##30627
	step
		goto 18.0,56.7 |n
		.talk Miss Fanny##59857
		.' Tell her "Let's go". |invehicle
	step
		'Use your Unyielding Fist ability to defeat the Mantid Collossus. |tip Use your Unyielding Fist ability when the new icon on your screens flashes orange
		.kill Mantid Colossus##56703 |q 30627/1
	step
		goto 18.0,56.3
		.talk Loon Mai##56720
		..turnin The Savior of Stoneplow##30627
		..accept The Gratitude of Stoneplow##30628
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Trainers
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("trainer_Alchemy",[[
		goto Stormwind City,55.7,86.1
		.talk Lilyssia Nightbreeze##5499
]])

ZygorGuidesViewer:RegisterInclude("trainer_Archaeology",[[
		goto Stormwind City,85.8,25.9
		.talk Harrison Jones##44238
]])

ZygorGuidesViewer:RegisterInclude("trainer_Blacksmithing",[[
		goto Stormwind City 63.7,37.0
		.talk Therum Deepforge##5511
]])

ZygorGuidesViewer:RegisterInclude("trainer_Blacksmithing_Shatt",[[
		goto Shattrath City,69.4,43.3
		.talk Kradu Grimblade##20124
]])

ZygorGuidesViewer:RegisterInclude("trainer_Cooking",[[
		goto Stormwind City,77.3,53.2
		.talk Stephen Ryback##5482
]])

ZygorGuidesViewer:RegisterInclude("trainer_Enchanting",[[
		goto Stormwind City,52.9,74.5
		.talk Lucan Cordell##1317
]])

ZygorGuidesViewer:RegisterInclude("trainer_Engineering",[[
		goto Stormwind City,62.8,32.0
		.talk Lilliam Sparkspindle##5518
]])

ZygorGuidesViewer:RegisterInclude("trainer_FirstAid",[[
		goto Stormwind City 52.2,45.4
		.talk Shaina Fuller##2327
]])

ZygorGuidesViewer:RegisterInclude("trainer_Fishing",[[
		goto Stormwind City 54.8,69.6
		.talk Arnold Leland##5493
]])

ZygorGuidesViewer:RegisterInclude("trainer_Herbalism",[[
		goto Stormwind City 54.3,84.1
		.talk Tannysa##5566
]])

ZygorGuidesViewer:RegisterInclude("trainer_Inscription",[[
		goto Stormwind City,49.8,74.8
		.talk Catarina Stanford##30713
]])

ZygorGuidesViewer:RegisterInclude("trainer_Jewelcrafting",[[
		goto Stormwind City 63.5,61.8
		.talk Theresa Denman##44582
]])

ZygorGuidesViewer:RegisterInclude("trainer_Mining",[[
		goto Stormwind City,59.6,37.6
		.talk Gelman Stonehand##5513
]])

ZygorGuidesViewer:RegisterInclude("trainer_Skinning",[[
		goto Stormwind City,72.2,62.2
		.talk Maris Granger##1292
]])

ZygorGuidesViewer:RegisterInclude("trainer_Skinning_IF",[[
		goto Ironforge,39.9,32.6
		.talk Balthus Stoneflayer##6291
]])

ZygorGuidesViewer:RegisterInclude("trainer_Tailoring",[[
		goto Stormwind City,53.1,81.3
		.talk Georgio Bolero##1346
]])

ZygorGuidesViewer:RegisterInclude("trainer_Leatherworking",[[
		goto Stormwind City,71.7,63.0
		.talk Simon Tanner##5564
]])

ZygorGuidesViewer:RegisterInclude("trainer_Mining_mop",[[
	goto The Jade Forest 45.0,85.9
	.talk Rockseeker Guo##67024
]])

ZygorGuidesViewer:RegisterInclude("trainer_Herbalism_mop",[[
	goto The Jade Forest 45.5,86.0
	.talk Orchard Keeper Li Mei##67025
]])

ZygorGuidesViewer:RegisterInclude("home_Herb_Mine_mop",[[
		goto The Jade Forest/0 44.9,84.4
		.talk Jiayi Applebloom##65907
		.home Paw'Don Village
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Supply Vendors
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("vendor_Alchemy",[[
		goto Stormwind City 55.9,85.6
		.talk Maria Lumere##1313
]])

ZygorGuidesViewer:RegisterInclude("vendor_Blacksmithing",[[
		goto Stormwind City,63.3,37.8
		.talk Kaita Deepforge##5512
]])

ZygorGuidesViewer:RegisterInclude("vendor_Cooking",[[
		goto Stormwind City 77.6,53.1
		.talk Erika Tate##5483
]])

ZygorGuidesViewer:RegisterInclude("vendor_Enchanting",[[
		goto Stormwind City 52.8,74.3
		.talk Jessara Cordell##1318
]])

ZygorGuidesViewer:RegisterInclude("vendor_Engineering",[[
		goto Stormwind City 63.1,32.0
		.talk Billibub Cogspinner##5519
]])

ZygorGuidesViewer:RegisterInclude("vendor_Fishing",[[
		goto Stormwind City 55.0,69.7
		.talk Catherine Leland##5494
]])

ZygorGuidesViewer:RegisterInclude("vendor_Inscription",[[
		goto Stormwind City 49.6,74.9
		.talk Stanly McCormick##30730
]])

ZygorGuidesViewer:RegisterInclude("vendor_Jewelcrafting",[[
		goto Stormwind City 63.2,61.7
		.talk Terrance Denman##44583
]])
ZygorGuidesViewer:RegisterInclude("vendor_Jewelcrafting_1",[[
		goto Stormwind City 63.8,61.6
		.talk Farrah Facet##56925
]])

ZygorGuidesViewer:RegisterInclude("vendor_Mining",[[
		goto Stormwind City 59.2,37.5
		.talk Brooke Stonebraid##5514
]])

ZygorGuidesViewer:RegisterInclude("vendor_Skinning",[[
		goto Stormwind City 71.6,62.8
		.talk Jillian Tanner##5565
]])

ZygorGuidesViewer:RegisterInclude("vendor_Tailoring",[[
		goto Stormwind City 53.1,81.8
		.talk Alexandra Bolero##1347
]])

ZygorGuidesViewer:RegisterInclude("vendor_Leatherworking",[[
		goto Stormwind City,71.6,62.8
		.talk Jillian Tanner##5565
]])

ZygorGuidesViewer:RegisterInclude("vendor_Cooking_Dalaran",[[
		goto Dalaran 41.6,64.6
		.talk Katherine Lee##28705
]])

--------------------------------------------------------------------------------------------------------------------------------------
-- Buying
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("auctioneer",[[
		goto Stormwind City 61.1,70.6
		.talk Auctioneer Fitch##8719
]])

ZygorGuidesViewer:RegisterInclude("auctioneer_dwarven",[[
		goto Stormwind City,60.1,32.2
		.talk Auctioneer Lauffer##43841
]])

ZygorGuidesViewer:RegisterInclude("shatt_auctioneer",[[
		goto Shattrath City,51.0,26.5 |only if rep ('The Aldor') >= Neutral
		.talk Auctioneer Itoran##50143 |only if rep ('The Aldor') >= Neutral
		goto Shattrath City,57.0,63.2 |only if rep ('The Scryers') >= Friendly
		.talk Auctioneer Kalaren##50139|only if rep ('The Scryers') >= Friendly
]])

ZygorGuidesViewer:RegisterInclude("auctioneer_dwarven",[[
		goto Stormwind City,60.1,32.2
		.talk Auctioneer Lauffer##43841
]])

ZygorGuidesViewer:RegisterInclude("goto_shatt_auctioneer",[[
		goto Shattrath City,51.0,26.5 |only if rep ('The Aldor') >= Neutral
		.talk Auctioneer Itoran##50143 |only if rep ('The Aldor') >= Neutral
		goto Shattrath City,57.0,63.2 |only if rep ('The Scryers') >= Friendly
		.talk Auctioneer Kalaren##50139|only if rep ('The Scryers') >= Friendly
]])


--------------------------------------------------------------------------------------------------------------------------------------
-- Anvils
--------------------------------------------------------------------------------------------------------------------------------------

ZygorGuidesViewer:RegisterInclude("shatt_anvil",[[
		goto Shattrath City,69.7,42.7
		.' Stand next to this anvil
]])

ZygorGuidesViewer:RegisterInclude("hell_anvil",[[
		goto Hellfire Peninsula,56.8,63.8
		.' Stand next to this anvil
]])

ZygorGuidesViewer:RegisterInclude("twil_anvil",[[
		goto Twilight Highlands,79.2,76.3
		.' Stand next to this anvil
]])

ZygorGuidesViewer:RegisterInclude("maincity_anvil2",[[
]])

ZygorGuidesViewer:RegisterInclude("maincity_anvil",[[
		goto Stormwind City,63.6,37.0
		.' Stand next to this anvil
]])


--------------------------------------------------------------------------------------------------------------------------------------
-- Other
--------------------------------------------------------------------------------------------------------------------------------------
ZygorGuidesViewer:RegisterInclude("cast_campfire",[[
		'Create a basic campfire |cast Basic Campfire##818
]])

ZygorGuidesViewer:RegisterInclude("dalaran_enter_sewer",[[
		Enter the Dalaran sewers |goto Dalaran/2 %q%
		'|goto Dalaran/1 60.2,47.7 <0.3 "Sewer entrance" |n %q%
		'|goto Dalaran/1 34.8,45.5 <0.3 "Sewer entrance" |n %q%
]])

ZygorGuidesViewer:RegisterInclude("dalaran_leave_sewer",[[
		Leave the Dalaran sewers |goto Dalaran/1 %q%
		'|goto Dalaran/2 60.2,47.7 <0.3 "Sewer entrance" |n %q%
		'|goto Dalaran/2 34.8,45.5 <0.3 "Sewer entrance" |n %q%
]])

--[=[
--Oh snap! Guide in the includes.. Find it a home?
ZygorGuidesViewer:RegisterGuide("Zygor's Alliance Pets & Mounts Guide\\Mount Training",[[
	condition end (level<40 and achieved(891)) or (level<60 and achieved(889)) or (level<68 and achieved(890) and knowspell(90267)) or (level<70 and knowspell(54197)) or (level<80 and achieved(892))  or (level<90 and achieved(5180)) or (level<100 and knowspell(115913) and achieved(5180))
	step
		#include "basic_mounts"
]])
--]=]

ZygorGuidesViewer:RegisterInclude("basic_mounts",[[
	step
	label "route"
		'Redirecting to Apprentice Riding |next "apprentice" |only if level>=20.0 and not achieved(891)
		'Redirecting to Journeyman Riding |next "journeyman" |only if level>=40.0 and not achieved(889)
		'Redirecting to Expert Riding/Flight Master's License |next "expert" |only if level>=60.0 and not achieved(890)
		'Redirecting to Flight License Flying |next "flightlicense" |only if level>=60.0 and not knowspell(90267)
		'Redirecting to Cold Weather Flying |next "cold" |only if level>=68.0 and not knowspell(54197)
		'Redirecting to Artisan Riding |next "artisan" |only if level>=70.0 and not achieved(892)
		'Redirecting to Master Riding |next "master" |only if level>=80.0 and not achieved(5180)
		'Redirecting to Pandaria Flying |next "pandarialicense" |only if level>=90.0 and not knowspell(115913)
		'Redirecting to All Known |next "allknown" |only if knowspell(115913) and achieved(5180)
		'Redirecting to Nothing Available |next "noneavail" |only if default
//APPRENTICE
	step
	label "apprentice"
		goto Stormwind City 77.6,67.2
		.talk Darlene Stokx##43693
		.learn Apprentice Riding##33388
		|only Human
	step
		goto Stormwind City 77.0,67.8
		.talk Katie Stokx##43694
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Black Stallion Bridle##2411 |or
		.buy 1 Brown Stallion Bridle##5656 |or
		.buy 1 Chestnut Mare Bridle##5655 |or
		.buy 1 Pinto Bridle##2414 |or
		|only Human
		|next "end"
	step
		goto Dun Morogh 71.2,48.4
		.talk Ultham Ironhorn##4772
		.learn Apprentice Riding##33388
		|only Dwarf
	step
		goto Dun Morogh 70.6,48.8
		.talk Veron Amberstill##1261
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Brown Ram##5872 |or
		.buy 1 Gray Ram##5864 |or
		.buy 1 White Ram##5873 |or
		|only Dwarf
		|next "end"
	step
		goto Darnassus 42.6,33.6
		.talk Jartsam##4753
		.learn Apprentice Riding##33388
		|only Night Elf
	step
		goto Darnassus 42.6,32.8
		.talk Lelanai##4730
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Reins of the Spotted Frostsaber##8632 |or
		.buy 1 Reins of the Striped Dawnsaber##47100 |or
		.buy 1 Reins of the Striped Frostsaber##8631 |or
		.buy 1 Reins of the Striped Nightsaber##8629 |or
		|only Night Elf
		|next "end"
	step
		goto Dun Morogh 56.2,46.4
		.talk Binjy Featherwhistle##7954
		.learn Apprentice Riding##33388
		|only Gnome
	step
		goto Dun Morogh 56.2,46.2
		.talk Milli Featherwhistle##7955
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Blue Mechanostrider##8595 |or
		.buy 1 Green Mechanostrider##13321 |or
		.buy 1 Red Mechanostrider##8563 |or
		.buy 1 Unpainted Mechanostrider##13322 |or
		|only Gnome
		|next "end"
	step
		goto The Exodar 81.4,52.6
		.talk Aalun##20914
		.learn Apprentice Riding##33388
		|only Draenei
	step
		goto The Exodar 81.6,52.6
		.talk Torallius the Pack Handler##17584
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Brown Elekk##28481 |or
		.buy 1 Gray Elekk##29744 |or
		.buy 1 Purple Elekk##29743 |or
		|only Draenei
		|next "end"
	step
		goto Darnassus 42.6,33.6
		.talk Jartsam##4753
		.learn Apprentice Riding##33388
		|only Worgen
	step
		goto Darnassus 48.6,22.2
		.talk Astrid Langstrump##55285
		.buy 1 Mountain Horse##73838
		|only Worgen
		|next "end"
	step
		goto Stormwind City 77.6,67.2
		.talk Darlene Stokx##43693
		.learn Apprentice Riding##33388
		|only Pandaren
	step
		goto 67.8,18.6
		.talk Old Whitenose##65068
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Reins of the Black Dragon Turtle##87795 |or
		.buy 1 Reins of the Blue Dragon Turtle##87796 |or
		.buy 1 Reins of the Brown Dragon Turtle##87797 |or
		.buy 1 Reins of the Green Dragon Turtle##82765 |or
		.buy 1 Reins of the Purple Dragon Turtle##87799 |or
		.buy 1 Reins of the Red Dragon Turtle##87800 |or
		|only Pandaren
		|next "end"
//JOURNEYMAN
	step
	label "journeyman"
		goto Stormwind City 77.6,67.2
		.talk Darlene Stokx##43693
		.learn Journeyman Riding##33391
		|only Human
	step
		goto Stormwind City 77.0,67.8
		.talk Katie Stokx##43694
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Brown Steed##18777 |or
		.buy 1 Swift Palomino##18776 |or
		.buy 1 Swift White Steed##18778 |or
		|only Human
		|next "end"
	step
		goto Dun Morogh 71.2,48.4
		.talk Ultham Ironhorn##4772
		.learn Journeyman Riding##33391
		|only Dwarf
	step
		goto Dun Morogh 70.6,48.8
		.talk Veron Amberstill##1261
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Brown Ram##18786 |or
		.buy 1 Swift Gray Ram##18787 |or
		.buy 1 Swift White Ram##18785 |or
		|only Dwarf
		|next "end"
	step
		goto Darnassus 42.6,33.6
		.talk Jartsam##4753
		.learn Journeyman Riding##33391
		|only Night Elf
	step
		goto Darnassus 42.6,32.8
		.talk Lelanai##4730
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Reins of the Swift Frostsaber##18766 |or
		.buy 1 Reins of the Swift Mistsaber##18767 |or
		.buy 1 Reins of the Swift Stormsaber##18902 |or
		|only Night Elf
		|next "end"
	step
		goto Dun Morogh 56.2,46.4
		.talk Binjy Featherwhistle##7954
		.learn Journeyman Riding##33391
		|only Gnome
	step
		goto Dun Morogh 56.2,46.2
		.talk Milli Featherwhistle##7955
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Green Mechanostrider##18772 |or
		.buy 1 Swift White Mechanostrider##18773 |or
		.buy 1 Swift Yellow Mechanostrider##18774 |or
		|only Gnome
		|next "end"
	step
		goto The Exodar 81.4,52.6
		.talk Aalun##20914
		.learn Journeyman Riding##33391
		|only Draenei
	step
		goto The Exodar 81.6,52.6
		.talk Torallius the Pack Handler##17584
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Great Blue Elekk##29745 |or
		.buy 1 Great Green Elekk##29746 |or
		.buy 1 Great Purple Elekk##29747 |or
		|only Draenei
		|next "end"
	step
		goto Darnassus 42.6,33.6
		.talk Jartsam##4753
		.learn Journeyman Riding##33391
		|only Night Elf
	step
		goto Darnassus 48.6,22.2
		.talk Astrid Langstrump##55285
		|tip You can use the level 20 mount you purchased, or pick this new mount.
		.buy 1 Swift Mountain Horse##73839
		|only Worgen
		|next "end"
	step
		goto Stormwind City 77.6,67.2
		.talk Darlene Stokx##43693
		.learn Journeyman Riding##33391
		|only Pandaren
	step
		goto 67.8,18.6
		.talk Old Whitenose##65068
		|tip You can use the level 20 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Reins of the Black Dragon Turtle##87795 |or
		.buy 1 Reins of the Blue Dragon Turtle##87796 |or
		.buy 1 Reins of the Brown Dragon Turtle##87797 |or
		.buy 1 Reins of the Green Dragon Turtle##82765 |or
		.buy 1 Reins of the Purple Dragon Turtle##87799 |or
		.buy 1 Reins of the Red Dragon Turtle##87800 |or
		|only Pandaren
		|next "end"
//EXPERT
	step
	label "expert"
		goto Stormwind City 70.6,73.0
		.talk Bralla Cloudwing##43769
		.learn Expert Riding##34090
	step
		goto Stormwind City 71.4,72.2
		.talk Tannec Stonebeak##43768
		|tip You can pick which one of these mounts you would like to use for your character.
		.buy 1 Ebon Gryphon##25471 |or
		.buy 1 Golden Gryphon##25470 |or
		.buy 1 Snowy Gryphon##25472 |or
		|next "end"
//FLIGHT LICENSE //TODO
	step
	label "flightlicense"
		goto Stormwind City 70.6,73.0
		.talk Bralla Cloudwing##43769
		.learn Flight Master's License##90267
		|next "end"
//COLD WEATHER
	step
	label "cold"
		goto Stormwind City 70.6,73.0
		.talk Bralla Cloudwing##43769
		.learn Cold Weather Flying##54197
		|next "end"
//ARTISAN
	step
	label "artisan"
		goto Stormwind City 70.6,73.0
		.talk Bralla Cloudwing##43769
		.learn Artisan Riding##34091
	step
		goto Stormwind City 71.4,72.2
		.talk Tannec Stonebeak##43768
		|tip You can use the level 60 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Blue Gryphon##25473 |or
		.buy 1 Swift Green Gryphon##25528 |or
		.buy 1 Swift Purple Gryphon##25529 |or
		.buy 1 Swift Red Gryphon##25527 |or
		|next "end"
//MASTER
	step
	label "master"
		goto Stormwind City 70.6,73.0
		.talk Bralla Cloudwing##43769
		.learn Artisan Riding##34091
	step
		goto Stormwind City 71.4,72.2
		.talk Tannec Stonebeak##43768
		|tip You can use the level 60 or 70 mount you purchased, or pick which one of these new mounts you would like to use for your character.
		.buy 1 Swift Blue Gryphon##25473 |or
		.buy 1 Swift Green Gryphon##25528 |or
		.buy 1 Swift Purple Gryphon##25529 |or
		.buy 1 Swift Red Gryphon##25527 |or
		|next "end"
//Panda LICENSE //TODO
	step
	label "pandarialicense"
		goto Shrine of Seven Stars
		.talk Cloudrunner Leng##60166
		.learn Wisdom of the Four Winds##115913
		|next "end"
//EXTRAS
	step
	label "allknown"
		'Congratulations, you have all mount training available!
		|confirm |next "end"
	step
	label "noneavail"
		'No new mount training is available at this time.
		|confirm |next "end"
	step
	label "end"
		'You have reached the end of the guide
		|confirm
]])

ZygorGuidesViewer:RegisterInclude("Profession_List_Blacksmith",[[
//trainer
		'You will learn this when you pick up Blacksmithing
		.learn Rough Copper Vest##12260
	step
		'You will learn this when you pick up Blacksmithing
		.learn Rough Sharpening Stone##2660
	step
		'You will learn this when you pick up Blacksmithing
		.learn Rough Weightstone##3115
	step
		'You will learn this when you pick up Blacksmithing
		.learn Copper Bracers##2663
	step
		'You will learn this when you pick up Blacksmithing
		.learn Copper Chain Pants##2662
	step
		#include "trainer_Blacksmithing"
		.learn Copper Mace##2737
	step
		#include "trainer_Blacksmithing"
		.learn Copper Axe##2738
	step
		#include "trainer_Blacksmithing"
		.learn Copper Chain Boots##3319
	step
		#include "trainer_Blacksmithing"
		.learn Rough Grinding Stone##3320
	step
		#include "trainer_Blacksmithing"
		.learn Copper Shortsword##2739
	step
		#include "trainer_Blacksmithing"
		.learn Copper Claymore##9983
	step
		#include "trainer_Blacksmithing"
		.learn Copper Dagger##8880
	step
		#include "trainer_Blacksmithing"
		.learn Copper Battle Axe##3293
	step
		#include "trainer_Blacksmithing"
		.learn Copper Chain Belt##2661
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Gauntlets##3323
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Pants##3324
	step
		#include "trainer_Blacksmithing"
		.learn Coarse Sharpening Stone##2665
	step
		#include "trainer_Blacksmithing"
		.learn Coarse Weightstone##3116
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Copper Maul##7408
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Belt##2666
	step
		#include "trainer_Blacksmithing"
		.learn Thick War Axe##3294
	step
		#include "trainer_Blacksmithing"
		.learn Coarse Grinding Stone##3326
	step
		#include "trainer_Blacksmithing"
		.learn Runed Copper Bracers##2664
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Boots##7817
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Copper Broadsword##3292
	step
		#include "trainer_Blacksmithing"
		.learn Silver Skeleton Key##19666
	step
		#include "trainer_Blacksmithing"
		.learn Big Bronze Knife##3491
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Cuirass##2670
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Leggings##2668
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Mace##2740
	step
		#include "trainer_Blacksmithing"
		.learn Pearl-handled Dagger##6517
	step
		#include "trainer_Blacksmithing"
		.learn Rough Bronze Shoulders##3328
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Axe##2741
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Shortsword##2742
	step
		#include "trainer_Blacksmithing"
		.learn Patterned Bronze Bracers##2672
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Sharpening Stone##2674
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Weightstone##3117
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Grinding Stone##3337
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Warhammer##9985
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Greatsword##9986
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Bronze Mace##3296
	step
		#include "trainer_Blacksmithing"
		.learn Silvered Bronze Boots##3331
	step
		#include "trainer_Blacksmithing"
		.learn Bronze Battle Axe##9987
	step
		#include "trainer_Blacksmithing"
		.learn Silvered Bronze Gauntlets##3333
	step
		#include "trainer_Blacksmithing"
		.learn Shining Silver Breastplate##2675
	step
		#include "trainer_Blacksmithing"
		.learn Iron Buckle##8768
	step
		#include "trainer_Blacksmithing"
		.learn Golden Skeleton Key##19667
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Leggings##3506
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Bracers##3501
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Hauberk##3508
	step
		#include "trainer_Blacksmithing"
		.learn Green Iron Helm##3502
	step
		#include "trainer_Blacksmithing"
		.learn Glinting Steel Dagger##15972
	step
		#include "trainer_Blacksmithing"
		.learn Golden Scale Bracers##7223
	step
		#include "trainer_Blacksmithing"
		.learn Solid Grinding Stone##9920
	step
		#include "trainer_Blacksmithing"
		.learn Solid Sharpening Stone##9918
	step
		#include "trainer_Blacksmithing"
		.learn Solid Weightstone##9921
	step
		#include "trainer_Blacksmithing"
		.learn Truesilver Skeleton Key##19668
	step
		#include "trainer_Blacksmithing"
		.learn Steel Breastplate##9916
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Gauntlet##9928
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Shoulder##9926
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Breastplate##9959
	step
		#include "trainer_Blacksmithing"
		.learn Mithril Coif##9961
	step
		#include "trainer_Blacksmithing"
		.learn Big Black Mace##10001
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Boots##9968
	step
		#include "trainer_Blacksmithing"
		.learn Dense Grinding Stone##16639
	step
		#include "trainer_Blacksmithing"
		.learn Dense Sharpening Stone##16641
	step
		#include "trainer_Blacksmithing"
		.learn Dense Weightstone##16640
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Armor##16642
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Belt##16643
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Bracers##16644
	step
		#include "trainer_Blacksmithing"
		.learn Mithril Scale Pants##9931
	step
		#include "trainer_Blacksmithing"
		.learn Heavy Mithril Axe##9993
	step
		#include "trainer_Blacksmithing"
		.learn Steel Plate Helm##9935
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Belt##16647
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Shoulders##16646
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Bracers##16649
	step
		#include "trainer_Blacksmithing"
		.learn Arcanite Skeleton Key##19669
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Thorium Handaxe##16969
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Boots##16652
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Helm##16653
	step
		#include "trainer_Blacksmithing"
		.learn Huge Thorium Battleaxe##16971
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Boots##16657
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Helm##16658
	step
		#include "trainer_Blacksmithing"
		.learn Fel Sharpening Stone##29654
	step
		#include "trainer_Blacksmithing"
		.learn Fel Weightstone##34607
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Coif##29551
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Gloves##29545
	step
		#include "trainer_Blacksmithing"
		.learn Thorium Leggings##16662
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Chest##16663
	step
		#include "trainer_Blacksmithing"
		.learn Imperial Plate Leggings##16730
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Belt##29547
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Gloves##29552
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Hatchet##29557
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Bracers##29553
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Hammer##29558
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Boots##29548
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Plate Pants##29549
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Chain Tunic##29556
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Greatsword##29565
	step
		#include "trainer_Blacksmithing"
		.learn Lesser Rune of Warding##32284
	step
		#include "trainer_Blacksmithing"
		.learn Fel Iron Breastplate##29550
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Skeleton Key##59405
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Belt##122583
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Gauntlets##122579
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Boots##122582
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Legplates##122580
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Shoulders##122577
	step
		#include "trainer_Blacksmithing"
		.learn Lightsteel Shield##122635
	step
		#include "trainer_Blacksmithing"
		.learn Living Steel Weapon Chain##131929
	step
		#include "trainer_Blacksmithing"
		.learn Spiritguard Shield##122636
	step
		#include "trainer_Blacksmithing"
		.learn Forgewire Axe##122637
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Blade##122638
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Breastplate##122578
	step
		#include "trainer_Blacksmithing"
		.learn Ghost-Forged Helm##122576
	step
		#include "trainer_Blacksmithing"
		.learn Phantasmal Hammer##122639
	step
		#include "trainer_Blacksmithing"
		.learn Ghost Shard##122641
	step
		#include "trainer_Blacksmithing"
		.learn Spiritblade Decimator##122640
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Belt##52568
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Boots##52569
	step
		#include "trainer_Blacksmithing"
		.learn Stormforged Gauntlets##76281
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Gauntlets##76180
	step
		#include "trainer_Blacksmithing"
		.learn Hardened Obsidium Shield##76291
	step
		#include "trainer_Blacksmithing"
		.learn Redsteel Gauntlets##76263
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Helm##52571
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Legplates##52567
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Gauntlets##55835
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Bracers##55834
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Shoulders##52572
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Triangle Shield##54550
	step
		#include "trainer_Blacksmithing"
		.learn Cobalt Tenderizer##55201
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Boots##54918
	step
		#include "trainer_Blacksmithing"
		.learn Sturdy Cobalt Quickblade##55200
	step
		#include "trainer_Blacksmithing"
		.learn Forged Cobalt Claymore##55203
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Chestpiece##54944
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Shoulders##54941
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Shoulders##55174
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Defender##54557
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Protector##55013
	step
		#include "trainer_Blacksmithing"
		.learn Notched Cobalt War Axe##55204
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Gauntlets##54945
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Belt##59436
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Legplates##55055
	step
		#include "trainer_Blacksmithing"
		.learn Savage Cobalt Slicer##55177
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Belt##54551
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Legplates##54554
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Belt##54946
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Legplates##54947
	step
		#include "trainer_Blacksmithing"
		.learn Socket Bracer##55628
	step
		#include "trainer_Blacksmithing"
		.learn Socket Gloves##55641
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Bracers##59438
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Gauntlets##55056
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Ambusher##55179
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Boots##54552
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Breastplate##54553
	step
		#include "trainer_Blacksmithing"
		.learn Horned Cobalt Helm##54949
	step
		#include "trainer_Blacksmithing"
		.learn Spiked Cobalt Bracers##54948
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Boots##55057
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Pauldrons##59440
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Shiv##55181
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Helm##54555
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Shoulders##54556
	step
		#include "trainer_Blacksmithing"
		.learn Deadly Saronite Dirk##55206
	step
		#include "trainer_Blacksmithing"
		.learn Cudgel of Saronite Justice##56280
	step
		#include "trainer_Blacksmithing"
		.learn Furious Saronite Beatstick##55182
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Bulwark##55014
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Spellblade##59442
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Bracers##55017
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Breastplate##55058
	step
		#include "trainer_Blacksmithing"
		.learn Brilliant Saronite Helm##59441
	step
		#include "trainer_Blacksmithing"
		.learn Eternal Belt Buckle##55656
	step
		#include "trainer_Blacksmithing"
		.learn Saronite Mindcrusher##55185
	step
		#include "trainer_Blacksmithing"
		.learn Tempered Saronite Gauntlets##55015
	step
		#include "trainer_Blacksmithing"
		.learn Ornate Saronite Bracers##56549
	step
		#include "trainer_Blacksmithing"
		.learn Savage Saronite Bracers##55305
	step
		#include "trainer_Blacksmithing"
		.learn Vengeance Bindings##55298
	step
		#include "trainer_Blacksmithing"
		.learn Titanium Shield Spike##56357
	step
		#include "trainer_Blacksmithing"
		.learn Titanium Weapon Chain##55839
	step
		#include "trainer_Blacksmithing"
		.learn Icebane Girdle##61009
	step
		#include "trainer_Blacksmithing"
		.learn