﻿
-- Thank you to all of the translators that have helped localize Overachiever. In addition to those mentioned
-- below in their respective sections, recognition is due to all who have used the localization system provided
-- for Overachiever by Curse Forge. See a list of them here:
-- http://wow.curseforge.com/projects/overachiever/localization/translators/

OVERACHIEVER_STRINGS = {
	BINDING_NAME_OVERACHIEVER_TAB_SEARCH = "Open Search Tab";
	BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS = "Open Suggestions Tab";
	BINDING_NAME_OVERACHIEVER_TAB_WATCH = "Open Watch Tab";

	SERIESTIP = "Part of a series:";
	REQUIREDFORMETATIP = "Required for:";

	PROGRESS = "Progress";
	YOURPROGRESS = "Your Progress";
	COMPLETEDATE = "Completed on %2$d/%1$02d/%3$02d";  -- 1 - day 2 - month 3 - year
	INCOMPLETE = "Incomplete";

	KILL_INCOMPLETE = "Need to kill";
	KILL_COMPLETE = "Already killed";

	CRITTER = "Critter";
	ACH_LOVECRITTERS_INCOMPLETE = "Needs some /love";
	ACH_LOVECRITTERS_COMPLETE = "Already /loved";

	ACH_WELLREAD_INCOMPLETE = "Needs to be read";
	ACH_WELLREAD_COMPLETE = "Already read";

	ACH_ANGLER_INCOMPLETE = "Need to fish";
	ACH_ANGLER_COMPLETE = "Already fished";

	ACH_CONSUME_INCOMPLETE = "Need to consume";
	ACH_CONSUME_COMPLETE = "Already consumed";
	ACH_CONSUME_INCOMPLETE_EXTRA = "Haven't consumed";

	ACH_LETITSNOW_INCOMPLETE = "Need to use Handful of Snowflakes";
	ACH_LETITSNOW_COMPLETE = "Already used Handful of Snowflakes";
	ACH_FISTFULOFLOVE_INCOMPLETE = "Need to use Handful of Rose Petals";
	ACH_FISTFULOFLOVE_COMPLETE = "Already used Handful of Rose Petals";
	ACH_BUNNYMAKER_INCOMPLETE = "Need to use Spring Flowers";
	ACH_BUNNYMAKER_COMPLETE = "Already used Spring Flowers";
	ACH_CHECKYOURHEAD_INCOMPLETE = "Needs a pumpkin head";
	ACH_CHECKYOURHEAD_COMPLETE = "Already pumpkin-headed";
	ACH_TURKEYLURKEY_INCOMPLETE = "Needs feathers";
	ACH_TURKEYLURKEY_COMPLETE = "Already feathered";

	MSG_INVALIDID = "Invalid input: No achievement with that ID.";
	MSG_NAMENOTFOUND = 'No achievement with name containing "|cffffffff%s|r" was found.';
	MSG_OPENINGTO = "Opening to: ";
	MSG_ONEFOUND = "1 other achievement found: ";
	MSG_NUMFOUNDLIST = "%s other achievements found:";
	MSG_ACHNOTFOUND = "Achievement not found.";

	OPTPANEL_REMINDERTOOLTIPS = "Reminder Tooltips";

	OPT_LABEL_SEASONALACHS = "SEASONAL ACHIEVEMENTS";

	OPT_LABEL_ACHTWO = '"%s" and "%s"';
	OPT_LABEL_ACHTHREE = '"%s," "%s," and|n"%s"';

	OPT_ACHUNKNOWN = "<Unknown>";

	OPT_LABEL_TOOLTIPS = "Achievement Tooltips and Links";
	OPT_SHOWPROGRESS = "Add your progress";
	OPT_SHOWPROGRESS_TIP = 'Add your progress when an achievement has quantity-based criteria, such as "Obtain 10 mounts."';
	OPT_SHOWPROGRESS_OTHER = "Compare progress in others' links";
	OPT_SHOWPROGRESS_OTHER_TIP = "Add your progress when the achievement info shown is that of another player.";
	OPT_SHOWID = "Show achievement IDs";

	OPT_LABEL_TRACKING = "Achievement Tracking";
	OPT_AUTOTRACKTIMED = "Auto-track timed achievements";
	OPT_AUTOTRACKTIMED_TIP = "Automatically track achievements with timed criteria when the timer starts. If you are already tracking the maximum number of achievements, it will attempt to take the place of an auto-tracked exploration achievement; otherwise, it won't be tracked.";
	OPT_AUTOTRACKEXPLORE = "Auto-track exploration achievements as you travel";
	OPT_AUTOTRACKEXPLORE_TIP = "When you enter a zone, automatically track its exploration achievement. If already tracking an exploration achievement, this will replace the previous automatically-tracked one if there is one or another exploration achievement otherwise.";
	OPT_AUTOTRACKEXPLORE_COMPLETED = "Including completed achievements";

	OPT_CRITTERTIPS = "Critter /loved?";
	OPT_CRITTERTIPS_TIP = "If this achievement is incomplete, add a line to the tooltips of critters that are part of its criteria to indicate whether you still need to /love that type of critter.";
	OPT_PESTCONTROLTIPS = "Pest exterminated?";
	OPT_PESTCONTROLTIPS_TIP = "If this achievement is incomplete, add a line to the tooltips of critters that are part of its criteria to indicate whether you still need to exterminate them.";
	OPT_WELLREADTIPS = "Book read?";
	OPT_WELLREADTIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of books that are part of its criteria to indicate whether you need to read them.";
	OPT_ANGLERTIPS = "Fishing node fished?";
	OPT_ANGLERTIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of fishing nodes that are part of its criteria to indicate whether you need to fish from them.";

	OPT_LETITSNOWTIPS = "Handful of Snowflakes used?";
	OPT_LETITSNOWTIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of players of an appropriate race/class combo to indicate whether you need to use a Handful of Snowflakes on them.";
	OPT_FISTFULOFLOVETIPS = "Handful of Rose Petals used?";
	OPT_FISTFULOFLOVETIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of players of an appropriate race/class combo to indicate whether you need to use a Handful of Rose Petals on them.";
	OPT_BUNNYMAKERTIPS = "Spring Flowers used?";
	OPT_BUNNYMAKERTIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of players of an appropriate gender and level to indicate whether you need to use Spring Flowers on them. Note that enemy players that are 10 or more levels higher than you are assumed to be at least level 18.";
	OPT_CHECKYOURHEADTIPS = "Weighted Jack-o'-Lantern used?";
	OPT_CHECKYOURHEADTIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of players to indicate whether you need to use a Weighted Jack-o'-Lantern on them.";
	OPT_TURKEYLURKEYTIPS = "Turkey Shooter used?";
	OPT_TURKEYLURKEYTIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of players to indicate whether you need to use your Turkey Shooter on them.";

	OPT_CONSUMEITEMTIPS = "Item consumed?";
	OPT_CONSUMEITEMTIPS_TIP = "If the achievement is incomplete, add a line to the tooltips of items that are part of its criteria to indicate whether you need to consume them.";
	OPT_CONSUMEITEMTIPS_TIP2 = "Items that you are too low level to consume will not trigger a reminder sound.";
	--OPT_CONSUMEITEMTIPS_TIP3 = "Note: This option can add a few seconds to your initial load time.";
	OPT_CONSUMEITEMTIPS_WHENCOMPLETE = "Show even if achievement is complete";

	OPT_LABEL_NEEDTOKILL = 'Kill Creature Achievements ("%s," "%s," etc.)';
	OPT_KILLCREATURETIPS = "Creature killed?";
	OPT_KILLCREATURETIPS_TIP = "Add a line to the tooltips of creatures (excluding critters) that need to be killed to meet the criteria of an incomplete achievement indicating whether you still need to kill them.";
	OPT_KILLCREATURETIPS_TIP2 = "Note: At startup (or when this is option is enabled), every achievement is scanned to find unit IDs. Not all achievements provide such IDs. Most do, but the tooltips of creatures which are the criteria of those that don't won't be altered by this option.";

	OPT_LABEL_MAINUI = "Main Achievement UI Modifications";
	OPT_UI_SERIESTIP = "Tooltip for achievements that are part of a series";
	OPT_UI_SERIESTIP_TIP = "When the cursor is over an achievement that is part of a series, display the names of others in the series and its relation to them.";
	OPT_UI_REQUIREDFORMETATIP = "Tooltip for achievements required by others";
	OPT_UI_REQUIREDFORMETATIP_TIP = "When the cursor is over an achievement that is required to earn another achievement, display the name of the meta-achievement.";
	OPT_DRAGGABLE = "Make draggable";
	OPT_DRAGSAVE = "Remember position";

	OPT_SELECTSOUND = "Incomplete Achievement Reminder Sound";
	OPT_SELECTSOUND_TIP = "Play the selected sound when an incomplete achievement reminder is added to the tooltip.";
	OPT_SELECTSOUND_TIP2 = "Sounds will only play once every 15 seconds.";
	OPT_SELECTSOUND_ANGLERCHECKPOLE = "Exclude fishing node reminders if pole is equipped";
	OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP = "Don't play reminder sound from fishing nodes if your fishing pole is equipped.";

	SOUND_BELL_ALLIANCE = "Bell - Alliance";
	SOUND_BELL_HORDE = "Bell - Horde";
	SOUND_BELL_NIGHTELF = "Bell - Night Elf";
	SOUND_DRUMHIT = "Drum Hit";
	SOUND_BELL_BOATARRIVED = "Bells - Boat Arrived";
	SOUND_GONG_TROLL = "Gong - Troll";
	SOUND_BELL_MELLOW = "Mellow Bells";
	SOUND_ENTERQUEUE = "Enter Queue";
	SOUND_HEARTHBIND = "Hearthstone Bind";
	SOUND_BELL_KARA = "Karazhan Bell";
	SOUND_DING_AUCTION = "Auction Ding";
	SOUND_BELL_AUCTION = "Auction Bells";
	SOUND_ALARM1 = "Alarm Clock 1";
	SOUND_ALARM2 = "Alarm Clock 2";
	SOUND_ALARM3 = "Alarm Clock 3";
	SOUND_MAP_PING = "Map Ping";
	SOUND_SIMON_DING = "Simon Ding";
	SOUND_SIMON_STARTGAME = "Simon Start Game";
	SOUND_SIMON_STARTLEVEL = "Simon Start Level";
	SOUND_YAR = "Yarrrr";
}

local L, locale = OVERACHIEVER_STRINGS, GetLocale()

--if (locale == "enGB") then  -- English (EU)
-- Unfortunately, GetLocale() returns "enUS" even when "enGB" would be more appropriate, and the SHORTDATE
-- global string is defined incorrectly for enGB clients (it's set as it is for enUS), so we have to do things
-- this way:
if (ACHIEVEMENT_TOOLTIP_COMPLETE == "Achievement earned by %1$s on %3$d/%2$d/20%4$02d") then
	L["COMPLETEDATE"] = "Completed on %1$d/%2$02d/%3$02d";  -- 1 - day 2 - month 3 - year
end

if (locale == "deDE") then  -- German
-- Thanks to users Svensn and Farook at wowinterface.com for these translations:
L["ACH_ANGLER_COMPLETE"] = "Bereits gefischt"
L["ACH_ANGLER_INCOMPLETE"] = "Muss noch geangelt werden"
L["ACH_BUNNYMAKER_COMPLETE"] = "Frühlingsblumen bereits benutzt"
L["ACH_BUNNYMAKER_INCOMPLETE"] = "Frühlingsblumen müssen noch benutzt werden"
L["ACH_CHECKYOURHEAD_COMPLETE"] = "Kürbis bereits aufgesetzt"
L["ACH_CHECKYOURHEAD_INCOMPLETE"] = "Benötigt noch einen Kürbis-Kopf"
L["ACH_CONSUME_COMPLETE"] = "Bereits konsumiert"
L["ACH_CONSUME_INCOMPLETE"] = "Muss noch konsumiert werden"
L["ACH_CONSUME_INCOMPLETE_EXTRA"] = "Hast nicht konsumiert"
L["ACH_FISTFULOFLOVE_COMPLETE"] = "Handvoll Rosenblüten wurde bereits verwendet"
L["ACH_FISTFULOFLOVE_INCOMPLETE"] = "Handvoll Rosenblüten muss noch verwendet werden"
L["ACH_LETITSNOW_COMPLETE"] = "Hand voll Schneeflocken wurde bereits verwendet"
L["ACH_LETITSNOW_INCOMPLETE"] = "Hand voll Schneeflocken muss noch verwendet werden"
L["ACH_LOVECRITTERS_COMPLETE"] = "Wurde bereits geliebt"
L["ACH_LOVECRITTERS_INCOMPLETE"] = "Braucht etwas Liebe ... /liebe"
L["ACH_TURKEYLURKEY_COMPLETE"] = "Bereits gefiedert"
L["ACH_TURKEYLURKEY_INCOMPLETE"] = "Muss noch gefiedert werden"
L["ACH_WELLREAD_COMPLETE"] = "Bereits gelesen"
L["ACH_WELLREAD_INCOMPLETE"] = "Muss noch gelesen werden"
L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = "Suche-Tab öffnen"
L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = "Vorschläge-Tab öffnen"
L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = "Beobachtungs-Tab öffnen"
L["COMPLETEDATE"] = "Abgeschlossen am %2$d/%1$02d/%3$02d"
L["CRITTER"] = "Tier"
L["INCOMPLETE"] = "Nicht abgeschlossen"
L["KILL_COMPLETE"] = "Bereits getötet"
L["KILL_INCOMPLETE"] = "Muss getötet werden"
L["MSG_ACHNOTFOUND"] = "Erfolg nicht gefunden."
L["MSG_INVALIDID"] = "Ungültige Eingabe: Kein Erfolg mit dieser ID."
L["MSG_NAMENOTFOUND"] = "Es wurde kein Erfolg gefunden dessen Name \"|cffffffff%s|r\" enthält."
L["MSG_NUMFOUNDLIST"] = "%s weitere Erfolge gefunden:"
L["MSG_ONEFOUND"] = "1 weiterer Erfolg gefunden: "
L["MSG_OPENINGTO"] = "Öffnen nach: "
L["OPT_ACHUNKNOWN"] = "<Unbekannt>"
L["OPT_ANGLERTIPS"] = "Hinzufügen ob du einen Schwarm befischt hast oder noch nicht."
L["OPT_ANGLERTIPS_TIP"] = "Einen Hinweis im Tooltip von Fischschwärmen die zu diesem Achievement gehören anzeigen, wenn dieses Achievement noch nicht abgeschlossen ist."
L["OPT_AUTOTRACKEXPLORE"] = "Erkundungs-Achievements beim Reisen automatisch nachverfolgen"
L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = "Abgeschlossene Achievements inkludieren"
L["OPT_AUTOTRACKEXPLORE_TIP"] = "Wenn du ein neues Gebiet betrittst, automatisch das dazugehörige Erkundungs-Achievement aktivieren. Die Anzeige wechselt nicht wenn zu diesem Zeitpunkt ein Achievement im Tracker angezeigt wird, welches nichts mit der Erkundung bestimmter Gegenden zu tun hat."
L["OPT_AUTOTRACKTIMED"] = "Auto-Verfolgung von zeitlich festgelegten Erfolgen"
L["OPT_AUTOTRACKTIMED_TIP"] = "Erfolge mit zeitlich festgelegten Kriterien automatisch verfolgen wenn der Timer beginnt. Wechselt nicht wenn ein anderes Achievement verfolgt wird, außer wenn es automatisch von Overachiever verfolgt wird."
L["OPT_BUNNYMAKERTIPS"] = "Hinzufügen ob Frühlingsblumen noch verwendet werden müssen oder nicht."
L["OPT_BUNNYMAKERTIPS_TIP"] = "Wenn der Erfolg noch nicht abgeschlossen ist, dem Tooltip eine Info bei Spielern des richtigen Geschlechts und Levels hinzufügen wenn auf sie noch Frühlingsblumen angewendet werden müssen. Beachte, dass gegnerische Spieler die 10 oder mehr Levels über dir sind als mindestens Level 18 angesehen werden."
L["OPT_CHECKYOURHEADTIPS"] = "Hinzufügen ob du die Gewichtige Kürbislaterne verwenden musst oder nicht"
L["OPT_CHECKYOURHEADTIPS_TIP"] = "Wenn der Erfolg noch nicht abgeschlossen ist, dem Tooltip von Spielern eine Zeile hinzufügen, ob die Gewichtige Kürbislaterne noch auf sie angewendet werden muss oder nicht."
L["OPT_CONSUMEITEMTIPS"] = "Zum Tooltop hinzufügen ob ein Gegenstand noch konsumiert werden muss oder nicht."
L["OPT_CONSUMEITEMTIPS_TIP"] = "Wenn das Achievement noch nicht abgeschlossen ist, dem Tooltip die Anzeige hinzufögen ob der jeweilige Gegenstand - sofern er den Kriterien entspricht - noch konsumiert werden muss."
L["OPT_CONSUMEITEMTIPS_TIP2"] = "Gegenstände für die du ein noch zu geringes Level zum Konsumieren hast, werden keinen Benachrichtigungston auslösen."
L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = "Auch anzeigen wenn das Achievement bereits abgeschlossen ist"
L["OPT_CRITTERTIPS"] = "Den /geliebt-Status von Tieren im Tooltip hinzufügen"
L["OPT_CRITTERTIPS_TIP"] = "Einen Hinweis im Tooltip von Tieren die zu diesem Achievement gehören anzeigen, wenn dieses Achievement noch nicht abgeschlossen ist."
L["OPT_DRAG_ACHFRAME"] = "Erfolge"
L["OPT_DRAG_ACHTRACKER"] = "Achievement-Tracker"
L["OPT_DRAGGABLE"] = "Verschiebbar machen"
L["OPT_DRAGLOCK"] = "Position sperren"
L["OPT_DRAGSAVE"] = "Position merken"
L["OPT_FISTFULOFLOVETIPS"] = "Hinzufügen ob du die Handvoll Rosenblüten noch auf einen Spieler verwenden musst oder nicht"
L["OPT_FISTFULOFLOVETIPS_TIP"] = "Einen Hinweis im Tooltip von Spielern einer entsprechenden Rassen-/Klassenkombination die zu diesem Achievement gehören anzeigen, wenn dieses Achievement noch nicht abgeschlossen ist."
L["OPT_KILLCREATURETIPS"] = "Hinzufügen ob man eine bestimmte Kreatur töten muss."
L["OPT_KILLCREATURETIPS_TIP"] = "Dem Tooltip von Kreaturen die noch getötet werden müssen um ein Kriterium eines nicht abgeschlossenen Erfolges zu erfüllen eine Info-Zeile hinzufügen die anzeigt, dass man dieses Monster noch töten muss."
L["OPT_KILLCREATURETIPS_TIP2"] = "Anmerkung: Beim Start (oder wenn diese Option aktiviert ist), wird jeder Erfolg gescannt, um die IDs der Einheiten festzustellen. Nicht alle Erfolge liefern derartige IDs. Die meisten tun es, aber die Tooltips der Kreaturen, die Kriterien solcher Erfolge ohne ID sind, werden durch diese Option nicht verändert."
L["OPT_LABEL_ACHTHREE"] = "\"%s,\" \"%s,\" und|n\"%s\""
L["OPT_LABEL_ACHTWO"] = "\"%s\" und \"%s\""
L["OPT_LABEL_DRAG"] = "Verschiebbare Felder"
L["OPT_LABEL_MAINUI"] = "Besondere UI-Modifikationen für Erfolge"
L["OPT_LABEL_NEEDTOKILL"] = "Kreaturen-töten-Erfolge (\"%s,\" \"%s,\" etc.)"
L["OPT_LABEL_SEASONALACHS"] = "WELTEREIGNIS-ERFOLGE"
L["OPT_LABEL_TOOLTIPS"] = "Achievement: Tooltips und Links"
L["OPT_LABEL_TRACKING"] = "Achievement: Tracking"
L["OPT_LETITSNOWTIPS"] = "Hinzufügen ob du eine Hand voll Schneeflocken noch auf einen Spieler anwenden musst oder nicht."
L["OPT_LETITSNOWTIPS_TIP"] = "Einen Hinweis im Tooltip von Spielern einer entsprechenden Rassen-/Klassenkombination die zu diesem Achievement gehören anzeigen, wenn dieses Achievement noch nicht abgeschlossen ist."
L["OPTPANEL_REMINDERTOOLTIPS"] = "Erinnerungshinweise"
L["OPT_PESTCONTROLTIPS"] = "Im Tooltip anzeigen, ob dieses Ungeziefer bereits getötet wurde."
L["OPT_PESTCONTROLTIPS_TIP"] = "Falls dieses Achievement noch nicht abgeschloßen ist, wird im Tooltip des Ungeziefers angezeigt, ob es bereits getötet wurde."
L["OPT_SELECTSOUND"] = "Benachrichtigungston: Nicht abgeschlossenes Achievement"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = "Fischschwarm-Benachrichtigungen weglassen, wenn eine Angel angelegt ist."
L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = "Keinen Ton bei Fischschwärmen abspielen, wenn du gerade deine Angel angelegt hast."
L["OPT_SELECTSOUND_TIP"] = "Den ausgewählten Ton abspielen wenn dem Tooltip eine Benachrichtigung hinzugefügt wird, dass das entsprechende Achievement noch nicht abgeschlossen ist."
L["OPT_SELECTSOUND_TIP2"] = "Töne werden nur einmal alle 15 Sekunden abgespielt."
L["OPT_SHOWID"] = "Achievement-IDs anzeigen"
L["OPT_SHOWPROGRESS"] = "Deinen Fortschritt hinzufügen"
L["OPT_SHOWPROGRESS_OTHER"] = "Vergleiche den Fortschritt in Links von anderen Spielern"
L["OPT_SHOWPROGRESS_OTHER_TIP"] = "Füge deinen Fortschritt hinzu wenn die gezeigte Achievement-Information von einem anderen Spieler kommt."
L["OPT_SHOWPROGRESS_TIP"] = "Füge deinen Fortschritt hinzu wenn das Achievement ein mengenbasierendes Kriterium enthält, wie zum Beispiel \"Erhalte 10 Reittiere.\""
L["OPT_TRACKERGREENCHECK"] = "Einen Haken neben dem abgeschlossenen Erfolgssymbol anzeigen"
L["OPT_TRACKERGREENCHECK_TIP"] = "Einen grünen Haken neben dem Symbol am Tracker anzeigen, sobald der Erfolg abgeschlossen wurde."
L["OPT_TURKEYLURKEYTIPS"] = "Truthahnbüchse bereits verwendet?"
L["OPT_TURKEYLURKEYTIPS_TIP"] = "Falls der Erfolg unvollständig ist, dem Tooltip von Spielern hinzufügen, ob die Truthahnbüchse bei diesen noch verwendet werden muss."
L["OPT_UI_REQUIREDFORMETATIP"] = "Im Tooltip anzeigen ob dieses Achievement für weitere benötigt wird"
L["OPT_UI_REQUIREDFORMETATIP_TIP"] = "Wenn auf ein Achievement gezeigt wird das für ein anderes benötigt wird, wird der Name des Meta-Erfolgs im Tooltip angezeigt."
L["OPT_UI_SERIESTIP"] = "Tooltip für Erfolge, die Teil einer Reihe sind"
L["OPT_UI_SERIESTIP_TIP"] = "Wenn der Mauscursor über einem Achievement ist, das einer Serie angehört, werden alle dazugehörigen Achievements ebenfalls aufgelistet."
L["OPT_WELLREADTIPS"] = "Im Tooltip anzeigen, ob dieses Buch bereits gelesen wurde oder nicht."
L["OPT_WELLREADTIPS_TIP"] = "Einen Hinweis im Tooltip von Büchern die zu diesem Achievement gehören anzeigen, wenn dieses Achievement noch nicht abgeschlossen ist."
L["PROGRESS"] = "Fortschritt"
L["REQUIREDFORMETATIP"] = "Benötigt für:"
L["SERIESTIP"] = "Teil einer Reihe:"
L["SOUND_ALARM1"] = "Alarm Ton 1"
L["SOUND_ALARM2"] = "Alarm Ton 2"
L["SOUND_ALARM3"] = "Alarm Ton 3"
L["SOUND_BELL_ALLIANCE"] = "Glocke - Allianz"
L["SOUND_BELL_AUCTION"] = "Glocke - Auktionshaus"
L["SOUND_BELL_BOATARRIVED"] = "Glocke - Schiff angekommen"
L["SOUND_BELL_HORDE"] = "Glocke - Horde"
L["SOUND_BELL_KARA"] = "Glocke - Karazhan"
L["SOUND_BELL_MELLOW"] = "Helle Glocken"
L["SOUND_BELL_NIGHTELF"] = "Glocke - Nachtelf"
L["SOUND_DING_AUCTION"] = "Auctionsding"
L["SOUND_DRUMHIT"] = "Trommelschlag"
L["SOUND_ENTERQUEUE"] = "Warteschlange beitreten"
L["SOUND_GONG_TROLL"] = "Gong - Troll"
L["SOUND_HEARTHBIND"] = "Ruhestein setzen"
L["SOUND_MAP_PING"] = "Map Ping"
L["SOUND_SIMON_DING"] = "Simon Ding"
L["SOUND_SIMON_STARTGAME"] = "Simon Spielstart"
L["SOUND_SIMON_STARTLEVEL"] = "Simon Startlevel"
L["SOUND_YAR"] = "Yarrrr"
L["YOURPROGRESS"] = "Dein Fortschritt"


elseif (locale == "frFR") then  -- French
-- Thanks to Atropyne (EU-Garona) for these translations:
L["ACH_ANGLER_COMPLETE"] = "Déjà pêché"
L["ACH_ANGLER_INCOMPLETE"] = "Doit être pêché"
L["ACH_BUNNYMAKER_COMPLETE"] = "A déjà utilisé les Fleurs printanières"
L["ACH_BUNNYMAKER_INCOMPLETE"] = "Doit utiliser les Fleurs printanières"
L["ACH_CHECKYOURHEAD_COMPLETE"] = "Déjà citrouillé"
L["ACH_CHECKYOURHEAD_INCOMPLETE"] = "Doit être citrouillé"
L["ACH_CONSUME_COMPLETE"] = "Déjà consommé"
L["ACH_CONSUME_INCOMPLETE"] = "Doit être consommé"
L["ACH_CONSUME_INCOMPLETE_EXTRA"] = "N'a pas été consommé"
L["ACH_FISTFULOFLOVE_COMPLETE"] = "A déjà reçu une Poignée de pétales de rose"
L["ACH_FISTFULOFLOVE_INCOMPLETE"] = "Doit recevoir une Poignée de pétales de rose"
L["ACH_LETITSNOW_COMPLETE"] = "A déjà reçu une Poignée de flocons de neige"
L["ACH_LETITSNOW_INCOMPLETE"] = "Doit lancer une Poignée de flocons de neige"
L["ACH_LOVECRITTERS_COMPLETE"] = "A déjà reçu de l' /amour"
L["ACH_LOVECRITTERS_INCOMPLETE"] = "A besoin d' /amour"
L["ACH_TURKEYLURKEY_COMPLETE"] = "Déjà Dindonisé"
L["ACH_TURKEYLURKEY_INCOMPLETE"] = "Doit être Dindonisé"
L["ACH_WELLREAD_COMPLETE"] = "Déjà lu"
L["ACH_WELLREAD_INCOMPLETE"] = "Doit être lu"
L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = "Ouvrir l'onglet de recherche"
L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = "Ouvrir l'onglet des suggestions"
L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = "Ouvre l'onglet de suivi"
L["COMPLETEDATE"] = "Accompli le %1$d/%2$02d/%3$02d"
L["CRITTER"] = "Bestiole"
L["INCOMPLETE"] = "Inachevé"
L["KILL_COMPLETE"] = "Déjà tué"
L["KILL_INCOMPLETE"] = "Doit tuer"
L["MSG_ACHNOTFOUND"] = "Haut fait introuvable."
L["MSG_INVALIDID"] = "Entrée invalide : aucun haut fait ne correspond à cette ID."
L["MSG_NAMENOTFOUND"] = "Aucun haut fait contenant le nom \"|cffffffff%s|r\" n'a été trouvé."
L["MSG_NUMFOUNDLIST"] = "%s autres haut faits trouvés :"
L["MSG_ONEFOUND"] = "1 autre haut fait trouvé : "
L["MSG_OPENINGTO"] = "Ouverture de : "
L["OPT_ACHUNKNOWN"] = "<Inconnu>"
L["OPT_ANGLERTIPS"] = "Ajoute à l'infobulle d'un banc de poisson s'il a déjà été pêché"
L["OPT_ANGLERTIPS_TIP"] = "Si le haut fait est inachevé, ajoute une ligne à l'infobulle des bancs de poissons concernés pour indiquer si vous devez y pêcher."
L["OPT_AUTOTRACKEXPLORE"] = "Suivi automatique des haut faits d'exploration quand vous voyagez"
L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = "Inclure les haut faits accomplis"
L["OPT_AUTOTRACKEXPLORE_TIP"] = "Quand vous entrez dans une zone, active automatiquement le suivi du haut fait d'exploration associé. Ne s'active pas si vous suivez déjà autre chose qu'un autre haut fait d'exploration."
L["OPT_AUTOTRACKTIMED"] = "Suivi automatique des hauts faits chronométrés"
L["OPT_AUTOTRACKTIMED_TIP"] = "Active automatiquement le suivi des hauts faits chronométrés lorsque le décompte commence. Ne s'active pas si un autre haut fait est en cours de suivi à moins que celui-ci n'ait été activé par Overachiever."
L["OPT_BUNNYMAKERTIPS"] = "Ajoute si devez utiliser les Fleurs printanières"
L["OPT_BUNNYMAKERTIPS_TIP"] = "Si le haut fait est inachevé, ajoute une ligne à l'infobulle des joueurs des genre et niveau appropriés pour indiquer si vous devez encore utiliser les Fleurs printanières sur eux. Notez que les joueurs ennemis qui ont 10 niveaux de plus que vous ou davantage sont considérés comme étant au moins de niveau 18."
L["OPT_CHECKYOURHEADTIPS"] = "Ajoute si vous devez utiliser une citrouille de la Sanssaint lestée"
L["OPT_CHECKYOURHEADTIPS_TIP"] = "Si le haut fait n'est pas terminé, ajoute une ligne à l'infobulle des joueurs pour indiquer si vous devez encore utiliser une citrouille de la Sanssaint lestée sur eux."
L["OPT_CONSUMEITEMTIPS"] = "Ajoute à l'infobulle des objets s'ils doivent être consommés"
L["OPT_CONSUMEITEMTIPS_TIP"] = "Si le haut fait est inachevé, ajoute une ligne à l'infobulle des objets concernés pour indiquer si vous avez besoin de les consommer."
L["OPT_CONSUMEITEMTIPS_TIP2"] = "Les objets pour l'utilisation desquels votre niveau est insuffisant ne déclenchent pas de rappel sonore."
L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = "Afficher même si le haut fait est accompli."
L["OPT_CRITTERTIPS"] = "Ajouter le statut /amour dans l'infobulle des bestioles "
L["OPT_CRITTERTIPS_TIP"] = "Si ce haut fait est inachevé, ajoute une ligne à l'infobulle des bestioles concernées pour indiquer qu'elles ont toujours besoin d' /amour."
L["OPT_DRAG_ACHFRAME"] = "Fenêtre principale de l'IU Hauts faits"
L["OPT_DRAG_ACHTRACKER"] = "Suivi des Hauts faits"
L["OPT_DRAGGABLE"] = "Rendre mobile"
L["OPT_DRAGLOCK"] = "Bloquer la position"
L["OPT_DRAGSAVE"] = "Sauver la position"
L["OPT_FISTFULOFLOVETIPS"] = "Vous signale si vous avez besoin de lancer une Poignée de pétales de rose"
L["OPT_FISTFULOFLOVETIPS_TIP"] = "Si le haut fait est inachevé, ajoute une ligne à l'infobulle des joueurs des combinaisons race/classe concernées pour vous indiquer si vous devez utiliser une Poignée de pétales de rose sur eux."
L["OPT_KILLCREATURETIPS"] = "Ajoute si vous devez tuer une créature"
L["OPT_KILLCREATURETIPS_TIP"] = "Ajoute une ligne à l'infobulle des créatures (hormis les bestioles) qui doivent être tuées pour atteindre l'objectif d'un haut fait inachevé pour indiquer si vous devez encore les tuer."
L["OPT_KILLCREATURETIPS_TIP2"] = "Note : Au démarrage (ou lorsque cette option est activée) tous les hauts faits sont analysés afin de découvrir les IDs des \"unités\". Ils n'en fournissent pas tous. La plupart le font, mais les infobulles des créatures concernées par ceux qui ne le font pas ne seront pas affectées par cette option."
L["OPT_LABEL_ACHTHREE"] = "\"%s,\" \"%s,\" et|n\"%s\""
L["OPT_LABEL_ACHTWO"] = "\"%s\" et \"%s\""
L["OPT_LABEL_DRAG"] = "Fenêtres déplaçables"
L["OPT_LABEL_MAINUI"] = "Modifications de l'IU principale des Hauts faits"
L["OPT_LABEL_NEEDTOKILL"] = "Hauts faits d'élimination de monstres (\"%s,\" \"%s,\" etc.)"
L["OPT_LABEL_SEASONALACHS"] = "SAISON ACHEVÉES"
L["OPT_LABEL_TOOLTIPS"] = "Infobulles et liens des haut faits"
L["OPT_LABEL_TRACKING"] = "Suivi des haut faits"
L["OPT_LETITSNOWTIPS"] = "Vous signale si vous avez besoin de lancer une Poignée de flocons de neige"
L["OPT_LETITSNOWTIPS_TIP"] = "Si le haut fait est inachevé, ajoute une ligne à l'infobulle des joueurs des combinaisons de race/classe concernées pour vous indiquer si vous devez utiliser une Poignée de flocons de neige sur eux."
L["OPTPANEL_REMINDERTOOLTIPS"] = "Rappel des info-bulles"
L["OPT_PESTCONTROLTIPS"] = "Ajoute à l'infobulle des nuisibles si vous les avez déjà exterminés"
L["OPT_PESTCONTROLTIPS_TIP"] = "Si ce haut fait est inachevé, ajoute une ligne à l'infobulle des nuisibles concernés pour indiquer si vous devez encore les exterminer."
L["OPT_SELECTSOUND"] = "Rappel sonore de haut fait inachevé"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = "Exclure les rappels des banc de poissons si une canne à pêche est équipée"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = "Ne pas jouer le rappel sonore des bancs de poissons si votre canne à pêche est équipée."
L["OPT_SELECTSOUND_TIP"] = "Jouer le son choisi lorsque le rappel d'un haut fait incomplet est ajouté à l'infobulle."
L["OPT_SELECTSOUND_TIP2"] = "Les sons ne seront joués qu'une fois toutes les 15 secondes."
L["OPT_SHOWID"] = "Montrer les IDs des hauts faits"
L["OPT_SHOWPROGRESS"] = "Ajouter votre progression"
L["OPT_SHOWPROGRESS_OTHER"] = "Comparer la progression via les liens d'autres joueurs"
L["OPT_SHOWPROGRESS_OTHER_TIP"] = "Ajouter votre progression quand les informations du haut fait affiché sont celles d'un autre joueur."
L["OPT_SHOWPROGRESS_TIP"] = "Ajouter votre progression quand un haut fait est basé sur une quantité, comme \"Obtenir 10 montures\"."
L["OPT_TRACKERGREENCHECK"] = "Afficher une marque à côté de l'icône de haut fait accompli"
L["OPT_TRACKERGREENCHECK_TIP"] = "Place une marque verte à côté de l'icône dans le suivi quand le haut fait est accompli."
L["OPT_TURKEYLURKEYTIPS"] = "Dindoflingue utilisé ?"
L["OPT_TURKEYLURKEYTIPS_TIP"] = "Si le haut fait n'est pas terminé, ajoute une ligne à l'infobulle des joueurs pour indiquer si vous devez encore utiliser le Dindoflingue sur eux."
L["OPT_UI_REQUIREDFORMETATIP"] = "Infobulle pour les hauts faits qui en requièrent d'autres"
L["OPT_UI_REQUIREDFORMETATIP_TIP"] = "Lorsque le curseur passe sur un haut fait qui est requis pour en accomplir un autre, affiche le nom du méta-haut fait."
L["OPT_UI_SERIESTIP"] = "Infobulle pour les hauts faits qui font partie d'une série"
L["OPT_UI_SERIESTIP_TIP"] = "Lorsque le curseur passe sur un haut fait qui fait partie d'une série, affiche le reste de la série et sa situation dans celle-ci."
L["OPT_WELLREADTIPS"] = "Ajoute à l'infobulle d'un livre si vous l'avez lu"
L["OPT_WELLREADTIPS_TIP"] = "Si le haut fait est inachevé, ajoute une ligne dans l'infobulle des livres concernés pour vous signaler si vous avez besoin de les lire."
L["PROGRESS"] = "Progression"
L["REQUIREDFORMETATIP"] = "Requis pour :"
L["SERIESTIP"] = "Partie d'une série :"
L["SOUND_ALARM1"] = "Alarme 1"
L["SOUND_ALARM2"] = "Alarme 2"
L["SOUND_ALARM3"] = "Alarme 3"
L["SOUND_BELL_ALLIANCE"] = "Cloche - Alliance"
L["SOUND_BELL_AUCTION"] = "Cloches de l'HV"
L["SOUND_BELL_BOATARRIVED"] = "Cloches - Le bateau a accosté"
L["SOUND_BELL_HORDE"] = "Cloche - Horde"
L["SOUND_BELL_KARA"] = "Cloche de Karazhan"
L["SOUND_BELL_MELLOW"] = "Cloches douces"
L["SOUND_BELL_NIGHTELF"] = "Cloche - Elfe de la nuit"
L["SOUND_DING_AUCTION"] = "Carillon - HV"
L["SOUND_DRUMHIT"] = "Battement de tambour"
L["SOUND_ENTERQUEUE"] = "Entrer dans la file"
L["SOUND_GONG_TROLL"] = "Gong - Troll"
L["SOUND_HEARTHBIND"] = "Son - Pierre de foyer"
L["SOUND_MAP_PING"] = "Ping de la carte"
L["SOUND_SIMON_DING"] = "Simon - Carillon"
L["SOUND_SIMON_STARTGAME"] = "Simon - Nouveau Jeu"
L["SOUND_SIMON_STARTLEVEL"] = "Simon - Nouveau Niveau"
L["SOUND_YAR"] = "Yarrrr"
L["YOURPROGRESS"] = "Votre progression"


elseif (locale == "zhTW") then  -- Traditional Chinese
-- Thanks to user xyrho at wowinterface.com and laincat at curse.com for these translations:
L["ACH_ANGLER_COMPLETE"] = "已釣過"
L["ACH_ANGLER_INCOMPLETE"] = "未釣過"
L["ACH_BUNNYMAKER_COMPLETE"] = "已經使用春日鮮花"
L["ACH_BUNNYMAKER_INCOMPLETE"] = "需要使用春日鮮花"
L["ACH_CHECKYOURHEAD_COMPLETE"] = "已經使用增重的南瓜燈籠"
L["ACH_CHECKYOURHEAD_INCOMPLETE"] = "需要使用增重的南瓜燈籠"
L["ACH_CONSUME_COMPLETE"] = "已使用過"
L["ACH_CONSUME_INCOMPLETE"] = "需要使用"
L["ACH_CONSUME_INCOMPLETE_EXTRA"] = "未使用過"
L["ACH_FISTFULOFLOVE_COMPLETE"] = "已用過一把玫瑰花瓣"
L["ACH_FISTFULOFLOVE_INCOMPLETE"] = "需使用一把玫瑰花瓣"
L["ACH_LETITSNOW_COMPLETE"] = "已用過一捧雪花"
L["ACH_LETITSNOW_INCOMPLETE"] = "需使用一捧雪花"
L["ACH_LOVECRITTERS_COMPLETE"] = "已 /愛 過"
L["ACH_LOVECRITTERS_INCOMPLETE"] = "需要 /愛"
L["ACH_TURKEYLURKEY_COMPLETE"] = "已經使用過火雞獵槍"
L["ACH_TURKEYLURKEY_INCOMPLETE"] = "需要使用火雞獵槍"
L["ACH_WELLREAD_COMPLETE"] = "已讀過"
L["ACH_WELLREAD_INCOMPLETE"] = "未讀過"
L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = "啟用搜索標籤"
L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = "啟用建議標籤"
L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = "開啟觀察標籤"
L["COMPLETEDATE"] = "已完成 %1$d/%2$02d/%3$02d"
L["CRITTER"] = "小動物"
L["INCOMPLETE"] = "未完成"
L["KILL_COMPLETE"] = "已擊殺"
L["KILL_INCOMPLETE"] = "需要擊殺"
L["MSG_ACHNOTFOUND"] = "找不到該成就."
L["MSG_INVALIDID"] = "無效的ID."
L["MSG_NAMENOTFOUND"] = "找不到含有 \"|cffffffff%s|r\" 的成就."
L["MSG_NUMFOUNDLIST"] = "另外找到 %s 項成就:"
L["MSG_ONEFOUND"] = "找到 1 項成就: "
L["MSG_OPENINGTO"] = "開啟: "
L["OPT_ACHUNKNOWN"] = "<未知>"
L["OPT_ANGLERTIPS"] = "提示魚點是否釣過"
L["OPT_ANGLERTIPS_TIP"] = "增加魚點提示說明."
L["OPT_AUTOTRACKEXPLORE"] = "自動追蹤探索成就"
L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = "包括已完成的成就"
L["OPT_AUTOTRACKEXPLORE_TIP"] = "轉換地圖時自動追蹤該區域探索成就."
L["OPT_AUTOTRACKTIMED"] = "自動追蹤計時成就"
L["OPT_AUTOTRACKTIMED_TIP"] = "自動在計時成就開始時顯示時限。如果你的追蹤目標空間已達上限，則會關閉自動追蹤探索成就以空出位子。否則，它將不會進行追蹤。"
L["OPT_BUNNYMAKERTIPS"] = "新增任何你需要許用春日鮮花"
L["OPT_BUNNYMAKERTIPS_TIP"] = "如果這個成就尚未完成，在18級以上女性玩家的提示訊息中提示你是否需要對她使用春日鮮花。注意假如是大於你10級的敵對角色，會被假設為至少18級。"
L["OPT_CHECKYOURHEADTIPS"] = "提示是否需要使用增重的南瓜燈籠"
L["OPT_CHECKYOURHEADTIPS_TIP"] = "如果這個成就尚未完成，在玩家的提示訊息中提示你是否需要對他使用增重的南瓜燈籠。"
L["OPT_CONSUMEITEMTIPS"] = "提示食物是否吃過"
L["OPT_CONSUMEITEMTIPS_TIP"] = "增加食物提示說明"
L["OPT_CONSUMEITEMTIPS_TIP2"] = "如果你的等級不足以食用這個物品時，將不做提示"
L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = "完成後是否繼續提示"
L["OPT_CRITTERTIPS"] = "提示小動物是否愛過"
L["OPT_CRITTERTIPS_TIP"] = "在小動物的提示說明中註明."
L["OPT_DRAG_ACHFRAME"] = "可移動成就視窗"
L["OPT_DRAG_ACHTRACKER"] = "可移動成就追蹤框架"
L["OPT_DRAGGABLE"] = "使拖曳"
L["OPT_DRAGLOCK"] = "鎖定框架位置"
L["OPT_DRAGSAVE"] = "記住視窗位置"
L["OPT_FISTFULOFLOVETIPS"] = "提示是否需要使用一把玫瑰花瓣"
L["OPT_FISTFULOFLOVETIPS_TIP"] = "增加玩家提示說明."
L["OPT_KILLCREATURETIPS"] = "新增您是否需要殺死的怪物"
L["OPT_KILLCREATURETIPS_TIP"] = "新增一行動物提示(不包括小動物 )需要加以殺害，以符合標準的未完成的成就說明，表明您是否仍然需要殺死他們。"
-- L["OPT_KILLCREATURETIPS_TIP2"] = ""
L["OPT_LABEL_ACHTHREE"] = "\"%s,\" \"%s,\" 和 \"%s\""
L["OPT_LABEL_ACHTWO"] = "\"%s\" 和 \"%s\""
L["OPT_LABEL_DRAG"] = "移動視窗"
L["OPT_LABEL_MAINUI"] = "主要成就的UI修改"
L["OPT_LABEL_NEEDTOKILL"] = "擊殺怪物成就 (\"%s\",\"%s\",及其他)"
L["OPT_LABEL_SEASONALACHS"] = "世界事件成就"
L["OPT_LABEL_TOOLTIPS"] = "提示及連結設定"
L["OPT_LABEL_TRACKING"] = "追蹤設定"
L["OPT_LETITSNOWTIPS"] = "提示是否需要使用一捧雪花"
L["OPT_LETITSNOWTIPS_TIP"] = "如果成就尚未完成，在適當種族與職業組合玩家的提示訊息中提示你是否需要使用一捧雪花。"
L["OPTPANEL_REMINDERTOOLTIPS"] = "工具提示"
L["OPT_PESTCONTROLTIPS"] = "顯示是否需要擊殺害蟲的提示"
L["OPT_PESTCONTROLTIPS_TIP"] = "如果這個成就尚未完成，在那些害蟲的提示訊息中提示你是否需要擊殺牠們。"
L["OPT_SELECTSOUND"] = "選擇提示音效"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = "裝備魚竿時不提示釣魚成就"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = "裝備魚竿時不聲音提示釣魚成就"
L["OPT_SELECTSOUND_TIP"] = "在發現一個需要完成的成就提示時播出提示音效"
L["OPT_SELECTSOUND_TIP2"] = "每15秒這個聲音只會出現1次"
L["OPT_SHOWID"] = "顯示成就ID"
L["OPT_SHOWPROGRESS"] = "顯示進度"
L["OPT_SHOWPROGRESS_OTHER"] = "比較其他人的進度連結"
L["OPT_SHOWPROGRESS_OTHER_TIP"] = "在別人的成就訊息連結說明中顯示自己的進度."
L["OPT_SHOWPROGRESS_TIP"] = "在提示說明中顯示成就進度."
L["OPT_TRACKERGREENCHECK"] = "顯示完成圖示"
L["OPT_TRACKERGREENCHECK_TIP"] = "在追蹤項目旁顯示已完成圖示."
L["OPT_TURKEYLURKEYTIPS"] = "提示是否需要使用火雞獵槍"
L["OPT_TURKEYLURKEYTIPS_TIP"] = "如果成就尚未完成，在玩家的提示訊息中提示你是否需要對他使用火雞獵槍。"
L["OPT_UI_REQUIREDFORMETATIP"] = "顯示其他需要此成就來完成的提示"
L["OPT_UI_REQUIREDFORMETATIP_TIP"] = "當游標位於一個成就，需要獲得的另一項成就，顯示成就樹名稱。"
L["OPT_UI_SERIESTIP"] = "顯示系列成就的提示"
L["OPT_UI_SERIESTIP_TIP"] = "當滑鼠指向一個系列成就時，顯示系列中其他成就的名字和與目前成就的關係"
L["OPT_WELLREADTIPS"] = "提示書本是否閱讀過"
L["OPT_WELLREADTIPS_TIP"] = "增加書本提示說明."
L["PROGRESS"] = "進度"
L["REQUIREDFORMETATIP"] = "需要:"
L["SERIESTIP"] = "系列成就:"
L["SOUND_ALARM1"] = "鬧鈴聲 1"
L["SOUND_ALARM2"] = "鬧鈴聲 2"
L["SOUND_ALARM3"] = "鬧鈴聲 3"
L["SOUND_BELL_ALLIANCE"] = "提示音效 - 聯盟"
L["SOUND_BELL_AUCTION"] = "拍賣場音效"
L["SOUND_BELL_BOATARRIVED"] = "提示音效 - 船進港時"
L["SOUND_BELL_HORDE"] = "提示音效 - 部落"
L["SOUND_BELL_KARA"] = "卡拉贊音效"
L["SOUND_BELL_MELLOW"] = "柔和的鈴聲"
L["SOUND_BELL_NIGHTELF"] = "提示音效 - 夜精靈"
L["SOUND_DING_AUCTION"] = "拍賣場音效"
L["SOUND_DRUMHIT"] = "擊鼓聲"
L["SOUND_ENTERQUEUE"] = "進入佇列"
L["SOUND_GONG_TROLL"] = "銅鑼音效"
L["SOUND_HEARTHBIND"] = "爐石束縛"
L["SOUND_MAP_PING"] = "點擊地圖音效"
L["SOUND_SIMON_DING"] = "賽門音效"
L["SOUND_SIMON_STARTGAME"] = "賽門遊戲開始音效"
L["SOUND_SIMON_STARTLEVEL"] = "賽門等級開始音效"
L["SOUND_YAR"] = "Yarrrr音效"
L["YOURPROGRESS"] = "你的進度"


elseif (locale == "zhCN") then  -- Simplified Chinese
-- Thanks to user Miste(晨光麦) at wowinterface.com and yeah-chen and chrisccc at curse.com for these translations:
L["ACH_ANGLER_COMPLETE"] = "已钓过" -- Needs review
L["ACH_ANGLER_INCOMPLETE"] = "未钓过" -- Needs review
-- L["ACH_BUNNYMAKER_COMPLETE"] = ""
-- L["ACH_BUNNYMAKER_INCOMPLETE"] = ""
-- L["ACH_CHECKYOURHEAD_COMPLETE"] = ""
-- L["ACH_CHECKYOURHEAD_INCOMPLETE"] = ""
L["ACH_CONSUME_COMPLETE"] = "已使用过" -- Needs review
L["ACH_CONSUME_INCOMPLETE"] = "需要使用" -- Needs review
L["ACH_CONSUME_INCOMPLETE_EXTRA"] = "未使用过" -- Needs review
L["ACH_FISTFULOFLOVE_COMPLETE"] = "已用过一把玫瑰花瓣" -- Needs review
L["ACH_FISTFULOFLOVE_INCOMPLETE"] = "需使用一把玫瑰花瓣" -- Needs review
L["ACH_LETITSNOW_COMPLETE"] = "已用过一捧雪花" -- Needs review
L["ACH_LETITSNOW_INCOMPLETE"] = "需使用一捧雪花" -- Needs review
L["ACH_LOVECRITTERS_COMPLETE"] = "已 /爱 过" -- Needs review
L["ACH_LOVECRITTERS_INCOMPLETE"] = "需要 /爱" -- Needs review
-- L["ACH_TURKEYLURKEY_COMPLETE"] = ""
-- L["ACH_TURKEYLURKEY_INCOMPLETE"] = ""
L["ACH_WELLREAD_COMPLETE"] = "已读过" -- Needs review
L["ACH_WELLREAD_INCOMPLETE"] = "未读过" -- Needs review
L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = "打开搜索标签"
L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = "打开建议标签"
-- L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = ""
L["COMPLETEDATE"] = "已完成 %1$d/%2$02d/%3$02d" -- Needs review
L["CRITTER"] = "小动物" -- Needs review
L["INCOMPLETE"] = "未完成" -- Needs review
L["KILL_COMPLETE"] = "已经击杀" -- Needs review
L["KILL_INCOMPLETE"] = "需要击杀" -- Needs review
L["MSG_ACHNOTFOUND"] = "找不到该成就." -- Needs review
L["MSG_INVALIDID"] = "无效的ID." -- Needs review
L["MSG_NAMENOTFOUND"] = "找不到含有 \"|cffffffff%s|r\" 的成就." -- Needs review
L["MSG_NUMFOUNDLIST"] = "另外找到 %s 项成就:" -- Needs review
L["MSG_ONEFOUND"] = "找到 1 项成就: " -- Needs review
L["MSG_OPENINGTO"] = "开启: " -- Needs review
-- L["OPT_ACHUNKNOWN"] = ""
L["OPT_ANGLERTIPS"] = "提示鱼点是否钓过" -- Needs review
L["OPT_ANGLERTIPS_TIP"] = "增加鱼点提示说明." -- Needs review
L["OPT_AUTOTRACKEXPLORE"] = "自动追踪探索成就" -- Needs review
L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = "包括已完成的成就" -- Needs review
L["OPT_AUTOTRACKEXPLORE_TIP"] = "转换地图时自动追踪该区域探索成就." -- Needs review
-- L["OPT_AUTOTRACKTIMED"] = ""
-- L["OPT_AUTOTRACKTIMED_TIP"] = ""
-- L["OPT_BUNNYMAKERTIPS"] = ""
-- L["OPT_BUNNYMAKERTIPS_TIP"] = ""
-- L["OPT_CHECKYOURHEADTIPS"] = ""
-- L["OPT_CHECKYOURHEADTIPS_TIP"] = ""
L["OPT_CONSUMEITEMTIPS"] = "提示食物是否吃过" -- Needs review
L["OPT_CONSUMEITEMTIPS_TIP"] = "增加食物提示说明" -- Needs review
L["OPT_CONSUMEITEMTIPS_TIP2"] = "如果你的等级不足以食用这个物品时，将不做提示" -- Needs review
L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = "完成后是否继续提示" -- Needs review
L["OPT_CRITTERTIPS"] = "提示小动物是否爱過" -- Needs review
L["OPT_CRITTERTIPS_TIP"] = "在小动物的提示说明中注明." -- Needs review
L["OPT_DRAG_ACHFRAME"] = "可移动成就窗体" -- Needs review
L["OPT_DRAG_ACHTRACKER"] = "可移动成就追踪框体" -- Needs review
-- L["OPT_DRAGGABLE"] = ""
L["OPT_DRAGLOCK"] = "锁定框架位置" -- Needs review
L["OPT_DRAGSAVE"] = "记住窗体位置" -- Needs review
L["OPT_FISTFULOFLOVETIPS"] = "提示是否需要使用一把玫瑰花瓣" -- Needs review
L["OPT_FISTFULOFLOVETIPS_TIP"] = "增加玩家提示说明." -- Needs review
-- L["OPT_KILLCREATURETIPS"] = ""
-- L["OPT_KILLCREATURETIPS_TIP"] = ""
-- L["OPT_KILLCREATURETIPS_TIP2"] = ""
L["OPT_LABEL_ACHTHREE"] = "\"%s,\" \"%s,\" 和 \"%s\"" -- Needs review
L["OPT_LABEL_ACHTWO"] = "\"%s\" 和 \"%s\"" -- Needs review
L["OPT_LABEL_DRAG"] = "移动窗体" -- Needs review
L["OPT_LABEL_MAINUI"] = "主成就界面修正" -- Needs review
-- L["OPT_LABEL_NEEDTOKILL"] = ""
-- L["OPT_LABEL_SEASONALACHS"] = ""
L["OPT_LABEL_TOOLTIPS"] = "提示及连接设定" -- Needs review
L["OPT_LABEL_TRACKING"] = "追踪设定" -- Needs review
L["OPT_LETITSNOWTIPS"] = "提示是否需要使用一捧雪花" -- Needs review
L["OPT_LETITSNOWTIPS_TIP"] = "增加玩家提示说明." -- Needs review
-- L["OPTPANEL_REMINDERTOOLTIPS"] = ""
-- L["OPT_PESTCONTROLTIPS"] = ""
-- L["OPT_PESTCONTROLTIPS_TIP"] = ""
L["OPT_SELECTSOUND"] = "选择提示音" -- Needs review
L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = "装备鱼竿时不提示钓鱼成就" -- Needs review
L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = "装备鱼竿时不声音提示钓鱼成就" -- Needs review
L["OPT_SELECTSOUND_TIP"] = "在发现一个需要完成的成就提示时播出提示音" -- Needs review
L["OPT_SELECTSOUND_TIP2"] = "每15秒这个声音只会出现1次" -- Needs review
L["OPT_SHOWID"] = "显示成就ID" -- Needs review
L["OPT_SHOWPROGRESS"] = "显示进度" -- Needs review
L["OPT_SHOWPROGRESS_OTHER"] = "比较其他人的进度连接" -- Needs review
L["OPT_SHOWPROGRESS_OTHER_TIP"] = "在別人的成就讯息连接说明中显示自己的进度." -- Needs review
L["OPT_SHOWPROGRESS_TIP"] = "在提示说明中显示成就进度." -- Needs review
L["OPT_TRACKERGREENCHECK"] = "显示完成图示" -- Needs review
L["OPT_TRACKERGREENCHECK_TIP"] = "在追踪项目旁显示已完成图示." -- Needs review
-- L["OPT_TURKEYLURKEYTIPS"] = ""
-- L["OPT_TURKEYLURKEYTIPS_TIP"] = ""
-- L["OPT_UI_REQUIREDFORMETATIP"] = ""
-- L["OPT_UI_REQUIREDFORMETATIP_TIP"] = ""
L["OPT_UI_SERIESTIP"] = "提示系列成就" -- Needs review
L["OPT_UI_SERIESTIP_TIP"] = "当鼠标指向一个系列成就时，显示系列中其他成就的名字和与当前成就的关系" -- Needs review
L["OPT_WELLREADTIPS"] = "提示书本是否阅读过" -- Needs review
L["OPT_WELLREADTIPS_TIP"] = "增加书本提示说明." -- Needs review
L["PROGRESS"] = "进度" -- Needs review
L["REQUIREDFORMETATIP"] = "要求:" -- Needs review
L["SERIESTIP"] = "系列成就" -- Needs review
L["SOUND_ALARM1"] = "闹铃声 1" -- Needs review
L["SOUND_ALARM2"] = "闹铃声 2" -- Needs review
L["SOUND_ALARM3"] = "闹铃声 3" -- Needs review
L["SOUND_BELL_ALLIANCE"] = "联盟钟声" -- Needs review
L["SOUND_BELL_AUCTION"] = "拍卖行钟声" -- Needs review
L["SOUND_BELL_BOATARRIVED"] = "船只到港钟声" -- Needs review
L["SOUND_BELL_HORDE"] = "部落钟声" -- Needs review
L["SOUND_BELL_KARA"] = "卡拉赞的钟声" -- Needs review
L["SOUND_BELL_MELLOW"] = "圆润的钟声" -- Needs review
L["SOUND_BELL_NIGHTELF"] = "暗夜精灵钟声" -- Needs review
L["SOUND_DING_AUCTION"] = "拍卖行-叮" -- Needs review
L["SOUND_DRUMHIT"] = "鼓声" -- Needs review
L["SOUND_ENTERQUEUE"] = "进入战场列队声" -- Needs review
L["SOUND_GONG_TROLL"] = "巨魔锣声" -- Needs review
L["SOUND_HEARTHBIND"] = "炉石绑定声" -- Needs review
L["SOUND_MAP_PING"] = "小地图信号声" -- Needs review
L["SOUND_SIMON_DING"] = "叮(西蒙)" -- Needs review
L["SOUND_SIMON_STARTGAME"] = "游戏开始(西蒙)" -- Needs review
L["SOUND_SIMON_STARTLEVEL"] = "升级(西蒙)" -- Needs review
L["SOUND_YAR"] = "啊啊啊啊啊……" -- Needs review
L["YOURPROGRESS"] = "你的进度" -- Needs review


elseif (locale == "ruRU") then  -- Russian
-- Thanks to user Swix at wowinterface.com for these translations:
L["ACH_ANGLER_COMPLETE"] = "Уже выловлено"
L["ACH_ANGLER_INCOMPLETE"] = "Надо выловить"
L["ACH_BUNNYMAKER_COMPLETE"] = "Весенние цветы уже использованы"
L["ACH_BUNNYMAKER_INCOMPLETE"] = "Нужно использовать Весенние цветы"
L["ACH_CHECKYOURHEAD_COMPLETE"] = "Уже надевали тыкву на голову"
L["ACH_CHECKYOURHEAD_INCOMPLETE"] = "Нужно надеть тыкву на голову"
L["ACH_CONSUME_COMPLETE"] = "Уже попробовали"
L["ACH_CONSUME_INCOMPLETE"] = "Нужно попробовать"
L["ACH_CONSUME_INCOMPLETE_EXTRA"] = "Не попробовали"
L["ACH_FISTFULOFLOVE_COMPLETE"] = "Горсть розовых лепестков уже использовалась"
L["ACH_FISTFULOFLOVE_INCOMPLETE"] = "Воспользуйтесь горстью розовых лепестков"
L["ACH_LETITSNOW_COMPLETE"] = "Горсть снежинок уже использовалась"
L["ACH_LETITSNOW_INCOMPLETE"] = "Воспользуйтесь горстью снежинок"
L["ACH_LOVECRITTERS_COMPLETE"] = "Уже /любите"
L["ACH_LOVECRITTERS_INCOMPLETE"] = "Выразите /любовь"
L["ACH_TURKEYLURKEY_COMPLETE"] = "Уже расстрелян"
L["ACH_TURKEYLURKEY_INCOMPLETE"] = "Нужно расстрелять"
L["ACH_WELLREAD_COMPLETE"] = "Прочитано"
L["ACH_WELLREAD_INCOMPLETE"] = "Нужно прочитать"
L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = "Открыть вкладку поиска"
L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = "Открыть вкладку предложений"
L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = "Открывает закладку Наблюдений"
L["COMPLETEDATE"] = "Дата выполнения: %1$d/%2$02d/%3$02d"
L["CRITTER"] = "Существо"
L["INCOMPLETE"] = "Не выполнено"
L["KILL_COMPLETE"] = "Уже убит"
L["KILL_INCOMPLETE"] = "Надо убить"
L["MSG_ACHNOTFOUND"] = "Достижение не найдено"
L["MSG_INVALIDID"] = "Неверный ввод: достижения с таким ID не существует."
L["MSG_NAMENOTFOUND"] = "Достижений с названием, содержащим \"|cffffffff%s|r\", не существует."
L["MSG_NUMFOUNDLIST"] = "Ещё %s других достижений найдено:"
L["MSG_ONEFOUND"] = "Найдено ещё одно достижение: "
L["MSG_OPENINGTO"] = "Результат поиска: "
L["OPT_ACHUNKNOWN"] = "<Неизвестно>"
L["OPT_ANGLERTIPS"] = "Отмечать посещённые места поклёвки в подсказках"
L["OPT_ANGLERTIPS_TIP"] = "Если эти достижения не выполнены, во всплывающую подсказку к местам поклёвки будет добавляться строка, показывающая, ловили ли вы рыбу оттуда."
L["OPT_AUTOTRACKEXPLORE"] = "Автоматически следить за достижениями на исследование"
L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = "Включая выполненные достижения"
L["OPT_AUTOTRACKEXPLORE_TIP"] = "При входе в локацию, отслеживатель будет автоматически переключать соответствующее достижение."
L["OPT_AUTOTRACKTIMED"] = "Авто-слежение достижений с временем"
L["OPT_AUTOTRACKTIMED_TIP"] = "Автоматически начинать слежение достижений с критерием по времени при запуске таймера. Если вы уже отслеживаете максимальное допустимое число достижений, то она будет пытаться занять место достижения авто-исследования, в противном случае она не будет отслеживаться."
L["OPT_BUNNYMAKERTIPS"] = "Добавляет, нужно ли вам использовать Весенние цветы"
L["OPT_BUNNYMAKERTIPS_TIP"] = "Если достижение еще не выполненно, добавляется строка в подсказку игроков соответствующего пола и уровня, указавая, нужно ли вам использовать на них Весенние цветы."
L["OPT_CHECKYOURHEADTIPS"] = "Добавлять строку о необходимости использовать \\\"Утяжеленный фонарь из тыквы \\\""
L["OPT_CHECKYOURHEADTIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку игрокам добавится строка, уведомляющая о необходимости использовать на них Утяжеленный фонарь из тыквы."
L["OPT_CONSUMEITEMTIPS"] = "Добавлять строку о необходимости попробывать еду."
L["OPT_CONSUMEITEMTIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку еды добавится строка, уведомляющая о необходимости его попробывать."
L["OPT_CONSUMEITEMTIPS_TIP2"] = "Еда которая за низкого уровня для вас не будет вызывать звуковое напоминание."
L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = "Показывать, даже если достижение выполнено"
L["OPT_CRITTERTIPS"] = "Добавлять /любовный статус в подсказки существам"
L["OPT_CRITTERTIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку существам будет добавляться строка, показывающая /любите ли вы это существо или нет."
L["OPT_DRAG_ACHFRAME"] = "Основное окно достижений"
L["OPT_DRAG_ACHTRACKER"] = "Отслеживатель"
L["OPT_DRAGGABLE"] = "Позволить перетаскивать"
L["OPT_DRAGLOCK"] = "Закрепить позицию"
L["OPT_DRAGSAVE"] = "Запомнить позицию"
L["OPT_FISTFULOFLOVETIPS"] = "Добавляет, нужно ли вам использовать Горсть розовых лепестков"
L["OPT_FISTFULOFLOVETIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку игрокам, подходящих по расе/классу, будет добавлена строка, указывающая на необходимость использования горсти розовых лепестков."
L["OPT_KILLCREATURETIPS"] = "Добавлять строку о необходимости убить существо"
L["OPT_KILLCREATURETIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку существам (исключа спутников) добавится строка, уведомляющая о необходимости убить их."
-- L["OPT_KILLCREATURETIPS_TIP2"] = ""
L["OPT_LABEL_ACHTHREE"] = "\"%s,\" \"%s,\" и|n\"%s\""
L["OPT_LABEL_ACHTWO"] = "\"%s\" и \"%s\""
L["OPT_LABEL_DRAG"] = "Перемещаемые окна"
-- L["OPT_LABEL_MAINUI"] = ""
L["OPT_LABEL_NEEDTOKILL"] = "Достижения по убийству существ (\"%s,\" \"%s,\" и т.д.)"
L["OPT_LABEL_SEASONALACHS"] = "СЕЗОННЫЕ ДОСТИЖЕНИЯ"
L["OPT_LABEL_TOOLTIPS"] = "Ссылки и всплывающие окошки"
L["OPT_LABEL_TRACKING"] = "Отслеживание достижений"
L["OPT_LETITSNOWTIPS"] = "Добавляет, нужно ли вам использовать Горсть снежинок"
L["OPT_LETITSNOWTIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку игрокам будет добавляться строка, уведомляющая о необходимости использования горсти снежинок."
L["OPTPANEL_REMINDERTOOLTIPS"] = "Напоминающие подсказки"
L["OPT_PESTCONTROLTIPS"] = "Добавлять строку о необходимости убийства существа"
L["OPT_PESTCONTROLTIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку существам будет добавляться строка, уведомляющая о необходимости убить данное существо."
L["OPT_SELECTSOUND"] = "Проигрывать звук при незавершённом достижении"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = "Не уведомлять о лунках, если удочка в руках"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = "Не проигрывать звук над лунками, если удочка у вас в руках."
L["OPT_SELECTSOUND_TIP"] = "Проигрывать выбранный звуковой файл, если во всплывающее окошко была добавлена информация о незавершённом достижении."
L["OPT_SELECTSOUND_TIP2"] = "Звук будет воспроизводиться не чаще, чем раз в 15 секунд."
L["OPT_SHOWID"] = "Показывать ID достижений"
L["OPT_SHOWPROGRESS"] = "Добавлять ваш прогресс"
L["OPT_SHOWPROGRESS_OTHER"] = "Сравнивать прогресс в чужих ссылках"
L["OPT_SHOWPROGRESS_OTHER_TIP"] = "Добавлять ваш прогресс в информацию о достижениях других игроков."
L["OPT_SHOWPROGRESS_TIP"] = "Добавлять ваш прогресс в достижения, основанные на количественном критерии, например, \"Соберите 10 питомцев\"."
L["OPT_TRACKERGREENCHECK"] = "Показывать галку после иконки выполненного достижения"
L["OPT_TRACKERGREENCHECK_TIP"] = "После иконки выполненного достижения будет отображаться зелёная галка."
L["OPT_TURKEYLURKEYTIPS"] = "Добавлять строку о необходимости использовать ваш индейкомет"
L["OPT_TURKEYLURKEYTIPS_TIP"] = "Если это достижение не выполнено, во всплывающую подсказку игрокам добавится строка, уведомляющая о необходимости использовать ваш индейкомет на них."
L["OPT_UI_REQUIREDFORMETATIP"] = "Показывать достижения, необходимые для других"
L["OPT_UI_REQUIREDFORMETATIP_TIP"] = "Если вы наведёте мышку на достижение, которое необходимо для получения другого достижения, во всплывающем окошке будет отображено название этого мета-достижения."
L["OPT_UI_SERIESTIP"] = "Показывать достижения, являющиеся частью серии"
L["OPT_UI_SERIESTIP_TIP"] = "Если вы наведёте мышку на достижение, являющееся частью серии, во всплывающее окошко будут добавлены имена других достижений из этой серии."
L["OPT_WELLREADTIPS"] = "Отмечать в подсказке книги, прочитана ли она"
L["OPT_WELLREADTIPS_TIP"] = "Если эти достижения не выполнены, во всплывающую подсказку к книгам будет добавляться строка, показывающая, прочитан ли этот экземпляр"
L["PROGRESS"] = "Прогресс"
L["REQUIREDFORMETATIP"] = "Требуется для:"
L["SERIESTIP"] = "Часть серии:"
L["SOUND_ALARM1"] = "Alarm Clock 1"
L["SOUND_ALARM2"] = "Alarm Clock 2"
L["SOUND_ALARM3"] = "Alarm Clock 3"
L["SOUND_BELL_ALLIANCE"] = "Колокол - Альянс"
L["SOUND_BELL_AUCTION"] = "Колокол - Аукцион"
L["SOUND_BELL_BOATARRIVED"] = "Колокол - Прибытие коробля"
L["SOUND_BELL_HORDE"] = "Колокол - Орда"
L["SOUND_BELL_KARA"] = "Колокол - Каражан"
L["SOUND_BELL_MELLOW"] = "Колокол - Спокойный"
L["SOUND_BELL_NIGHTELF"] = "Колокол - Начной Эльф"
L["SOUND_DING_AUCTION"] = "Звон аукциона"
L["SOUND_DRUMHIT"] = "Барабаны"
L["SOUND_ENTERQUEUE"] = "Вход в очередь"
L["SOUND_GONG_TROLL"] = "Гонг - Троль"
L["SOUND_HEARTHBIND"] = "Привязка камня возвражения"
L["SOUND_MAP_PING"] = "Импульс на карте"
L["SOUND_SIMON_DING"] = "Саймон - звон"
L["SOUND_SIMON_STARTGAME"] = "Саймон - начало игры"
L["SOUND_SIMON_STARTLEVEL"] = "Саймон - начало уровня"
L["SOUND_YAR"] = "Ярррр"
L["YOURPROGRESS"] = "Ваш прогресс"


elseif (locale == "koKR") then  -- Korean
L["ACH_ANGLER_COMPLETE"] = "이미 낚시함"
L["ACH_ANGLER_INCOMPLETE"] = "낚시 필요"
L["ACH_BUNNYMAKER_COMPLETE"] = "봄꽃 사용한 적 있음"
L["ACH_BUNNYMAKER_INCOMPLETE"] = "봄꽃 사용 필요"
-- L["ACH_CHECKYOURHEAD_COMPLETE"] = ""
-- L["ACH_CHECKYOURHEAD_INCOMPLETE"] = ""
L["ACH_CONSUME_COMPLETE"] = "이미 먹음"
L["ACH_CONSUME_INCOMPLETE"] = "먹을 필요 있음"
L["ACH_CONSUME_INCOMPLETE_EXTRA"] = "먹은 적 없음"
L["ACH_FISTFULOFLOVE_COMPLETE"] = "붉은 꽃잎 한 줌 이미 사용함"
L["ACH_FISTFULOFLOVE_INCOMPLETE"] = "붉은 꽃잎 한 줌 사용 필요"
L["ACH_LETITSNOW_COMPLETE"] = "눈송이 한 줌 이미 사용함"
L["ACH_LETITSNOW_INCOMPLETE"] = "눈송이 한 줌 사용할 필요 있음"
L["ACH_LOVECRITTERS_COMPLETE"] = "/사랑 한 적 있음"
L["ACH_LOVECRITTERS_INCOMPLETE"] = "/사랑 한 적 없음"
-- L["ACH_TURKEYLURKEY_COMPLETE"] = ""
-- L["ACH_TURKEYLURKEY_INCOMPLETE"] = ""
L["ACH_WELLREAD_COMPLETE"] = "이미 읽음"
L["ACH_WELLREAD_INCOMPLETE"] = "읽지 않음"
L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = "검색 탭"
L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = "추천 탭"
L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = "추적 탭"
L["COMPLETEDATE"] = "업적 획득 - %3$02d/%02$d/%1$02d"
L["CRITTER"] = "동물"
L["INCOMPLETE"] = "업적 진행 중"
L["KILL_COMPLETE"] = "처치한 적 있음"
L["KILL_INCOMPLETE"] = "처치 필요"
L["MSG_ACHNOTFOUND"] = "업적을 찾을 수 없습니다."
L["MSG_INVALIDID"] = "올바르지 않은 값: 해당 ID의 업적이 존재하지 않습니다."
L["MSG_NAMENOTFOUND"] = "\"|cffffffff%s|r\"을 포함하는 업적을 찾을 수 없습니다."
L["MSG_NUMFOUNDLIST"] = "%s개의 다른 업적을 찾았습니다:"
L["MSG_ONEFOUND"] = "1개의 다른 업적을 찾았습니다: "
L["MSG_OPENINGTO"] = "열기: "
L["OPT_ACHUNKNOWN"] = "<무엇인가>"
L["OPT_ANGLERTIPS"] = "물고기 떼 낚시 표시"
L["OPT_ANGLERTIPS_TIP"] = "업적을 완료하지 않은 경우 해당 물고기 떼에 마우스를 가져가면 툴팁에 낚시가 필요한 지 표시해줍니다."
L["OPT_AUTOTRACKEXPLORE"] = "지역 이동시 탐험 업적을 자동으로 추적"
L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = "완료한 업적 포함"
L["OPT_AUTOTRACKEXPLORE_TIP"] = "특정 지역으로 이동했을 때 자동으로 관련된 탐험 업적을 추적합니다. 다른 지역 탐험을 추적중이면 추적을 바꾸지 않습니다."
L["OPT_AUTOTRACKTIMED"] = "시간제한 업적 자동 추적"
L["OPT_AUTOTRACKTIMED_TIP"] = "시간제한이 있는 업적의 타이머가 시작되면 자동으로 추적합니다. 수동으로 업적을 추적중이면 업적 추적을 전환하지 않습니다."
L["OPT_BUNNYMAKERTIPS"] = "봄꽃 사용 상태 표시"
L["OPT_BUNNYMAKERTIPS_TIP"] = "업적을 완료하지 않은 경우 적절한 성별과 레벨을 가진 플레이어의 툴팁에 봄꽃을 사용할 필요가 있는지 표시합니다. 자신과 레벨이 10 이상 차이나는 적 플레이어의 경우에는 레벨 18 이상으로 취급됩니다."
-- L["OPT_CHECKYOURHEADTIPS"] = ""
-- L["OPT_CHECKYOURHEADTIPS_TIP"] = ""
L["OPT_CONSUMEITEMTIPS"] = "툴팁에 음식 먹은 상태 표시"
L["OPT_CONSUMEITEMTIPS_TIP"] = "업적을 완료하지 않은 경우 음식 아이템에 마우스를 가져가면 툴팁에 음식을 먹을 필요가 있는지 알려줍니다."
L["OPT_CONSUMEITEMTIPS_TIP2"] = "요구 레벨이 높아 먹을 수 없는 음식은 소리로 알려주지 않습니다."
L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = "업적을 완료한 후에도 표시"
L["OPT_CRITTERTIPS"] = "/사랑 상태 표시"
L["OPT_CRITTERTIPS_TIP"] = "업적을 완료하지 않은 경우 동물에 마우스를 가져다 대면 툴팁에 \"/사랑\"이 필요한지 표시합니다."
L["OPT_DRAG_ACHFRAME"] = "기본 업적창"
L["OPT_DRAG_ACHTRACKER"] = "업적 추적창"
L["OPT_DRAGGABLE"] = "업적창 이동"
L["OPT_DRAGLOCK"] = "위치 잠금"
L["OPT_DRAGSAVE"] = "위치 저장"
L["OPT_FISTFULOFLOVETIPS"] = "붉은 꽃잎 한 줌 사용 표시"
L["OPT_FISTFULOFLOVETIPS_TIP"] = "업적을 완료하지 않은 경우 해당하는 종족/직업의 플레이어 툴팁에 붉은 꽃잎 한 줌을 사용할 필요가 있는지 표시합니다."
-- L["OPT_KILLCREATURETIPS"] = ""
-- L["OPT_KILLCREATURETIPS_TIP"] = ""
-- L["OPT_KILLCREATURETIPS_TIP2"] = ""
L["OPT_LABEL_ACHTHREE"] = "\"%s,\" \"%s,\" 및|n\"%s\""
L["OPT_LABEL_ACHTWO"] = "\"%s\"|1과;와; \"%s\""
L["OPT_LABEL_DRAG"] = "프레임 이동"
L["OPT_LABEL_MAINUI"] = "기본 업적창 툴팁 변경"
-- L["OPT_LABEL_NEEDTOKILL"] = ""
-- L["OPT_LABEL_SEASONALACHS"] = ""
L["OPT_LABEL_TOOLTIPS"] = "업적 툴팁과 링크"
L["OPT_LABEL_TRACKING"] = "업적 추적"
L["OPT_LETITSNOWTIPS"] = "눈송이 한 줌 사용 표시"
L["OPT_LETITSNOWTIPS_TIP"] = "업적을 완료하지 않은 경우 해당하는 종족/직업의 플레이어 툴팁에 눈송이 한 줌을 사용할 필요가 있는지 표시합니다."
-- L["OPTPANEL_REMINDERTOOLTIPS"] = ""
L["OPT_PESTCONTROLTIPS"] = "처치 상태 표시"
L["OPT_PESTCONTROLTIPS_TIP"] = "업적을 완료하지 않은 경우 해당 동물에 마우스를 가져다대면 툴팁에 처치가 필요한지 표시합니다."
L["OPT_SELECTSOUND"] = "완료하지 않은 업적 알림 소리"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = "낚시대 착용시 알림 제외"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = "낚시대를 착용중이면 물고기 떼에 마우스를 가져가도 알림 소리를 재생하지 않습니다."
L["OPT_SELECTSOUND_TIP"] = "완료되지 않은 업적이 발견되었을 때 선택한 소리를 재생합니다."
L["OPT_SELECTSOUND_TIP2"] = "15초에 한 번씩만 재생 됩니다."
L["OPT_SHOWID"] = "업적 ID 표시"
L["OPT_SHOWPROGRESS"] = "자신의 진행 상태 추가"
L["OPT_SHOWPROGRESS_OTHER"] = "다른 업적 링크와 비교"
L["OPT_SHOWPROGRESS_OTHER_TIP"] = "다른 사람의 업적 링크를 볼때 자신의 진행 상태를 추가합니다."
L["OPT_SHOWPROGRESS_TIP"] = "\"탈 것 10개 획득\"과 같은, 업적 달성이 수량 기준일 때 자신의 진행 상태를 추가합니다."
L["OPT_TRACKERGREENCHECK"] = "완료된 업적 아이콘 옆에 체크 표시"
L["OPT_TRACKERGREENCHECK_TIP"] = "추적창에서 완료된 업적은 아이콘 옆에 녹색 체크 표시를 해줍니다."
-- L["OPT_TURKEYLURKEYTIPS"] = ""
-- L["OPT_TURKEYLURKEYTIPS_TIP"] = ""
L["OPT_UI_REQUIREDFORMETATIP"] = "요구하는 관련 업적 표시"
L["OPT_UI_REQUIREDFORMETATIP_TIP"] = "업적 달성을 위해 다른 업적을 달성해야 하면 달성해야 할 해당 업적을 표시합니다."
L["OPT_UI_SERIESTIP"] = "업적 세트 표시"
L["OPT_UI_SERIESTIP_TIP"] = "업적이 특정 세트에 속하는 업적이면 세트에 속한 모든 업적을 추가로 표시합니다."
L["OPT_WELLREADTIPS"] = "독서 상태 표시"
L["OPT_WELLREADTIPS_TIP"] = "업적을 완료하지 않았으면 툴팁에 독서가 필요하다고 표시합니다."
L["PROGRESS"] = "진행 상태"
L["REQUIREDFORMETATIP"] = "아래 업적이 요구함:"
L["SERIESTIP"] = "업적 세트:"
L["SOUND_ALARM1"] = "알람 시계 1"
L["SOUND_ALARM2"] = "알람 시계 2"
L["SOUND_ALARM3"] = "알람 시계 3"
L["SOUND_BELL_ALLIANCE"] = "종소리 - 얼라이언스"
L["SOUND_BELL_AUCTION"] = "경매장 종료 종소리"
L["SOUND_BELL_BOATARRIVED"] = "종소리 - 배 도착"
L["SOUND_BELL_HORDE"] = "종소리 - 호드"
L["SOUND_BELL_KARA"] = "카라잔 종소리"
L["SOUND_BELL_MELLOW"] = "부드러운 종소리"
L["SOUND_BELL_NIGHTELF"] = "종소리 - 나이트 엘프"
L["SOUND_DING_AUCTION"] = "경매장 시작 종소리"
L["SOUND_DRUMHIT"] = "북소리"
L["SOUND_ENTERQUEUE"] = "전장 신청 소리"
L["SOUND_GONG_TROLL"] = "징소리 - 트롤"
L["SOUND_HEARTHBIND"] = "귀환석 지정 소리"
L["SOUND_MAP_PING"] = "미니맵 위치 알림 소리"
L["SOUND_SIMON_DING"] = "시몬 종소리"
L["SOUND_SIMON_STARTGAME"] = "시몬 게임 시작"
L["SOUND_SIMON_STARTLEVEL"] = "시몬 레벨 시작"
L["SOUND_YAR"] = "이야~~~르"
L["YOURPROGRESS"] = "자신의 진행 상태"


elseif (locale == "esES" or locale == "esMX") then  -- Spanish
-- Thanks to user PatoDaia at wowinterface.com for these translations:
L["ACH_ANGLER_COMPLETE"] = "Ya lo has pescado"
L["ACH_ANGLER_INCOMPLETE"] = "Necesitas pescarlo"
L["ACH_BUNNYMAKER_COMPLETE"] = "Ya has usado Flores primaverales"
L["ACH_BUNNYMAKER_INCOMPLETE"] = "Necesitas usar Flores primaverales"
L["ACH_CHECKYOURHEAD_COMPLETE"] = "Ya calabaceado."
L["ACH_CHECKYOURHEAD_INCOMPLETE"] = "Necesita una calabaza en la cabeza"
L["ACH_CONSUME_COMPLETE"] = "Ya lo has probado"
L["ACH_CONSUME_INCOMPLETE"] = "Necesitas probarlo"
L["ACH_CONSUME_INCOMPLETE_EXTRA"] = "Aún no lo has probado"
L["ACH_FISTFULOFLOVE_COMPLETE"] = "Ya has usado un Puñado de Pétalos de Rosa"
L["ACH_FISTFULOFLOVE_INCOMPLETE"] = "Necesitas usar un Puñado de Pétalos de Rosa"
L["ACH_LETITSNOW_COMPLETE"] = "Ya has usado un Puñado de Copos de Nieve"
L["ACH_LETITSNOW_INCOMPLETE"] = "Necesitas usar un Puñado de Copos de Nieve"
L["ACH_LOVECRITTERS_COMPLETE"] = "Ya la has /amado"
L["ACH_LOVECRITTERS_INCOMPLETE"] = "Necesita algo de /amor"
L["ACH_TURKEYLURKEY_COMPLETE"] = "Ya emplumado"
L["ACH_TURKEYLURKEY_INCOMPLETE"] = "Necesita unas plumas"
L["ACH_WELLREAD_COMPLETE"] = "Ya lo has leído"
L["ACH_WELLREAD_INCOMPLETE"] = "Necesitas leerlo"
L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = "Abrir pestaña de Búsqueda"
L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = "Abrir pestaña de Sugerencias"
L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = "Abrir pestaña de Seguimiento"
L["COMPLETEDATE"] = "Completado en %1$02d/%2$02d/%3$02d"
L["CRITTER"] = "Alimaña"
L["INCOMPLETE"] = "Incompleto"
L["KILL_COMPLETE"] = "Ya lo has matado"
L["KILL_INCOMPLETE"] = "Necesitas matarlo"
L["MSG_ACHNOTFOUND"] = "Logro no encontrado."
L["MSG_INVALIDID"] = "Entrada errónea: No hay ningún logro con esa ID."
L["MSG_NAMENOTFOUND"] = "No se ha encontrado ningún logro cuyo nombre contenga \"|cffffffff%s|r\"."
L["MSG_NUMFOUNDLIST"] = "%s logros adicionales encontrados:"
L["MSG_ONEFOUND"] = "1 logro adicional encontrado: "
L["MSG_OPENINGTO"] = "Abriendo a: "
L["OPT_ACHUNKNOWN"] = "<Desconocido>"
L["OPT_ANGLERTIPS"] = "Añadir si ya has pescado un banco de peces a su tooltip"
L["OPT_ANGLERTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los bancos de peces incluidos en el logro, para indicar que necesitas pescar en él."
L["OPT_AUTOTRACKEXPLORE"] = "Auto-seguir logros de exploración conforme viajas"
L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = "Incluir logros completados"
L["OPT_AUTOTRACKEXPLORE_TIP"] = "Sigue automáticamente el logro de exploración asociado a una zona cuando entras en ella. No cambia si actualmente se está siguiendo otro logro que no sea de exploración."
L["OPT_AUTOTRACKTIMED"] = "Auto-seguir logros temporizados."
L["OPT_AUTOTRACKTIMED_TIP"] = "Sigue automáticamente los logros por tiempo cuando el temporizador comienza. No cambia si actualmente se está siguiendo otro logro a menos que fuese seguido automáticamente por Overachiever."
L["OPT_BUNNYMAKERTIPS"] = "Añadir si aún necesitas usar Flores primaverales"
L["OPT_BUNNYMAKERTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los jugadores del nivel y raza apropiados para indicar que necesitas usar un Flores primaverales sobre él. Se asumirá que los jugadores enemigos que sean superiores a tí por 10 niveles o más serán al menos de nivel 18."
L["OPT_CHECKYOURHEADTIPS"] = "Añadir si aún necesitas usar una Calabaza iluminada pesada"
L["OPT_CHECKYOURHEADTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los jugadores para indicar que necesitas usar una Calabaza iluminada pesada sobre él."
L["OPT_CONSUMEITEMTIPS"] = "Añadir si aún necesitas ingerir un consumible a su tooltip"
L["OPT_CONSUMEITEMTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los consumibles incluidos en el logro, para indicar que necesitas comerlo o beberlo."
L["OPT_CONSUMEITEMTIPS_TIP2"] = "Los consumibles para los que no tienes suficiente nivel no activaran un sonido recordatorio."
L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = "Mostrar incluso si el logro ha sido completado"
L["OPT_CRITTERTIPS"] = "Añadir estado de /amor al tooltip de las alimañas"
L["OPT_CRITTERTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de las alimañas incluidas en el logro, para indicar que aún necesitas hacer /amor sobre ellas."
L["OPT_DRAG_ACHFRAME"] = "Ventana Principal del UI para Logros"
L["OPT_DRAG_ACHTRACKER"] = "Tracker de Logros"
L["OPT_DRAGGABLE"] = "Permitir moverlo."
L["OPT_DRAGLOCK"] = "Bloquear posición"
L["OPT_DRAGSAVE"] = "Recordar posición"
L["OPT_FISTFULOFLOVETIPS"] = "Añadir si aún necesitas usar un Puñado de Pétalos de Rosa"
L["OPT_FISTFULOFLOVETIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los jugadores con la combinación de clase/raza incluida en el logro, para indicar que necesitas usar un Puñado de Pétalos de Rosa sobre él."
L["OPT_KILLCREATURETIPS"] = "Añadir si necesitas matar una criatura a su tooltip"
L["OPT_KILLCREATURETIPS_TIP"] = "Añade una linea al tooltip de las criaturas (excluyendo alimañas) que necesitan ser matadas para cumplir los requisitos de un logro incompleto, para indicar que aún necesitas matarlas."
L["OPT_KILLCREATURETIPS_TIP2"] = "Nota: Al inicio (o cuando esta opción es activada), cada logro es escaneado para encontrar la ID de las criaturas afectadas. No todos los logros informan de esas IDs. Muchos lo hacen, pero los tooltips de las criaturas que son necesarias para los logros que no lo hacen no serán afectadas por esta opción."
L["OPT_LABEL_ACHTHREE"] = "\"%s,\" \"%s,\" y|n\"%s\""
L["OPT_LABEL_ACHTWO"] = "\"%s\" y \"%s\""
L["OPT_LABEL_DRAG"] = "Ventanas Arrastrables"
L["OPT_LABEL_MAINUI"] = "Modificiaciones del interface de Logros"
L["OPT_LABEL_NEEDTOKILL"] = "Logros de matar criaturas (\"%s,\" \"%s,\" etc.)"
L["OPT_LABEL_SEASONALACHS"] = "LOGROS DE TEMPORADA"
L["OPT_LABEL_TOOLTIPS"] = "Tooltips y Enlaces de Logros"
L["OPT_LABEL_TRACKING"] = "Seguimiento de Logros"
L["OPT_LETITSNOWTIPS"] = "Añadir si aún necesitas usar un Puñado de Copos de Nieve"
L["OPT_LETITSNOWTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los jugadores con la combinación de clase/raza incluida en el logro, para indicar que necesitas usar un Puñado de Copos de Nieve sobre él."
L["OPTPANEL_REMINDERTOOLTIPS"] = "Tooltips recordatorios"
L["OPT_PESTCONTROLTIPS"] = "Añadir si ya has eliminado una alimaña a su tooltip."
L["OPT_PESTCONTROLTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de las alimañas incluidas en el logro, para indicar que aún necesitas exterminarlas."
L["OPT_SELECTSOUND"] = "Sonido Recordatorio de Logro Incompleto"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = "Excluir recordatorio de pesca si esta equipada una caña"
L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = "No reproduce el sonido recordatorio de los bancos de peces si llevas equipada una caña de pescar."
L["OPT_SELECTSOUND_TIP"] = "Reproduce el sonido seleccionado cuando el recordatorio para un logro incompleto es añadido al tooltip."
L["OPT_SELECTSOUND_TIP2"] = "El sonido recordatorio sólo se reproducirá una vez cada 15 segundos."
L["OPT_SHOWID"] = "Mostrar las IDs de los logros"
L["OPT_SHOWPROGRESS"] = "Añadir tu progreso"
L["OPT_SHOWPROGRESS_OTHER"] = "Comparar progreso con los logros de otros jugadores"
L["OPT_SHOWPROGRESS_OTHER_TIP"] = "Añade tu progreso cuando se muestre la información de un logro para otro jugador."
L["OPT_SHOWPROGRESS_TIP"] = "Añade tu progreso cuando un logro esta basado en un criterio cuantitativo, como \"Obtener 10 monturas.\""
L["OPT_TRACKERGREENCHECK"] = "Mostrar una marca junto al icono de logro completado."
L["OPT_TRACKERGREENCHECK_TIP"] = "Muestra una marca verde junto al icono del tracker cuando el logro ha sido completado."
L["OPT_TURKEYLURKEYTIPS"] = "Añadir si aún necesitas usar una Pavopistola"
L["OPT_TURKEYLURKEYTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los jugadores para indicar que necesitas usar tu Pavopistola sobre él."
L["OPT_UI_REQUIREDFORMETATIP"] = "Tooltip en los logros requeridos por otros logros."
L["OPT_UI_REQUIREDFORMETATIP_TIP"] = "Cuando el cursor esta sobre un logro que es requerido para obtener otro logro, muestra el nombre del meta-logro."
L["OPT_UI_SERIESTIP"] = "Mostrar tooltip sobre logros que son parte de una serie"
L["OPT_UI_SERIESTIP_TIP"] = "Cuando el cursor esta sobre un logro que es parte de una serie, muestra los nombres de otros logros de la misma serie y su relación con ellos."
L["OPT_WELLREADTIPS"] = "Añadir si ya has leido un libro a su tooltip"
L["OPT_WELLREADTIPS_TIP"] = "Si este logro está incompleto, añade una línea al tooltip de los libros incluidos en el logro, para indicar que necesitas leerlos."
L["PROGRESS"] = "Progreso"
L["REQUIREDFORMETATIP"] = "Requerido para:"
L["SERIESTIP"] = "Parte de una serie:"
L["SOUND_ALARM1"] = "Alarma de Reloj 1"
L["SOUND_ALARM2"] = "Alarma de Reloj 2"
L["SOUND_ALARM3"] = "Alarma de Reloj 3"
L["SOUND_BELL_ALLIANCE"] = "Campana - Alianza"
L["SOUND_BELL_AUCTION"] = "Campana de Subasta"
L["SOUND_BELL_BOATARRIVED"] = "Campana - Llegada de Barco"
L["SOUND_BELL_HORDE"] = "Campana - Horda"
L["SOUND_BELL_KARA"] = "Campana Karazhan"
L["SOUND_BELL_MELLOW"] = "Campanilla"
L["SOUND_BELL_NIGHTELF"] = "Campana - Elfo de la Noche"
L["SOUND_DING_AUCTION"] = "Tintineo de Subasta"
L["SOUND_DRUMHIT"] = "Golpe de Tambor"
L["SOUND_ENTERQUEUE"] = "Esperar en la Fila"
L["SOUND_GONG_TROLL"] = "Gong - Troll"
L["SOUND_HEARTHBIND"] = "Enlazar Piedra de Hogar"
L["SOUND_MAP_PING"] = "Ping del Mapa"
L["SOUND_SIMON_DING"] = "Simon - Ding"
L["SOUND_SIMON_STARTGAME"] = "Simon - Inicio de Juego"
L["SOUND_SIMON_STARTLEVEL"] = "Simon - Inicio de Nivel"
L["SOUND_YAR"] = "Yarrrr"
L["YOURPROGRESS"] = "Tu progreso"


	if (locale == "esMX") then  -- Spanish (Mexican)
-- L["ACH_ANGLER_COMPLETE"] = ""
-- L["ACH_ANGLER_INCOMPLETE"] = ""
-- L["ACH_BUNNYMAKER_COMPLETE"] = ""
-- L["ACH_BUNNYMAKER_INCOMPLETE"] = ""
-- L["ACH_CHECKYOURHEAD_COMPLETE"] = ""
-- L["ACH_CHECKYOURHEAD_INCOMPLETE"] = ""
-- L["ACH_CONSUME_COMPLETE"] = ""
-- L["ACH_CONSUME_INCOMPLETE"] = ""
-- L["ACH_CONSUME_INCOMPLETE_EXTRA"] = ""
-- L["ACH_FISTFULOFLOVE_COMPLETE"] = ""
-- L["ACH_FISTFULOFLOVE_INCOMPLETE"] = ""
-- L["ACH_LETITSNOW_COMPLETE"] = ""
-- L["ACH_LETITSNOW_INCOMPLETE"] = ""
-- L["ACH_LOVECRITTERS_COMPLETE"] = ""
-- L["ACH_LOVECRITTERS_INCOMPLETE"] = ""
-- L["ACH_TURKEYLURKEY_COMPLETE"] = ""
-- L["ACH_TURKEYLURKEY_INCOMPLETE"] = ""
-- L["ACH_WELLREAD_COMPLETE"] = ""
-- L["ACH_WELLREAD_INCOMPLETE"] = ""
-- L["BINDING_NAME_OVERACHIEVER_TAB_SEARCH"] = ""
-- L["BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS"] = ""
-- L["BINDING_NAME_OVERACHIEVER_TAB_WATCH"] = ""
-- L["COMPLETEDATE"] = ""
-- L["CRITTER"] = ""
-- L["INCOMPLETE"] = ""
-- L["KILL_COMPLETE"] = ""
-- L["KILL_INCOMPLETE"] = ""
-- L["MSG_ACHNOTFOUND"] = ""
-- L["MSG_INVALIDID"] = ""
-- L["MSG_NAMENOTFOUND"] = ""
-- L["MSG_NUMFOUNDLIST"] = ""
-- L["MSG_ONEFOUND"] = ""
-- L["MSG_OPENINGTO"] = ""
-- L["OPT_ACHUNKNOWN"] = ""
-- L["OPT_ANGLERTIPS"] = ""
-- L["OPT_ANGLERTIPS_TIP"] = ""
-- L["OPT_AUTOTRACKEXPLORE"] = ""
-- L["OPT_AUTOTRACKEXPLORE_COMPLETED"] = ""
-- L["OPT_AUTOTRACKEXPLORE_TIP"] = ""
-- L["OPT_AUTOTRACKTIMED"] = ""
-- L["OPT_AUTOTRACKTIMED_TIP"] = ""
-- L["OPT_BUNNYMAKERTIPS"] = ""
-- L["OPT_BUNNYMAKERTIPS_TIP"] = ""
-- L["OPT_CHECKYOURHEADTIPS"] = ""
-- L["OPT_CHECKYOURHEADTIPS_TIP"] = ""
-- L["OPT_CONSUMEITEMTIPS"] = ""
-- L["OPT_CONSUMEITEMTIPS_TIP"] = ""
-- L["OPT_CONSUMEITEMTIPS_TIP2"] = ""
-- L["OPT_CONSUMEITEMTIPS_WHENCOMPLETE"] = ""
-- L["OPT_CRITTERTIPS"] = ""
-- L["OPT_CRITTERTIPS_TIP"] = ""
-- L["OPT_DRAG_ACHFRAME"] = ""
-- L["OPT_DRAG_ACHTRACKER"] = ""
-- L["OPT_DRAGGABLE"] = ""
-- L["OPT_DRAGLOCK"] = ""
-- L["OPT_DRAGSAVE"] = ""
-- L["OPT_FISTFULOFLOVETIPS"] = ""
-- L["OPT_FISTFULOFLOVETIPS_TIP"] = ""
-- L["OPT_KILLCREATURETIPS"] = ""
-- L["OPT_KILLCREATURETIPS_TIP"] = ""
-- L["OPT_KILLCREATURETIPS_TIP2"] = ""
-- L["OPT_LABEL_ACHTHREE"] = ""
-- L["OPT_LABEL_ACHTWO"] = ""
-- L["OPT_LABEL_DRAG"] = ""
-- L["OPT_LABEL_MAINUI"] = ""
-- L["OPT_LABEL_NEEDTOKILL"] = ""
-- L["OPT_LABEL_SEASONALACHS"] = ""
-- L["OPT_LABEL_TOOLTIPS"] = ""
-- L["OPT_LABEL_TRACKING"] = ""
-- L["OPT_LETITSNOWTIPS"] = ""
-- L["OPT_LETITSNOWTIPS_TIP"] = ""
-- L["OPTPANEL_REMINDERTOOLTIPS"] = ""
-- L["OPT_PESTCONTROLTIPS"] = ""
-- L["OPT_PESTCONTROLTIPS_TIP"] = ""
-- L["OPT_SELECTSOUND"] = ""
-- L["OPT_SELECTSOUND_ANGLERCHECKPOLE"] = ""
-- L["OPT_SELECTSOUND_ANGLERCHECKPOLE_TIP"] = ""
-- L["OPT_SELECTSOUND_TIP"] = ""
-- L["OPT_SELECTSOUND_TIP2"] = ""
-- L["OPT_SHOWID"] = ""
-- L["OPT_SHOWPROGRESS"] = ""
-- L["OPT_SHOWPROGRESS_OTHER"] = ""
-- L["OPT_SHOWPROGRESS_OTHER_TIP"] = ""
-- L["OPT_SHOWPROGRESS_TIP"] = ""
-- L["OPT_TRACKERGREENCHECK"] = ""
-- L["OPT_TRACKERGREENCHECK_TIP"] = ""
-- L["OPT_TURKEYLURKEYTIPS"] = ""
-- L["OPT_TURKEYLURKEYTIPS_TIP"] = ""
-- L["OPT_UI_REQUIREDFORMETATIP"] = ""
-- L["OPT_UI_REQUIREDFORMETATIP_TIP"] = ""
-- L["OPT_UI_SERIESTIP"] = ""
-- L["OPT_UI_SERIESTIP_TIP"] = ""
-- L["OPT_WELLREADTIPS"] = ""
-- L["OPT_WELLREADTIPS_TIP"] = ""
-- L["PROGRESS"] = ""
-- L["REQUIREDFORMETATIP"] = ""
-- L["SERIESTIP"] = ""
-- L["SOUND_ALARM1"] = ""
-- L["SOUND_ALARM2"] = ""
-- L["SOUND_ALARM3"] = ""
-- L["SOUND_BELL_ALLIANCE"] = ""
-- L["SOUND_BELL_AUCTION"] = ""
-- L["SOUND_BELL_BOATARRIVED"] = ""
-- L["SOUND_BELL_HORDE"] = ""
-- L["SOUND_BELL_KARA"] = ""
-- L["SOUND_BELL_MELLOW"] = ""
-- L["SOUND_BELL_NIGHTELF"] = ""
-- L["SOUND_DING_AUCTION"] = ""
-- L["SOUND_DRUMHIT"] = ""
-- L["SOUND_ENTERQUEUE"] = ""
-- L["SOUND_GONG_TROLL"] = ""
-- L["SOUND_HEARTHBIND"] = ""
-- L["SOUND_MAP_PING"] = ""
-- L["SOUND_SIMON_DING"] = ""
-- L["SOUND_SIMON_STARTGAME"] = ""
-- L["SOUND_SIMON_STARTLEVEL"] = ""
-- L["SOUND_YAR"] = ""
-- L["YOURPROGRESS"] = ""

	end

end

BINDING_HEADER_OVERACHIEVER = GetAddOnMetadata("Overachiever", "Title")
BINDING_NAME_OVERACHIEVER_TAB_SEARCH = L.BINDING_NAME_OVERACHIEVER_TAB_SEARCH;
BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS = L.BINDING_NAME_OVERACHIEVER_TAB_SUGGESTIONS;
BINDING_NAME_OVERACHIEVER_TAB_WATCH = L.BINDING_NAME_OVERACHIEVER_TAB_WATCH;
